/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.Numeric;
import com.heirloomcomputing.ecs.exec.Utilities;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.exec.comparableByteArray;

public abstract class bTreeNode {
    protected static final boolean debugMode = false;
    protected static final boolean sanityCheck = false;
    protected static final int MAX_PRIORITY = 500000;
    protected int height = 0;
    protected boolean isLeaf = true;
    protected int currentIndex = 0;
    protected boolean isRoot = false;
    protected boolean isDirty = false;
    protected int priority = 0;
    protected int referenceCount = 0;
    protected comparableByteArray MAX_KEY = null;
    protected byte[] maxKeyBytes = null;
    protected int maxKeyLength = 0;

    public static void debug(String text) {
        Utilities.debugOutput("bTreeNode: " + text);
    }

    public int checkSanityLT1k(int num) {
        if (num > 1024) {
            throw new RuntimeException("*** Heirloom Computing internal error bTreeNode: currentIndex should not be > numKeys in a node but is  " + num);
        }
        return num;
    }

    public int checkSanityLE70(int num) {
        if (num > 70) {
            throw new RuntimeException("*** Heirloom Computing internal error bTreeNode: currentIndex should not be > numKeys in a node but is  " + num);
        }
        return num;
    }

    public long checkSanityX1K(long num) {
        if (num % 1024L != 0L) {
            throw new RuntimeException("*** Heirloom Computing internal error bTreeNode: recordKeys must be on 1K boundaries  " + num);
        }
        return num;
    }

    public void checkSanityRT(byte[] record, int ... i) {
        int rt = (record[0] & 0xF0) >> 4;
        if ((i == null || i.length == 0) && (rt == 2 || rt != 0 && rt != 1 && rt != 3 && rt != 6) || i != null && i.length == 1 && i[0] != rt) {
            throw new RuntimeException("*** Heirloom Computing internal error bTreeNode: invalid record type  " + rt);
        }
    }

    public void setRoot(boolean flag) {
        this.isRoot = flag;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public void setDirty(boolean flag) {
        this.isDirty = flag;
    }

    public boolean isDirty() {
        return this.getDirty();
    }

    public boolean getDirty() {
        return this.isDirty;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int val) {
        this.priority = val;
    }

    public void increasePriority() {
        if (this.priority < 500000) {
            ++this.priority;
        }
    }

    public boolean decreasePriority() {
        if (this.priority == 0) {
            return true;
        }
        return --this.priority <= 0;
    }

    public int getReferenceCount() {
        return this.referenceCount;
    }

    public void setReferenceCount(int count) {
        this.referenceCount = count;
    }

    public void increaseReferenceCount() {
        ++this.referenceCount;
    }

    public boolean decreaseReferenceCount() {
        if (this.referenceCount == 0) {
            return true;
        }
        return --this.referenceCount <= 0;
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public void setCurrentIndex(int index) {
        this.currentIndex = index;
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public void setLeaf(boolean condition) {
        this.isLeaf = condition;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int h) {
        this.height = h;
    }

    public void increaseHeight() {
        ++this.height;
    }

    public void decreaseHeight() {
        if (this.height > 0) {
            --this.height;
        }
    }

    public void setTotalHeightOfTree(int h) {
    }

    public int getTotalHeightOfTree() {
        return -1;
    }

    public boolean isBelowMinimum() {
        return this.getNumberOfKeys() < this.getMinKeys();
    }

    public boolean isBelowOrAtMinimum() {
        return this.getNumberOfKeys() <= this.getMinKeys();
    }

    public boolean isAtMinimum() {
        return this.getNumberOfKeys() == this.getMinKeys();
    }

    public boolean getCanHoldKeys(int numKeys) {
        return this.getNumberOfKeys() + numKeys <= this.getMaxKeys();
    }

    public boolean moveFrom(bTreeNode sourceNode, int n) {
        if (!this.moveFromNode(sourceNode, n)) {
            return false;
        }
        this.currentIndex = this.getNumberOfKeys() - 1;
        return true;
    }

    public Object getChild() {
        return this.getChild(this.currentIndex);
    }

    public Object getChild(int childNumber) {
        if (childNumber > this.getNumberOfKeys()) {
            return null;
        }
        try {
            return this.convertBytesToChildObject(childNumber);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean getChild(byte[] bytes, int offset) {
        return this.getChild(this.currentIndex, bytes, offset);
    }

    public Object getData(int nodePointerPosition) {
        Object child = this.getChild(nodePointerPosition);
        if (child == null) {
            return null;
        }
        return this.getData(child);
    }

    public boolean getChild(int childNumber, byte[] bytes, int offset) {
        if (childNumber > this.getNumberOfKeys()) {
            return false;
        }
        try {
            byte[] buffer = this.getBuffer();
            if (buffer == null) {
                return false;
            }
            System.arraycopy(buffer, this.getChildByteOffset(childNumber), bytes, offset, this.getChildLength());
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean setChild(int childNumber, Object child) {
        try {
            return this.convertChildObjectToBytes(child, childNumber);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean setChild(int childNumber, byte[] child) {
        return this.setChild(childNumber, child, 0);
    }

    public boolean setChild(int childNumber, byte[] child, int childOffset) {
        try {
            System.arraycopy(child, childOffset, this.getBuffer(), this.getChildByteOffset(childNumber), this.getChildLength());
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean setChild(int childNumber, bTreeNode child) {
        if (child != null) {
            this.setChild(childNumber, child.getLocation());
        } else {
            this.setChild(childNumber, (Object)null);
        }
        return true;
    }

    public comparableByteArray getKey(int keyNumber) {
        try {
            byte[] buffer = this.getBuffer();
            if (keyNumber >= this.getNumberOfKeys() || buffer == null) {
                return null;
            }
            return this.convertBytesToKeyObject(buffer, this.getKeyByteOffset(keyNumber), this.getKeyLength());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean getKey(int keyNumber, byte[] bytes, int offset) {
        try {
            byte[] buffer = this.getBuffer();
            if (keyNumber >= this.getNumberOfKeys() || buffer == null) {
                return false;
            }
            this.getFullKeyFromBytes(buffer, this.getKeyByteOffset(keyNumber), bytes, offset);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean setKey(int keyNumber, comparableByteArray key) {
        try {
            return this.convertKeyObjectToBytes(key, this.getBuffer(), this.getKeyByteOffset(keyNumber));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean setKey(int keyNumber, byte[] key) {
        return this.setKey(keyNumber, key, 0, key.length);
    }

    public boolean setKey(int keyNumber, byte[] key, int keyOffset, int keyLen) {
        try {
            this.convertKeyObjectToBytes(key, keyOffset, keyLen, this.getBuffer(), this.getKeyByteOffset(keyNumber));
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static int compareBytes(byte[] bytes1, int index1, int len1, byte[] bytes2, int index2, int len2, boolean truncate) {
        int l1 = len1 > len2 ? index2 + len2 : index2 + len1;
        int j = index1;
        for (int i = index2; i < l1; ++i) {
            if (j >= bytes1.length || i >= bytes2.length) {
                return 0;
            }
            if (bytes1[j] == bytes2[i]) {
                ++j;
                continue;
            }
            return (bytes1[j] & 0xFF) - (bytes2[i] & 0xFF) > 0 ? 1 : -1;
        }
        if (!truncate && len1 != len2) {
            return len1 > len2 ? 1 : -1;
        }
        return 0;
    }

    private boolean binarySearchBytes(int left, int right, byte[] bytes, int offset, int len) {
        if (left == this.getNumberOfKeys()) {
            this.currentIndex = left;
            return false;
        }
        if (right < left) {
            this.currentIndex = left;
            return this.compareKeyBytes(this.getBuffer(), this.getKeyByteOffset(left), this.getKeyLength(), bytes, offset, len, true) == 0;
        }
        int middle = right + left >> 1;
        int compareResult = -this.compareKeyBytes(this.getBuffer(), this.getKeyByteOffset(middle), this.getKeyLength(), bytes, offset, len, true);
        if (compareResult == 0) {
            if (left == middle) {
                this.currentIndex = left;
                return true;
            }
            return this.binarySearchBytes(left, middle - 1, bytes, offset, len);
        }
        if (compareResult < 0) {
            return this.binarySearchBytes(left, middle - 1, bytes, offset, len);
        }
        return this.binarySearchBytes(middle + 1, right, bytes, offset, len);
    }

    public boolean findKey(byte[] keyBytes) {
        return this.findKey(keyBytes, 0, keyBytes.length);
    }

    public boolean findKey(byte[] keyBytes, int keyOffset, int keyLength) {
        if (this.getNumberOfKeys() > 0) {
            return this.binarySearchBytes(0, this.getNumberOfKeys() - 1, keyBytes, keyOffset, keyLength);
        }
        return false;
    }

    public boolean findKey(comparableByteArray key) {
        if (key == null) {
            return false;
        }
        byte[] b = key.toByteArray();
        if (b == null) {
            return false;
        }
        return this.findKey(b, 0, b.length);
    }

    public int compareKey(comparableByteArray key, int keyPosition, boolean truncate) {
        if (key == null) {
            return -1;
        }
        byte[] bytes = key.toByteArray();
        return this.compareKey(keyPosition, bytes, 0, bytes.length, truncate);
    }

    public int compareKey(int keyPosition, byte[] bytes, int offset, int len, boolean truncate) {
        return -this.compareKeyBytes(this.getBuffer(), this.getKeyByteOffset(keyPosition), this.getKeyLength(), bytes, 0, bytes.length, truncate);
    }

    public boolean addKey(comparableByteArray key, Object child) {
        return this.addKey(key, child, -1, 0L);
    }

    public boolean addKey(comparableByteArray key, Object child, int childIndex) {
        return this.addKey(key, child, childIndex, 0L);
    }

    public boolean addKey(comparableByteArray key, bTreeNode child) {
        return this.addKey(key, child, -1, 0L);
    }

    public boolean addKey(comparableByteArray key, bTreeNode child, int childIndex) {
        return this.addKey(key, child, childIndex, 0L);
    }

    public boolean addKey(comparableByteArray key, bTreeNode child, int childIndex, long duplicateCount) {
        if (child == null) {
            return this.addKey(key, (Object)child, childIndex, duplicateCount);
        }
        boolean returnCode = this.addKey(key, child.getLocation(), childIndex, duplicateCount);
        if (returnCode) {
            this.setLeaf(false);
        }
        return returnCode;
    }

    public boolean addKey(comparableByteArray key, Object child, int childIndex, long duplicateCount) {
        int numKeys = this.getNumberOfKeys();
        if (numKeys == this.getMaxKeys()) {
            return false;
        }
        try {
            byte[] keyBytes = key.toByteArray();
            byte[] childBytes = new byte[this.getChildLength()];
            boolean flag = this.convertChildObjectToBytes(child, childBytes, 0);
            if (!flag) {
                return false;
            }
            boolean result = this.addKey(keyBytes, 0, keyBytes.length, childBytes, 0, childIndex, duplicateCount);
            return result;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean addKey(bTreeNode sourceNode, int sourceIndex, int childIndex) {
        byte[] buffer = sourceNode.getBuffer();
        if (this.hasVariableKeyLengths()) {
            byte[] bytes = sourceNode.getFullKeyFromBytes(buffer, sourceNode.getKeyByteOffset(sourceIndex));
            return this.addKey(bytes, 0, sourceNode.getKeyLength(), buffer, sourceNode.getChildByteOffset(sourceIndex), childIndex, sourceNode.getDuplicateCount(sourceIndex));
        }
        return this.addKey(buffer, sourceNode.getKeyByteOffset(sourceIndex), sourceNode.getKeyLength(), buffer, sourceNode.getChildByteOffset(sourceIndex), childIndex, sourceNode.getDuplicateCount(sourceIndex));
    }

    public boolean addKey(byte[] keyBytes, int keyOffset, int keyLen, byte[] childBytes, int childOffset, int childIndex, long duplicateCount) {
        int numKeys = this.getNumberOfKeys();
        if (numKeys == this.getMaxKeys()) {
            return false;
        }
        int count = 0;
        if (childIndex < 0) {
            if (this.findKey(keyBytes, keyOffset, keyLen)) {
                int keyLength = this.getKeyLength();
                byte[] buffer = this.getBuffer();
                while (this.currentIndex < numKeys && this.compareKeyBytes(buffer, this.getKeyByteOffset(this.currentIndex), keyLength, keyBytes, keyOffset, keyLen, true) == 0) {
                    ++this.currentIndex;
                }
                count = this.currentIndex--;
            } else {
                count = this.currentIndex;
            }
        } else {
            count = this.currentIndex = childIndex;
        }
        boolean result = this.insertKeyIntoBufferAndIncreaseNumberOfKeys(count, keyBytes, keyOffset, keyLen, childBytes, childOffset, duplicateCount);
        return result;
    }

    public int findKeyWithChild(Object child) {
        return this.findKeyWithChild(child, 0);
    }

    public int findKeyWithChild(bTreeNode child) {
        if (child != null) {
            this.findKey(child.getKey(0));
            return this.findKeyWithChild(child.getLocation(), this.currentIndex);
        }
        return this.findKeyWithChild((Object)child);
    }

    public int findKeyWithChild(byte[] childBytes, int offset) {
        return this.findKeyWithChild(childBytes, offset, 0);
    }

    public int findKeyWithChild(byte[] childBytes, int offset, int startIndex) {
        int count;
        byte[] buffer = this.getBuffer();
        int numKeys = this.getNumberOfKeys();
        int childLength = this.getChildLength();
        for (count = startIndex; count <= numKeys && bTreeNode.compareBytes(buffer, this.getChildByteOffset(count), childLength, childBytes, offset, childLength, false) != 0; ++count) {
        }
        if (count <= numKeys) {
            return count;
        }
        return -1;
    }

    public int findKeyWithChild(Object child, int startIndex) {
        byte[] bytes = new byte[this.getChildLength()];
        if (!this.convertChildObjectToBytes(child, bytes, 0)) {
            return -1;
        }
        return this.findKeyWithChild(bytes, 0, startIndex);
    }

    public boolean deleteKey(int keyNumber) {
        if (keyNumber >= this.getNumberOfKeys()) {
            return false;
        }
        return this.deleteKeyFromBufferAndDecreaseNumberOfKeys(keyNumber);
    }

    public boolean deleteKey(byte[] keyBytes, int keyOffset, int keyLen) {
        if (!this.findKey(keyBytes, keyOffset, keyLen)) {
            return false;
        }
        return this.deleteKey(this.currentIndex);
    }

    public boolean deleteKey(comparableByteArray key) {
        if (!this.findKey(key)) {
            return false;
        }
        return this.deleteKey(this.currentIndex);
    }

    public void free() {
        this.setDirty(false);
        this.setPriority(0);
        this.setReferenceCount(0);
    }

    public String toString() {
        return "{ " + Integer.toHexString(this.hashCode()) + " }";
    }

    public static boolean isPrint(char c) {
        return c >= ' ' && c <= '~';
    }

    public String getHexDump() {
        String hex;
        int count;
        String lineSep = "\n";
        try {
            lineSep = System.getProperty("line.separator");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        byte[] buffer = this.getBuffer();
        if (buffer == null) {
            return null;
        }
        String text = "";
        int val = 0;
        String asciitext = "";
        for (count = 0; count < buffer.length; ++count) {
            val = buffer[count] & 0xFF;
            hex = "00";
            try {
                hex = Integer.toHexString(val);
            }
            catch (Exception exception) {
                // empty catch block
            }
            while (hex.length() < 2) {
                hex = "0" + hex;
            }
            String chex = "00";
            try {
                chex = Integer.toHexString(count);
            }
            catch (Exception exception) {
                // empty catch block
            }
            while (chex.length() < 5) {
                chex = "0" + chex;
            }
            char c = (char)val;
            if (count == 0) {
                asciitext = bTreeNode.isPrint(c) ? asciitext + "" + c : asciitext + ".";
            }
            if (count != 0) {
                if (count % 32 == 0) {
                    text = text + "  " + asciitext + lineSep;
                    asciitext = "";
                } else if (count % 4 == 0) {
                    text = text + " ";
                }
                asciitext = bTreeNode.isPrint(c) ? asciitext + "" + c : asciitext + ".";
            }
            if (count % 32 == 0) {
                text = text + chex.toUpperCase() + ": ";
            }
            text = text + hex.toUpperCase();
        }
        hex = "--";
        while (true) {
            if (count != 0) {
                if (count % 32 == 0) break;
                if (count % 4 == 0) {
                    text = text + " ";
                }
                asciitext = asciitext + "-";
            }
            text = text + hex.toUpperCase();
            ++count;
        }
        text = text + "  " + asciitext + lineSep;
        return text;
    }

    public boolean lastKeyIsMaxKey() {
        return false;
    }

    public comparableByteArray getMaxKey() {
        if (this.MAX_KEY != null) {
            return this.MAX_KEY;
        }
        if (this.getNumberOfKeys() == 0) {
            return null;
        }
        this.MAX_KEY = this.getKey(0).copy();
        if (this.MAX_KEY instanceof Numeric) {
            ((Variable)this.MAX_KEY).moveAll('\u00ff');
            int len = this.MAX_KEY.toByteArray().length;
            this.MAX_KEY = Variable.newVariableOfSize(len);
            this.maxKeyBytes = new byte[len];
            for (int i = 0; i < len; ++i) {
                this.maxKeyBytes[i] = -1;
            }
            this.maxKeyLength = len;
            this.MAX_KEY.fromByteArray(this.maxKeyBytes);
        } else if (this.MAX_KEY instanceof Variable) {
            ((Variable)this.MAX_KEY).moveAll('\u00ff');
            int len = this.MAX_KEY.toByteArray().length;
            this.maxKeyBytes = new byte[len];
            for (int i = 0; i < len; ++i) {
                this.maxKeyBytes[i] = -1;
            }
            this.maxKeyLength = len;
            this.MAX_KEY.fromByteArray(this.maxKeyBytes);
        }
        return this.MAX_KEY;
    }

    public byte[] getMaxKeyBytes() {
        return this.maxKeyBytes;
    }

    public int getMaxKeyLength() {
        return this.maxKeyLength;
    }

    protected void getFullKeyFromBytes(byte[] bytes, int offset, byte[] destBytes, int destOffset) {
        System.arraycopy(bytes, offset, destBytes, destOffset, this.getKeyLength());
    }

    protected byte[] getFullKeyFromBytes(byte[] bytes, int offset) {
        byte[] fullKeyBytes = new byte[this.getKeyLength()];
        this.getFullKeyFromBytes(bytes, offset, fullKeyBytes, 0);
        return fullKeyBytes;
    }

    protected boolean convertKeyObjectToBytes(byte[] keyBytes, int keyBytesOffset, int keyLen, byte[] bytes, int offset) {
        System.arraycopy(keyBytes, keyBytesOffset, bytes, offset, keyLen);
        return true;
    }

    protected int compareKeyBytes(byte[] bytes, int offset, int len, byte[] fullKeyBytes, int fullKeyOffset, int fullKeyLength, boolean truncate) {
        return bTreeNode.compareBytes(bytes, offset, len, fullKeyBytes, fullKeyOffset, fullKeyLength, truncate);
    }

    protected boolean hasVariableKeyLengths() {
        return false;
    }

    abstract byte[] getBuffer();

    abstract Object getLocation();

    abstract Object convertBytesToChildObject(int var1);

    abstract boolean convertChildObjectToBytes(Object var1, int var2);

    abstract boolean convertChildObjectToBytes(Object var1, byte[] var2, int var3);

    abstract comparableByteArray convertBytesToKeyObject(byte[] var1, int var2, int var3);

    abstract boolean convertKeyObjectToBytes(comparableByteArray var1, byte[] var2, int var3);

    abstract void setNode();

    abstract Object getData(Object var1);

    abstract bTreeNode getNode(Object var1, bTreeNode var2);

    abstract bTreeNode getNode(Object var1);

    abstract bTreeNode newInstance();

    abstract boolean insertKeyIntoBufferAndIncreaseNumberOfKeys(int var1, byte[] var2, int var3, int var4, byte[] var5, int var6, long var7);

    abstract boolean deleteKeyFromBufferAndDecreaseNumberOfKeys(int var1);

    abstract int getNumberOfKeys();

    abstract int getChildLength();

    abstract int getKeyLength();

    abstract int getKeyByteOffset(int var1);

    abstract int getChildByteOffset(int var1);

    abstract int getMaxKeys();

    abstract int getMinKeys();

    abstract long getDuplicateCount(int var1);

    abstract void setDuplicateCount(int var1, long var2);

    abstract boolean moveFromNode(bTreeNode var1, int var2);
}

