/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;

public class block {
    public static final boolean debugMode = false;
    public static final int minHeaderSize = 32;
    public static final int minDataSize = 480;
    protected long nextBlock = -1L;
    protected long lastBlock = -1L;
    protected int index = 0;
    protected int status = 0;
    protected long reserved = 0L;
    protected byte[] data = null;
    protected boolean isDirty = false;
    protected byte[] tempBlock = null;
    private static final int MAX_PRIORITY = 500000;
    protected long location = 0L;
    protected int referenceCount = 0;
    protected int priority = 0;

    public block() {
        this.data = new byte[480];
        this.tempBlock = new byte[512];
    }

    public block(int dataSize) {
        this.data = new byte[dataSize];
        this.tempBlock = new byte[dataSize + 32];
    }

    public void setNextBlock(long nextBlock) {
        this.nextBlock = nextBlock;
    }

    public long getNextBlock() {
        return this.nextBlock;
    }

    public void setLastBlock(long lastBlock) {
        this.lastBlock = lastBlock;
    }

    public long getLastBlock() {
        return this.lastBlock;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getStatus() {
        return this.status;
    }

    public void setBlock(byte[] tempBlock) {
        this.nextBlock = ((long)tempBlock[7] & 0xFFL) << 56 | ((long)tempBlock[6] & 0xFFL) << 48 | ((long)tempBlock[5] & 0xFFL) << 40 | ((long)tempBlock[4] & 0xFFL) << 32 | ((long)tempBlock[3] & 0xFFL) << 24 | ((long)tempBlock[2] & 0xFFL) << 16 | ((long)tempBlock[1] & 0xFFL) << 8 | (long)tempBlock[0] & 0xFFL;
        this.lastBlock = ((long)tempBlock[15] & 0xFFL) << 56 | ((long)tempBlock[14] & 0xFFL) << 48 | ((long)tempBlock[13] & 0xFFL) << 40 | ((long)tempBlock[12] & 0xFFL) << 32 | ((long)tempBlock[11] & 0xFFL) << 24 | ((long)tempBlock[10] & 0xFFL) << 16 | ((long)tempBlock[9] & 0xFFL) << 8 | (long)tempBlock[8] & 0xFFL;
        this.index = (tempBlock[19] & 0xFF) << 24 | (tempBlock[18] & 0xFF) << 16 | (tempBlock[17] & 0xFF) << 8 | tempBlock[16] & 0xFF;
        this.status = (tempBlock[23] & 0xFF) << 24 | (tempBlock[22] & 0xFF) << 16 | (tempBlock[21] & 0xFF) << 8 | tempBlock[20] & 0xFF;
        this.setData(tempBlock, 32, tempBlock.length - 32);
    }

    public byte[] getBlock() {
        this.tempBlock[0] = (byte)(this.nextBlock & 0xFFL);
        this.tempBlock[1] = (byte)(this.nextBlock >> 8 & 0xFFL);
        this.tempBlock[2] = (byte)(this.nextBlock >> 16 & 0xFFL);
        this.tempBlock[3] = (byte)(this.nextBlock >> 24 & 0xFFL);
        this.tempBlock[4] = (byte)(this.nextBlock >> 32 & 0xFFL);
        this.tempBlock[5] = (byte)(this.nextBlock >> 40 & 0xFFL);
        this.tempBlock[6] = (byte)(this.nextBlock >> 48 & 0xFFL);
        this.tempBlock[7] = (byte)(this.nextBlock >> 56 & 0xFFL);
        this.tempBlock[8] = (byte)(this.lastBlock & 0xFFL);
        this.tempBlock[9] = (byte)(this.lastBlock >> 8 & 0xFFL);
        this.tempBlock[10] = (byte)(this.lastBlock >> 16 & 0xFFL);
        this.tempBlock[11] = (byte)(this.lastBlock >> 24 & 0xFFL);
        this.tempBlock[12] = (byte)(this.lastBlock >> 32 & 0xFFL);
        this.tempBlock[13] = (byte)(this.lastBlock >> 40 & 0xFFL);
        this.tempBlock[14] = (byte)(this.lastBlock >> 48 & 0xFFL);
        this.tempBlock[15] = (byte)(this.lastBlock >> 56 & 0xFFL);
        this.tempBlock[16] = (byte)(this.index & 0xFF);
        this.tempBlock[17] = (byte)(this.index >> 8 & 0xFF);
        this.tempBlock[18] = (byte)(this.index >> 16 & 0xFF);
        this.tempBlock[19] = (byte)(this.index >> 24 & 0xFF);
        this.tempBlock[20] = (byte)(this.status & 0xFF);
        this.tempBlock[21] = (byte)(this.status >> 8 & 0xFF);
        this.tempBlock[22] = (byte)(this.status >> 16 & 0xFF);
        this.tempBlock[23] = (byte)(this.status >> 24 & 0xFF);
        System.arraycopy(this.data, 0, this.tempBlock, 32, this.data.length);
        return this.tempBlock;
    }

    public void setData(byte[] tempData, int offset, int length) {
        if (length + offset > tempData.length) {
            length = tempData.length - offset;
        }
        if (length > this.data.length) {
            length = this.data.length;
        }
        System.arraycopy(tempData, offset, this.data, 0, length);
    }

    public byte[] getData(int offset, int length) {
        if (this.data == null) {
            return null;
        }
        if (offset + length > this.data.length) {
            length = this.data.length - offset;
        }
        byte[] tempData = new byte[length];
        System.arraycopy(this.data, offset, tempData, 0, length);
        return tempData;
    }

    public byte[] getData() {
        return this.getData(0, this.data.length);
    }

    public int getDataLength() {
        if (this.data == null) {
            return 0;
        }
        return this.data.length;
    }

    public block copy() {
        block myBlock = new block(this.data.length);
        myBlock.nextBlock = this.nextBlock;
        myBlock.lastBlock = this.lastBlock;
        myBlock.index = this.index;
        myBlock.status = this.status;
        myBlock.reserved = this.reserved;
        System.arraycopy(this.data, 0, myBlock.data, 0, this.data.length);
        System.arraycopy(this.tempBlock, 0, myBlock.tempBlock, 0, this.tempBlock.length);
        myBlock.isDirty = this.isDirty;
        return myBlock;
    }

    public void clear() {
        this.nextBlock = -1L;
        this.lastBlock = -1L;
        this.index = 0;
        this.status = 0;
        int len = this.data.length;
        this.data = new byte[len];
        this.isDirty = false;
        this.priority = 0;
        this.location = 0L;
        this.referenceCount = 0;
    }

    public void clearDirty() {
        this.isDirty = false;
    }

    public void setDirty(boolean flag) {
        this.isDirty = flag;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public String toString() {
        String text = "";
        String lineSep = RuntimeEnvironment.getGlobalParameter("line.separator");
        text = text + "Dirty bit set? " + this.isDirty + lineSep;
        text = text + "Next block=" + this.nextBlock + lineSep;
        text = text + "Last block=" + this.lastBlock + lineSep;
        text = text + "Index=" + this.index + lineSep;
        text = text + "Status=" + this.status + lineSep;
        text = text + "Data address: " + this.data + lineSep;
        return text;
    }

    public void setLocation(long loc) {
        this.location = loc;
    }

    public long getLocation() {
        return this.location;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int val) {
        this.priority = val;
    }

    public void increasePriority() {
        if (this.priority < 500000) {
            ++this.priority;
        }
    }

    public boolean decreasePriority() {
        if (this.priority == 0) {
            return true;
        }
        return --this.priority <= 0;
    }

    public int getReferenceCount() {
        return this.referenceCount;
    }

    public void setReferenceCount(int count) {
        this.referenceCount = count;
    }

    public void increaseReferenceCount() {
        ++this.referenceCount;
    }

    public boolean decreaseReferenceCount() {
        if (this.referenceCount == 0) {
            return true;
        }
        return --this.referenceCount <= 0;
    }
}

