/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.LockRecord;
import com.heirloomcomputing.ecs.exec.LogSetup;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.block;
import com.heirloomcomputing.ecs.exec.smartFile;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class blockFile {
    protected static final boolean debugMode = false;
    private static final int CACHE_100_PERCENT_SIZE = 128;
    private static final int DEFAULT_PERCENT = 100;
    private BlockFileCache cache;
    public static final int minHeaderSize = 32;
    private byte majorVersion = 1;
    private byte minorVersion = 0;
    protected short headerSize = (short)32;
    private long numBlocks = 0L;
    private long numHoles = 0L;
    private int blockSize = 512;
    private long holeRoot = -1L;
    private byte[] headerBytes = new byte[32];
    private byte[] extendedHeader = null;
    private String filename = null;
    protected smartFile file = new smartFile();
    protected boolean isOpen = false;
    protected boolean readable = false;
    protected boolean writable = false;
    protected boolean extend = false;
    private boolean fileAlreadyExists = false;
    private int status = 0;
    protected LockRecord dataLockRecord = null;
    protected LockRecord idxLockRecord = null;
    protected boolean readOnlyCache = false;
    protected block rootBlock = null;

    public static void debug(String text) {
        System.out.println("blockFile: " + text);
    }

    protected void warning(String method, String text) {
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.warning("basicFile." + method + ": " + text);
        }
    }

    public blockFile() {
        this(0, 0, 512);
    }

    public blockFile(byte majorVersion, byte minorVersion, int blockSize) {
        this(majorVersion, minorVersion, blockSize, new block(blockSize - 32), 32);
    }

    public blockFile(byte majorVersion, byte minorVersion, int blockSize, block curBlock) {
        this(majorVersion, minorVersion, blockSize, curBlock, 32);
    }

    public blockFile(byte majorVersion, byte minorVersion, int blockSize, block curBlock, short headerSize) {
        this(majorVersion, minorVersion, blockSize, curBlock, headerSize, null);
    }

    public blockFile(byte majorVersion, byte minorVersion, int blockSize, block curBlock, short headerSize, byte[] extHeader) {
        this(majorVersion, minorVersion, blockSize, curBlock, headerSize, null, false);
    }

    public blockFile(byte majorVersion, byte minorVersion, int blockSize, block curBlock, short headerSize, byte[] extHeader, boolean readOnlyCaching) {
        this.readOnlyCache = readOnlyCaching;
        int percent = 100;
        int CACHE_SIZE = 128;
        String cacheVar = null;
        try {
            cacheVar = RuntimeEnvironment.getGlobalParameter("IDXCACHE");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cacheVar != null) {
            try {
                percent = Integer.valueOf(cacheVar);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            int bTree_100 = 32;
            int bTree_CACHE_SIZE = (int)((float)bTree_100 * ((float)percent / 100.0f));
            CACHE_SIZE = bTree_100 > 0 ? bTree_CACHE_SIZE * (128 / bTree_100) : 0;
        }
        this.cache = new BlockFileCache(CACHE_SIZE);
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.rootBlock = curBlock;
        this.setHeaderSize(headerSize);
        this.setBlockSize(blockSize);
        if (headerSize > 32) {
            this.extendedHeader = new byte[headerSize - 32];
            if (extHeader == null) {
                return;
            }
            int length = extHeader.length;
            if (length > this.extendedHeader.length) {
                length = this.extendedHeader.length;
            }
            System.arraycopy(extHeader, 0, this.extendedHeader, 0, length);
        }
    }

    public void setReadOnlyCaching(boolean flag) {
        this.readOnlyCache = flag;
    }

    public void setLockRecords(LockRecord dataLockRecord, LockRecord idxLockRecord) {
        this.dataLockRecord = dataLockRecord;
        this.idxLockRecord = idxLockRecord;
        dataLockRecord.setFileObject(this.file);
        idxLockRecord.setFileObject(this.file);
    }

    public int writeHeaderInformation() {
        int bSize;
        if (!this.isWritable()) {
            return 0;
        }
        this.headerBytes[0] = this.majorVersion;
        this.headerBytes[1] = this.minorVersion;
        blockFile.setBytesFromShort(this.headerBytes, 2, this.getHeaderSize());
        blockFile.setBytesFromLong(this.headerBytes, 4, this.getNumberOfBlocks());
        blockFile.setBytesFromLong(this.headerBytes, 12, this.getNumberOfHoles());
        blockFile.setBytesFromInt(this.headerBytes, 20, this.getBlockSize());
        blockFile.setBytesFromLong(this.headerBytes, 24, this.getHoleRoot());
        int returnCode = this.file.seek(0L);
        this.iostatus(returnCode);
        if (returnCode < 0) {
            return returnCode;
        }
        returnCode = this.file.write(this.headerBytes);
        this.iostatus(returnCode);
        if (returnCode < 0) {
            return returnCode;
        }
        int index = 32;
        if (this.extendedHeader != null) {
            returnCode = this.file.write(this.extendedHeader);
            this.iostatus(returnCode);
            if (returnCode < 0) {
                return returnCode;
            }
            index += this.extendedHeader.length;
        }
        if (this.majorVersion > 0 && index < (bSize = this.getBlockSize())) {
            byte[] nullbytes = new byte[bSize - index];
            returnCode = this.file.write(nullbytes);
            this.iostatus(returnCode);
            if (returnCode < 0) {
                return returnCode;
            }
        }
        return 0;
    }

    public int readHeaderInformation() {
        int returnCode = this.file.seek(0L);
        this.iostatus(returnCode);
        if (returnCode < 0) {
            return returnCode;
        }
        returnCode = this.file.read(this.headerBytes, 0, this.headerBytes.length, true);
        this.iostatus(returnCode);
        if (returnCode < 0) {
            return returnCode;
        }
        if (this.extendedHeader == null || this.extendedHeader.length != this.headerSize - 32) {
            this.extendedHeader = new byte[this.headerSize - 32];
        }
        returnCode = this.file.read(this.extendedHeader, 0, this.headerSize - 32, true);
        this.iostatus(returnCode);
        if (returnCode < 0) {
            this.warning("readHeaderInformation", "could not read file header");
            return returnCode;
        }
        this.majorVersion = this.headerBytes[0];
        this.minorVersion = this.headerBytes[1];
        this.setHeaderSize(blockFile.getShortFromBytes(this.headerBytes, 2));
        this.setNumberOfBlocks(blockFile.getLongFromBytes(this.headerBytes, 4));
        this.setNumberOfHoles(blockFile.getLongFromBytes(this.headerBytes, 12));
        int bSize = blockFile.getIntFromBytes(this.headerBytes, 20);
        this.setBlockSize(bSize);
        this.setHoleRoot(blockFile.getLongFromBytes(this.headerBytes, 24));
        return 0;
    }

    public short getHeaderSize() {
        return this.headerSize;
    }

    private void setHeaderSize(short headerSize) {
        if (headerSize < 32) {
            headerSize = (short)32;
        }
        this.headerSize = headerSize;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    private void setBlockSize(int blockSize) {
        int min = 512;
        if (blockSize < min) {
            blockSize = min;
        }
        this.blockSize = blockSize;
    }

    public long getNumberOfBlocks() {
        return this.numBlocks;
    }

    private void setNumberOfBlocks(long numBlocks) {
        this.numBlocks = numBlocks;
    }

    public long getNumberOfHoles() {
        return this.numHoles;
    }

    private void setNumberOfHoles(long numHoles) {
        this.numHoles = numHoles;
    }

    public long getHoleRoot() {
        return this.holeRoot;
    }

    private void setHoleRoot(long holeRoot) {
        this.holeRoot = holeRoot;
    }

    private int updateHoleInfo(long holeRoot, long numBlocks, long numHoles) {
        this.setHoleRoot(holeRoot);
        this.setNumberOfBlocks(numBlocks);
        this.setNumberOfHoles(numHoles);
        return 0;
    }

    public byte[] getExtendedHeader() {
        return this.extendedHeader;
    }

    public void setExtendedHeader(byte[] extHeader) {
        if (this.extendedHeader == null) {
            this.extendedHeader = extHeader;
            return;
        }
        int length = extHeader.length;
        if (length > this.headerSize - 32) {
            length = this.headerSize - 32;
        }
        if (this.extendedHeader.length != length) {
            System.arraycopy(extHeader, 0, this.extendedHeader, 0, length);
        } else {
            this.extendedHeader = extHeader;
        }
    }

    public int updateHeaderInformation() {
        if (!this.isWritable()) {
            return 0;
        }
        int returnCode = this.writeHeaderInformation();
        this.iostatus(returnCode);
        return returnCode;
    }

    public long getCurrentBlockNumber() {
        if (this.blockSize == 0) {
            return -1L;
        }
        long index = this.file.getFilePointer();
        long currentBlockNum = index - (long)this.headerSize;
        if (this.majorVersion > 0) {
            currentBlockNum = index - (long)this.blockSize;
        }
        if (currentBlockNum % (long)this.blockSize != 0L) {
            return -1L;
        }
        return currentBlockNum / (long)this.blockSize;
    }

    boolean deleteFile() {
        String name = this.filename;
        if (name == null) {
            return false;
        }
        File f = new File(name);
        boolean flag = false;
        try {
            flag = f.exists() ? f.delete() : true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return flag;
    }

    public void setFilename(String filename) {
        this.filename = filename;
        if (this.file == null) {
            this.file = new smartFile();
        }
        this.file.setFilename(filename);
    }

    public boolean isNewFile() {
        return !this.fileAlreadyExists;
    }

    public int open(int mode) {
        byte[] tempByte = new byte[1];
        this.iostatus(0);
        this.readable = (mode & 1) != 0;
        this.writable = (mode & 2) != 0;
        if ((mode & 4) != 0) {
            this.writable = true;
            this.extend = true;
        } else {
            this.extend = false;
        }
        int openReturnCode = this.file.open(mode);
        this.iostatus(openReturnCode);
        if (openReturnCode > -10) {
            if (this.dataLockRecord != null) {
                this.dataLockRecord.open(this.filename, mode & 0x16000);
            }
            if (this.idxLockRecord != null) {
                this.idxLockRecord.open(this.filename + ".idx", mode & 0x16000 | 0x10000);
            }
            boolean bl = this.fileAlreadyExists = !this.file.isNewFile();
            if (this.fileAlreadyExists) {
                int returnCode = this.file.seek(0);
                this.iostatus(returnCode);
                if (returnCode < 0) {
                    try {
                        this.file.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (this.dataLockRecord != null) {
                        this.dataLockRecord.close();
                    }
                    if (this.idxLockRecord != null) {
                        this.idxLockRecord.close();
                    }
                    return returnCode;
                }
                returnCode = this.file.read(tempByte, 0, 1, true);
                this.iostatus(returnCode);
                if (returnCode < 0) {
                    try {
                        this.file.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (this.dataLockRecord != null) {
                        this.dataLockRecord.close();
                    }
                    if (this.idxLockRecord != null) {
                        this.idxLockRecord.close();
                    }
                    return returnCode;
                }
                byte fileMajorVersion = tempByte[0];
                if (fileMajorVersion > this.majorVersion) {
                    try {
                        this.file.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (this.dataLockRecord != null) {
                        this.dataLockRecord.close();
                    }
                    if (this.idxLockRecord != null) {
                        this.idxLockRecord.close();
                    }
                    this.warning("open", "incorrect version in file header " + fileMajorVersion + " expected version less than " + this.majorVersion);
                    returnCode = -92;
                    this.iostatus(-92);
                    return returnCode;
                }
                returnCode = this.file.read(tempByte, 0, 1, true);
                this.iostatus(returnCode);
                if (returnCode < 0) {
                    try {
                        this.file.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (this.dataLockRecord != null) {
                        this.dataLockRecord.close();
                    }
                    if (this.idxLockRecord != null) {
                        this.idxLockRecord.close();
                    }
                    return returnCode;
                }
                if (fileMajorVersion == this.majorVersion && tempByte[0] > this.minorVersion) {
                    try {
                        this.file.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (this.dataLockRecord != null) {
                        this.dataLockRecord.close();
                    }
                    if (this.idxLockRecord != null) {
                        this.idxLockRecord.close();
                    }
                    this.warning("open", "incorrect minor version in file header " + tempByte[0] + " expected minor version less than " + this.minorVersion);
                    returnCode = -92;
                    this.iostatus(-92);
                    return returnCode;
                }
                returnCode = this.readHeaderInformation();
                this.iostatus(returnCode);
                if (returnCode < 0) {
                    try {
                        this.file.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (this.dataLockRecord != null) {
                        this.dataLockRecord.close();
                    }
                    if (this.idxLockRecord != null) {
                        this.idxLockRecord.close();
                    }
                    return returnCode;
                }
            } else {
                if (!this.isWritable()) {
                    try {
                        this.file.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (this.dataLockRecord != null) {
                        this.dataLockRecord.close();
                    }
                    if (this.idxLockRecord != null) {
                        this.idxLockRecord.close();
                    }
                    return openReturnCode;
                }
                int returnCode = this.writeHeaderInformation();
                this.iostatus(returnCode);
                if (returnCode < 0) {
                    try {
                        this.file.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (this.dataLockRecord != null) {
                        this.dataLockRecord.close();
                    }
                    if (this.idxLockRecord != null) {
                        this.idxLockRecord.close();
                    }
                    return returnCode;
                }
            }
            this.isOpen = true;
        }
        return openReturnCode;
    }

    public int close(int mode) {
        this.iostatus(0);
        this.isOpen = false;
        int returnCode = this.file.close(mode);
        this.iostatus(returnCode);
        this.fileAlreadyExists = false;
        if (this.dataLockRecord != null) {
            this.dataLockRecord.close();
        }
        if (this.idxLockRecord != null) {
            this.idxLockRecord.close();
        }
        return returnCode;
    }

    public int close() {
        return this.close(0);
    }

    public int seek(long blockNum) {
        long index = (long)this.headerSize + blockNum * (long)this.blockSize;
        if (this.majorVersion > 0) {
            index = (long)this.blockSize + blockNum * (long)this.blockSize;
        }
        this.iostatus(0);
        if (index < 0L || blockNum > this.numBlocks + this.numHoles) {
            int returnCode = -90;
            this.iostatus(-90);
            this.warning("seek", "could not position the file");
            return returnCode;
        }
        int returnCode = this.file.seek(index);
        this.iostatus(returnCode);
        if (returnCode < 0) {
            return returnCode;
        }
        return 0;
    }

    public int read(block currentBlock) {
        this.iostatus(0);
        long loc = currentBlock.getLocation();
        if (this.isBlockAtEndOfFile(loc)) {
            int returnCode = -10;
            this.iostatus(-10);
            return returnCode;
        }
        int returnCode = this.seek(loc);
        this.iostatus(returnCode);
        if (returnCode != 0) {
            return returnCode;
        }
        byte[] bytes = new byte[this.blockSize];
        returnCode = this.file.read(bytes, 0, this.blockSize, true);
        this.iostatus(returnCode);
        if (returnCode < 0) {
            return returnCode;
        }
        currentBlock.setBlock(bytes);
        return returnCode;
    }

    public int write(block currentBlock) {
        this.iostatus(0);
        if (!this.isWritable()) {
            int returnCode = -48;
            this.iostatus(-48);
            this.warning("write", "operation not on file open for output");
            return returnCode;
        }
        byte[] bytes = currentBlock.getBlock();
        if (bytes.length != this.blockSize) {
            int returnCode = -30;
            this.iostatus(-30);
            return returnCode;
        }
        long loc = currentBlock.getLocation();
        int returnCode = this.seek(loc);
        this.iostatus(returnCode);
        if (returnCode < 0) {
            return returnCode;
        }
        returnCode = this.file.write(bytes);
        this.iostatus(returnCode);
        return returnCode;
    }

    public block allocate() {
        block currentBlock;
        this.iostatus(0);
        if (!this.isWritable()) {
            int returnCode = -48;
            this.iostatus(-48);
            this.warning("delete", "operation not on file open for output");
            return null;
        }
        if (this.holeRoot >= 0L) {
            currentBlock = this.rootBlock.copy();
            currentBlock.setLocation(this.holeRoot);
            long tempLocation = this.holeRoot;
            int returnCode = this.read(currentBlock);
            if (returnCode < 0) {
                return null;
            }
            long nextBlock = currentBlock.getNextBlock();
            currentBlock.clear();
            currentBlock.setLocation(tempLocation);
            returnCode = this.updateHoleInfo(nextBlock, this.numBlocks + 1L, this.numHoles - 1L);
            if (returnCode < 0) {
                return null;
            }
        } else {
            currentBlock = this.rootBlock.copy();
            currentBlock.clear();
            currentBlock.setLocation(this.numBlocks + this.numHoles);
            int returnCode = this.write(currentBlock);
            this.iostatus(returnCode);
            if (returnCode < 0) {
                return null;
            }
            this.setNumberOfBlocks(this.numBlocks + 1L);
        }
        return currentBlock;
    }

    public int delete(block currentBlock) {
        this.iostatus(0);
        if (!this.isWritable()) {
            int returnCode = -48;
            this.iostatus(-48);
            this.warning("delete", "operation not on file open for output");
            return returnCode;
        }
        if (this.numBlocks <= 0L) {
            int returnCode = -90;
            this.iostatus(-90);
            this.warning("delete", "could not position the file");
            return returnCode;
        }
        long loc = currentBlock.getLocation();
        if (this.isBlockAtEndOfFile(loc)) {
            int returnCode = -90;
            this.iostatus(-90);
            this.warning("delete", "could not position the file");
            return returnCode;
        }
        currentBlock.clear();
        currentBlock.setNextBlock(this.holeRoot);
        currentBlock.setLocation(loc);
        int returnCode = this.write(currentBlock);
        if (returnCode < 0) {
            return returnCode;
        }
        returnCode = this.updateHoleInfo(loc, this.numBlocks - 1L, this.numHoles + 1L);
        if (returnCode < 0) {
            return returnCode;
        }
        return 0;
    }

    public boolean fileIsOpen() {
        return this.isOpen;
    }

    public boolean isInput() {
        return this.readable && !this.writable;
    }

    public boolean isOutput() {
        return this.writable && !this.readable;
    }

    public boolean isIO() {
        return this.readable && this.writable;
    }

    public boolean isExtend() {
        return this.extend;
    }

    public boolean isReadable() {
        return this.readable;
    }

    public boolean isWritable() {
        return this.writable;
    }

    public void flushCache() {
        this.cache.flush();
        if (this.file != null) {
            this.file.flush();
        }
    }

    public void reset() {
        this.readHeaderInformation();
    }

    public boolean isBlockAtEndOfFile(long blockNum) {
        return blockNum == this.numHoles + this.numBlocks;
    }

    public void iostatus(int status) {
        this.status = status;
    }

    public int priorError() {
        return this.status;
    }

    protected static final byte[] getBytesFromShort(short value) {
        byte[] bytes = new byte[2];
        blockFile.setBytesFromShort(bytes, 0, value);
        return bytes;
    }

    protected static final void setBytesFromShort(byte[] bytes, int offset, short value) {
        bytes[offset + 1] = (byte)(value >> 8 & 0xFF);
        bytes[offset] = (byte)(value & 0xFF);
    }

    protected static final short getShortFromBytes(byte[] bytes, int offset) {
        return (short)(((short)bytes[offset + 1] & 0xFF) << 8 | (short)bytes[offset] & 0xFF);
    }

    protected static final byte[] getBytesFromInt(int value) {
        byte[] bytes = new byte[4];
        blockFile.setBytesFromInt(bytes, 0, value);
        return bytes;
    }

    protected static final void setBytesFromInt(byte[] bytes, int offset, int value) {
        bytes[offset + 3] = (byte)(value >> 24 & 0xFF);
        bytes[offset + 2] = (byte)(value >> 16 & 0xFF);
        bytes[offset + 1] = (byte)(value >> 8 & 0xFF);
        bytes[offset] = (byte)(value & 0xFF);
    }

    protected static final int getIntFromBytes(byte[] bytes, int offset) {
        return (bytes[offset + 3] & 0xFF) << 24 | (bytes[offset + 2] & 0xFF) << 16 | (bytes[offset + 1] & 0xFF) << 8 | bytes[offset] & 0xFF;
    }

    protected static final byte[] getBytesFromLong(long value) {
        byte[] bytes = new byte[8];
        blockFile.setBytesFromLong(bytes, 0, value);
        return bytes;
    }

    protected static final void setBytesFromLong(byte[] bytes, int offset, long value) {
        bytes[offset + 7] = (byte)(value >> 56 & 0xFFL);
        bytes[offset + 6] = (byte)(value >> 48 & 0xFFL);
        bytes[offset + 5] = (byte)(value >> 40 & 0xFFL);
        bytes[offset + 4] = (byte)(value >> 32 & 0xFFL);
        bytes[offset + 3] = (byte)(value >> 24 & 0xFFL);
        bytes[offset + 2] = (byte)(value >> 16 & 0xFFL);
        bytes[offset + 1] = (byte)(value >> 8 & 0xFFL);
        bytes[offset] = (byte)(value & 0xFFL);
    }

    protected static final long getLongFromBytes(byte[] bytes, int offset) {
        return ((long)bytes[offset + 7] & 0xFFL) << 56 | ((long)bytes[offset + 6] & 0xFFL) << 48 | ((long)bytes[offset + 5] & 0xFFL) << 40 | ((long)bytes[offset + 4] & 0xFFL) << 32 | ((long)bytes[offset + 3] & 0xFFL) << 24 | ((long)bytes[offset + 2] & 0xFFL) << 16 | ((long)bytes[offset + 1] & 0xFFL) << 8 | (long)bytes[offset] & 0xFFL;
    }

    protected final block allocateBlock() {
        block newBlock = this.cache.allocate(-1L, false);
        return newBlock;
    }

    protected final block allocateBlock(long location) {
        block newBlock = this.cache.allocate(location, true);
        return newBlock;
    }

    protected final boolean deallocateBlock(block curBlock) {
        return this.deallocateBlock(curBlock, false);
    }

    protected final boolean deallocateBlock(block curBlock, boolean makeDirty) {
        if (curBlock == null) {
            return false;
        }
        return this.cache.deallocate(curBlock, makeDirty);
    }

    protected final boolean deallocateAndDeleteBlock(block curBlock) {
        if (curBlock == null) {
            return false;
        }
        return this.cache.deallocate(curBlock, true, true);
    }

    class LongKey {
        private int key = 0;

        public LongKey(long val) {
            this.key = (int)val;
        }

        public final int hashCode() {
            return this.key;
        }

        public final boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            try {
                return this.hashCode() == ((LongKey)o).hashCode();
            }
            catch (Throwable throwable) {
                return super.equals(o);
            }
        }
    }

    class BlockFileCache {
        private int size;
        private final Vector<block> freeBlocks = new Vector();
        Hashtable<LongKey, block> cache;

        public BlockFileCache(int size) {
            this.cache = new Hashtable(size);
            this.size = size;
        }

        public final int getCacheSize() {
            return this.size;
        }

        public final void flush() {
            Enumeration<block> elements = this.cache.elements();
            while (elements.hasMoreElements()) {
                block curBlock = elements.nextElement();
                if (curBlock == null) continue;
                if (curBlock.isDirty()) {
                    blockFile.this.write(curBlock);
                }
                curBlock.clear();
                if (this.freeBlocks.size() >= 200) continue;
                this.freeBlocks.addElement(curBlock);
            }
            this.cache.clear();
        }

        private final boolean flushLowestPriorityNonReferencedBlocks() {
            boolean oneHasBeenRemoved = false;
            Enumeration<block> elements = this.cache.elements();
            while (elements.hasMoreElements()) {
                block curBlock = elements.nextElement();
                if (curBlock.getReferenceCount() != 0) continue;
                long location = curBlock.getLocation();
                LongKey locationKey = new LongKey(location);
                if (curBlock.isDirty()) {
                    blockFile.this.write(curBlock);
                }
                curBlock.clear();
                if (this.freeBlocks.size() < 200) {
                    this.freeBlocks.addElement(curBlock);
                }
                this.cache.remove(locationKey);
                oneHasBeenRemoved = true;
            }
            return oneHasBeenRemoved;
        }

        public final block allocate(long location, boolean useLocation) {
            int cacheSize;
            block newBlock;
            int last;
            boolean inCache = false;
            LongKey locationKey = null;
            if (!useLocation) {
                last = this.freeBlocks.size() - 1;
                if (last >= 0) {
                    this.freeBlocks.removeElementAt(last);
                }
                if ((newBlock = blockFile.this.allocate()) == null) {
                    return null;
                }
                location = newBlock.getLocation();
                locationKey = new LongKey(location);
            } else {
                locationKey = new LongKey(location);
                newBlock = this.cache.get(locationKey);
                if (newBlock == null) {
                    last = this.freeBlocks.size() - 1;
                    if (last >= 0) {
                        block tempBlock = this.freeBlocks.elementAt(last);
                        this.freeBlocks.removeElementAt(last);
                        newBlock = tempBlock;
                        newBlock.setLocation(location);
                        if (blockFile.this.read(newBlock) < 0) {
                            return null;
                        }
                    } else {
                        newBlock = blockFile.this.rootBlock.copy();
                        newBlock.setLocation(location);
                        if (blockFile.this.read(newBlock) < 0) {
                            return null;
                        }
                    }
                } else {
                    inCache = true;
                }
            }
            if (!inCache && (cacheSize = this.getCacheSize()) > 0) {
                if (cacheSize == this.cache.size()) {
                    if (this.flushLowestPriorityNonReferencedBlocks()) {
                        this.cache.put(locationKey, newBlock);
                    }
                } else {
                    this.cache.put(locationKey, newBlock);
                }
            }
            newBlock.increasePriority();
            newBlock.increaseReferenceCount();
            return newBlock;
        }

        public final boolean deallocate(block curBlock) {
            return this.deallocate(curBlock, false, false);
        }

        public final boolean deallocate(block curBlock, boolean makeDirty) {
            return this.deallocate(curBlock, makeDirty, false);
        }

        public final boolean deallocate(block curBlock, boolean makeDirty, boolean deleteIfNoReferences) {
            int cacheSize = this.getCacheSize();
            long location = curBlock.getLocation();
            LongKey locationKey = new LongKey(location);
            if (makeDirty && blockFile.this.readOnlyCache) {
                if (blockFile.this.write(curBlock) < 0) {
                    return false;
                }
                makeDirty = false;
            }
            if (locationKey != null && cacheSize > 0 && this.cache.get(locationKey) == curBlock) {
                int referenceCount = curBlock.getReferenceCount() - 1;
                if (referenceCount == 0 && deleteIfNoReferences) {
                    if (blockFile.this.delete(curBlock) < 0) {
                        return false;
                    }
                    curBlock.clear();
                    if (this.freeBlocks.size() < 200) {
                        this.freeBlocks.addElement(curBlock);
                    }
                    this.cache.remove(locationKey);
                    return true;
                }
                curBlock.setReferenceCount(referenceCount);
                if (makeDirty) {
                    curBlock.setDirty(true);
                }
                return true;
            }
            if (makeDirty && blockFile.this.write(curBlock) < 0) {
                return false;
            }
            curBlock.clear();
            if (this.freeBlocks.size() < 200) {
                this.freeBlocks.addElement(curBlock);
            }
            return true;
        }

        public final String toString() {
            return "A bunch of cache values";
        }
    }
}

