/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec.fileprotocol;

import com.heirloomcomputing.ecs.exec.FileConstants;
import com.heirloomcomputing.ecs.exec.FileCountTracker;
import com.heirloomcomputing.ecs.exec.FileProtocol;
import com.heirloomcomputing.ecs.exec.LockFile;
import com.heirloomcomputing.ecs.exec.LockedFileException;
import com.heirloomcomputing.ecs.exec.NIORandomAccessFile;
import com.heirloomcomputing.ecs.exec.RandomAccessFileFactory;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.exec.lockManager;
import com.heirloomcomputing.ecs.exec.smartFile;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;

public class file
implements FileProtocol,
FileConstants {
    public static final String READ_MODE = "r";
    public static final String WRITE_MODE = "rw";
    public static final String READ_WRITE_MODE = "rw";
    private static final Hashtable<String, Long> filePointerTable = new Hashtable();
    private static final Hashtable<String, FileCountTracker> fileRegistry = new Hashtable();
    private static ArrayList<String> fileConcatenation = null;
    private static boolean LINE_SEQUENTIAL_WRAPS = true;
    private static boolean lockWhileOpen = LockFile.isLockWhileOpen();
    private boolean readable = true;
    private boolean writable = true;
    private boolean lineSequential;
    private boolean open;
    private boolean multi;
    private boolean bufferedEndOfFile;
    private boolean idxFile;
    private long filePosition;
    private long nextFilePosition;
    private int bufferedReadChar = -1;
    private RandomAccessFile raf;
    private String filename;
    private lockManager locker = new lockManager();
    private static final int LINE_SEQUENTIAL_READ_BUFFER_SIZE = 16384;
    private byte[] lineSequentialReadBuffer;
    private int lineSequentialReadIndex;
    private int lineSequentialReadLimit = -1;
    private boolean bufferLineSequential = true;

    private static void initializeDefaults() {
        LINE_SEQUENTIAL_WRAPS = RuntimeEnvironment.isGlobalParameter("LINEWRAPS", true);
    }

    private final synchronized void restoreFilePointer() {
        if (!this.multi) {
            return;
        }
        Long result = filePointerTable.get(Thread.currentThread().toString() + "/" + this.filename);
        long seekAddress = -2L;
        if (result != null) {
            try {
                seekAddress = result;
                if (seekAddress == -1L) {
                    seekAddress = 0L;
                }
                this.raf.seek(seekAddress);
            }
            catch (Exception e) {
                seekAddress = 0L;
                try {
                    this.raf.seek(seekAddress);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private final synchronized void saveFilePointer() {
        long seekAddress;
        if (!this.multi) {
            return;
        }
        try {
            seekAddress = this.raf.getFilePointer();
        }
        catch (Exception e) {
            seekAddress = -1L;
        }
        try {
            filePointerTable.put(Thread.currentThread().toString() + "/" + this.filename, new Long(seekAddress));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final synchronized void resetFilePointer() {
        try {
            if (this.raf != null) {
                this.raf.seek(0L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final synchronized void eliminateFilePointer() {
        if (!this.multi) {
            return;
        }
        try {
            filePointerTable.remove(Thread.currentThread().toString() + "/" + this.filename);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final String getProtocol() {
        return "file";
    }

    @Override
    public final synchronized boolean init(String filename, boolean lineSequential) {
        if (filename != null) {
            filename = filename.trim();
        }
        this.lineSequential = lineSequential;
        this.readable = true;
        this.writable = true;
        this.filename = smartFile.convertFilename(filename);
        if (this.multi) {
            this.eliminateFilePointer();
        }
        return true;
    }

    @Override
    public final void setLineSequential(boolean state) {
        this.lineSequential = state;
    }

    public final synchronized boolean initWithLocalFilename(String filename, boolean lineSequential) {
        this.filePosition = 0L;
        this.nextFilePosition = 0L;
        this.resetFilePointer();
        return this.init(filename, lineSequential);
    }

    @Override
    public final synchronized int write(byte[] data, int offset, int length) {
        if (!this.open || !this.writable) {
            return -48;
        }
        try {
            if (this.multi) {
                this.restoreFilePointer();
                this.raf.write(data, offset, length);
                this.saveFilePointer();
            } else {
                this.raf.write(data, offset, length);
            }
            return 0;
        }
        catch (EOFException eofException) {
            if (this.multi) {
                this.saveFilePointer();
            }
            return -10;
        }
        catch (IOException ioException) {
            if (this.multi) {
                this.saveFilePointer();
            }
            return -99;
        }
        catch (Exception exception) {
            if (this.multi) {
                this.saveFilePointer();
            }
            return -30;
        }
    }

    @Override
    public final synchronized int read(byte[] data, int offset, int length) {
        if (this.multi) {
            this.restoreFilePointer();
        }
        if (!this.open) {
            return -47;
        }
        int bytesRead = 0;
        if (this.bufferedEndOfFile) {
            this.bufferedEndOfFile = false;
            return -10;
        }
        try {
            this.filePosition = this.nextFilePosition;
            if (this.lineSequential) {
                int bytesStored = 0;
                int ch = 0;
                boolean escaped = false;
                boolean eof = false;
                try {
                    while (true) {
                        String nextFileName;
                        if (this.bufferedReadChar >= 0) {
                            ch = this.bufferedReadChar;
                            this.bufferedReadChar = -1;
                        } else if (this.bufferLineSequential) {
                            if (this.lineSequentialReadBuffer == null) {
                                this.lineSequentialReadIndex = 0;
                                this.lineSequentialReadBuffer = new byte[16384];
                                this.lineSequentialReadLimit = this.raf.read(this.lineSequentialReadBuffer);
                                while (this.lineSequentialReadLimit < 0 && fileConcatenation != null && fileConcatenation.size() > 0) {
                                    nextFileName = fileConcatenation.remove(0);
                                    this.raf.close();
                                    try {
                                        this.raf = RandomAccessFileFactory.getInstance(nextFileName, READ_MODE);
                                    }
                                    catch (Exception e) {
                                        break;
                                    }
                                    this.lineSequentialReadLimit = this.raf.read(this.lineSequentialReadBuffer);
                                    this.lineSequentialReadIndex = 0;
                                }
                                ch = this.lineSequentialReadLimit < 0 ? -1 : this.lineSequentialReadBuffer[this.lineSequentialReadIndex++] & 0xFF;
                            } else if (this.lineSequentialReadIndex >= this.lineSequentialReadLimit) {
                                this.lineSequentialReadIndex = 0;
                                this.lineSequentialReadLimit = this.raf.read(this.lineSequentialReadBuffer);
                                while (this.lineSequentialReadLimit < 0 && fileConcatenation != null && fileConcatenation.size() > 0) {
                                    nextFileName = fileConcatenation.remove(0);
                                    this.raf.close();
                                    try {
                                        this.raf = RandomAccessFileFactory.getInstance(nextFileName, READ_MODE);
                                    }
                                    catch (Exception e) {
                                        break;
                                    }
                                    this.lineSequentialReadLimit = this.raf.read(this.lineSequentialReadBuffer);
                                    this.lineSequentialReadIndex = 0;
                                }
                                ch = this.lineSequentialReadLimit < 0 ? -1 : this.lineSequentialReadBuffer[this.lineSequentialReadIndex++] & 0xFF;
                            } else {
                                ch = this.lineSequentialReadBuffer[this.lineSequentialReadIndex++] & 0xFF;
                            }
                        } else {
                            ch = this.raf.read();
                            while (ch < 0 && fileConcatenation != null && fileConcatenation.size() > 0) {
                                nextFileName = fileConcatenation.remove(0);
                                this.raf.close();
                                try {
                                    this.raf = RandomAccessFileFactory.getInstance(nextFileName, READ_MODE);
                                }
                                catch (Exception e) {
                                    break;
                                }
                                ch = this.raf.read();
                            }
                        }
                        ++this.nextFilePosition;
                        if (ch < 0) {
                            --this.nextFilePosition;
                            eof = true;
                            break;
                        }
                        if (ch == 0 && !escaped) {
                            escaped = true;
                            continue;
                        }
                        if (!escaped) {
                            if (ch != 13) {
                                if (ch == 10) break;
                                if (ch == 26) {
                                    eof = true;
                                    break;
                                }
                                if (bytesStored < length) {
                                    data[offset + bytesStored] = (byte)(ch & 0xFF);
                                    ++bytesStored;
                                } else if (LINE_SEQUENTIAL_WRAPS) {
                                    --this.nextFilePosition;
                                    this.bufferedReadChar = ch & 0xFF;
                                    break;
                                }
                            }
                        } else if (bytesStored < length) {
                            data[offset + bytesStored] = (byte)(ch & 0xFF);
                            ++bytesStored;
                        } else if (LINE_SEQUENTIAL_WRAPS) {
                            --this.nextFilePosition;
                            this.bufferedReadChar = ch & 0xFF;
                            break;
                        }
                        escaped = false;
                    }
                }
                catch (Exception eofException) {
                    eof = true;
                }
                for (int i = bytesStored; i < length; ++i) {
                    data[offset + i] = Variable.SPACE_BYTE;
                }
                if (this.multi) {
                    this.saveFilePointer();
                }
                if (eof && bytesStored > 0) {
                    this.bufferedEndOfFile = true;
                    eof = false;
                }
                return eof ? -10 : bytesStored;
            }
            try {
                bytesRead = this.raf.read(data, offset, length);
                this.nextFilePosition += (long)bytesRead;
            }
            catch (EOFException eofException) {
                if (this.multi) {
                    this.saveFilePointer();
                }
                return -10;
            }
            catch (IOException ioException) {
                if (this.multi) {
                    this.saveFilePointer();
                }
                return -99;
            }
            catch (Exception anyException) {
                if (this.multi) {
                    this.saveFilePointer();
                }
                return -10;
            }
            if (this.multi) {
                this.saveFilePointer();
            }
            return bytesRead <= 0 ? -10 : bytesRead;
        }
        catch (Exception permanentError) {
            if (this.multi) {
                this.saveFilePointer();
            }
            return -30;
        }
    }

    @Override
    public final int close(int mode) {
        FileCountTracker thisfile;
        if ((mode & 0x800) != 0 && (thisfile = fileRegistry.get(this.filename)) != null) {
            if (!thisfile.decCount()) {
                return 0;
            }
            fileRegistry.remove(this.filename);
        }
        this.readable = true;
        this.writable = true;
        if (this.raf != null) {
            if (!lockWhileOpen) {
                try {
                    this.raf.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                LockFile.releaseSharing(this.raf, this.filename);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (lockWhileOpen) {
                try {
                    this.raf.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.raf = null;
        }
        this.open = false;
        if (this.multi) {
            this.eliminateFilePointer();
        }
        return 0;
    }

    @Override
    public final synchronized int open(int mode) {
        this.multi = (mode & 0x800) != 0;
        this.bufferedEndOfFile = false;
        this.bufferedReadChar = -1;
        if (this.multi) {
            this.eliminateFilePointer();
        }
        int returnCode = this.innerOpen(mode);
        if ((mode & 4) == 0) {
            if (this.multi) {
                this.saveFilePointer();
            }
            return returnCode;
        }
        if (returnCode <= -10 || returnCode == -5 || returnCode == 5 || returnCode >= 10) {
            if (this.multi) {
                this.saveFilePointer();
            }
            return returnCode;
        }
        this.filePosition = this.nextFilePosition = this.length();
        if (this.filePosition < 0L) {
            if (this.filePosition == -90L) {
                return returnCode;
            }
            if (this.multi) {
                this.saveFilePointer();
            }
            return (int)this.filePosition;
        }
        long seekCode = this.seek(this.filePosition);
        if (seekCode != 0L) {
            returnCode = (int)seekCode;
        }
        if (this.multi) {
            this.saveFilePointer();
        }
        return returnCode;
    }

    private final int innerOpen(int mode) {
        int returnCode;
        if (!this.multi) {
            return this.innerOpen2(mode);
        }
        FileCountTracker thisfile = fileRegistry.get(this.filename);
        if (thisfile == null) {
            returnCode = this.innerOpen2(mode & 0xFFFFF7FF);
            if (returnCode > -10 && returnCode < 10) {
                fileRegistry.put(this.filename, new FileCountTracker(this.raf));
            }
        } else {
            thisfile.incCount();
            this.raf = thisfile.getRandomAccessFile();
            returnCode = 0;
            this.open = true;
        }
        return returnCode;
    }

    /*
     * Unable to fully structure code
     */
    private final int innerOpen2(int mode) {
        lockedFilename = this.filename;
        ERROR_LOCKED_FILE_MISSING = (mode & 8) != 0 ? 5 : 35;
        sharingAllOthers = false;
        sharingNoOthers = false;
        sharingReadOnly = false;
        if ((mode & 131072) != 0) {
            sharingAllOthers = true;
            this.bufferLineSequential = false;
        } else if ((mode & 262144) != 0) {
            sharingNoOthers = true;
            this.bufferLineSequential = true;
        } else if ((mode & 524288) != 0) {
            sharingReadOnly = true;
            this.bufferLineSequential = true;
        } else if ((mode & 32) != 0) {
            sharingAllOthers = true;
            this.bufferLineSequential = false;
        } else if ((mode & 64) != 0) {
            sharingNoOthers = true;
            this.bufferLineSequential = true;
        } else if ((mode & 128) != 0) {
            sharingReadOnly = true;
            this.bufferLineSequential = true;
        } else {
            this.bufferLineSequential = true;
        }
        if (!file.lockWhileOpen) {
            try {
                if (sharingAllOthers) {
                    lockedFilename = LockFile.sharingAllOthers(null, this.filename, mode);
                } else if (sharingNoOthers) {
                    lockedFilename = LockFile.sharingNoOthers(null, this.filename, mode);
                } else if (sharingReadOnly) {
                    lockedFilename = LockFile.sharingReadOnly(null, this.filename, mode);
                }
            }
            catch (LockedFileException lockedFile) {
                return -93;
            }
            if (lockedFilename == null) {
                return ERROR_LOCKED_FILE_MISSING;
            }
            sharingAllOthers = false;
            sharingNoOthers = false;
            sharingReadOnly = false;
        }
        extend = (mode & 4) != 0;
        this.writable = (mode & 2) != 0;
        this.readable = (mode & 1) != 0;
        this.filePosition = 0L;
        this.nextFilePosition = 0L;
        if (this.bufferLineSequential) {
            if (this.writable) {
                this.bufferLineSequential = false;
            } else {
                this.lineSequentialReadIndex = 0;
                this.lineSequentialReadLimit = -1;
            }
        }
        retry = false;
        do {
            try {
                if (this.readable && !this.writable) {
                    if (!new File(lockedFilename).exists()) {
                        concatenatedFiles = lockedFilename.split("\\+");
                        if (concatenatedFiles.length > 1 && !retry) {
                            for (String oneFile : concatenatedFiles) {
                                if (new File(oneFile).exists()) continue;
                                throw new FileNotFoundException();
                            }
                            file.fileConcatenation = new ArrayList<String>(Arrays.asList(concatenatedFiles));
                            lockedFilename = file.fileConcatenation.remove(0);
                        } else {
                            throw new FileNotFoundException();
                        }
                    }
                    if (!(sharingAllOthers || sharingNoOthers || sharingReadOnly)) {
                        this.raf = RandomAccessFileFactory.getInstance(lockedFilename, "r");
                    } else {
                        try {
                            this.raf = RandomAccessFileFactory.getInstance(lockedFilename, "rw");
                        }
                        catch (Exception t) {
                            this.raf = RandomAccessFileFactory.getInstance(lockedFilename, "r");
                        }
                    }
                    this.open = true;
                    if (sharingAllOthers) {
                        try {
                            if (LockFile.sharingAllOthers(this.raf, lockedFilename, mode) != null) ** GOTO lbl107
                            this.open = false;
                        }
                        catch (LockedFileException lockException) {
                            this.open = false;
                            return -93;
                        }
                    } else if (sharingNoOthers) {
                        try {
                            if (LockFile.sharingNoOthers(this.raf, lockedFilename, mode) != null) ** GOTO lbl107
                            this.open = false;
                        }
                        catch (LockedFileException lockException) {
                            this.open = false;
                            return -93;
                        }
                    } else if (sharingReadOnly) {
                        try {
                            if (LockFile.sharingReadOnly(this.raf, lockedFilename, mode) == null) {
                                this.open = false;
                            }
                        }
                        catch (LockedFileException lockException) {
                            this.open = false;
                            return -93;
                        }
                    }
lbl107:
                    // 7 sources

                    return this.open != false ? 0 : ERROR_LOCKED_FILE_MISSING;
                }
                if (!new File(lockedFilename).exists()) continue;
                newFile = false;
                if (this.writable && !extend && !this.readable) {
                    block116: {
                        if (sharingAllOthers || sharingNoOthers || sharingReadOnly) {
                            this.raf = RandomAccessFileFactory.getInstance(lockedFilename, "r");
                            try {
                                if (LockFile.sharingNoOthers(this.raf, lockedFilename, 1) != null) {
                                    LockFile.releaseSharing(this.raf, lockedFilename);
                                    this.raf.close();
                                    try {
                                        fout = new FileOutputStream(lockedFilename);
                                        fout.close();
                                        break block116;
                                    }
                                    catch (Exception t) {
                                        return -93;
                                    }
                                }
                                try {
                                    this.raf.close();
                                }
                                catch (Exception t) {
                                    // empty catch block
                                }
                                return ERROR_LOCKED_FILE_MISSING;
                            }
                            catch (LockedFileException lockException) {
                                this.open = false;
                                try {
                                    this.raf.close();
                                }
                                catch (Exception var11_40) {
                                    // empty catch block
                                }
                                return -93;
                            }
                        }
                    }
                    newFile = true;
                }
                try {
                    this.raf = RandomAccessFileFactory.getInstance(lockedFilename, "rw");
                }
                catch (Exception t) {
                    this.raf = RandomAccessFileFactory.getInstance(lockedFilename, this.writable != false ? "rw" : "r");
                }
                if (this.writable && !this.readable && !extend) {
                    try {
                        this.raf.getChannel().truncate(0L);
                    }
                    catch (IOException t) {
                        // empty catch block
                    }
                }
                this.open = true;
                if (sharingAllOthers) {
                    try {
                        if (LockFile.sharingAllOthers(this.raf, lockedFilename, mode) != null) ** GOTO lbl177
                        this.open = false;
                    }
                    catch (LockedFileException lockedFile) {
                        this.open = false;
                        return -93;
                    }
                } else if (sharingNoOthers) {
                    try {
                        if (LockFile.sharingNoOthers(this.raf, lockedFilename, mode) != null) ** GOTO lbl177
                        this.open = false;
                    }
                    catch (LockedFileException lockedFile) {
                        this.open = false;
                        return -93;
                    }
                } else if (sharingReadOnly) {
                    try {
                        if (LockFile.sharingReadOnly(this.raf, lockedFilename, mode) == null) {
                            this.open = false;
                        }
                    }
                    catch (LockedFileException lockedFile) {
                        this.open = false;
                        return -93;
                    }
                }
lbl177:
                // 7 sources

                if (!this.open) {
                    return ERROR_LOCKED_FILE_MISSING;
                }
                return newFile != false ? -8 : 0;
            }
            catch (FileNotFoundException fnfe) {
                if (!retry) {
                    retry = true;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception lockedFile) {}
                    continue;
                }
                retry = false;
            }
            catch (Exception fnfe) {
                // empty catch block
            }
        } while (retry);
        if ((mode & 8) != 0) {
            create = (mode & 1024) != 0;
            this.open = true;
            if (this.writable || create) {
                try {
                    this.raf = RandomAccessFileFactory.getInstance(lockedFilename, "rw");
                    if (sharingAllOthers) {
                        try {
                            if (LockFile.sharingAllOthers(this.raf, lockedFilename, mode) != null) ** GOTO lbl223
                            this.open = false;
                        }
                        catch (LockedFileException lockedFile) {
                            this.open = false;
                            return -93;
                        }
                    } else if (sharingNoOthers) {
                        try {
                            if (LockFile.sharingNoOthers(this.raf, lockedFilename, mode) != null) ** GOTO lbl223
                            this.open = false;
                        }
                        catch (LockedFileException lockedFile) {
                            this.open = false;
                            return -93;
                        }
                    } else if (sharingReadOnly) {
                        try {
                            if (LockFile.sharingReadOnly(this.raf, lockedFilename, mode) == null) {
                                this.open = false;
                            }
                        }
                        catch (LockedFileException lockedFile) {
                            this.open = false;
                            return -93;
                        }
                    }
lbl223:
                    // 7 sources

                    if (!this.open) {
                        return ERROR_LOCKED_FILE_MISSING;
                    }
                }
                catch (Exception coudlntCreateMissingOutputOptionalFile) {
                    return 30;
                }
            }
            return 5;
        }
        try {
            if (System.getProperty("ebp.failOnUndeclaredFiles") != null) {
                return -96;
            }
        }
        catch (Exception create) {
            // empty catch block
        }
        if (this.writable && !this.readable && !extend) {
            try {
                this.raf = RandomAccessFileFactory.getInstance(lockedFilename, "rw");
                this.open = true;
                if (sharingAllOthers) {
                    try {
                        if (LockFile.sharingAllOthers(this.raf, lockedFilename, mode) != null) ** GOTO lbl263
                        this.open = false;
                    }
                    catch (LockedFileException lockedFile) {
                        this.open = false;
                        return -93;
                    }
                } else if (sharingNoOthers) {
                    try {
                        if (LockFile.sharingNoOthers(this.raf, lockedFilename, mode) != null) ** GOTO lbl263
                        this.open = false;
                    }
                    catch (LockedFileException lockedFile) {
                        this.open = false;
                        return -93;
                    }
                } else if (sharingReadOnly) {
                    try {
                        if (LockFile.sharingReadOnly(this.raf, lockedFilename, mode) == null) {
                            this.open = false;
                        }
                    }
                    catch (LockedFileException lockedFile) {
                        this.open = false;
                        return -93;
                    }
                }
lbl263:
                // 7 sources

                return this.open != false ? -8 : ERROR_LOCKED_FILE_MISSING;
            }
            catch (Exception var9_23) {
                // empty catch block
            }
        }
        return 35;
    }

    @Override
    public final synchronized long getFilePointer() {
        if (this.multi) {
            this.restoreFilePointer();
        }
        try {
            return this.raf.getFilePointer();
        }
        catch (Exception e) {
            return -90L;
        }
    }

    @Override
    public final synchronized int seek(long position) {
        try {
            this.setPositionInRandomAccessFile(position);
            if (this.multi) {
                this.saveFilePointer();
            }
            return 0;
        }
        catch (Exception e) {
            if (this.multi) {
                this.saveFilePointer();
            }
            return -90;
        }
    }

    private final synchronized void setPositionInRandomAccessFile(long position) throws IOException {
        if (this.raf instanceof NIORandomAccessFile) {
            NIORandomAccessFile nioRAF = (NIORandomAccessFile)this.raf;
            if (position >= nioRAF.getCurrentBufferPosition()) {
                nioRAF.seek(position);
            }
        } else {
            this.raf.seek(position);
        }
    }

    @Override
    public final synchronized long length() {
        if (this.multi) {
            this.restoreFilePointer();
        }
        try {
            return this.raf.length();
        }
        catch (Exception e) {
            return -90L;
        }
    }

    @Override
    public final synchronized int backup() {
        return this.seek(this.filePosition);
    }

    @Override
    public final boolean isStream() {
        return false;
    }

    @Override
    public final boolean isReadable() {
        return this.readable;
    }

    @Override
    public final boolean isWritable() {
        return this.writable;
    }

    @Override
    public final boolean isSeekable() {
        return true;
    }

    @Override
    public final boolean isOpen() {
        return this.open;
    }

    @Override
    public final synchronized int readLock(long offset, int length) {
        return this.locker.readLock(offset, length);
    }

    @Override
    public final synchronized boolean readUnlock(long offset, int length) {
        this.locker.readUnlock(offset, length);
        return true;
    }

    @Override
    public final synchronized boolean readUnlock(int handle) {
        this.locker.readUnlock(handle);
        return true;
    }

    @Override
    public final synchronized int writeLock(long offset, int length) {
        return this.locker.writeLock(offset, length);
    }

    @Override
    public final synchronized boolean writeUnlock(long offset, int length) {
        this.locker.writeUnlock(offset, length);
        return true;
    }

    @Override
    public final synchronized boolean writeUnlock(int handle) {
        this.locker.writeUnlock(handle);
        return true;
    }

    @Override
    public final Object getObject() {
        return this.raf;
    }

    @Override
    public void setBlockSize(int size) {
    }

    @Override
    public void flush() {
    }

    public final boolean isIdxFile() {
        return this.idxFile;
    }

    public final void setIdxFile(boolean idxFile2) {
        this.idxFile = idxFile2;
    }

    static {
        file.initializeDefaults();
    }
}

