/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec.fileprotocol;

import com.heirloomcomputing.ecs.exec.FileConstants;
import com.heirloomcomputing.ecs.exec.FileProtocol;
import com.heirloomcomputing.ecs.exec.Variable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;

public class http
implements FileProtocol,
FileConstants {
    private String filename = null;
    private boolean readable = true;
    private boolean writable = true;
    private boolean lineSequential = false;
    private boolean open = false;
    private InputStream is = null;
    private OutputStream os = null;
    private URL url = null;
    private URLConnection urlConnection = null;
    private int MAX_LENGTH = -1;

    public void setBuffering(boolean in, boolean out) {
    }

    @Override
    public void setBlockSize(int size) {
        this.MAX_LENGTH = size > 0 ? size : -1;
    }

    public void setOpenSleep(int value) {
    }

    public static final String getProtocol() {
        return "http";
    }

    @Override
    public final boolean init(String passFilename, boolean lineSequential) {
        this.filename = passFilename;
        if (this.filename != null) {
            this.filename = this.filename.trim();
        }
        this.lineSequential = lineSequential;
        if (!this.filename.toUpperCase().startsWith("HTTP:")) {
            this.filename = "http:" + this.filename;
        }
        this.readable = true;
        this.writable = true;
        return true;
    }

    @Override
    public final void setLineSequential(boolean state) {
        this.lineSequential = state;
    }

    @Override
    public int write(byte[] data, int offset, int length) {
        if (!this.isOpen()) {
            return -48;
        }
        if (!this.isWritable()) {
            return -48;
        }
        if (this.os == null) {
            return -48;
        }
        try {
            if (this.MAX_LENGTH <= 0) {
                this.os.write(data, offset, length);
                this.flush();
            } else {
                while (length > this.MAX_LENGTH) {
                    this.os.write(data, offset, this.MAX_LENGTH);
                    offset += this.MAX_LENGTH;
                    length -= this.MAX_LENGTH;
                    this.flush();
                }
                if (length > 0) {
                    this.os.write(data, offset, length);
                    this.flush();
                }
            }
            return 0;
        }
        catch (IOException e) {
            return -93;
        }
    }

    @Override
    public int read(byte[] data, int offset, int length) {
        if (!this.open) {
            return -47;
        }
        if (this.is == null) {
            return -47;
        }
        int bytesRead = 0;
        this.flush();
        try {
            block29: {
                if (this.lineSequential) {
                    int bytesStored = 0;
                    int ch = 0;
                    boolean finished = false;
                    boolean escaped = false;
                    boolean eof = false;
                    try {
                        do {
                            if ((ch = this.is.read()) < 0) {
                                finished = true;
                                eof = true;
                                continue;
                            }
                            if (ch == 0 && !escaped) {
                                escaped = true;
                                continue;
                            }
                            if (!escaped) {
                                switch (ch) {
                                    case 13: {
                                        break;
                                    }
                                    case 10: {
                                        finished = true;
                                        break;
                                    }
                                    case 26: {
                                        finished = true;
                                        eof = true;
                                        break;
                                    }
                                    default: {
                                        if (bytesStored < length) {
                                            data[offset + bytesStored] = (byte)(ch & 0xFF);
                                            ++bytesStored;
                                            break;
                                        } else {
                                            break;
                                        }
                                    }
                                }
                            } else if (bytesStored < length) {
                                data[offset + bytesStored] = (byte)(ch & 0xFF);
                                ++bytesStored;
                            }
                            escaped = false;
                        } while (!finished);
                    }
                    catch (Exception eofException) {
                        eof = true;
                    }
                    for (int i = bytesStored; i < length; ++i) {
                        data[offset + i] = Variable.SPACE_BYTE;
                    }
                    return eof ? -10 : bytesStored;
                }
                bytesRead = 0;
                int chunk = 0;
                if (this.MAX_LENGTH <= 0) {
                    try {
                        while ((chunk = this.is.read(data, offset, length)) > 0) {
                            offset += chunk;
                            if ((bytesRead += chunk) < (length -= chunk)) continue;
                        }
                    }
                    catch (Exception endOfFile) {
                        bytesRead = -1;
                    }
                } else {
                    try {
                        while (length > this.MAX_LENGTH && (chunk = this.is.read(data, offset, this.MAX_LENGTH)) > 0) {
                            offset += chunk;
                            length -= chunk;
                            bytesRead += chunk;
                        }
                        if (length <= 0) break block29;
                        while ((chunk = this.is.read(data, offset, length)) > 0) {
                            offset += chunk;
                            if ((bytesRead += chunk) < (length -= chunk)) continue;
                            break;
                        }
                    }
                    catch (Exception e) {
                        bytesRead = -1;
                    }
                }
            }
            return bytesRead <= 0 ? -10 : bytesRead;
        }
        catch (Exception permanentError) {
            return -10;
        }
    }

    @Override
    public final int close(int mode) {
        this.open = false;
        try {
            if (this.is != null) {
                this.is.close();
            }
            this.is = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.os != null) {
                this.os.close();
            }
            this.os = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.is != null || this.os != null) {
            return -30;
        }
        this.is = null;
        this.os = null;
        return 0;
    }

    @Override
    public final int open(int mode) {
        this.readable = (mode & 1) != 0;
        boolean bl = this.writable = (mode & 2) != 0;
        if (this.open) {
            return -41;
        }
        try {
            this.url = new URL(this.filename);
            this.urlConnection = this.url.openConnection();
            if (this.readable) {
                try {
                    this.urlConnection.setDoInput(true);
                }
                catch (Exception die) {
                    this.readable = false;
                }
            }
            if (this.writable) {
                try {
                    this.urlConnection.setDoOutput(true);
                }
                catch (Exception doe) {
                    this.writable = false;
                }
            }
            this.urlConnection.connect();
            if (this.writable) {
                try {
                    this.os = this.urlConnection.getOutputStream();
                }
                catch (Exception oe) {
                    this.writable = false;
                }
            }
            if (this.readable) {
                try {
                    this.is = this.urlConnection.getInputStream();
                }
                catch (Exception ie) {
                    this.readable = false;
                }
            }
            if (this.readable || this.writable) {
                this.open = true;
            }
            if (this.open) {
                return 0;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return -30;
    }

    @Override
    public final long getFilePointer() {
        return -90L;
    }

    @Override
    public final int seek(long position) {
        return -90;
    }

    @Override
    public final long length() {
        return -90L;
    }

    @Override
    public final int backup() {
        return 0;
    }

    @Override
    public final boolean isStream() {
        return true;
    }

    @Override
    public final boolean isReadable() {
        return this.readable;
    }

    @Override
    public final boolean isWritable() {
        return this.writable;
    }

    @Override
    public final boolean isSeekable() {
        return false;
    }

    @Override
    public final boolean isOpen() {
        return this.open;
    }

    @Override
    public final int readLock(long offset, int length) {
        return 0;
    }

    @Override
    public final boolean readUnlock(long offset, int length) {
        return true;
    }

    @Override
    public final boolean readUnlock(int handle) {
        return true;
    }

    @Override
    public final int writeLock(long offset, int length) {
        return 0;
    }

    @Override
    public final boolean writeUnlock(long offset, int length) {
        return true;
    }

    @Override
    public final boolean writeUnlock(int handle) {
        return true;
    }

    @Override
    public final Object getObject() {
        return this.urlConnection;
    }

    @Override
    public void flush() {
        try {
            if (this.os != null) {
                this.os.flush();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

