/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec.fileprotocol;

import com.heirloomcomputing.ecs.exec.FileConstants;
import com.heirloomcomputing.ecs.exec.FileProtocol;
import com.heirloomcomputing.ecs.exec.Variable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Hashtable;

public class pipe
implements FileProtocol,
FileConstants {
    private static int MAX_LENGTH = -1;
    private String filename;
    private boolean readable = true;
    private boolean writable = true;
    private boolean lineSequential;
    private boolean open;
    private InputStream is;
    private OutputStream os;
    private static Hashtable<String, OutputStream> outputPipes = new Hashtable();
    private static Hashtable<String, InputStream> inputPipes = new Hashtable();

    public static void setBuffering(boolean in, boolean out) {
    }

    public static void setOpenSleep(int value) {
    }

    public static PipedOutputStream getOutputPipe(String name) {
        try {
            return (PipedOutputStream)outputPipes.get(name);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static PipedInputStream getInputPipe(String name) {
        try {
            return (PipedInputStream)inputPipes.get(name);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static final String getProtocol() {
        return "pipe";
    }

    @Override
    public final boolean init(String filename, boolean lineSequential) {
        if (filename != null) {
            filename = filename.trim();
        }
        this.filename = filename;
        this.lineSequential = lineSequential;
        this.readable = true;
        this.writable = true;
        return true;
    }

    @Override
    public final void setLineSequential(boolean state) {
        this.lineSequential = state;
    }

    @Override
    public int write(byte[] data, int offset, int length) {
        if (!this.isOpen()) {
            return -48;
        }
        if (!this.isWritable()) {
            return -48;
        }
        if (this.os == null) {
            return -48;
        }
        try {
            if (MAX_LENGTH <= 0) {
                this.os.write(data, offset, length);
                this.flush();
            } else {
                while (length > MAX_LENGTH) {
                    this.os.write(data, offset, MAX_LENGTH);
                    offset += MAX_LENGTH;
                    length -= MAX_LENGTH;
                    this.flush();
                }
                if (length > 0) {
                    this.os.write(data, offset, length);
                    this.flush();
                }
            }
            return 0;
        }
        catch (IOException e) {
            return -30;
        }
    }

    @Override
    public int read(byte[] data, int offset, int length) {
        if (!this.open) {
            return -47;
        }
        if (this.is == null) {
            return -47;
        }
        int bytesRead = 0;
        this.flush();
        try {
            block29: {
                if (this.lineSequential) {
                    int bytesStored = 0;
                    int ch = 0;
                    boolean finished = false;
                    boolean escaped = false;
                    boolean eof = false;
                    try {
                        do {
                            if ((ch = this.is.read()) < 0) {
                                finished = true;
                                eof = true;
                                continue;
                            }
                            if (ch == 0 && !escaped) {
                                escaped = true;
                                continue;
                            }
                            if (!escaped) {
                                switch (ch) {
                                    case 13: {
                                        break;
                                    }
                                    case 10: {
                                        finished = true;
                                        break;
                                    }
                                    case 26: {
                                        finished = true;
                                        eof = true;
                                        break;
                                    }
                                    default: {
                                        if (bytesStored < length) {
                                            data[offset + bytesStored] = (byte)(ch & 0xFF);
                                            ++bytesStored;
                                            break;
                                        } else {
                                            break;
                                        }
                                    }
                                }
                            } else if (bytesStored < length) {
                                data[offset + bytesStored] = (byte)(ch & 0xFF);
                                ++bytesStored;
                            }
                            escaped = false;
                        } while (!finished);
                    }
                    catch (Exception eofException) {
                        eof = true;
                    }
                    for (int i = bytesStored; i < length; ++i) {
                        data[offset + i] = Variable.SPACE_BYTE;
                    }
                    return eof ? -10 : bytesStored;
                }
                bytesRead = 0;
                int chunk = 0;
                if (MAX_LENGTH <= 0) {
                    try {
                        while ((chunk = this.is.read(data, offset, length)) > 0) {
                            offset += chunk;
                            if ((bytesRead += chunk) < (length -= chunk)) continue;
                        }
                    }
                    catch (Exception endOfFile) {
                        bytesRead = -1;
                    }
                } else {
                    try {
                        while (length > MAX_LENGTH && (chunk = this.is.read(data, offset, MAX_LENGTH)) > 0) {
                            offset += chunk;
                            length -= chunk;
                            bytesRead += chunk;
                        }
                        if (length <= 0) break block29;
                        while ((chunk = this.is.read(data, offset, length)) > 0) {
                            offset += chunk;
                            if ((bytesRead += chunk) < (length -= chunk)) continue;
                            break;
                        }
                    }
                    catch (Exception e) {
                        bytesRead = -1;
                    }
                }
            }
            return bytesRead <= 0 ? -10 : bytesRead;
        }
        catch (Exception permanentError) {
            return -30;
        }
    }

    @Override
    public final int close(int mode) {
        this.open = false;
        int result = 0;
        try {
            if (this.is != null) {
                this.is.close();
            }
        }
        catch (Exception e) {
            result = -30;
        }
        try {
            if (this.os != null) {
                this.os.close();
            }
        }
        catch (Exception e) {
            result = -30;
        }
        this.is = null;
        this.os = null;
        this.readable = true;
        this.writable = true;
        return result;
    }

    @Override
    public final int open(int mode) {
        if (this.open) {
            return -41;
        }
        this.is = null;
        this.os = null;
        this.readable = (mode & 1) != 0;
        boolean bl = this.writable = (mode & 2) != 0;
        if (this.filename.startsWith("pipe:")) {
            this.filename = this.filename.substring(5);
        }
        OutputStream pipeOut = outputPipes.get(this.filename);
        InputStream pipeIn = inputPipes.get(this.filename);
        try {
            if (this.writable) {
                this.os = pipeIn != null ? new PipedOutputStream((PipedInputStream)pipeIn) : new PipedOutputStream();
                outputPipes.put(this.filename, this.os);
            }
            if (this.readable) {
                this.is = pipeOut != null ? new PipedInputStream((PipedOutputStream)pipeOut) : new PipedInputStream();
                inputPipes.put(this.filename, this.is);
            }
            this.open = true;
            return 0;
        }
        catch (Exception exception) {
            return -30;
        }
    }

    @Override
    public final long getFilePointer() {
        return -90L;
    }

    @Override
    public final int seek(long position) {
        return -90;
    }

    @Override
    public final long length() {
        return -90L;
    }

    @Override
    public final int backup() {
        return 0;
    }

    @Override
    public final boolean isStream() {
        return true;
    }

    @Override
    public final boolean isReadable() {
        return this.readable;
    }

    @Override
    public final boolean isWritable() {
        return this.writable;
    }

    @Override
    public final boolean isSeekable() {
        return false;
    }

    @Override
    public final boolean isOpen() {
        return this.open;
    }

    @Override
    public final int readLock(long offset, int length) {
        return 0;
    }

    @Override
    public final boolean readUnlock(long offset, int length) {
        return true;
    }

    @Override
    public final boolean readUnlock(int handle) {
        return true;
    }

    @Override
    public final int writeLock(long offset, int length) {
        return 0;
    }

    @Override
    public final boolean writeUnlock(long offset, int length) {
        return true;
    }

    @Override
    public final boolean writeUnlock(int handle) {
        return true;
    }

    @Override
    public final Object getObject() {
        if (this.os != null) {
            return this.os;
        }
        return this.is;
    }

    @Override
    public void setBlockSize(int size) {
        MAX_LENGTH = size > 0 ? size : -1;
    }

    @Override
    public void flush() {
        try {
            if (this.os != null) {
                this.os.flush();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

