/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec.fileprotocol;

import com.heirloomcomputing.ecs.exec.FileConstants;
import com.heirloomcomputing.ecs.exec.FileProtocol;
import com.heirloomcomputing.ecs.exec.Variable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Hashtable;

public class server
implements FileProtocol,
FileConstants {
    private boolean readable = true;
    private boolean writable = true;
    private boolean lineSequential = false;
    private ServerSocket ssocket;
    private int port = 0;
    private int MAX_LENGTH = -1;
    private static boolean alreadyInited = false;
    private Hashtable<Thread, SocketGroup> socketMapping = new Hashtable();

    public void setBuffering(boolean in, boolean out) {
    }

    @Override
    public void setBlockSize(int size) {
        this.MAX_LENGTH = size > 0 ? size : -1;
    }

    public void setOpenSleep(int value) {
    }

    public static final String getProtocol() {
        return "server";
    }

    @Override
    public final boolean init(String filename, boolean lineSequential) {
        if (filename != null) {
            filename = filename.trim();
        }
        if (alreadyInited) {
            return false;
        }
        alreadyInited = true;
        if (filename == null) {
            return true;
        }
        this.lineSequential = lineSequential;
        if (filename.toUpperCase().startsWith("SERVER:")) {
            filename = filename.substring(7);
        }
        this.readable = true;
        this.writable = true;
        int i = filename.indexOf(58);
        if (i >= 0) {
            try {
                this.port = Integer.valueOf(filename.substring(i + 1));
            }
            catch (Exception e) {
                this.port = 80;
            }
            filename = filename.substring(0, i);
        } else {
            try {
                this.port = Integer.valueOf(filename);
            }
            catch (Exception e) {
                this.port = 80;
            }
        }
        try {
            ServerSocket tempServerSocket;
            if (this.ssocket != null) {
                this.ssocket.close();
                this.ssocket = null;
            }
            this.ssocket = tempServerSocket = new ServerSocket(this.port);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    @Override
    public final void setLineSequential(boolean state) {
        this.lineSequential = state;
    }

    @Override
    public int write(byte[] data, int offset, int length) {
        if (!this.isOpen()) {
            return -48;
        }
        if (!this.isWritable()) {
            return -48;
        }
        SocketGroup group = this.getSocketGroup();
        if (group == null) {
            return -48;
        }
        DataOutputStream os = group.os;
        if (os == null) {
            return -48;
        }
        try {
            if (this.MAX_LENGTH <= 0) {
                os.write(data, offset, length);
                this.flush();
            } else {
                while (length > this.MAX_LENGTH) {
                    os.write(data, offset, this.MAX_LENGTH);
                    offset += this.MAX_LENGTH;
                    length -= this.MAX_LENGTH;
                    this.flush();
                }
                if (length > 0) {
                    os.write(data, offset, length);
                    this.flush();
                }
            }
            return 0;
        }
        catch (IOException e) {
            return -93;
        }
    }

    @Override
    public int read(byte[] data, int offset, int length) {
        if (!this.isOpen()) {
            return -47;
        }
        SocketGroup group = this.getSocketGroup();
        if (group == null) {
            return -47;
        }
        DataInputStream is = group.is;
        if (is == null) {
            return -47;
        }
        int bytesRead = 0;
        this.flush();
        try {
            block30: {
                if (this.lineSequential) {
                    int bytesStored = 0;
                    int ch = 0;
                    boolean finished = false;
                    boolean escaped = false;
                    boolean eof = false;
                    try {
                        do {
                            if ((ch = is.read()) < 0) {
                                finished = true;
                                eof = true;
                                continue;
                            }
                            if (ch == 0 && !escaped) {
                                escaped = true;
                                continue;
                            }
                            if (!escaped) {
                                switch (ch) {
                                    case 13: {
                                        break;
                                    }
                                    case 10: {
                                        finished = true;
                                        break;
                                    }
                                    case 26: {
                                        finished = true;
                                        eof = true;
                                        break;
                                    }
                                    default: {
                                        if (bytesStored < length) {
                                            data[offset + bytesStored] = (byte)(ch & 0xFF);
                                            ++bytesStored;
                                            break;
                                        } else {
                                            break;
                                        }
                                    }
                                }
                            } else if (bytesStored < length) {
                                data[offset + bytesStored] = (byte)(ch & 0xFF);
                                ++bytesStored;
                            }
                            escaped = false;
                        } while (!finished);
                    }
                    catch (Exception eofException) {
                        eof = true;
                    }
                    for (int i = bytesStored; i < length; ++i) {
                        data[offset + i] = Variable.SPACE_BYTE;
                    }
                    return eof ? -10 : bytesStored;
                }
                bytesRead = 0;
                int chunk = 0;
                if (this.MAX_LENGTH <= 0) {
                    try {
                        while ((chunk = is.read(data, offset, length)) > 0) {
                            offset += chunk;
                            if ((bytesRead += chunk) < (length -= chunk)) continue;
                        }
                    }
                    catch (Exception endOfFile) {
                        bytesRead = -1;
                    }
                } else {
                    try {
                        while (length > this.MAX_LENGTH && (chunk = is.read(data, offset, this.MAX_LENGTH)) > 0) {
                            offset += chunk;
                            length -= chunk;
                            bytesRead += chunk;
                        }
                        if (length <= 0) break block30;
                        while ((chunk = is.read(data, offset, length)) > 0) {
                            offset += chunk;
                            if ((bytesRead += chunk) < (length -= chunk)) continue;
                            break;
                        }
                    }
                    catch (Exception e) {
                        bytesRead = -1;
                    }
                }
            }
            return bytesRead <= 0 ? -10 : bytesRead;
        }
        catch (Exception permanentError) {
            return -10;
        }
    }

    @Override
    public final int close(int mode) {
        SocketGroup group = this.getSocketGroup();
        if (group == null) {
            return -30;
        }
        group.open = false;
        this.removeSocketGroup();
        if (group.socket != null) {
            try {
                group.socket.close();
            }
            catch (Exception e) {
                return -30;
            }
        }
        if ((mode & 0x10) != 0) {
            try {
                if (this.ssocket != null) {
                    this.ssocket.close();
                    this.ssocket = null;
                }
            }
            catch (Exception e) {
                return -30;
            }
        }
        return 0;
    }

    @Override
    public final int open(int mode) {
        try {
            SocketGroup group = this.getSocketGroup();
            if (group == null) {
                group = new SocketGroup();
                this.setSocketGroup(group);
            } else if (group.open) {
                return -41;
            }
            if (this.ssocket != null) {
                group.socket = this.ssocket.accept();
                group.is = new DataInputStream(group.socket.getInputStream());
                group.os = new DataOutputStream(group.socket.getOutputStream());
                group.open = true;
                return 0;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return -30;
    }

    @Override
    public final long getFilePointer() {
        return -90L;
    }

    @Override
    public final int seek(long position) {
        return -90;
    }

    @Override
    public final long length() {
        return -90L;
    }

    @Override
    public final int backup() {
        return 0;
    }

    @Override
    public final boolean isStream() {
        return true;
    }

    @Override
    public final boolean isReadable() {
        return this.readable;
    }

    @Override
    public final boolean isWritable() {
        return this.writable;
    }

    @Override
    public final boolean isSeekable() {
        return false;
    }

    @Override
    public final boolean isOpen() {
        SocketGroup group = this.getSocketGroup();
        if (group != null) {
            return group.open;
        }
        return false;
    }

    @Override
    public final int readLock(long offset, int length) {
        return 0;
    }

    @Override
    public final boolean readUnlock(long offset, int length) {
        return true;
    }

    @Override
    public final boolean readUnlock(int handle) {
        return true;
    }

    @Override
    public final int writeLock(long offset, int length) {
        return 0;
    }

    @Override
    public final boolean writeUnlock(long offset, int length) {
        return true;
    }

    @Override
    public final boolean writeUnlock(int handle) {
        return true;
    }

    private SocketGroup getSocketGroup() {
        SocketGroup s;
        Thread t = Thread.currentThread();
        SocketGroup o = this.socketMapping.get(t);
        try {
            s = o;
        }
        catch (Exception e) {
            s = null;
        }
        return s;
    }

    private void removeSocketGroup() {
        Thread t = Thread.currentThread();
        this.socketMapping.remove(t);
    }

    private void setSocketGroup(SocketGroup s) {
        Thread t = Thread.currentThread();
        this.socketMapping.put(t, s);
    }

    @Override
    public final Object getObject() {
        Socket socket2;
        SocketGroup group = this.getSocketGroup();
        if (group != null && (socket2 = group.socket) != null) {
            return socket2;
        }
        return this.ssocket;
    }

    @Override
    public void flush() {
        try {
            SocketGroup group = this.getSocketGroup();
            if (group == null) {
                return;
            }
            if (group.os != null) {
                group.os.flush();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class SocketGroup {
        public Socket socket;
        public DataInputStream is;
        public DataOutputStream os;
        public boolean open;

        private SocketGroup() {
        }
    }
}

