/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec.fileprotocol;

import com.heirloomcomputing.ecs.exec.FileConstants;
import com.heirloomcomputing.ecs.exec.FileProtocol;
import com.heirloomcomputing.ecs.exec.Variable;
import com.sun.net.ssl.internal.ssl.Provider;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.Security;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;

public class sslserver
implements FileProtocol,
FileConstants {
    private String filename;
    private boolean readable = true;
    private boolean writable = true;
    private boolean lineSequential;
    private SSLServerSocket ssocket;
    private String[] cipherSuites;
    private int enableSessionCreation = -1;
    private int needClientAuth = -1;
    private int useClientMode = -1;
    private int port = -1;
    private int MAX_LENGTH = -1;
    private static boolean alreadyInited;
    private Hashtable<Thread, SocketGroup> socketMapping = new Hashtable();

    private static void addProvider() {
        try {
            Security.addProvider((java.security.Provider)new Provider());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            String currentHandler = System.getProperty("java.protocol.handler.pkgs");
            if (currentHandler == null) {
                Properties p = System.getProperties();
                p.put("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");
                System.setProperties(p);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setBuffering(boolean in, boolean out) {
    }

    @Override
    public void setBlockSize(int size) {
        this.MAX_LENGTH = size > 0 ? size : -1;
    }

    public void setOpenSleep(int value) {
    }

    public static final String getProtocol() {
        return "sslserver";
    }

    private String extract(String option) {
        if (option == null) {
            return null;
        }
        String part = null;
        int optionLength = option.length();
        int index = this.filename.indexOf(option);
        int finalIndex = -1;
        if (index >= 0) {
            finalIndex = this.filename.indexOf(47, index + 1);
            if (finalIndex >= 0) {
                part = this.filename.substring(index + optionLength, finalIndex);
                this.filename = this.filename.substring(0, index) + this.filename.substring(finalIndex);
            } else {
                part = this.filename.substring(index + optionLength);
                this.filename = this.filename.substring(0, index);
            }
        }
        if (part != null) {
            part = part.trim();
        }
        return part;
    }

    private void setFilename(String paramFilename) {
        boolean reduce = true;
        while (reduce) {
            reduce = false;
            if ((paramFilename = paramFilename.trim()).toUpperCase().startsWith("SSLSERVER:")) {
                paramFilename = paramFilename.substring(10);
                reduce = true;
            }
            if (paramFilename.toUpperCase().startsWith("SERVER:")) {
                paramFilename = paramFilename.substring(7);
                reduce = true;
            }
            if (!paramFilename.startsWith("//")) continue;
            paramFilename = paramFilename.substring(2);
            reduce = true;
        }
        int index = -1;
        String part = null;
        Vector<String> cipherSuitesVector = null;
        this.filename = paramFilename;
        reduce = true;
        while (reduce) {
            reduce = false;
            part = this.extract("/cipher-suite=");
            if (part != null) {
                reduce = true;
                if (part.length() > 0) {
                    if (cipherSuitesVector == null) {
                        cipherSuitesVector = new Vector<String>();
                    }
                    cipherSuitesVector.addElement(part);
                }
            }
            if ((part = this.extract("/enable-session-creation=")) != null) {
                reduce = true;
                if (part.length() > 0) {
                    this.enableSessionCreation = part.toUpperCase().startsWith("T") ? 1 : 0;
                }
            }
            if ((part = this.extract("/need-client-auth=")) != null) {
                reduce = true;
                if (part.length() > 0) {
                    this.needClientAuth = part.toUpperCase().startsWith("T") ? 1 : 0;
                }
            }
            if ((part = this.extract("/use-client-mode=")) != null) {
                reduce = true;
                if (part.length() > 0) {
                    this.useClientMode = part.toUpperCase().startsWith("T") ? 1 : 0;
                }
            }
            if ((part = this.extract("/port=")) == null) continue;
            reduce = true;
            try {
                this.port = Integer.parseInt(part);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (cipherSuitesVector != null && cipherSuitesVector.size() > 0) {
            int size = cipherSuitesVector.size();
            this.cipherSuites = new String[size];
            for (int i = 0; i < size; ++i) {
                this.cipherSuites[i] = (String)cipherSuitesVector.elementAt(i);
            }
        }
        if ((index = this.filename.indexOf(58)) >= 0) {
            try {
                this.port = Integer.valueOf(this.filename.substring(index + 1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.filename = this.filename.substring(0, index);
        } else {
            try {
                this.port = Integer.parseInt(this.filename);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    public final boolean init(String passFilename, boolean lineSequential) {
        if (alreadyInited) {
            return false;
        }
        alreadyInited = true;
        boolean result = true;
        this.readable = true;
        this.writable = true;
        this.lineSequential = lineSequential;
        try {
            if (passFilename != null) {
                this.setFilename(passFilename);
            }
            if (this.ssocket != null) {
                this.ssocket.close();
                this.ssocket = null;
            }
            this.ssocket = (SSLServerSocket)SSLServerSocketFactory.getDefault().createServerSocket(this.port);
            try {
                if (this.cipherSuites != null) {
                    this.ssocket.setEnabledCipherSuites(this.cipherSuites);
                }
            }
            catch (Exception e) {
                result = false;
            }
            try {
                if (this.enableSessionCreation == 0) {
                    this.ssocket.setEnableSessionCreation(false);
                } else if (this.enableSessionCreation == 1) {
                    this.ssocket.setEnableSessionCreation(true);
                }
            }
            catch (Exception e) {
                result = false;
            }
            try {
                if (this.needClientAuth == 0) {
                    this.ssocket.setNeedClientAuth(false);
                } else if (this.needClientAuth == 1) {
                    this.ssocket.setNeedClientAuth(true);
                }
            }
            catch (Exception e) {
                result = false;
            }
            try {
                if (this.useClientMode == 0) {
                    this.ssocket.setUseClientMode(false);
                } else if (this.useClientMode == 1) {
                    this.ssocket.setUseClientMode(true);
                }
            }
            catch (Exception e) {
                result = false;
            }
        }
        catch (Exception t) {
            result = false;
        }
        return result;
    }

    @Override
    public final void setLineSequential(boolean state) {
        this.lineSequential = state;
    }

    @Override
    public int write(byte[] data, int offset, int length) {
        if (!this.isOpen()) {
            return -48;
        }
        if (!this.isWritable()) {
            return -48;
        }
        SocketGroup group = this.getSocketGroup();
        if (group == null) {
            return -48;
        }
        DataOutputStream os = group.os;
        if (os == null) {
            return -48;
        }
        try {
            if (this.MAX_LENGTH <= 0) {
                os.write(data, offset, length);
                this.flush();
            } else {
                while (length > this.MAX_LENGTH) {
                    os.write(data, offset, this.MAX_LENGTH);
                    offset += this.MAX_LENGTH;
                    length -= this.MAX_LENGTH;
                    this.flush();
                }
                if (length > 0) {
                    os.write(data, offset, length);
                    this.flush();
                }
            }
            return 0;
        }
        catch (IOException e) {
            return -93;
        }
    }

    @Override
    public int read(byte[] data, int offset, int length) {
        if (!this.isOpen()) {
            return -47;
        }
        SocketGroup group = this.getSocketGroup();
        if (group == null) {
            return -47;
        }
        DataInputStream is = group.is;
        if (is == null) {
            return -47;
        }
        int bytesRead = 0;
        this.flush();
        try {
            block30: {
                if (this.lineSequential) {
                    int bytesStored = 0;
                    int ch = 0;
                    boolean finished = false;
                    boolean escaped = false;
                    boolean eof = false;
                    try {
                        do {
                            if ((ch = is.read()) < 0) {
                                finished = true;
                                eof = true;
                                continue;
                            }
                            if (ch == 0 && !escaped) {
                                escaped = true;
                                continue;
                            }
                            if (!escaped) {
                                switch (ch) {
                                    case 13: {
                                        break;
                                    }
                                    case 10: {
                                        finished = true;
                                        break;
                                    }
                                    case 26: {
                                        finished = true;
                                        eof = true;
                                        break;
                                    }
                                    default: {
                                        if (bytesStored < length) {
                                            data[offset + bytesStored] = (byte)(ch & 0xFF);
                                            ++bytesStored;
                                            break;
                                        } else {
                                            break;
                                        }
                                    }
                                }
                            } else if (bytesStored < length) {
                                data[offset + bytesStored] = (byte)(ch & 0xFF);
                                ++bytesStored;
                            }
                            escaped = false;
                        } while (!finished);
                    }
                    catch (Exception eofException) {
                        eof = true;
                    }
                    for (int i = bytesStored; i < length; ++i) {
                        data[offset + i] = Variable.SPACE_BYTE;
                    }
                    return eof ? -10 : bytesStored;
                }
                bytesRead = 0;
                int chunk = 0;
                if (this.MAX_LENGTH <= 0) {
                    try {
                        while ((chunk = is.read(data, offset, length)) > 0) {
                            offset += chunk;
                            if ((bytesRead += chunk) < (length -= chunk)) continue;
                        }
                    }
                    catch (Exception endOfFile) {
                        bytesRead = -1;
                    }
                } else {
                    try {
                        while (length > this.MAX_LENGTH && (chunk = is.read(data, offset, this.MAX_LENGTH)) > 0) {
                            offset += chunk;
                            length -= chunk;
                            bytesRead += chunk;
                        }
                        if (length <= 0) break block30;
                        while ((chunk = is.read(data, offset, length)) > 0) {
                            offset += chunk;
                            if ((bytesRead += chunk) < (length -= chunk)) continue;
                            break;
                        }
                    }
                    catch (Exception e) {
                        bytesRead = -1;
                    }
                }
            }
            return bytesRead <= 0 ? -10 : bytesRead;
        }
        catch (Exception permanentError) {
            return -10;
        }
    }

    @Override
    public final int close(int mode) {
        SocketGroup group = this.getSocketGroup();
        if (group == null) {
            return -30;
        }
        group.open = false;
        this.removeSocketGroup();
        if (group.socket != null) {
            try {
                group.socket.close();
            }
            catch (Exception e) {
                return -30;
            }
        }
        if ((mode & 0x10) != 0) {
            try {
                if (this.ssocket != null) {
                    this.ssocket.close();
                    this.ssocket = null;
                }
            }
            catch (Exception e) {
                return -30;
            }
        }
        return 0;
    }

    @Override
    public final int open(int mode) {
        block7: {
            try {
                SocketGroup group = this.getSocketGroup();
                if (group == null) {
                    group = new SocketGroup();
                    this.setSocketGroup(group);
                } else if (group.open) {
                    return -41;
                }
                if (this.ssocket == null) break block7;
                try {
                    group.socket = (SSLSocket)this.ssocket.accept();
                    group.is = new DataInputStream(group.socket.getInputStream());
                    group.os = new DataOutputStream(group.socket.getOutputStream());
                    group.open = true;
                }
                catch (Exception e) {
                    return -30;
                }
                return 0;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return -30;
    }

    @Override
    public final long getFilePointer() {
        return -90L;
    }

    @Override
    public final int seek(long position) {
        return -90;
    }

    @Override
    public final long length() {
        return -90L;
    }

    @Override
    public final int backup() {
        return 0;
    }

    @Override
    public final boolean isStream() {
        return true;
    }

    @Override
    public final boolean isReadable() {
        return this.readable;
    }

    @Override
    public final boolean isWritable() {
        return this.writable;
    }

    @Override
    public final boolean isSeekable() {
        return false;
    }

    @Override
    public final boolean isOpen() {
        boolean result = false;
        SocketGroup group = this.getSocketGroup();
        if (group != null) {
            result = group.open;
        }
        return result;
    }

    @Override
    public final int readLock(long offset, int length) {
        return 0;
    }

    @Override
    public final boolean readUnlock(long offset, int length) {
        return true;
    }

    @Override
    public final boolean readUnlock(int handle) {
        return true;
    }

    @Override
    public final int writeLock(long offset, int length) {
        return 0;
    }

    @Override
    public final boolean writeUnlock(long offset, int length) {
        return true;
    }

    @Override
    public final boolean writeUnlock(int handle) {
        return true;
    }

    private SocketGroup getSocketGroup() {
        SocketGroup s;
        Thread t = Thread.currentThread();
        SocketGroup o = this.socketMapping.get(t);
        try {
            s = o;
        }
        catch (Exception e) {
            s = null;
        }
        return s;
    }

    private void removeSocketGroup() {
        this.socketMapping.remove(Thread.currentThread());
    }

    private void setSocketGroup(SocketGroup s) {
        this.socketMapping.put(Thread.currentThread(), s);
    }

    @Override
    public final Object getObject() {
        SSLSocket socket2;
        SocketGroup group = this.getSocketGroup();
        if (group != null && (socket2 = group.socket) != null) {
            return socket2;
        }
        return this.ssocket;
    }

    @Override
    public void flush() {
        try {
            SocketGroup group = this.getSocketGroup();
            if (group == null) {
                return;
            }
            if (group.os != null) {
                group.os.flush();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        sslserver.addProvider();
        alreadyInited = false;
    }

    private class SocketGroup {
        public SSLSocket socket;
        public DataInputStream is;
        public DataOutputStream os;
        public boolean open;

        private SocketGroup() {
        }
    }
}

