/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.CobolException;
import com.heirloomcomputing.ecs.exec.Context;
import com.heirloomcomputing.ecs.exec.IndexedFile;
import com.heirloomcomputing.ecs.exec.LockFile;
import com.heirloomcomputing.ecs.exec.LogSetup;
import com.heirloomcomputing.ecs.exec.MFFile;
import com.heirloomcomputing.ecs.exec.Numeric;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.SynkronixIndexedFile;
import com.heirloomcomputing.ecs.exec.Utilities;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.exec.VariableList;
import com.heirloomcomputing.ecs.exec.basicFile;
import java.util.Hashtable;

public class idxFile
extends basicFile {
    private static final String PGM = "idxFile";
    private Variable fileStatus2 = null;
    private boolean defaultMicroFocus = false;
    private boolean defaultAConnect = false;
    private boolean defaultISAM = false;
    private boolean defaultACU = false;
    private boolean defaultAS400 = false;
    private boolean defaultUpdated = false;
    private boolean noOps = false;
    private static Hashtable<String, Class<?>> bufferedClasses = new Hashtable();
    private static final String[] supportedTypesClasses = new String[]{"com.heirloomcomputing.ecs.exec.SynkronixIndexedFile", "com.heirloomcomputing.ecs.exec.SynkronixIndexedFile", "com.heirloomcomputing.ecs.exec.SynkronixIndexedFile", "com.heirloomcomputing.ecs.exec.SynkronixIndexedFile", "com.heirloomcomputing.ecs.exec.MFIndexedFile", "com.heirloomcomputing.ecs.exec.MFIndexedFile", "com.heirloomcomputing.ecs.exec.MFIndexedFile", "com.heirloomcomputing.ecs.exec.MFIndexedFile", "com.heirloomcomputing.ecs.exec.MFIndexedFile", "com.heirloomcomputing.ecs.exec.AConnectIndexedFile", "com.heirloomcomputing.ecs.exec.AS400IndexedFile", "com.heirloomcomputing.ecs.exec.ISAMIndexedFile", "com.heirloomcomputing.ecs.exec.ISAMIndexedFile", "com.heirloomcomputing.ecs.exec.ISAMIndexedFile", "com.heirloomcomputing.ecs.exec.ISAMIndexedFile", "com.heirloomcomputing.ecs.exec.ISAMIndexedFile", "com.heirloomcomputing.ecs.exec.ISAMIndexedFile", "com.heirloomcomputing.ecs.exec.ISAMIndexedFile", "com.heirloomcomputing.ecs.exec.ACUIndexedFile", "com.heirloomcomputing.ecs.exec.ACUIndexedFile", "com.heirloomcomputing.ecs.exec.ACUIndexedFile", "com.heirloomcomputing.ecs.exec.ACUIndexedFile", "com.heirloomcomputing.ecs.exec.ACUIndexedFile", "com.heirloomcomputing.ecs.exec.ACUIndexedFile"};
    private static final String[] supportedTypes = new String[]{"EC", "EISAM", "E-ISAM", "E_ISAM", "MF", "MFU", "MFW", "MF3", "MF8", "ACON", "AS400", "ISAM", "CISAM", "C-ISAM", "C_ISAM", "DISAM", "D-ISAM", "D_ISAM", "ACU", "ACUCOBOL", "VIS4", "VISION4", "VIS", "VISION"};
    private String protocol = null;
    private boolean remote = false;
    private int port;
    private String site;
    private IndexedFile file = null;
    private idxFile externalFile = null;
    private Variable filenameVariable = null;
    private boolean optional;
    protected String assignTo;
    private int reserve;
    private Variable fileStatus;
    private int accessMode;
    private int blockFrom;
    private int blockTo;
    private boolean isRecords;
    private int recordFrom;
    private int recordTo;
    protected Variable dependingOn;
    private int newModes = 0;
    private int numberOfKeys = 0;
    private Variable[] keyArray = new Variable[256];
    private boolean[] keyDuplicates = new boolean[256];
    private int keyCompression = 0;
    private int dataCompression = 0;
    private boolean dataEncryption = false;
    private int idxFormat = 3;

    public static void debug(String text) {
        LogSetup.LOGGER.finer("idxFile: " + text);
    }

    public idxFile setDuplicatePrimary() {
        throw new RuntimeException("Duplicate primary keys are not supported");
    }

    public idxFile setFileStatus2(Variable v) {
        this.fileStatus2 = v;
        return this;
    }

    public idxFile setFileStatus3(Variable v) {
        return this;
    }

    private void updateDefaultFileSystems() {
        if (this.defaultUpdated) {
            return;
        }
        this.defaultUpdated = true;
        String s = RuntimeEnvironment.getGlobalParameter("FILESYSTEMIDX");
        if (s == null) {
            s = RuntimeEnvironment.getGlobalParameter("FILESYSTEM");
        }
        if (s != null) {
            if ((s = s.toUpperCase()).equalsIgnoreCase("MF")) {
                this.defaultMicroFocus = true;
                this.idxFormat = 3;
            } else if (s.equalsIgnoreCase("MFU")) {
                this.defaultMicroFocus = true;
                this.idxFormat = 3;
            } else if (s.equalsIgnoreCase("MFW")) {
                this.defaultMicroFocus = true;
                this.idxFormat = 3;
            } else if (s.equalsIgnoreCase("MF3")) {
                this.defaultMicroFocus = true;
                this.idxFormat = 3;
            } else if (s.equalsIgnoreCase("MF8")) {
                this.defaultMicroFocus = true;
                this.idxFormat = 8;
            } else if (s.equalsIgnoreCase("MICROFOCUS")) {
                this.defaultMicroFocus = true;
                this.idxFormat = 3;
            } else if (s.equalsIgnoreCase("MERANT")) {
                this.defaultMicroFocus = true;
                this.idxFormat = 3;
            } else if (s.equalsIgnoreCase("ACON")) {
                this.defaultAConnect = true;
            } else if (s.equalsIgnoreCase("ACONNECT")) {
                this.defaultAConnect = true;
            } else if (s.equalsIgnoreCase("ACUCONNECT")) {
                this.defaultAConnect = true;
            } else if (s.equalsIgnoreCase("AS400")) {
                this.defaultAS400 = true;
            } else if (s.equalsIgnoreCase("OS400")) {
                this.defaultAS400 = true;
            } else if (s.equalsIgnoreCase("ISAM")) {
                this.defaultISAM = true;
            } else if (s.equalsIgnoreCase("CISAM")) {
                this.defaultISAM = true;
            } else if (s.equalsIgnoreCase("C-ISAM")) {
                this.defaultISAM = true;
            } else if (s.equalsIgnoreCase("C_ISAM")) {
                this.defaultISAM = true;
            } else if (s.equalsIgnoreCase("DISAM")) {
                this.defaultISAM = true;
            } else if (s.equalsIgnoreCase("D-ISAM")) {
                this.defaultISAM = true;
            } else if (s.equalsIgnoreCase("D_ISAM")) {
                this.defaultISAM = true;
            } else if (s.equalsIgnoreCase("ACU")) {
                this.defaultACU = true;
            } else if (s.equalsIgnoreCase("ACUCOBOL")) {
                this.defaultACU = true;
            } else if (s.equalsIgnoreCase("VIS4")) {
                this.defaultACU = true;
            } else if (s.equalsIgnoreCase("VISION4")) {
                this.defaultACU = true;
            } else if (s.equalsIgnoreCase("VIS")) {
                this.defaultACU = true;
            } else if (s.equalsIgnoreCase("VISION")) {
                this.defaultACU = true;
            }
        }
        MFFile.InitCompression();
    }

    private void sortKeys() {
        String envname;
        boolean ignoreDefault = false;
        String fname = this.filenameVariable != null ? this.filenameVariable.toString() : this.assignTo;
        if (fname == null || fname.trim().isEmpty()) {
            return;
        }
        if (fname.toLowerCase().startsWith("env:") && (fname = RuntimeEnvironment.getGlobalParameter(envname = fname.substring(4).trim())) == null) {
            fname = envname;
        }
        for (int i = 0; i < supportedTypes.length; ++i) {
            if (!fname.startsWith(supportedTypes[i] + ":")) continue;
            ignoreDefault = true;
            break;
        }
        if (fname.startsWith("MF:") || fname.startsWith("MFU:") || fname.startsWith("MFW:") || fname.startsWith("MF3:") || fname.startsWith("MF8:") || fname.startsWith("MICROFOCUS:") || fname.startsWith("MERANT:") || !ignoreDefault && this.defaultMicroFocus) {
            return;
        }
        if (this.numberOfKeys < 3) {
            return;
        }
        if (fname.startsWith("ACU:") || !ignoreDefault && this.defaultACU) {
            boolean flag = true;
            while (flag) {
                flag = false;
                for (int j = 1; j < this.numberOfKeys - 1; ++j) {
                    int addressj1;
                    int addressj = this.keyArray[j] instanceof VariableList ? ((VariableList)this.keyArray[j]).getList()[0].getAddress() : this.keyArray[j].getAddress();
                    int n = addressj1 = this.keyArray[j + 1] instanceof VariableList ? ((VariableList)this.keyArray[j + 1]).getList()[0].getAddress() : this.keyArray[j + 1].getAddress();
                    if (addressj <= addressj1) continue;
                    Variable tempVar = this.keyArray[j];
                    this.keyArray[j] = this.keyArray[j + 1];
                    this.keyArray[j + 1] = tempVar;
                    boolean tempBool = this.keyDuplicates[j];
                    this.keyDuplicates[j] = this.keyDuplicates[j + 1];
                    this.keyDuplicates[j + 1] = tempBool;
                    flag = true;
                }
            }
            return;
        }
        for (int A = 1; A < this.numberOfKeys - 1; ++A) {
            for (int B = A + 1; B < this.numberOfKeys; ++B) {
                boolean AisVL = this.keyArray[A] instanceof VariableList;
                boolean BisVL = this.keyArray[B] instanceof VariableList;
                if ((!AisVL || BisVL) && this.keyArray[B].getAddress() >= this.keyArray[A].getAddress()) continue;
                Variable tempVar = this.keyArray[B];
                this.keyArray[B] = this.keyArray[A];
                this.keyArray[A] = tempVar;
                boolean tempBool = this.keyDuplicates[B];
                this.keyDuplicates[B] = this.keyDuplicates[A];
                this.keyDuplicates[A] = tempBool;
            }
        }
    }

    @Override
    public String getFilename() {
        String filename = "";
        filename = this.filenameVariable != null ? this.filenameVariable.toString() : this.assignTo;
        if (filename != null) {
            filename = filename.trim();
        }
        return filename;
    }

    public void setFilename(String filename) {
        this.assignTo = filename;
    }

    private String getFilteredFilename() {
        String filename = "";
        filename = this.filenameVariable != null ? this.filenameVariable.toString() : this.aliasFilename(this.assignTo);
        return this.filterFilename(filename);
    }

    private String getAConnectFilename(String filename) {
        if (filename == null || filename.trim().length() == 0) {
            return null;
        }
        if (filename.trim().charAt(0) == '@') {
            return filename;
        }
        String name = RuntimeEnvironment.getGlobalParameter(filename);
        if (name == null || name.trim().length() == 0) {
            return null;
        }
        if (name.trim().charAt(0) == '@') {
            return name;
        }
        return null;
    }

    private String filterFilename(String filename) {
        if (filename == null) {
            return null;
        }
        String func = "idxFile.filterFilename(): ";
        String origFilename = filename;
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer("idxFile.filterFilename(): 0. filename=" + filename + ". ");
        }
        if (filename != null) {
            filename = filename.trim();
        }
        String newFilename = null;
        String temp = this.getAConnectFilename(filename);
        if (temp != null) {
            filename = temp;
            this.protocol = "ACON";
        } else {
            if (filename.toLowerCase().startsWith("env:")) {
                String envname = filename.substring(4).trim();
                if ((filename = RuntimeEnvironment.getGlobalParameter(envname)) == null) {
                    filename = envname;
                }
            } else {
                newFilename = RuntimeEnvironment.getGlobalParameter(filename);
                if (newFilename != null) {
                    filename = newFilename;
                }
                if (filename.startsWith("\"") && filename.endsWith("\"")) {
                    filename = filename.substring(1, filename.length() - 1);
                }
            }
            if (this.defaultAConnect) {
                filename = this.filterRemote(filename);
                filename = this.filterProtocol(filename);
                this.protocol = "ACON";
                this.remote = false;
                String portNum = RuntimeEnvironment.getGlobalParameter("SERVER_PORT");
                if (portNum == null) {
                    try {
                        if (this.port > 0) {
                            RuntimeEnvironment.setGlobalParameter("SERVER_PORT", String.valueOf(this.port));
                        }
                    }
                    catch (Exception exception) {}
                } else {
                    int myPort = 0;
                    try {
                        myPort = Integer.valueOf(portNum);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (myPort > 0) {
                        if (this.port <= 0) {
                            this.port = myPort;
                        } else if (this.port != myPort) {
                            this.port = myPort;
                        }
                    } else {
                        try {
                            if (this.port > 0) {
                                RuntimeEnvironment.setGlobalParameter("SERVER_PORT", String.valueOf(this.port));
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                filename = '@' + this.site + ":" + filename;
            } else {
                filename = this.filterRemote(filename);
                filename = this.filterProtocol(filename);
            }
        }
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer("idxFile.filterFilename(): last. origFilename=" + origFilename + ". FINAL filename=" + filename + ". ");
        }
        return filename;
    }

    private boolean isAS400Connection() {
        try {
            String osName = System.getProperty("os.name").toUpperCase().trim();
            if (osName.indexOf("OS/400") >= 0 || osName.indexOf("OS400") >= 0 || osName.indexOf("ISERIES") >= 0) {
                return true;
            }
            return RuntimeEnvironment.getGlobalParameter("AS400CONNECT_SERVER") != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private String filterProtocol(String filename) {
        if (filename == null) {
            return null;
        }
        String[] splits = filename.split("[_-]");
        String dispMod = RuntimeEnvironment.getGlobalParameter(splits[splits.length - 1] + ".disp");
        if (dispMod != null && dispMod.equalsIgnoreCase("mod")) {
            this.forceExtend = true;
        }
        this.protocol = null;
        int index = filename.indexOf(58);
        if (index >= 2) {
            this.protocol = filename.substring(0, index);
            filename = index < filename.length() - 1 ? filename.substring(index + 1) : "";
        } else {
            char ch;
            if (filename.length() > 9 && ((ch = filename.charAt(8)) == '_' || ch == '-') && filename.toUpperCase().startsWith("DATABASE") && this.isAS400Connection()) {
                this.protocol = "AS400";
                filename = filename.substring(9);
            }
            if (filename.length() > 5 && ((ch = filename.charAt(4)) == '_' || ch == '-') && filename.toUpperCase().startsWith("DISK") && this.isAS400Connection()) {
                this.protocol = "AS400";
                filename = filename.substring(5);
            }
        }
        return filename;
    }

    private String filterRemote(String filename) {
        if (filename == null) {
            return null;
        }
        if ((filename = filename.trim()).toLowerCase().startsWith("remote:")) {
            int index = 7;
            if (index >= filename.length()) {
                return "";
            }
            filename = filename.substring(index);
            filename = this.setRemote(filename);
        }
        return filename;
    }

    private String setRemote(String filename) {
        if (filename == null) {
            return null;
        }
        this.remote = true;
        this.filenameVariable = null;
        this.site = null;
        int index = filename.indexOf(58);
        if (index >= 0) {
            this.site = filename.substring(0, index);
            filename = index < filename.length() - 1 ? filename.substring(index + 1) : "";
        }
        if (this.site == null) {
            try {
                this.site = Utilities.getCodeBase().toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.site == null) {
            this.site = RuntimeEnvironment.getGlobalParameter("REMOTEHOST");
        }
        if (this.site == null) {
            this.site = "127.0.0.1";
        }
        index = filename.indexOf(58);
        this.port = 6584;
        if (index >= 0 && index < filename.length() - 1) {
            try {
                this.port = Integer.decode(filename.substring(0, index));
                filename = filename.substring(index + 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (Context.getGlobalFileCharacter() != '/') {
            int i = 0;
            do {
                if ((i = filename.indexOf(47, i)) < 0) continue;
                filename = filename.substring(0, i - 1) + '/' + filename.substring(i);
                i += 2;
            } while (i >= 0);
            i = 0;
            do {
                if ((i = filename.indexOf(Context.getGlobalFileCharacter(), i)) < 0) continue;
                filename = filename.substring(0, i - 1) + Context.getGlobalFileCharacter() + filename.substring(i + 1);
                ++i;
            } while (i >= 0);
        }
        return filename;
    }

    private int getSupportedType(String protocol) {
        int i;
        if (protocol != null) {
            for (i = 0; i < supportedTypes.length; ++i) {
                if (!protocol.equalsIgnoreCase(supportedTypes[i])) continue;
                if (supportedTypes[i] == "MF8") {
                    this.idxFormat = 8;
                }
                if (supportedTypes[i] == "MF3") {
                    this.idxFormat = 3;
                }
                return i;
            }
        }
        for (i = 0; i < supportedTypes.length; ++i) {
            if (this.defaultMicroFocus && "MF".equalsIgnoreCase(supportedTypes[i])) {
                return i;
            }
            if (this.defaultACU && "ACU".equalsIgnoreCase(supportedTypes[i])) {
                return i;
            }
            if (this.defaultAConnect && "ACON".equalsIgnoreCase(supportedTypes[i])) {
                return i;
            }
            if (this.defaultAS400 && "AS400".equalsIgnoreCase(supportedTypes[i])) {
                return i;
            }
            if (!this.defaultISAM || !"ISAM".equalsIgnoreCase(supportedTypes[i])) continue;
            return i;
        }
        return -1;
    }

    private boolean initFile(String filename) {
        int n;
        this.updateDefaultFileSystems();
        this.file = null;
        if (this.protocol == null) {
            if (this.defaultMicroFocus) {
                this.protocol = "MF";
            } else if (this.defaultACU) {
                this.protocol = "ACU";
            } else if (this.defaultAConnect) {
                this.protocol = "ACON";
            } else if (this.defaultAS400) {
                this.protocol = "AS400";
            } else if (this.defaultISAM) {
                this.protocol = "ISAM";
            }
        }
        if (this.protocol != null && (n = this.getSupportedType(this.protocol)) >= 0) {
            try {
                String cname = supportedTypesClasses[n];
                Class<?> cl = bufferedClasses.get(cname);
                if (cl == null) {
                    cl = Class.forName(cname);
                    if (cl == null) {
                        throw new RuntimeException("File system not supported");
                    }
                    bufferedClasses.put(cname, cl);
                }
                this.file = (IndexedFile)cl.newInstance();
                this.file.setContext(this.context);
            }
            catch (Throwable t) {
                try {
                    CobolException.runtimeError("This version of Elastic COBOL does not support the file system '" + this.protocol + "' specified.", t);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return false;
            }
        }
        if (this.file == null) {
            this.file = new SynkronixIndexedFile();
        }
        if (this.remote && this.protocol != null) {
            filename = this.protocol + ":" + filename;
        }
        return this.file.init(this.remote, this.site, this.port, filename, this.numberOfKeys, this.keyArray, this.keyDuplicates, this.optional, this.reserve, this.fileStatus, this.accessMode, this.blockFrom, this.blockTo, this.isRecords, this.recordFrom, this.recordTo, this.dependingOn, this.newModes, this.keyCompression, this.dataCompression, this.idxFormat, this.dataEncryption);
    }

    public synchronized int getFileMarkerKeyOffset() {
        if (this.file == null) {
            return -1;
        }
        return this.file.getFileMarkerKeyOffset();
    }

    public idxFile setIdxFormat(int format) {
        this.idxFormat = format;
        return this;
    }

    public int getIdxFormat() {
        return this.idxFormat;
    }

    public idxFile setKeyCompress(int factor) {
        this.keyCompression = factor;
        return this;
    }

    public int getKeyCompress() {
        return this.keyCompression;
    }

    public idxFile setDataCompress(int factor) {
        this.dataCompression = factor;
        return this;
    }

    public int getDataCompress() {
        return this.dataCompression;
    }

    public idxFile setDataCompression() {
        this.setDataCompression(1);
        return this;
    }

    public idxFile setDataCompression(int val) {
        this.setDataCompress(val);
        this.setKeyCompress(val);
        return this;
    }

    public int getDataCompression() {
        return this.dataCompression;
    }

    public idxFile setDataEncryption(boolean flag) {
        this.dataEncryption = flag;
        return this;
    }

    public boolean getDataEncryption() {
        return this.dataEncryption;
    }

    public synchronized idxFile declare(boolean optional, Variable filenameVariable, int reserve, Variable fileStatus, int accessMode, Variable recordKey, int blockFrom, int blockTo, boolean isRecords, int recordFrom, int recordTo, Variable dependingOn, int newModes) {
        this.newModes = newModes;
        return this.declare(optional, filenameVariable, reserve, fileStatus, accessMode, recordKey, blockFrom, blockTo, isRecords, recordFrom, recordTo, dependingOn);
    }

    public synchronized idxFile declare(boolean optional, Variable filenameVariable, int reserve, Variable fileStatus, int accessMode, Variable recordKey, int blockFrom, int blockTo, boolean isRecords, int recordFrom, int recordTo, Variable dependingOn) {
        this.filenameVariable = filenameVariable;
        String assignTo = filenameVariable.toString();
        return this.declare(optional, assignTo, reserve, fileStatus, accessMode, recordKey, blockFrom, blockTo, isRecords, recordFrom, recordTo, dependingOn);
    }

    public synchronized idxFile declare(boolean optional, String assignTo, int reserve, Variable fileStatus, int accessMode, Variable recordKey, int blockFrom, int blockTo, boolean isRecords, int recordFrom, int recordTo, Variable dependingOn, int newModes) {
        this.newModes = newModes;
        return this.declare(optional, assignTo, reserve, fileStatus, accessMode, recordKey, blockFrom, blockTo, isRecords, recordFrom, recordTo, dependingOn);
    }

    public String toString() {
        try {
            String linesep = System.getProperty("line.separator");
            if (linesep == null) {
                linesep = "\n";
            }
            StringBuffer result = new StringBuffer();
            result.append("ORGANIZATION IS INDEXED").append(linesep);
            if (this.accessMode == 2) {
                result.append("ACCESS MODE IS RANDOM").append(linesep);
            } else if (this.accessMode == 4) {
                result.append("ACCESS MODE IS DYNAMIC").append(linesep);
            } else if (this.accessMode == 1) {
                result.append("ACCESS MODE IS SEQUENTIAL").append(linesep);
            }
            if (this.optional) {
                result.append("OPTIONAL").append(linesep);
            }
            if (this.filenameVariable != null) {
                result.append("ASSIGN TO ").append(this.filenameVariable.getName()).append("=\"").append(this.filenameVariable.toString().trim()).append("\"").append(linesep);
            } else if (this.file != null) {
                result.append("ASSIGN TO \"").append(this.file.filename).append("\"").append(linesep);
            }
            if (this.isOpen()) {
                result.append("CURRENTLY OPEN").append(linesep);
            } else {
                result.append("CURRENTLY CLOSED").append(linesep);
            }
            if (this.externalFile != null) {
                result.append("EXTERNAL").append(linesep);
            }
            if (this.fileStatus != null) {
                result.append("FILE STATUS IS ").append(this.fileStatus.getName()).append("=").append(this.fileStatus.toDisplayString()).append(linesep);
            } else if (this.file.priorErrorCode < 0) {
                result.append("IMPLICIT FILE STATUS IS ").append(-this.file.priorErrorCode).append(linesep);
            } else {
                result.append("IMPLICIT FILE STATUS IS ").append(this.file.priorErrorCode).append(linesep);
            }
            if (this.fileStatus2 != null) {
                result.append("FILE STATUS 2 IS ").append(this.fileStatus2.getName()).append("=").append(this.fileStatus2.toDisplayString()).append(linesep);
            }
            if (this.recordFrom == this.recordTo) {
                result.append("RECORDING MODE IS FIXED").append(linesep);
            } else {
                result.append("RECORDING MODE IS VARIABLE").append(linesep);
            }
            if (this.dependingOn != null) {
                result.append("DEPENDING ON ").append(this.dependingOn.getName()).append('=').append(this.dependingOn.toInt()).append(linesep);
            }
            if (this.blockFrom != 0 || this.blockTo != 0) {
                String type = null;
                type = this.isRecords ? " RECORDS" : " CHARACTERS";
                if (this.blockFrom >= this.blockTo) {
                    result.append("BLOCK CONTAINS ").append(this.blockFrom).append(type).append(linesep);
                } else {
                    result.append("BLOCK CONTAINS ").append(this.blockFrom).append(" TO ").append(this.blockTo).append(type).append(linesep);
                }
            }
            String prot = "ECOBOL PROTOCOL";
            if (this.defaultMicroFocus) {
                prot = "MICRO FOCUS PROTOCOL";
            }
            if (this.defaultACU) {
                prot = "ACUCOBOL PROTOCOL";
            }
            if (this.defaultISAM) {
                prot = "ISAM PROTOCOL";
            }
            result.append(prot).append(linesep);
            if (this.remote) {
                result.append("IS REMOTE (HOST='" + this.site + "', PORT='" + this.port + "')").append(linesep);
            }
            if (this.recordFrom != -1 || this.recordTo != -1) {
                if (this.recordFrom >= this.recordTo) {
                    result.append("RECORD CONTAINS ").append(this.recordFrom).append(" CHARACTERS").append(linesep);
                } else {
                    result.append("RECORD CONTAINS ").append(this.recordFrom).append(" TO ").append(this.recordTo).append(" CHARACTERS").append(linesep);
                }
            }
            if (this.file.masterRecord != null) {
                result.append("RECORD NAME=").append(this.file.masterRecord.getName()).append(linesep);
                int keyLen = this.file.keyLength[0] > 64 ? 64 : this.file.keyLength[0];
                String masterKey = this.file.masterRecord.toDisplayString().substring(0, keyLen);
                result.append("RECORD KEY =").append(masterKey);
                if (keyLen == 64) {
                    result.append("...");
                }
                result.append(linesep);
                String masterDat = this.file.masterRecord.toDisplayString().substring(this.file.keyLength[0], this.file.keyLength[0] + keyLen);
                result.append("RECORD DATA=").append(masterDat);
                if (keyLen == 64) {
                    result.append("...");
                }
                result.append(linesep);
            }
            return result.toString();
        }
        catch (RuntimeException t) {
            return "INDEXED FILE (LOOKUP EXCEPTION OCCURRED)";
        }
    }

    public synchronized idxFile declare(boolean optional, String assignTo, int reserve, Variable fileStatus, int accessMode, Variable recordKey, int blockFrom, int blockTo, boolean isRecords, int recordFrom, int recordTo, Variable dependingOn) {
        this.optional = optional;
        if (assignTo != null) {
            this.assignTo = assignTo;
        }
        this.reserve = reserve;
        this.fileStatus = fileStatus;
        this.accessMode = accessMode;
        this.keyArray[0] = recordKey;
        this.keyDuplicates[0] = false;
        this.blockFrom = blockFrom;
        this.blockTo = blockTo;
        this.isRecords = isRecords;
        this.recordFrom = recordFrom;
        this.recordTo = recordTo;
        this.dependingOn = dependingOn;
        this.numberOfKeys = recordKey != null ? 1 : 0;
        return this;
    }

    public synchronized idxFile alternateKey(Variable alternateKey, int duplicates) {
        this.keyArray[this.numberOfKeys] = alternateKey;
        this.keyDuplicates[this.numberOfKeys] = duplicates == 512;
        ++this.numberOfKeys;
        return this;
    }

    public synchronized idxFile endDeclare() {
        this.sortKeys();
        if (!this.initFile(this.getFilteredFilename())) {
            this.file = null;
            if (this.fileStatus != null) {
                this.fileStatus.move(-92);
            }
        }
        return this;
    }

    @Override
    public synchronized boolean open(int mode) {
        if (this.file == null) {
            return false;
        }
        if (this.filenameVariable != null) {
            this.sortKeys();
            if (!this.initFile(this.getFilteredFilename())) {
                this.file = null;
                if (this.fileStatus != null) {
                    this.fileStatus.move(-92);
                    return false;
                }
            }
        }
        if ((mode = LockFile.transformOpenMode(mode)) == 2 && this.forceExtend) {
            mode |= 4;
        }
        this.file.setOpenMode(mode);
        try {
            String filename = this.getFilteredFilename();
            if (filename.equalsIgnoreCase("NUL") || filename.equalsIgnoreCase("/dev/null")) {
                this.noOps = true;
                this.iostatus(0);
                return true;
            }
            if (!this.file.setFilename(filename)) {
                return false;
            }
            if (this.optional || this.defaultMicroFocus && (mode & 4) != 0) {
                mode |= 8;
            }
            this.file.setCharsetName(this.dataCharset);
            boolean rc = this.file.open(mode);
            return rc;
        }
        catch (Exception e) {
            CobolException.runtimeError("Error in indexed file OPEN.", (Throwable)e);
            return false;
        }
    }

    public synchronized boolean openTimeoutSeconds(int mode, Numeric timeout) {
        mode = LockFile.transformOpenMode(mode);
        int timeout_mask = 0x2100000;
        mode &= ~timeout_mask;
        double seconds = timeout.toDouble();
        boolean success = false;
        long currentTime = System.currentTimeMillis();
        long finalTime = currentTime + (long)(seconds * 1000.0);
        do {
            this.iostatus(0);
            success = this.open(mode);
            if (success || System.currentTimeMillis() >= finalTime) continue;
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (!success && System.currentTimeMillis() < finalTime);
        return success;
    }

    public synchronized boolean openTimeoutRetries(int mode, Numeric timeout) {
        mode = LockFile.transformOpenMode(mode);
        int timeout_mask = 0x2100000;
        mode &= ~timeout_mask;
        int attempts = timeout.toInt();
        if (attempts < 0) {
            attempts = 0;
        }
        ++attempts;
        boolean success = false;
        do {
            this.iostatus(0);
            success = this.open(mode);
            if (success || --attempts <= 0) continue;
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (!success && attempts > 0);
        return success;
    }

    public synchronized boolean openTimeoutRetries(int mode) {
        mode = LockFile.transformOpenMode(mode);
        mode &= 0xFDEFFFFF;
        boolean success = false;
        do {
            this.iostatus(0);
            success = this.open(mode);
            if (success) continue;
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (!success);
        return success;
    }

    @Override
    public synchronized boolean close() {
        return this.close(0);
    }

    public synchronized boolean close(int mode) {
        if (this.noOps) {
            this.iostatus(0);
            return true;
        }
        if (this.file != null) {
            return this.file.close(mode);
        }
        return false;
    }

    public synchronized boolean start(String format, Variable nullKeyMap, int mode, int keyOffset, byte[] replacementData) {
        return this.start(mode, keyOffset, replacementData);
    }

    public synchronized boolean start(int mode, int keyOffset, byte[] replacementData) {
        if (this.noOps) {
            this.iostatus(0);
            return true;
        }
        try {
            if (this.file != null) {
                return this.file.start(mode, keyOffset, replacementData);
            }
        }
        catch (Throwable t) {
            CobolException.runtimeError("Error in indexed file START.", t);
        }
        return false;
    }

    public synchronized boolean start(String format, Variable nullKeyMap, int mode, int keyOffset) {
        return this.start(mode, keyOffset);
    }

    public synchronized boolean start(int mode, int keyOffset) {
        if (this.noOps) {
            this.iostatus(0);
            return true;
        }
        try {
            if (this.file != null) {
                return this.file.start(mode, keyOffset);
            }
        }
        catch (Throwable t) {
            CobolException.runtimeError("Error in indexed file START.", t);
        }
        return false;
    }

    public synchronized boolean start(String format, Variable nullKeyMap, int mode, Variable currentKey) {
        return this.start(mode, currentKey);
    }

    public synchronized boolean start(int mode, Variable currentKey) {
        if (this.noOps) {
            this.iostatus(0);
            return true;
        }
        try {
            if (this.file != null) {
                return this.file.start(mode, currentKey);
            }
        }
        catch (Throwable t) {
            CobolException.runtimeError("Error in indexed file START.", t);
        }
        return false;
    }

    public synchronized boolean start(String format, Variable nullKeyMap, int mode) {
        return this.start(mode);
    }

    public synchronized boolean start(int mode) {
        if (this.noOps) {
            this.iostatus(0);
            return true;
        }
        try {
            if (this.file != null) {
                return this.file.start(mode);
            }
        }
        catch (Throwable t) {
            CobolException.runtimeError("Error in indexed file START.", t);
        }
        return false;
    }

    public synchronized boolean start(String format, Variable nullKeyMap, Variable currentKey) {
        return this.start(currentKey);
    }

    public synchronized boolean start(Variable currentKey) {
        try {
            return this.start(0, currentKey);
        }
        catch (Throwable t) {
            CobolException.runtimeError("Error in indexed file START.", t);
            return false;
        }
    }

    public synchronized byte[] readNetwork(boolean seqOverride, int keyOffset, byte[] keyData, int mode, double timeout) {
        return this.readNetwork(seqOverride, keyOffset, keyData, mode, timeout, 1);
    }

    public synchronized byte[] readNetwork(boolean seqOverride, int keyOffset, byte[] keyData, int mode, double timeout, int direction) {
        try {
            if (this.file != null) {
                return this.file.read(seqOverride, keyOffset, keyData, mode, timeout, direction);
            }
        }
        catch (Throwable t) {
            CobolException.runtimeError("Error in indexed file remote READ.", t);
        }
        return null;
    }

    public synchronized boolean read(String format, Variable nullKeyMap, Variable nullMap, Variable intoVar, Variable keyIs, int mode, Numeric timeout) {
        return this.read(intoVar, keyIs, mode, timeout);
    }

    public synchronized boolean read(String format, Variable nullKeyMap, Variable nullMap, Variable intoVar, Variable keyIs, int mode, Numeric timeout, boolean genericFromKeyAllowed) {
        return this.read(intoVar, keyIs, mode, timeout);
    }

    public synchronized boolean read(Variable intoVar, Variable keyIs, int mode, Numeric timeout) {
        if (this.noOps) {
            this.iostatus(0);
            return true;
        }
        try {
            double to = 0.0;
            if (timeout != null) {
                to = timeout.toDouble();
            }
            if (this.file != null) {
                return this.file.read(intoVar, keyIs, mode, to);
            }
        }
        catch (Throwable t) {
            CobolException.runtimeError("Error in indexed file READ.", t);
        }
        return false;
    }

    public boolean read(Variable intoVar, Variable keyIs, int mode, Numeric timeout, boolean genericFromKeyAllowed) {
        return this.read(intoVar, keyIs, mode, timeout);
    }

    public synchronized boolean read(String format, Variable nullKeyMap, Variable nullMap, Variable intoVar, Variable keyIs) {
        return this.read(intoVar, keyIs);
    }

    public synchronized boolean read(Variable intoVar, Variable keyIs) {
        return this.read(intoVar, keyIs, 0, null);
    }

    public synchronized boolean read(String format, Variable nullKeyMap, Variable nullMap, Variable intoVar, int mode, Numeric timeout) {
        return this.read(intoVar, mode, timeout);
    }

    public synchronized boolean read(Variable intoVar, int mode, Numeric timeout) {
        if (this.noOps) {
            this.iostatus(0);
            return true;
        }
        try {
            double to = 0.0;
            if (timeout != null) {
                to = timeout.toDouble();
            }
            if (this.file != null) {
                return this.file.read(intoVar, mode, to);
            }
        }
        catch (Throwable t) {
            CobolException.runtimeError("Error in indexed file READ.", t);
        }
        return false;
    }

    public synchronized boolean read(String format, Variable nullKeyMap, Variable nullMap, Variable intoVar) {
        return this.read(intoVar);
    }

    @Override
    public synchronized boolean read(Variable intoVar) {
        return this.read(intoVar, 0, null);
    }

    public synchronized boolean readFirst(String format, Variable nullKeyMap, Variable nullMap, Variable intoVar, int mode, Numeric timeout) {
        return this.readFirst(intoVar, mode, timeout);
    }

    public synchronized boolean readFirst(Variable intoVar, int mode, Numeric timeout) {
        try {
            double to = 0.0;
            if (timeout != null) {
                to = timeout.toDouble();
            }
            if (this.file != null) {
                return this.file.readFirst(intoVar, mode, to);
            }
        }
        catch (Throwable t) {
            CobolException.runtimeError("Error in indexed file READ FIRST.", t);
        }
        return false;
    }

    public synchronized boolean readFirst(String format, Variable nullKeyMap, Variable nullMap, Variable intoVar) {
        return this.readFirst(intoVar);
    }

    public synchronized boolean readFirst(Variable intoVar) {
        return this.readFirst(intoVar, 0, null);
    }

    public synchronized boolean readLast(String format, Variable nullKeyMap, Variable nullMap, Variable intoVar, int mode, Numeric timeout) {
        return this.readLast(intoVar, mode, timeout);
    }

    public synchronized boolean readLast(Variable intoVar, int mode, Numeric timeout) {
        try {
            double to = 0.0;
            if (timeout != null) {
                to = timeout.toDouble();
            }
            if (this.file != null) {
                return this.file.readLast(intoVar, mode, to);
            }
        }
        catch (Throwable t) {
            CobolException.runtimeError("Error in indexed file READ LAST.", t);
        }
        return false;
    }

    public synchronized boolean readLast(String format, Variable nullKeyMap, Variable nullMap, Variable intoVar) {
        return this.readLast(intoVar);
    }

    public synchronized boolean readLast(Variable intoVar) {
        return this.readLast(intoVar, 0, null);
    }

    public synchronized boolean readNext(String format, Variable nullKeyMap, Variable nullMap, Variable intoVar, int mode, Numeric timeout) {
        return this.readNext(intoVar, mode, timeout);
    }

    public synchronized boolean readNext(Variable intoVar, int mode, Numeric timeout, boolean genericFromKeyAllowed) {
        return this.readNext(intoVar, mode, timeout);
    }

    public synchronized boolean readNext(Variable intoVar, int mode, Numeric timeout) {
        if (this.noOps) {
            this.iostatus(0);
            return true;
        }
        try {
            double to = 0.0;
            if (timeout != null) {
                to = timeout.toDouble();
            }
            if (this.file != null) {
                return this.file.readNext(intoVar, mode, to);
            }
        }
        catch (Throwable t) {
            CobolException.runtimeError("Error in indexed file READ NEXT.", t);
        }
        return false;
    }

    public synchronized boolean readNext(String format, Variable nullKeyMap, Variable nullMap, Variable intoVar) {
        return this.readNext(intoVar);
    }

    public synchronized boolean readNext(Variable intoVar) {
        return this.readNext(intoVar, 0, null);
    }

    public synchronized boolean readNext(Variable intoVar, boolean genericFromKeyAllowed) {
        return this.readNext(intoVar, 0, null);
    }

    public synchronized boolean readPrevious(String format, Variable nullKeyMap, Variable nullMap, Variable intoVar, int mode, Numeric timeout) {
        return this.readPrevious(intoVar, mode, timeout);
    }

    public synchronized boolean readPrevious(Variable intoVar, int mode, Numeric timeout) {
        if (this.noOps) {
            this.iostatus(0);
            return true;
        }
        try {
            double to = 0.0;
            if (timeout != null) {
                to = timeout.toDouble();
            }
            if (this.file != null) {
                return this.file.readPrevious(intoVar, mode, to);
            }
        }
        catch (Throwable t) {
            CobolException.runtimeError("Error in indexed file READ PREVIOUS.", t);
        }
        return false;
    }

    public synchronized boolean readPrevious(String format, Variable nullKeyMap, Variable nullMap, Variable intoVar) {
        return this.readPrevious(intoVar);
    }

    public synchronized boolean readPrevious(Variable intoVar) {
        return this.readPrevious(intoVar, 0, null);
    }

    public synchronized boolean writeNetwork(boolean seqOverride, int dependingOnLength, byte[] data, int mode, double timeout) {
        if (this.noOps) {
            this.iostatus(0);
            return true;
        }
        try {
            if (this.file != null) {
                return this.file.write(seqOverride, dependingOnLength, data, mode, timeout);
            }
        }
        catch (Throwable t) {
            CobolException.runtimeError("Error in indexed file remote WRITE.", t);
        }
        return false;
    }

    public boolean write(String format, Variable nullKeyMap, Variable nullMap, Variable fromVar, int mode, Numeric timeout) {
        return this.write(fromVar, mode, timeout);
    }

    public boolean write(Variable fromVar, int mode, Numeric timeout) {
        if (this.noOps) {
            this.iostatus(0);
            return true;
        }
        try {
            double to = 0.0;
            if (timeout != null) {
                to = timeout.toDouble();
            }
            if (this.file != null) {
                return this.file.write(fromVar, mode, to);
            }
        }
        catch (Throwable t) {
            CobolException.runtimeError("Error in indexed file WRITE.", t);
        }
        return false;
    }

    public synchronized boolean write(String format, Variable nullKeyMap, Variable nullMap, Variable fromVar) {
        return this.write(fromVar);
    }

    @Override
    public synchronized boolean write(Variable fromVar) {
        return this.write(fromVar, 0, null);
    }

    public synchronized boolean writeNext(String format, Variable nullKeyMap, Variable nullMap, Variable fromVar) {
        return this.writeNext(fromVar);
    }

    public synchronized boolean writeNext(Variable fromVar) {
        if (this.noOps) {
            this.iostatus(0);
            return true;
        }
        try {
            if (this.file != null) {
                return this.file.writeNext(fromVar);
            }
        }
        catch (Throwable t) {
            CobolException.runtimeError("Error in indexed file WRITE NEXT.", t);
        }
        return false;
    }

    public boolean rewrite(String format, Variable nullKeyMap, Variable nullMap, Variable fromVar, int mode, Numeric timeout) {
        return this.rewrite(fromVar, mode, timeout);
    }

    public boolean rewrite(Variable fromVar, int mode, Numeric timeout) {
        if (this.noOps) {
            this.iostatus(0);
            return true;
        }
        try {
            double to = 0.0;
            if (timeout != null) {
                to = timeout.toDouble();
            }
            if (this.file != null) {
                return this.file.rewrite(fromVar, mode, to);
            }
        }
        catch (Throwable t) {
            CobolException.runtimeError("Error in indexed file REWRITE.", t);
        }
        return false;
    }

    public synchronized boolean rewrite(String format, Variable nullKeyMap, Variable nullMap, Variable fromVar) {
        return this.rewrite(fromVar);
    }

    public synchronized boolean rewrite(Variable fromVar) {
        return this.rewrite(fromVar, 0, null);
    }

    public synchronized boolean rewriteNetwork(int dependingOnLength, byte[] data, int mode, double timeout) {
        try {
            if (this.file != null) {
                return this.file.rewrite(dependingOnLength, data, mode, timeout);
            }
        }
        catch (Throwable t) {
            CobolException.runtimeError("Error in indexed file remote REWRITE.", t);
        }
        return false;
    }

    public boolean delete(String format, Variable nullKeyMap, int mode, Numeric timeout) {
        return this.delete(mode, timeout);
    }

    public boolean delete(int mode, Numeric timeout) {
        if (this.noOps) {
            this.iostatus(0);
            return true;
        }
        try {
            double to = 0.0;
            if (timeout != null) {
                to = timeout.toDouble();
            }
            if (this.file != null) {
                return this.file.delete(mode, to);
            }
        }
        catch (Throwable t) {
            CobolException.runtimeError("Error in indexed file DELETE.", t);
        }
        return false;
    }

    public synchronized boolean delete(String format, Variable nullKeyMap) {
        return this.delete();
    }

    public synchronized boolean delete() {
        return this.delete(0, null);
    }

    public synchronized boolean delete(String format, Variable nullKeyMap, byte[] keyData, int mode, double timeout, boolean generic) {
        return this.delete(keyData, mode, timeout, generic);
    }

    public synchronized boolean delete(byte[] keyData, int mode, double timeout, boolean generic) {
        if (this.noOps) {
            this.iostatus(0);
            return true;
        }
        try {
            if (this.file != null) {
                return this.file.delete(keyData, mode, timeout, generic);
            }
        }
        catch (Throwable t) {
            CobolException.runtimeError("Error in indexed file DELETE.", t);
        }
        return false;
    }

    @Override
    public synchronized void init() {
        try {
            if (this.file != null) {
                this.file.init();
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Override
    public synchronized int priorError() {
        return this.getPriorError();
    }

    public synchronized int getPriorError() {
        if (this.externalFile != null) {
            return this.externalFile.getPriorError();
        }
        if (this.file != null) {
            return this.file.getPriorError();
        }
        return -30;
    }

    public synchronized void setPriorError(int priorError) {
        if (this.externalFile != null) {
            this.externalFile.setPriorError(priorError);
        } else if (this.file != null) {
            this.file.setPriorError(priorError);
        }
    }

    public synchronized int iostatus(int status) {
        return this.setIOStatus(status);
    }

    public synchronized int setIOStatus(int status) {
        if (this.file != null) {
            return this.file.setIOStatus(status);
        }
        return -30;
    }

    public synchronized int iostatus(String x) {
        return this.setIOStatus(x);
    }

    public synchronized int setIOStatus(String x) {
        if (this.file != null) {
            return this.file.setIOStatus(x);
        }
        return -30;
    }

    public synchronized boolean isAtEnd(int returnCode) {
        if (this.file != null) {
            return this.file.isAtEnd(returnCode);
        }
        return true;
    }

    public synchronized boolean isInvalidKey(int returnCode) {
        if (this.file != null) {
            return this.file.isInvalidKey(returnCode);
        }
        return true;
    }

    public synchronized boolean isOK() {
        int priorErrorCode = this.getPriorError();
        return priorErrorCode > -10 && priorErrorCode < 10;
    }

    public boolean useExceptionNotInvalid() {
        int rc = this.getPriorError();
        if (rc < 0) {
            rc = -rc;
        }
        return rc >= 10 && rc != -22 && rc != -23 && rc != -24;
    }

    public synchronized boolean useException() {
        int priorErrorCode = this.getPriorError();
        if (priorErrorCode < 0) {
            priorErrorCode = -priorErrorCode;
        }
        return priorErrorCode >= 10;
    }

    public synchronized int useException(int specific, int input, int output, int io, int extend) {
        if (this.useException()) {
            if (specific >= 0) {
                return specific;
            }
            if (this.isInput()) {
                return input;
            }
            if (this.isOutput()) {
                return output;
            }
            if (this.isIO()) {
                return io;
            }
            if (this.isExtend()) {
                return extend;
            }
        }
        return -1;
    }

    public synchronized int useException(int specific) {
        if (this.useException()) {
            return specific;
        }
        return -1;
    }

    public synchronized int useExceptionNotInvalid(int specific, int input, int output, int io, int extend) {
        if (this.useExceptionNotInvalid()) {
            if (specific >= 0) {
                return specific;
            }
            if (this.isInput()) {
                return input;
            }
            if (this.isOutput()) {
                return output;
            }
            if (this.isIO()) {
                return io;
            }
            if (this.isExtend()) {
                return extend;
            }
        }
        return -1;
    }

    public synchronized int useExceptionNotInvalid(int specific) {
        if (this.useExceptionNotInvalid()) {
            return specific;
        }
        return -1;
    }

    public synchronized boolean useAtEnd() {
        int priorErrorCode = this.getPriorError();
        return priorErrorCode == -10 || priorErrorCode == 10 || priorErrorCode == 14 || priorErrorCode == -14;
    }

    public synchronized int useAtEnd(int specific, int input, int output, int io, int extend) {
        if (this.useAtEnd()) {
            if (specific >= 0) {
                return specific;
            }
            if (this.isInput()) {
                return input;
            }
            if (this.isOutput()) {
                return output;
            }
            if (this.isIO()) {
                return io;
            }
            if (this.isExtend()) {
                return extend;
            }
        }
        return -1;
    }

    public synchronized int useAtEnd(int specific) {
        if (this.useAtEnd() && specific >= 0) {
            return specific;
        }
        return -1;
    }

    public synchronized boolean isOpen() {
        if (this.file == null) {
            return false;
        }
        return this.file.isOpen();
    }

    public synchronized boolean isInput() {
        if (this.file == null) {
            return false;
        }
        return this.file.isInput();
    }

    public synchronized boolean isOutput() {
        if (this.file == null) {
            return false;
        }
        return this.file.isOutput();
    }

    public synchronized boolean isIO() {
        if (this.file == null) {
            return false;
        }
        return this.file.isIO();
    }

    public synchronized boolean isExtend() {
        if (this.file == null) {
            return false;
        }
        return this.file.isExtend();
    }

    public synchronized boolean isWritable() {
        if (this.file == null) {
            return false;
        }
        return this.file.isWritable();
    }

    public synchronized boolean isOptional() {
        if (this.file == null) {
            return false;
        }
        return this.file.isOptional();
    }

    public synchronized boolean isRandom() {
        if (this.file == null) {
            return false;
        }
        return this.file.isRandom();
    }

    public synchronized boolean isDynamic() {
        if (this.file == null) {
            return false;
        }
        return this.file.isDynamic();
    }

    public synchronized boolean isSequential() {
        if (this.file == null) {
            return false;
        }
        return this.file.isSequential();
    }

    public synchronized boolean ignoreAtEnd() {
        if (this.file == null) {
            return false;
        }
        return this.file.ignoreAtEnd();
    }

    public synchronized int getSize() {
        if (this.file == null) {
            return -1;
        }
        return this.file.getSize();
    }

    public synchronized boolean fixed() {
        if (this.file == null) {
            return false;
        }
        return this.file.isFixed();
    }

    public synchronized boolean variable() {
        if (this.file == null) {
            return false;
        }
        return this.file.isVariable();
    }

    @Override
    public synchronized Numeric getLinageCounter() {
        return new Numeric(1);
    }

    @Override
    public Object getObject() {
        return null;
    }

    public boolean deleteFile() {
        boolean flag = false;
        this.iostatus(0);
        if (this.file != null) {
            this.file.setFilename(this.getFilteredFilename());
            flag = this.file.deleteFile();
        }
        if (!flag) {
            this.iostatus(-5);
        }
        return flag;
    }

    public void finalize() throws Throwable {
        this.init();
        super.finalize();
    }

    public idxFile settingExternalFile(Context context, String name) {
        Object copy = context.getExternalFile(this, name);
        if (copy == null) {
            return this;
        }
        if (!(copy instanceof idxFile)) {
            return this;
        }
        if (copy == this) {
            return this;
        }
        this.externalFile = (idxFile)copy;
        this.file = this.externalFile.file;
        return this;
    }

    @Override
    public void unlock() {
        if (this.file != null) {
            this.file.unlock();
        }
    }

    public void exclusive() {
        if (this.file != null) {
            this.file.exclusive();
        }
    }

    public void exclusiveConditionally() {
        if (this.file != null) {
            this.file.exclusiveConditionally();
        }
    }

    public void unexclusive() {
        if (this.file != null) {
            this.file.unexclusive();
        }
    }

    public boolean flushCache() {
        if (this.file != null) {
            return this.file.flushCache();
        }
        return false;
    }

    public boolean reset() {
        if (this.file != null) {
            return this.file.resetCache();
        }
        return false;
    }

    public boolean supportsTransactions() {
        if (this.file != null) {
            return this.file.supportsTransactions();
        }
        return false;
    }

    @Override
    public boolean begin() {
        if (this.supportsTransactions()) {
            return this.file.begin();
        }
        return false;
    }

    @Override
    public boolean commit() {
        if (this.supportsTransactions()) {
            return this.file.commit();
        }
        return false;
    }

    @Override
    public boolean rollback() {
        if (this.supportsTransactions()) {
            return this.file.rollback();
        }
        return false;
    }

    @Override
    public boolean recover() {
        if (this.supportsTransactions()) {
            return this.file.recover();
        }
        return false;
    }

    public idxFile setPassword(Variable identifier) {
        return this;
    }

    public idxFile clone() {
        throw new RuntimeException("Multi browser sessions not supported by this file type.");
    }
}

