/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec.jdk14;

import com.heirloomcomputing.ecs.exec.FileConstants;
import com.heirloomcomputing.ecs.exec.LockFileInterface;
import com.heirloomcomputing.ecs.exec.LockedFileException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.Enumeration;
import java.util.Hashtable;

public class LockFileChannel
implements LockFileInterface,
FileConstants {
    public static final long READ_MAX = 0x7FFFFFFFFFFFFFFEL;
    public static final long WRITE_MAX = Long.MAX_VALUE;
    private Hashtable<Object, FileLock> locks = new Hashtable();
    private FileLock readOnlyLock = null;

    private FileChannel getFileChannel(Object fileObject) {
        if (fileObject == null) {
            return null;
        }
        if (fileObject instanceof RandomAccessFile) {
            return ((RandomAccessFile)fileObject).getChannel();
        }
        if (fileObject instanceof FileInputStream) {
            return ((FileInputStream)fileObject).getChannel();
        }
        if (fileObject instanceof FileOutputStream) {
            return ((FileOutputStream)fileObject).getChannel();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String sharingNoOthers(Object fileObject, String name, int openMode) throws LockedFileException {
        boolean throwLockedFile;
        block7: {
            throwLockedFile = false;
            try {
                FileChannel fileChannel = this.getFileChannel(fileObject);
                FileLock lock2 = fileChannel.tryLock(0L, Long.MAX_VALUE, false);
                if (lock2 == null) {
                    throwLockedFile = true;
                    break block7;
                }
                Hashtable<Object, FileLock> hashtable = this.locks;
                synchronized (hashtable) {
                    this.locks.put(fileObject, lock2);
                    return name;
                }
            }
            catch (Throwable t) {
                return null;
            }
        }
        if (throwLockedFile) {
            throw new LockedFileException();
        }
        return null;
    }

    @Override
    public String sharingReadOnly(Object fileObject, String name, int openMode) throws LockedFileException {
        return this.sharingNoOthers(fileObject, name, openMode);
    }

    @Override
    public String sharingAllOthers(Object fileObject, String name, int openMode) throws LockedFileException {
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean releaseSharing(Object fileObject, String name) {
        try {
            FileLock lock2 = this.locks.get(fileObject);
            if (lock2 == null) {
                return true;
            }
            Hashtable<Object, FileLock> hashtable = this.locks;
            synchronized (hashtable) {
                lock2.release();
            }
            return true;
        }
        catch (Throwable throwable) {
            this.releaseReadOnlyLock();
            return false;
        }
    }

    private void releaseReadOnlyLock() {
        if (this.readOnlyLock != null) {
            try {
                this.readOnlyLock.release();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.readOnlyLock = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseSharing() {
        Hashtable<Object, FileLock> hashtable = this.locks;
        synchronized (hashtable) {
            Enumeration<FileLock> e = this.locks.elements();
            while (e.hasMoreElements()) {
                try {
                    FileLock lock2 = e.nextElement();
                    lock2.release();
                }
                catch (Throwable throwable) {}
            }
            this.locks.clear();
        }
        this.releaseReadOnlyLock();
    }

    @Override
    public boolean isLockWhileOpen() {
        return true;
    }

    @Override
    public int transformOpenMode(int mode) {
        boolean readOnly = false;
        if ((mode & 0x20000) == 0 && (mode & 0x40000) == 0) {
            if ((mode & 0x80000) != 0) {
                readOnly = true;
            } else if ((mode & 0x20) == 0 && (mode & 0x40) == 0 && (mode & 0x80) != 0) {
                readOnly = true;
            }
        }
        if (readOnly) {
            mode &= 0xFFF7FFFF;
            mode &= 0xFFFFFF7F;
            mode |= 0x40000;
        }
        return mode;
    }

    static {
        Class<FileChannel> clazz = FileChannel.class;
    }
}

