/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.lock;
import java.util.Vector;

public class lockManager {
    public static final long WAIT = -1L;
    public static final long NO_WAIT = 0L;
    private static final long timeout = 0L;
    private final Vector<lock> readLocks = new Vector();
    private final Vector<lock> writeLocks = new Vector();
    private final Vector<lock> pendingWriteLocks = new Vector();

    public final void unlockThread() {
        this.unlockThread(Thread.currentThread());
    }

    private void unlockVector(Vector<lock> locks, Thread thread) {
        for (int i = locks.size() - 1; i >= 0; --i) {
            lock oldLock = locks.elementAt(i);
            if (oldLock.getThread() != thread) continue;
            locks.removeElementAt(i);
            oldLock.notifyAll();
        }
    }

    public final void unlockThread(Thread thread) {
        this.unlockVector(this.readLocks, thread);
        this.unlockVector(this.pendingWriteLocks, thread);
        this.unlockVector(this.writeLocks, thread);
    }

    public final synchronized int overlap(Vector<lock> v, lock l) {
        int locksCount = v.size();
        for (int i = 0; i < locksCount; ++i) {
            lock loop = v.elementAt(i);
            if (!loop.overlaps(l) || loop.equals(l) || loop.getThread() == l.getThread()) continue;
            return i;
        }
        return -1;
    }

    public final synchronized int readLock(long address, int length) {
        return this.readLock(address, length, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized int readLock(long address, int length, long milliseconds) {
        long timer;
        lock waitLock;
        int foundLock;
        boolean no_timeout;
        boolean bl = no_timeout = milliseconds < 0L;
        if (no_timeout) {
            milliseconds = 1L;
        }
        lock newLock = new lock(Thread.currentThread(), address, length);
        do {
            if ((foundLock = this.overlap(this.pendingWriteLocks, newLock)) < 0) continue;
            if (milliseconds <= 0L) {
                return -1;
            }
            waitLock = null;
            try {
                lock lock2 = waitLock = this.pendingWriteLocks.elementAt(foundLock);
                synchronized (lock2) {
                    if (no_timeout) {
                        waitLock.wait();
                    } else {
                        timer = System.currentTimeMillis();
                        waitLock.wait(0L);
                        timer = System.currentTimeMillis() - timer;
                        milliseconds -= timer;
                    }
                }
            }
            catch (Exception e) {
                if (waitLock == null) continue;
                this.pendingWriteLocks.removeElement(waitLock);
            }
        } while (foundLock >= 0);
        do {
            if ((foundLock = this.overlap(this.writeLocks, newLock)) < 0) continue;
            if (milliseconds <= 0L) {
                return -1;
            }
            waitLock = null;
            try {
                lock e = waitLock = this.writeLocks.elementAt(foundLock);
                synchronized (e) {
                    if (no_timeout) {
                        waitLock.wait();
                    } else {
                        timer = System.currentTimeMillis();
                        waitLock.wait(0L);
                        timer = System.currentTimeMillis() - timer;
                        milliseconds -= timer;
                    }
                }
            }
            catch (Exception e) {
                if (waitLock == null) continue;
                this.writeLocks.removeElement(waitLock);
            }
        } while (foundLock >= 0);
        this.readLocks.addElement(newLock);
        return newLock.getHandle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void readUnlock(long address, int length) {
        lock newLock = new lock(Thread.currentThread(), address, length);
        lock foundLock = null;
        int lockIndex = this.readLocks.indexOf(newLock);
        if (lockIndex >= 0) {
            foundLock = this.readLocks.elementAt(lockIndex);
            this.readLocks.removeElementAt(lockIndex);
            lock lock2 = foundLock;
            synchronized (lock2) {
                foundLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void readUnlock(int handle) {
        if (handle == -1) {
            this.unlockThread();
            return;
        }
        lock foundLock = null;
        int lockCount = this.readLocks.size();
        int lockIndex = -1;
        for (int i = 0; i < lockCount; ++i) {
            if (this.readLocks.elementAt(i).getHandle() != handle) continue;
            lockIndex = i;
            break;
        }
        if (lockIndex < 0) {
            return;
        }
        foundLock = this.readLocks.elementAt(lockIndex);
        this.readLocks.removeElementAt(lockIndex);
        lock lock2 = foundLock;
        synchronized (lock2) {
            foundLock.notifyAll();
        }
    }

    public final synchronized int writeLock(long address, int length) {
        return this.writeLock(address, length, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized int writeLock(long address, int length, long milliseconds) {
        lock e2;
        long timer;
        lock waitLock;
        int foundLock;
        boolean no_timeout;
        boolean bl = no_timeout = milliseconds < 0L;
        if (no_timeout) {
            milliseconds = 1L;
        }
        lock newLock = new lock(Thread.currentThread(), address, length);
        this.pendingWriteLocks.addElement(newLock);
        do {
            if ((foundLock = this.overlap(this.pendingWriteLocks, newLock)) < 0) continue;
            if (milliseconds <= 0L) {
                return -1;
            }
            waitLock = null;
            try {
                lock lock2 = waitLock = this.pendingWriteLocks.elementAt(foundLock);
                synchronized (lock2) {
                    if (no_timeout) {
                        waitLock.wait();
                    } else {
                        timer = System.currentTimeMillis();
                        waitLock.wait(0L);
                        timer = System.currentTimeMillis() - timer;
                        milliseconds -= timer;
                    }
                }
            }
            catch (Exception e2) {
                if (waitLock == null) continue;
                this.pendingWriteLocks.removeElement(waitLock);
            }
        } while (foundLock >= 0);
        do {
            if ((foundLock = this.overlap(this.writeLocks, newLock)) < 0) continue;
            if (milliseconds <= 0L) {
                return -1;
            }
            waitLock = null;
            try {
                e2 = waitLock = this.writeLocks.elementAt(foundLock);
                synchronized (e2) {
                    if (no_timeout) {
                        waitLock.wait();
                    } else {
                        timer = System.currentTimeMillis();
                        waitLock.wait(0L);
                        timer = System.currentTimeMillis() - timer;
                        milliseconds -= timer;
                    }
                }
            }
            catch (Exception e3) {
                if (waitLock == null) continue;
                this.writeLocks.removeElement(waitLock);
            }
        } while (foundLock >= 0);
        this.pendingWriteLocks.removeElement(newLock);
        do {
            if ((foundLock = this.overlap(this.readLocks, newLock)) < 0) continue;
            if (milliseconds <= 0L) {
                return -1;
            }
            waitLock = null;
            try {
                e2 = waitLock = this.readLocks.elementAt(foundLock);
                synchronized (e2) {
                    if (no_timeout) {
                        waitLock.wait();
                    } else {
                        timer = System.currentTimeMillis();
                        waitLock.wait(0L);
                        timer = System.currentTimeMillis() - timer;
                        milliseconds -= timer;
                    }
                }
            }
            catch (Exception e4) {
                if (waitLock == null) continue;
                this.readLocks.removeElement(waitLock);
            }
        } while (foundLock >= 0);
        this.writeLocks.addElement(newLock);
        return newLock.getHandle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void writeUnlock(long address, int length) {
        lock newLock = new lock(Thread.currentThread(), address, length);
        lock foundLock = null;
        int lockIndex = this.writeLocks.indexOf(newLock);
        if (lockIndex >= 0) {
            foundLock = this.writeLocks.elementAt(lockIndex);
            this.writeLocks.removeElementAt(lockIndex);
            lock lock2 = foundLock;
            synchronized (lock2) {
                foundLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void writeUnlock(int handle) {
        lock foundLock = null;
        int lockCount = this.writeLocks.size();
        int lockIndex = -1;
        for (int i = 0; i < lockCount; ++i) {
            if (this.writeLocks.elementAt(i).getHandle() != handle) continue;
            lockIndex = i;
            break;
        }
        if (lockIndex < 0) {
            return;
        }
        foundLock = this.writeLocks.elementAt(lockIndex);
        this.writeLocks.removeElementAt(lockIndex);
        lock lock2 = foundLock;
        synchronized (lock2) {
            foundLock.notifyAll();
        }
    }
}

