/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.Utilities;
import com.heirloomcomputing.ecs.exec.bTreeNode;
import com.heirloomcomputing.ecs.exec.comparableByteArray;
import com.heirloomcomputing.ecs.exec.recordBlockFile;
import com.heirloomcomputing.ecs.exec.recordPointer;

public class recordBlockFileBTreeNode
extends bTreeNode {
    public static boolean debugMode = false;
    private recordBlockFile file = null;
    private recordPointer currentLocation = null;
    private comparableByteArray keyTemplate = null;
    private int handlerID = 0;
    private byte[] mainBuffer = null;
    private int numberOfKeys = 0;
    private int maxKeys;
    private int minKeys;
    private int keyLength;
    private int childLength;
    private long[] duplicateCount;
    private int keyBase = 0;

    public static void debug(String text) {
        Utilities.debugOutput("recordBlockFileBTreeNode: " + text);
    }

    public recordBlockFileBTreeNode(recordBlockFile file2, int order, comparableByteArray nodeKeyTemplate, int handlerID) {
        this.maxKeys = order - 1;
        this.minKeys = this.maxKeys / 2;
        this.duplicateCount = new long[this.maxKeys];
        this.keyTemplate = nodeKeyTemplate;
        this.keyLength = this.keyTemplate.length();
        this.childLength = 12;
        this.handlerID = handlerID;
        this.file = file2;
        this.mainBuffer = new byte[file2.getMaxRecordSize()];
        if (debugMode) {
            recordBlockFileBTreeNode.debug("mainBufferSize=" + this.mainBuffer.length);
        }
        this.toByteArray();
        long currentBlockNumber = file2.findRecordBlock(this.mainBuffer.length);
        int currentRecordKey = file2.addRecord(currentBlockNumber, this.mainBuffer);
        this.currentLocation = new recordPointer(currentBlockNumber, currentRecordKey);
        if (debugMode) {
            recordBlockFileBTreeNode.debug("******************* adding new node instance to file: blockNumber=" + currentBlockNumber + " recordKey=" + currentRecordKey);
            recordBlockFileBTreeNode.debug("Bytes written:\n" + this.toString());
        }
    }

    public recordBlockFileBTreeNode(recordBlockFile file2, int order, long blockNumber, int recordKey, comparableByteArray nodeKeyTemplate, int handlerID) {
        this.maxKeys = order - 1;
        this.minKeys = this.maxKeys / 2;
        this.duplicateCount = new long[this.maxKeys];
        this.keyTemplate = nodeKeyTemplate;
        this.keyLength = this.keyTemplate.length();
        this.childLength = 12;
        this.handlerID = handlerID;
        this.file = file2;
        this.mainBuffer = new byte[file2.getMaxRecordSize()];
        if (debugMode) {
            recordBlockFileBTreeNode.debug("mainBufferSize=" + this.mainBuffer.length);
        }
        if (debugMode) {
            recordBlockFileBTreeNode.debug("************ retrieving a new node instance from file: blockNumber= " + blockNumber + " key=" + recordKey);
        }
        this.fromByteArray(file2.getRecord(blockNumber, recordKey));
        this.currentLocation = new recordPointer(blockNumber, recordKey);
        if (debugMode) {
            recordBlockFileBTreeNode.debug("bytes read=\n" + this.toString());
        }
    }

    @Override
    public final Object getLocation() {
        return this.currentLocation;
    }

    @Override
    public final int getNumberOfKeys() {
        return this.numberOfKeys;
    }

    @Override
    public final int getMaxKeys() {
        return this.maxKeys;
    }

    @Override
    public final int getMinKeys() {
        return this.minKeys;
    }

    @Override
    public final long getDuplicateCount(int keyNumber) {
        if (keyNumber < 0 || keyNumber >= this.numberOfKeys) {
            return -1L;
        }
        return this.duplicateCount[keyNumber];
    }

    @Override
    public final void setDuplicateCount(int keyNumber, long count) {
        this.duplicateCount[keyNumber] = count;
    }

    @Override
    public final int getChildLength() {
        return this.childLength;
    }

    @Override
    public final int getKeyLength() {
        return this.keyLength;
    }

    @Override
    public final int getKeyByteOffset(int keyNumber) {
        return this.keyBase + keyNumber * (16 + this.getKeyLength()) + 16;
    }

    @Override
    public final int getChildByteOffset(int childNumber) {
        int offset = this.keyBase + childNumber * (16 + this.getKeyLength());
        if (childNumber >= this.getNumberOfKeys()) {
            ++offset;
        }
        return offset;
    }

    @Override
    public final bTreeNode getNode(Object myNodePointer, bTreeNode reuseNode) {
        if (myNodePointer == null) {
            if (debugMode) {
                recordBlockFileBTreeNode.debug("recordBlockFileBTreeNode ERROR: getNode(p1, p2) received a null nodePointer.");
            }
            return null;
        }
        recordPointer nodePointer = (recordPointer)myNodePointer;
        recordBlockFileBTreeNode node = (recordBlockFileBTreeNode)reuseNode;
        long blockNumber = nodePointer.getBlockNumber();
        int recordKey = nodePointer.getRecordKey();
        node.fromByteArray(this.file.getRecord(blockNumber, recordKey));
        node.currentLocation = new recordPointer(blockNumber, recordKey);
        return node;
    }

    @Override
    public final bTreeNode getNode(Object myNodePointer) {
        if (myNodePointer == null) {
            if (debugMode) {
                recordBlockFileBTreeNode.debug("recordBlockFileBTreeNode ERROR: getNode() received a null nodePointer.");
            }
            return null;
        }
        recordPointer nodePointer = (recordPointer)myNodePointer;
        long blockNumber = nodePointer.getBlockNumber();
        int recordKey = nodePointer.getRecordKey();
        return this.newInstance(blockNumber, recordKey);
    }

    @Override
    public final void setNode() {
        if (debugMode) {
            recordBlockFileBTreeNode.debug("Called setNode, node=\n" + this.toString());
        }
        if (this.currentLocation == null) {
            return;
        }
        long blockNumber = this.currentLocation.getBlockNumber();
        int recordKey = this.currentLocation.getRecordKey();
        if (this.numberOfKeys <= 0 && !this.isRoot()) {
            this.file.deleteRecord(blockNumber, recordKey);
        } else {
            this.file.updateRecord(blockNumber, recordKey, this.toByteArray());
        }
    }

    @Override
    public final Object getData(Object myNodePointer) {
        if (myNodePointer == null) {
            return null;
        }
        if (debugMode) {
            recordBlockFileBTreeNode.debug("Called getData(" + myNodePointer + ")");
        }
        recordPointer nodePointer = (recordPointer)myNodePointer;
        long blockNumber = nodePointer.getBlockNumber();
        int recordKey = nodePointer.getRecordKey();
        if (debugMode) {
            recordBlockFileBTreeNode.debug("blockNumber=" + blockNumber);
            recordBlockFileBTreeNode.debug("recordKey=" + recordKey);
        }
        byte[] myData = this.file.getRecord(blockNumber, recordKey);
        return myData;
    }

    @Override
    public final bTreeNode newInstance() {
        return new recordBlockFileBTreeNode(this.file, this.maxKeys + 1, this.keyTemplate, this.handlerID);
    }

    public final bTreeNode newInstance(long blockNumber, int recordKey) {
        return new recordBlockFileBTreeNode(this.file, this.maxKeys + 1, blockNumber, recordKey, this.keyTemplate, this.handlerID);
    }

    private final boolean fromByteArray(byte[] bytes) {
        if (bytes == null) {
            if (debugMode) {
                recordBlockFileBTreeNode.debug("fromByteArray was given null bytes!");
            }
            return false;
        }
        if (this.keyTemplate == null || bytes == null) {
            if (debugMode) {
                if (bytes == null) {
                    recordBlockFileBTreeNode.debug("ERROR: passed null byte array to fromByteArray in recordBlockFileBTreeNode class");
                } else {
                    recordBlockFileBTreeNode.debug("ERROR: No key template defined for recordBlockFileBTreeNode");
                }
            }
            return false;
        }
        int index = 1;
        byte length = bytes[0];
        if (debugMode) {
            recordBlockFileBTreeNode.debug("parent length=" + length);
        }
        if (length != 0) {
            index = 13;
        }
        boolean bl = this.isLeaf = bytes[index++] == 1;
        if (debugMode) {
            recordBlockFileBTreeNode.debug("isLeaf?=" + this.isLeaf);
        }
        this.numberOfKeys = bytes[index++] & 0xFF | (bytes[index++] & 0xFF) << 8 | (bytes[index++] & 0xFF) << 16 | (bytes[index++] & 0xFF) << 24;
        if (debugMode) {
            recordBlockFileBTreeNode.debug("numberOfKeys=" + this.numberOfKeys);
        }
        this.keyBase = index;
        System.arraycopy(bytes, 0, this.mainBuffer, 0, bytes.length);
        return true;
    }

    private final byte[] toByteArray() {
        if (debugMode) {
            recordBlockFileBTreeNode.debug("Called toByteArray, node=" + this.toString());
        }
        byte[] tempBytes = this.mainBuffer;
        int index = 0;
        tempBytes[index++] = 0;
        tempBytes[index++] = this.isLeaf ? (byte)1 : 0;
        tempBytes[index++] = (byte)(this.numberOfKeys & 0xFF);
        tempBytes[index++] = (byte)(this.numberOfKeys >> 8 & 0xFF);
        tempBytes[index++] = (byte)(this.numberOfKeys >> 16 & 0xFF);
        tempBytes[index++] = (byte)(this.numberOfKeys >> 24 & 0xFF);
        this.keyBase = index;
        for (int count = 0; count < this.numberOfKeys; ++count) {
            index += 12;
            int length = this.getKeyLength();
            tempBytes[index++] = (byte)(length & 0xFF);
            tempBytes[index++] = (byte)(length >> 8 & 0xFF);
            tempBytes[index++] = (byte)(length >> 16 & 0xFF);
            tempBytes[index++] = (byte)(length >> 24 & 0xFF);
            index += length;
        }
        return tempBytes;
    }

    @Override
    public void free() {
        super.free();
        this.numberOfKeys = 0;
        this.duplicateCount = new long[this.maxKeys];
    }

    @Override
    public final String toString() {
        String text = "";
        try {
            boolean showData = false;
            String lineSep = RuntimeEnvironment.getGlobalParameter("line.separator");
            int numKeys = this.getNumberOfKeys();
            Object location = this.getLocation();
            if (location == null) {
                return text + ": ERROR, location is null!";
            }
            String loc = location.toString();
            text = loc + " " + numKeys + ": ";
            text = this.isRoot() ? text + "(Root) " : text + "       ";
            if (this.isLeaf()) {
                int count;
                text = text + "x ";
                for (count = 0; count < numKeys; ++count) {
                    comparableByteArray keyObj;
                    Object child = this.getChild(count);
                    if (child == null) {
                        return text + ": ERROR child was null!!";
                    }
                    text = text + child.toString();
                    if (showData) {
                        text = text + ":" + new String((byte[])this.getData(child));
                    }
                    if ((keyObj = this.getKey(count)) == null) {
                        return text + ": ERROR key was null!!";
                    }
                    text = text + "[" + keyObj.toString() + "]";
                }
                Object tempChild = this.getChild(count);
                if (tempChild != null) {
                    text = text + tempChild.toString();
                    if (showData) {
                        text = text + ":" + new String((byte[])this.getData(tempChild));
                    }
                }
                text = text + lineSep;
            } else {
                int count;
                text = text + "  ";
                for (count = 0; count < numKeys; ++count) {
                    text = text + this.getChild(count);
                    text = text + "[" + this.getKey(count).toString() + "]";
                }
                Object tempChild = this.getChild(count);
                text = tempChild != null ? text + tempChild : text + "{ NULL }";
                text = text + lineSep;
            }
        }
        catch (Throwable t) {
            t.printStackTrace(System.out);
        }
        return text;
    }

    @Override
    protected final byte[] getBuffer() {
        return this.mainBuffer;
    }

    @Override
    protected Object convertBytesToChildObject(int childNumber) {
        if (debugMode) {
            recordBlockFileBTreeNode.debug("Called convertBytesToChildObject(" + childNumber + ") numberOfKeys=" + this.getNumberOfKeys());
        }
        int offset = this.getChildByteOffset(childNumber);
        if (childNumber >= this.getNumberOfKeys() && this.mainBuffer[offset - 1] == 0) {
            if (debugMode) {
                recordBlockFileBTreeNode.debug("childNumber=" + childNumber + ", returning null");
            }
            return null;
        }
        recordPointer childObject = new recordPointer(this.mainBuffer, offset);
        return childObject;
    }

    @Override
    protected boolean convertChildObjectToBytes(Object childObject, int childNumber) {
        if (debugMode) {
            recordBlockFileBTreeNode.debug("Called convertChildObjectToBytes(" + childObject + ", " + childNumber + ") numberOfKeys=" + this.getNumberOfKeys());
        }
        int offset = this.getChildByteOffset(childNumber);
        if (childNumber >= this.getNumberOfKeys()) {
            this.mainBuffer[offset - 1] = (byte)(childObject != null ? 1 : 0);
            if (childObject == null) {
                return true;
            }
        }
        return this.convertChildObjectToBytes(childObject, this.mainBuffer, offset);
    }

    @Override
    protected boolean convertChildObjectToBytes(Object childObject, byte[] bytes, int offset) {
        if (childObject == null) {
            if (debugMode) {
                recordBlockFileBTreeNode.debug("converChildObjectToBytes passed a null childObject!");
            }
            return false;
        }
        try {
            ((recordPointer)childObject).writeBytes(bytes, offset);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    protected comparableByteArray convertBytesToKeyObject(byte[] bytes, int offset, int len) {
        if (bytes == null) {
            return null;
        }
        comparableByteArray keyObject = this.keyTemplate.copy();
        byte[] keyBytes = new byte[len];
        System.arraycopy(bytes, offset, keyBytes, 0, len);
        keyObject.fromByteArray(keyBytes);
        return keyObject;
    }

    @Override
    protected boolean convertKeyObjectToBytes(comparableByteArray keyObject, byte[] bytes, int offset) {
        if (keyObject == null) {
            return false;
        }
        byte[] keyBytes = keyObject.toByteArray();
        if (keyBytes != null) {
            System.arraycopy(keyBytes, 0, bytes, offset, keyBytes.length);
        }
        return true;
    }

    @Override
    protected boolean insertKeyIntoBufferAndIncreaseNumberOfKeys(int keyNumberPosition, byte[] keyBytes, int keyOffset, int keyLen, byte[] childBytes, int childOffset, long duplicateCount) {
        try {
            ++this.numberOfKeys;
            int displacement = 16 + this.getKeyLength();
            int sourceOffset = this.getChildByteOffset(keyNumberPosition);
            int destOffset = sourceOffset + displacement;
            int totalBytesToMove = this.mainBuffer.length - sourceOffset - displacement;
            System.arraycopy(this.mainBuffer, sourceOffset, this.mainBuffer, destOffset, totalBytesToMove);
            System.arraycopy(childBytes, childOffset, this.mainBuffer, sourceOffset, 12);
            System.arraycopy(keyBytes, keyOffset, this.mainBuffer, sourceOffset + 16, keyLen);
            if (this.numberOfKeys < this.maxKeys) {
                System.arraycopy(this.duplicateCount, keyNumberPosition, this.duplicateCount, keyNumberPosition + 1, this.numberOfKeys - keyNumberPosition - 1);
            }
            this.duplicateCount[keyNumberPosition] = duplicateCount;
            if (debugMode) {
                recordBlockFileBTreeNode.debug("inserted key, node=\n" + this.getHexDump());
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    protected boolean deleteKeyFromBufferAndDecreaseNumberOfKeys(int keyNumberPosition) {
        int numKeys = this.getNumberOfKeys();
        if (keyNumberPosition < 0 || keyNumberPosition >= numKeys) {
            return false;
        }
        try {
            int displacement = 16 + this.getKeyLength();
            int sourceOffset = this.getChildByteOffset(keyNumberPosition + 1);
            if (keyNumberPosition + 1 >= numKeys) {
                --sourceOffset;
            }
            int destOffset = sourceOffset - displacement;
            int totalBytesToMove = this.mainBuffer.length - sourceOffset;
            System.arraycopy(this.mainBuffer, sourceOffset, this.mainBuffer, destOffset, totalBytesToMove);
            if (keyNumberPosition + 1 < this.maxKeys) {
                System.arraycopy(this.duplicateCount, keyNumberPosition + 1, this.duplicateCount, keyNumberPosition, this.numberOfKeys - keyNumberPosition - 1);
            }
            --this.numberOfKeys;
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    protected boolean moveFromNode(bTreeNode sourceNode, int n) {
        if (n == 0) {
            return true;
        }
        boolean returnValue = true;
        if (sourceNode.getNumberOfKeys() < n) {
            returnValue = false;
            n = sourceNode.getNumberOfKeys();
        }
        if (this.numberOfKeys + n > this.getMaxKeys()) {
            returnValue = false;
            n = this.getMaxKeys() - this.numberOfKeys;
        }
        try {
            int displacement;
            int amount;
            recordBlockFileBTreeNode source = (recordBlockFileBTreeNode)sourceNode;
            int keyNumberPosition = this.getNumberOfKeys();
            this.numberOfKeys += n;
            int ourOffset = this.getChildByteOffset(keyNumberPosition);
            int sourceOffset = source.getChildByteOffset(0);
            int totalBytesToMove = (source.getKeyLength() + source.getChildLength() + 4) * n;
            if (debugMode) {
                recordBlockFileBTreeNode.debug("totalBytesToMove=" + totalBytesToMove);
            }
            byte[] sourceBuffer = source.getBuffer();
            System.arraycopy(sourceBuffer, sourceOffset, this.mainBuffer, ourOffset, totalBytesToMove);
            if (debugMode) {
                recordBlockFileBTreeNode.debug("moving duplicateCount objects");
            }
            System.arraycopy(source.duplicateCount, 0, this.duplicateCount, keyNumberPosition, n);
            if (debugMode) {
                recordBlockFileBTreeNode.debug("deleting from source...");
            }
            if ((amount = sourceBuffer.length - (displacement = sourceOffset + totalBytesToMove)) > 0) {
                System.arraycopy(sourceBuffer, displacement, sourceBuffer, sourceOffset, amount);
            }
            amount = source.getNumberOfKeys() - n;
            if (debugMode) {
                recordBlockFileBTreeNode.debug("removing duplicateCount objects from source, amount=" + amount);
            }
            if (amount > 0) {
                System.arraycopy(source.duplicateCount, n, source.duplicateCount, 0, amount);
            }
            source.numberOfKeys -= n;
            if (debugMode) {
                recordBlockFileBTreeNode.debug("done.  returnValue=" + returnValue + ", sourceNode=\n" + sourceNode.toString() + "\ndestNode=\n" + this.toString());
            }
            return returnValue;
        }
        catch (Throwable throwable) {
            return false;
        }
    }
}

