/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.Context;
import com.heirloomcomputing.ecs.exec.LockFile;
import com.heirloomcomputing.ecs.exec.LockRecord;
import com.heirloomcomputing.ecs.exec.LogSetup;
import com.heirloomcomputing.ecs.exec.MFFile;
import com.heirloomcomputing.ecs.exec.Memory;
import com.heirloomcomputing.ecs.exec.Numeric;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.exec.basicFile;
import com.heirloomcomputing.ecs.exec.smartFile;
import com.heirloomcomputing.ecs.isamsql.DCB;
import com.heirloomcomputing.ecs.isamsql.DCBDB;
import com.heirloomcomputing.ecs.isamsql.DCBFactory;
import java.io.File;
import java.util.Calendar;
import java.util.Objects;

public class seqFile
extends basicFile {
    private static final String PGM = "seqFile";
    private static boolean defaultMicrofocus;
    private static boolean defaultAcucobol;
    private static boolean defaultIbmV;
    private static boolean defaultIbmVB;
    private static boolean defaultSyncSort;
    private static boolean isInsertNull;
    private static boolean isStripNull;
    private static boolean isStripSpaces;
    protected Protocol protocol;
    protected int minimum = -1;
    protected int maximum = -1;
    protected Variable dependingOn;
    protected Variable linageId;
    protected Variable footingId;
    protected Variable topId;
    protected Variable bottomId;
    protected int linage = -1;
    protected int footing = -1;
    protected int top = -1;
    protected int bottom = -1;
    protected Variable fileStatus;
    protected boolean optional;
    protected boolean isOpen;
    protected int size;
    protected int readSize;
    protected int rewriteSize;
    protected String codeSet;
    protected boolean readable;
    protected boolean writable;
    protected boolean extend;
    protected int priorErrorCode;
    protected seqFile externalFile;
    protected Variable filenameVariable;
    protected int newModes;
    protected boolean lineSequential;
    protected int alignment = 1;
    protected boolean microfocus_unix;
    protected boolean microfocus_win;
    protected boolean override_variable;
    protected boolean override_fixed;
    protected boolean override_varying;
    protected int usedAlignment;
    protected byte[] fourbytes = new byte[4];
    protected smartFile file = new smartFile();
    protected LockRecord lockRecord = LockRecord.create(this.file);
    protected boolean lowLevel;
    protected int blockFrom;
    protected int blockTo;
    protected int dataCompression = 0;
    private boolean noOps = false;
    protected boolean isVSEAssignFile = false;
    private int blkSize;
    private int blkSizeCurrent;
    private long blkSizeLastPosn;
    private boolean blkSizePartial;
    private Variable fileStatus2;
    private boolean cached;
    private boolean cachedInput;
    private boolean cachedOutput;
    private boolean cachedIO;
    private boolean cachedFixed;
    private boolean cachedVariable;
    private byte[] temporaryStorage;
    private final char[] smallChar = new char[]{'0', '0'};
    private boolean permanentLineSequential;
    private boolean isFormatFBA;
    private boolean isFormatVBA;
    private byte[] controlByte = new byte[]{"3".equals(RuntimeEnvironment.getGlobalParameter("DT")) ? (byte)64 : 32};
    private byte cbSpace;
    private byte cbMinus;
    private byte cbPlus;
    private byte cbCharZero;
    private byte cbCharOne;
    private byte cbCharTwo;
    private byte cbCharThree;
    private byte cbCharFour;
    private byte cbCharFive;
    private byte cbCharSix;
    private byte cbCharSeven;
    private byte cbCharEight;
    private byte cbCharNine;
    private byte cbCharA;
    private byte cbCharB;
    private byte cbCharC;
    private static final String CURRENT_JOB_TYPE = "currentjobtype";
    private static final String JOB_TYPE_JCS = "JCS";
    private byte[] lineSep = null;
    private static final String NOADV_param = "no_adv";

    protected smartFile getFile() {
        return this.file;
    }

    private static void initFilesystems() {
        defaultMicrofocus = false;
        defaultAcucobol = false;
        defaultIbmV = false;
        defaultIbmVB = false;
        defaultSyncSort = false;
        String s = RuntimeEnvironment.getGlobalParameter("FILESYSTEMSEQ");
        if (s == null) {
            s = RuntimeEnvironment.getGlobalParameter("FILESYSTEM");
        }
        if (s != null) {
            if ((s = s.toUpperCase()).equalsIgnoreCase("MF")) {
                defaultMicrofocus = true;
            } else if (s.equalsIgnoreCase("MICROFOCUS")) {
                defaultMicrofocus = true;
            } else if (s.equalsIgnoreCase("MERANT")) {
                defaultMicrofocus = true;
            } else if (s.equalsIgnoreCase("ACU")) {
                defaultAcucobol = true;
            } else if (s.equalsIgnoreCase("ACUCOBOL")) {
                defaultAcucobol = true;
            } else if (s.equalsIgnoreCase("ACUCORP")) {
                defaultAcucobol = true;
            } else if (s.equalsIgnoreCase("IBMV")) {
                defaultIbmV = true;
            } else if (s.equalsIgnoreCase("IBMVB")) {
                defaultIbmVB = true;
            } else if (s.equalsIgnoreCase("SYNCSORT")) {
                defaultSyncSort = true;
            }
        }
        String stripSpaces = null;
        stripSpaces = RuntimeEnvironment.getGlobalParameter("STRIPSPACES") != null ? RuntimeEnvironment.getGlobalParameter("STRIPSPACES") : System.getProperty("STRIPSPACES");
        isStripSpaces = !"NO".equalsIgnoreCase(stripSpaces) && !"FALSE".equalsIgnoreCase(stripSpaces) && !"OFF".equalsIgnoreCase(stripSpaces);
        String insertNull = RuntimeEnvironment.getGlobalParameter("INSERTNULL");
        isInsertNull = !"NO".equalsIgnoreCase(insertNull) && !"FALSE".equalsIgnoreCase(insertNull) && !"OFF".equalsIgnoreCase(insertNull);
        String stripNull = RuntimeEnvironment.getGlobalParameter("STRIPNULL");
        isStripNull = !"NO".equalsIgnoreCase(stripNull) && !"FALSE".equalsIgnoreCase(stripNull) && !"OFF".equalsIgnoreCase(stripNull);
    }

    private final int determineWriteSize(int length) {
        return (this.fixed() || this.protocol == Protocol.MICROFOCUS) && length < this.maximum && !this.lineSequential && !this.override_varying && !this.override_variable ? this.maximum : length;
    }

    public boolean isRaw() {
        return this.protocol == Protocol.RAWMODE;
    }

    public final seqFile settingExternalFile(Context context, String name) {
        Object copy = context.getExternalFile(this, name);
        if (copy == null) {
            return this;
        }
        if (!(copy instanceof seqFile)) {
            return this;
        }
        if (copy == this) {
            return this;
        }
        this.externalFile = (seqFile)copy;
        this.file = this.externalFile.getFile();
        return this;
    }

    smartFile getSmartFile() {
        return this.getFile();
    }

    public final void setSmartFile(smartFile file2) {
        this.file = file2;
    }

    public boolean isReadable() {
        return this.externalFile != null ? this.externalFile.isReadable() : this.readable;
    }

    public boolean isWritable() {
        return this.externalFile != null ? this.externalFile.isWritable() : this.writable;
    }

    public boolean isExtend() {
        return this.externalFile != null ? this.externalFile.isExtend() : this.extend;
    }

    public void setReadable(boolean state) {
        if (this.externalFile != null) {
            this.externalFile.setReadable(state);
        }
        this.readable = state;
    }

    public void setWritable(boolean state) {
        if (this.externalFile != null) {
            this.externalFile.setWritable(state);
        }
        this.writable = state;
    }

    public void setExtend(boolean state) {
        if (this.externalFile != null) {
            this.externalFile.setExtend(state);
        }
        this.extend = state;
    }

    public seqFile setFileStatus(Variable v) {
        this.fileStatus = v;
        return this;
    }

    public seqFile setFileStatus2(Variable v) {
        this.fileStatus2 = v;
        return this;
    }

    public seqFile setFileStatus3(Variable v) {
        return this;
    }

    public Variable getFileStatusVar() {
        return this.fileStatus;
    }

    public Variable getFileStatusVar2() {
        return this.fileStatus2;
    }

    public void setLowLevel(boolean flag) {
        this.lowLevel = flag;
    }

    public boolean isLowLevel() {
        return this.lowLevel;
    }

    private final void cacheValues() {
        boolean readable = this.isReadable();
        boolean writable = this.isWritable();
        boolean extend = this.isExtend();
        boolean lowLevel = this.isLowLevel();
        this.cachedInput = lowLevel || readable && !writable;
        this.cachedOutput = lowLevel || writable && !readable && !extend;
        this.cachedIO = readable && writable;
        this.cachedFixed = this.fixed();
        this.cachedVariable = this.variable();
        this.cached = true;
    }

    private void invalidateCacheValues() {
        this.cached = false;
    }

    public boolean isInput() {
        if (this.cached) {
            return this.cachedInput;
        }
        return this.isLowLevel() || this.isReadable() && !this.isWritable();
    }

    public boolean isOutput() {
        if (this.cached) {
            return this.cachedOutput;
        }
        return this.isLowLevel() || this.isWritable() && !this.isReadable() && !this.isExtend();
    }

    public boolean isIO() {
        if (this.cached) {
            return this.cachedIO;
        }
        return this.isReadable() && this.isWritable();
    }

    public synchronized boolean isOpen() {
        if (this.getFile() == null) {
            return false;
        }
        return this.getFile().isOpen();
    }

    public boolean useException() {
        return this.priorError() != 0 && this.priorError() != -10 && this.priorError() != 10 && this.priorError() != 7;
    }

    public boolean useAtEnd() {
        return this.priorError() == -10 || this.priorError() == 10;
    }

    public boolean isOK() {
        return this.priorError() > -10;
    }

    public int useException(int specific, int input, int output, int io, int extend) {
        if (this.useException()) {
            if (specific >= 0) {
                return specific;
            }
            if (this.isExtend()) {
                return extend;
            }
            if (this.isInput()) {
                return input;
            }
            if (this.isOutput()) {
                return output;
            }
            if (this.isIO()) {
                return io;
            }
        }
        return -1;
    }

    public final synchronized int useException(int specific) {
        if (this.useException()) {
            return specific;
        }
        return -1;
    }

    public int useAtEnd(int specific, int input, int output, int io, int extend) {
        int priorError = this.priorError();
        if (priorError == 10 || priorError == -10) {
            if (specific >= 0) {
                return specific;
            }
            if (this.isExtend()) {
                return extend;
            }
            if (this.isInput()) {
                return input;
            }
            if (this.isOutput()) {
                return output;
            }
            if (this.isIO()) {
                return io;
            }
        }
        return -1;
    }

    public int useAtEnd(int specific) {
        int priorError = this.priorError();
        if (specific >= 0 && (priorError == 10 || priorError == -10)) {
            return specific;
        }
        return -1;
    }

    public void iostatus(String x) {
        try {
            this.iostatus(-Integer.decode(x.trim()).intValue());
        }
        catch (Exception e) {
            this.iostatus(0);
        }
    }

    public void iostatus(int status) {
        try {
            if (status < 0) {
                if ((status = -status) == 9) {
                    status = 0;
                }
                this.setPriorError(status);
                if (this.fileStatus != null) {
                    if (status == 0) {
                        this.fileStatus.moveZeroes();
                    } else if (status < 10) {
                        this.smallChar[1] = (char)(status + 48);
                        this.fileStatus.move(this.smallChar);
                    } else {
                        this.fileStatus.move(status);
                    }
                }
            } else {
                status = 0;
                this.setPriorError(status);
                if (this.fileStatus != null) {
                    this.fileStatus.moveZeroes();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public int priorError() {
        return this.externalFile != null ? this.externalFile.priorError() : this.priorErrorCode;
    }

    public void setPriorError(int status) {
        this.priorErrorCode = status;
        if (this.externalFile != null) {
            this.externalFile.setPriorError(status);
        }
    }

    public void setLinage(int l, int f, int t, int b) {
        this.linage = l;
        this.footing = f;
        this.top = t;
        this.bottom = b;
    }

    public seqFile declare(boolean optional, Variable filenameVariable, int reserve, Variable paddingId, char paddingChar, Variable fileStatus, int blockFrom, int blockTo, boolean isRecords, int recordFrom, int recordTo, Variable dependingOn, boolean isLabelRecordsOmitted, Variable linageId, int linage, Variable footingId, int footing, Variable topId, int top, Variable bottomId, int bottom, String codeSet, int newModes) {
        this.newModes = newModes;
        return this.declare(optional, filenameVariable, reserve, paddingId, paddingChar, fileStatus, blockFrom, blockTo, isRecords, recordFrom, recordTo, dependingOn, isLabelRecordsOmitted, linageId, linage, footingId, footing, topId, top, bottomId, bottom, codeSet);
    }

    public seqFile declare(boolean optional, Variable filenameVariable, int reserve, Variable paddingId, char paddingChar, Variable fileStatus, int blockFrom, int blockTo, boolean isRecords, int recordFrom, int recordTo, Variable dependingOn, boolean isLabelRecordsOmitted, Variable linageId, int linage, Variable footingId, int footing, Variable topId, int top, Variable bottomId, int bottom, String codeSet) {
        String assignTo = null;
        this.filenameVariable = filenameVariable;
        if (filenameVariable != null) {
            assignTo = filenameVariable.toString();
        }
        return this.declare(optional, assignTo, reserve, paddingId, paddingChar, fileStatus, blockFrom, blockTo, isRecords, recordFrom, recordTo, dependingOn, isLabelRecordsOmitted, linageId, linage, footingId, footing, topId, top, bottomId, bottom, codeSet);
    }

    public seqFile declare(boolean optional, String assignTo, int reserve, Variable paddingId, char paddingChar, Variable fileStatus, int blockFrom, int blockTo, boolean isRecords, int recordFrom, int recordTo, Variable dependingOn, boolean isLabelRecordsOmitted, Variable linageId, int linage, Variable footingId, int footing, Variable topId, int top, Variable bottomId, int bottom, String codeSet, int newModes) {
        this.newModes = newModes;
        return this.declare(optional, assignTo, reserve, paddingId, paddingChar, fileStatus, blockFrom, blockTo, isRecords, recordFrom, recordTo, dependingOn, isLabelRecordsOmitted, linageId, linage, footingId, footing, topId, top, bottomId, bottom, codeSet);
    }

    public seqFile declare(boolean optional, String assignTo, int reserve, Variable paddingId, char paddingChar, Variable fileStatus, int blockFrom, int blockTo, boolean isRecords, int recordFrom, int recordTo, Variable dependingOn, boolean isLabelRecordsOmitted, Variable linageId, int linage, Variable footingId, int footing, Variable topId, int top, Variable bottomId, int bottom, String codeSet) {
        try {
            int storageSpace;
            this.optional = optional;
            this.fileStatus = fileStatus;
            this.dependingOn = dependingOn;
            this.minimum = recordFrom;
            this.maximum = recordTo;
            if (this.maximum < 0) {
                this.maximum = -1;
            }
            if (this.minimum < 0) {
                this.minimum = -1;
            }
            if (this.minimum < 0 && this.maximum >= 0) {
                this.minimum = this.maximum;
            }
            if (this.maximum < 0 && this.minimum >= 0) {
                this.maximum = this.minimum;
            }
            if (this.minimum > this.maximum) {
                this.maximum = this.minimum;
            }
            if ((storageSpace = this.maximum + 4) < 1024) {
                storageSpace = 1024;
            }
            this.temporaryStorage = new byte[storageSpace];
            try {
                this.getFile().setColumns(this.maximum);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.linageId = linageId;
            this.footingId = footingId;
            this.topId = topId;
            this.bottomId = bottomId;
            this.linage = linage;
            this.footing = footing;
            this.top = top;
            this.bottom = bottom;
            this.codeSet = codeSet;
            if (blockTo < blockFrom) {
                blockTo = blockFrom;
            }
            if (isRecords) {
                if (blockTo > 0) {
                    blockTo *= recordTo;
                }
                if (blockFrom > 0) {
                    blockFrom *= recordTo;
                }
            }
            this.blockFrom = blockFrom;
            this.blockTo = blockTo;
            if (assignTo != null) {
                this.setFilename(assignTo);
                if (assignTo.startsWith("env:")) {
                    String recfm;
                    String ddname = assignTo.substring(4);
                    switch (recfm = RuntimeEnvironment.getGlobalParameter(ddname + ".recfm")) {
                        case "fba": {
                            this.isFormatFBA = true;
                            break;
                        }
                        case "vba": {
                            this.isFormatVBA = true;
                            break;
                        }
                        case "lseq": {
                            if ("3".equals(RuntimeEnvironment.getGlobalParameter("DT"))) break;
                            this.setLineSequential();
                            break;
                        }
                    }
                } else {
                    String recfm;
                    switch (recfm = RuntimeEnvironment.getGlobalParameter(assignTo + ".recfm")) {
                        case "fba": {
                            this.isFormatFBA = true;
                            break;
                        }
                        case "vba": {
                            this.isFormatVBA = true;
                            break;
                        }
                        case "lseq": {
                            if ("3".equals(RuntimeEnvironment.getGlobalParameter("DT"))) break;
                            this.setLineSequential();
                            break;
                        }
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this;
    }

    public seqFile endDeclare() {
        return this;
    }

    public boolean fixed() {
        if (this.cached) {
            return this.cachedFixed;
        }
        if (this.override_fixed) {
            return true;
        }
        return !this.variable();
    }

    public boolean variable() {
        if (this.cached) {
            return this.cachedVariable;
        }
        if (this.override_variable) {
            return true;
        }
        if (this.override_fixed) {
            return false;
        }
        if (this.protocol == Protocol.MICROFOCUS) {
            if (this.override_varying) {
                return true;
            }
            return this.dependingOn != null && !this.lineSequential;
        }
        return (this.minimum != this.maximum || this.dependingOn != null) && !this.lineSequential;
    }

    public seqFile setLineSequential() {
        return this.setLineSequential(true);
    }

    protected void setFormatFBA() {
        this.isFormatFBA = true;
    }

    public seqFile setLineSequential(boolean state) {
        this.lineSequential = this.permanentLineSequential = state;
        this.getFile().setLineSequential(this.permanentLineSequential);
        return this;
    }

    public void setFileName(smartFile smartSeqFile, String assignToParm) {
        String func = "seqFile.setFilename(): ";
        seqFile.initFilesystems();
        if (assignToParm == null) {
            return;
        }
        if (assignToParm.toUpperCase().startsWith("UT_S_") || assignToParm.toUpperCase().startsWith("UT-S-")) {
            assignToParm = assignToParm.substring(5);
        } else if (assignToParm.toUpperCase().startsWith("LINE:UT_S_") || assignToParm.toUpperCase().startsWith("LINE:UT-S-")) {
            assignToParm = assignToParm.substring(10);
        } else if (assignToParm.toUpperCase().startsWith("LINE:")) {
            assignToParm = assignToParm.substring(5);
        }
        String assignTo = this.aliasFilename(assignToParm);
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer("seqFile.setFilename(): 1. assignToParm=" + assignToParm + ". assignTo=" + assignTo + ". ");
        }
        String loAssignTo = assignTo.toLowerCase();
        this.protocol = Protocol.ECOBOL;
        if (loAssignTo.startsWith("raw:")) {
            assignTo = assignTo.substring(4);
            this.protocol = Protocol.RAWMODE;
        }
        if (loAssignTo.startsWith("ims:")) {
            this.protocol = Protocol.RAWMODE;
        }
        if (loAssignTo.startsWith("ec:")) {
            assignTo = assignTo.substring(3);
            this.protocol = Protocol.ECOBOL;
        } else if (loAssignTo.startsWith("ecobol:")) {
            assignTo = assignTo.substring(7);
            this.protocol = Protocol.ECOBOL;
        } else if (loAssignTo.startsWith("mf:")) {
            assignTo = assignTo.substring(3);
            this.protocol = Protocol.MICROFOCUS;
        } else if (loAssignTo.startsWith("mf3:") || loAssignTo.startsWith("mf8:")) {
            assignTo = assignTo.substring(4);
            this.protocol = Protocol.MICROFOCUS;
        } else if (loAssignTo.startsWith("acu:")) {
            assignTo = assignTo.substring(4);
            this.protocol = Protocol.ACUCOBOL;
        } else if (loAssignTo.startsWith("ibm:")) {
            assignTo = assignTo.substring(4);
            this.protocol = this.blockFrom == this.blockTo && this.blockFrom > 0 ? Protocol.IBMVB : Protocol.IBMV;
            this.protocol = Protocol.IBMV;
        } else if (loAssignTo.startsWith("ibmv:")) {
            assignTo = assignTo.substring(5);
            this.protocol = Protocol.IBMV;
        } else if (loAssignTo.startsWith("ibmvb:")) {
            assignTo = assignTo.substring(6);
            this.protocol = Protocol.IBMVB;
            this.blkSize = 0;
            this.blkSizeCurrent = 0;
            this.blkSizeLastPosn = 0L;
            this.blkSizePartial = false;
        } else if (loAssignTo.startsWith("sync:")) {
            assignTo = assignTo.substring(5);
            this.protocol = Protocol.SYNCSORT;
        }
        if (defaultMicrofocus) {
            this.protocol = Protocol.MICROFOCUS;
        } else if (defaultAcucobol) {
            this.protocol = Protocol.ACUCOBOL;
        } else if (defaultIbmV) {
            this.protocol = Protocol.IBMV;
        } else if (defaultIbmVB) {
            this.protocol = Protocol.IBMVB;
            this.blkSize = 0;
            this.blkSizeCurrent = 0;
            this.blkSizeLastPosn = 0L;
            this.blkSizePartial = false;
        } else if (defaultSyncSort) {
            this.protocol = Protocol.SYNCSORT;
        }
        if (this.protocol == Protocol.MICROFOCUS) {
            this.alignment = 4;
            String os = RuntimeEnvironment.getGlobalParameter("os.name");
            String string2 = os = os != null ? os.toUpperCase() : "";
            if (os.startsWith("WIN") || os.startsWith("OS2") || os.startsWith("OS/2")) {
                this.microfocus_win = true;
            } else {
                this.microfocus_unix = true;
            }
        }
        if (loAssignTo.startsWith("mfu:")) {
            assignTo = assignTo.substring(4);
            this.protocol = Protocol.MICROFOCUS;
            this.microfocus_unix = true;
            this.microfocus_win = false;
            this.alignment = 4;
        }
        if (loAssignTo.startsWith("mfw:")) {
            assignTo = assignTo.substring(4);
            this.protocol = Protocol.MICROFOCUS;
            this.microfocus_unix = false;
            this.microfocus_win = true;
            this.alignment = 4;
        }
        smartSeqFile.setFilename(assignTo, this.permanentLineSequential);
        this.lineSequential = smartSeqFile.isLineSequential();
        if (this.blockFrom > this.blockTo) {
            this.blockTo = this.blockFrom;
        }
        if (this.blockTo > 0) {
            smartSeqFile.setBlockSize(this.blockTo);
        }
        if (this.protocol == Protocol.IBMVB) {
            this.blkSize = this.maximum == 0 || this.blockTo == 0 ? 0 : 4 + this.blockTo + 4 * (this.blockTo / this.maximum);
        }
    }

    public void setFilename(String assignToParm) {
        this.setFileName(this.getFile(), assignToParm);
    }

    @Override
    public String getFilename() {
        return this.getFile() != null ? this.getFile().getFilename() : null;
    }

    public void setFixed() {
        this.newModes = 1;
    }

    public void setVariable() {
        this.newModes = 2;
    }

    private String currentFilename() {
        if (this.filenameVariable != null) {
            String filename = this.filenameVariable.toString().replaceAll("\"", "");
            if (filename != null) {
                filename = filename.trim();
                filename = this.aliasFilename(filename);
                this.getFile().setFilename(filename, this.permanentLineSequential);
            }
        } else if (this.ddName != null) {
            String oldFilename = this.getFilename();
            String filename = this.aliasFilename(this.ddName);
            if (filename != null && oldFilename != null && !filename.equalsIgnoreCase(oldFilename)) {
                this.setFilename(filename);
            }
        }
        return this.getFilename();
    }

    @Override
    public boolean open(int mode) {
        try {
            mode = LockFile.transformOpenMode(mode);
            String filename = this.currentFilename();
            if (filename.equalsIgnoreCase("NUL") || filename.equalsIgnoreCase("/dev/null")) {
                this.noOps = true;
                this.iostatus(0);
                return true;
            }
            mode = this.setOpenMode(mode);
            this.override_fixed = (this.newModes & 1) != 0;
            this.override_variable = (this.newModes & 2) != 0;
            this.override_varying = (this.newModes & 4) != 0;
            try {
                this.lockRecord.open(filename, mode & 0x16000);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.readSize = -1;
            if ((mode & 1) != 0) {
                this.setReadable(true);
            } else {
                this.setReadable(false);
            }
            if ((mode & 2) != 0) {
                this.setWritable(true);
            } else {
                this.setWritable(false);
            }
            if ((mode & 4) != 0) {
                this.setReadable(false);
                this.setWritable(true);
                this.setExtend(true);
            } else {
                this.setExtend(false);
            }
            try {
                if (this.topId != null) {
                    this.getFile().setTop(this.topId);
                } else {
                    this.getFile().setTop(this.top);
                }
                if (this.bottomId != null) {
                    this.getFile().setBottom(this.bottomId);
                } else {
                    this.getFile().setBottom(this.bottom);
                }
                if (this.footingId != null) {
                    this.getFile().setFooter(this.footingId);
                } else {
                    this.getFile().setFooter(this.footing);
                }
                if (this.linageId != null) {
                    this.getFile().setLinage(this.linageId);
                } else if (this.linage > 0) {
                    this.getFile().setLinage(this.linage);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.protocol == Protocol.IBMVB) {
                this.blkSizeCurrent = 0;
                this.blkSizeLastPosn = 0L;
                this.blkSizePartial = false;
            }
            if (this.optional || this.protocol == Protocol.MICROFOCUS && (mode & 4) != 0) {
                mode |= 8;
            }
            this.cacheValues();
            try {
                boolean isOpen;
                int returnCode = this.getFile().open(mode);
                this.iostatus(returnCode);
                this.getFile().setCharset(this.dataCharset);
                this.lineSep = smartFile.lineSeparatorBytes;
                if (Variable.memoryCharset != null && this.getFile().getCharset() != null && Variable.memoryCharset != this.getFile().getCharset()) {
                    this.lineSep = new String(smartFile.lineSeparatorBytes, this.getFile().getCharset()).getBytes(Variable.memoryCharset);
                }
                boolean bl = isOpen = returnCode >= -9 && returnCode <= 0;
                if (!this.lineSequential && isOpen && this.protocol == Protocol.MICROFOCUS && this.variable()) {
                    boolean fileAlreadyExists;
                    boolean bl2 = fileAlreadyExists = !this.getFile().isNewFile();
                    if (fileAlreadyExists) {
                        returnCode = this.readHeader();
                    } else {
                        this.writeHeader();
                    }
                    this.iostatus(returnCode);
                    isOpen = returnCode >= -9 && returnCode <= 0;
                }
                return isOpen;
            }
            catch (Exception e) {
                this.iostatus(-35);
                this.isOpen = false;
                return false;
            }
        }
        catch (Throwable javaException) {
            this.iostatus(-98);
            this.isOpen = false;
            return false;
        }
    }

    public synchronized boolean openTimeoutSeconds(int mode, Numeric timeout) {
        try {
            mode = LockFile.transformOpenMode(mode);
            int timeout_mask = 0x2100000;
            mode &= ~timeout_mask;
            double seconds = timeout.toDouble();
            boolean success = false;
            long currentTime = System.currentTimeMillis();
            long finalTime = currentTime + (long)(seconds * 1000.0);
            do {
                this.iostatus(0);
                success = this.open(mode);
                if (success || System.currentTimeMillis() >= finalTime) continue;
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            } while (!success && System.currentTimeMillis() < finalTime);
            return success;
        }
        catch (Throwable javaException) {
            this.iostatus(-98);
            this.isOpen = false;
            return false;
        }
    }

    public synchronized boolean openTimeoutRetries(int mode, Numeric timeout) {
        try {
            mode = LockFile.transformOpenMode(mode);
            int timeout_mask = 0x2100000;
            mode &= ~timeout_mask;
            int attempts = timeout.toInt();
            if (attempts < 0) {
                attempts = 0;
            }
            ++attempts;
            boolean success = false;
            do {
                this.iostatus(0);
                success = this.open(mode);
                if (success || --attempts <= 0) continue;
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            } while (!success && attempts > 0);
            return success;
        }
        catch (Throwable javaException) {
            this.iostatus(-98);
            this.isOpen = false;
            return false;
        }
    }

    public synchronized boolean openTimeoutRetries(int mode) {
        try {
            mode = LockFile.transformOpenMode(mode);
            int timeout_mask = 0x2100000;
            mode &= ~timeout_mask;
            boolean success = false;
            do {
                this.iostatus(0);
                success = this.open(mode);
                if (success) continue;
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            } while (!success);
            return success;
        }
        catch (Throwable javaException) {
            this.iostatus(-98);
            this.isOpen = false;
            return false;
        }
    }

    @Override
    public boolean close() {
        return this.close(0);
    }

    public boolean close(int mode) {
        if (this.noOps) {
            this.iostatus(0);
            return true;
        }
        String currentJobType = Objects.toString(RuntimeEnvironment.getGlobalParameter(CURRENT_JOB_TYPE), "");
        if (!this.isVSEAssignFile && currentJobType.equals(JOB_TYPE_JCS) && this.size > 0 && this.getFile().getFilename() != null) {
            try {
                File fileName = new File(this.getFile().getFilename());
                DCB dcb = DCBFactory.getInstance(fileName.getName(), this.getFile().getFilename());
                if (dcb instanceof DCBDB) {
                    dcb.loadDCB(true);
                    dcb.setLrecl(this.size);
                    dcb.saveDCB();
                }
            }
            catch (Exception fileName) {
                // empty catch block
            }
        }
        try {
            if (this.protocol == Protocol.IBMVB && this.blkSizePartial && this.blkSizeCurrent != 0 && this.blkSizeCurrent != this.blkSize) {
                this.getFile().seek(this.blkSizeLastPosn);
                this.fourbytes[3] = (byte)(this.blkSizeCurrent & 0xFF);
                this.fourbytes[2] = (byte)(this.blkSizeCurrent >> 8 & 0xFF);
                this.fourbytes[1] = (byte)(this.blkSizeCurrent >> 16 & 0xFF);
                this.fourbytes[0] = (byte)(this.blkSizeCurrent >> 24 & 0xFF);
                this.getFile().write(this.fourbytes, 0, 4);
                this.getFile().seek(this.getFile().length());
                this.blkSizePartial = false;
            }
            this.invalidateCacheValues();
            this.readSize = -1;
            this.lockRecord.close();
            int returnCode = this.getFile().close(mode);
            this.iostatus(returnCode);
            this.isOpen = returnCode == 0;
            return !this.isOpen;
        }
        catch (Throwable javaException) {
            this.iostatus(-98);
            this.isOpen = false;
            return false;
        }
    }

    public boolean readNext(Variable data) {
        return this.read(data);
    }

    public boolean readPrevious(Variable data) {
        return this.readNext(data);
    }

    public boolean readNext(Variable data, int mode, Numeric timeout) {
        return this.read(data, mode, timeout);
    }

    public boolean readPrevious(Variable data, int mode, Numeric timeout) {
        return this.readNext(data, mode, timeout);
    }

    public boolean read(Variable data, int mode, Numeric timeout) {
        block25: {
            if (this.noOps) {
                this.iostatus(0);
                return true;
            }
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.finer("variable, int, Numeric: 0.");
            }
            try {
                boolean locking;
                if ("NUL".equals(this.getFile().getFilename())) {
                    this.iostatus(-10);
                    return true;
                }
                boolean bl = locking = this.lockingAutomatic() && (mode & 0x400000) == 0 || this.lockingManual() && (mode & 0x1000000) != 0;
                if (!locking) {
                    boolean readFlag = this.read(data);
                    if (LogSetup.IS_LOGGING) {
                        LogSetup.LOGGER.finer("variable, int, Numeric: not locking. readFlag=" + readFlag + ". ");
                    }
                    return readFlag;
                }
                int retries = 0;
                long currentTime = 0L;
                long finalTime = 0L;
                if ((mode & 0x100000) != 0 && timeout != null) {
                    double seconds = timeout.toDouble();
                    currentTime = System.currentTimeMillis();
                    finalTime = currentTime + (long)(seconds * 1000.0);
                }
                long lockNumber = 0L;
                if (!locking) break block25;
                lockNumber = this.getFile().getFilePointer();
                boolean retry = false;
                do {
                    int determineSize;
                    if (this.dependingOn != null) {
                        determineSize = this.dependingOn.toInt();
                    } else {
                        determineSize = this.maximum;
                        if (determineSize <= 0) {
                            determineSize = data.length();
                        }
                    }
                    if (this.lockRecord.lock(lockNumber, determineSize)) {
                        boolean status = this.read(data, determineSize);
                        if (this.isInput()) {
                            this.lockRecord.unlock(lockNumber);
                            return status;
                        }
                        if (this.isOK()) {
                            if (this.lockingSingle()) {
                                return status;
                            }
                            if ((mode & 0x200000) != 0) {
                                this.lockRecord.unlock(lockNumber);
                                return status;
                            }
                            if (this.lockingManual() && (mode & 0x1000000) == 0) {
                                this.lockRecord.unlock(lockNumber);
                                return status;
                            }
                            return status;
                        }
                        if (this.lockingSingle()) {
                            return status;
                        }
                        if ((mode & 0x200000) != 0) {
                            return status;
                        }
                        this.lockRecord.unlock(lockNumber);
                        return status;
                    }
                    retry = false;
                    if ((mode & 0x2000000) != 0) {
                        if (timeout != null && ++retries >= timeout.toInt()) continue;
                        try {
                            Thread.sleep(500L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        retry = true;
                        continue;
                    }
                    if ((mode & 0x100000) == 0 || System.currentTimeMillis() >= finalTime) continue;
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (System.currentTimeMillis() >= finalTime) continue;
                    retry = true;
                } while (retry);
                this.iostatus(-99);
            }
            catch (Throwable javaException) {
                this.iostatus(-98);
            }
        }
        return false;
    }

    @Override
    public boolean read(Variable data) {
        return this.read(data, this.maximum);
    }

    public boolean read(Variable data, int determineSize) {
        if (this.noOps) {
            this.iostatus(0);
            return true;
        }
        try {
            if (this.isExtend()) {
                this.iostatus(-47);
                return false;
            }
            data.prepareMemoryForWrite();
            this.readSize = determineSize;
            int returnCode = 0;
            int readingAlignment = 0;
            if (!this.lineSequential && this.variable() && this.protocol != Protocol.RAWMODE) {
                switch (this.protocol) {
                    case MICROFOCUS: {
                        readingAlignment = this.MF_prefixSize();
                        returnCode = this.getFile().read(this.temporaryStorage, 0, readingAlignment);
                        if (returnCode < 0) {
                            this.iostatus(returnCode);
                            this.readSize = -1;
                            return returnCode == -10;
                        }
                        this.readSize = readingAlignment == 4 ? (this.temporaryStorage[0] & 0xF) << 24 | (this.temporaryStorage[1] & 0xFF) << 16 | (this.temporaryStorage[2] & 0xFF) << 8 | this.temporaryStorage[3] & 0xFF : (this.temporaryStorage[0] & 0xF) << 8 | this.temporaryStorage[1] & 0xFF;
                        if ((readingAlignment = readingAlignment + this.readSize & 3) <= 0) break;
                        readingAlignment = 4 - readingAlignment;
                        break;
                    }
                    case ACUCOBOL: {
                        returnCode = this.getFile().read(this.fourbytes, 0, 2);
                        if (returnCode < 0) {
                            this.iostatus(returnCode);
                            this.readSize = -1;
                            return returnCode == -10;
                        }
                        this.readSize = (this.fourbytes[0] & 0xFF) << 8 | this.fourbytes[1] & 0xFF;
                        break;
                    }
                    case IBMV: {
                        returnCode = this.getFile().read(this.fourbytes, 0, 4);
                        if (returnCode < 0) {
                            this.iostatus(returnCode);
                            this.readSize = -1;
                            return returnCode == -10;
                        }
                        if (returnCode >= 0) {
                            if (returnCode != 4) {
                                this.readSize = -1;
                                if (LogSetup.IS_LOGGING) {
                                    LogSetup.LOGGER.severe("IBMV record descriptor word (RDW) must be 4 bytes");
                                }
                                this.iostatus(-34);
                                return false;
                            }
                            if (this.fourbytes[2] != 0 || this.fourbytes[3] != 0) {
                                this.readSize = -1;
                                if (LogSetup.IS_LOGGING) {
                                    LogSetup.LOGGER.severe("IBMV record descriptor word (RDW) must contain zeros in bytes 3 & 4");
                                }
                                this.iostatus(-34);
                                return false;
                            }
                        }
                        this.readSize = ((this.fourbytes[0] & 0xFF) << 8 | this.fourbytes[1] & 0xFF) - 4;
                        break;
                    }
                    case IBMVB: {
                        if (this.blkSizeCurrent == 0 || this.blkSizeCurrent >= this.blkSize) {
                            returnCode = this.getFile().read(this.fourbytes, 0, 4);
                            if (returnCode < 0) {
                                this.iostatus(returnCode);
                                this.readSize = -1;
                                return returnCode == -10;
                            }
                            if (returnCode != 4) {
                                this.readSize = -1;
                                if (LogSetup.IS_LOGGING) {
                                    LogSetup.LOGGER.severe("IBMVB block descriptor word (BDW) must be 4 bytes");
                                }
                                this.iostatus(-34);
                                return false;
                            }
                            this.blkSize = ((this.fourbytes[0] & 0xFF) << 24 | (this.fourbytes[1] & 0xFF) << 16 | (this.fourbytes[2] & 0xFF) << 8 | this.fourbytes[3] & 0xFF) - 4;
                            this.blkSizeCurrent = 4;
                        }
                        if ((returnCode = this.getFile().read(this.fourbytes, 0, 4)) < 0) {
                            this.iostatus(returnCode);
                            this.readSize = -1;
                            return returnCode == -10;
                        }
                        if (returnCode >= 0) {
                            if (returnCode != 4) {
                                this.readSize = -1;
                                if (LogSetup.IS_LOGGING) {
                                    LogSetup.LOGGER.severe("IBMVB record descriptor word (RDW) must be 4 bytes");
                                }
                                this.iostatus(-34);
                                return false;
                            }
                            if (this.fourbytes[2] != 0 || this.fourbytes[3] != 0) {
                                this.readSize = -1;
                                if (LogSetup.IS_LOGGING) {
                                    LogSetup.LOGGER.severe("IBMVB record descriptor word (RDW) must contain zeros in bytes 3 & 4");
                                }
                                this.iostatus(-34);
                                return false;
                            }
                        }
                        this.readSize = ((this.fourbytes[0] & 0xFF) << 8 | this.fourbytes[1] & 0xFF) - 4;
                        this.blkSizeCurrent += 4 + this.readSize;
                        break;
                    }
                    case SYNCSORT: {
                        returnCode = this.getFile().read(this.fourbytes, 0, 2);
                        if (returnCode < 0) {
                            this.iostatus(returnCode);
                            this.readSize = -1;
                            return returnCode == -10;
                        }
                        this.readSize = (this.fourbytes[0] & 0xFF) << 8 | this.fourbytes[1] & 0xFF;
                        break;
                    }
                    default: {
                        returnCode = this.getFile().read(this.fourbytes, 0, 4);
                        if (returnCode < 0) {
                            this.iostatus(returnCode);
                            this.readSize = -1;
                            return returnCode == -10;
                        }
                        if (LogSetup.IS_LOGGING) {
                            LogSetup.LOGGER.finer("variable, int. 6: returnCode=" + returnCode);
                        }
                        this.readSize = (this.fourbytes[3] & 0xFF) << 24 | (this.fourbytes[2] & 0xFF) << 16 | (this.fourbytes[1] & 0xFF) << 8 | this.fourbytes[0] & 0xFF;
                    }
                }
            }
            if (this.maximum > 0 && this.readSize > this.maximum) {
                if (LogSetup.IS_LOGGING) {
                    LogSetup.LOGGER.severe("Variable length specified within the record of " + this.readSize + " larger than maximum for this FD of " + this.maximum);
                }
                this.iostatus(-4);
                return false;
            }
            if (this.minimum > 0 && this.readSize < this.minimum) {
                if (LogSetup.IS_LOGGING) {
                    LogSetup.LOGGER.severe("Variable length specified within the record of " + this.readSize + " smaller than minimum for this FD of " + this.minimum);
                }
                this.iostatus(-4);
                return false;
            }
            if (readingAlignment > 0) {
                int tempSize = readingAlignment + this.readSize;
                if (tempSize > this.temporaryStorage.length) {
                    this.temporaryStorage = new byte[tempSize];
                }
                returnCode = this.getFile().read(this.temporaryStorage, 0, tempSize);
                if (this.dataCompression != 0 && MFFile.GetCompression(this.dataCompression) != null) {
                    this.temporaryStorage = MFFile.GetCompression(this.dataCompression).decompress(this.temporaryStorage, 0, this.readSize);
                    this.readSize = this.temporaryStorage.length;
                }
                if (returnCode > 0) {
                    returnCode -= readingAlignment;
                }
                data.getMemory().copy(this.temporaryStorage, 0, data.getAddress(), this.readSize);
            } else {
                byte[] buf = new byte[this.readSize <= 0 ? data.getSize() : this.readSize];
                returnCode = this.getFile().read(buf, 0, this.readSize);
                if (returnCode >= 0) {
                    data.getMemory().copy(buf, 0, data.getAddress(), this.readSize > returnCode ? this.readSize : returnCode);
                }
            }
            this.usedAlignment = readingAlignment;
            if (this.codeSet != null) {
                this.readCodesetInPlace(data.getMemory(), data.getAddress(), this.readSize);
            }
            if (returnCode >= 0) {
                this.readSize = returnCode;
            }
            if (returnCode >= 0 && returnCode != this.readSize && !this.lineSequential) {
                returnCode = -4;
            }
            if (this.dependingOn != null) {
                this.dependingOn.move(this.readSize);
            }
            if (returnCode >= 0) {
                returnCode = 0;
            }
            this.iostatus(returnCode);
            if (returnCode <= -10) {
                this.readSize = -1;
                return true;
            }
        }
        catch (Throwable javaException) {
            this.iostatus(-98);
        }
        return false;
    }

    public int read(byte[] data) {
        int returnCode = 0;
        if (this.isExtend()) {
            returnCode = -47;
            this.iostatus(-47);
            return returnCode;
        }
        this.readSize = this.dependingOn != null ? this.dependingOn.toInt() : (this.maximum <= 0 ? data.length : this.maximum);
        int readingAlignment = 0;
        if (!this.lineSequential && this.variable() && this.protocol != Protocol.RAWMODE) {
            switch (this.protocol) {
                case MICROFOCUS: {
                    readingAlignment = this.MF_prefixSize();
                    returnCode = this.getFile().read(this.temporaryStorage, 0, readingAlignment);
                    this.readSize = readingAlignment == 4 ? (this.temporaryStorage[0] & 0xF) << 24 | (this.temporaryStorage[1] & 0xFF) << 16 | (this.temporaryStorage[2] & 0xFF) << 8 | this.temporaryStorage[3] & 0xFF : (this.temporaryStorage[0] & 0xF) << 8 | this.temporaryStorage[1] & 0xFF;
                    readingAlignment = readingAlignment + this.readSize & 3;
                    if (readingAlignment <= 0) break;
                    readingAlignment = 4 - readingAlignment;
                    break;
                }
                case ACUCOBOL: {
                    returnCode = this.getFile().read(this.fourbytes, 0, 2);
                    this.readSize = (this.fourbytes[0] & 0xFF) << 8 | this.fourbytes[1] & 0xFF;
                    break;
                }
                case IBMV: {
                    returnCode = this.getFile().read(this.fourbytes, 0, 4);
                    this.readSize = (this.fourbytes[0] & 0xFF) << 8 | this.fourbytes[1] & 0xFF;
                    break;
                }
                case IBMVB: {
                    if (this.blkSizeCurrent == 0 || this.blkSizeCurrent >= this.blkSize) {
                        returnCode = this.getFile().read(this.fourbytes, 0, 4);
                        this.blkSize = (this.fourbytes[0] & 0xFF) << 24 | (this.fourbytes[1] & 0xFF) << 16 | (this.fourbytes[2] & 0xFF) << 8 | this.fourbytes[3] & 0xFF;
                        this.blkSizeCurrent = 4;
                    }
                    returnCode = this.getFile().read(this.fourbytes, 0, 4);
                    this.readSize = ((this.fourbytes[0] & 0xFF) << 8 | this.fourbytes[1] & 0xFF) - 4;
                    this.blkSizeCurrent += 4 + this.readSize;
                    break;
                }
                case SYNCSORT: {
                    returnCode = this.getFile().read(this.fourbytes, 0, 2);
                    this.readSize = (this.fourbytes[0] & 0xFF) << 8 | this.fourbytes[1] & 0xFF;
                    break;
                }
                default: {
                    returnCode = this.getFile().read(this.fourbytes, 0, 4);
                    this.readSize = (this.fourbytes[3] & 0xFF) << 24 | (this.fourbytes[2] & 0xFF) << 16 | (this.fourbytes[1] & 0xFF) << 8 | this.fourbytes[0] & 0xFF;
                }
            }
            if (returnCode < 0) {
                this.iostatus(returnCode);
                this.readSize = -1;
                return returnCode;
            }
        }
        if (this.readSize > this.maximum) {
            this.readSize = this.maximum;
        }
        if (readingAlignment > 0) {
            int tempSize = readingAlignment + this.readSize;
            if (tempSize > this.temporaryStorage.length) {
                this.temporaryStorage = new byte[tempSize];
            }
            if ((returnCode = this.getFile().read(this.temporaryStorage, 0, tempSize)) > 0) {
                returnCode -= readingAlignment;
            }
            System.arraycopy(this.temporaryStorage, 0, data, 0, data.length);
        } else {
            returnCode = this.getFile().read(data, 0, this.readSize);
        }
        this.usedAlignment = readingAlignment;
        if (returnCode > 0) {
            this.readSize = returnCode;
        }
        if (returnCode > 0 && returnCode != this.readSize && !this.lineSequential) {
            returnCode = -4;
        }
        if (this.dependingOn != null) {
            this.dependingOn.move(this.readSize);
        }
        if (returnCode >= 0) {
            returnCode = 0;
        }
        this.iostatus(returnCode);
        if (returnCode == -10) {
            this.readSize = -1;
            return returnCode;
        }
        if (returnCode <= -10) {
            this.readSize = -1;
        }
        return returnCode;
    }

    public boolean write(Variable data, int mode, Numeric timeout) {
        return this.write(data, mode, timeout, false);
    }

    private byte[] formatLineSequential(byte[] data, int dataAddress, int dataLength) {
        if (isStripSpaces) {
            for (int stripSpaceNull = dataLength - 1; stripSpaceNull >= 0; --stripSpaceNull) {
                if (this.lineSequential && stripSpaceNull == 0) {
                    dataLength = 0;
                }
                if (data[dataAddress + stripSpaceNull] == 32 || isStripNull && data[dataAddress + stripSpaceNull] == 0) continue;
                dataLength = stripSpaceNull + 1;
                break;
            }
        }
        int escapes = 0;
        byte check = 0;
        if (isInsertNull) {
            block9: for (int i = 0; i < dataLength; ++i) {
                check = data[dataAddress + i];
                switch (data[dataAddress + i]) {
                    case 0: 
                    case 10: 
                    case 13: 
                    case 26: {
                        ++escapes;
                        continue block9;
                    }
                    default: {
                        if (!this.lineSequential || this.protocol != Protocol.MICROFOCUS || check >= 32 || check <= 0) continue block9;
                        ++escapes;
                    }
                }
            }
        }
        if (escapes > 0) {
            byte[] lineSep = smartFile.lineSeparatorBytes;
            int lineSepLength = lineSep.length;
            byte[] copy = new byte[dataLength + lineSepLength + escapes];
            int store = 0;
            for (int i = 0; i < dataLength; ++i) {
                check = data[dataAddress + i];
                switch (check) {
                    case 0: 
                    case 10: 
                    case 13: 
                    case 26: {
                        copy[store++] = 0;
                        break;
                    }
                    default: {
                        if (!this.lineSequential || this.protocol != Protocol.MICROFOCUS || check >= 32 || check <= 0) break;
                        copy[store++] = 0;
                    }
                }
                copy[store++] = check;
            }
            System.arraycopy(lineSep, 0, copy, store, lineSepLength);
            return copy;
        }
        int lineSepLength = this.lineSep.length;
        byte[] copy = new byte[dataLength + lineSepLength];
        try {
            System.arraycopy(data, dataAddress, copy, 0, dataLength);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        System.arraycopy(this.lineSep, 0, copy, dataLength, lineSepLength);
        return copy;
    }

    private byte[] formatLineSequentialRewrite(byte[] data, int dataAddress, int dataLength) {
        if (this.rewriteSize < 0) {
            this.rewriteSize = dataLength;
        }
        int escapes = 0;
        if (isInsertNull) {
            for (int i = 0; i < dataLength; ++i) {
                switch (data[dataAddress + i]) {
                    case 0: 
                    case 10: 
                    case 13: 
                    case 26: {
                        ++escapes;
                    }
                }
            }
        }
        int check = 0;
        if (escapes > 0) {
            byte[] lineSep = smartFile.lineSeparatorBytes;
            int lineSepLength = lineSep.length;
            int desiredSize = this.rewriteSize + lineSepLength;
            byte[] copy2 = new byte[this.rewriteSize + lineSepLength];
            int store = 0;
            int i = 0;
            int space = 32;
            block13: while (store < desiredSize) {
                check = i < dataLength ? data[dataAddress + i] : space;
                switch (check) {
                    case 0: 
                    case 10: 
                    case 13: 
                    case 26: {
                        copy2[store++] = 0;
                        if (store >= desiredSize) {
                            copy2[store - 1] = 32;
                            break block13;
                        }
                    }
                    default: {
                        copy2[store++] = check;
                        ++i;
                        continue block13;
                    }
                }
            }
            System.arraycopy(lineSep, 0, copy2, desiredSize - lineSepLength, lineSepLength);
            return copy2;
        }
        byte[] lineSep = smartFile.lineSeparatorBytes;
        int lineSepLength = lineSep.length;
        if (dataLength < this.rewriteSize) {
            byte[] copy = new byte[this.rewriteSize + lineSepLength];
            try {
                System.arraycopy(data, dataAddress, copy, 0, dataLength);
            }
            catch (Throwable copy2) {
                // empty catch block
            }
            int space = 32;
            for (int i = dataLength; i < this.rewriteSize; ++i) {
                copy[i] = space;
            }
            System.arraycopy(lineSep, 0, copy, this.rewriteSize, lineSepLength);
            return copy;
        }
        if (dataLength > this.rewriteSize) {
            byte[] copy = new byte[this.rewriteSize + lineSepLength];
            try {
                System.arraycopy(data, dataAddress, copy, 0, this.rewriteSize);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            System.arraycopy(lineSep, 0, copy, this.rewriteSize, lineSepLength);
            return copy;
        }
        byte[] copy = new byte[dataLength + lineSepLength];
        try {
            System.arraycopy(data, dataAddress, copy, 0, dataLength);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        System.arraycopy(lineSep, 0, copy, dataLength, lineSepLength);
        return copy;
    }

    private byte[] formatLineSequentialNoControl(byte[] data, int dataAddress, int dataLength) {
        for (int stripSpaces = dataLength - 1; stripSpaces >= 0; --stripSpaces) {
            if (data[dataAddress + stripSpaces] == 32) continue;
            dataLength = stripSpaces + 1;
            break;
        }
        byte[] lineSep = smartFile.lineSeparatorBytes;
        int lineSepLength = lineSep.length;
        byte[] copy = new byte[dataLength + lineSepLength];
        try {
            System.arraycopy(data, dataAddress, copy, 0, dataLength);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        System.arraycopy(lineSep, 0, copy, dataLength, lineSepLength);
        return copy;
    }

    public boolean write(Variable data, int mode, Numeric timeout, boolean printSequential) {
        block18: {
            if (this.noOps) {
                this.iostatus(0);
                return true;
            }
            try {
                boolean locking;
                byte[] dataByteArray;
                data.flushToMemory();
                int dataAddress = data.getAddress();
                int dataLength = this.dependingOn != null ? this.dependingOn.toInt() : data.length();
                this.size = this.determineWriteSize(dataLength);
                if (!this.writeDataPrep()) {
                    return printSequential ? this.advance() : false;
                }
                if (data.odoNoSlide && data.isGroup() && data.itemSize < data.maxItemSize) {
                    dataByteArray = new byte[this.size];
                    data.getOdoBytes(dataByteArray, 0);
                } else {
                    dataByteArray = data.getMemory().getBytes(dataAddress, this.size);
                }
                dataAddress = 0;
                if (printSequential) {
                    dataByteArray = this.formatLineSequential(dataByteArray, dataAddress, this.size);
                    dataAddress = 0;
                    this.size = dataByteArray.length;
                }
                boolean bl = locking = this.lockingAutomatic() && (mode & 0x400000) == 0 || this.lockingManual() && (mode & 0x1000000) != 0;
                if (!locking) {
                    return this.writeData(dataByteArray, dataAddress, this.size);
                }
                int retries = 0;
                long currentTime = 0L;
                long finalTime = 0L;
                if ((mode & 0x100000) != 0 && timeout != null) {
                    double seconds = timeout.toDouble();
                    currentTime = System.currentTimeMillis();
                    finalTime = currentTime + (long)(seconds * 1000.0);
                }
                long lockNumber = 0L;
                if (!locking) break block18;
                lockNumber = this.getFile().getFilePointer();
                boolean retry = false;
                do {
                    if (this.lockRecord.lock(lockNumber, this.size)) {
                        boolean status = this.writeData(dataByteArray, dataAddress, this.size);
                        if (this.lockingSingle()) {
                            return status;
                        }
                        if ((mode & 0x1000000) != 0) {
                            return status;
                        }
                        this.lockRecord.unlock(lockNumber);
                        return status;
                    }
                    retry = false;
                    if ((mode & 0x2000000) != 0) {
                        if (timeout != null && ++retries >= timeout.toInt()) continue;
                        try {
                            Thread.sleep(500L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        retry = true;
                        continue;
                    }
                    if ((mode & 0x100000) == 0 || System.currentTimeMillis() >= finalTime) continue;
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (System.currentTimeMillis() >= finalTime) continue;
                    retry = true;
                } while (retry);
                this.iostatus(-99);
            }
            catch (Throwable javaException) {
                this.iostatus(-98);
            }
        }
        return false;
    }

    @Override
    public boolean write(Variable data) {
        return this.write(data, false);
    }

    public boolean write(Variable data, boolean printSequential) {
        if (this.noOps) {
            this.iostatus(0);
            return true;
        }
        try {
            byte[] dataByteArray;
            data.flushToMemory();
            int dataAddress = data.getAddress();
            int dataLength = this.dependingOn != null ? this.dependingOn.toInt() : data.length();
            this.size = this.determineWriteSize(dataLength);
            if (data.odoNoSlide && data.isGroup() && data.itemSize < data.maxItemSize) {
                dataByteArray = new byte[this.size];
                data.getOdoBytes(dataByteArray, 0);
            } else {
                dataByteArray = data.getMemory().getBytes(dataAddress, this.size);
            }
            dataAddress = 0;
            if (printSequential || this.lineSequential) {
                dataByteArray = this.formatLineSequential(dataByteArray, dataAddress, this.size);
                dataAddress = 0;
                this.size = dataByteArray.length;
            }
            if (!this.writeDataPrep()) {
                return printSequential ? this.advance() : false;
            }
            return this.write(dataByteArray, dataAddress, this.size);
        }
        catch (Throwable javaException) {
            this.iostatus(-98);
            return false;
        }
    }

    public boolean writeNoControl(Variable data) {
        return this.writeNoControl(data, false);
    }

    public boolean writeNoControl(Variable data, boolean printSequential) {
        try {
            byte[] dataByteArray;
            data.flushToMemory();
            int dataAddress = data.getAddress();
            int dataLength = this.dependingOn != null ? this.dependingOn.toInt() : data.length();
            this.size = this.determineWriteSize(dataLength);
            if (data.odoNoSlide && data.isGroup() && data.itemSize < data.maxItemSize) {
                dataByteArray = new byte[this.size];
                data.getOdoBytes(dataByteArray, 0);
            } else {
                dataByteArray = data.getMemory().getBytes(dataAddress, this.size);
            }
            dataAddress = 0;
            if (printSequential) {
                dataByteArray = this.formatLineSequentialNoControl(dataByteArray, dataAddress, this.size);
                dataAddress = 0;
                this.size = dataByteArray.length;
            }
            return this.writeNoControl(dataByteArray, dataAddress, this.size);
        }
        catch (Throwable javaException) {
            this.iostatus(-98);
            return false;
        }
    }

    public boolean writeNoControl(byte[] data, int offset, int length) {
        this.size = this.determineWriteSize(length);
        if (!(this.isOutput() || this.isExtend() || this.getFile() != null && this.getFile().isStream())) {
            int returnCode = -48;
            this.iostatus(returnCode);
            return false;
        }
        if (this.getFile() != null && (this.getOpenMode() & 4) != 0 && !this.getFile().isStream()) {
            this.getFile().seek(this.getFile().length());
        }
        this.readSize = -1;
        int returnCode = this.getFile().writeNoControl(data, offset, this.size);
        this.usedAlignment = 0;
        if (returnCode == -9 || returnCode == -93) {
            this.iostatus(0);
            return true;
        }
        this.iostatus(returnCode);
        return false;
    }

    public boolean write(byte[] data, int offset, int length) {
        if (!(this.isOutput() || this.isExtend() || this.getFile() != null && this.getFile().isStream())) {
            int returnCode = -48;
            this.iostatus(returnCode);
            return false;
        }
        this.size = this.determineWriteSize(length);
        if (this.writeDataPrep()) {
            return this.writeData(data, offset, this.size);
        }
        return false;
    }

    protected boolean writeDataPrep() {
        boolean errb = false;
        if (!(this.isOutput() || this.isExtend() || this.getFile() != null && this.getFile().isStream())) {
            this.iostatus(-48);
            return false;
        }
        this.readSize = -1;
        if (!this.lineSequential) {
            if (this.size < 0 || this.size > this.maximum) {
                errb = true;
            }
            if (this.size < this.minimum && !this.override_varying && !this.override_variable) {
                errb = true;
            }
        } else if (this.size < 0 || this.size > this.maximum + 2) {
            errb = true;
        }
        if (errb) {
            this.iostatus(-44);
            return false;
        }
        if (this.getFile() != null && (this.getOpenMode() & 4) != 0 && !this.getFile().isStream()) {
            this.getFile().seek(this.getFile().length());
        }
        return true;
    }

    protected boolean writeData(byte[] data, int offset, int size) {
        int returnCode;
        boolean endOfPage = false;
        int writingAlignment = 0;
        if (this.isFormatFBA || this.isFormatVBA) {
            ++size;
        }
        if (!this.lineSequential && this.variable() && this.protocol != Protocol.RAWMODE) {
            switch (this.protocol) {
                case MICROFOCUS: {
                    if (this.dataCompression != 0 && MFFile.GetCompression(this.dataCompression) != null) {
                        data = MFFile.GetCompression(this.dataCompression).compress(data, offset, size);
                        offset = 0;
                        size = data.length;
                    }
                    if ((writingAlignment = this.MF_prefixSize()) == 2) {
                        this.temporaryStorage[0] = (byte)(size >> 8 & 0xFF | 0x40);
                        this.temporaryStorage[1] = (byte)(size & 0xFF);
                    } else {
                        this.temporaryStorage[0] = (byte)(size >> 24 & 0xFF | 0x40);
                        this.temporaryStorage[1] = (byte)(size >> 16 & 0xFF);
                        this.temporaryStorage[2] = (byte)(size >> 8 & 0xFF);
                        this.temporaryStorage[3] = (byte)(size & 0xFF);
                    }
                    returnCode = this.getFile().write(this.temporaryStorage, 0, writingAlignment);
                    if (returnCode == -9) {
                        endOfPage = true;
                        returnCode = 0;
                    }
                    if ((writingAlignment = writingAlignment + size & 3) <= 0) break;
                    writingAlignment = 4 - writingAlignment;
                    break;
                }
                case ACUCOBOL: {
                    this.fourbytes[0] = (byte)(size >> 8 & 0xFF);
                    this.fourbytes[1] = (byte)(size & 0xFF);
                    returnCode = this.getFile().write(this.fourbytes, 0, 2);
                    break;
                }
                case IBMV: {
                    this.fourbytes[3] = 0;
                    this.fourbytes[2] = 0;
                    this.fourbytes[1] = (byte)(4 + size & 0xFF);
                    this.fourbytes[0] = (byte)(4 + size >> 8 & 0xFF);
                    returnCode = this.getFile().write(this.fourbytes, 0, 4);
                    break;
                }
                case IBMVB: {
                    if (this.blkSize == 0) {
                        this.blkSize = 8 + size;
                        this.blkSizeCurrent = 0;
                    }
                    if (this.blkSizeCurrent == 0 || this.blkSizeCurrent + size + 4 >= this.blkSize) {
                        if (this.blkSizeCurrent != 0 && this.blkSizeCurrent != this.blkSize) {
                            this.getFile().seek(this.blkSizeLastPosn);
                            this.fourbytes[3] = (byte)(this.blkSizeCurrent & 0xFF);
                            this.fourbytes[2] = (byte)(this.blkSizeCurrent >> 8 & 0xFF);
                            this.fourbytes[1] = (byte)(this.blkSizeCurrent >> 16 & 0xFF);
                            this.fourbytes[0] = (byte)(this.blkSizeCurrent >> 24 & 0xFF);
                            returnCode = this.getFile().write(this.fourbytes, 0, 4);
                            this.getFile().seek(this.getFile().length());
                        }
                        this.blkSizeLastPosn = this.getFile().length();
                        this.fourbytes[3] = (byte)(this.blkSize & 0xFF);
                        this.fourbytes[2] = (byte)(this.blkSize >> 8 & 0xFF);
                        this.fourbytes[1] = (byte)(this.blkSize >> 16 & 0xFF);
                        this.fourbytes[0] = (byte)(this.blkSize >> 24 & 0xFF);
                        returnCode = this.getFile().write(this.fourbytes, 0, 4);
                        this.blkSizeCurrent = 4;
                    }
                    this.fourbytes[3] = 0;
                    this.fourbytes[2] = 0;
                    this.fourbytes[1] = (byte)(size + 4 & 0xFF);
                    this.fourbytes[0] = (byte)(size + 4 >> 8 & 0xFF);
                    returnCode = this.getFile().write(this.fourbytes, 0, 4);
                    this.blkSizeCurrent += 4 + size;
                    this.blkSizePartial = this.blkSizeCurrent != this.blkSize;
                    break;
                }
                case SYNCSORT: {
                    this.fourbytes[1] = (byte)(size & 0xFF);
                    this.fourbytes[0] = (byte)(size >> 8 & 0xFF);
                    returnCode = this.getFile().write(this.fourbytes, 0, 2);
                    break;
                }
                default: {
                    this.fourbytes[0] = (byte)(size & 0xFF);
                    this.fourbytes[1] = (byte)(size >> 8 & 0xFF);
                    this.fourbytes[2] = (byte)(size >> 16 & 0xFF);
                    this.fourbytes[3] = (byte)(size >> 24 & 0xFF);
                    returnCode = this.getFile().write(this.fourbytes, 0, 4);
                }
            }
            if (returnCode == -9) {
                endOfPage = true;
                returnCode = 0;
            }
        }
        if (this.isFormatFBA || this.isFormatVBA) {
            --size;
            if (RuntimeEnvironment.getGlobalParameter(NOADV_param) != null && !this.checkDataForNewlineOnly(data)) {
                data[0] = this.controlByte[0];
            } else {
                returnCode = this.getFile().write(this.controlByte, 0, 1);
                if (returnCode == -9) {
                    endOfPage = true;
                    returnCode = 0;
                }
            }
            this.controlByte[0] = this.getCbSpace();
        }
        if (writingAlignment == 0) {
            if (this.codeSet == null) {
                returnCode = this.getFile().write(data, offset, size);
            } else {
                byte[] csdata = this.writeCodeset(data, offset, size);
                returnCode = this.getFile().write(csdata, 0, size);
            }
        } else if (this.codeSet == null) {
            int tempSize = writingAlignment + size;
            if (tempSize > this.temporaryStorage.length) {
                this.temporaryStorage = new byte[tempSize];
            }
            System.arraycopy(data, offset, this.temporaryStorage, 0, size);
            returnCode = this.getFile().write(this.temporaryStorage, 0, tempSize);
        } else {
            byte[] csdata = this.writeCodeset(data, offset, size);
            byte[] temp = new byte[writingAlignment + size];
            System.arraycopy(csdata, 0, temp, 0, size);
            returnCode = this.getFile().write(temp, 0, writingAlignment + size);
        }
        this.usedAlignment = writingAlignment;
        if (returnCode == -9 || returnCode == -93) {
            endOfPage = true;
            returnCode = 0;
        }
        this.iostatus(returnCode);
        return endOfPage;
    }

    private boolean checkDataForNewlineOnly(byte[] data) {
        if (data.length == 0) {
            return false;
        }
        if (data.length == 2 && data[0] == 13 && data[1] == 10) {
            return true;
        }
        return data.length == 1 && data[0] == 10;
    }

    public boolean rewrite(Variable data, int mode, Numeric timeout) {
        return this.rewrite(data, mode, timeout, false);
    }

    public boolean rewrite(Variable data, int mode, Numeric timeout, boolean printSequential) {
        block19: {
            if (this.noOps) {
                this.iostatus(0);
                return true;
            }
            try {
                boolean locking;
                byte[] dataByteArray;
                data.flushToMemory();
                this.size = this.dependingOn != null ? this.dependingOn.toInt() : data.length();
                if (!this.rewritePrep()) {
                    return printSequential ? this.advance() : false;
                }
                int dataAddress = data.getAddress();
                if (data.odoNoSlide && data.isGroup() && data.itemSize < data.maxItemSize) {
                    dataByteArray = new byte[this.size];
                    data.getOdoBytes(dataByteArray, 0);
                } else {
                    dataByteArray = data.getMemory().getBytes(dataAddress, this.size);
                }
                dataAddress = 0;
                if (printSequential) {
                    dataByteArray = this.formatLineSequentialRewrite(dataByteArray, dataAddress, this.size);
                    dataAddress = 0;
                    this.size = dataByteArray.length;
                }
                boolean bl = locking = this.lockingAutomatic() && (mode & 0x400000) == 0 || this.lockingManual() && (mode & 0x1000000) != 0;
                if (!locking) {
                    return this.rewriteData(dataByteArray, dataAddress, this.size);
                }
                int retries = 0;
                long currentTime = 0L;
                long finalTime = 0L;
                if ((mode & 0x100000) != 0 && timeout != null) {
                    double seconds = timeout.toDouble();
                    currentTime = System.currentTimeMillis();
                    finalTime = currentTime + (long)(seconds * 1000.0);
                }
                long lockNumber = 0L;
                if (!locking) break block19;
                lockNumber = this.getFile().getFilePointer();
                boolean retry = false;
                do {
                    if (this.lockRecord.lock(lockNumber, this.size)) {
                        boolean status = this.rewriteData(dataByteArray, dataAddress, this.size);
                        if (this.isOK()) {
                            if (this.lockingMultiple() && (mode & 0x200000) == 0 || (mode & 0x1000000) != 0) {
                                return status;
                            }
                            if (this.lockingSingle()) {
                                return status;
                            }
                            this.lockRecord.unlock(lockNumber);
                            return status;
                        }
                        return status;
                    }
                    retry = false;
                    if ((mode & 0x2000000) != 0) {
                        if (timeout != null && ++retries >= timeout.toInt()) continue;
                        try {
                            Thread.sleep(500L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        retry = true;
                        continue;
                    }
                    if ((mode & 0x100000) == 0 || System.currentTimeMillis() >= finalTime) continue;
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (System.currentTimeMillis() >= finalTime) continue;
                    retry = true;
                } while (retry);
                this.iostatus(-99);
            }
            catch (Throwable javaException) {
                this.iostatus(-98);
                return false;
            }
        }
        return false;
    }

    public boolean rewrite(Variable data) {
        return this.rewrite(data, false);
    }

    public boolean rewrite(Variable data, boolean printSequential) {
        if (this.noOps) {
            this.iostatus(0);
            return true;
        }
        try {
            byte[] dataByteArray;
            data.flushToMemory();
            this.size = this.dependingOn != null ? this.dependingOn.toInt() : data.length();
            int dataAddress = data.getAddress();
            if (data.odoNoSlide && data.isGroup() && data.itemSize < data.maxItemSize) {
                dataByteArray = new byte[this.size];
                data.getOdoBytes(dataByteArray, 0);
            } else {
                dataByteArray = data.getMemory().getBytes(dataAddress, this.size);
            }
            dataAddress = 0;
            if (this.rewritePrep()) {
                if (printSequential) {
                    dataByteArray = this.formatLineSequentialRewrite(dataByteArray, dataAddress, this.size);
                    dataAddress = 0;
                    this.size = dataByteArray.length;
                }
                return this.rewriteData(dataByteArray, dataAddress, this.size);
            }
        }
        catch (Throwable javaException) {
            this.iostatus(-98);
            return false;
        }
        return false;
    }

    private boolean rewritePrep() {
        if (this.readSize == -1) {
            this.iostatus(-43);
            return false;
        }
        if (this.size < this.minimum || this.size > this.maximum || this.size != this.readSize) {
            this.readSize = -1;
            this.iostatus(-44);
            return false;
        }
        this.rewriteSize = this.readSize;
        this.readSize = -1;
        int returnCode = this.getFile().backup();
        if (returnCode == -90 || returnCode == -48) {
            this.iostatus(-49);
            return false;
        }
        return true;
    }

    private boolean rewriteData(byte[] memory, int address, int size) {
        int returnCode;
        if (this.usedAlignment == 0) {
            if (this.codeSet == null) {
                returnCode = this.getFile().write(memory, address, size);
            } else {
                byte[] csdata = this.writeCodeset(memory, address, size);
                returnCode = this.getFile().write(csdata, 0, size);
            }
        } else if (this.codeSet == null) {
            int tempSize = this.usedAlignment + size;
            if (tempSize > this.temporaryStorage.length) {
                this.temporaryStorage = new byte[tempSize];
            }
            System.arraycopy(memory, address, this.temporaryStorage, 0, size);
            returnCode = this.getFile().write(this.temporaryStorage, 0, tempSize);
        } else {
            byte[] csdata = this.writeCodeset(memory, address, size);
            byte[] temp = new byte[this.usedAlignment + size];
            System.arraycopy(csdata, 0, temp, 0, size);
            returnCode = this.getFile().write(temp, 0, this.usedAlignment + size);
        }
        if (returnCode == -48) {
            returnCode = -44;
        }
        this.iostatus(returnCode);
        return returnCode == -9;
    }

    @Override
    public boolean advance() {
        try {
            int returnCode = this.getFile().advance(1);
            if (returnCode == -9) {
                this.iostatus(0);
                return true;
            }
            this.iostatus(returnCode);
        }
        catch (Throwable javaException) {
            this.iostatus(-98);
            return false;
        }
        return false;
    }

    @Override
    public boolean advancePage() {
        if (this.isFormatFBA || this.isFormatVBA) {
            this.controlByte[0] = this.getCbCharOne();
            return true;
        }
        try {
            if (!this.getFile().isTrackStats()) {
                this.advance();
                return true;
            }
            while (this.getFile().getLinage() != 1) {
                this.advance();
            }
        }
        catch (Throwable javaException) {
            this.iostatus(-98);
            return false;
        }
        return true;
    }

    @Override
    public boolean advance(String mnemonic) {
        if (this.isFormatFBA || this.isFormatVBA) {
            switch (mnemonic.toLowerCase()) {
                case "c01": {
                    this.controlByte[0] = this.getCbCharOne();
                    break;
                }
                case "c02": {
                    this.controlByte[0] = this.getCbCharTwo();
                    break;
                }
                case "c03": {
                    this.controlByte[0] = this.getCbCharThree();
                    break;
                }
                case "c04": {
                    this.controlByte[0] = this.getCbCharFour();
                    break;
                }
                case "c05": {
                    this.controlByte[0] = this.getCbCharFive();
                    break;
                }
                case "c06": {
                    this.controlByte[0] = this.getCbCharSix();
                    break;
                }
                case "c07": {
                    this.controlByte[0] = this.getCbCharSeven();
                    break;
                }
                case "c08": {
                    this.controlByte[0] = this.getCbCharEight();
                    break;
                }
                case "c09": {
                    this.controlByte[0] = this.getCbCharNine();
                    break;
                }
                case "c10": {
                    this.controlByte[0] = this.getCbCharA();
                    break;
                }
                case "c11": {
                    this.controlByte[0] = this.getCbCharB();
                    break;
                }
                case "c12": {
                    this.controlByte[0] = this.getCbCharC();
                }
            }
            return true;
        }
        if (mnemonic != null) {
            if (mnemonic.equalsIgnoreCase("PAGE")) {
                return this.advancePage();
            }
            if (mnemonic.equalsIgnoreCase("LINE")) {
                return this.advance();
            }
            if (mnemonic.equalsIgnoreCase("TAB")) {
                return this.advanceTab();
            }
            if (mnemonic.equalsIgnoreCase("FORMFEED")) {
                return this.advanceFormFeed();
            }
            switch (mnemonic.toLowerCase()) {
                case "c01": {
                    return this.advance(1);
                }
                case "c02": {
                    return this.advance(2);
                }
                case "c03": {
                    return this.advance(3);
                }
                case "c04": {
                    return this.advance(4);
                }
            }
        }
        return false;
    }

    @Override
    public boolean advanceTab() {
        return false;
    }

    @Override
    public boolean advanceFormFeed() {
        return false;
    }

    @Override
    public boolean advance(int n) {
        if (this.isFormatFBA || this.isFormatVBA) {
            switch (n) {
                case 0: {
                    this.controlByte[0] = this.getCbPlus();
                    break;
                }
                case 1: {
                    this.controlByte[0] = this.getCbSpace();
                    break;
                }
                case 2: {
                    this.controlByte[0] = this.getCbCharZero();
                    break;
                }
                case 3: {
                    this.controlByte[0] = this.getCbMinus();
                    break;
                }
                case 4: {
                    this.controlByte[0] = this.getCbMinus();
                    this.writeData(new byte[this.size], 0, this.size);
                    this.controlByte[0] = this.getCbSpace();
                    break;
                }
                case 5: {
                    this.controlByte[0] = this.getCbMinus();
                    this.writeData(new byte[this.size], 0, this.size);
                    this.controlByte[0] = this.getCbCharZero();
                    break;
                }
                case 6: {
                    this.controlByte[0] = this.getCbMinus();
                    this.writeData(new byte[this.size], 0, this.size);
                    this.controlByte[0] = this.getCbMinus();
                    break;
                }
                case 7: {
                    this.controlByte[0] = this.getCbMinus();
                    this.writeData(new byte[this.size], 0, this.size);
                    this.writeData(new byte[this.size], 0, this.size);
                    this.controlByte[0] = this.getCbSpace();
                    break;
                }
                case 8: {
                    this.controlByte[0] = this.getCbMinus();
                    this.writeData(new byte[this.size], 0, this.size);
                    this.writeData(new byte[this.size], 0, this.size);
                    this.controlByte[0] = this.getCbCharZero();
                    break;
                }
                case 9: {
                    this.controlByte[0] = this.getCbMinus();
                    this.writeData(new byte[this.size], 0, this.size);
                    this.writeData(new byte[this.size], 0, this.size);
                    this.controlByte[0] = this.getCbMinus();
                    break;
                }
                case 10: {
                    this.controlByte[0] = this.getCbMinus();
                    this.writeData(new byte[this.size], 0, this.size);
                    this.writeData(new byte[this.size], 0, this.size);
                    this.writeData(new byte[this.size], 0, this.size);
                    this.controlByte[0] = this.getCbSpace();
                    break;
                }
                default: {
                    this.controlByte[0] = this.getCbSpace();
                }
            }
            this.iostatus(0);
            return true;
        }
        try {
            boolean returnStatus = false;
            int returnCode = this.getFile().advance(n);
            if (returnCode == -9) {
                returnStatus = true;
                returnCode = 0;
            }
            this.iostatus(returnCode);
            return returnStatus;
        }
        catch (Throwable javaException) {
            this.iostatus(-98);
            return false;
        }
    }

    @Override
    public void init() {
        try {
            this.readSize = -1;
            if (this.getFile() != null && this.getFile().isOpen()) {
                this.close();
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    int seek(long l) {
        int returnCode = this.getFile().seek(l);
        this.iostatus(returnCode);
        return returnCode;
    }

    long getFilePointer() {
        return this.getFile().getFilePointer();
    }

    @Override
    public Object getObject() {
        return this.getFile() != null ? this.getFile().getObject() : null;
    }

    public boolean deleteFile() {
        File ref;
        boolean deleted = false;
        String filename = this.currentFilename();
        if (filename != null && (ref = new File(filename)).exists()) {
            deleted = ref.delete();
        }
        if (deleted) {
            this.iostatus(0);
        } else {
            this.iostatus(-5);
        }
        return deleted;
    }

    public String toString() {
        try {
            String linesep = System.getProperty("line.separator");
            if (linesep == null) {
                linesep = "\n";
            }
            StringBuffer result = new StringBuffer();
            if (this.lineSequential || this.permanentLineSequential) {
                result.append("ORGANIZATION IS LINE SEQUENTIAL").append(linesep);
            } else {
                result.append("ORGANIZATION IS SEQUENTIAL").append(linesep);
            }
            result.append("ACCESS MODE IS SEQUENTIAL").append(linesep);
            if (this.optional) {
                result.append("OPTIONAL").append(linesep);
            }
            if (this.filenameVariable != null) {
                result.append("ASSIGN TO ").append(this.filenameVariable.getName()).append("=\"").append(this.filenameVariable.toString().trim()).append("\"").append(linesep);
            } else if (this.getFile() != null) {
                result.append("ASSIGN TO \"").append(this.getFile().getFilename()).append("\"").append(linesep);
            }
            if (this.getFile().isOpen()) {
                result.append("CURRENTLY OPEN").append(linesep);
            } else {
                result.append("CURRENTLY CLOSED").append(linesep);
            }
            if (this.externalFile != null) {
                result.append("EXTERNAL").append(linesep);
            }
            if (this.fileStatus != null) {
                result.append("FILE STATUS IS ").append(this.fileStatus.getName()).append("=").append(this.fileStatus.toDisplayString()).append(linesep);
            } else if (this.priorErrorCode < 0) {
                result.append("IMPLICIT FILE STATUS IS ").append(-this.priorErrorCode).append(linesep);
            } else {
                result.append("IMPLICIT FILE STATUS IS ").append(this.priorErrorCode).append(linesep);
            }
            if (this.fixed()) {
                result.append("RECORDING MODE IS FIXED").append(linesep);
            } else {
                result.append("RECORDING MODE IS VARIABLE").append(linesep);
            }
            if (this.dependingOn != null) {
                result.append("DEPENDING ON ").append(this.dependingOn.getName()).append('=').append(this.dependingOn.toInt()).append(linesep);
            }
            if (this.linageId != null) {
                result.append("LINAGE IS ").append(this.linageId.getName()).append('=').append(this.linageId.toInt()).append(" LINES").append(linesep);
            } else if (this.linage > 0) {
                result.append("LINAGE IS ").append(this.linage).append(" LINES").append(linesep);
            }
            if (this.footingId != null) {
                result.append("WITH FOOTING AT ").append(this.footingId.getName()).append('=').append(this.footingId.toInt()).append(linesep);
            } else if (this.footing > 0) {
                result.append("WITH FOOTING AT ").append(this.footing).append(linesep);
            }
            if (this.topId != null) {
                result.append("LINES AT TOP ").append(this.topId.getName()).append('=').append(this.topId.toInt()).append(linesep);
            } else if (this.top > 0) {
                result.append("LINES AT TOP ").append(this.top).append(linesep);
            }
            if (this.bottomId != null) {
                result.append("LINES AT BOTTOM ").append(this.bottomId.getName()).append('=').append(this.bottomId.toInt()).append(linesep);
            } else if (this.bottom > 0) {
                result.append("LINES AT BOTTOM ").append(this.bottom).append(linesep);
            }
            if (this.blockFrom != 0 || this.blockTo != 0) {
                if (this.blockFrom == this.blockTo) {
                    result.append("BLOCK CONTAINS ").append(this.blockFrom).append(" CHARACTERS").append(linesep);
                } else {
                    result.append("BLOCK CONTAINS ").append(this.blockFrom).append(" TO ").append(this.blockTo).append(" CHARACTERS").append(linesep);
                }
            }
            switch (this.protocol) {
                case MICROFOCUS: {
                    result.append("MICRO FOCUS PROTOCOL").append(linesep);
                    break;
                }
                case ACUCOBOL: {
                    result.append("ACUCOBOL PROTOCOL").append(linesep);
                }
                case IBMV: {
                    result.append("IBMV PROTOCOL").append(linesep);
                }
                case IBMVB: {
                    result.append("IBMVB PROTOCOL").append(linesep);
                }
                case SYNCSORT: {
                    result.append("SYNCSORT PROTOCOL").append(linesep);
                }
                default: {
                    result.append("ECOBOL PROTOCOL").append(linesep);
                }
            }
            if (this.minimum != -1 || this.maximum != -1) {
                if (this.minimum == this.maximum) {
                    result.append("RECORD CONTAINS ").append(this.minimum).append(" CHARACTERS").append(linesep);
                } else {
                    result.append("RECORD CONTAINS ").append(this.minimum).append(" TO ").append(this.maximum).append(" CHARACTERS").append(linesep);
                }
            }
            return result.toString();
        }
        catch (RuntimeException t) {
            return "SEQUENTIAL FILE (LOOKUP EXCEPTION OCCURRED)";
        }
    }

    @Override
    public final Numeric getLinageCounter() {
        return new Numeric(this.getFile().getLinage());
    }

    public String readCodeset(String convert) {
        int length = convert.length();
        StringBuffer result = new StringBuffer(length);
        for (int i = 0; i < length; ++i) {
            char c = convert.charAt(i);
            try {
                c = this.codeSet.charAt(c);
            }
            catch (Exception e) {
                c = '\u0000';
            }
            result.append(c);
        }
        return result.toString();
    }

    public byte[] readCodeset(byte[] convert) {
        int length = convert.length;
        byte[] result = new byte[length];
        for (int i = 0; i < length; ++i) {
            char c = (char)convert[i];
            try {
                c = this.codeSet.charAt(c);
            }
            catch (Exception e) {
                c = '\u0000';
            }
            result[i] = (byte)c;
        }
        return result;
    }

    public byte[] readCodeset(byte[] convert, int start, int length) {
        if (length > convert.length - start) {
            length = convert.length - start;
        }
        byte[] result = new byte[length];
        for (int i = 0; i < length; ++i) {
            char c = (char)convert[start + i];
            try {
                c = this.codeSet.charAt(c);
            }
            catch (Exception e) {
                c = '\u0000';
            }
            result[i] = (byte)c;
        }
        return result;
    }

    public void readCodesetInPlace(Memory convert, int start, int length) {
        if (length > convert.getTopOfMemory() - start) {
            length = convert.getTopOfMemory() - start;
        }
        for (int i = 0; i < length; ++i) {
            char c = (char)convert.getByte(start + i);
            try {
                c = this.codeSet.charAt(c);
            }
            catch (Exception e) {
                c = '\u0000';
            }
            convert.setByte(start + i, (byte)c);
        }
    }

    public String writeCodeset(String convert) {
        int length = convert.length();
        StringBuffer result = new StringBuffer(length);
        for (int i = 0; i < length; ++i) {
            char c = convert.charAt(i);
            c = (char)this.codeSet.indexOf(c);
            result.append(i >= 0 ? c : (char)'\u0000');
        }
        return result.toString();
    }

    public byte[] writeCodeset(byte[] convert) {
        int length = convert.length;
        byte[] result = new byte[length];
        for (int i = 0; i < length; ++i) {
            char c = (char)convert[i];
            result[i] = (c = (char)this.codeSet.indexOf(c)) >= '\u0000' ? (byte)c : (byte)0;
        }
        return result;
    }

    public byte[] writeCodeset(byte[] convert, int start, int length) {
        if (length > convert.length - start) {
            length = convert.length - start;
        }
        byte[] result = new byte[length];
        for (int i = 0; i < length; ++i) {
            char c = (char)convert[start + i];
            result[i] = (c = (char)this.codeSet.indexOf(c)) >= '\u0000' ? (byte)c : (byte)0;
        }
        return result;
    }

    public void finalize() {
        this.init();
    }

    protected final boolean writeHeader() {
        if (this.protocol == Protocol.MICROFOCUS) {
            if (this.fixed()) {
                return true;
            }
            this.getFile().seek(0);
            byte[] data = this.MF_header();
            int mylock = this.getFile().writeLock(0L, data.length);
            this.getFile().writeNoControl(data, 0, data.length);
            this.getFile().writeUnlock(mylock);
            return true;
        }
        return true;
    }

    protected final int readHeader() {
        if (this.protocol == Protocol.MICROFOCUS) {
            if (this.fixed()) {
                return 0;
            }
            this.getFile().seek(0);
            int mylock = this.getFile().readLock(0L, 128);
            byte[] header = new byte[128];
            this.getFile().read(header, 0, 128);
            boolean result = this.MF_header(header);
            this.getFile().readUnlock(mylock);
            return result ? 0 : -39;
        }
        return 0;
    }

    final int MF_prefixSize() {
        return this.maximum >= 4096 ? 4 : 2;
    }

    protected final byte[] MF_header() {
        int i;
        byte zero;
        byte[] result = new byte[128];
        if (this.maximum < 4096) {
            result[0] = 48;
            result[1] = 126;
            result[2] = 0;
            result[3] = 0;
        } else {
            result[0] = 48;
            result[1] = 0;
            result[2] = 0;
            result[3] = 124;
        }
        result[4] = result[5] = (zero = 0);
        result[6] = result[7] = zero;
        Calendar cal = Calendar.getInstance();
        int cen = cal.get(1);
        int year = cen - 2000;
        int month = cal.get(2) + 1;
        int date = cal.get(5);
        int hour = cal.get(10);
        int min = cal.get(12);
        int sec = cal.get(13);
        result[8] = result[22] = (byte)(year / 10 + 48);
        result[9] = result[23] = (byte)(year % 10 + 48);
        result[10] = result[24] = (byte)(month / 10 + 48);
        result[11] = result[25] = (byte)(month % 10 + 48);
        result[12] = result[26] = (byte)(date / 10 + 48);
        result[13] = result[27] = (byte)(date % 10 + 48);
        result[14] = result[28] = (byte)(hour / 10 + 48);
        result[15] = result[29] = (byte)(hour % 10 + 48);
        result[16] = result[30] = (byte)(min / 10 + 48);
        result[17] = result[31] = (byte)(min % 10 + 48);
        result[18] = result[32] = (byte)(sec / 10 + 48);
        result[19] = result[33] = (byte)(sec % 10 + 48);
        result[20] = result[34] = (byte)(cen / 10 + 48);
        result[21] = result[35] = (byte)(cen % 10 + 48);
        result[36] = 0;
        result[37] = 62;
        result[38] = zero;
        result[39] = 1;
        if (this.lowLevel) {
            result[39] = 2;
        }
        result[40] = zero;
        result[41] = (byte)MFFile.CurrentCompression(-1);
        this.dataCompression = result[41];
        result[42] = zero;
        result[43] = 0;
        for (i = 44; i < 48; ++i) {
            result[i] = zero;
        }
        result[48] = (byte)(this.variable() ? 1 : 0);
        for (i = 49; i < 56; ++i) {
            result[i] = zero;
        }
        result[56] = (byte)(this.maximum / 256);
        result[57] = (byte)(this.maximum & 0xFF);
        result[58] = zero;
        result[59] = zero;
        result[60] = (byte)(this.minimum / 256);
        result[61] = (byte)(this.minimum & 0xFF);
        for (i = 62; i < 108; ++i) {
            result[i] = zero;
        }
        if (this.lowLevel) {
            result[76] = 4;
        }
        result[108] = 67;
        result[109] = 0;
        result[110] = 31;
        result[111] = -9;
        for (i = 112; i < 128; ++i) {
            result[i] = zero;
        }
        return result;
    }

    protected boolean MF_header(byte[] parse) {
        if (parse[41] != 0 && MFFile.GetCompression(parse[41]) == null) {
            return false;
        }
        if (parse[43] != 3 && parse[43] != 0) {
            return false;
        }
        this.maximum = (parse[56] & 0xFF) * 256 | parse[57] & 0xFF;
        this.minimum = (parse[60] & 0xFF) * 256 | parse[61] & 0xFF;
        boolean flag = this.minimum <= this.maximum;
        return flag;
    }

    @Override
    public void unlock() {
        try {
            this.lockRecord.unlockAll();
            this.iostatus(0);
        }
        catch (Throwable javaException) {
            this.iostatus(-98);
        }
    }

    public void exclusive() {
        try {
            while (!this.lockRecord.exclusive()) {
                this.iostatus(-93);
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {}
            }
            this.iostatus(0);
        }
        catch (Throwable javaException) {
            this.iostatus(-98);
        }
    }

    public void exclusiveConditionally() {
        try {
            if (!this.lockRecord.exclusive()) {
                this.iostatus(-93);
            } else {
                this.iostatus(0);
            }
        }
        catch (Throwable javaException) {
            this.iostatus(-98);
        }
    }

    public void unexclusive() {
        try {
            this.lockRecord.unexclusive();
            this.iostatus(0);
        }
        catch (Throwable javaException) {
            this.iostatus(-98);
        }
    }

    public void flushCache() {
    }

    public seqFile setPassword(Variable identifier) {
        return this;
    }

    public int getReadSize() {
        return this.readSize;
    }

    public seqFile clone() {
        throw new RuntimeException("Multi browser sessions not supported by this file type.");
    }

    public byte getCbSpace() {
        if (this.cbSpace == 0) {
            this.setCbSpace();
        }
        return this.cbSpace;
    }

    public void setCbSpace() {
        this.cbSpace = (byte)("3".equals(RuntimeEnvironment.getGlobalParameter("DT")) ? 64 : 32);
    }

    public byte getCbMinus() {
        if (this.cbMinus == 0) {
            this.setCbMinus();
        }
        return this.cbMinus;
    }

    public void setCbMinus() {
        this.cbMinus = (byte)("3".equals(RuntimeEnvironment.getGlobalParameter("DT")) ? 96 : 45);
    }

    public byte getCbPlus() {
        if (this.cbPlus == 0) {
            this.setCbPlus();
        }
        return this.cbPlus;
    }

    public void setCbPlus() {
        this.cbPlus = (byte)("3".equals(RuntimeEnvironment.getGlobalParameter("DT")) ? 78 : 43);
    }

    public byte getCbCharZero() {
        if (this.cbCharZero == 0) {
            this.setCbCharZero();
        }
        return this.cbCharZero;
    }

    public void setCbCharZero() {
        this.cbCharZero = (byte)("3".equals(RuntimeEnvironment.getGlobalParameter("DT")) ? -16 : 48);
    }

    public byte getCbCharOne() {
        if (this.cbCharOne == 0) {
            this.setCbCharOne();
        }
        return this.cbCharOne;
    }

    public void setCbCharOne() {
        this.cbCharOne = (byte)("3".equals(RuntimeEnvironment.getGlobalParameter("DT")) ? -15 : 49);
    }

    public byte getCbCharTwo() {
        if (this.cbCharTwo == 0) {
            this.setCbCharTwo();
        }
        return this.cbCharTwo;
    }

    public void setCbCharTwo() {
        this.cbCharTwo = (byte)("3".equals(RuntimeEnvironment.getGlobalParameter("DT")) ? -14 : 50);
    }

    public byte getCbCharThree() {
        if (this.cbCharThree == 0) {
            this.setCbCharThree();
        }
        return this.cbCharThree;
    }

    public void setCbCharThree() {
        this.cbCharThree = (byte)("3".equals(RuntimeEnvironment.getGlobalParameter("DT")) ? -13 : 51);
    }

    public byte getCbCharFour() {
        if (this.cbCharFour == 0) {
            this.setCbCharFour();
        }
        return this.cbCharFour;
    }

    public void setCbCharFour() {
        this.cbCharFour = (byte)("3".equals(RuntimeEnvironment.getGlobalParameter("DT")) ? -12 : 52);
    }

    public byte getCbCharFive() {
        if (this.cbCharFive == 0) {
            this.setCbCharFive();
        }
        return this.cbCharFive;
    }

    public void setCbCharFive() {
        this.cbCharFive = (byte)("3".equals(RuntimeEnvironment.getGlobalParameter("DT")) ? -11 : 53);
    }

    public byte getCbCharSix() {
        if (this.cbCharSix == 0) {
            this.setCbCharSix();
        }
        return this.cbCharSix;
    }

    public void setCbCharSix() {
        this.cbCharSix = (byte)("3".equals(RuntimeEnvironment.getGlobalParameter("DT")) ? -10 : 54);
    }

    public byte getCbCharSeven() {
        if (this.cbCharSeven == 0) {
            this.setCbCharSeven();
        }
        return this.cbCharSeven;
    }

    public void setCbCharSeven() {
        this.cbCharSeven = (byte)("3".equals(RuntimeEnvironment.getGlobalParameter("DT")) ? -9 : 55);
    }

    public byte getCbCharEight() {
        if (this.cbCharEight == 0) {
            this.setCbCharEight();
        }
        return this.cbCharEight;
    }

    public void setCbCharEight() {
        this.cbCharEight = (byte)("3".equals(RuntimeEnvironment.getGlobalParameter("DT")) ? -8 : 56);
    }

    public byte getCbCharNine() {
        if (this.cbCharNine == 0) {
            this.setCbCharNine();
        }
        return this.cbCharNine;
    }

    public void setCbCharNine() {
        this.cbCharNine = (byte)("3".equals(RuntimeEnvironment.getGlobalParameter("DT")) ? -7 : 57);
    }

    public byte getCbCharA() {
        if (this.cbCharA == 0) {
            this.setCbCharA();
        }
        return this.cbCharA;
    }

    public void setCbCharA() {
        this.cbCharA = (byte)("3".equals(RuntimeEnvironment.getGlobalParameter("DT")) ? -63 : 65);
    }

    public byte getCbCharB() {
        if (this.cbCharB == 0) {
            this.setCbCharB();
        }
        return this.cbCharB;
    }

    public void setCbCharB() {
        this.cbCharB = (byte)("3".equals(RuntimeEnvironment.getGlobalParameter("DT")) ? -62 : 66);
    }

    public byte getCbCharC() {
        if (this.cbCharC == 0) {
            this.setCbCharC();
        }
        return this.cbCharC;
    }

    public void setCbCharC() {
        this.cbCharC = (byte)("3".equals(RuntimeEnvironment.getGlobalParameter("DT")) ? -61 : 67);
    }

    protected static enum Protocol {
        ECOBOL,
        ACUCOBOL,
        RAWMODE,
        IBMV,
        IBMVB,
        SYNCSORT,
        MICROFOCUS;

    }
}

