/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec.smartheap;

import com.heirloomcomputing.ecs.exec.Memory;
import com.heirloomcomputing.ecs.exec.smartheap.SmartHeap;
import com.heirloomcomputing.ecs.exec.smartheap.SmartHeapElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class SmartHeapVector
implements SmartHeap {
    public static final int MASK_INDIRECT = Integer.MAX_VALUE;
    private List<Memory> directPointers = new ArrayList<Memory>(100);
    private int nextDirectPointer;
    private Vector<SmartHeapElement> indirectPointers;
    private Map<Memory, Map<Integer, Integer>> indirectPointersMemory;
    private int nextIndirectPointer;

    public SmartHeapVector() {
        this.directPointers.add(0, null);
        this.directPointers.add(1, null);
        this.nextDirectPointer = 2;
        this.indirectPointers = new Vector(100, 100);
        this.indirectPointers.add(null);
        this.nextIndirectPointer = 1;
        this.indirectPointersMemory = new HashMap<Memory, Map<Integer, Integer>>(100);
        HashMap<Object, Integer> addrVal = new HashMap<Object, Integer>(100);
        addrVal.put(null, 0);
        this.indirectPointersMemory.put(null, addrVal);
    }

    @Override
    public int index(Memory mem) {
        int index = this.directPointers.indexOf(mem);
        if (index < 0) {
            this.directPointers.add(this.nextDirectPointer, mem);
            index = this.nextDirectPointer++;
        }
        return index;
    }

    @Override
    public int index(Memory mem, int addr) {
        Integer index;
        Map<Integer, Integer> addrIndex = this.indirectPointersMemory.get(mem);
        if (addrIndex == null) {
            SmartHeapElement findOrInsert = new SmartHeapElement(mem, addr);
            this.indirectPointers.insertElementAt(findOrInsert, this.nextIndirectPointer);
            HashMap<Integer, Integer> addrVal = new HashMap<Integer, Integer>(100);
            addrVal.put(addr, this.nextIndirectPointer);
            this.indirectPointersMemory.put(mem, addrVal);
            index = this.nextIndirectPointer++;
        } else {
            index = addrIndex.get(addr);
            if (index == null) {
                SmartHeapElement findOrInsert = new SmartHeapElement(mem, addr);
                this.indirectPointers.insertElementAt(findOrInsert, this.nextIndirectPointer);
                addrIndex.put(addr, this.nextIndirectPointer);
                index = this.nextIndirectPointer++;
            }
        }
        return index;
    }

    @Override
    public Memory memoryD(int index) {
        if (index <= 0 || index > this.directPointers.size()) {
            return null;
        }
        Memory find = this.directPointers.get(index);
        if (find == null) {
            return null;
        }
        return find;
    }

    @Override
    public Memory memoryI(int index) {
        if (index <= 0 || index > this.indirectPointers.size()) {
            return null;
        }
        SmartHeapElement find = this.indirectPointers.elementAt(index);
        if (find == null) {
            return null;
        }
        return find.getMemory();
    }

    @Override
    public int addressI(int index) {
        if (index <= 0 || index > this.indirectPointers.size()) {
            return -1;
        }
        SmartHeapElement find = this.indirectPointers.elementAt(index);
        if (find == null) {
            return -1;
        }
        return find.getAddress();
    }

    @Override
    public void free(int pointer) {
        if ((pointer & Integer.MIN_VALUE) == 0) {
            int index = pointer >> 16;
            if (index > 0 && index < this.directPointers.size()) {
                this.directPointers.set(index, null);
            }
        } else {
            int index = pointer & Integer.MAX_VALUE;
            if (index > 0 && index < this.indirectPointers.size()) {
                SmartHeapElement find = this.indirectPointers.elementAt(index);
                this.indirectPointers.setElementAt(null, index);
                if (find != null && find.getMemory() != null) {
                    Map<Integer, Integer> addrIndex = this.indirectPointersMemory.get(find.getMemory());
                    addrIndex.remove(find.getAddress());
                    if (addrIndex.size() == 0) {
                        this.indirectPointersMemory.remove(find.getMemory());
                    }
                }
            }
        }
    }
}

