/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.isamsql;

import com.heirloomcomputing.ecs.isamsql.DCB;
import com.heirloomcomputing.ecs.isamsql.DCBDB;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class DCBFactory {
    private static Boolean modeDcbDB = null;
    private static DBMS dbms = DBMS.UNKNOWN;
    public static final String dcbCreateTableHeader = "CREATE TABLE \"DCBDB";
    private static String dcbTableNameExt = "";
    public static final String dcbCreateCols = "( DSNAME VARCHAR(150 ) NOT NULL PRIMARY KEY, LRECL VARCHAR(6 ), DSORG VARCHAR(5 ), ORIENTATION VARCHAR(50 ), PROTOTYPE VARCHAR(6 ), RECFM VARCHAR(5 ), RECMIN VARCHAR(6 ), RECAVG VARCHAR(6 ), CHARSET VARCHAR(50 ), BLKSIZE VARCHAR(7 ), GDG_LIMIT VARCHAR(7 ), KEYLEN VARCHAR(7 ), KEYOFF VARCHAR(7 ), ALTKEYOFFS VARCHAR(7 ), ALTKEYLENS VARCHAR(7 ), ALTKEYDUPS VARCHAR(7 ), ALTKEYGROUPS VARCHAR(20 ), LABEL VARCHAR(20 ), EXPDT VARCHAR(26 ), REUSE VARCHAR(20 ), RELATE VARCHAR(150 ), ASSOCIATES VARCHAR(150 ), PATH VARCHAR(150 ), UPDATE_USER VARCHAR(50 ), UPDATE_TS DATETIME )";
    public static final String dcbCreatePGCols = "( DSNAME VARCHAR(150 ) NOT NULL PRIMARY KEY, LRECL VARCHAR(6 ), DSORG VARCHAR(5 ), ORIENTATION VARCHAR(50 ), PROTOTYPE VARCHAR(6 ), RECFM VARCHAR(5 ), RECMIN VARCHAR(6 ), RECAVG VARCHAR(6 ), CHARSET VARCHAR(50 ), BLKSIZE VARCHAR(7 ), GDG_LIMIT VARCHAR(7 ), KEYLEN VARCHAR(7 ), KEYOFF VARCHAR(7 ), ALTKEYOFFS VARCHAR(7 ), ALTKEYLENS VARCHAR(7 ), ALTKEYDUPS VARCHAR(7 ), ALTKEYGROUPS VARCHAR(20 ), LABEL VARCHAR(20 ), EXPDT VARCHAR(26 ), REUSE VARCHAR(20 ), RELATE VARCHAR(150 ), ASSOCIATES VARCHAR(150 ), PATH VARCHAR(150 ), UPDATE_USER VARCHAR(50 ), UPDATE_TS TIMESTAMP )";

    public static DBMS getDbms() {
        return dbms;
    }

    public static DCB getInstance() {
        if (DCBFactory.isModeDcbDB().booleanValue()) {
            return new DCBDB();
        }
        return new DCB();
    }

    public static DCB getInstance(DCB cpy) {
        if (DCBFactory.isModeDcbDB().booleanValue()) {
            return new DCBDB(cpy);
        }
        return new DCB(cpy);
    }

    public static DCB getInstance(String dsn, String dsnPath) {
        if (DCBFactory.isModeDcbDB().booleanValue()) {
            return new DCBDB(dsn, dsnPath);
        }
        return new DCB(dsn, dsnPath);
    }

    public static DCB getInstance(String dsn, String dsnPath, boolean forUpdate) {
        if (DCBFactory.isModeDcbDB().booleanValue()) {
            return new DCBDB(dsn, dsnPath, forUpdate);
        }
        return new DCB(dsn, dsnPath, forUpdate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean isModeDcbDB() {
        Class<DCBFactory> clazz = DCBFactory.class;
        synchronized (DCBFactory.class) {
            if (modeDcbDB == null) {
                if ("true".equalsIgnoreCase(System.getProperty("dcb.mode.db")) || "yes".equalsIgnoreCase(System.getProperty("dcb.mode.db"))) {
                    DCBFactory.setModeDcbDB(Boolean.TRUE);
                } else {
                    DCBFactory.setModeDcbDB(Boolean.FALSE);
                }
            }
            if (modeDcbDB.booleanValue()) {
                DCBFactory.setupDCBDB();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return modeDcbDB;
        }
    }

    public static void setModeDcbDB(Boolean modeDcbDB) {
        DCBFactory.modeDcbDB = modeDcbDB;
    }

    public static String getDcbTableNameExt() {
        return dcbTableNameExt;
    }

    public static void setDcbTableNameExt(String dcbTableNameExt) {
        DCBFactory.dcbTableNameExt = dcbTableNameExt;
    }

    public static void setupDCBDB() {
        String url2 = System.getProperty("dcb.db.url");
        String user = System.getProperty("dcb.db.user");
        String pass = System.getProperty("dcb.db.pass");
        String driver = System.getProperty("dcb.db.driver");
        String tableExt = System.getProperty("dcb.db.table");
        if (System.getProperty("dcb.db.url").toLowerCase().contains("postgresql")) {
            dbms = DBMS.POSTGRESQL;
        }
        Connection connection = null;
        Statement stmt = null;
        try {
            if (driver != null) {
                Class.forName(driver);
            }
            if ((connection = DriverManager.getConnection(url2, user, pass)) != null) {
                if (tableExt != null) {
                    DCBFactory.setDcbTableNameExt(tableExt);
                }
                DatabaseMetaData dbmd = connection.getMetaData();
                ResultSet mdrs = dbmd.getTables(null, connection.getSchema(), "DCBDB" + dcbTableNameExt, new String[]{"TABLE"});
                if (!mdrs.next()) {
                    String sql = dcbCreateTableHeader + dcbTableNameExt + "\"" + dcbCreateCols;
                    if (dbms == DBMS.POSTGRESQL) {
                        sql = dcbCreateTableHeader + dcbTableNameExt + "\"" + dcbCreatePGCols;
                    }
                    stmt = connection.createStatement();
                    stmt.executeUpdate(sql);
                }
            } else {
                System.err.println("Connection Failed! Check output console");
                System.err.println("Conn Info : Url[" + url2 + "] User[" + user + "] pass[" + pass + "] driver[" + driver + "] Table Ext[" + tableExt);
            }
        }
        catch (SQLException e) {
            System.err.println("DCBFactory->setupDCBDB()" + e.getMessage());
            System.err.println("Conn Info : Url[" + url2 + "] User[" + user + "] pass[" + pass + "] driver[" + driver + "] Table Ext[" + tableExt);
        }
        catch (ClassNotFoundException e) {
            System.err.println("DCBFactory->setupDCBDB()" + e.getMessage());
            throw new IllegalArgumentException("The jdbc driver " + e.getMessage() + " could not be found");
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {}
        }
    }

    public static enum DBMS {
        UNKNOWN,
        POSTGRESQL,
        DB2,
        ORACLE,
        MYSQL,
        H2,
        DERBY,
        HIVE,
        SPLICE,
        SQLSERVER;

    }
}

