/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.isamsql;

import com.heirloomcomputing.ecs.exec.LogSetup;
import com.heirloomcomputing.ecs.exec.PropertiesUtil;
import com.heirloomcomputing.ecs.isamsql.SqlConnectionInfo;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.TreeMap;

public class SqlConnections {
    private HashMap<String, SqlConnectionInfo> connections = null;
    private static String connectionErrors;
    private static int numberOfConnectionErrors;

    public void storeConnectionInfo() {
        String key;
        String filename = "deploy.properties";
        SqlConnectionInfo conInfo = null;
        Properties props = null;
        try {
            props = PropertiesUtil.loadProperties(filename);
        }
        catch (IllegalArgumentException err) {
            filename = "deploy_settings";
            try {
                props = PropertiesUtil.loadProperties(filename);
            }
            catch (IllegalArgumentException e) {
                props = new Properties();
                try {
                    filename = "deploy.properties";
                    FileInputStream fis = new FileInputStream(filename);
                    props.load(fis);
                }
                catch (FileNotFoundException e1) {
                    filename = "deploy_settings";
                    try {
                        FileInputStream fis = new FileInputStream(filename);
                        props.load(fis);
                    }
                    catch (FileNotFoundException fis) {
                    }
                    catch (IOException fis) {}
                }
                catch (IOException e1) {
                    // empty catch block
                }
            }
        }
        if (!props.isEmpty() && LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.info("Loaded properties file:" + filename);
        }
        props = PropertiesUtil.swapProperties(props);
        Enumeration<Object> e = System.getProperties().keys();
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            if (!key.startsWith("sql.") || props.getProperty(key) != null) continue;
            props.setProperty(key, System.getProperty(key));
        }
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.fine(" displays properties file: ");
            props.list(System.out);
            LogSetup.LOGGER.fine(props.toString() + "\n");
        }
        this.connections = new HashMap();
        e = props.keys();
        while (e.hasMoreElements()) {
            String s;
            key = (String)e.nextElement();
            if (!key.startsWith("sql.")) continue;
            int idxOfDot2 = key.indexOf(46, 4);
            String conname = key.substring(4, idxOfDot2);
            conInfo = this.connections.get(conname);
            if (conInfo == null) {
                conInfo = new SqlConnectionInfo();
                conInfo.setName(conname);
                this.connections.put(conname, conInfo);
            }
            if ("user".equalsIgnoreCase(s = key.substring(idxOfDot2 + 1))) {
                conInfo.setUser(props.getProperty(key));
                continue;
            }
            if ("password".equalsIgnoreCase(s)) {
                conInfo.setPassword(props.getProperty(key));
                continue;
            }
            if ("dataSource".equalsIgnoreCase(s)) {
                conInfo.setDataSource(props.getProperty(key));
                continue;
            }
            if ("driver".equalsIgnoreCase(s)) {
                conInfo.setDriver(props.getProperty(key));
                continue;
            }
            if ("url".equalsIgnoreCase(s)) {
                conInfo.setUrl(props.getProperty(key));
                continue;
            }
            if ("autocommit".equalsIgnoreCase(s)) {
                conInfo.setAutoCommit(props.getProperty(key));
                continue;
            }
            if ("isolation".equalsIgnoreCase(s)) {
                conInfo.setIsolation(props.getProperty(key));
                continue;
            }
            if ("readonly".equalsIgnoreCase(s)) {
                conInfo.setReadOnly(props.getProperty(key));
                continue;
            }
            if ("useBatchInsert".equalsIgnoreCase(s)) {
                conInfo.setUseBatchInsert(props.getProperty(key));
                continue;
            }
            if (!"useBatchInsert.batchSize".equalsIgnoreCase(s)) continue;
            conInfo.setBatchInsertSize(props.getProperty(key));
        }
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.fine("connections are: \n" + this.connections.toString());
        }
    }

    public HashMap<String, SqlConnectionInfo> getConnections() {
        return this.connections;
    }

    public void setConnections(HashMap<String, SqlConnectionInfo> connections) {
        this.connections = connections;
    }

    public static String toString(Connection aConn) {
        if (aConn != null) {
            try {
                return "DB Connection for product='" + aConn.getMetaData().getDatabaseProductName() + "', version='" + aConn.getMetaData().getDatabaseProductVersion() + "', driver='" + aConn.getMetaData().getDriverName() + "', version='" + aConn.getMetaData().getDriverVersion() + "', URL='" + aConn.getMetaData().getURL() + "', user='" + aConn.getMetaData().getUserName() + "' ";
            }
            catch (SQLException e) {
                return "[DB Connection info unavailable]";
            }
        }
        return "[DB Connection is null]";
    }

    public static TreeMap<String, Connection> openConnections(TreeMap<String, SqlConnectionInfo> conInfos) {
        TreeMap<String, Connection> conns = new TreeMap<String, Connection>();
        Connection conn = null;
        connectionErrors = "";
        Collection<SqlConnectionInfo> c = conInfos.values();
        for (SqlConnectionInfo conInfo : c) {
            block19: {
                if (LogSetup.IS_LOGGING) {
                    LogSetup.LOGGER.fine("conInfo is: \n" + conInfo);
                }
                if (!conInfo.isSqlConnectionInfoValid()) {
                    connectionErrors = connectionErrors + "   (" + ++numberOfConnectionErrors + ") " + conInfo.getName() + " connection information '" + conInfo.toString() + "' invalid or missing.";
                    if (!LogSetup.IS_LOGGING) continue;
                    LogSetup.LOGGER.warning("Missing connection information, skipping: \n" + conInfo);
                    continue;
                }
                String driver = conInfo.getDriver();
                if (driver != null) {
                    System.setProperty("jdbc.drivers", driver);
                    try {
                        Class.forName(driver);
                    }
                    catch (ClassNotFoundException e1) {
                        connectionErrors = connectionErrors + "\n   (" + ++numberOfConnectionErrors + ") " + conInfo.getName() + " driver '" + driver + "' not found on classpath or could not be loaded";
                        if (!LogSetup.IS_LOGGING) break block19;
                        LogSetup.LOGGER.warning("Could not find database driver, skipping: \n" + conInfo);
                    }
                }
            }
            try {
                String tmp;
                conn = DriverManager.getConnection(conInfo.getUrl(), conInfo.getUser(), conInfo.getPassword());
                if (LogSetup.IS_LOGGING) {
                    LogSetup.LOGGER.fine("Opening " + SqlConnections.toString(conn));
                }
                if ((tmp = conInfo.getAutoCommit()) != null) {
                    conn.setAutoCommit("true".equalsIgnoreCase(tmp) || "yes".equalsIgnoreCase(tmp) || "on".equalsIgnoreCase(tmp) || "1".equals(tmp));
                }
                if ((tmp = conInfo.getIsolation()) != null) {
                    if ("UR".equalsIgnoreCase(tmp) || "UNCOMMITTED".equalsIgnoreCase(tmp)) {
                        conn.setTransactionIsolation(1);
                    } else if ("CR".equalsIgnoreCase(tmp) || "COMMITTED".equalsIgnoreCase(tmp)) {
                        conn.setTransactionIsolation(2);
                    } else if ("RR".equalsIgnoreCase(tmp) || "REPEATABLE".equalsIgnoreCase(tmp)) {
                        conn.setTransactionIsolation(4);
                    } else if ("CC".equalsIgnoreCase(tmp) || "SERIALIZABLE".equalsIgnoreCase(tmp)) {
                        conn.setTransactionIsolation(8);
                    } else {
                        conn.setTransactionIsolation(0);
                    }
                }
                conns.put(conInfo.getName(), conn);
                String isBatchInsertUsed = conInfo.getUseBatchInsert();
                if (!"true".equalsIgnoreCase(isBatchInsertUsed)) continue;
                System.setProperty("sql.file.useBatchInsert", isBatchInsertUsed);
                System.setProperty("sql.file.useBatchInsert.batchSize", conInfo.getBatchInsertSize());
            }
            catch (Exception e) {
                connectionErrors = connectionErrors + "\n   (" + ++numberOfConnectionErrors + ") " + conInfo.getName() + " could not connect to database: '" + e.getMessage() + "'";
                if (!LogSetup.IS_LOGGING) continue;
                LogSetup.LOGGER.warning("Could not connect to database (" + e.getMessage() + "), skipping: \n" + conInfo);
            }
        }
        return conns;
    }

    public static void closeConnections(ArrayList<Connection> conns) {
        for (Connection conn : conns) {
            try {
                if (conn.isClosed()) continue;
                conn.close();
            }
            catch (SQLException sQLException) {}
        }
        while (conns.size() > 0) {
            conns.remove(0);
        }
    }

    public static String getConnectionErrors() {
        return connectionErrors;
    }

    public void removeConnection(String aConnName) {
        this.connections.remove(aConnName);
    }

    public void addConnection(String name, String user, String password, String driver, String url2, String dataSource, String autocommit, String isolation, String readonly, String useBatchInsert, String batchInsertSize) {
        if (this.connections == null) {
            this.connections = new HashMap();
        } else {
            this.connections.remove(name);
        }
        SqlConnectionInfo connInfo = new SqlConnectionInfo(name, user, password, driver, url2, dataSource);
        connInfo.setAutoCommit(autocommit);
        connInfo.setIsolation(isolation);
        connInfo.setReadOnly(readonly);
        connInfo.setUseBatchInsert(useBatchInsert);
        connInfo.setBatchInsertSize(batchInsertSize);
        this.connections.put(name, connInfo);
    }

    static {
        numberOfConnectionErrors = 0;
    }
}

