/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.isamsql;

import com.heirloomcomputing.ecs.exec.Codepage;
import com.heirloomcomputing.ecs.exec.LockFile;
import com.heirloomcomputing.ecs.exec.LogSetup;
import com.heirloomcomputing.ecs.exec.Numeric;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.Utilities;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.exec.VariableList;
import com.heirloomcomputing.ecs.isamsql.ACCESSMODE;
import com.heirloomcomputing.ecs.isamsql.DBMS;
import com.heirloomcomputing.ecs.isamsql.FILETYPE;
import com.heirloomcomputing.ecs.isamsql.OPENMODE;
import com.heirloomcomputing.ecs.isamsql.READSTATE;
import com.heirloomcomputing.ecs.isamsql.Shared;
import com.heirloomcomputing.ecs.isamsql.SqlColumn;
import com.heirloomcomputing.ecs.isamsql.SqlConnectionInfo;
import com.heirloomcomputing.ecs.isamsql.SqlConnections;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.TreeMap;
import java.util.Vector;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.xml.bind.DatatypeConverter;

public class VDB {
    private static SqlConnections GlobalSqlConnections = null;
    private static final int READ_MODE_UPDATE = 4;
    public static String PGM = "VDB";
    int esdsKey = -1;
    private final String DB2_DUP_ERROR = "23505";
    private final String MYSQL_DUP_ERROR = "23000";
    private static boolean THROWEXCEPTIONS = true;
    private final String defaultEbcdicEncoding = "Cp277";
    private HashMap<String, PreparedStatement> keyToPreparedStatementMap = new HashMap();
    private static int BUFFSIZE = -1;
    private static final int DEFAULT_FETCHSIZE = 1000;
    private static int FETCHSIZE = -1;
    private int FetchSize = -1;
    private int BuffSize = -1;
    private boolean supportsSavepoints = false;
    private boolean supportsReleaseSavepoints = false;
    public String assignTo = null;
    private Vector<SqlColumn> columns = null;
    private String sqlTableName = null;
    private String sqlCatalogName = null;
    private String sqlSchemaName = null;
    private String[] candidateSqlTableNames = null;
    private boolean readable = false;
    private boolean writeable = false;
    private boolean forRemoval = false;
    public Connection conn = null;
    public boolean ETPcontrolledConnection = false;
    private Shared shared = new Shared();
    private int priorErrorCode = 0;
    private boolean remote = false;
    private int port = 0;
    private String site = null;
    public Variable filenameVariable = null;
    public boolean optional = false;
    public Variable fileStatus = null;
    public int blockFrom = 0;
    public int blockTo = 0;
    public boolean isRecords = false;
    public int recordFrom = 0;
    public int recordTo = 0;
    public Variable dependingOn = null;
    public int numberOfKeys = 0;
    private int currentKeyNumber = -1;
    public String[] keyNameArray = new String[256];
    public Variable[] keyArray = new Variable[256];
    private byte[][] keyBuffers = new byte[256][];
    public boolean[] isKeyDuplicates = new boolean[256];
    private String lastSqlStatement = null;
    private int batchInsertedRows;
    private PreparedStatement batchPreparedStmt = null;
    private PreparedStatement rewritePreparedStmt = null;
    private PreparedStatement deletePreparedStmt = null;
    public static boolean LOGVDB;
    private static boolean EXTENDEDSSA;
    private static boolean DISABLE_SQLCURSORS;
    private static int BATCH_UPDATE_THRESHOLD;
    public boolean resultSetInvalidated = false;
    private String compactCompositeKeyName = "";
    private static final Pattern IDXCOL_LENGTH_PATTERN;
    private static Class<?> dfsrrc00Class;
    private static Method dfsrrc00GetInstanceMapMethod;
    private HashMap<String, Object> imsObjTbl = null;
    private ResultSet resultSet = null;
    private PreparedStatement browseStmt = null;
    private byte[] lastRowKeyBytes = null;
    private byte[] endPageKeyBytes = null;
    private Integer endPageInt = null;
    private byte[] endPagePrimaryKeyBytes = null;
    private byte[] prevKeyBytes = null;
    private boolean isUsingAlternateKey = false;
    private int direction = 0;
    private byte[] record0 = null;
    private byte[] record1 = null;
    private byte[] record2 = null;
    private Object primeKey1 = null;
    private Object primeKey2 = null;
    private Object originalKey = null;
    private byte[] originalKeyEbcidic = null;
    private byte[] primeKeyEbcdic = null;
    private Object altKey1 = null;
    private Object altKey2 = null;
    public int idxFormat = 3;
    public String filteredFilename = null;
    public String primaryKeyColumn = null;
    public String aixOrPathName = null;
    private int keyCompression = 0;
    private int dataCompression = 0;
    private boolean dataEncryption = false;
    private String comparator = null;
    private String operator = null;
    private long buffering = 1L;
    private int rewriteBuffer = 0;
    private int deleteBuffer = 0;
    private boolean generic = false;
    private String blobTypeName = "BLOB";
    private String blobTypeNameMax = "BLOB";
    private String idxTypeName = "BLOB";
    private String topClause = "";
    private String cascadeOption = "";
    private String notNullPrimaryKeyOption = " not null primary key";
    private int blobTypeMaxSize = Integer.MAX_VALUE;
    private int blobTypeMultiplier = 1;
    public ACCESSMODE accessMode = ACCESSMODE.UNKNOWN;
    public DBMS dbms = DBMS.UNKNOWN;
    public int driverMajorVersion;
    public int dbmsMajorVersion;
    private String dbmsName = "";
    public int paginationOffset = 0;
    public int paginationLimit = 0;
    public int readMode = 0;
    public boolean browsing = false;
    public boolean isReadRandom = false;
    String conditionForCount = "";
    public READSTATE readState = READSTATE.CLOSED;
    public OPENMODE openMode = OPENMODE.CLOSED;
    public FILETYPE fileType = FILETYPE.UNKNOWN;
    private boolean isDisableCursorCompatible;
    private Boolean ALLOW_CURSOR_OVERRIDE;
    private static boolean TECHECKED;
    private static final String UNKNOWN_DB_NAME = "unknown";

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.ETPcontrolledConnection && this.conn != null && !this.conn.isClosed()) {
            this.shared.unShare();
            if (this.shared.isShared()) {
                if (LogSetup.IS_LOGGING) {
                    LogSetup.LOGGER.fine("Not Closing (shared) " + VDB.toString(this.conn));
                } else if (LOGVDB) {
                    System.out.println("Not Closing (shared) " + VDB.toString(this.conn));
                }
            } else {
                if (LogSetup.IS_LOGGING) {
                    LogSetup.LOGGER.fine("Closing (not shared) " + VDB.toString(this.conn));
                } else if (LOGVDB) {
                    System.out.println("Not Closing (shared) " + VDB.toString(this.conn));
                }
                this.conn.close();
                this.conn = null;
            }
        } else if (LogSetup.IS_LOGGING) {
            if (this.conn == null || this.conn.isClosed()) {
                LogSetup.LOGGER.fine("Not closing (already closed)");
            } else {
                LogSetup.LOGGER.fine("Not closing (ETP controlled)" + VDB.toString(this.conn));
            }
        } else if (LOGVDB) {
            if (this.conn == null || this.conn.isClosed()) {
                System.out.println("Not closing (already closed)");
            } else {
                System.out.println("Not closing (ETP controlled)" + VDB.toString(this.conn));
            }
        }
    }

    public VDB() {
        PGM = UNKNOWN_DB_NAME;
        this.shared.share();
        if (System.getProperty("logvdb") != null) {
            LOGVDB = true;
        }
        EXTENDEDSSA = Boolean.valueOf(System.getProperty("ims.extendedssa"));
        DISABLE_SQLCURSORS = Boolean.valueOf(System.getProperty("disable_sqlcursors"));
        BATCH_UPDATE_THRESHOLD = Integer.valueOf(System.getProperty("batchUpdateThreshold", "0"));
        this.ALLOW_CURSOR_OVERRIDE = Boolean.valueOf(System.getProperty("allow_cursor_override"));
    }

    public VDB(String pgm) {
        PGM = pgm + ": ";
        this.shared.share();
        if (System.getProperty("logvdb") != null) {
            LOGVDB = true;
        }
        EXTENDEDSSA = Boolean.valueOf(System.getProperty("ims.extendedssa"));
        DISABLE_SQLCURSORS = Boolean.valueOf(System.getProperty("disable_sqlcursors"));
        BATCH_UPDATE_THRESHOLD = Integer.valueOf(System.getProperty("batchUpdateThreshold", "0"));
        this.ALLOW_CURSOR_OVERRIDE = Boolean.valueOf(System.getProperty("allow_cursor_override"));
    }

    public VDB(VDB cpy) {
        this.assignTo = cpy.assignTo;
        this.columns = cpy.columns;
        this.sqlTableName = cpy.sqlTableName;
        this.openMode = cpy.openMode;
        this.readState = cpy.readState;
        this.fileType = cpy.fileType;
        this.readable = cpy.readable;
        this.writeable = cpy.writeable;
        this.conn = cpy.conn;
        this.shared = cpy.shared;
        this.shared.share();
        this.priorErrorCode = cpy.priorErrorCode;
        this.resultSet = null;
        this.paginationLimit = cpy.paginationLimit;
        this.remote = cpy.remote;
        this.port = cpy.port;
        this.site = cpy.site;
        this.filenameVariable = cpy.filenameVariable;
        this.optional = cpy.optional;
        this.fileStatus = cpy.fileStatus;
        this.accessMode = cpy.accessMode;
        this.blockFrom = cpy.blockFrom;
        this.blockTo = cpy.blockTo;
        this.isRecords = cpy.isRecords;
        this.recordFrom = cpy.recordFrom;
        this.recordTo = cpy.recordTo;
        this.dependingOn = cpy.dependingOn;
        this.numberOfKeys = cpy.numberOfKeys;
        this.keyNameArray = new String[this.numberOfKeys];
        this.keyArray = new Variable[this.numberOfKeys];
        this.keyBuffers = new byte[this.numberOfKeys][];
        for (int i = 0; i < this.numberOfKeys; ++i) {
            this.keyNameArray[i] = cpy.keyNameArray[i];
            this.keyArray[i] = cpy.keyArray[i];
            if (cpy.keyBuffers[i] == null) continue;
            this.keyBuffers[i] = new byte[cpy.keyBuffers[i].length];
        }
        this.isKeyDuplicates = cpy.isKeyDuplicates;
        this.record0 = cpy.record1;
        this.record1 = cpy.record1;
        this.record2 = cpy.record1;
        this.primeKey1 = cpy.primeKey1;
        this.primeKey2 = cpy.primeKey2;
        this.altKey1 = cpy.altKey1;
        this.altKey2 = cpy.altKey2;
        this.keyCompression = cpy.keyCompression;
        this.dataCompression = cpy.dataCompression;
        this.dataEncryption = cpy.dataEncryption;
        this.idxFormat = cpy.idxFormat;
        this.filteredFilename = cpy.filteredFilename;
        this.comparator = cpy.comparator;
        this.operator = cpy.operator;
        this.primaryKeyColumn = cpy.primaryKeyColumn;
        this.buffering = cpy.buffering;
        this.rewriteBuffer = cpy.rewriteBuffer;
        this.deleteBuffer = cpy.deleteBuffer;
        this.browsing = cpy.browsing;
        this.dbms = cpy.dbms;
        this.dbmsName = cpy.dbmsName;
        this.dbmsMajorVersion = cpy.dbmsMajorVersion;
        this.driverMajorVersion = cpy.driverMajorVersion;
        this.readMode = cpy.readMode;
        if (System.getProperty("logvdb") != null) {
            LOGVDB = true;
        }
        EXTENDEDSSA = Boolean.valueOf(System.getProperty("ims.extendedssa"));
        DISABLE_SQLCURSORS = Boolean.valueOf(System.getProperty("disable_sqlcursors"));
        BATCH_UPDATE_THRESHOLD = Integer.valueOf(System.getProperty("batchUpdateThreshold", "0"));
        this.isDisableCursorCompatible = cpy.isDisableCursorCompatible;
        this.ALLOW_CURSOR_OVERRIDE = Boolean.valueOf(System.getProperty("allow_cursor_override"));
    }

    public void swap(Variable older, Variable newer) {
        if (older != null && newer != null) {
            if (older == this.filenameVariable) {
                this.filenameVariable = newer;
            } else if (older == this.dependingOn) {
                this.dependingOn = newer;
            } else if (older == this.fileStatus) {
                this.fileStatus = newer;
            } else {
                for (int i = 0; i < this.numberOfKeys; ++i) {
                    if (older != this.keyArray[i]) continue;
                    this.keyArray[i] = newer;
                    break;
                }
            }
        }
    }

    protected void warning(String method, String text) {
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.warning("VDB." + method + ": " + text);
        } else if (LOGVDB) {
            System.out.println("VDB." + method + ": " + text);
        }
    }

    public String toDesc() {
        if (this.filenameVariable != null) {
            return "FILE " + this.filenameVariable.getName() + "=\"" + this.filenameVariable.toString();
        }
        if (this.assignTo != null) {
            return "ASSIGN TO " + this.assignTo;
        }
        return "[unknown file]";
    }

    public String toString() {
        int i;
        String linesep = System.getProperty("line.separator");
        if (linesep == null) {
            linesep = "\n";
        }
        StringBuffer result = new StringBuffer();
        if (this.accessMode == ACCESSMODE.RANDOM) {
            result.append("ACCESS MODE IS RANDOM").append(linesep);
        } else if (this.accessMode == ACCESSMODE.DYNAMIC) {
            result.append("ACCESS MODE IS DYNAMIC").append(linesep);
        } else if (this.accessMode == ACCESSMODE.SEQUENTIAL) {
            result.append("ACCESS MODE IS SEQUENTIAL").append(linesep);
        }
        result.append((this.optional ? "" : "NOT-") + "OPTIONAL").append(linesep);
        if (this.filenameVariable != null) {
            result.append("ASSIGN TO ").append(this.filenameVariable.getName()).append("=\"").append(this.filenameVariable.toString()).append("\"").append(linesep);
        }
        if (this.fileStatus != null) {
            result.append("FILE STATUS IS ").append(this.fileStatus.getName()).append("=").append(this.fileStatus.toDisplayString()).append(linesep);
        }
        if (this.recordFrom == this.recordTo) {
            result.append("RECORDING MODE IS FIXED").append(linesep);
        } else {
            result.append("RECORDING MODE IS VARIABLE").append(linesep);
        }
        if (this.recordFrom != -1 || this.recordTo != -1) {
            if (this.recordFrom >= this.recordTo) {
                result.append("RECORD CONTAINS ").append(this.recordFrom).append(" CHARACTERS").append(linesep);
            } else {
                result.append("RECORD CONTAINS ").append(this.recordFrom).append(" TO ").append(this.recordTo).append(" CHARACTERS").append(linesep);
            }
        }
        if (this.dependingOn != null) {
            result.append("DEPENDING ON ").append(this.dependingOn.getName()).append('=').append(this.dependingOn.toInt()).append(linesep);
        }
        if (this.blockFrom != 0 || this.blockTo != 0) {
            String type = null;
            type = this.isRecords ? " RECORDS" : " CHARACTERS";
            if (this.blockFrom >= this.blockTo) {
                result.append("BLOCK CONTAINS ").append(this.blockFrom).append(type).append(linesep);
            } else {
                result.append("BLOCK CONTAINS ").append(this.blockFrom).append(" TO ").append(this.blockTo).append(type).append(linesep);
            }
        }
        if (this.remote) {
            result.append("IS REMOTE (HOST='" + this.site + "', PORT='" + this.port + "')").append(linesep);
        }
        switch (this.openMode) {
            case OPEN_INPUT: {
                result.append("FILE IS OPEN FOR INPUT").append(linesep);
            }
            case OPEN_OUTPUT: {
                result.append("FILE IS OPEN FOR OUTPUT").append(linesep);
                break;
            }
            case OPEN_IO: {
                result.append("FILE IS OPEN FOR I-O").append(linesep);
                break;
            }
            case CLOSED: {
                result.append("FILE IS CLOSED").append(linesep);
            }
        }
        result.append((this.readable ? "" : "NOT ") + "READABLE").append(linesep);
        result.append((this.writeable ? "" : "NOT ") + "WRITEABLE").append(linesep);
        result.append("numberOfKeys is " + this.numberOfKeys).append(linesep);
        result.append("NAMES OF KEYS: ").append(linesep);
        for (i = 0; i < this.numberOfKeys; ++i) {
            result.append("    " + this.keyNameArray[i] + (i == 0 ? ". PRIMARY KEY" : ". ALTERNATE KEY")).append(linesep);
        }
        result.append("VALUE OF KEYS: ").append(linesep);
        for (i = 0; i < this.numberOfKeys; ++i) {
            result.append("    " + this.keyArray[i].toText() + (i == 0 ? ". PRIMARY KEY" : ". ALTERNATE KEY")).append(linesep);
        }
        result.append("Currently" + (this.browsing ? " " : " Not ") + "Browsing").append(linesep);
        return result.toString();
    }

    public boolean isOpen(OPENMODE checkFor) {
        try {
            if (this.conn == null || this.conn.isClosed()) {
                this.openMode = OPENMODE.CLOSED;
            }
        }
        catch (SQLException e) {
            this.openMode = OPENMODE.CLOSED;
        }
        return checkFor == this.openMode;
    }

    public static String toString(Connection aConn) {
        if (aConn != null) {
            try {
                return "DB Connection for product='" + aConn.getMetaData().getDatabaseProductName() + "', version='" + aConn.getMetaData().getDatabaseProductVersion() + "', driver='" + aConn.getMetaData().getDriverName() + "', version='" + aConn.getMetaData().getDriverVersion() + "', URL='" + aConn.getMetaData().getURL() + "', user='" + aConn.getMetaData().getUserName() + "' ";
            }
            catch (SQLException e) {
                return "[DB Connection info unavailable]";
            }
        }
        return "[DB Connection is null]";
    }

    public void sortKeys() {
        if (this.numberOfKeys < 3) {
            return;
        }
        for (int A = 1; A < this.numberOfKeys - 1; ++A) {
            for (int B = A + 1; B < this.numberOfKeys; ++B) {
                boolean AisVL = this.keyArray[A] instanceof VariableList;
                boolean BisVL = this.keyArray[B] instanceof VariableList;
                if ((!AisVL || BisVL) && this.keyArray[B].getAddress() >= this.keyArray[A].getAddress()) continue;
                Variable tempVar = this.keyArray[B];
                this.keyArray[B] = this.keyArray[A];
                this.keyArray[A] = tempVar;
                String tempString = this.keyNameArray[B];
                this.keyNameArray[B] = this.keyNameArray[A];
                this.keyNameArray[A] = tempString;
                boolean tempBool = this.isKeyDuplicates[B];
                this.isKeyDuplicates[B] = this.isKeyDuplicates[A];
                this.isKeyDuplicates[A] = tempBool;
                byte[] tempBytes = this.keyBuffers[B];
                this.keyBuffers[B] = this.keyBuffers[A];
                this.keyBuffers[A] = tempBytes;
            }
        }
    }

    public synchronized boolean open(int mode) throws RuntimeException {
        boolean optional;
        String func = ".open(): ";
        boolean isExtend = (mode & 4) == 4;
        this.readable = (mode & 1) == 1;
        this.writeable = (mode & 2) == 2;
        this.forRemoval = (mode & 0x80) == 128;
        boolean bl = optional = (mode & 8) == 8;
        if (this.readable && this.writeable) {
            this.openMode = OPENMODE.OPEN_IO;
            this.readState = READSTATE.OPEN;
        } else if (this.readable) {
            this.openMode = OPENMODE.OPEN_INPUT;
            this.readState = READSTATE.OPEN;
        } else if (this.writeable) {
            this.openMode = OPENMODE.OPEN_OUTPUT;
            this.readState = READSTATE.OPEN;
        } else {
            this.openMode = OPENMODE.CLOSED;
            this.readState = READSTATE.CLOSED;
        }
        this.currentKeyNumber = -1;
        if (!this.findTable(this.writeable && !this.readable && !isExtend, this.writeable, this.forRemoval)) {
            this.warning("open", "file missing and non optional open");
            this.setIOStatus(-35);
            this.readState = READSTATE.ERROR;
            if (!optional) {
                this.closeResultSet();
                VDB.Logit(PGM + ".open(): " + ":file status=" + (this.fileStatus == null ? "NOT FOUND" : this.fileStatus.toText()) + ". ERROR! SQL table not found corresponding to file '" + this.getFilename() + "'", ".open(): ");
            }
            return false;
        }
        if (this.sqlTableName == null) {
            this.setIOStatus(-90);
            VDB.Logit("file status=" + (this.fileStatus == null ? "ERROR_OTHER" : this.fileStatus.toText()) + ". ERROR! ASSIGN TO filename must correspond to a SQL table (e.g., file 'SYS1.MYUSER.CUSTOMERS.DAT' would have a CUSTOMERS table)   ASSIGN TO filename is '" + this.getFilename() + "'", ".open(): ");
            return false;
        }
        this.readTableFetchsize();
        if (LogSetup.IS_LOGGING) {
            int i;
            for (i = 0; i < this.numberOfKeys; ++i) {
                LogSetup.LOGGER.fine("keyArray[" + i + "]: name=" + this.keyArray[i].getName() + ". recordPosition=" + this.keyArray[i].getRecordPosition() + ". length=" + this.keyArray[i].length());
            }
            LogSetup.LOGGER.fine(" To display sql column info: ");
            for (i = 0; i < this.columns.size(); ++i) {
                LogSetup.LOGGER.fine("SqlColumn " + i + " " + this.columns.get(i).toString());
            }
        } else if (LOGVDB) {
            int i;
            for (i = 0; i < this.numberOfKeys; ++i) {
                if (VDB.isAllNulls(this.keyArray)) continue;
                System.out.println("keyArray[" + i + "]: name=" + this.keyArray[i].getName() + ". recordPosition=" + this.keyArray[i].getRecordPosition() + ". length=" + this.keyArray[i].length());
            }
            System.out.println(" To display sql column info: ");
            for (i = 0; i < this.columns.size(); ++i) {
                System.out.println("SqlColumn " + i + " " + this.columns.get(i).toString());
            }
        }
        this.browsing = false;
        this.setIOStatus(0);
        this.batchInsertedRows = 0;
        return true;
    }

    public static boolean isAllNulls(Variable[] array) {
        return Arrays.asList(array).stream().allMatch(o -> o == null);
    }

    private void setupDefaultAndGlobalFetchSize() {
        block5: {
            if (FETCHSIZE == -1) {
                try {
                    String str = RuntimeEnvironment.getGlobalParameter("DB-ROWS-TO-FETCH");
                    if (str != null) {
                        this.FetchSize = FETCHSIZE = Integer.parseInt(str);
                        break block5;
                    }
                    FETCHSIZE = 1000;
                    this.FetchSize = 1000;
                }
                catch (NumberFormatException e) {
                    FETCHSIZE = 1000;
                    this.FetchSize = 1000;
                }
            } else {
                this.FetchSize = FETCHSIZE;
            }
        }
    }

    public void resetDefaultAndGlobalFetchSize(int fetchSize) {
        this.FetchSize = FETCHSIZE = fetchSize;
    }

    private void readTableFetchsize() {
        try {
            String str = RuntimeEnvironment.getGlobalParameter("DB-ROWS-TO-FETCH-" + this.sqlTableName.toUpperCase());
            this.FetchSize = str != null ? (FETCHSIZE = Integer.parseInt(str)) : FETCHSIZE;
        }
        catch (NumberFormatException e) {
            FETCHSIZE = 1000;
            this.FetchSize = 1000;
        }
    }

    public synchronized boolean openTimeoutSeconds(int mode, Numeric timeout) throws RuntimeException {
        mode = LockFile.transformOpenMode(mode);
        int timeout_mask = 0x2100000;
        mode &= ~timeout_mask;
        double seconds = timeout.toDouble();
        boolean success = false;
        long currentTime = System.currentTimeMillis();
        long finalTime = currentTime + (long)(seconds * 1000.0);
        do {
            this.setIOStatus(0);
            success = this.open(mode);
            if (success || System.currentTimeMillis() >= finalTime) continue;
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (!success && System.currentTimeMillis() < finalTime);
        return success;
    }

    public synchronized boolean openTimeoutRetries(int mode, Numeric timeout) throws RuntimeException {
        mode = LockFile.transformOpenMode(mode);
        int timeout_mask = 0x2100000;
        mode &= ~timeout_mask;
        int attempts = timeout.toInt();
        if (attempts < 0) {
            attempts = 0;
        }
        ++attempts;
        boolean success = false;
        do {
            this.setIOStatus(0);
            success = this.open(mode);
            if (success || --attempts <= 0) continue;
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (!success && attempts > 0);
        return success;
    }

    public synchronized boolean openTimeoutRetries(int mode) throws RuntimeException {
        mode = LockFile.transformOpenMode(mode);
        mode &= 0xFDEFFFFF;
        boolean success = false;
        do {
            this.setIOStatus(0);
            success = this.open(mode);
            if (success) continue;
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (!success);
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean close(int mode) throws RuntimeException {
        String func = ".close(): ";
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.fine("In close(int). ");
        } else if (LOGVDB) {
            System.out.println("In close(int). ");
        }
        if (this.isOpen(OPENMODE.CLOSED)) {
            this.setIOStatus(-42);
            this.readState = READSTATE.ERROR;
            VDB.Logit(PGM + ".close(): ", "Cannot close file '" + this.getFilteredFilename() + "' because it is already closed");
            return false;
        }
        try {
            boolean isDisableCursorsLocal;
            this.closeResultSet();
            if (this.isBatchInsertMode() && this.batchPreparedStmt != null) {
                int[] executeBatchResult = this.batchPreparedStmt.executeBatch();
                for (int res : executeBatchResult) {
                    if (res == true) continue;
                    throw new SQLException("At least one of the inserts in the batch updated more than 1 record, which is not expected");
                }
            }
            boolean bl = isDisableCursorsLocal = this.isDisableCursorCompatible && DISABLE_SQLCURSORS;
            if (isDisableCursorsLocal && BATCH_UPDATE_THRESHOLD > 0) {
                int[] rowsUpdated;
                if (this.deletePreparedStmt != null && this.deleteBuffer > 0) {
                    rowsUpdated = this.deletePreparedStmt.executeBatch();
                    int totRowsDeleted = IntStream.of(rowsUpdated).sum();
                    if (totRowsDeleted != this.deleteBuffer) {
                        throw new SQLException("At least one of the deletes in the batch deleted more than 1 record, which is not expected");
                    }
                    this.deleteBuffer = 0;
                    this.deletePreparedStmt = null;
                }
                if (this.rewritePreparedStmt != null && this.rewriteBuffer > 0) {
                    rowsUpdated = this.rewritePreparedStmt.executeBatch();
                    int totRowsUpdated = IntStream.of(rowsUpdated).sum();
                    if (totRowsUpdated != this.rewriteBuffer) {
                        throw new SQLException("At least one of the rewrites in the batch updated more than 1 record, which is not expected");
                    }
                    this.rewriteBuffer = 0;
                    this.rewritePreparedStmt = null;
                }
            }
            if (!this.conn.getAutoCommit()) {
                this.conn.commit();
            }
            Object object = this.keyToPreparedStatementMap.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry stmt = (Map.Entry)object.next();
                ((PreparedStatement)stmt.getValue()).close();
            }
            this.keyToPreparedStatementMap.clear();
            if (!this.ETPcontrolledConnection) {
                this.shared.unShare();
                if (!this.shared.isShared()) {
                    if (LogSetup.IS_LOGGING) {
                        LogSetup.LOGGER.fine("Closing (not shared) " + VDB.toString(this.conn));
                    } else if (LOGVDB) {
                        System.out.println("Closing (not shared) " + VDB.toString(this.conn));
                    }
                    this.conn.close();
                    this.conn = null;
                } else if (LogSetup.IS_LOGGING) {
                    LogSetup.LOGGER.fine("Not closing (shared connection)" + VDB.toString(this.conn));
                } else if (LOGVDB) {
                    System.out.println("Not closing (shared connection)" + VDB.toString(this.conn));
                }
            } else if (LogSetup.IS_LOGGING) {
                if (this.conn == null || this.conn.isClosed()) {
                    LogSetup.LOGGER.fine("Not closing (already closed)");
                } else {
                    LogSetup.LOGGER.fine("Not closing (ETP controlled)" + VDB.toString(this.conn));
                }
            } else if (LOGVDB) {
                if (this.conn == null || this.conn.isClosed()) {
                    System.out.println("Not closing (already closed)");
                } else {
                    System.out.println("Not closing (ETP controlled)" + VDB.toString(this.conn));
                }
            }
        }
        catch (SQLException e) {
            this.warning("close", "file missing and non optional open");
            this.closeResultSet();
            this.setIOStatus(-35);
            this.readState = READSTATE.ERROR;
            VDB.LogAndThrowException(PGM + ".close(): " + ": Cannot close table for '" + this.getFilteredFilename() + "' (table name " + this.sqlTableName + ") because " + e.getMessage(), false);
            boolean bl = false;
            return bl;
        }
        finally {
            this.conn = null;
            this.sqlTableName = null;
        }
        this.readState = READSTATE.CLOSED;
        this.browsing = false;
        this.setIOStatus(0);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteFile() {
        if (this.conn == null) {
            return false;
        }
        String func = ".deleteFile(): ";
        boolean rc = true;
        for (int i = 1; i < this.numberOfKeys; ++i) {
            Statement stmt = null;
            try {
                block31: {
                    stmt = this.conn.createStatement();
                    String dropIndexStmt = "drop index " + this.sqlTableName + "_aix_" + this.keyNameArray[i];
                    if (this.dbms == DBMS.MYSQL || this.dbms == DBMS.SQLSERVER) {
                        dropIndexStmt = dropIndexStmt + " on " + this.sqlTableName;
                    }
                    stmt.execute(dropIndexStmt);
                    if (!this.conn.getAutoCommit()) {
                        try {
                            this.conn.commit();
                        }
                        catch (SQLException e) {
                            String why = e.getMessage();
                            if (LogSetup.IS_LOGGING) {
                                LogSetup.LOGGER.finer(PGM + func + "SQLException=" + why);
                            }
                            if (!LOGVDB) break block31;
                            System.out.println(PGM + func + "SQLException=" + why);
                        }
                    }
                }
                rc &= true;
                continue;
            }
            catch (SQLException f) {
                this.warning("deleteFile", "file missing and non optional open");
                this.closeResultSet();
                this.setIOStatus(-35);
                this.readState = READSTATE.ERROR;
                VDB.LogAndThrowException(PGM + func + ": Cannot delete index " + this.sqlTableName + "_aix_" + this.keyNameArray[i] + " for '" + this.getFilteredFilename() + "' (table name " + this.sqlTableName + ") because " + f.getMessage(), false);
                rc &= false;
            }
        }
        Statement stmt = null;
        try {
            block32: {
                stmt = this.conn.createStatement();
                stmt.execute("drop table " + this.sqlTableName + this.cascadeOption);
                if (!this.conn.getAutoCommit()) {
                    try {
                        this.conn.commit();
                    }
                    catch (SQLException e) {
                        String why = e.getMessage();
                        if (LogSetup.IS_LOGGING) {
                            LogSetup.LOGGER.finer(PGM + func + "SQLException=" + why);
                        }
                        if (!LOGVDB) break block32;
                        LogSetup.LOGGER.finer(PGM + func + "SQLException=" + why);
                    }
                }
            }
            rc &= true;
        }
        catch (SQLException e) {
            try {
                block34: {
                    stmt.close();
                    stmt = this.conn.createStatement();
                    stmt.execute("drop view " + this.sqlTableName);
                    if (!this.conn.getAutoCommit()) {
                        try {
                            this.conn.commit();
                        }
                        catch (SQLException f) {
                            String why = e.getMessage();
                            if (LogSetup.IS_LOGGING) {
                                LogSetup.LOGGER.finer(PGM + func + "SQLException=" + why);
                                break block34;
                            }
                            if (!LOGVDB) break block34;
                            System.out.println(PGM + func + "SQLException=" + why);
                        }
                    }
                }
                rc &= true;
            }
            catch (SQLException f) {
                this.warning("deleteFile", "file missing and non optional open");
                this.closeResultSet();
                this.setIOStatus(-35);
                this.readState = READSTATE.ERROR;
                VDB.LogAndThrowException(PGM + func + ": Cannot delete table for '" + this.getFilteredFilename() + "' (table/view name " + this.sqlTableName + ") because '" + e.getMessage() + "' or '" + f.getMessage() + "'", false);
                rc &= false;
            }
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return rc;
    }

    public String getFilename() {
        String filename = "";
        filename = this.filenameVariable != null ? this.filenameVariable.toString() : this.assignTo;
        if (filename != null) {
            filename = filename.trim();
        }
        return filename;
    }

    public String getFilteredFilename() {
        String filename = "";
        filename = this.filenameVariable != null ? this.filenameVariable.toString().toLowerCase() : this.assignTo.toLowerCase();
        String[] path = filename.split(":");
        String[] ret = File.separator.equals("\\") ? path[path.length - 1].split("\\\\") : path[path.length - 1].split(File.separator);
        String partial = ret[ret.length - 1];
        return partial;
    }

    public int getIdxFormat() {
        return this.idxFormat;
    }

    public void setKeyCompress(int factor) {
        this.keyCompression = factor;
    }

    public int getKeyCompress() {
        return this.keyCompression;
    }

    public void setDataCompress(int factor) {
        this.dataCompression = factor;
    }

    public int getDataCompress() {
        return this.dataCompression;
    }

    public void setDataCompression() {
        this.setDataCompression(1);
    }

    public void setDataCompression(int val) {
        this.setDataCompress(val);
        this.setKeyCompress(val);
    }

    public int getDataCompression() {
        return this.dataCompression;
    }

    public void setDataEncryption(boolean flag) {
        this.dataEncryption = flag;
    }

    public boolean getDataEncryption() {
        return this.dataEncryption;
    }

    public synchronized boolean initFile() {
        String str;
        if (BUFFSIZE <= 0) {
            try {
                str = RuntimeEnvironment.getGlobalParameter("DB-BUFFER-SIZE");
                if (str == null) {
                    BUFFSIZE = 1000;
                } else {
                    BUFFSIZE = Integer.parseInt(str);
                    if (BUFFSIZE <= 0) {
                        BUFFSIZE = 1;
                    }
                }
            }
            catch (NumberFormatException e) {
                BUFFSIZE = 1000;
            }
        }
        this.setupDefaultAndGlobalFetchSize();
        if (!TECHECKED) {
            str = RuntimeEnvironment.getGlobalParameter("DB-EXCEPTIONS");
            boolean value = str == null || "YES".equalsIgnoreCase(str) || "TRUE".equalsIgnoreCase(str) || "1".equals(str) || "ON".equalsIgnoreCase(str);
            VDB.ThrowExceptions(value);
            TECHECKED = true;
        }
        return true;
    }

    private void constructPossibleTableNames(String[] components) {
        int i;
        boolean eliminateSuffix;
        int cnt = 0;
        boolean bl = eliminateSuffix = components.length > 1 && ("IDX".equalsIgnoreCase(components[components.length - 1]) || "DAT".equalsIgnoreCase(components[components.length - 1]));
        if (eliminateSuffix ? components.length == 4 : components.length == 3) {
            ++cnt;
        }
        ++cnt;
        if (components.length > 2 && eliminateSuffix) {
            ++cnt;
        }
        this.candidateSqlTableNames = new String[cnt];
        cnt = 0;
        this.candidateSqlTableNames[cnt] = components[0];
        for (i = 1; i < components.length; ++i) {
            int n = cnt;
            this.candidateSqlTableNames[n] = this.candidateSqlTableNames[n] + "_" + components[i];
        }
        ++cnt;
        if (eliminateSuffix ? components.length == 4 : components.length == 3) {
            this.candidateSqlTableNames[cnt] = components[0];
            for (i = 1; i < 3; ++i) {
                int n = cnt;
                this.candidateSqlTableNames[n] = this.candidateSqlTableNames[n] + "." + components[i];
            }
            ++cnt;
        }
        if (components.length > 2 && eliminateSuffix) {
            this.candidateSqlTableNames[cnt] = components[0];
            for (i = 1; i < components.length - 1; ++i) {
                int n = cnt;
                this.candidateSqlTableNames[n] = this.candidateSqlTableNames[n] + "_" + components[i];
            }
            ++cnt;
        }
    }

    private void setBuffering(Connection forThisConn) {
        try {
            this.BuffSize = forThisConn.getAutoCommit() ? 0 : BUFFSIZE;
        }
        catch (SQLException e) {
            this.BuffSize = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean findTableInConnection(String candidateTableName, Connection candidateConnection) {
        Statement stmt = null;
        boolean ret = false;
        try {
            stmt = candidateConnection.createStatement();
            DatabaseMetaData databaseMetaData = candidateConnection.getMetaData();
            boolean found = false;
            boolean isAixOrPath = false;
            String tableNamePart = null;
            String catalogNamePart = null;
            String schemaNamePart = null;
            ResultSet dbmdResult = null;
            dbmdResult = databaseMetaData.getTables(null, candidateConnection.getSchema(), candidateTableName, null);
            if (dbmdResult.next()) {
                this.sqlTableName = candidateTableName;
                isAixOrPath = "VIEW".equalsIgnoreCase(dbmdResult.getString(4));
                found = true;
            } else {
                dbmdResult = databaseMetaData.getTables(null, candidateConnection.getSchema(), candidateTableName.toUpperCase(), null);
                if (dbmdResult.next()) {
                    this.sqlTableName = candidateTableName.toUpperCase();
                    isAixOrPath = "VIEW".equalsIgnoreCase(dbmdResult.getString(4));
                    found = true;
                } else {
                    int posn1 = candidateTableName.indexOf(46);
                    if (posn1 > 0) {
                        int posn2 = candidateTableName.indexOf(46, posn1 + 1);
                        if (posn2 > 0) {
                            catalogNamePart = candidateTableName.substring(0, posn1);
                            schemaNamePart = candidateTableName.substring(posn1 + 1, posn2);
                            tableNamePart = candidateTableName.substring(posn2 + 1);
                        } else {
                            schemaNamePart = candidateTableName.substring(0, posn1);
                            tableNamePart = candidateTableName.substring(posn1 + 1);
                        }
                        dbmdResult = databaseMetaData.getTables(catalogNamePart, schemaNamePart, tableNamePart, null);
                        if (dbmdResult.next()) {
                            found = true;
                            this.sqlCatalogName = catalogNamePart;
                            this.sqlSchemaName = schemaNamePart;
                            this.sqlTableName = tableNamePart;
                            isAixOrPath = "VIEW".equalsIgnoreCase(dbmdResult.getString(4));
                        } else {
                            dbmdResult = databaseMetaData.getTables(catalogNamePart == null ? null : catalogNamePart.toUpperCase(), schemaNamePart.toUpperCase(), tableNamePart.toUpperCase(), null);
                            if (dbmdResult.next()) {
                                found = true;
                                this.sqlCatalogName = catalogNamePart == null ? null : catalogNamePart.toUpperCase();
                                this.sqlSchemaName = schemaNamePart.toUpperCase();
                                this.sqlTableName = tableNamePart.toUpperCase();
                                isAixOrPath = "VIEW".equalsIgnoreCase(dbmdResult.getString(4));
                            }
                        }
                    }
                }
            }
            if (found) {
                this.conn = candidateConnection;
                if (LogSetup.IS_LOGGING && this.conn.getMetaData() != null) {
                    LogSetup.LOGGER.fine("Using " + VDB.toString(this.conn) + (isAixOrPath ? "for view " : "for table '") + this.sqlTableName + "'. ");
                } else if (LOGVDB && this.conn.getMetaData() != null) {
                    System.out.println("Using " + VDB.toString(this.conn) + (isAixOrPath ? "for view " : "for table '") + this.sqlTableName + "'. ");
                }
                ret = true;
            } else if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.finer("Candidate table " + this.sqlTableName + " on " + VDB.toString(this.conn) + " not found.");
            } else if (LOGVDB) {
                System.out.println("Candidate table " + this.sqlTableName + " on " + VDB.toString(this.conn) + " not found.");
            }
        }
        catch (SQLException e) {
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.finer("Candidate table " + this.sqlTableName + " on " + VDB.toString(this.conn) + " not found. SQLException=" + e.getMessage());
            } else if (LOGVDB) {
                System.out.println("Candidate table " + this.sqlTableName + " on " + VDB.toString(this.conn) + " not found. SQLException=" + e.getMessage());
            }
        }
        finally {
            try {
                stmt.close();
                if (this.BuffSize > 0 && !candidateConnection.getAutoCommit() && VDB.getConnectionName(candidateConnection).contains("DB2")) {
                    candidateConnection.commit();
                }
            }
            catch (SQLException sQLException) {}
        }
        return ret;
    }

    private void findConnection() {
        block34: {
            block33: {
                Iterator<Map.Entry<String, Connection>> iter3;
                TreeMap<String, Connection> conns;
                block32: {
                    Connection trial;
                    String func = ".findConnection(): ";
                    if (this.conn != null && this.sqlTableName != null) {
                        this.setBuffering(this.conn);
                        return;
                    }
                    if (this.conn != null) break block33;
                    if (GlobalSqlConnections == null) {
                        GlobalSqlConnections = new SqlConnections();
                        GlobalSqlConnections.storeConnectionInfo();
                    }
                    TreeMap<String, SqlConnectionInfo> conInfos = new TreeMap<String, SqlConnectionInfo>();
                    conInfos.putAll(GlobalSqlConnections.getConnections());
                    if (conInfos.isEmpty()) {
                        this.warning("findConnection", "file missing and non optional open");
                        this.closeResultSet();
                        this.setIOStatus(-35);
                        this.readState = READSTATE.ERROR;
                        VDB.LogAndThrowException(PGM + ".findConnection(): " + ":\nNo SQL connections information available \nto map the VDB file '" + this.getFilteredFilename() + "' to a SQL table.\nUse properties in the deploy.properties|deploy_settings file or system properties\non java command line to indicate data source names and connection info, e.g. \n-Dsql.file.url=jdbc:postgres://localhost/mydb -Dsql.file.user=postgres \n-Dsql.file.password=mYp-ss -Dsql.file.driver=org.postgresql.Driver\n", false);
                    }
                    String dbTable = this.getFilteredFilename();
                    String[] dsnComponents = dbTable.split("\\.");
                    int dsnRangeFrom = 0;
                    if (dsnComponents.length > 1 && conInfos.get(dsnComponents[0]) != null) {
                        Iterator iter2 = conInfos.keySet().iterator();
                        while (iter2.hasNext()) {
                            String anInfoName = (String)iter2.next();
                            if (dsnComponents[0].equalsIgnoreCase(anInfoName)) continue;
                            iter2.remove();
                        }
                        ++dsnRangeFrom;
                    }
                    this.constructPossibleTableNames(Arrays.copyOfRange(dsnComponents, dsnRangeFrom, dsnComponents.length));
                    conns = SqlConnections.openConnections(conInfos);
                    if (LogSetup.IS_LOGGING) {
                        LogSetup.LOGGER.fine("conns.size()=" + conns.size());
                    } else if (LOGVDB) {
                        System.out.println("conns.size()=" + conns.size());
                    }
                    if (conns.isEmpty()) {
                        this.warning("findConnection", "file missing and non optional open");
                        this.closeResultSet();
                        this.setIOStatus(-35);
                        this.readState = READSTATE.ERROR;
                        VDB.LogAndThrowException(PGM + ".findConnection(): " + ": No SQL connections available to map the VDB file '" + this.getFilteredFilename() + "' to a SQL table. " + SqlConnections.getConnectionErrors() + " [" + conInfos.toString() + "]", false);
                        this.conn = null;
                        return;
                    }
                    if (conns.size() != conInfos.size()) {
                        Iterator<Map.Entry<String, Connection>> iterConn = conns.entrySet().iterator();
                        String[] setInfos = conInfos.keySet();
                        while (iterConn.hasNext()) {
                            Map.Entry<String, Connection> entryConn = iterConn.next();
                            setInfos.remove(entryConn.getKey());
                        }
                        for (String aConnName : setInfos) {
                            GlobalSqlConnections.removeConnection(aConnName);
                        }
                    }
                    if ((trial = conns.get("file")) != null) {
                        this.setBuffering(trial);
                        for (String candidateTableName : this.candidateSqlTableNames) {
                            if (this.findTableInConnection(candidateTableName, trial)) break;
                        }
                    } else {
                        iter3 = conns.entrySet().iterator();
                        while (iter3.hasNext()) {
                            Connection candidateConnection = iter3.next().getValue();
                            this.setBuffering(candidateConnection);
                            for (String candidateTableName : this.candidateSqlTableNames) {
                                if (!this.findTableInConnection(candidateTableName, candidateConnection)) {
                                    continue;
                                }
                                break block32;
                            }
                        }
                    }
                }
                if (this.conn == null) {
                    this.conn = conns.get("file");
                    if (this.conn == null) {
                        this.conn = conns.firstEntry().getValue();
                    }
                    try {
                        if (LogSetup.IS_LOGGING && this.conn.getMetaData() != null) {
                            LogSetup.LOGGER.fine("Using " + VDB.toString(this.conn) + "for table '" + this.sqlTableName + "'. ");
                        } else if (LOGVDB && this.conn.getMetaData() != null) {
                            System.out.println("Using " + VDB.toString(this.conn) + "for table '" + this.sqlTableName + "'. ");
                        }
                    }
                    catch (SQLException iter3) {
                        // empty catch block
                    }
                }
                iter3 = conns.entrySet().iterator();
                while (iter3.hasNext()) {
                    Connection anotherConn = iter3.next().getValue();
                    try {
                        if (this.conn == anotherConn) continue;
                        if (LogSetup.IS_LOGGING) {
                            LogSetup.LOGGER.fine("Closing " + VDB.toString(anotherConn));
                        } else if (LOGVDB) {
                            System.out.println("Closing " + VDB.toString(anotherConn));
                        }
                        anotherConn.close();
                    }
                    catch (SQLException sQLException) {}
                }
                break block34;
            }
            if (this.sqlTableName != null) break block34;
            String[] DSNParts = this.getFilteredFilename().split("\\.");
            this.constructPossibleTableNames(DSNParts);
            this.setBuffering(this.conn);
            for (String onePossibleTableName : this.candidateSqlTableNames) {
                if (this.findTableInConnection(onePossibleTableName, this.conn)) break;
            }
        }
    }

    private synchronized boolean findTable(boolean emptyIt, boolean createIt, boolean removeIt) throws RuntimeException {
        String func = ".findTable(): ";
        this.findConnection();
        if (this.conn == null) {
            return false;
        }
        if (new DetermineDBNameAndSettings().invoke()) {
            return false;
        }
        this.emptyOrRemoveTableIfRequired(emptyIt, removeIt, this.isEbcdicBinaryColumn());
        if (this.addIndexToExistingIfRequired(emptyIt, createIt, removeIt, this.isEbcdicBinaryColumn())) {
            return false;
        }
        if (this.createTable(createIt)) {
            return false;
        }
        if (this.isEbcdicBinaryColumn() && this.addEBCDICIndexColumn(emptyIt, createIt, removeIt)) {
            return false;
        }
        this.columns = SqlColumn.getColumns(this.sqlTableName, this.conn, this.dbms, this.driverMajorVersion, !Utilities.isCurrentEnviromentCICS());
        if (this.columns == null) {
            this.setIOStatus(-90);
            VDB.Logit("file status=" + (this.fileStatus == null ? "ERROR_OTHER" : this.fileStatus.toText()) + "  ERROR! SQL table mapping to VDB file could not be determined.  External filename is " + this.getFilename() + ". SQL Table name is " + this.sqlTableName, func);
            this.setIOStatus(-90);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addEBCDICIndexColumn(boolean emptyIt, boolean createIt, boolean removeIt) {
        String func = ".addEBCDICIndexColumn(): ";
        Statement stmt = null;
        if (this.conn != null && this.sqlTableName != null && createIt) {
            String alterStr = "alter table " + this.sqlTableName + " ";
            int numAdded = 0;
            Vector<SqlColumn> allSqlCols = SqlColumn.getColumns(this.sqlTableName, this.conn, this.dbms, this.driverMajorVersion, !Utilities.isCurrentEnviromentCICS());
            if (!(emptyIt || removeIt || createIt)) {
                this.warning("addEBCDICIndexColumn", "can't create a EBCIDIC column without open OUTPUT, I-O");
                this.closeResultSet();
                this.setIOStatus(-39);
                this.readState = READSTATE.ERROR;
                VDB.LogAndThrowException(PGM + func + ":  A key column named '" + this.keyNameArray[0] + "' matching the KEY IS COBOL element '" + this.keyArray[0].getName() + "' length and record offsets was not found", false);
                return true;
            }
            boolean primaryKeyCreated = false;
            if (allSqlCols.size() > 0) {
                for (int k = 0; k < this.numberOfKeys; ++k) {
                    boolean found = false;
                    for (SqlColumn aColumn : allSqlCols) {
                        if (!aColumn.getName().toLowerCase().startsWith("ci_") || !aColumn.getName().toLowerCase().endsWith(this.keyNameArray[k].toLowerCase())) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    if (numAdded > 0) {
                        alterStr = alterStr + ", ";
                    }
                    if (this.isEbcdicBinaryColumn()) {
                        alterStr = alterStr + "add " + this.generateEbcdicIndexKeyName(this.keyNameArray[k], this.primaryKeyColumn.equals(this.keyNameArray[k])) + " " + String.format(this.idxTypeName, this.getKeySize(this.keyArray[k])) + " not null";
                    }
                    if (this.dbms == DBMS.DB2) {
                        alterStr = alterStr + " default 0";
                    }
                    alterStr = alterStr + ";";
                    try {
                        stmt = this.conn.createStatement();
                        stmt.execute(alterStr);
                        if (primaryKeyCreated) {
                            String indexKey = "create index " + this.sqlTableName + "_ci_" + this.keyNameArray[k] + "_index on " + this.sqlTableName + "(" + this.generateEbcdicIndexKeyName(this.keyNameArray[k], this.primaryKeyColumn.equals(this.keyNameArray[k])) + ")";
                            stmt.execute(indexKey);
                        } else {
                            String primaryKeyStr = "alter table " + this.sqlTableName + " add constraint " + this.sqlTableName + "_ci_" + this.keyNameArray[k] + "_pk primary key  (" + this.generateEbcdicIndexKeyName(this.keyNameArray[k], this.primaryKeyColumn.equals(this.keyNameArray[k])) + ")";
                            stmt.execute(primaryKeyStr);
                            String indexASCIIKeyIdx = "create index " + this.sqlTableName + "_" + this.keyNameArray[k] + "_index on " + this.sqlTableName + "(" + this.keyNameArray[k] + ")";
                            stmt.execute(indexASCIIKeyIdx);
                            primaryKeyCreated = true;
                        }
                        alterStr = "alter table " + this.sqlTableName + " ";
                        continue;
                    }
                    catch (SQLException e) {
                        this.warning("addEBCDICIndexColumn", "file missing and non optional open");
                        this.closeResultSet();
                        this.setIOStatus(-35);
                        this.readState = READSTATE.ERROR;
                        VDB.LogAndThrowException(PGM + func + ": Cannot create new EBCIDIC column for '" + this.getFilteredFilename() + "' (table name " + this.sqlTableName + ") because " + e.getMessage(), false);
                        boolean bl = true;
                        return bl;
                    }
                    finally {
                        block23: {
                            try {
                                stmt.close();
                                if (!this.conn.getAutoCommit()) {
                                    this.conn.commit();
                                }
                            }
                            catch (Exception e) {
                                String why = e.getMessage();
                                if (LogSetup.IS_LOGGING) {
                                    LogSetup.LOGGER.finer(PGM + func + "SQLException=" + why);
                                }
                                if (!LOGVDB) break block23;
                                System.out.println(PGM + func + "SQLException=" + why);
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    public boolean execSQL(String sqlStmt) {
        Statement stmt = null;
        this.findConnection();
        if (this.conn == null || sqlStmt == null || sqlStmt.trim().isEmpty()) {
            return false;
        }
        if (this.conn != null) {
            try {
                stmt = this.conn.createStatement();
                stmt.execute(sqlStmt);
                stmt.close();
                try {
                    if (!this.conn.getAutoCommit()) {
                        this.conn.commit();
                    }
                    return true;
                }
                catch (SQLException e) {
                    System.out.println("SQLException=" + e.getMessage());
                }
            }
            catch (SQLException e) {
                System.out.println("SQLException=" + e.getMessage());
            }
        }
        return false;
    }

    private boolean createTable(boolean createIt) {
        String func = ".createTable(): ";
        Statement stmt = null;
        String why = "";
        if (this.conn != null && this.sqlTableName == null && createIt) {
            int j = 0;
            while (this.sqlTableName == null && j < this.candidateSqlTableNames.length) {
                String dbTable = this.candidateSqlTableNames[j++];
                try {
                    block22: {
                        String stmtStr = this.recordTo > this.blobTypeMaxSize || this.dbms == DBMS.SQLSERVER ? "create table " + dbTable + " (data " + this.blobTypeNameMax : "create table " + dbTable + " (data " + String.format(this.blobTypeName, this.recordTo * this.blobTypeMultiplier);
                        for (int k = 0; k < this.numberOfKeys; ++k) {
                            String idxFinalTypeName = this.keyArray[k] == null ? this.idxTypeName : String.format(this.idxTypeName, this.getKeySize(this.keyArray[k]));
                            stmtStr = stmtStr + ", " + this.keyNameArray[k] + " " + idxFinalTypeName;
                            if (!this.primaryKeyColumn.equals(this.keyNameArray[k]) || this.isEbcdicBinaryColumn()) continue;
                            stmtStr = stmtStr + this.notNullPrimaryKeyOption;
                        }
                        stmtStr = stmtStr + ")";
                        stmt = this.conn.createStatement();
                        stmt.execute(stmtStr);
                        stmt.close();
                        try {
                            if (!this.conn.getAutoCommit()) {
                                this.conn.commit();
                            }
                        }
                        catch (SQLException e) {
                            why = e.getMessage();
                            if (LogSetup.IS_LOGGING) {
                                LogSetup.LOGGER.finer(PGM + func + "SQLException=" + why);
                            }
                            if (!LOGVDB) break block22;
                            System.out.println(PGM + func + "SQLException=" + why);
                        }
                    }
                    this.sqlTableName = dbTable;
                    for (int k = 0; k < this.numberOfKeys; ++k) {
                        if (this.keyNameArray[k].equalsIgnoreCase(this.primaryKeyColumn)) continue;
                        String createIdxStr = "create ";
                        if (!this.isKeyDuplicates[k]) {
                            createIdxStr = createIdxStr + "unique ";
                        }
                        createIdxStr = createIdxStr + "index " + this.sqlTableName + "_aix_" + this.keyNameArray[k] + " on " + this.sqlTableName + "(" + this.keyNameArray[k] + ")";
                        stmt.close();
                        stmt = this.conn.createStatement();
                        stmt.execute(createIdxStr);
                        stmt.close();
                        try {
                            if (this.conn.getAutoCommit()) continue;
                            this.conn.commit();
                            continue;
                        }
                        catch (SQLException e) {
                            why = e.getMessage();
                            if (LogSetup.IS_LOGGING) {
                                LogSetup.LOGGER.finer(PGM + func + "SQLException=" + why);
                                continue;
                            }
                            if (!LOGVDB) continue;
                            System.out.println(PGM + func + "SQLException=" + why);
                        }
                    }
                    break;
                }
                catch (SQLException e) {
                    why = e.getMessage();
                    if (LogSetup.IS_LOGGING) {
                        LogSetup.LOGGER.finer(PGM + func + "SQLException=" + why);
                    } else if (LOGVDB) {
                        System.out.println(PGM + func + "SQLException=" + why);
                    }
                    if (this.dbms != DBMS.POSTGRESQL) continue;
                    if (LogSetup.IS_LOGGING) {
                        LogSetup.LOGGER.finer(PGM + func + "RollBack issued in Postgresql to flush previous error");
                    }
                    try {
                        this.conn.rollback();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        if (this.sqlTableName == null) {
            if (!createIt) {
                return true;
            }
            this.warning("findConnection", "file missing and non optional open");
            this.closeResultSet();
            this.setIOStatus(-35);
            this.readState = READSTATE.ERROR;
            VDB.LogAndThrowException(PGM + func + ": New SQL table for file '" + this.getFilteredFilename() + "'  could not be created for OPEN FOR OUTPUT in any DB connection because " + why, false);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addIndexToExistingIfRequired(boolean emptyIt, boolean createIt, boolean removeIt, boolean isEbcdicBinaryColumnFlagOn) {
        if (Utilities.isCurrentEnviromentCICS()) {
            return false;
        }
        String func = ".addIndexToExistingIfRequired(): ";
        Statement stmt = null;
        if (this.conn != null && this.sqlTableName != null && createIt) {
            String why;
            String alterStr = "alter table " + this.sqlTableName + " ";
            int numAdded = 0;
            Vector<SqlColumn> addedColumns = new Vector<SqlColumn>();
            Vector<SqlColumn> allSqlCols = SqlColumn.getColumns(this.sqlTableName, this.conn, this.dbms, this.driverMajorVersion, !Utilities.isCurrentEnviromentCICS());
            for (int k = 0; k < this.numberOfKeys; ++k) {
                String[] keyComponents;
                boolean found = false;
                for (SqlColumn aColumn : allSqlCols) {
                    if (!this.keyNameArray[k].equalsIgnoreCase(aColumn.getName())) continue;
                    found = true;
                    break;
                }
                if (found || isEbcdicBinaryColumnFlagOn) continue;
                if (!(emptyIt || removeIt || createIt)) {
                    this.warning("addIndexToExistingIfRequired", "can't create a new index without open OUTPUT, I-O");
                    this.closeResultSet();
                    this.setIOStatus(-39);
                    this.readState = READSTATE.ERROR;
                    VDB.LogAndThrowException(PGM + func + ":  A key column named '" + this.keyNameArray[k] + "' matching the KEY IS COBOL element '" + this.keyArray[k].getName() + "' length and record offsets was not found", false);
                    return true;
                }
                if (numAdded > 0) {
                    alterStr = alterStr + ", ";
                }
                alterStr = alterStr + "add " + this.keyNameArray[k] + " " + String.format(this.idxTypeName, this.getKeySize(this.keyArray[k]));
                int len = 0;
                int off = 0;
                for (String aKeyComponent : keyComponents = this.keyNameArray[k].substring(3).split("__")) {
                    String[] aLenOff = aKeyComponent.split("_");
                    try {
                        if (keyComponents.length == 1) {
                            off = Integer.parseInt(aLenOff[0]);
                        }
                        len += Integer.parseInt(aLenOff[1]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (len == 0) continue;
                addedColumns.add(new SqlColumn(this.keyNameArray[k], off, len, 0, k, len, String.format(this.idxTypeName, this.getKeySize(this.keyArray[k])), this.sqlTableName));
                this.keyBuffers[k] = new byte[len];
                ++numAdded;
            }
            if (numAdded > 0) {
                try {
                    stmt = this.conn.createStatement();
                    stmt.execute(alterStr);
                }
                catch (SQLException e) {
                    this.warning("addIndexToExistingIfRequired", "file missing and non optional open");
                    this.closeResultSet();
                    this.setIOStatus(-35);
                    this.readState = READSTATE.ERROR;
                    VDB.LogAndThrowException(PGM + func + ": Cannot create new alternate index for '" + this.getFilteredFilename() + "' (table name " + this.sqlTableName + ") because " + e.getMessage(), false);
                    boolean why2 = true;
                    return why2;
                }
                finally {
                    block64: {
                        try {
                            stmt.close();
                            if (!this.conn.getAutoCommit()) {
                                this.conn.commit();
                            }
                        }
                        catch (Exception e) {
                            why = e.getMessage();
                            if (LogSetup.IS_LOGGING) {
                                LogSetup.LOGGER.finer(PGM + func + "SQLException=" + why);
                            }
                            if (!LOGVDB) break block64;
                            System.out.println(PGM + func + "SQLException=" + why);
                        }
                    }
                }
                Statement stmt2 = null;
                try {
                    String selectStr = "select * from " + this.sqlTableName;
                    stmt2 = this.dbms == DBMS.SPLICE ? this.conn.createStatement() : this.conn.createStatement(1005, 1008);
                    ResultSet allRecords = stmt2.executeQuery(selectStr);
                    while (allRecords.next()) {
                        byte[] data = allRecords.getBytes("data");
                        for (SqlColumn aColumn : addedColumns) {
                            byte[] key = new byte[aColumn.getLength()];
                            for (int j = 0; j < aColumn.getComponentCount(); ++j) {
                                System.arraycopy(data, aColumn.getOffset(j), key, 0, aColumn.getLength(j));
                            }
                            allRecords.updateBytes(aColumn.getName(), key);
                        }
                        allRecords.updateRow();
                        if (this.BuffSize <= 0 || this.buffering++ % (long)this.BuffSize != 0L || this.conn.getAutoCommit()) continue;
                        this.conn.commit();
                    }
                }
                catch (SQLException e) {
                    this.warning("addIndexToExistingIfRequired", "file missing and non optional open");
                    this.closeResultSet();
                    this.setIOStatus(-35);
                    this.readState = READSTATE.ERROR;
                    VDB.LogAndThrowException(PGM + func + ": Cannot load new alternate index for '" + this.getFilteredFilename() + "' (table name " + this.sqlTableName + ") because " + e.getMessage(), false);
                    boolean allRecords = true;
                    return allRecords;
                }
                finally {
                    try {
                        stmt2.close();
                        if (this.BuffSize > 0 && !this.conn.getAutoCommit()) {
                            this.conn.commit();
                        }
                    }
                    catch (Exception data) {}
                }
                try {
                    for (SqlColumn aColumn : addedColumns) {
                        String createIdxStr = "create ";
                        for (int k = 0; k < this.numberOfKeys; ++k) {
                            if (!this.keyNameArray[k].equals(aColumn.getName())) continue;
                            if (this.isKeyDuplicates[k]) break;
                            createIdxStr = createIdxStr + "unique ";
                            break;
                        }
                        createIdxStr = createIdxStr + "index " + this.sqlTableName + "_aix_" + aColumn.getName() + " on " + this.sqlTableName + "(" + aColumn.getName() + ")";
                        stmt.close();
                        stmt = this.conn.createStatement();
                        stmt.execute(createIdxStr);
                        stmt.close();
                        try {
                            if (!this.conn.getAutoCommit()) {
                                this.conn.commit();
                            }
                        }
                        catch (Exception k) {
                            // empty catch block
                        }
                        try {
                            if (this.aixOrPathName == null) continue;
                            createIdxStr = "create view " + this.aixOrPathName + " as select " + this.topClause + " * from " + this.sqlTableName + " order by " + aColumn.getName() + " asc";
                            stmt = this.conn.createStatement();
                            stmt.execute(createIdxStr);
                            stmt.close();
                            try {
                                if (this.conn.getAutoCommit()) continue;
                                this.conn.commit();
                            }
                            catch (Exception k) {
                            }
                        }
                        catch (SQLException e) {
                            this.warning("addIndexToExistingIfRequired", "cannot define AIX or PATH name '" + this.aixOrPathName + "' as a VIEW on the base cluster TABLE");
                        }
                    }
                }
                catch (SQLException e) {
                    this.warning("addIndexToExistingIfRequired", "file missing and non optional open");
                    this.closeResultSet();
                    this.setIOStatus(-35);
                    this.readState = READSTATE.ERROR;
                    VDB.LogAndThrowException(PGM + func + ": Cannot create index for '" + this.getFilteredFilename() + "' (table name " + this.sqlTableName + ") because " + e.getMessage(), false);
                    return true;
                }
            }
            if (this.aixOrPathName != null) {
                Savepoint save = null;
                try {
                    if (this.doesTableExist(this.conn, this.aixOrPathName)) {
                        return false;
                    }
                    save = this.conn.setSavepoint();
                    String createIdxStr = "create view " + this.aixOrPathName + " as select * from " + this.sqlTableName;
                    stmt = this.conn.createStatement();
                    stmt.execute(createIdxStr);
                    stmt.close();
                    try {
                        if (!this.conn.getAutoCommit()) {
                            this.conn.commit();
                        }
                    }
                    catch (Exception e) {
                        why = e.getMessage();
                        if (LogSetup.IS_LOGGING) {
                            LogSetup.LOGGER.finer(PGM + func + "SQLException=" + why);
                        } else if (LOGVDB) {
                            System.out.println(PGM + func + "SQLException=" + why);
                        }
                    }
                }
                catch (SQLException e) {
                    if (save != null) {
                        try {
                            this.conn.rollback(save);
                        }
                        catch (SQLException e1) {
                            this.warning("The rollback to savepoint is not successful", e1.getMessage());
                        }
                    }
                    this.warning("addIndexToExistingIfRequired", "cannot define PATH name '" + this.aixOrPathName + "' as a VIEW on the VIEW created for the alternate index (" + e.getMessage() + ")");
                }
            }
        }
        return false;
    }

    private boolean doesTableExist(Connection connection, String actualTableName) throws SQLException {
        try (ResultSet resultSet = connection.getMetaData().getTables(null, null, actualTableName, null);){
            boolean bl = resultSet.next();
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void emptyOrRemoveTableIfRequired(boolean emptyIt, boolean removeIt, boolean isEbcdicBinaryColumnFlagOn) {
        String func = ".emptyOrRemoveTableIfRequired(): ";
        if (this.conn != null && this.sqlTableName != null && (removeIt || emptyIt)) {
            String why;
            try (Statement stmt = this.conn.createStatement();){
                if (removeIt) {
                    stmt.execute("drop table " + this.sqlTableName + this.cascadeOption);
                    this.sqlTableName = null;
                } else if (emptyIt) {
                    if (isEbcdicBinaryColumnFlagOn && !this.doesEbcdicColumnExist(this.primaryKeyColumn)) {
                        stmt.execute("drop table " + this.sqlTableName + this.cascadeOption);
                    } else {
                        this.truncateTable(stmt);
                    }
                }
            }
            catch (SQLException e) {
                why = e.getMessage();
                if (LogSetup.IS_LOGGING) {
                    LogSetup.LOGGER.finer(PGM + func + "SQLException=" + why);
                } else if (LOGVDB) {
                    System.out.println(PGM + func + "SQLException=" + why);
                }
            }
            finally {
                block35: {
                    try {
                        if (!this.conn.getAutoCommit()) {
                            this.conn.commit();
                        }
                    }
                    catch (SQLException e) {
                        why = e.getMessage();
                        if (LogSetup.IS_LOGGING) {
                            LogSetup.LOGGER.finer(PGM + func + "SQLException=" + why);
                        }
                        if (!LOGVDB) break block35;
                        System.out.println(PGM + func + "SQLException=" + why);
                    }
                }
            }
        }
    }

    private void truncateTable(Statement stmt) throws SQLException {
        String query = "truncate table " + this.sqlTableName;
        String driver = System.getProperty("dcb.db.driver");
        if (driver != null && driver.contains("db2")) {
            query = query + " immediate";
        }
        stmt.execute(query);
    }

    private int getKeySize(Variable key) {
        return key.getSize();
    }

    public void closeResultSet() {
        String func = ".closeResultSet(): ";
        if (this.resultSet != null) {
            block5: {
                try {
                    if (!this.resultSet.isClosed()) {
                        this.resultSet.close();
                    }
                }
                catch (SQLException e) {
                    String why = e.getMessage();
                    if (LogSetup.IS_LOGGING) {
                        LogSetup.LOGGER.finer(PGM + func + "SQLException=" + why);
                    }
                    if (!LOGVDB) break block5;
                    System.out.println(PGM + func + "SQLException=" + why);
                }
            }
            this.resultSet = null;
        }
    }

    private boolean paginationNextPrev(boolean doNext) throws SQLException {
        boolean isDisableCursorsLocal;
        String func = ".paginationNextPrev(): ";
        boolean moreData = this.resultSet != null;
        boolean bl = isDisableCursorsLocal = this.isDisableCursorCompatible && DISABLE_SQLCURSORS;
        if (this.dbms == DBMS.SQLSERVER && isDisableCursorsLocal) {
            if (moreData) {
                if (doNext) {
                    if (this.direction < 0) {
                        int n = this.startNextPrev(this.keyArray[this.currentKeyNumber], 1);
                    }
                    moreData = this.resultSet.next();
                } else {
                    if (this.direction > 0) {
                        int fs = this.startNextPrev(this.keyArray[this.currentKeyNumber], -1);
                        moreData = this.resultSet.next();
                    }
                    moreData = this.resultSet.next();
                }
            }
            if (!moreData && this.paginationLimit > 0) {
                if (this.originalKey instanceof byte[]) {
                    byte[] bytesToUse = null;
                    bytesToUse = this.endPageKeyBytes != null ? this.endPageKeyBytes : (this.lastRowKeyBytes != null ? this.lastRowKeyBytes : (this.originalKeyEbcidic != null ? this.originalKeyEbcidic : (byte[])this.originalKey));
                    this.browseStmt.setBytes(1, bytesToUse);
                    if (this.isUsingAlternateKey) {
                        if (Arrays.equals(this.prevKeyBytes, this.endPageKeyBytes)) {
                            this.browseStmt.setBytes(2, this.endPagePrimaryKeyBytes);
                        } else {
                            this.browseStmt.setBytes(2, new byte[this.keyArray[0].getBytes().length]);
                        }
                    }
                } else if (this.originalKey instanceof Integer) {
                    if (this.endPageInt == null) {
                        this.endPageKeyBytes = null;
                        this.endPagePrimaryKeyBytes = null;
                        this.prevKeyBytes = null;
                        moreData = false;
                        return moreData;
                    }
                    this.browseStmt.setInt(1, this.endPageInt);
                }
                this.resultSet = this.browseStmt.executeQuery();
                this.endPageKeyBytes = null;
                this.endPagePrimaryKeyBytes = null;
                this.lastRowKeyBytes = null;
                this.prevKeyBytes = null;
                this.endPageInt = null;
                if (doNext) {
                    if ("GE".equals(this.operator) || "LE".equals(this.operator)) {
                        moreData = this.resultSet.next();
                        if (moreData) {
                            moreData = this.resultSet.next();
                        }
                    } else {
                        moreData = this.resultSet.next();
                    }
                } else {
                    moreData = this.resultSet.next();
                }
            }
            if (moreData & !this.isUsingAlternateKey) {
                this.lastRowKeyBytes = this.resultSet.getBytes(this.keyNameArray[this.currentKeyNumber]);
            }
            if (this.paginationLimit > 0) {
                if (this.resultSet.getRow() == this.paginationLimit) {
                    if (this.originalKey instanceof byte[]) {
                        this.endPageKeyBytes = this.resultSet.getBytes(this.keyNameArray[this.currentKeyNumber]);
                        if (this.isUsingAlternateKey) {
                            this.endPagePrimaryKeyBytes = this.resultSet.getBytes(this.keyNameArray[0]);
                            if (this.paginationLimit == 2) {
                                System.err.println("warning-pagination limit too low, may result in dropped records");
                            }
                        }
                    } else if (this.originalKey instanceof Integer) {
                        this.endPageInt = this.resultSet.getInt(this.keyNameArray[this.currentKeyNumber]);
                    }
                } else if (this.isUsingAlternateKey) {
                    this.prevKeyBytes = this.resultSet.getBytes(this.keyNameArray[this.currentKeyNumber]);
                }
            }
            this.direction = doNext ? 1 : -1;
        } else {
            if (moreData) {
                moreData = doNext ? this.resultSet.next() : this.resultSet.previous();
            }
            if (!moreData && this.paginationLimit > 0) {
                if (doNext) {
                    this.paginationOffset += this.paginationLimit;
                } else {
                    this.paginationOffset -= this.paginationLimit;
                    if (this.paginationOffset < 0) {
                        return false;
                    }
                }
                if (this.originalKey instanceof byte[]) {
                    if (this.originalKeyEbcidic != null) {
                        this.browseStmt.setBytes(1, this.originalKeyEbcidic);
                    } else {
                        this.browseStmt.setBytes(1, (byte[])this.originalKey);
                    }
                } else if (this.originalKey instanceof Integer) {
                    this.browseStmt.setInt(1, (Integer)this.originalKey);
                }
                this.dbms.SetLimitandOffset(this.browseStmt, this.paginationLimit, this.paginationOffset);
                this.resultSet = this.browseStmt.executeQuery();
                moreData = doNext ? this.resultSet.next() : this.resultSet.previous();
            }
        }
        return moreData;
    }

    private boolean retrieveOneRecord(boolean forward, WhichRecord whichRecord) throws SQLException {
        if (this.paginationNextPrev(forward)) {
            whichRecord.getRecordData(this);
            switch (this.fileType) {
                case INDEXED: {
                    whichRecord.getPrimeKey(this);
                    if (this.currentKeyNumber <= 0) break;
                    whichRecord.getAlternateKey(this);
                    break;
                }
                case RELATIVE: {
                    whichRecord.getRelativePrimeKey(this);
                    break;
                }
                case SEQUENTIAL: {
                    this.primeKey1 = null;
                    break;
                }
                default: {
                    this.assertVDB(false, "filetype unknown : " + (Object)((Object)this.fileType));
                }
            }
            return true;
        }
        whichRecord.resetRecordValues(this);
        return false;
    }

    public int advanceAndRetrieveData(boolean getNext) {
        return this.advanceAndRetrieveDataImpl(getNext, false);
    }

    public int advanceAndRetrieveData(boolean getNext, boolean genericFromKeyAllowed) {
        return this.advanceAndRetrieveDataImpl(getNext, genericFromKeyAllowed);
    }

    private int advanceAndRetrieveDataImpl(boolean getNext, boolean genericFromKeyAllowed) {
        String func = ".advanceAndRectrieveData(): ";
        try {
            Integer fs1;
            if (getNext ? (fs1 = this.getNextData()) != null : (fs1 = this.getPrevData()) != null) {
                return fs1;
            }
        }
        catch (SQLException e) {
            this.readState = READSTATE.ERROR;
            this.closeResultSet();
            VDB.LogAndThrowException(PGM + ".advanceAndRectrieveData(): " + ": Cannot retrieve data into variable for '" + this.getFilteredFilename() + "' (table name " + this.sqlTableName + ") because " + e.getMessage(), true);
            return -90;
        }
        if (this.record1 == null) {
            if (this.record0 == null && (this.accessMode == ACCESSMODE.RANDOM || this.accessMode == ACCESSMODE.DYNAMIC && this.isReadRandom)) {
                this.setIOStatus(-23);
                this.readState = READSTATE.ERROR;
                this.warning("advanceAndRetrieveData", "invalid key, random record missing");
                return -23;
            }
            this.setIOStatus(-10);
            this.readState = READSTATE.ENDFILE;
            return -10;
        }
        if (this.readState == READSTATE.ERROR) {
            return -90;
        }
        if (this.generic && !genericFromKeyAllowed) {
            int len = ((byte[])this.originalKey).length;
            byte[] tmp = new byte[len];
            System.arraycopy(this.record1, this.keyArray[this.currentKeyNumber].getRecordPosition(), tmp, 0, len);
            if (!VDB.isEqual(this.originalKey, tmp)) {
                this.record2 = null;
                this.record1 = null;
                this.record0 = null;
                this.primeKey2 = null;
                this.primeKey1 = null;
                this.altKey2 = null;
                this.altKey1 = null;
                this.readState = READSTATE.ENDFILE;
                this.setIOStatus(-23);
                return -23;
            }
        }
        if (this.currentKeyNumber > 0 && VDB.isEqual(this.altKey1, this.altKey2)) {
            this.setIOStatus(-2);
            return -2;
        }
        this.setIOStatus(0);
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Integer getPrevData() throws SQLException {
        switch (this.readState) {
            case START_ASC: {
                this.readState = READSTATE.ERROR;
                this.assertVDB(false, "START_ASC state is entered into by VDBIndexedFile.start() before we know which direction from READ NEXT");
                return null;
            }
            case AFTER_START_ASC: {
                if (this.operator.equals("GE") || this.operator.equals("EQ")) {
                    if (this.originalKey instanceof byte[]) {
                        this.keyArray[this.currentKeyNumber].fromByteArray((byte[])this.originalKey);
                    } else {
                        this.keyArray[this.currentKeyNumber].fromInt((Integer)this.originalKey);
                    }
                    int fs = this.startNextPrev(this.keyArray[this.currentKeyNumber], -1);
                    if (fs <= -10) {
                        return fs;
                    }
                    fs = this.advanceAndRetrieveData(true);
                    if (fs < -10) return fs;
                    this.readState = READSTATE.READPREV_DESC;
                    return fs;
                }
                if (!this.operator.equals("GT")) {
                    this.readState = READSTATE.READNEXT_ASC;
                    return null;
                }
                if (this.record1 == null) {
                    this.setIOStatus(-10);
                    this.readState = READSTATE.ENDFILE;
                    return -10;
                }
                if (this.currentKeyNumber > 0) {
                    this.keyArray[this.currentKeyNumber].fromByteArray((byte[])this.altKey1);
                } else if (this.primeKey1 instanceof byte[]) {
                    this.keyArray[this.currentKeyNumber].fromByteArray((byte[])this.primeKey1);
                } else {
                    this.keyArray[this.currentKeyNumber].fromInt((Integer)this.primeKey1);
                }
                int fs = this.startNextPrev(this.keyArray[this.currentKeyNumber], -1);
                if (fs <= -10) {
                    return fs;
                }
                fs = this.advanceAndRetrieveData(true);
                if (fs < -10) return fs;
                this.readState = READSTATE.READPREV_DESC;
                return fs;
            }
            case START_DESC: {
                this.readState = READSTATE.ERROR;
                this.assertVDB(false, "START_DESC state is entered into by VDBIndexedFile.start() before we know which direction from READ NEXT");
                return null;
            }
            case AFTER_START_DESC: {
                this.readState = READSTATE.READPREV_DESC;
                return null;
            }
            case OPEN: {
                this.currentKeyNumber = 0;
                this.keyArray[this.currentKeyNumber].moveLowValues();
                int rc = this.startNextPrev(this.keyArray[this.currentKeyNumber], 1);
                if (rc < -2) {
                    return rc;
                }
                rc = this.advanceAndRetrieveData(true);
                if (rc >= -2) {
                    this.readState = READSTATE.READNEXT_ASC;
                    return rc;
                }
                this.readState = READSTATE.ERROR;
                return rc;
            }
            case READNEXT_ASC: {
                this.retrieveOneRecord(false, WhichRecord.CURRENT);
                this.retrieveOneRecord(false, WhichRecord.CURRENT);
                if (this.record1 == null) {
                    if (this.originalKey instanceof byte[]) {
                        this.keyArray[this.currentKeyNumber].fromByteArray((byte[])this.originalKey);
                    } else {
                        this.keyArray[this.currentKeyNumber].fromInt((Integer)this.originalKey);
                    }
                    int fs = this.startNextPrev(this.keyArray[this.currentKeyNumber], -2);
                    if (fs < -2) return fs;
                    if (!this.retrieveOneRecord(true, WhichRecord.CURRENT)) {
                        this.setIOStatus(-10);
                        this.readState = READSTATE.ENDFILE;
                        return -10;
                    }
                    this.retrieveOneRecord(true, WhichRecord.NEXT);
                    this.readState = READSTATE.READPREV_DESC;
                } else {
                    this.retrieveOneRecord(false, WhichRecord.NEXT);
                    this.readState = READSTATE.READPREV_ASC;
                }
                this.record0 = null;
                return null;
            }
            case READNEXT_DESC: {
                int fs;
                this.retrieveOneRecord(false, WhichRecord.CURRENT);
                if (this.record1 != null) {
                    this.retrieveOneRecord(false, WhichRecord.NEXT);
                    this.readState = READSTATE.READPREV_DESC;
                    return null;
                }
                this.record2 = null;
                this.primeKey2 = null;
                this.altKey2 = null;
                if (this.originalKey instanceof byte[]) {
                    this.keyArray[this.currentKeyNumber].fromByteArray((byte[])this.originalKey);
                } else {
                    this.keyArray[this.currentKeyNumber].fromInt((Integer)this.originalKey);
                }
                if (this.operator.equals("LE")) {
                    fs = this.startNextPrev(this.keyArray[this.currentKeyNumber], -2);
                } else if (this.operator.equals("LT")) {
                    fs = this.startNextPrev(this.keyArray[this.currentKeyNumber], -1);
                } else {
                    this.assertVDB(false, "something wrong with our state machine " + this.operator);
                    fs = -90;
                }
                if (fs < -2) {
                    this.setIOStatus(fs);
                    this.readState = READSTATE.ERROR;
                    return fs;
                }
                if (this.retrieveOneRecord(true, WhichRecord.CURRENT)) {
                    this.retrieveOneRecord(true, WhichRecord.NEXT);
                    this.readState = READSTATE.READNEXT_DESC;
                    return null;
                }
                this.readState = READSTATE.ENDFILE;
                return null;
            }
            case READPREV_ASC: {
                int fs;
                this.record0 = this.record1;
                this.record1 = this.record2;
                this.primeKey1 = this.primeKey2;
                this.altKey1 = this.altKey2;
                if (this.record1 != null) {
                    this.retrieveOneRecord(false, WhichRecord.NEXT);
                    this.readState = READSTATE.READPREV_ASC;
                    return null;
                }
                if (this.originalKey instanceof byte[]) {
                    this.keyArray[this.currentKeyNumber].fromByteArray((byte[])this.originalKey);
                } else {
                    this.keyArray[this.currentKeyNumber].fromInt((Integer)this.originalKey);
                }
                if (this.operator.equals("GE")) {
                    fs = this.startNextPrev(this.keyArray[this.currentKeyNumber], -2);
                } else if (this.operator.equals("GT")) {
                    fs = this.startNextPrev(this.keyArray[this.currentKeyNumber], -1);
                } else {
                    this.assertVDB(false, "something wrong with our state machine" + this.operator);
                    fs = -90;
                }
                if (fs < -2) {
                    this.setIOStatus(fs);
                    this.readState = READSTATE.ERROR;
                    return fs;
                }
                if (this.retrieveOneRecord(true, WhichRecord.CURRENT)) {
                    this.retrieveOneRecord(true, WhichRecord.NEXT);
                    this.readState = READSTATE.READPREV_DESC;
                    return null;
                }
                this.readState = READSTATE.ENDFILE;
                return null;
            }
            case READPREV_DESC: {
                this.record0 = this.record1;
                this.record1 = this.record2;
                this.primeKey1 = this.primeKey2;
                this.altKey1 = this.altKey2;
                if (this.record1 != null) {
                    this.retrieveOneRecord(true, WhichRecord.NEXT);
                    this.readState = READSTATE.READPREV_DESC;
                    return null;
                }
                this.readState = READSTATE.ENDFILE;
                return null;
            }
            case READRAND: {
                this.assertVDB(false, "READRAND should always be called with getNext==true " + (Object)((Object)this.readState));
                return null;
            }
            case ENDFILE: {
                this.setIOStatus(-10);
                this.readState = READSTATE.ENDFILE;
                return -10;
            }
            case CLOSED: {
                this.setIOStatus(-42);
                this.readState = READSTATE.ERROR;
                this.warning("advanceAndRetrieveData", "invalid operation, file already closed");
                return -42;
            }
            case ERROR: {
                this.setIOStatus(-90);
                this.readState = READSTATE.ERROR;
                return -90;
            }
        }
        this.assertVDB(false, "other states are unexpected " + (Object)((Object)this.readState));
        return -90;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Integer getNextData() throws SQLException {
        switch (this.readState) {
            case START_ASC: {
                this.prepareStartForAsc();
                return null;
            }
            case AFTER_START_ASC: {
                this.readState = READSTATE.READNEXT_ASC;
                return null;
            }
            case START_DESC: {
                this.prepareStartForDesc();
                return null;
            }
            case AFTER_START_DESC: {
                if (this.operator.equals("LE") || this.operator.equals("EQ")) {
                    if (this.originalKey instanceof byte[]) {
                        this.keyArray[this.currentKeyNumber].fromByteArray((byte[])this.originalKey);
                    } else {
                        this.keyArray[this.currentKeyNumber].fromInt((Integer)this.originalKey);
                    }
                    int fs = this.startNextPrev(this.keyArray[this.currentKeyNumber], 1);
                    if (fs <= -10) {
                        return fs;
                    }
                    fs = this.advanceAndRetrieveData(true);
                    if (fs < -10) return null;
                    this.readState = READSTATE.READNEXT_ASC;
                    return null;
                }
                if (!this.operator.equals("LT")) {
                    this.readState = READSTATE.READNEXT_DESC;
                    return null;
                }
                if (this.record1 == null) {
                    this.setIOStatus(-10);
                    this.readState = READSTATE.ENDFILE;
                    return -10;
                }
                if (this.currentKeyNumber > 0) {
                    this.keyArray[this.currentKeyNumber].fromByteArray((byte[])this.altKey1);
                } else if (this.primeKey1 instanceof byte[]) {
                    this.keyArray[this.currentKeyNumber].fromByteArray((byte[])this.primeKey1);
                } else {
                    this.keyArray[this.currentKeyNumber].fromInt((Integer)this.primeKey1);
                }
                int fs = this.startNextPrev(this.keyArray[this.currentKeyNumber], 1);
                if (fs <= -10) {
                    return fs;
                }
                fs = this.advanceAndRetrieveData(true);
                if (fs < -10) return null;
                this.readState = READSTATE.READNEXT_ASC;
                return null;
            }
            case OPEN: {
                this.currentKeyNumber = 0;
                if (!this.resultSetInvalidated) {
                    this.keyArray[this.currentKeyNumber].moveLowValues();
                } else {
                    this.resultSetInvalidated = false;
                }
                int rc = this.startNextPrev(this.keyArray[this.currentKeyNumber], 1);
                if (rc < -2) {
                    return rc;
                }
                rc = this.advanceAndRetrieveData(true);
                if (rc >= -2) {
                    this.readState = READSTATE.READNEXT_ASC;
                    return rc;
                }
                this.readState = READSTATE.ERROR;
                return rc;
            }
            case READRAND: {
                this.record0 = this.record1;
                this.record1 = this.record2;
                this.primeKey1 = this.primeKey2;
                this.altKey1 = this.altKey2;
                if (this.record1 != null) {
                    this.retrieveOneRecord(true, WhichRecord.NEXT);
                    this.readState = READSTATE.READNEXT_ASC;
                    return null;
                }
                this.record2 = null;
                this.primeKey2 = null;
                this.altKey2 = null;
                if (this.originalKey instanceof byte[]) {
                    this.keyArray[this.currentKeyNumber].fromByteArray((byte[])this.originalKey);
                } else if (this.originalKey instanceof Integer) {
                    this.keyArray[this.currentKeyNumber].fromInt((Integer)this.originalKey);
                }
                byte[] tmp = this.record0;
                int fs = this.operator.equals("EQ") || this.operator.equals("LE") ? this.startNextPrev(this.keyArray[this.currentKeyNumber], 2) : (this.operator.equals("LT") ? this.startNextPrev(this.keyArray[this.currentKeyNumber], 1) : -10);
                this.record0 = tmp;
                if (fs < -2) {
                    this.setIOStatus(fs);
                    this.readState = READSTATE.ERROR;
                    return fs;
                }
                if (this.retrieveOneRecord(true, WhichRecord.CURRENT)) {
                    this.retrieveOneRecord(true, WhichRecord.NEXT);
                    this.readState = READSTATE.READNEXT_ASC;
                    return null;
                }
                this.readState = READSTATE.ENDFILE;
                return null;
            }
            case READNEXT_ASC: {
                this.record0 = this.record1;
                this.record1 = this.record2;
                this.primeKey1 = this.primeKey2;
                this.altKey1 = this.altKey2;
                if (this.record1 != null) {
                    this.retrieveOneRecord(true, WhichRecord.NEXT);
                    this.readState = READSTATE.READNEXT_ASC;
                    return null;
                }
                this.record2 = null;
                this.primeKey2 = null;
                this.altKey2 = null;
                this.readState = READSTATE.ENDFILE;
                return null;
            }
            case READNEXT_DESC: {
                int fs;
                this.record0 = this.record1;
                this.record1 = this.record2;
                this.primeKey1 = this.primeKey2;
                this.altKey1 = this.altKey2;
                if (this.record1 != null) {
                    this.retrieveOneRecord(false, WhichRecord.NEXT);
                    this.readState = READSTATE.READNEXT_DESC;
                    return null;
                }
                this.record2 = null;
                this.primeKey2 = null;
                this.altKey2 = null;
                if (this.originalKey instanceof byte[]) {
                    this.keyArray[this.currentKeyNumber].fromByteArray((byte[])this.originalKey);
                } else if (this.originalKey instanceof Integer) {
                    this.keyArray[this.currentKeyNumber].fromInt((Integer)this.originalKey);
                }
                if (this.operator.equals("LE")) {
                    fs = this.startNextPrev(this.keyArray[this.currentKeyNumber], -2);
                } else if (this.operator.equals("LT")) {
                    fs = this.startNextPrev(this.keyArray[this.currentKeyNumber], -1);
                } else {
                    this.assertVDB(false, "something wrong with our state machine " + this.operator);
                    fs = -90;
                }
                if (fs < -2) {
                    this.setIOStatus(fs);
                    this.readState = READSTATE.ERROR;
                    return fs;
                }
                if (this.retrieveOneRecord(true, WhichRecord.CURRENT)) {
                    this.retrieveOneRecord(true, WhichRecord.NEXT);
                    this.readState = READSTATE.READNEXT_DESC;
                    return null;
                }
                this.readState = READSTATE.ENDFILE;
                return null;
            }
            case READPREV_ASC: {
                this.retrieveOneRecord(true, WhichRecord.CURRENT);
                this.retrieveOneRecord(true, WhichRecord.CURRENT);
                if (this.record1 == null) {
                    if (this.originalKey instanceof byte[]) {
                        this.keyArray[this.currentKeyNumber].fromByteArray((byte[])this.originalKey);
                    } else {
                        this.keyArray[this.currentKeyNumber].fromInt((Integer)this.originalKey);
                    }
                    int fs = this.startNextPrev(this.keyArray[this.currentKeyNumber], 2);
                    if (fs < -2) return fs;
                    if (!this.retrieveOneRecord(true, WhichRecord.CURRENT)) {
                        this.setIOStatus(-10);
                        this.readState = READSTATE.ENDFILE;
                        return -10;
                    }
                    this.retrieveOneRecord(true, WhichRecord.NEXT);
                    this.readState = READSTATE.READNEXT_ASC;
                } else {
                    this.retrieveOneRecord(true, WhichRecord.NEXT);
                    this.readState = READSTATE.READNEXT_ASC;
                }
                this.record0 = null;
                return null;
            }
            case READPREV_DESC: {
                int fs;
                this.record0 = this.record1;
                this.record1 = this.record2;
                this.primeKey1 = this.primeKey2;
                this.altKey1 = this.altKey2;
                if (this.record1 != null) {
                    this.retrieveOneRecord(false, WhichRecord.NEXT);
                    this.readState = READSTATE.READPREV_DESC;
                    return null;
                }
                if (this.originalKey instanceof byte[]) {
                    this.keyArray[this.currentKeyNumber].fromByteArray((byte[])this.originalKey);
                } else {
                    this.keyArray[this.currentKeyNumber].fromInt((Integer)this.originalKey);
                }
                if (this.operator.equals("LE")) {
                    fs = this.startNextPrev(this.keyArray[this.currentKeyNumber], 2);
                } else if (this.operator.equals("LT")) {
                    fs = this.startNextPrev(this.keyArray[this.currentKeyNumber], 1);
                } else {
                    this.assertVDB(false, "something wrong with our state machine" + this.operator);
                    fs = -90;
                }
                if (fs < -2) {
                    this.setIOStatus(fs);
                    this.readState = READSTATE.ERROR;
                    return fs;
                }
                if (this.retrieveOneRecord(true, WhichRecord.CURRENT)) {
                    this.retrieveOneRecord(true, WhichRecord.NEXT);
                    this.readState = READSTATE.READPREV_DESC;
                    return null;
                }
                this.readState = READSTATE.ENDFILE;
                return null;
            }
            case ENDFILE: {
                this.setIOStatus(-10);
                this.readState = READSTATE.ENDFILE;
                return -10;
            }
            case CLOSED: {
                this.setIOStatus(-42);
                this.readState = READSTATE.ERROR;
                this.warning("advanceAndRetrieveData", "invalid operation, file already closed");
                return -42;
            }
            case ERROR: {
                this.setIOStatus(-90);
                this.readState = READSTATE.ERROR;
                return -90;
            }
        }
        this.assertVDB(false, " other states are unexpected " + this.readState.toString());
        return -90;
    }

    private void prepareStartForAsc() throws SQLException {
        if (this.retrieveOneRecord(true, WhichRecord.CURRENT) && (!this.operator.equals("EQ") || this.isKeyDuplicates[this.currentKeyNumber])) {
            this.retrieveOneRecord(true, WhichRecord.NEXT);
        }
        this.record0 = null;
        this.readState = READSTATE.AFTER_START_ASC;
    }

    private void prepareStartForDesc() throws SQLException {
        if (this.retrieveOneRecord(true, WhichRecord.CURRENT) && (!this.operator.equals("EQ") || this.isKeyDuplicates[this.currentKeyNumber])) {
            this.retrieveOneRecord(true, WhichRecord.NEXT);
        }
        this.record0 = null;
        this.readState = READSTATE.AFTER_START_DESC;
    }

    private int evaluateConstantForOperator(String operatorForNextPrev) {
        if (operatorForNextPrev.equals("LE")) {
            return -1;
        }
        if (operatorForNextPrev.equals("LT")) {
            return -2;
        }
        if (operatorForNextPrev.equals("LS")) {
            return -2;
        }
        if (operatorForNextPrev.equals("LE")) {
            return -1;
        }
        if (operatorForNextPrev.equals("EQ")) {
            return 0;
        }
        if (operatorForNextPrev.equals("GE")) {
            return 1;
        }
        if (operatorForNextPrev.equals("GR")) {
            return 2;
        }
        if (operatorForNextPrev.equals("GT")) {
            return 2;
        }
        if (operatorForNextPrev.equals("LK")) {
            return 3;
        }
        this.assertVDB(false, "something wrong with our state machine " + operatorForNextPrev);
        return -90;
    }

    private byte[] getKeyData(Variable key) {
        if (key instanceof VariableList) {
            Variable[] keyList = ((VariableList)key).getList();
            int len = 0;
            for (Variable aKeyComponent : keyList) {
                len += aKeyComponent.getMinimumSize();
            }
            byte[] ret = new byte[len];
            len = 0;
            for (Variable aKeyComponent : keyList) {
                System.arraycopy(aKeyComponent.toByteArray(), 0, ret, len, aKeyComponent.getMinimumSize());
                len += aKeyComponent.getMinimumSize();
            }
            return ret;
        }
        if (key.getSize() <= key.getMinimumSize()) {
            return key.toByteArray();
        }
        byte[] ret = new byte[key.getMinimumSize()];
        System.arraycopy(key.toByteArray(), 0, ret, 0, ret.length);
        return ret;
    }

    private void extractRecordIntoKey(Variable key, byte[] record) {
        if (key instanceof VariableList) {
            Variable[] keyList;
            for (Variable aKeyComponent : keyList = ((VariableList)key).getList()) {
                byte[] ret = new byte[aKeyComponent.length()];
                System.arraycopy(record, aKeyComponent.getRecordPosition(), ret, 0, aKeyComponent.length());
                aKeyComponent.fromByteArray(ret);
            }
        } else {
            byte[] ret = new byte[key.length()];
            System.arraycopy(record, key.getRecordPosition(), ret, 0, key.length());
            key.fromByteArray(ret);
        }
    }

    public void updateDeclaredKeys(Variable externalKey) {
        switch (this.fileType) {
            case INDEXED: {
                break;
            }
            case RELATIVE: {
                this.keyArray[0].fromInt((Integer)this.primeKey1);
                break;
            }
            case SEQUENTIAL: {
                break;
            }
            default: {
                this.assertVDB(false, "unknonw filetype " + (Object)((Object)this.fileType));
            }
        }
        if (externalKey != null && externalKey != this.keyArray[this.currentKeyNumber]) {
            this.extractRecordIntoKey(externalKey, this.record1);
        }
    }

    public void updateIntoVarAndLen(Variable intoVar) {
        intoVar.fromByteArray(this.record1);
        if (this.dependingOn != null) {
            this.dependingOn.fromInt(this.record1.length);
        }
    }

    public String getIdxName(Variable recordKey) {
        this.compactCompositeKeyName = "";
        if (recordKey != null) {
            Variable[] list = null;
            String name = "idx";
            if (recordKey instanceof VariableList) {
                for (Variable aKeyPiece : list = ((VariableList)recordKey).getList()) {
                    if (name.length() > 3) {
                        name = name + "__";
                    }
                    name = name + aKeyPiece.getRecordPosition() + "_" + aKeyPiece.getSize();
                }
            } else {
                if (this.conn != null && this.columns != null) {
                    for (SqlColumn sqlcol : this.columns) {
                        if (!sqlcol.getName().toLowerCase().startsWith("ci_") || sqlcol.getOffset(0) != recordKey.getRecordPosition() || sqlcol.getLength() != recordKey.getSize()) continue;
                        this.compactCompositeKeyName = name = name + recordKey.getRecordPosition() + "_" + recordKey.getSize();
                        return sqlcol.getName();
                    }
                    for (SqlColumn sqlcol : this.columns) {
                        if (!sqlcol.getName().toLowerCase().startsWith("idx") || sqlcol.getOffset(0) != recordKey.getRecordPosition() || sqlcol.getLength() != recordKey.getSize()) continue;
                        this.compactCompositeKeyName = name = name + recordKey.getRecordPosition() + "_" + recordKey.getSize();
                        return sqlcol.getName();
                    }
                }
                name = name + recordKey.getRecordPosition() + "_" + recordKey.getSize();
            }
            return name;
        }
        return null;
    }

    private String closestIdxName(Variable keyIs) {
        if (this.fileType == FILETYPE.RELATIVE) {
            this.currentKeyNumber = 0;
            return "rel";
        }
        if (this.fileType == FILETYPE.SEQUENTIAL) {
            this.currentKeyNumber = 0;
            return "seq";
        }
        String keyName = this.getIdxName(keyIs);
        if (!this.compactCompositeKeyName.isEmpty() && this.primaryKeyColumn.equalsIgnoreCase(this.compactCompositeKeyName)) {
            this.primaryKeyColumn = keyName;
        }
        boolean keyExists = false;
        for (int i = 0; i < this.numberOfKeys; ++i) {
            if (!this.keyNameArray[i].equalsIgnoreCase(keyName) && !this.keyArray[i].isPreferredKey() && !this.keyNameArray[i].equalsIgnoreCase(this.compactCompositeKeyName)) continue;
            if (this.keyNameArray[i].equalsIgnoreCase(this.compactCompositeKeyName)) {
                this.keyNameArray[i] = keyName;
            }
            keyExists = true;
            this.currentKeyNumber = i;
            this.keyBuffers[i] = this.getKeyData(keyIs);
            break;
        }
        if (!keyExists) {
            keyName = keyName.split("_")[0];
            int closestTo = keyIs.getSize();
            int delta = 10000000;
            for (int i = 0; i < this.numberOfKeys; ++i) {
                if (!this.keyNameArray[i].startsWith(keyName) || this.keyArray[i].getSize() < closestTo || this.keyArray[i].getSize() - closestTo >= delta) continue;
                keyExists = true;
                this.currentKeyNumber = i;
                this.keyBuffers[i] = this.getKeyData(keyIs);
                delta = this.keyArray[i].getSize() - closestTo;
            }
        }
        if (!keyExists) {
            String allKeyNames = "";
            for (int i = 0; i < this.numberOfKeys; ++i) {
                if (!allKeyNames.isEmpty()) {
                    allKeyNames = allKeyNames + "', '";
                }
                allKeyNames = allKeyNames + this.keyArray[i].getName();
                allKeyNames = allKeyNames + "' (VDB index column '" + this.keyNameArray[i] + "')";
            }
            this.closeResultSet();
            VDB.LogAndThrowException(PGM + ": READ KEY is invalid. KEY element on READ statement is '" + keyIs.getName() + "' (VDB index column '" + keyName + "'). Valid key names are '" + allKeyNames + "'. Either the VDB file was created in a different program that did not define all the keys or the application is using a key variable not defined in the file descriptor.", true);
            return null;
        }
        return this.keyNameArray[this.currentKeyNumber];
    }

    private void setSSAParameterValues(PreparedStatement prepStmt, String func) throws SQLException {
        Method method;
        Class<?> klazz;
        Object obj = null;
        if (dfsrrc00Class != null && dfsrrc00GetInstanceMapMethod != null) {
            klazz = dfsrrc00Class;
            method = dfsrrc00GetInstanceMapMethod;
            try {
                obj = method.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
                e.printStackTrace(System.err);
            }
        } else {
            try {
                klazz = Class.forName("com.heirloomcomputing.eims.util.DFSRRC00");
                method = klazz.getDeclaredMethod("getInstanceMap", new Class[0]);
                obj = method.invoke(null, new Object[0]);
                dfsrrc00Class = klazz;
                dfsrrc00GetInstanceMapMethod = method;
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace(System.err);
            }
        }
        Object lstObj = null;
        Object valObj = null;
        Object dbdObj = null;
        Object ssaObj = null;
        if (obj != null) {
            if (obj instanceof HashMap) {
                this.imsObjTbl = (HashMap)obj;
            }
            String tid = String.valueOf(Thread.currentThread().getId());
            lstObj = this.imsObjTbl.get("LST_" + tid);
            valObj = this.imsObjTbl.get("VAL_" + tid);
            dbdObj = this.imsObjTbl.get("DBD_" + tid);
            ssaObj = this.imsObjTbl.get("SSA_" + tid);
        }
        List fieldQueryList = null;
        if (lstObj instanceof List) {
            fieldQueryList = (List)lstObj;
        }
        if (fieldQueryList != null && !fieldQueryList.isEmpty()) {
            List fieldValueList = null;
            List listOfFieldValueLists = null;
            if (valObj instanceof List && (listOfFieldValueLists = (List)valObj) != null && !listOfFieldValueLists.isEmpty()) {
                fieldValueList = (List)listOfFieldValueLists.remove(0);
                fieldQueryList.remove(0);
                if (!fieldValueList.isEmpty()) {
                    int i = 0;
                    int pos = 2;
                    while (i < fieldValueList.size()) {
                        prepStmt.setBytes(pos, (byte[])fieldValueList.get(i));
                        if (LOGVDB) {
                            System.out.println(PGM + func + ": prepStmt.setBytes(" + pos + ", <hex representation of byte array next line>)");
                            System.out.println(DatatypeConverter.printHexBinary((byte[])((byte[])fieldValueList.get(i))));
                        }
                        ++i;
                        ++pos;
                    }
                }
            }
        }
    }

    public int startNextPrev(Variable key, int mode) {
        String func = ".startNextPrev(): ";
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer(PGM + ".startNextPrev(): " + ": on [" + this.toDesc() + "].");
        } else if (LOGVDB) {
            System.out.println(PGM + ".startNextPrev(): " + ": on [" + this.toDesc() + "].");
        }
        if (!this.isOpen(OPENMODE.OPEN_INPUT) && !this.isOpen(OPENMODE.OPEN_IO)) {
            this.setIOStatus(-47);
            this.readState = READSTATE.ERROR;
            return -47;
        }
        if (this.resultSet == null || this.readState != READSTATE.READNEXT_ASC && this.readState != READSTATE.START_ASC || mode != 1 || this.readState == READSTATE.READPREV_DESC && mode == -1 || this.readState == READSTATE.READNEXT_ASC && mode == 1) {
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.finer(PGM + ".startNextPrev(): " + ": Finding prep statement.");
            } else if (LOGVDB) {
                System.out.println(PGM + ".startNextPrev(): " + ": Finding prep statement.");
            }
            String keyName = this.closestIdxName(key);
            if (keyName == null) {
                this.setIOStatus(-23);
                this.record1 = null;
                this.primeKey1 = null;
                this.altKey1 = null;
                this.readState = READSTATE.ERROR;
                this.warning("startNextPrev", "invalid key, random record missing");
                return -23;
            }
            if (mode >> 8 != 0) {
                this.readMode = mode >> 8;
            }
            if (this.fileType == FILETYPE.INDEXED) {
                int keyNameLength = 0;
                try {
                    int from = keyName.toLowerCase().startsWith("ci_n") ? keyName.substring(6).indexOf(95) + 7 : (keyName.toLowerCase().startsWith("ci_") ? keyName.substring(3).indexOf(95) + 4 : keyName.indexOf(95) + 1);
                    int to = keyName.indexOf("__");
                    if (to < 0) {
                        to = keyName.length();
                    }
                    keyNameLength = Integer.parseInt(keyName.substring(from, to));
                }
                catch (NumberFormatException e) {
                    this.warning("startNextPrev", "invalid key, random record missing");
                    return -23;
                }
                if ((key.getMinimumSize() < key.length() || key.length() < keyNameLength) && mode == 0) {
                    this.generic = true;
                    mode = 1;
                } else {
                    this.generic = mode == 1 || mode == 2 || mode == -1 || mode == -2 ? false : false;
                }
            } else {
                this.generic = false;
            }
            if (this.FetchSize < 0) {
                this.FetchSize = FETCHSIZE;
            }
            this.browseStmt = this.procurePreparedStatement(keyName, "READNEXT", mode);
            this.readState = mode == 0 || mode == 1 || mode == 2 ? READSTATE.START_ASC : READSTATE.START_DESC;
            try {
                boolean isDisableCursorsLocal;
                boolean bl = isDisableCursorsLocal = this.isDisableCursorCompatible && DISABLE_SQLCURSORS;
                if (this.FetchSize > 0) {
                    this.browseStmt.setFetchSize(this.FetchSize);
                }
                this.originalKey = null;
                this.originalKeyEbcidic = null;
                this.primeKeyEbcdic = null;
                if (this.fileType == FILETYPE.SEQUENTIAL) {
                    this.originalKey = new Integer(0);
                    this.browseStmt.setInt(1, this.esdsKey == -1 ? 0 : this.esdsKey);
                } else {
                    int posn;
                    for (int i = 1; i < this.columns.size(); ++i) {
                        SqlColumn col = this.columns.get(i);
                        if (this.doesEbcdicColumnExist(keyName) && col.getName().toLowerCase().startsWith("ci_") && col.getName().toLowerCase().endsWith(keyName.toLowerCase())) {
                            if (this.fileType != FILETYPE.INDEXED) continue;
                            String colKeyValue = new String(key.toByteArray(), StandardCharsets.ISO_8859_1);
                            byte[] originalKeyEbcdic = colKeyValue.getBytes(Charset.forName("Cp277"));
                            this.originalKey = this.getKeyData(key);
                            this.originalKeyEbcidic = originalKeyEbcdic;
                            this.browseStmt.setBytes(1, originalKeyEbcdic);
                            if (this.isUsingAlternateKey) {
                                this.browseStmt.setBytes(2, this.keyArray[0].getBytes());
                            }
                            if (!LOGVDB) break;
                            System.out.println("Column: " + keyName);
                            System.out.println(PGM + ".startNextPrev(): " + ": browseStmt.setBytes(1, <hex representation of byte array next line>)");
                            System.out.println(DatatypeConverter.printHexBinary((byte[])originalKeyEbcdic));
                            if (!this.isUsingAlternateKey) break;
                            System.out.println("Column: " + this.primaryKeyColumn);
                            System.out.println(PGM + ".startNextPrev(): " + ": browseStmt.setBytes(2, <hex representation of byte array next line>)");
                            System.out.println(DatatypeConverter.printHexBinary((byte[])this.keyArray[0].getBytes()));
                            break;
                        }
                        if (this.doesEbcdicColumnExist(keyName) || !col.getName().equalsIgnoreCase(keyName)) continue;
                        if (this.fileType == FILETYPE.RELATIVE && key.isNumeric()) {
                            int k = key.toInt();
                            this.originalKey = new Integer(k);
                            this.browseStmt.setInt(1, k);
                            break;
                        }
                        if (this.fileType != FILETYPE.INDEXED) break;
                        this.originalKey = this.getKeyData(key);
                        this.browseStmt.setBytes(1, (byte[])this.originalKey);
                        if (this.isUsingAlternateKey) {
                            this.browseStmt.setBytes(2, this.keyArray[0].getBytes());
                        }
                        if (!LOGVDB) break;
                        System.out.println("Column: " + keyName);
                        System.out.println(PGM + ".startNextPrev(): " + ": browseStmt.setBytes(1, <hex representation of byte array next line>)");
                        System.out.println(DatatypeConverter.printHexBinary((byte[])((byte[])this.originalKey)));
                        if (!this.isUsingAlternateKey) break;
                        System.out.println("Column: " + this.primaryKeyColumn);
                        System.out.println(PGM + ".startNextPrev(): " + ": browseStmt.setBytes(2, <hex representation of byte array next line>)");
                        System.out.println(DatatypeConverter.printHexBinary((byte[])this.keyArray[0].getBytes()));
                        break;
                    }
                    if (this.originalKey == null && (posn = keyName.indexOf(95)) > 0) {
                        keyName = keyName.substring(0, posn + 1).toLowerCase();
                        for (int i = 1; i < this.columns.size(); ++i) {
                            SqlColumn col = this.columns.get(i);
                            if (!col.getName().toLowerCase().startsWith(keyName)) continue;
                            if (this.fileType == FILETYPE.RELATIVE && key.isNumeric()) {
                                int k = key.toInt();
                                this.originalKey = new Integer(k);
                                this.browseStmt.setInt(1, k);
                                break;
                            }
                            if (this.fileType != FILETYPE.INDEXED) break;
                            this.originalKey = this.getKeyData(key);
                            this.browseStmt.setBytes(1, (byte[])this.originalKey);
                            if (!LOGVDB) break;
                            System.out.println("Column: " + keyName);
                            System.out.println(PGM + ".startNextPrev(): " + ": browseStmt.setBytes(1, <hex representation of byte array next line>)");
                            System.out.println(DatatypeConverter.printHexBinary((byte[])((byte[])this.originalKey)));
                            break;
                        }
                    }
                }
                if (this.assertVDB(this.originalKey != null, "must have found a a matching column for our key (if REL or IDX)") == -90) {
                    return -90;
                }
                if ((this.dbms != DBMS.SQLSERVER || !isDisableCursorsLocal) && this.paginationLimit > 0 && this.dbms.supportsPagination()) {
                    this.paginationOffset = 0;
                    this.dbms.SetLimitandOffset(this.browseStmt, this.paginationLimit, this.paginationOffset);
                }
                if (this.resultSet != null) {
                    this.closeResultSet();
                }
                this.resultSet = this.browseStmt.executeQuery();
                long finished = System.currentTimeMillis();
                this.record2 = null;
                this.record1 = null;
                this.record0 = null;
                this.primeKey2 = null;
                this.primeKey1 = null;
                this.altKey2 = null;
                this.altKey1 = null;
            }
            catch (SQLException e) {
                this.closeResultSet();
                this.readState = READSTATE.ERROR;
                VDB.LogAndThrowException(PGM + ".startNextPrev(): " + ": Cannot retrieve data into variable for '" + this.getFilteredFilename() + "' (table name " + this.sqlTableName + ") because " + e.getMessage(), true);
                return -90;
            }
        }
        return 0;
    }

    private PreparedStatement getPreparedStatement(String prepStmtKey) {
        return this.keyToPreparedStatementMap.get(prepStmtKey);
    }

    private void makePreparedStatement(String keyName, String command, int mode, String prepStmtKey) {
        boolean isDisableCursorsLocal;
        String func = ".makePreparedStatement(): ";
        String cmd = command.toUpperCase();
        this.makeComparator(mode);
        PreparedStatement pstmt = null;
        String query = null;
        String rowLock = "";
        String noLock = "";
        this.isDisableCursorCompatible = this.ALLOW_CURSOR_OVERRIDE.booleanValue() ? !this.enableThisCursor() : true;
        boolean bl = isDisableCursorsLocal = this.isDisableCursorCompatible && DISABLE_SQLCURSORS;
        if (this.dbms == DBMS.SQLSERVER) {
            if (!isDisableCursorsLocal) {
                rowLock = " with (rowlock) ";
            }
            if (this.readMode == 4 || Utilities.isCurrentEnviromentCICS()) {
                // empty if block
            }
        }
        String imsExtendedSql = null;
        if (VDB.isEXTENDEDSSA()) {
            imsExtendedSql = this.generateExtendedSSA();
        }
        if (imsExtendedSql != null && LOGVDB) {
            System.out.println(PGM + ".makePreparedStatement(): " + ": imsExtendedSql=" + imsExtendedSql);
        }
        if ("READNEXT".equals(cmd) || "READ".equals(cmd) || "START".equals(cmd)) {
            String where = this.makeSqlWhere(keyName);
            String anAdditionalKey = null;
            if (this.fileType == FILETYPE.INDEXED && this.currentKeyNumber != 0 && this.isKeyDuplicates[this.currentKeyNumber]) {
                anAdditionalKey = this.keyNameArray[0];
            }
            String orderBy = this.makeSqlOrderBy(keyName, anAdditionalKey, mode == -1 || mode == -2);
            query = "select * from " + this.sqlTableName + noLock;
            this.conditionForCount = " where " + where;
            query = query + this.conditionForCount;
            query = query + " order by " + orderBy;
            if (imsExtendedSql != null) {
                String extendedQuery;
                query = extendedQuery = "select ims.* from ( " + query + " ) as ims " + imsExtendedSql;
            }
            if (this.dbms == DBMS.SQLSERVER && isDisableCursorsLocal) {
                if (this.FetchSize > 0) {
                    query = query.replaceFirst("select \\*", "select top " + this.FetchSize + " *");
                    if (!keyName.equals(this.primaryKeyColumn)) {
                        int orderPos = query.indexOf("order by");
                        query = query.substring(0, orderPos - 1) + " and " + this.primaryKeyColumn + " >= ? " + query.substring(orderPos);
                        this.isUsingAlternateKey = true;
                    }
                }
            } else {
                this.paginationOffset = 0;
                this.paginationLimit = 0;
                if (this.FetchSize != 1000 && this.FetchSize > 0 && this.dbms.supportsPagination()) {
                    query = query + this.dbms.getPaginationClause();
                    this.paginationLimit = this.FetchSize;
                }
            }
        } else if ("WRITE".equals(cmd)) {
            query = "insert into " + this.sqlTableName + "(";
            if (this.fileType == FILETYPE.SEQUENTIAL) {
                query = query + this.columns.get(0).getName();
            } else {
                boolean first = true;
                for (SqlColumn aColumn : this.columns) {
                    if (first) {
                        first = false;
                    } else {
                        query = query + ",";
                    }
                    query = query + aColumn.getName();
                }
            }
            query = query + ") values (" + this.makeSqlInsertPlaceHolders() + ")";
        } else if ("DELETE".equals(cmd)) {
            query = "delete from " + this.sqlTableName + rowLock + " where " + this.makeSqlWhere(this.keyNameArray[0]);
        } else if ("DELETE GENERIC".equals(cmd)) {
            query = "delete from " + this.sqlTableName + " where " + this.makeSqlWhereDelete(keyName);
        } else if ("REWRITE".equals(cmd)) {
            query = "update " + this.sqlTableName + rowLock + " set " + this.makeSqlSet() + " where " + this.makeSqlWhere(this.keyNameArray[0]);
        } else if ("COUNT".equals(cmd)) {
            query = "select COUNT(*) from " + this.sqlTableName + this.conditionForCount;
        } else if (cmd != null) {
            VDB.Logit("Internal Error:  command unknown: " + cmd, "makePreparedStatement");
        } else {
            VDB.Logit("Internal Error:  command not specified", "makePreparedStatement");
        }
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.fine(PGM + ".makePreparedStatement(): " + ": query=" + query);
        } else if (LOGVDB) {
            System.out.println(PGM + ".makePreparedStatement(): " + ": query=" + query);
        }
        try {
            pstmt = this.dbms == DBMS.SQLSERVER ? (isDisableCursorsLocal ? this.conn.prepareStatement(query) : ("START".equals(cmd) || !this.writeable ? this.conn.prepareStatement(query, 1004, 1007) : this.conn.prepareStatement(query, 1005, 1008))) : (this.writeable ? (this.dbms == DBMS.SPLICE ? this.conn.prepareStatement(query) : this.conn.prepareStatement(query, 1005, 1008)) : (this.dbms == DBMS.SPLICE ? this.conn.prepareStatement(query) : this.conn.prepareStatement(query, 1004, 1007)));
            this.lastSqlStatement = query;
        }
        catch (SQLException e) {
            this.closeResultSet();
            VDB.LogAndThrowException(PGM + ".makePreparedStatement(): " + ": SQLException: " + e.getMessage(), true);
        }
        this.keyToPreparedStatementMap.put(prepStmtKey, pstmt);
    }

    private String generateExtendedSSA() {
        String sqlString = null;
        Object obj = null;
        if (dfsrrc00Class != null && dfsrrc00GetInstanceMapMethod != null) {
            Class<?> klazz = dfsrrc00Class;
            Method method = dfsrrc00GetInstanceMapMethod;
            try {
                obj = method.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
                e.printStackTrace(System.err);
            }
        } else {
            try {
                Class<?> klazz = Class.forName("com.heirloomcomputing.eims.util.DFSRRC00");
                Method method = klazz.getDeclaredMethod("getInstanceMap", new Class[0]);
                obj = method.invoke(null, new Object[0]);
                dfsrrc00Class = klazz;
                dfsrrc00GetInstanceMapMethod = method;
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace(System.err);
            }
        }
        Object lstObj = null;
        Object valObj = null;
        Object dbdObj = null;
        Object ssaObj = null;
        if (obj != null) {
            if (obj instanceof HashMap) {
                this.imsObjTbl = (HashMap)obj;
            }
            String tid = String.valueOf(Thread.currentThread().getId());
            lstObj = this.imsObjTbl.get("LST_" + tid);
            valObj = this.imsObjTbl.get("VAL_" + tid);
            dbdObj = this.imsObjTbl.get("DBD_" + tid);
            ssaObj = this.imsObjTbl.get("SSA_" + tid);
        }
        List fieldQueryList = null;
        if (lstObj instanceof List && !(fieldQueryList = (List)lstObj).isEmpty()) {
            sqlString = (String)fieldQueryList.remove(0);
        }
        return sqlString;
    }

    public String makeStatement(String keyName, String command, int mode) {
        String func = ".makeStatement(): ";
        String cmd = command.toUpperCase();
        this.makeComparator(mode);
        String query = null;
        if ("READNEXT".equals(cmd) || "READ".equals(cmd) || "START".equals(cmd)) {
            String where = this.makeSqlWhere(keyName);
            String anAdditionalKey = null;
            if (this.fileType == FILETYPE.INDEXED && this.currentKeyNumber != 0 && this.isKeyDuplicates[this.currentKeyNumber]) {
                anAdditionalKey = this.keyNameArray[0];
            }
            String orderBy = this.makeSqlOrderBy(keyName, anAdditionalKey, mode == -1);
            query = "select * from " + this.sqlTableName + " where " + where + " order by " + orderBy;
        } else if ("WRITE".equals(cmd)) {
            query = "insert into " + this.sqlTableName + "(";
            boolean first = true;
            for (SqlColumn aColumn : this.columns) {
                if (first) {
                    first = false;
                } else {
                    query = query + ",";
                }
                query = query + aColumn.getName();
            }
            query = query + ") values (" + this.makeSqlInsertPlaceHolders() + ")";
        } else if ("DELETE".equals(cmd)) {
            query = "delete from " + this.sqlTableName + " where " + this.makeSqlWhere(keyName);
        } else if ("DELETE GENERIC".equals(cmd)) {
            query = "delete from " + this.sqlTableName + " where " + this.makeSqlWhereDelete(keyName);
        } else if ("REWRITE".equals(cmd)) {
            query = "update " + this.sqlTableName + " set " + this.makeSqlSet() + " where " + this.makeSqlWhere(keyName);
        } else if (cmd != null) {
            VDB.Logit("Internal Error:  command unknown: " + cmd, "makeStatement");
        } else {
            VDB.Logit("Internal Error:  command not specified", "makeStatement");
        }
        if (LOGVDB) {
            System.out.println(PGM + ".makeStatement(): " + ": query=" + query);
        }
        return query;
    }

    public PreparedStatement procurePreparedStatement(String keyName, String command, int mode) {
        String func = ".procurePreparedStatement(): ";
        String cmd = command.toUpperCase();
        this.makeComparator(mode);
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(cmd).append(' ').append(keyName).append(' ').append(this.operator);
        if (this.readable && this.writeable) {
            sbuf.append("IO");
        } else if (this.readable) {
            sbuf.append("I");
        } else if (this.writeable) {
            sbuf.append("O");
        }
        sbuf.append(String.valueOf(this.readMode));
        String prepStmtKey = sbuf.toString();
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer(PGM + ".procurePreparedStatement(): " + ": key to prepared statement Map is " + prepStmtKey + ". mode=" + mode + ".");
        } else if (LOGVDB) {
            System.out.println(PGM + ".procurePreparedStatement(): " + ": key to prepared statement Map is " + prepStmtKey + ". mode=" + mode + ".");
        }
        PreparedStatement pstmt = null;
        if (!VDB.isEXTENDEDSSA() && (pstmt = this.getPreparedStatement(prepStmtKey)) != null) {
            return pstmt;
        }
        this.makePreparedStatement(keyName, command, mode, prepStmtKey);
        pstmt = this.getPreparedStatement(prepStmtKey);
        if (pstmt == null) {
            VDB.Logit("Internal Error: PreparedStatement object should have been found!", ".procurePreparedStatement(): ");
        }
        return pstmt;
    }

    private String makeSqlOrderBy(String searchKeyName, String primaryKeyName, boolean desc) {
        String orderBy = searchKeyName;
        if (this.isMSSQLEBCDIC()) {
            orderBy = "cast(" + searchKeyName + " AS VARCHAR(MAX))";
        }
        if (this.isEbcdicBinaryColumn() || this.doesEbcdicColumnExist(searchKeyName)) {
            if (this.doesEbcdicColumnExist(searchKeyName)) {
                VDB.Logit(PGM + ":.makeSqlWhere ", this.getEbcdicColumnEquivalent(searchKeyName) + " ebcdic column is going to be used.");
                orderBy = this.getEbcdicColumnEquivalent(searchKeyName);
            } else {
                VDB.Logit(PGM + ":.makeSqlWhere ", "Flag useEbcdicBinaryColumn is on, but there is no ebcdic column created!");
            }
        }
        if (desc) {
            orderBy = orderBy + " desc";
        }
        if (this.isMSSQLEBCDIC()) {
            orderBy = orderBy + " COLLATE " + this.getMSSQLCodepageCollation();
        }
        if (primaryKeyName != null) {
            orderBy = this.doesEbcdicColumnExist(primaryKeyName) ? orderBy + "," + this.getEbcdicColumnEquivalent(primaryKeyName) : orderBy + "," + primaryKeyName;
            if (desc) {
                orderBy = orderBy + " desc";
            }
        }
        return orderBy;
    }

    private String makeSqlSet() {
        StringBuffer sbuf = new StringBuffer();
        if (this.fileType != FILETYPE.INDEXED) {
            return this.columns.get(0).getName();
        }
        int numOfColumns = 0;
        for (int i = 0; i < this.columns.size(); ++i) {
            SqlColumn col = this.columns.get(i);
            if (++numOfColumns > 1) {
                sbuf.append(",");
            }
            sbuf.append(col.getName()).append(" = ?");
        }
        String str = sbuf.toString();
        return str;
    }

    private String makeSqlWhereDelete(String keyName) {
        if (this.isMSSQLEBCDIC()) {
            String complexWhere = "cast(" + keyName + " AS VARCHAR(MAX)) COLLATE" + this.getMSSQLCodepageCollation() + this.comparator + " ?";
            return complexWhere;
        }
        return keyName + " " + this.comparator + " ?";
    }

    private String makeSqlWhere(String keyName) {
        if (this.isMSSQLEBCDIC()) {
            String complexWhere = "cast(" + keyName + " AS VARCHAR(MAX)) COLLATE" + this.getMSSQLCodepageCollation() + this.comparator + " ?";
            return complexWhere;
        }
        if (this.isEbcdicBinaryColumn() || this.doesEbcdicColumnExist(keyName)) {
            if (this.doesEbcdicColumnExist(keyName)) {
                VDB.Logit(PGM + ":.makeSqlWhere ", keyName + " ebcdic column is going to be used.");
                return this.getEbcdicColumnEquivalent(keyName) + " " + this.comparator + " ?";
            }
            VDB.Logit(PGM + ":.makeSqlWhere ", "Flag useEbcdicBinaryColumn is on, but there is no ebcdic column created!");
        }
        return keyName + " " + this.comparator + " ?";
    }

    private boolean doesEbcdicColumnExist(String keyName) {
        if (this.columns != null) {
            if (keyName.toLowerCase().startsWith("ci_")) {
                Predicate<SqlColumn> p1 = s -> s.getName().toLowerCase().startsWith("ci_") && s.getName().toLowerCase().endsWith(keyName.toLowerCase());
                return this.columns.stream().anyMatch(p1);
            }
            String keyNameWithPrefix = "ci_" + keyName;
            Predicate<SqlColumn> p1 = s -> s.getName().toLowerCase().startsWith("ci_") && s.getName().toLowerCase().endsWith(keyNameWithPrefix.toLowerCase());
            return this.columns.stream().anyMatch(p1);
        }
        Vector<SqlColumn> tempColumns = SqlColumn.getColumns(this.sqlTableName, this.conn, this.dbms, this.driverMajorVersion, !Utilities.isCurrentEnviromentCICS());
        if (keyName.toLowerCase().startsWith("ci_")) {
            Predicate<SqlColumn> p1 = s -> s.getName().toLowerCase().startsWith("ci_") && s.getName().toLowerCase().endsWith(keyName.toLowerCase());
            return tempColumns.stream().anyMatch(p1);
        }
        String keyNameWithPrefix = "ci_" + keyName;
        Predicate<SqlColumn> p1 = s -> s.getName().toLowerCase().startsWith("ci_") && s.getName().toLowerCase().endsWith(keyNameWithPrefix.toLowerCase());
        return tempColumns.stream().anyMatch(p1);
    }

    private String getEbcdicColumnEquivalent(String keyName) {
        Predicate<SqlColumn> p1 = s -> s.getName().toLowerCase().startsWith("ci_") && s.getName().toLowerCase().endsWith(keyName.toLowerCase());
        Optional<SqlColumn> isColumnFound = this.columns.stream().filter(p1).findFirst();
        if (isColumnFound.isPresent()) {
            return isColumnFound.get().getName();
        }
        return keyName;
    }

    private String makeSqlInsertPlaceHolders() {
        StringBuffer sbuf = new StringBuffer();
        if (this.fileType == FILETYPE.SEQUENTIAL) {
            sbuf.append('?');
        } else {
            for (int i = 0; i < this.columns.size(); ++i) {
                if (i > 0) {
                    sbuf.append(',');
                }
                sbuf.append('?');
            }
        }
        String str = sbuf.toString();
        return str;
    }

    private void makeComparator(int mode) {
        String func = ".makeComparator(): ";
        switch (mode) {
            case -2: {
                this.comparator = "<";
                this.operator = "LT";
                break;
            }
            case -1: {
                this.comparator = "<=";
                this.operator = "LE";
                break;
            }
            case 0: {
                this.comparator = "=";
                this.operator = "EQ";
                break;
            }
            case 1: {
                this.comparator = ">=";
                this.operator = "GE";
                break;
            }
            case 2: {
                this.comparator = ">";
                this.operator = "GT";
                break;
            }
            case 3: {
                this.comparator = "like";
                this.operator = "LIKE";
                break;
            }
            default: {
                VDB.Logit("WARNING: VALID START COMPARATORS ARE =, >, >=, <, <=, LIKE. ASSUMED = ", ".makeComparator(): ");
                this.comparator = "=";
                this.operator = "EQ";
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public PreparedStatement fillStatementParameterValues(String operation, int mode, Variable fromVar) throws SQLException {
        func = " .fillStatementParameterValues() ";
        keyName = "data";
        pStmt = this.procurePreparedStatement(keyName, operation, mode);
        data = this.dependingOn == null ? fromVar.toByteArray() : fromVar.toByteArray(this.dependingOn.toInt());
        pStmt.setBytes(1, data);
        if (VDB.LOGVDB) {
            colName = "";
            if (this.columns.size() > 0) {
                colName = this.columns.get(0) == null ? "" : this.columns.get(0).getName();
            }
            System.out.println("Column: " + colName);
            System.out.println(VDB.PGM + " .fillStatementParameterValues() " + ": pStmt.setBytes(1, <hex representation of byte array next line>)");
            System.out.println(DatatypeConverter.printHexBinary((byte[])data));
        }
        switch (1.$SwitchMap$com$heirloomcomputing$ecs$isamsql$FILETYPE[this.fileType.ordinal()]) {
            case 1: {
                for (i = 1; i < this.columns.size(); ++i) {
                    col = this.columns.get(i);
                    dat = new byte[col.getLength()];
                    runningOffset = 0;
                    if (!col.getName().toLowerCase().startsWith("ci_")) ** GOTO lbl52
                    keys = new ArrayList<E>();
                    if (col.getName().toLowerCase().startsWith("ci_n")) {
                        keys = this.getKeyTypes(col.getName(), col.getName().toLowerCase().endsWith(this.primaryKeyColumn.toLowerCase()));
                    }
                    for (j = 0; j < col.getComponentCount(); ++j) {
                        if (col.getLength(j) <= dat.length - runningOffset && col.getLength(j) + col.getOffset(j) <= data.length) ** GOTO lbl30
                        if (VDB.ThrowExceptions(null)) {
                            this.closeResultSet();
                            VDB.LogAndThrowException("VDB: Column mismatch '" + col.getName() + "' with original file definition. Has a COBOL record element length changed since the file/table was created?", true);
                        }
                        ** GOTO lbl62
lbl30:
                        // 1 sources

                        if (keys.isEmpty() || !keys.contains(j)) ** GOTO lbl33
                        System.arraycopy(data, col.getOffset(j), dat, runningOffset, col.getLength(j));
                        ** GOTO lbl49
lbl33:
                        // 1 sources

                        colKeyValue = new String(data, StandardCharsets.ISO_8859_1);
                        encoding = "Cp277";
                        if (fromVar.getByteEncoding() != null) {
                            encoding = fromVar.getByteEncoding();
                        }
                        try {
                            System.arraycopy(colKeyValue.getBytes(encoding), col.getOffset(j), dat, runningOffset, col.getLength(j));
                        }
                        catch (UnsupportedEncodingException e) {
                            why = e.getMessage();
                            if (LogSetup.IS_LOGGING) {
                                LogSetup.LOGGER.fine(VDB.PGM + " .fillStatementParameterValues() " + "UnsupportedEncodingException=" + why);
                            }
                            if (!VDB.LOGVDB) ** GOTO lbl49
                            System.out.println(VDB.PGM + " .fillStatementParameterValues() " + "UnsupportedEncodingException=" + why);
                        }
lbl49:
                        // 5 sources

                        runningOffset += col.getLength(j);
                    }
                    ** GOTO lbl62
lbl52:
                    // 2 sources

                    for (j = 0; j < col.getComponentCount(); ++j) {
                        if (col.getLength(j) <= dat.length - runningOffset && col.getLength(j) + col.getOffset(j) <= data.length) ** GOTO lbl59
                        if (VDB.ThrowExceptions(null)) {
                            this.closeResultSet();
                            VDB.LogAndThrowException("VDB: Column mismatch '" + col.getName() + "' with original file definition. Has a COBOL record element length changed since the file/table was created?", true);
                        }
                        break;
lbl59:
                        // 1 sources

                        System.arraycopy(data, col.getOffset(j), dat, runningOffset, col.getLength(j));
                        runningOffset += col.getLength(j);
                    }
lbl62:
                    // 4 sources

                    pStmt.setBytes(i + 1, dat);
                    if (!VDB.LOGVDB) continue;
                    System.out.println("Column: " + col.getName());
                    System.out.println(VDB.PGM + " .fillStatementParameterValues() " + ": pStmt.setBytes(" + (i + 1) + ",<hex representation of byte array next line>)");
                    System.out.println(DatatypeConverter.printHexBinary((byte[])dat));
                }
                break;
            }
            case 2: {
                pStmt.setInt(2, this.keyArray[0].toInt());
                break;
            }
            case 3: {
                break;
            }
            default: {
                this.assertVDB(false, "unknown filetype " + (Object)this.fileType);
            }
        }
        return pStmt;
    }

    public boolean isMSSQLEBCDIC() {
        String property = System.getProperty("sql.file.useMSSQLcollateEbcdic");
        return Boolean.valueOf(property);
    }

    public String getMSSQLCodepageCollation() {
        String property = System.getProperty("sql.file.ebcdicCodepage");
        Codepage codepage = Codepage.parseCodepage(property);
        switch (codepage) {
            case CODEPAGE_277: {
                return " SQL_EBCDIC277_2_CP1_CS_AS ";
            }
        }
        return " SQL_EBCDIC037_CP1_CS_AS ";
    }

    public boolean isEbcdicBinaryColumn() {
        String property = System.getProperty("sql.file.useEbcdicBinaryColumn");
        return Boolean.valueOf(property);
    }

    private List<Integer> getKeyTypes(String keyName, boolean isPrimaryKey) {
        String keyTypes = null;
        ArrayList<Integer> keyIndexes = new ArrayList();
        keyTypes = isPrimaryKey ? System.getProperty("OUTFILE-PRIMARY-TYPES") : System.getProperty("OUTFILE-ALTKEY-TYPES");
        if (keyTypes != null) {
            String[] keyTypesArray = keyTypes.replaceAll("[\\[\\]]", "").replaceAll("\\s", "").split(",");
            for (int index = 0; index < keyTypesArray.length; ++index) {
                if (!keyTypesArray[index].equals("n")) continue;
                keyIndexes.add(index);
            }
        } else {
            keyIndexes = this.getKeyTypesFromColumnName(keyName);
        }
        return keyIndexes;
    }

    private List<Integer> getKeyTypesFromColumnName(String columnName) {
        if (columnName.toLowerCase().startsWith("ci_n")) {
            int startIndex = 4;
            String indexes = columnName.substring(startIndex, columnName.toLowerCase().indexOf("_idx"));
            List<String> keyIndexes = Arrays.asList(indexes.split("(?<=.)"));
            return keyIndexes.stream().map(Integer::parseInt).collect(Collectors.toList());
        }
        return new ArrayList<Integer>();
    }

    public String generateEbcdicIndexKeyName(String keyName, boolean isPrimaryKey) {
        List<Integer> keyNonTextTypes = this.getKeyTypes(keyName, isPrimaryKey);
        if (keyNonTextTypes.size() > 0) {
            String prefixType = keyNonTextTypes.stream().map(String::valueOf).collect(Collectors.joining(""));
            return "ci_n" + prefixType + "_" + keyName;
        }
        return "ci_" + keyName;
    }

    public boolean isBatchInsertMode() {
        String property = System.getProperty("sql.file.useBatchInsert");
        return Boolean.valueOf(property);
    }

    public int getBatchInsertSize() {
        String property = System.getProperty("sql.file.useBatchInsert.batchSize");
        if (property != null && !property.isEmpty()) {
            return Integer.valueOf(property);
        }
        return 0;
    }

    private boolean isDupKey(String sqlState) {
        if (sqlState == null) {
            return false;
        }
        return sqlState.equals("23505") || sqlState.equals("23000");
    }

    public boolean insert(Variable fromVar) {
        boolean errorOccurred;
        String func = "write(): ";
        if (BATCH_UPDATE_THRESHOLD > 0 && this.deletePreparedStmt != null && this.deleteBuffer > 0 && (errorOccurred = this.processDeleteWhenOperChanged())) {
            throw new IllegalStateException("While in batch update mode, unprocessed delete batch failed when op mode changed to write ops before processing deletes");
        }
        this.record1 = this.dependingOn == null ? fromVar.toByteArray() : fromVar.toByteArray(this.dependingOn.toInt());
        if (this.fileType != FILETYPE.SEQUENTIAL) {
            this.primeKey1 = this.getKeyData(this.keyArray[0]);
        }
        this.readState = READSTATE.WRITE;
        boolean isBatchMode = this.isBatchInsertMode();
        int batchSize = this.getBatchInsertSize();
        int numOfRowsInserted = 0;
        Savepoint mark = null;
        try {
            PreparedStatement prepStmt = this.fillStatementParameterValues("WRITE", 0, fromVar);
            if (!isBatchMode && this.BuffSize > 0 && this.supportsSavepoints) {
                mark = this.conn.setSavepoint("mark");
            }
            if (isBatchMode) {
                if (this.batchPreparedStmt == null) {
                    this.batchPreparedStmt = prepStmt;
                } else if (this.batchPreparedStmt != prepStmt) {
                    throw new IllegalStateException("While in batching mode, different prepared statement instances encountered which is a signal of issue");
                }
                prepStmt.addBatch();
                numOfRowsInserted = 1;
                ++this.batchInsertedRows;
                if (this.batchInsertedRows % batchSize == 0) {
                    int[] executeBatchResult;
                    for (int res : executeBatchResult = prepStmt.executeBatch()) {
                        if (res == 1) continue;
                        throw new SQLException("At least one of the inserts in the batch updated more than 1 record, which is not expected");
                    }
                    this.conn.commit();
                }
            } else {
                numOfRowsInserted = prepStmt.executeUpdate();
            }
            if (!isBatchMode && this.BuffSize > 0 && this.supportsReleaseSavepoints) {
                this.conn.releaseSavepoint(mark);
            }
            if (!isBatchMode && this.BuffSize > 0 && this.buffering++ % (long)this.BuffSize == 0L && !this.conn.getAutoCommit()) {
                this.conn.commit();
            }
        }
        catch (SQLException e) {
            if (!this.isDupKey(e.getSQLState())) {
                this.closeResultSet();
                if (System.getProperty("TRANSFORM_MODE", "0").equalsIgnoreCase("1")) {
                    this.setIOStatus(-90);
                    System.setProperty("TRANSFORM_MODE_ERR", "[ERROR] " + PGM + "write(): " + ": Cannot write data into '" + this.getFilteredFilename() + "' (table name " + this.sqlTableName + ") because " + e.getMessage() + "SQLState : " + e.getSQLState());
                    return true;
                }
                VDB.LogAndThrowException(PGM + "write(): " + ": Cannot write data into '" + this.getFilteredFilename() + "' (table name " + this.sqlTableName + ") because " + e.getMessage() + "SQLState : " + e.getSQLState(), true);
            }
            if (System.getProperty("TRANSFORM_MODE", "0").equalsIgnoreCase("1")) {
                this.closeResultSet();
                this.setIOStatus(-90);
                System.setProperty("TRANSFORM_MODE_ERR", "[ERROR] " + PGM + "write(): " + ": Duplicate key on WRITE occurred on '" + this.getFilteredFilename() + "' (table name " + this.sqlTableName + ") but subsequent commit failed with \n" + e.getMessage() + "\nSQLState : " + e.getSQLState());
                return true;
            }
            try {
                if (this.BuffSize > 0 && !this.conn.getAutoCommit() && this.buffering > 1L) {
                    if (this.supportsSavepoints && mark != null) {
                        this.conn.rollback(mark);
                    }
                    this.conn.commit();
                }
                this.buffering = 0L;
            }
            catch (SQLException e1) {
                this.closeResultSet();
                VDB.LogAndThrowException(PGM + "write(): " + ": Duplicate key on WRITE occurred on '" + this.getFilteredFilename() + "' (table name " + this.sqlTableName + ") but subsequent commit failed with " + e.getMessage() + "SQLState : " + e.getSQLState(), true);
            }
        }
        if (numOfRowsInserted == 0) {
            this.setIOStatus(-22);
            return true;
        }
        if (numOfRowsInserted > 1) {
            this.setIOStatus(-90);
            VDB.Logit("file status=" + (this.fileStatus == null ? "ERROR OTHER" : this.fileStatus.toText()) + ". More than 1 record written. " + numOfRowsInserted + " records were written. ", "write(): ");
            return true;
        }
        this.setIOStatus(0);
        return false;
    }

    public boolean update(Variable fromVar) {
        boolean isDisableCursorsLocal;
        String func = "rewrite(): ";
        int numOfRowsUpdated = 0;
        byte[] data = this.dependingOn == null ? fromVar.toByteArray() : fromVar.toByteArray(this.dependingOn.toInt());
        boolean bl = isDisableCursorsLocal = this.isDisableCursorCompatible && DISABLE_SQLCURSORS;
        if (!isDisableCursorsLocal && this.resultSet != null && this.dbms != DBMS.ORACLE && this.dbms != DBMS.DB2 && (this.accessMode == ACCESSMODE.SEQUENTIAL || this.accessMode == ACCESSMODE.DYNAMIC && (this.record1 == null || this.isKeyInRecordEqual(0, data, this.record1)))) {
            if (this.record1 == null || this.readState != READSTATE.READNEXT_DESC && this.readState != READSTATE.READNEXT_ASC && this.readState != READSTATE.READPREV_DESC && this.readState != READSTATE.READPREV_ASC && this.readState != READSTATE.READRAND && this.readState != READSTATE.WRITE) {
                this.setIOStatus(-43);
                VDB.Logit("file status=" + (this.fileStatus == null ? "ERROR_LOGIC_REWRITE_NOT_AFTER_READ" : this.fileStatus.toText()) + ". Record cannot be rewritten. Previous access to file (sql table) must be successful 'READ'.", "rewrite(): ");
                this.readState = READSTATE.ERROR;
                return true;
            }
            if (this.readState != READSTATE.WRITE) {
                try {
                    if (this.record2 != null) {
                        if (this.readState == READSTATE.READNEXT_ASC || this.readState == READSTATE.READPREV_DESC || this.readState == READSTATE.READRAND) {
                            this.resultSet.previous();
                        } else {
                            this.resultSet.next();
                        }
                    } else if (this.readState == READSTATE.READNEXT_ASC || this.readState == READSTATE.READPREV_DESC || this.readState == READSTATE.READRAND) {
                        this.resultSet.last();
                    } else {
                        this.resultSet.first();
                    }
                    this.resultSet.updateBytes(1, data);
                    switch (this.fileType) {
                        case RELATIVE: {
                            break;
                        }
                        case SEQUENTIAL: {
                            break;
                        }
                        case INDEXED: {
                            for (int i = 1; i < this.columns.size(); ++i) {
                                SqlColumn col = this.columns.get(i);
                                byte[] dat = new byte[col.getLength()];
                                int runningOffset = 0;
                                for (int j = 0; j < col.getComponentCount(); ++j) {
                                    if (col.getName().toLowerCase().startsWith("ci_n")) {
                                        List<Integer> keys = this.getKeyTypesFromColumnName(col.getName());
                                        if (!keys.isEmpty() && keys.contains(j)) {
                                            System.arraycopy(data, col.getOffset(j), dat, runningOffset, col.getLength(j));
                                        } else {
                                            try {
                                                String colKeyValue = new String(data, StandardCharsets.ISO_8859_1);
                                                String encoding = "Cp277";
                                                if (fromVar.getByteEncoding() != null) {
                                                    encoding = fromVar.getByteEncoding();
                                                }
                                                System.arraycopy(colKeyValue.getBytes(encoding), col.getOffset(j), dat, runningOffset, col.getLength(j));
                                            }
                                            catch (UnsupportedEncodingException e) {
                                                VDB.LogAndThrowException(PGM + "rewrite(): " + ": Unsupported Encoding for '" + col.getName() + "' (table name " + this.sqlTableName + ") because " + e.getMessage() + "SQLState : " + e.getMessage(), true);
                                            }
                                        }
                                    } else if (col.getName().toLowerCase().startsWith("ci_")) {
                                        try {
                                            String colKeyValue = new String(data, StandardCharsets.ISO_8859_1);
                                            String encoding = "Cp277";
                                            if (fromVar.getByteEncoding() != null) {
                                                encoding = fromVar.getByteEncoding();
                                            }
                                            System.arraycopy(colKeyValue.getBytes(encoding), col.getOffset(j), dat, runningOffset, col.getLength(j));
                                        }
                                        catch (UnsupportedEncodingException e) {
                                            VDB.LogAndThrowException(PGM + "rewrite(): " + ": Unsupported Encoding for '" + col.getName() + "' (table name " + this.sqlTableName + ") because " + e.getMessage() + "SQLState : " + e.getMessage(), true);
                                        }
                                    } else {
                                        System.arraycopy(data, col.getOffset(j), dat, runningOffset, col.getLength(j));
                                    }
                                    runningOffset += col.getLength(j);
                                }
                                this.resultSet.updateBytes(i + 1, dat);
                            }
                            break;
                        }
                        default: {
                            this.assertVDB(false, "unknown Filetype " + (Object)((Object)this.fileType));
                            return true;
                        }
                    }
                    this.resultSet.updateRow();
                    numOfRowsUpdated = 1;
                    if (this.record2 != null) {
                        if (this.readState == READSTATE.READNEXT_ASC || this.readState == READSTATE.READPREV_DESC || this.readState == READSTATE.READRAND) {
                            this.resultSet.next();
                        } else {
                            this.resultSet.previous();
                        }
                    } else {
                        this.resultSet.next();
                    }
                }
                catch (SQLFeatureNotSupportedException e) {
                    numOfRowsUpdated = 0;
                }
                catch (SQLException e) {
                    this.closeResultSet();
                    this.setIOStatus(-23);
                    VDB.Logit("file status=" + (this.fileStatus == null ? "ERROR_INVALID_KEY_RANDOM_RECORD_MISSING" : this.fileStatus.toText()) + ". Record cannot be rewritten. " + e.getMessage(), "rewrite(): ");
                    this.readState = READSTATE.ERROR;
                    return true;
                }
            }
        }
        if (numOfRowsUpdated == 0) {
            try {
                PreparedStatement prepStmt = this.fillStatementParameterValues("REWRITE", 0, fromVar);
                String keyName = this.getIdxName(this.keyArray[0]);
                if (this.doesEbcdicColumnExist(keyName)) {
                    if (keyName.toLowerCase().startsWith("ci_")) {
                        String colKeyValue = new String(this.getKeyData(this.keyArray[0]), StandardCharsets.ISO_8859_1);
                        byte[] originalKeyEbcdic = colKeyValue.getBytes(Charset.forName("Cp277"));
                        prepStmt.setBytes(this.columns.size() + 1, originalKeyEbcdic);
                    } else {
                        prepStmt.setBytes(this.columns.size() + 1, this.getKeyData(this.keyArray[0]));
                    }
                } else {
                    prepStmt.setBytes(this.columns.size() + 1, this.getKeyData(this.keyArray[0]));
                }
                if (isDisableCursorsLocal && BATCH_UPDATE_THRESHOLD > 0) {
                    if (this.rewritePreparedStmt == null) {
                        this.rewritePreparedStmt = prepStmt;
                    } else if (this.rewritePreparedStmt != prepStmt) {
                        throw new IllegalStateException("While in rewrite batching mode, different prepared statement instances encountered which is a signal of issue");
                    }
                    prepStmt.addBatch();
                    numOfRowsUpdated = 1;
                    ++this.rewriteBuffer;
                    if (this.rewriteBuffer >= BATCH_UPDATE_THRESHOLD) {
                        int[] rowsUpdated = prepStmt.executeBatch();
                        int totRowsUpdated = IntStream.of(rowsUpdated).sum();
                        this.conn.commit();
                        this.rewriteBuffer = 0;
                        numOfRowsUpdated = totRowsUpdated == BATCH_UPDATE_THRESHOLD ? 1 : 0;
                    }
                } else {
                    numOfRowsUpdated = prepStmt.executeUpdate();
                    if (!(this.BuffSize <= 0 || this.buffering++ % (long)this.BuffSize != 0L && numOfRowsUpdated <= this.BuffSize || this.conn.getAutoCommit())) {
                        this.conn.commit();
                        this.buffering += (long)(numOfRowsUpdated - 1);
                    }
                }
            }
            catch (SQLException e) {
                this.closeResultSet();
                VDB.LogAndThrowException(PGM + "rewrite(): " + ": Cannot retrieve data into variable for '" + this.getFilteredFilename() + "' Because: " + e.getMessage(), true);
            }
        }
        if (numOfRowsUpdated == 0) {
            this.setIOStatus(-23);
            VDB.Logit("file status=" + (this.fileStatus == null ? "ERROR_INVALID_KEY_RANDOM_RECORD_MISSING" : this.fileStatus.toText()) + ". No record rewritten because no record is found. ", "rewrite(): ");
            this.warning("update", "invalid key, random record missing");
            return true;
        }
        this.setIOStatus(0);
        return false;
    }

    public boolean processDeleteWhenOperChanged() throws RuntimeException {
        String func = ".processDeleteWhenOperChanged(): ";
        boolean isDisableCursorsLocal = this.isDisableCursorCompatible && DISABLE_SQLCURSORS;
        try {
            if (isDisableCursorsLocal && BATCH_UPDATE_THRESHOLD > 0) {
                if (this.deletePreparedStmt != null && this.deleteBuffer > 0) {
                    int[] rowsUpdated = this.deletePreparedStmt.executeBatch();
                    int totRowsDeleted = IntStream.of(rowsUpdated).sum();
                    if (totRowsDeleted != this.deleteBuffer) {
                        throw new SQLException("At least one of the deletes in the batch deleted more than 1 record, which is not expected");
                    }
                    this.deleteBuffer = 0;
                    this.deletePreparedStmt = null;
                }
                if (!this.conn.getAutoCommit()) {
                    this.conn.commit();
                }
            }
        }
        catch (SQLException e) {
            this.closeResultSet();
            VDB.LogAndThrowException(PGM + ".processDeleteWhenOperChanged(): " + ": Cannot delete for '" + this.getFilteredFilename() + "' Because: " + e.getMessage(), true);
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public boolean delete() {
        block29: {
            func = ".delete(): ";
            if (this.accessMode == ACCESSMODE.SEQUENTIAL && this.readState != READSTATE.READNEXT_DESC && this.readState != READSTATE.READNEXT_ASC && this.readState != READSTATE.READPREV_DESC && this.readState != READSTATE.READPREV_ASC && this.readState != READSTATE.READRAND) {
                this.setIOStatus(-43);
                VDB.Logit("file status=" + (this.fileStatus == null ? "ERROR_LOGIC_DELETE_NOT_AFTER_READ" : this.fileStatus.toText()) + ". Record cannot be deleted. Previous access to SEQUENTIAL file must be a successful 'READ'.", ".delete(): ");
                this.readState = READSTATE.ERROR;
                this.warning("delete", "invalid operation, delete not after read");
                return true;
            }
            numOfRowsDeleted = 0;
            v0 = isDisableCursorsLocal = this.isDisableCursorCompatible != false && VDB.DISABLE_SQLCURSORS != false;
            if (isDisableCursorsLocal || this.dbms == DBMS.ORACLE || this.dbms == DBMS.DB2 || this.record1 == null || this.readState != READSTATE.READNEXT_DESC && this.readState != READSTATE.READNEXT_ASC && this.readState != READSTATE.READPREV_DESC && this.readState != READSTATE.READPREV_ASC && this.readState != READSTATE.READRAND || !VDB.isEqual(this.getKeyData(this.keyArray[0]), this.primeKey1)) break block29;
            try {
                block30: {
                    if (this.readState != READSTATE.READNEXT_ASC && this.readState != READSTATE.READPREV_DESC) break block30;
                    if (!this.retrieveOneRecord(false, WhichRecord.CURRENT)) {
                        numOfRowsDeleted = 0;
                        break block29;
                    }
                    ** GOTO lbl-1000
                }
                if (!this.retrieveOneRecord(true, WhichRecord.CURRENT)) {
                    numOfRowsDeleted = 0;
                } else lbl-1000:
                // 2 sources

                {
                    this.resultSet.deleteRow();
                    this.record1 = this.record0;
                    this.primeKey1 = null;
                    this.altKey1 = null;
                    numOfRowsDeleted = 1;
                    if (this.readState == READSTATE.READNEXT_ASC || this.readState == READSTATE.READPREV_DESC) {
                        this.retrieveOneRecord(true, WhichRecord.CURRENT);
                    } else {
                        this.retrieveOneRecord(false, WhichRecord.CURRENT);
                    }
                    this.record1 = this.record0;
                }
            }
            catch (SQLFeatureNotSupportedException e) {
                numOfRowsDeleted = 0;
            }
            catch (SQLException e) {
                this.closeResultSet();
                this.setIOStatus(-23);
                VDB.Logit("file status=" + (this.fileStatus == null ? "ERROR_INVALID_KEY_RANDOM_RECORD_MISSING" : this.fileStatus.toText()) + ". Record cannot be deleted. No record found to be deleted. ", ".delete(): ");
                this.readState = READSTATE.ERROR;
                this.warning("delete", "invalid key, random record missing");
                return true;
            }
        }
        if (numOfRowsDeleted == 0) {
            try {
                prepStmt = this.procurePreparedStatement(this.keyNameArray[0], "DELETE", 0);
                if (this.fileType == FILETYPE.INDEXED) {
                    if (this.doesEbcdicColumnExist(this.keyNameArray[0])) {
                        keyColumn = null;
                        keyColumn = this.keyNameArray[0].toLowerCase().startsWith("ci_") != false ? this.keyNameArray[0] : this.getEbcdicColumnEquivalent(this.keyNameArray[0]);
                        if (keyColumn != null && keyColumn.toLowerCase().startsWith("ci_")) {
                            colKeyValue = new String(this.getKeyData(this.keyArray[0]), StandardCharsets.ISO_8859_1);
                            originalKeyEbcdic = colKeyValue.getBytes(Charset.forName("Cp277"));
                            prepStmt.setBytes(1, originalKeyEbcdic);
                        } else {
                            prepStmt.setBytes(1, this.getKeyData(this.keyArray[0]));
                        }
                    } else {
                        prepStmt.setBytes(1, this.getKeyData(this.keyArray[0]));
                    }
                } else {
                    prepStmt.setInt(1, this.keyArray[0].toInt());
                }
                if (isDisableCursorsLocal && VDB.BATCH_UPDATE_THRESHOLD > 0) {
                    if (this.deletePreparedStmt == null) {
                        this.deletePreparedStmt = prepStmt;
                    } else if (this.deletePreparedStmt != prepStmt) {
                        throw new IllegalStateException("While in delete batching mode, different prepared statement instances encountered which is a signal of issue");
                    }
                    prepStmt.addBatch();
                    numOfRowsDeleted = 1;
                    ++this.deleteBuffer;
                    if (this.deleteBuffer >= VDB.BATCH_UPDATE_THRESHOLD) {
                        rowsUpdated = prepStmt.executeBatch();
                        totRowsUpdated = IntStream.of(rowsUpdated).sum();
                        this.conn.commit();
                        this.deleteBuffer = 0;
                        numOfRowsDeleted = totRowsUpdated == VDB.BATCH_UPDATE_THRESHOLD ? 1 : (totRowsUpdated > VDB.BATCH_UPDATE_THRESHOLD ? 2 : 0);
                    }
                } else {
                    numOfRowsDeleted = prepStmt.executeUpdate();
                    if (!(this.BuffSize <= 0 || this.buffering++ % (long)this.BuffSize != 0L && numOfRowsDeleted <= this.BuffSize || this.conn.getAutoCommit())) {
                        this.conn.commit();
                        this.buffering += (long)(numOfRowsDeleted - 1);
                    }
                }
            }
            catch (SQLException e) {
                this.closeResultSet();
                VDB.LogAndThrowException(VDB.PGM + ".delete(): " + ": Cannot delete for '" + this.getFilteredFilename() + "' Because: " + e.getMessage(), true);
            }
        }
        if (numOfRowsDeleted == 0) {
            this.setIOStatus(-23);
            VDB.Logit("file status=" + (this.fileStatus == null ? "ERROR_INVALID_KEY_RANDOM_RECORD_MISSING" : this.fileStatus.toText()) + ". No record is deleted because no record is found. ", ".delete(): ");
            this.warning("delete", "invalid key, random record missing");
            return true;
        }
        if (numOfRowsDeleted > 1) {
            this.setIOStatus(-90);
            VDB.Logit("file status=" + (this.fileStatus == null ? "ERROR_OTHER" : this.fileStatus.toText()) + ". More than 1 record deleted, which should not happen. " + numOfRowsDeleted + " records were deleted. ", ".delete(): ");
            this.readState = READSTATE.ERROR;
            return true;
        }
        if (!isDisableCursorsLocal) {
            this.resultSetInvalidated = true;
            if (this.record2 != null || this.readState != READSTATE.READNEXT_DESC && this.readState != READSTATE.READNEXT_ASC && this.readState != READSTATE.READPREV_DESC && this.readState != READSTATE.READPREV_ASC) {
                this.record2 = null;
                this.record1 = null;
                this.record0 = null;
                this.primeKey2 = null;
                this.primeKey1 = null;
                this.readState = READSTATE.OPEN;
            }
        }
        this.setIOStatus(0);
        return false;
    }

    public boolean delete(Variable keyVar, byte[] keyData, int mode, boolean generic) {
        String func = ".delete(): ";
        int numOfRowsDeleted = 0;
        try {
            String keyLenStr;
            int keyLen;
            String keyName = this.closestIdxName(keyVar);
            if (keyName == null) {
                if (LOGVDB) {
                    System.out.println(PGM + ".delete(): " + ": keyName is null. Exiting with ERROR_INVALID_KEY_RANDOM_RECORD_MISSING");
                }
                this.setIOStatus(-23);
                return true;
            }
            Matcher matcher = IDXCOL_LENGTH_PATTERN.matcher(keyName.trim());
            if (matcher.matches() && (keyLen = Integer.parseInt(keyLenStr = matcher.group(1))) < keyData.length) {
                keyData = Arrays.copyOf(keyData, keyLen);
                if (LOGVDB) {
                    System.out.println(PGM + ".delete(): " + ": The length of keyData is greater than key length. Key column is " + keyName);
                    System.out.println("keyData is being truncated to key column length of " + keyLenStr);
                }
            }
            Statement stmt = null;
            PreparedStatement prepStmt = null;
            if (generic) {
                byte[] byteKeyData;
                stmt = this.conn.createStatement();
                String delsqlstmt = this.makeStatement(keyName, "DELETE GENERIC", 3);
                if (this.doesEbcdicColumnExist(keyName) && this.fileType == FILETYPE.INDEXED) {
                    String colKeyValue = new String(keyData, StandardCharsets.ISO_8859_1);
                    byteKeyData = colKeyValue.getBytes(Charset.forName("Cp277"));
                } else {
                    byteKeyData = keyData;
                }
                if (LOGVDB) {
                    System.out.println("Generic Delete");
                    System.out.println("Key Name: " + keyName);
                    System.out.println(PGM + ".delete(): " + ": prepStmt.setBytes(1, <hex representation of byte array next line>)");
                    System.out.println(DatatypeConverter.printHexBinary((byte[])byteKeyData));
                }
                if (this.dbms == DBMS.SQLSERVER) {
                    String keyByteLen = Integer.toString(byteKeyData.length);
                    delsqlstmt = delsqlstmt.replaceFirst(keyName, "substring(" + keyName + ",1," + keyByteLen + ")");
                    delsqlstmt = delsqlstmt.replaceFirst("like", "=");
                    delsqlstmt = delsqlstmt.substring(0, delsqlstmt.length() - 1) + " 0x" + DatatypeConverter.printHexBinary((byte[])byteKeyData);
                } else {
                    delsqlstmt = delsqlstmt.substring(0, delsqlstmt.length() - 1) + "'" + new String(byteKeyData) + "%'";
                }
                if (LOGVDB) {
                    System.out.println("PGM + func + query=" + delsqlstmt);
                }
                numOfRowsDeleted = stmt.executeUpdate(delsqlstmt);
            } else {
                byte[] byteKeyData;
                String delsqlstmt = this.makeStatement(keyName, "DELETE", 0);
                prepStmt = this.conn.prepareStatement(delsqlstmt);
                if (this.doesEbcdicColumnExist(keyName) && this.fileType == FILETYPE.INDEXED) {
                    String colKeyValue = new String(keyData, StandardCharsets.ISO_8859_1);
                    byteKeyData = colKeyValue.getBytes(Charset.forName("Cp277"));
                    prepStmt.setBytes(1, byteKeyData);
                    if (LOGVDB) {
                        System.out.println("Column: " + keyName);
                        System.out.println(PGM + ".delete(): " + ": browseStmt.setBytes(1, <hex representation of byte array next line>)");
                        System.out.println(DatatypeConverter.printHexBinary((byte[])byteKeyData));
                    }
                } else {
                    byteKeyData = keyData;
                    prepStmt.setBytes(1, keyData);
                }
                if (LOGVDB) {
                    System.out.println("Key Name: " + keyName);
                    System.out.println(PGM + ".delete(): " + ": prepStmt.setBytes(1, <hex representation of byte array next line>)");
                    System.out.println(DatatypeConverter.printHexBinary((byte[])byteKeyData));
                }
                numOfRowsDeleted = prepStmt.executeUpdate();
            }
            if (!(this.BuffSize <= 0 || this.buffering++ % (long)this.BuffSize != 0L && numOfRowsDeleted <= this.BuffSize || this.conn.getAutoCommit())) {
                this.conn.commit();
                this.buffering += (long)(numOfRowsDeleted - 1);
            }
            if (stmt != null) {
                stmt.close();
            }
            if (prepStmt != null) {
                prepStmt.close();
            }
            if (this.BuffSize > 0 && !this.conn.getAutoCommit()) {
                this.conn.commit();
            }
        }
        catch (SQLException e) {
            this.closeResultSet();
            VDB.LogAndThrowException(PGM + ".delete(): " + ": Cannot delete for '" + this.getFilteredFilename() + "' Because: " + e.getMessage(), true);
        }
        if (numOfRowsDeleted == 0) {
            this.setIOStatus(-23);
            VDB.Logit("file status=" + (this.fileStatus == null ? "ERROR_INVALID_KEY_RANDOM_RECORD_MISSING" : this.fileStatus.toText()) + ". No record is deleted because no record is found. ", ".delete(): ");
            this.warning("delete", "invalid key, random record missing");
            return true;
        }
        this.setIOStatus(0);
        return false;
    }

    public synchronized int priorError() {
        return this.getPriorError();
    }

    public final int getPriorError() {
        if (this.priorErrorCode > 0) {
            return -this.priorErrorCode;
        }
        return this.priorErrorCode;
    }

    public final void setPriorError(int priorError) {
        this.priorErrorCode = priorError;
    }

    public final int setIOStatus(int status) {
        char[] smallChar = new char[]{'0', '0'};
        if ((status = status < 0 ? -status : 0) == 9) {
            status = 0;
        }
        this.setPriorError(status);
        if (this.fileStatus != null) {
            if (status == 0) {
                this.fileStatus.moveZeroes();
            } else if (status < 10) {
                smallChar[1] = (char)(status + 48);
                this.fileStatus.move(smallChar);
            } else {
                this.fileStatus.move(status);
            }
        }
        return status;
    }

    public final int setIOStatus(String x) {
        int status = 0;
        try {
            status = Integer.decode(x);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.setIOStatus(-status);
    }

    public synchronized boolean isOK() {
        int priorErrorCode = this.getPriorError();
        return priorErrorCode > -10 && priorErrorCode < 10;
    }

    public static boolean ThrowExceptions(Boolean pleaseDo) {
        if (pleaseDo != null) {
            THROWEXCEPTIONS = pleaseDo;
            TECHECKED = true;
        }
        return THROWEXCEPTIONS;
    }

    public byte[] extractKey(int num, byte[] record) {
        if (this.keyNameArray == null || num < 0 || num > this.keyNameArray.length || record == null) {
            return null;
        }
        String[] offlen = this.keyNameArray[num].substring(this.keyNameArray[num].indexOf("idx") + 3).split("_");
        if (offlen.length != 2) {
            return null;
        }
        int off = 0;
        int len = 0;
        try {
            off = Integer.parseInt(offlen[0]);
            len = Integer.parseInt(offlen[1]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (off < 0 || off + len > record.length) {
            return null;
        }
        byte[] ret = new byte[len];
        System.arraycopy(record, off, ret, 0, len);
        return ret;
    }

    public static SqlConnections getGlobalSqlConnections() {
        if (GlobalSqlConnections == null) {
            GlobalSqlConnections = new SqlConnections();
        }
        return GlobalSqlConnections;
    }

    public static boolean isEqual(Object d1, Object d2) {
        if (d1 instanceof byte[] && d2 instanceof byte[]) {
            byte[] b1 = (byte[])d1;
            byte[] b2 = (byte[])d2;
            if (b1 == null || d2 == null || b1.length != b2.length) {
                return false;
            }
            for (int i = 0; i < b1.length; ++i) {
                if (b1[i] == b2[i]) continue;
                return false;
            }
            return true;
        }
        if (d1 instanceof Integer && d2 instanceof Integer) {
            Integer i1 = (Integer)d1;
            Integer i2 = (Integer)d2;
            return i1.intValue() == i2.intValue();
        }
        return false;
    }

    public boolean isKeyInRecordEqual(int keyNum, byte[] d1, byte[] d2) {
        if (this.fileType != FILETYPE.INDEXED) {
            return true;
        }
        if (keyNum >= this.keyArray.length) {
            return false;
        }
        String[] offLen = this.keyNameArray[keyNum].substring(this.keyNameArray[keyNum].indexOf("idx") + 3).split("_");
        int start = Integer.parseInt(offLen[0]);
        int end = start + Integer.parseInt(offLen[1]);
        for (int i = start; i < end; ++i) {
            if (d1[i] == d2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean isKeyExternal(Variable key, Variable record) {
        int ra;
        if (key.getMemory() != record.getMemory()) {
            return true;
        }
        int ka = key.getAddress();
        return ka < (ra = record.getAddress()) || ka >= ra + record.getLength();
    }

    public static void Logit(String str, String methodName) {
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.info(PGM + methodName + ": " + str);
        } else if (LOGVDB) {
            System.out.println(PGM + methodName + ": " + str);
        }
    }

    public static void LogAndThrowException(String msg, boolean forceThrow) {
        VDB.Logit(msg, "");
        if (THROWEXCEPTIONS || forceThrow) {
            throw new RuntimeException(msg);
        }
    }

    public void begin() {
    }

    public void commit() {
        try {
            if (this.conn != null && !this.conn.isClosed() && !this.conn.getAutoCommit()) {
                this.conn.commit();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void rollback() {
        try {
            if (this.conn != null && !this.conn.isClosed() && !this.conn.getAutoCommit()) {
                this.conn.rollback();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void recover() {
    }

    public int assertVDB(boolean test, String message) {
        String func = ".assertVDB(): ";
        if (!test) {
            this.setIOStatus(-90);
            this.readState = READSTATE.ERROR;
            this.closeResultSet();
            VDB.LogAndThrowException(PGM + ".assertVDB(): " + ": VDB subsystem internal error. Problem related to processing database table for COBOL I/O Operation. " + message, false);
            return -90;
        }
        return 0;
    }

    public static String getConnectionName(Connection con) {
        try {
            DatabaseMetaData md = con.getMetaData();
            return md.getDatabaseProductName();
        }
        catch (Exception e) {
            return UNKNOWN_DB_NAME;
        }
    }

    public static void main(String[] args) {
        System.out.println("VDB unit test");
        VDB vdb = new VDB();
        String[] components = new String[]{"DB", "SCHEM", "TBL"};
        vdb.constructPossibleTableNames(components);
        System.out.print("constructTableNames={");
        boolean comma = false;
        for (String aStr : vdb.candidateSqlTableNames) {
            if (comma) {
                System.out.print(",");
            }
            System.out.print(aStr);
            comma = true;
        }
        System.out.println("}");
        components = new String[]{"DB", "SCHEM", "TBL", "DAT"};
        vdb.constructPossibleTableNames(components);
        System.out.print("constructTableNames={");
        comma = false;
        for (String aStr : vdb.candidateSqlTableNames) {
            if (comma) {
                System.out.print(",");
            }
            System.out.print(aStr);
            comma = true;
        }
        System.out.println("}");
        components = new String[]{"HCI00", "TBL", "DAT"};
        vdb.constructPossibleTableNames(components);
        System.out.print("constructTableNames={");
        comma = false;
        for (String aStr : vdb.candidateSqlTableNames) {
            if (comma) {
                System.out.print(",");
            }
            System.out.print(aStr);
            comma = true;
        }
        System.out.println("}");
        components = new String[]{"A", "B", "C", "D", "E"};
        vdb.constructPossibleTableNames(components);
        System.out.print("constructTableNames={");
        comma = false;
        for (String aStr : vdb.candidateSqlTableNames) {
            if (comma) {
                System.out.print(",");
            }
            System.out.print(aStr);
            comma = true;
        }
        System.out.println("}");
        components = new String[]{"ONETBLNAME"};
        vdb.constructPossibleTableNames(components);
        System.out.print("constructTableNames={");
        comma = false;
        for (String aStr : vdb.candidateSqlTableNames) {
            if (comma) {
                System.out.print(",");
            }
            System.out.print(aStr);
            comma = true;
        }
        System.out.println("}");
        components = new String[]{"DAT"};
        vdb.constructPossibleTableNames(components);
        System.out.print("constructTableNames={");
        comma = false;
        for (String aStr : vdb.candidateSqlTableNames) {
            if (comma) {
                System.out.print(",");
            }
            System.out.print(aStr);
            comma = true;
        }
        System.out.println("}");
    }

    public void setESDSKey(int _esdsKey) {
        this.esdsKey = _esdsKey;
    }

    public static boolean isEXTENDEDSSA() {
        return EXTENDEDSSA;
    }

    public static void setEXTENDEDSSA(boolean eXTENDEDSSA) {
        EXTENDEDSSA = eXTENDEDSSA;
    }

    private boolean enableThisCursor() {
        boolean enable = false;
        try (InputStream input = VDB.class.getClassLoader().getResourceAsStream("deploy.properties");){
            Properties prop = new Properties();
            if (input == null) {
                System.err.println("Unable to find deploy.properties on classpath");
            } else {
                prop.load(input);
                enable = Boolean.valueOf(prop.getProperty("enable.cursor." + this.sqlTableName));
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return enable;
    }

    static /* synthetic */ byte[] access$102(VDB x0, byte[] x1) {
        x0.record1 = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$602(VDB x0, byte[] x1) {
        x0.record2 = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$902(VDB x0, byte[] x1) {
        x0.record0 = x1;
        return x1;
    }

    static {
        IDXCOL_LENGTH_PATTERN = Pattern.compile("^.*_([0-9]+)$");
        dfsrrc00Class = null;
        dfsrrc00GetInstanceMapMethod = null;
        TECHECKED = false;
    }

    private class DetermineDBNameAndSettings {
        private String func = ".DetermineDBNameAndSettings(): ";
        private String dbmsName;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean invoke() {
            block39: {
                this.func = ".DetermineDBNameAndSettings.invoke(): ";
                try {
                    DatabaseMetaData md = VDB.this.conn.getMetaData();
                    this.dbmsName = md.getDatabaseProductName();
                    VDB.this.dbmsMajorVersion = md.getDatabaseMajorVersion();
                    VDB.this.driverMajorVersion = md.getDriverMajorVersion();
                    VDB.this.supportsSavepoints = (VDB.this.supportsReleaseSavepoints = md.supportsSavepoints());
                }
                catch (SQLException e) {
                    this.dbmsName = VDB.UNKNOWN_DB_NAME;
                    VDB.this.dbmsMajorVersion = 0;
                    VDB.this.supportsSavepoints = false;
                }
                if (this.dbmsName.equals("Oracle") && VDB.this.dbmsMajorVersion >= 9) {
                    VDB.this.supportsReleaseSavepoints = false;
                }
                VDB.this.blobTypeName = (VDB.this.blobTypeNameMax = "BLOB");
                VDB.this.idxTypeName = "BLOB";
                if (this.dbmsName.contains("DB2")) {
                    VDB.this.blobTypeName = (VDB.this.blobTypeNameMax = "varchar(%d) for bit data");
                    VDB.this.idxTypeName = "varchar(%d) for bit data";
                    VDB.this.dbms = DBMS.DB2;
                } else if (this.dbmsName.contains("MySQL")) {
                    VDB.this.blobTypeName = (VDB.this.blobTypeNameMax = "blob");
                    VDB.this.blobTypeMultiplier = 2;
                    VDB.this.idxTypeName = "varbinary(%d)";
                    VDB.this.dbms = DBMS.MYSQL;
                    VDB.this.paginationLimit = FETCHSIZE;
                } else if (this.dbmsName.contains("PostgreSQL")) {
                    VDB.this.blobTypeName = (VDB.this.blobTypeNameMax = "bytea");
                    VDB.this.idxTypeName = "bytea";
                    VDB.this.cascadeOption = " cascade";
                    VDB.this.dbms = DBMS.POSTGRESQL;
                    VDB.this.paginationLimit = FETCHSIZE;
                } else if (this.dbmsName.contains("SQL Server")) {
                    VDB.this.blobTypeName = "varbinary(%d)";
                    VDB.this.blobTypeMaxSize = 8000;
                    VDB.this.blobTypeNameMax = "varbinary(max)";
                    VDB.this.idxTypeName = "varbinary(%d)";
                    VDB.this.dbms = DBMS.SQLSERVER;
                    VDB.this.supportsReleaseSavepoints = false;
                    VDB.this.topClause = "top (100) percent";
                    VDB.this.paginationLimit = FETCHSIZE;
                } else if (this.dbmsName.contains("Oracle")) {
                    VDB.this.blobTypeName = (VDB.this.blobTypeNameMax = "long raw");
                    VDB.this.idxTypeName = "raw(%d)";
                    VDB.this.dbms = DBMS.ORACLE;
                } else if (this.dbmsName.contains("H2")) {
                    VDB.this.blobTypeName = (VDB.this.blobTypeNameMax = "blob");
                    VDB.this.idxTypeName = "raw(%d)";
                    VDB.this.dbms = DBMS.H2;
                } else if (this.dbmsName.contains("Derby")) {
                    VDB.this.blobTypeName = (VDB.this.blobTypeNameMax = "blob");
                    VDB.this.idxTypeName = "varchar(%d)";
                    VDB.this.dbms = DBMS.DERBY;
                } else if (this.dbmsName.contains("Splice")) {
                    VDB.this.blobTypeName = (VDB.this.blobTypeNameMax = "blob");
                    VDB.this.idxTypeName = "varchar(%d)";
                    VDB.this.dbms = DBMS.SPLICE;
                } else if (this.dbmsName.contains("Hive")) {
                    VDB.this.blobTypeName = (VDB.this.blobTypeNameMax = "varchar(%d)");
                    VDB.this.idxTypeName = "varchar(%d)";
                    VDB.this.notNullPrimaryKeyOption = "";
                    VDB.this.dbms = DBMS.HIVE;
                } else {
                    VDB.this.dbms = DBMS.UNKNOWN;
                    try {
                        ResultSet types = VDB.this.conn.getMetaData().getTypeInfo();
                        while (types.next()) {
                            short data_type = types.getShort("DATA_TYPE");
                            if (data_type == 2004) {
                                VDB.this.idxTypeName = (VDB.this.blobTypeName = (VDB.this.blobTypeNameMax = types.getString("TYPE_NAME")));
                                continue;
                            }
                            if (data_type == -4) {
                                VDB.this.idxTypeName = (VDB.this.blobTypeName = (VDB.this.blobTypeNameMax = types.getString("TYPE_NAME")));
                                continue;
                            }
                            if (data_type == -3) {
                                VDB.this.blobTypeName = (VDB.this.blobTypeNameMax = types.getString("TYPE_NAME"));
                                if (VDB.this.blobTypeName.contains("(): ")) {
                                    VDB.this.idxTypeName = (VDB.this.blobTypeName = (VDB.this.blobTypeNameMax = VDB.this.blobTypeName.replace("()", "(%d)")));
                                    continue;
                                }
                                VDB.this.idxTypeName = (VDB.this.blobTypeName = (VDB.this.blobTypeNameMax = VDB.this.blobTypeNameMax + "(%d)"));
                                continue;
                            }
                            if (data_type != -2) continue;
                            VDB.this.blobTypeName = (VDB.this.blobTypeNameMax = types.getString("TYPE_NAME"));
                        }
                        if (!VDB.this.conn.getAutoCommit()) {
                            VDB.this.conn.commit();
                        }
                        types.close();
                    }
                    catch (SQLException e) {
                        String why = e.getMessage();
                        if (LogSetup.IS_LOGGING) {
                            LogSetup.LOGGER.finer(PGM + this.func + "SQLException=" + why);
                        }
                        if (!LOGVDB) break block39;
                        System.out.println(PGM + this.func + "SQLException=" + why);
                    }
                }
            }
            if (VDB.this.numberOfKeys > 0 && VDB.this.keyNameArray[0].equals("rel")) {
                VDB.this.idxTypeName = "integer";
                return false;
            }
            if (VDB.this.numberOfKeys > 0 && VDB.this.keyNameArray[0].equals("seq")) {
                if (this.dbmsName.contains("DB2")) {
                    VDB.this.blobTypeName = "varchar(%d) for bit data";
                    VDB.this.idxTypeName = "integer generated always as identity";
                    return false;
                }
                if (this.dbmsName.contains("MySQL")) {
                    VDB.this.blobTypeName = "blob";
                    VDB.this.idxTypeName = "serial";
                    return false;
                }
                if (this.dbmsName.contains("PostgreSQL")) {
                    VDB.this.blobTypeName = "bytea";
                    VDB.this.idxTypeName = "serial";
                    return false;
                }
                if (this.dbmsName.contains("SQL Server")) {
                    VDB.this.blobTypeName = "varbinary(%d)";
                    VDB.this.blobTypeMaxSize = 8000;
                    VDB.this.blobTypeNameMax = "varbinary(max)";
                    VDB.this.idxTypeName = "int identity(1,1)";
                    return false;
                }
                if (this.dbmsName.contains("Oracle") && VDB.this.dbmsMajorVersion >= 12) {
                    VDB.this.blobTypeName = "blob";
                    VDB.this.idxTypeName = "number generated always as identity";
                    return false;
                }
                VDB.this.idxTypeName = "get_a_database_that_supports_identity_columns";
                if (this.dbmsName.contains("Oracle")) {
                    VDB.this.setIOStatus(-35);
                    VDB.this.warning("open", "cannot create LINEAR (ESDS) table in this DB version");
                    VDB.this.readState = READSTATE.ERROR;
                    VDB.LogAndThrowException(PGM + this.func + ": Cannot create LINEAR (entry sequenced record dataset) tables for this database '" + this.dbmsName + "', requires Oracle 12C or higher for 'identity' columns.", false);
                    return true;
                }
                VDB.this.setIOStatus(-35);
                VDB.this.warning("open", "cannot create LINEAR (ESDS) table in this DB version");
                VDB.this.readState = READSTATE.ERROR;
                VDB.LogAndThrowException(PGM + this.func + ": Cannot create LINEAR (entry sequenced record dataset) tables for this database '" + this.dbmsName + "', unknown 'serial' or 'identity' column type.", false);
                return true;
            }
            if (VDB.this.numberOfKeys > 0 && VDB.this.keyNameArray[0].startsWith("idx")) {
                return false;
            }
            VDB.this.blobTypeName = "blob";
            VDB.this.idxTypeName = "blob";
            return false;
        }
    }

    private static enum WhichRecord {
        CURRENT{

            @Override
            void resetRecordValues(VDB instance) {
                VDB.access$102(instance, null);
                instance.primeKey1 = null;
                instance.altKey1 = null;
            }

            @Override
            void getRecordData(VDB instance) throws SQLException {
                VDB.access$102(instance, instance.resultSet.getBytes(1));
            }

            @Override
            void getPrimeKey(VDB instance) throws SQLException {
                if (instance.dbms == DBMS.SPLICE) {
                    instance.primeKey1 = instance.resultSet.getCharacterStream(2);
                } else {
                    instance.primeKey1 = instance.resultSet.getBytes(2);
                }
            }

            @Override
            void getRelativePrimeKey(VDB instance) throws SQLException {
                instance.primeKey1 = new Integer(instance.resultSet.getInt(2));
            }

            @Override
            void getAlternateKey(VDB instance) throws SQLException {
                if (instance.dbms == DBMS.SPLICE) {
                    instance.altKey1 = instance.resultSet.getCharacterStream(instance.currentKeyNumber + 2);
                } else {
                    instance.altKey1 = instance.resultSet.getBytes(instance.currentKeyNumber + 2);
                }
            }
        }
        ,
        NEXT{

            @Override
            void resetRecordValues(VDB instance) {
                VDB.access$602(instance, null);
                instance.primeKey2 = null;
                instance.altKey2 = null;
            }

            @Override
            void getRecordData(VDB instance) throws SQLException {
                VDB.access$602(instance, instance.resultSet.getBytes(1));
            }

            @Override
            void getPrimeKey(VDB instance) throws SQLException {
                if (instance.dbms == DBMS.SPLICE) {
                    instance.primeKey2 = instance.resultSet.getCharacterStream(2);
                } else {
                    instance.primeKey2 = instance.resultSet.getBytes(2);
                }
            }

            @Override
            void getRelativePrimeKey(VDB instance) throws SQLException {
                instance.primeKey2 = new Integer(instance.resultSet.getInt(2));
            }

            @Override
            void getAlternateKey(VDB instance) throws SQLException {
                if (instance.dbms == DBMS.SPLICE) {
                    instance.altKey2 = instance.resultSet.getCharacterStream(instance.currentKeyNumber + 2);
                } else {
                    instance.altKey2 = instance.resultSet.getBytes(instance.currentKeyNumber + 2);
                }
            }
        }
        ,
        PREVIOUS{

            @Override
            void resetRecordValues(VDB instance) {
                VDB.access$902(instance, null);
            }

            @Override
            void getRecordData(VDB instance) throws SQLException {
                VDB.access$902(instance, instance.resultSet.getBytes(1));
            }

            @Override
            void getPrimeKey(VDB instance) throws SQLException {
                instance.assertVDB(true, "getPrimeKey called on previous record, not expected");
            }

            @Override
            void getRelativePrimeKey(VDB instance) throws SQLException {
            }

            @Override
            void getAlternateKey(VDB instance) throws SQLException {
                instance.assertVDB(true, "getAlternateKey called on previous record, not expected");
            }
        };


        abstract void resetRecordValues(VDB var1);

        abstract void getRecordData(VDB var1) throws SQLException;

        abstract void getPrimeKey(VDB var1) throws SQLException;

        abstract void getRelativePrimeKey(VDB var1) throws SQLException;

        abstract void getAlternateKey(VDB var1) throws SQLException;
    }
}

