/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.isamsql;

import com.heirloomcomputing.ecs.exec.LogSetup;
import com.heirloomcomputing.ecs.exec.Numeric;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.exec.seqFile;
import com.heirloomcomputing.ecs.isamsql.ACCESSMODE;
import com.heirloomcomputing.ecs.isamsql.FILETYPE;
import com.heirloomcomputing.ecs.isamsql.OPENMODE;
import com.heirloomcomputing.ecs.isamsql.READSTATE;
import com.heirloomcomputing.ecs.isamsql.VDB;
import java.sql.Connection;
import java.sql.SQLException;

public class VDBSequentialFile
extends seqFile {
    VDB vdb = null;
    private VDBSequentialFile externalFile = null;
    public boolean forgottenEndDeclare = true;

    public VDBSequentialFile() {
        this.vdb = new VDB("VDBSequentialFile");
    }

    public VDBSequentialFile(VDBSequentialFile cpy) {
        this.vdb = new VDB(cpy.vdb);
        this.externalFile = cpy.externalFile;
        this.file = cpy.file;
    }

    @Override
    public VDBSequentialFile clone() {
        return new VDBSequentialFile(this);
    }

    @Override
    public String toString() {
        try {
            String linesep = System.getProperty("line.separator");
            if (linesep == null) {
                linesep = "\n";
            }
            StringBuffer result = new StringBuffer();
            result.append("VDBSequentialFile instance").append(linesep);
            result.append("PROTOCOL IS VDB (ESDS)").append(linesep);
            result.append("ORGANIZATION IS SEQUENTIAL").append(linesep);
            result.append(this.vdb.toString());
            if (this.file != null) {
                result.append("ASSIGN TO \"").append(this.getFilename()).append("\"").append(linesep);
            }
            result.append((this.externalFile != null ? "" : "NOT-") + "EXTERNAL").append(linesep);
            return result.toString();
        }
        catch (RuntimeException t) {
            return "SEQUENTIAL FILE";
        }
    }

    @Override
    public seqFile declare(boolean optional, Variable filenameVariable, int reserve, Variable paddingId, char paddingChar, Variable fileStatus, int blockFrom, int blockTo, boolean isRecords, int recordFrom, int recordTo, Variable dependingOn, boolean isLabelRecordsOmitted, Variable linageId, int linage, Variable footingId, int footing, Variable topId, int top, Variable bottomId, int bottom, String codeSet, int newModes) {
        this.newModes = newModes;
        return this.declare(optional, filenameVariable, reserve, paddingId, paddingChar, fileStatus, blockFrom, blockTo, isRecords, recordFrom, recordTo, dependingOn, isLabelRecordsOmitted, linageId, linage, footingId, footing, topId, top, bottomId, bottom, codeSet);
    }

    @Override
    public seqFile declare(boolean optional, Variable filenameVariable, int reserve, Variable paddingId, char paddingChar, Variable fileStatus, int blockFrom, int blockTo, boolean isRecords, int recordFrom, int recordTo, Variable dependingOn, boolean isLabelRecordsOmitted, Variable linageId, int linage, Variable footingId, int footing, Variable topId, int top, Variable bottomId, int bottom, String codeSet) {
        String assignTo = null;
        this.filenameVariable = filenameVariable;
        if (filenameVariable != null) {
            assignTo = filenameVariable.toString();
        }
        return this.declare(optional, assignTo, reserve, paddingId, paddingChar, fileStatus, blockFrom, blockTo, isRecords, recordFrom, recordTo, dependingOn, isLabelRecordsOmitted, linageId, linage, footingId, footing, topId, top, bottomId, bottom, codeSet);
    }

    @Override
    public seqFile declare(boolean optional, String assignTo, int reserve, Variable paddingId, char paddingChar, Variable fileStatus, int blockFrom, int blockTo, boolean isRecords, int recordFrom, int recordTo, Variable dependingOn, boolean isLabelRecordsOmitted, Variable linageId, int linage, Variable footingId, int footing, Variable topId, int top, Variable bottomId, int bottom, String codeSet, int newModes) {
        this.newModes = newModes;
        return this.declare(optional, assignTo, reserve, paddingId, paddingChar, fileStatus, blockFrom, blockTo, isRecords, recordFrom, recordTo, dependingOn, isLabelRecordsOmitted, linageId, linage, footingId, footing, topId, top, bottomId, bottom, codeSet);
    }

    @Override
    public seqFile declare(boolean optional, String assignTo, int reserve, Variable paddingId, char paddingChar, Variable fileStatus, int blockFrom, int blockTo, boolean isRecords, int recordFrom, int recordTo, Variable dependingOn, boolean isLabelRecordsOmitted, Variable linageId, int linage, Variable footingId, int footing, Variable topId, int top, Variable bottomId, int bottom, String codeSet) {
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer("Hello. ");
        }
        if (recordTo < 0) {
            recordTo = -1;
        }
        if (recordFrom < 0) {
            recordFrom = -1;
        }
        if (recordFrom < 0 && recordTo >= 0) {
            recordFrom = recordTo;
        }
        if (recordTo < 0 && recordFrom >= 0) {
            recordTo = recordFrom;
        }
        if (recordFrom > this.maximum) {
            recordTo = recordFrom;
        }
        this.vdb.fileType = FILETYPE.SEQUENTIAL;
        this.vdb.optional = optional;
        if (assignTo != null && this.vdb.assignTo == null) {
            this.vdb.assignTo = this.aliasFilename(assignTo, true);
        }
        this.fileStatus = this.vdb.fileStatus = fileStatus;
        this.vdb.accessMode = ACCESSMODE.SEQUENTIAL;
        this.vdb.primaryKeyColumn = "seq";
        this.vdb.isKeyDuplicates[0] = false;
        this.vdb.blockFrom = blockFrom;
        this.vdb.blockTo = blockTo;
        this.vdb.isRecords = isRecords;
        this.vdb.recordFrom = recordFrom;
        this.vdb.recordTo = recordTo;
        this.vdb.dependingOn = dependingOn;
        this.vdb.keyNameArray[0] = "seq";
        this.vdb.numberOfKeys = 1;
        return this;
    }

    @Override
    public synchronized boolean isOK() {
        int priorErrorCode = this.vdb.getPriorError();
        return priorErrorCode > -10 && priorErrorCode < 10;
    }

    @Override
    public synchronized boolean isOpen() {
        return !this.vdb.isOpen(OPENMODE.CLOSED);
    }

    public void executeSql(String sql) {
        this.vdb.execSQL(sql);
    }

    public void setConnection(Connection sqlConnection) {
        String func = ".setConnection()";
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.fine(VDB.PGM + ".setConnection()" + ": Setting existing " + VDB.toString(sqlConnection));
        }
        this.vdb.conn = sqlConnection;
        this.vdb.ETPcontrolledConnection = sqlConnection != null;
    }

    public void swap(Variable older, Variable newer) {
        this.vdb.swap(older, newer);
    }

    @Override
    public synchronized seqFile endDeclare() {
        this.vdb.sortKeys();
        this.vdb.filteredFilename = this.vdb.getFilteredFilename();
        if (!this.vdb.initFile()) {
            this.file = null;
            if (this.vdb.fileStatus != null) {
                this.vdb.fileStatus.move(-92);
            }
        }
        return this;
    }

    public void resetDefaultAndGlobalFetchSize(int fetchSize) {
        this.vdb.resetDefaultAndGlobalFetchSize(fetchSize);
    }

    @Override
    public boolean fixed() {
        return this.vdb.recordFrom == this.vdb.recordTo;
    }

    @Override
    public boolean variable() {
        return this.vdb.recordFrom != this.vdb.recordTo;
    }

    @Override
    public void setFilename(String assignToParm) {
        this.vdb.assignTo = assignToParm;
    }

    @Override
    public synchronized boolean open(int mode) {
        if (this.forgottenEndDeclare) {
            this.forgottenEndDeclare = false;
            this.endDeclare();
        }
        String func = ".open()";
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer(VDB.PGM + ".open()" + ": on [" + this.vdb.toDesc() + "].");
        }
        return this.vdb.open(mode);
    }

    @Override
    public synchronized boolean openTimeoutSeconds(int mode, Numeric timeout) {
        String func = ".openTimeoutSeconds()";
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer(VDB.PGM + ".openTimeoutSeconds()" + ": on [" + this.vdb.toDesc() + "].");
        }
        return this.vdb.openTimeoutSeconds(mode, timeout);
    }

    @Override
    public synchronized boolean openTimeoutRetries(int mode, Numeric timeout) {
        String func = ".openTimeoutRetries()";
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer(VDB.PGM + ".openTimeoutRetries()" + ": on [" + this.vdb.toDesc() + "].");
        }
        return this.vdb.openTimeoutRetries(mode, timeout);
    }

    @Override
    public synchronized boolean openTimeoutRetries(int mode) {
        return this.vdb.openTimeoutRetries(mode);
    }

    @Override
    public synchronized boolean close() {
        return this.close(0);
    }

    @Override
    public synchronized boolean close(int mode) {
        String func = ".close()";
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer(VDB.PGM + ".close()" + ": on [" + this.vdb.toDesc() + "].");
        }
        return this.vdb.close(mode);
    }

    @Override
    public boolean deleteFile() {
        String func = ".deleteFile()";
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer(VDB.PGM + ".deleteFile()" + ": on [" + this.vdb.toDesc() + "].");
        }
        return this.vdb.deleteFile();
    }

    @Override
    public boolean read(Variable intoVar, int mode, Numeric timeout) {
        String func = ".read()";
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer(VDB.PGM + ".read()" + ": on [" + this.vdb.toDesc() + "].");
        }
        if (this.vdb == null || !this.vdb.isOpen(OPENMODE.OPEN_INPUT) && !this.vdb.isOpen(OPENMODE.OPEN_IO)) {
            this.vdb.setIOStatus(-47);
            this.vdb.readState = READSTATE.ERROR;
            return true;
        }
        this.vdb.readMode = mode >> 8;
        mode &= 0xFF;
        int fs = 0;
        boolean incrKey = true;
        if (this.vdb.readState == READSTATE.OPEN) {
            fs = this.vdb.startNextPrev(null, 1);
            incrKey = false;
        }
        if (fs > -10) {
            fs = this.vdb.advanceAndRetrieveData(true);
        }
        if (fs <= -10) {
            return true;
        }
        this.vdb.updateIntoVarAndLen(intoVar);
        this.vdb.readState = READSTATE.READNEXT_ASC;
        if (incrKey && this.vdb.esdsKey >= 0) {
            ++this.vdb.esdsKey;
        }
        return false;
    }

    @Override
    public synchronized boolean read(Variable intoVar) {
        return this.read(intoVar, 0, null);
    }

    @Override
    public synchronized boolean readNext(Variable intoVar, int mode, Numeric timeout) {
        this.vdb.browsing = true;
        return this.read(intoVar, mode, timeout);
    }

    @Override
    public synchronized boolean readNext(Variable intoVar) {
        return this.readNext(intoVar, 0, null);
    }

    @Override
    public synchronized boolean readPrevious(Variable intoVar, int mode, Numeric timeout) {
        this.vdb.browsing = true;
        return this.read(intoVar, 0, timeout);
    }

    @Override
    public synchronized boolean readPrevious(Variable intoVar) {
        return this.read(intoVar, 0, null);
    }

    @Override
    public boolean write(Variable fromVar, int mode, Numeric timeout) {
        return this.write(fromVar);
    }

    @Override
    public boolean write(Variable data, int mode, Numeric timeout, boolean printSequential) {
        return this.write(data);
    }

    @Override
    public boolean write(Variable data, boolean printSequential) {
        return this.write(data);
    }

    @Override
    public boolean writeNoControl(Variable data) {
        return this.write(data);
    }

    @Override
    public boolean writeNoControl(Variable data, boolean printSequential) {
        return this.write(data);
    }

    @Override
    public synchronized boolean write(Variable fromVar) {
        String func = VDB.PGM + ".write()";
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer(VDB.PGM + func + ": on [" + this.vdb.toDesc() + "].");
        }
        if (this.vdb == null || !this.vdb.isOpen(OPENMODE.OPEN_OUTPUT) && !this.vdb.isOpen(OPENMODE.OPEN_IO)) {
            this.vdb.setIOStatus(-48);
            return true;
        }
        return this.vdb.insert(fromVar);
    }

    @Override
    public boolean rewrite(Variable data, int mode, Numeric timeout) {
        return this.rewrite(data);
    }

    @Override
    public boolean rewrite(Variable data, int mode, Numeric timeout, boolean printSequential) {
        return this.rewrite(data);
    }

    @Override
    public boolean rewrite(Variable fromVar) {
        String func = ".rewrite()";
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer(VDB.PGM + ".rewrite()" + ": on [" + this.vdb.toDesc() + "].");
        }
        if (this.vdb == null || !this.vdb.isOpen(OPENMODE.OPEN_IO)) {
            this.vdb.setIOStatus(-49);
            return true;
        }
        return this.vdb.update(fromVar);
    }

    @Override
    public synchronized boolean useException() {
        int priorErrorCode = this.vdb.getPriorError();
        if (priorErrorCode < 0) {
            priorErrorCode = -priorErrorCode;
        }
        return priorErrorCode >= 10;
    }

    @Override
    public synchronized int useException(int specific, int input, int output, int io, int extend) {
        if (this.useException()) {
            if (specific >= 0) {
                return specific;
            }
            if (this.isInput()) {
                return input;
            }
            if (this.isOutput()) {
                return output;
            }
            if (this.isIO()) {
                return io;
            }
            if (this.isExtend()) {
                return extend;
            }
        }
        return -1;
    }

    @Override
    public synchronized boolean useAtEnd() {
        int priorErrorCode = this.vdb.getPriorError();
        return priorErrorCode == -10 || priorErrorCode == 10 || priorErrorCode == 14 || priorErrorCode == -14;
    }

    @Override
    public synchronized int useAtEnd(int specific, int input, int output, int io, int extend) {
        if (this.useAtEnd()) {
            if (specific >= 0) {
                return specific;
            }
            if (this.isInput()) {
                return input;
            }
            if (this.isOutput()) {
                return output;
            }
            if (this.isIO()) {
                return io;
            }
            if (this.isExtend()) {
                return extend;
            }
        }
        return -1;
    }

    @Override
    public synchronized int useAtEnd(int specific) {
        if (this.useAtEnd() && specific >= 0) {
            return specific;
        }
        return -1;
    }

    @Override
    public Object getObject() {
        return null;
    }

    @Override
    public seqFile setPassword(Variable identifier) {
        return this;
    }

    public boolean supportsTransactions() {
        if (this.vdb.conn != null) {
            try {
                return !this.vdb.conn.getAutoCommit();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return false;
    }
}

