/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.isamsql;

import com.heirloomcomputing.ecs.exec.CobolException;
import com.heirloomcomputing.ecs.exec.Context;
import com.heirloomcomputing.ecs.exec.IndexedFile;
import com.heirloomcomputing.ecs.exec.LockFile;
import com.heirloomcomputing.ecs.exec.LogSetup;
import com.heirloomcomputing.ecs.exec.Numeric;
import com.heirloomcomputing.ecs.exec.PropertiesUtil;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.SynkronixIndexedFile;
import com.heirloomcomputing.ecs.exec.Utilities;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.exec.VariableList;
import com.heirloomcomputing.ecs.exec.idxFile;
import com.heirloomcomputing.ecs.isamsql.SqlColumn;
import com.heirloomcomputing.ecs.isamsql.SqlConnectionInfo;
import com.heirloomcomputing.ecs.isamsql.SqlConnections;
import com.heirloomcomputing.ecs.isamsql.XmlDatasetLoader;
import com.heirloomcomputing.ecs.util.String2;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;

public class VSQLIndexedFile
extends idxFile {
    private static final String PGM = "VSQLIndexedFile";
    private boolean isConnectionsOpened = false;
    private HashMap<String, Vector<SqlColumn>> dbTables = null;
    private ArrayList<String> xmlFilenames = null;
    private static Properties setupProp = null;
    private static Properties deploy_settings = null;
    private HashMap<String, Connection> tableConns;
    private Hashtable<String, Class<?>> bufferedClasses = new Hashtable();
    public static int BUFFSIZE = -1;
    public int BuffSize = -1;
    public static int FETCHSIZE = 1000;
    private HashMap<String, PreparedStatement> keyToPreparedStatementMap = new HashMap();
    private Vector<SqlColumn> columns = null;
    private String sqlTableName = null;
    private boolean isOpen = false;
    private int openIOMode;
    private boolean isOpenIO;
    private boolean isOpenInput;
    private boolean isOpenOutput;
    private boolean readable;
    private boolean writeable;
    private Connection conn = null;
    private int priorErrorCode = 0;
    private ResultSet resultSet;
    private boolean alreadyDidNext = false;
    private int resultSetRecordNumber;
    private AccessType priorAccessType;
    private boolean defaultMicrofocus = false;
    private boolean defaultAConnect = false;
    private boolean defaultISAM = false;
    private boolean defaultACU = false;
    private boolean defaultAS400 = false;
    private boolean defaultUpdated = false;
    private String[] supportedTypesClasses = new String[]{"com.heirloomcomputing.ecs.exec.MFIndexedFile", "com.heirloomcomputing.ecs.exec.MFIndexedFile", "com.heirloomcomputing.ecs.exec.MFIndexedFile", "com.heirloomcomputing.ecs.exec.AConnectIndexedFile", "com.heirloomcomputing.ecs.exec.AS400IndexedFile", "com.heirloomcomputing.ecs.exec.ISAMIndexedFile", "com.heirloomcomputing.ecs.exec.ISAMIndexedFile", "com.heirloomcomputing.ecs.exec.ISAMIndexedFile", "com.heirloomcomputing.ecs.exec.ISAMIndexedFile", "com.heirloomcomputing.ecs.exec.ISAMIndexedFile", "com.heirloomcomputing.ecs.exec.ISAMIndexedFile", "com.heirloomcomputing.ecs.exec.ISAMIndexedFile", "com.heirloomcomputing.ecs.exec.ACUIndexedFile", "com.heirloomcomputing.ecs.exec.ACUIndexedFile", "com.heirloomcomputing.ecs.exec.ACUIndexedFile", "com.heirloomcomputing.ecs.exec.ACUIndexedFile", "com.heirloomcomputing.ecs.exec.ACUIndexedFile", "com.heirloomcomputing.ecs.exec.ACUIndexedFile"};
    private String[] supportedTypes = new String[]{"MF", "MFU", "MFW", "ACON", "AS400", "ISAM", "CISAM", "C-ISAM", "C_ISAM", "DISAM", "D-ISAM", "D_ISAM", "ACU", "ACUCOBOL", "VIS4", "VISION4", "VIS", "VISION"};
    private String protocol = null;
    private boolean remote = false;
    private int port;
    private String site;
    private IndexedFile file = null;
    private VSQLIndexedFile externalFile = null;
    private Variable filenameVariable = null;
    private boolean optional;
    private int reserve;
    private Variable fileStatus;
    private int accessMode;
    private int blockFrom;
    private int blockTo;
    private boolean isRecords;
    private int recordFrom;
    private int recordTo;
    private byte[] into;
    private Variable dependingOn;
    private int newModes = 0;
    private int numberOfKeys = 0;
    private String[] keyNameArray = new String[256];
    private Variable[] keyArray = new Variable[256];
    private boolean[] isKeyDuplicates = new boolean[256];
    private Variable lastKeyRead;
    private Variable lastRecordAccessed;
    private int keyCompression = 0;
    private int dataCompression = 0;
    private boolean dataEncryption = false;
    private int idxFormat = 3;
    private String filteredFilename;
    private String priorCommand = "";
    private String comparator;
    private String operator;

    private void updateDefaultFileSystems() {
        if (this.defaultUpdated) {
            return;
        }
        this.defaultUpdated = true;
        String s = RuntimeEnvironment.getGlobalParameter("FILESYSTEMIDX");
        if (s == null) {
            s = RuntimeEnvironment.getGlobalParameter("FILESYSTEM");
        }
        if (s != null) {
            if ((s = s.toUpperCase()).equalsIgnoreCase("MF")) {
                this.defaultMicrofocus = true;
            } else if (s.equalsIgnoreCase("MFU")) {
                this.defaultMicrofocus = true;
            } else if (s.equalsIgnoreCase("MFW")) {
                this.defaultMicrofocus = true;
            } else if (s.equalsIgnoreCase("MICROFOCUS")) {
                this.defaultMicrofocus = true;
            } else if (s.equalsIgnoreCase("MERANT")) {
                this.defaultMicrofocus = true;
            } else if (s.equalsIgnoreCase("ACON")) {
                this.defaultAConnect = true;
            } else if (s.equalsIgnoreCase("ACONNECT")) {
                this.defaultAConnect = true;
            } else if (s.equalsIgnoreCase("ACUCONNECT")) {
                this.defaultAConnect = true;
            } else if (s.equalsIgnoreCase("AS400")) {
                this.defaultAS400 = true;
            } else if (s.equalsIgnoreCase("OS400")) {
                this.defaultAS400 = true;
            } else if (s.equalsIgnoreCase("ISAM")) {
                this.defaultISAM = true;
            } else if (s.equalsIgnoreCase("CISAM")) {
                this.defaultISAM = true;
            } else if (s.equalsIgnoreCase("C-ISAM")) {
                this.defaultISAM = true;
            } else if (s.equalsIgnoreCase("C_ISAM")) {
                this.defaultISAM = true;
            } else if (s.equalsIgnoreCase("DISAM")) {
                this.defaultISAM = true;
            } else if (s.equalsIgnoreCase("D-ISAM")) {
                this.defaultISAM = true;
            } else if (s.equalsIgnoreCase("D_ISAM")) {
                this.defaultISAM = true;
            } else if (s.equalsIgnoreCase("ACU")) {
                this.defaultACU = true;
            } else if (s.equalsIgnoreCase("ACUCOBOL")) {
                this.defaultACU = true;
            } else if (s.equalsIgnoreCase("VIS4")) {
                this.defaultACU = true;
            } else if (s.equalsIgnoreCase("VISION4")) {
                this.defaultACU = true;
            } else if (s.equalsIgnoreCase("VIS")) {
                this.defaultACU = true;
            } else if (s.equalsIgnoreCase("VISION")) {
                this.defaultACU = true;
            }
        }
    }

    private void sortKeys() {
        if (this.numberOfKeys < 3) {
            return;
        }
        for (int A = 1; A < this.numberOfKeys - 1; ++A) {
            for (int B = A + 1; B < this.numberOfKeys; ++B) {
                boolean AisVL = this.keyArray[A] instanceof VariableList;
                boolean BisVL = this.keyArray[B] instanceof VariableList;
                if ((!AisVL || BisVL) && this.keyArray[B].getAddress() >= this.keyArray[A].getAddress()) continue;
                Variable tempVar = this.keyArray[B];
                this.keyArray[B] = this.keyArray[A];
                this.keyArray[A] = tempVar;
                boolean tempBool = this.isKeyDuplicates[B];
                this.isKeyDuplicates[B] = this.isKeyDuplicates[A];
                this.isKeyDuplicates[A] = tempBool;
            }
        }
    }

    @Override
    public String getFilename() {
        String filename = "";
        filename = this.filenameVariable != null ? this.filenameVariable.toString() : this.assignTo;
        if (filename != null) {
            filename = filename.trim();
        }
        return filename;
    }

    private String getFilteredFilename() {
        String filename = "";
        filename = this.filenameVariable != null ? this.filenameVariable.toString() : this.assignTo;
        return this.filterFilename(filename);
    }

    private String getAConnectFilename(String filename) {
        if (filename == null || filename.trim().length() == 0) {
            return null;
        }
        if (filename.trim().charAt(0) == '@') {
            return filename;
        }
        String name = RuntimeEnvironment.getGlobalParameter(filename);
        if (name == null || name.trim().length() == 0) {
            return null;
        }
        if (name.trim().charAt(0) == '@') {
            return name;
        }
        return null;
    }

    private String filterFilename(String filename) {
        String temp;
        if (filename != null) {
            filename = filename.trim();
        }
        if ((temp = this.getAConnectFilename(filename)) != null) {
            filename = temp;
            this.protocol = "ACON";
        } else if (filename != null) {
            String envname;
            if (filename.startsWith("env:") && (filename = RuntimeEnvironment.getGlobalParameter(envname = filename.substring(4))) == null) {
                filename = envname;
            }
            if (this.defaultAConnect) {
                filename = this.filterRemote(filename);
                filename = this.filterProtocol(filename);
                this.protocol = "ACON";
                this.remote = false;
                String portNum = RuntimeEnvironment.getGlobalParameter("SERVER_PORT");
                if (portNum == null) {
                    try {
                        if (this.port > 0) {
                            RuntimeEnvironment.setGlobalParameter("SERVER_PORT", String.valueOf(this.port));
                        }
                    }
                    catch (Exception exception) {}
                } else {
                    int myPort = 0;
                    try {
                        myPort = Integer.valueOf(portNum);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (myPort > 0) {
                        if (this.port <= 0) {
                            this.port = myPort;
                        } else if (this.port != myPort) {
                            this.port = myPort;
                        }
                    } else {
                        try {
                            if (this.port > 0) {
                                RuntimeEnvironment.setGlobalParameter("SERVER_PORT", String.valueOf(this.port));
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                filename = '@' + this.site + ":" + filename;
            } else {
                filename = this.filterRemote(filename);
                filename = this.filterProtocol(filename);
            }
        }
        return filename;
    }

    private boolean isAS400Connection() {
        try {
            String osName = System.getProperty("os.name").toUpperCase().trim();
            if (osName.indexOf("OS/400") >= 0 || osName.indexOf("OS400") >= 0 || osName.indexOf("ISERIES") >= 0) {
                return true;
            }
            return RuntimeEnvironment.getGlobalParameter("AS400CONNECT_SERVER") != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private String filterProtocol(String filename) {
        if (filename == null) {
            return null;
        }
        this.protocol = null;
        int index = filename.indexOf(58);
        if (index >= 2) {
            this.protocol = filename.substring(0, index);
            filename = index < filename.length() - 1 ? filename.substring(index + 1) : "";
        } else {
            char ch;
            if (filename.length() > 9 && ((ch = filename.charAt(8)) == '_' || ch == '-') && filename.toUpperCase().startsWith("DATABASE") && this.isAS400Connection()) {
                this.protocol = "AS400";
                filename = filename.substring(9);
            }
            if (filename.length() > 5 && ((ch = filename.charAt(4)) == '_' || ch == '-') && filename.toUpperCase().startsWith("DISK") && this.isAS400Connection()) {
                this.protocol = "AS400";
                filename = filename.substring(5);
            }
        }
        return filename;
    }

    private String filterRemote(String filename) {
        if (filename == null) {
            return null;
        }
        if ((filename = filename.trim()).toLowerCase().startsWith("remote:")) {
            int index = 7;
            if (index >= filename.length()) {
                return "";
            }
            filename = filename.substring(index);
            filename = this.setRemote(filename);
        }
        return filename;
    }

    private String setRemote(String filename) {
        if (filename == null) {
            return null;
        }
        this.remote = true;
        this.filenameVariable = null;
        this.site = null;
        int index = filename.indexOf(58);
        if (index >= 0) {
            this.site = filename.substring(0, index);
            filename = index < filename.length() - 1 ? filename.substring(index + 1) : "";
        }
        if (this.site == null) {
            try {
                this.site = Utilities.getCodeBase().toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.site == null) {
            this.site = RuntimeEnvironment.getGlobalParameter("REMOTEHOST");
        }
        if (this.site == null) {
            this.site = "127.0.0.1";
        }
        index = filename.indexOf(58);
        this.port = 6584;
        if (index >= 0 && index < filename.length() - 1) {
            try {
                this.port = Integer.decode(filename.substring(index + 1));
                filename = filename.substring(0, index);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (Context.getGlobalFileCharacter() != '/') {
            int i = 0;
            do {
                if ((i = filename.indexOf(47, i)) < 0) continue;
                filename = filename.substring(0, i - 1) + '/' + filename.substring(i);
                i += 2;
            } while (i >= 0);
            i = 0;
            do {
                if ((i = filename.indexOf(Context.getGlobalFileCharacter(), i)) < 0) continue;
                filename = filename.substring(0, i - 1) + Context.getGlobalFileCharacter() + filename.substring(i + 1);
                ++i;
            } while (i >= 0);
        }
        return filename;
    }

    private int getSupportedType(String protocol) {
        if (this.supportedTypes != null) {
            for (int i = 0; i < this.supportedTypes.length; ++i) {
                if (this.defaultMicrofocus && "MF".equalsIgnoreCase(this.supportedTypes[i])) {
                    return i;
                }
                if (this.defaultACU && "ACU".equalsIgnoreCase(this.supportedTypes[i])) {
                    return i;
                }
                if (this.defaultAConnect && "ACON".equalsIgnoreCase(this.supportedTypes[i])) {
                    return i;
                }
                if (this.defaultAS400 && "AS400".equalsIgnoreCase(this.supportedTypes[i])) {
                    return i;
                }
                if (this.defaultISAM && "ISAM".equalsIgnoreCase(this.supportedTypes[i])) {
                    return i;
                }
                if (!protocol.equalsIgnoreCase(this.supportedTypes[i])) continue;
                return i;
            }
        }
        return -1;
    }

    private boolean initFile(String filename) {
        int n;
        this.updateDefaultFileSystems();
        this.file = null;
        if (this.protocol == null) {
            if (this.defaultMicrofocus) {
                this.protocol = "MF";
            } else if (this.defaultACU) {
                this.protocol = "ACU";
            } else if (this.defaultAConnect) {
                this.protocol = "ACON";
            } else if (this.defaultAS400) {
                this.protocol = "AS400";
            } else if (this.defaultISAM) {
                this.protocol = "ISAM";
            }
        }
        if (this.protocol != null && (n = this.getSupportedType(this.protocol)) >= 0) {
            try {
                String cname = this.supportedTypesClasses[n];
                Class<?> cl = this.bufferedClasses.get(cname);
                if (cl == null) {
                    cl = Class.forName(cname);
                    if (cl == null) {
                        throw new RuntimeException("File system not supported");
                    }
                    this.bufferedClasses.put(cname, cl);
                }
                this.file = (IndexedFile)cl.newInstance();
                this.file.setContext(this.context);
            }
            catch (Throwable t) {
                try {
                    CobolException.runtimeError("This version of Elastic COBOL does not support the file system '" + this.protocol + "' specified.", t);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return false;
            }
        }
        if (this.file == null) {
            this.file = new SynkronixIndexedFile();
        }
        if (BUFFSIZE < 0) {
            try {
                String str = RuntimeEnvironment.getGlobalParameter("DB-BUFFER-SIZE");
                BUFFSIZE = str == null ? 1000 : Integer.parseInt(str);
            }
            catch (NumberFormatException e) {
                BUFFSIZE = 1000;
            }
        }
        try {
            String str = RuntimeEnvironment.getGlobalParameter("DB-ROWS-TO-FETCH");
            if (str != null) {
                FETCHSIZE = Integer.parseInt(str);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return this.file.init(this.remote, this.site, this.port, filename, this.numberOfKeys, this.keyArray, this.isKeyDuplicates, this.optional, this.reserve, this.fileStatus, this.accessMode, this.blockFrom, this.blockTo, this.isRecords, this.recordFrom, this.recordTo, this.dependingOn, this.newModes, this.keyCompression, this.dataCompression, this.idxFormat, this.dataEncryption);
    }

    @Override
    public String toString() {
        try {
            int i;
            String linesep = System.getProperty("line.separator");
            if (linesep == null) {
                linesep = "\n";
            }
            StringBuffer result = new StringBuffer();
            result.append("ORGANIZATION IS INDEXED").append(linesep);
            if (this.accessMode == 2) {
                result.append("ACCESS MODE IS RANDOM").append(linesep);
            } else if (this.accessMode == 4) {
                result.append("ACCESS MODE IS DYNAMIC").append(linesep);
            } else if (this.accessMode == 1) {
                result.append("ACCESS MODE IS SEQUENTIAL").append(linesep);
            }
            result.append((this.optional ? "" : "NOT-") + "OPTIONAL").append(linesep);
            if (this.filenameVariable != null) {
                result.append("ASSIGN TO ").append(this.filenameVariable.getName()).append("=\"").append(this.filenameVariable.toString()).append("\"").append(linesep);
            } else if (this.file != null) {
                result.append("ASSIGN TO \"").append(this.getFilename()).append("\"").append(linesep);
            }
            result.append("SYSTEM FILENAME W/O PROTOCOL IS " + this.filteredFilename).append(linesep);
            result.append("obsolete: CURRENTLY-" + (this.isOpen() ? "OPEN" : "CLOSED")).append(linesep);
            result.append("FILE IS " + (this.isOpen ? "OPENED" : "CLOSED")).append(linesep);
            result.append((this.externalFile != null ? "" : "NOT-") + "EXTERNAL").append(linesep);
            if (this.fileStatus != null) {
                result.append("FILE STATUS IS ").append(this.fileStatus.getName()).append("=").append(this.fileStatus.toDisplayString()).append(linesep);
            }
            if (this.recordFrom == this.recordTo) {
                result.append("RECORDING MODE IS FIXED").append(linesep);
            } else {
                result.append("RECORDING MODE IS VARIABLE").append(linesep);
            }
            if (this.recordFrom != -1 || this.recordTo != -1) {
                if (this.recordFrom >= this.recordTo) {
                    result.append("RECORD CONTAINS ").append(this.recordFrom).append(" CHARACTERS").append(linesep);
                } else {
                    result.append("RECORD CONTAINS ").append(this.recordFrom).append(" TO ").append(this.recordTo).append(" CHARACTERS").append(linesep);
                }
            }
            if (this.dependingOn != null) {
                result.append("DEPENDING ON ").append(this.dependingOn.getName()).append('=').append(this.dependingOn.toInt()).append(linesep);
            }
            if (this.blockFrom != 0 || this.blockTo != 0) {
                String type = null;
                type = this.isRecords ? " RECORDS" : " CHARACTERS";
                if (this.blockFrom >= this.blockTo) {
                    result.append("BLOCK CONTAINS ").append(this.blockFrom).append(type).append(linesep);
                } else {
                    result.append("BLOCK CONTAINS ").append(this.blockFrom).append(" TO ").append(this.blockTo).append(type).append(linesep);
                }
            }
            result.append("PROTOCOL IS: " + this.protocol).append(linesep);
            if (this.remote) {
                result.append("IS REMOTE (HOST='" + this.site + "', PORT='" + this.port + "')").append(linesep);
            }
            result.append("OPEN INPUT/OUTPUT MODE IS: " + this.openIOMode).append(linesep);
            result.append((this.isOpenInput ? "" : "NOT ") + "OPEN INPUT").append(linesep);
            result.append((this.isOpenOutput ? "" : "NOT ") + "OPEN OUTPUT").append(linesep);
            result.append((this.isOpenIO ? "" : "NOT ") + "OPEN IO").append(linesep);
            result.append((this.readable ? "" : "NOT ") + "READABLE").append(linesep);
            result.append((this.writeable ? "" : "NOT ") + "WRITEABLE").append(linesep);
            result.append("numberOfKeys is " + this.numberOfKeys).append(linesep);
            result.append("NAMES OF KEYS: ").append(linesep);
            for (i = 0; i < this.numberOfKeys; ++i) {
                result.append("    " + this.keyNameArray[i] + (i == 0 ? ". PRIMARY KEY" : ". ALTERNATE KEY")).append(linesep);
            }
            result.append("VALUE OF KEYS: ").append(linesep);
            for (i = 0; i < this.numberOfKeys; ++i) {
                result.append("    " + this.keyArray[i].toText() + (i == 0 ? ". PRIMARY KEY" : ". ALTERNATE KEY")).append(linesep);
            }
            return result.toString();
        }
        catch (RuntimeException t) {
            return "INDEXED FILE";
        }
    }

    @Override
    public synchronized int getFileMarkerKeyOffset() {
        if (this.file == null) {
            return -1;
        }
        return this.file.getFileMarkerKeyOffset();
    }

    @Override
    public idxFile setIdxFormat(int format) {
        this.idxFormat = format;
        return this;
    }

    @Override
    public int getIdxFormat() {
        return this.idxFormat;
    }

    @Override
    public idxFile setKeyCompress(int factor) {
        this.keyCompression = factor;
        return this;
    }

    @Override
    public int getKeyCompress() {
        return this.keyCompression;
    }

    @Override
    public idxFile setDataCompress(int factor) {
        this.dataCompression = factor;
        return this;
    }

    @Override
    public int getDataCompress() {
        return this.dataCompression;
    }

    @Override
    public idxFile setDataCompression() {
        this.setDataCompression(1);
        return this;
    }

    @Override
    public idxFile setDataCompression(int val) {
        this.setDataCompress(val);
        this.setKeyCompress(val);
        return this;
    }

    @Override
    public int getDataCompression() {
        return this.dataCompression;
    }

    @Override
    public idxFile setDataEncryption(boolean flag) {
        this.dataEncryption = flag;
        return this;
    }

    @Override
    public boolean getDataEncryption() {
        return this.dataEncryption;
    }

    @Override
    public synchronized idxFile declare(boolean optional, Variable filenameVariable, int reserve, Variable fileStatus, int accessMode, Variable recordKey, int blockFrom, int blockTo, boolean isRecords, int recordFrom, int recordTo, Variable dependingOn, int newModes) {
        this.newModes = newModes;
        return this.declare(optional, filenameVariable, reserve, fileStatus, accessMode, recordKey, blockFrom, blockTo, isRecords, recordFrom, recordTo, dependingOn);
    }

    @Override
    public synchronized idxFile declare(boolean optional, Variable filenameVariable, int reserve, Variable fileStatus, int accessMode, Variable recordKey, int blockFrom, int blockTo, boolean isRecords, int recordFrom, int recordTo, Variable dependingOn) {
        this.filenameVariable = filenameVariable;
        String assignTo = filenameVariable.toString();
        return this.declare(optional, assignTo, reserve, fileStatus, accessMode, recordKey, blockFrom, blockTo, isRecords, recordFrom, recordTo, dependingOn);
    }

    @Override
    public synchronized idxFile declare(boolean optional, String assignTo, int reserve, Variable fileStatus, int accessMode, Variable recordKey, int blockFrom, int blockTo, boolean isRecords, int recordFrom, int recordTo, Variable dependingOn, int newModes) {
        this.newModes = newModes;
        return this.declare(optional, assignTo, reserve, fileStatus, accessMode, recordKey, blockFrom, blockTo, isRecords, recordFrom, recordTo, dependingOn);
    }

    @Override
    public synchronized idxFile declare(boolean optional, String assignTo, int reserve, Variable fileStatus, int accessMode, Variable recordKey, int blockFrom, int blockTo, boolean isRecords, int recordFrom, int recordTo, Variable dependingOn) {
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer("Hello. ");
        }
        this.optional = optional;
        if (assignTo != null && this.assignTo == null) {
            this.assignTo = assignTo;
        }
        this.reserve = reserve;
        this.fileStatus = fileStatus;
        this.accessMode = accessMode;
        this.keyArray[0] = recordKey;
        this.isKeyDuplicates[0] = false;
        this.blockFrom = blockFrom;
        this.blockTo = blockTo;
        this.isRecords = isRecords;
        this.recordFrom = recordFrom;
        this.recordTo = recordTo;
        this.dependingOn = dependingOn;
        this.numberOfKeys = recordKey != null ? 1 : 0;
        this.keyNameArray[0] = this.keyArray[0].getName();
        if (recordFrom != -1 || recordTo != -1) {
            this.into = recordFrom >= recordTo ? new byte[recordFrom] : new byte[recordTo];
        }
        return this;
    }

    @Override
    public synchronized idxFile alternateKey(Variable alternateKey, int duplicates) {
        this.keyArray[this.numberOfKeys] = alternateKey;
        this.keyNameArray[this.numberOfKeys] = this.keyArray[this.numberOfKeys].getName();
        this.isKeyDuplicates[this.numberOfKeys] = duplicates == 512;
        ++this.numberOfKeys;
        return this;
    }

    @Override
    public synchronized idxFile endDeclare() {
        this.sortKeys();
        this.filteredFilename = this.getFilteredFilename();
        if (!this.initFile(this.filteredFilename)) {
            this.file = null;
            if (this.fileStatus != null) {
                this.warning("VSQLIndexedFile.endDeclare", "not supported on this version");
                this.fileStatus.move(-92);
            }
        }
        return this;
    }

    @Override
    public synchronized boolean open(int mode) {
        int first;
        String func = ".open(i)";
        this.openIOMode = mode;
        this.isOpen = true;
        int iread = mode & 1;
        this.readable = iread == 1;
        int iwrite = mode & 2;
        this.writeable = iwrite == 2;
        this.isOpenIO = this.readable && this.writeable;
        this.isOpenInput = this.readable && !this.writeable;
        this.isOpenOutput = !this.readable && this.writeable;
        String propertyKey = this.getFilename().toUpperCase().replaceFirst(":", ".");
        int last = propertyKey.lastIndexOf(92);
        if (last < 0) {
            last = propertyKey.lastIndexOf(47);
        }
        if ((first = propertyKey.indexOf(46)) > 0 && last > 0) {
            propertyKey = propertyKey.substring(0, first + 1) + propertyKey.substring(last + 1);
        }
        if (!this.isConnectionsOpened) {
            this.openConnections(propertyKey);
            this.isConnectionsOpened = true;
        }
        this.columns = this.dbTables.get(this.sqlTableName.trim());
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.fine(": columns=" + this.columns);
            LogSetup.LOGGER.finer(": toString()=" + String2.makeDisplayable(this.toString()));
        }
        if (this.columns == null) {
            this.iostatus(-90);
            StringBuffer sb = new StringBuffer();
            for (String as : this.dbTables.keySet().toArray(new String[0])) {
                sb.append(as).append(" ");
            }
            this.logit("file status=" + this.fileStatus.toText() + "ERROR! SQL table is not configured in the deploy.properties|deploy_settings file. \n   External filename is " + this.getFilename() + ". SQL Table name is " + this.sqlTableName + ".\n   There should be a line in the deploy.properties|deploy_settings file like this: 'file." + this.sqlTableName + "jdbc:" + this.sqlTableName + ".xml'.\n   Problem could also be a name mismatch(s) in your XML file containing dataset name '" + sb.toString() + "' which should also match '" + this.sqlTableName + "'", ".open(i)");
            this.iostatus(-90);
            return true;
        }
        this.conn = this.tableConns.get(this.sqlTableName);
        try {
            this.BuffSize = this.conn.getAutoCommit() ? 0 : BUFFSIZE;
        }
        catch (SQLException e) {
            this.BuffSize = 0;
        }
        if (LogSetup.IS_LOGGING) {
            int i;
            for (i = 0; i < this.numberOfKeys; ++i) {
                LogSetup.LOGGER.fine("keyArray[" + i + "]: name=" + this.keyArray[i].getName() + ". recordPosition=" + this.keyArray[i].getRecordPosition() + ". length=" + this.keyArray[i].length());
            }
            LogSetup.LOGGER.fine(" To display sql column info: ");
            for (i = 0; i < this.columns.size(); ++i) {
                LogSetup.LOGGER.fine("SqlColumn " + i + " " + this.columns.get(i).toString());
            }
        }
        this.iostatus(0);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void openConnections(String fileName) {
        SqlConnections sc = new SqlConnections();
        sc.storeConnectionInfo();
        TreeMap<String, SqlConnectionInfo> conInfos = new TreeMap<String, SqlConnectionInfo>();
        conInfos.putAll(sc.getConnections());
        if (conInfos.size() == 0) {
            throw new RuntimeException("VSQL: : No database connection information provided on command line properties, deploy.properties|deploy_settings file, or in ETP or EBP settings.");
        }
        TreeMap<String, Connection> conns = SqlConnections.openConnections(conInfos);
        if (conInfos.size() == 0) {
            throw new RuntimeException("VSQL: : No available database connections could be made");
        }
        if (setupProp == null) {
            setupProp = PropertiesUtil.loadProperties("data.properties");
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.fine("Properties file 'data.properties' contains:\n" + setupProp.toString());
            }
            if (setupProp.size() == 0) {
                throw new RuntimeException("VSQL: : File name '" + fileName + "' not found in database table mapping file 'data.properties'");
            }
        }
        this.sqlTableName = setupProp.getProperty(fileName);
        if (this.sqlTableName == null) {
            throw new RuntimeException("VSQL: : File name '" + fileName + "' not mapped to a database table name as required in 'data.properties' file");
        }
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.fine(": ASSIGN TO filename is " + fileName + ". sqlTableName=" + this.sqlTableName + ".");
        }
        if (deploy_settings == null) {
            String fname;
            block39: {
                fname = "deploy.properties";
                try {
                    deploy_settings = PropertiesUtil.loadProperties(fname);
                    if (deploy_settings == null && (deploy_settings = PropertiesUtil.loadProperties(fname = "deploy_settings")) == null) {
                        throw new RuntimeException("VSQL: Could not open file 'deploy.properties|deploy_settings' required for VSQL operation.");
                    }
                }
                catch (IllegalArgumentException e) {
                    fname = "deploy_settings";
                    deploy_settings = PropertiesUtil.loadProperties(fname);
                    if (deploy_settings != null) break block39;
                    throw new RuntimeException("VSQL: Could not open file 'deploy.properties|deploy_settings' required for VSQL operation.");
                }
            }
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.info("Loaded properties file:" + fname);
            }
        }
        this.xmlFilenames = PropertiesUtil.listValues(deploy_settings, "file." + this.sqlTableName, "jdbc:");
        if (this.xmlFilenames.size() == 0) {
            this.xmlFilenames = PropertiesUtil.listValues(deploy_settings, "file." + this.sqlTableName.toLowerCase(), "jdbc:");
            if (this.xmlFilenames.size() == 0) {
                this.xmlFilenames = PropertiesUtil.listValues(deploy_settings, "file." + this.sqlTableName.toUpperCase(), "jdbc:");
            }
        }
        if (this.xmlFilenames.size() == 0) {
            throw new RuntimeException("VSQL: SQL table-to-XML file property 'file." + this.sqlTableName + "' not found in deployment settings file 'deploy.properties|deploy_settings'");
        }
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.fine("VSQL: xmlFilenames are: " + this.xmlFilenames);
        }
        this.dbTables = XmlDatasetLoader.XmlToTable(this.xmlFilenames);
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.fine("dbTables.toString() contains:\n" + this.dbTables.toString());
        }
        Set<String> ck = this.dbTables.keySet();
        Iterator itk = ck.iterator();
        String dbTable = null;
        Statement stmt = null;
        Connection conn = null;
        this.tableConns = new HashMap();
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.fine("The Set of keys in HashMap dbTables:  ");
        }
        while (itk.hasNext()) {
            boolean isFoundConnection = false;
            dbTable = (String)itk.next();
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.fine("    " + dbTable);
            }
            Iterator<Map.Entry<String, Connection>> iter = conns.entrySet().iterator();
            while (iter.hasNext()) {
                conn = iter.next().getValue();
                try {
                    stmt = conn.createStatement();
                    DatabaseMetaData databaseMetaData = conn.getMetaData();
                    if (databaseMetaData.getTables(null, null, dbTable, null).next() || databaseMetaData.getTables(null, null, dbTable.toUpperCase(), null).next()) {
                        isFoundConnection = true;
                        break;
                    }
                    isFoundConnection = false;
                    try {
                        if (conn.isClosed()) break;
                        conn.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    break;
                }
                catch (SQLException e) {
                    isFoundConnection = false;
                }
                finally {
                    try {
                        stmt.close();
                    }
                    catch (Exception exception) {}
                }
            }
            if (isFoundConnection) {
                this.tableConns.put(dbTable, conn);
                continue;
            }
            throw new RuntimeException("VSQL: DB connection not found for SQL table '" + dbTable + "'.\n" + conInfos.size() + " connections were tried. Possible connections are: \n" + conInfos.toString() + ".");
        }
    }

    @Override
    public synchronized boolean openTimeoutSeconds(int mode, Numeric timeout) {
        mode = LockFile.transformOpenMode(mode);
        int timeout_mask = 0x2100000;
        mode &= ~timeout_mask;
        double seconds = timeout.toDouble();
        boolean success = false;
        long currentTime = System.currentTimeMillis();
        long finalTime = currentTime + (long)(seconds * 1000.0);
        do {
            this.iostatus(0);
            success = this.open(mode);
            if (success || System.currentTimeMillis() >= finalTime) continue;
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (!success && System.currentTimeMillis() < finalTime);
        return success;
    }

    @Override
    public synchronized boolean openTimeoutRetries(int mode, Numeric timeout) {
        mode = LockFile.transformOpenMode(mode);
        int timeout_mask = 0x2100000;
        mode &= ~timeout_mask;
        int attempts = timeout.toInt();
        if (attempts < 0) {
            attempts = 0;
        }
        ++attempts;
        boolean success = false;
        do {
            this.iostatus(0);
            success = this.open(mode);
            if (success || --attempts <= 0) continue;
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (!success && attempts > 0);
        return success;
    }

    @Override
    public synchronized boolean openTimeoutRetries(int mode) {
        mode = LockFile.transformOpenMode(mode);
        mode &= 0xFDEFFFFF;
        boolean success = false;
        do {
            this.iostatus(0);
            success = this.open(mode);
            if (success) continue;
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (!success);
        return success;
    }

    @Override
    public synchronized boolean close() {
        return this.close(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean close(int mode) {
        block19: {
            block18: {
                block17: {
                    if (!this.isConnectionsOpened) break block18;
                    this.isConnectionsOpened = false;
                    if (LogSetup.IS_LOGGING) {
                        LogSetup.LOGGER.fine("In close(int). ");
                    }
                    try {
                        this.commitIfNecessary(this.BuffSize);
                        this.conn.close();
                        for (Connection connection : this.tableConns.values()) {
                            try {
                                if (connection.isClosed()) continue;
                                connection.close();
                            }
                            catch (SQLException exception) {}
                        }
                    }
                    catch (SQLException e) {
                        System.out.println("VSQL: error closing SQL Connection.");
                        e.printStackTrace(System.err);
                        break block17;
                    }
                    finally {
                        for (Map.Entry<String, PreparedStatement> entry : this.keyToPreparedStatementMap.entrySet()) {
                            try {
                                entry.getValue().close();
                            }
                            catch (Exception exception) {}
                        }
                        this.keyToPreparedStatementMap.clear();
                    }
                    for (Map.Entry entry : this.keyToPreparedStatementMap.entrySet()) {
                        try {
                            ((PreparedStatement)entry.getValue()).close();
                        }
                        catch (Exception exception) {}
                    }
                    this.keyToPreparedStatementMap.clear();
                }
                this.iostatus(0);
                break block19;
            }
            this.warning("VSQLIndexedFile.close", "invalid operation, file already closed");
            this.iostatus(-42);
        }
        return false;
    }

    @Override
    public synchronized boolean start(String format, Variable nullKeyMap, int mode, int keyOffset, byte[] replacementData) {
        return this.start(mode, keyOffset, replacementData);
    }

    @Override
    public synchronized boolean start(String format, Variable nullKeyMap, int mode, int keyOffset) {
        return this.start(mode, keyOffset);
    }

    @Override
    public synchronized boolean start(String format, Variable nullKeyMap, int mode, Variable currentKey) {
        return this.start(mode, currentKey);
    }

    @Override
    public synchronized boolean start(int mode, Variable currentKey) {
        String func = ".start(i,V)";
        this.closeResultSet();
        if (!this.isOpenInput && !this.isOpenIO) {
            this.iostatus(-47);
            this.warning("VSQLIndexedFile.start", "invalid operation, file not open for input");
            return false;
        }
        if (this.accessMode != 1 && this.accessMode != 4) {
            this.iostatus(-90);
            this.logit("file status=" + this.fileStatus.toText() + ": ERROR! ACCESS MODE must be SEQUENTIAL or DYNAMIC.", ".start(i,V)");
            return false;
        }
        String keyName = currentKey.getName();
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer("mode=" + mode + ". current key: " + keyName + "=" + currentKey.toText());
        }
        boolean keyExists = false;
        for (int i = 0; i < this.numberOfKeys; ++i) {
            if (!keyName.equals(this.keyNameArray[i])) continue;
            keyExists = true;
            this.keyArray[i] = currentKey;
            break;
        }
        if (!keyExists) {
            throw new RuntimeException("VSQL: START KEY is invalid. KEY name is " + keyName + ". KEY value is " + currentKey.toText());
        }
        boolean isFound = false;
        PreparedStatement prepStmt = this.procurePreparedStatement(currentKey, "START", mode);
        Variable[] keyComponents = currentKey instanceof VariableList ? ((VariableList)currentKey).getList() : new Variable[]{currentKey};
        String[] objStrs = new String[this.columns.size()];
        int numOfKeyCol = 0;
        for (Variable oneKeyComponent : keyComponents) {
            int offset = oneKeyComponent.getRecordPosition();
            int highOffset = offset + oneKeyComponent.getLength();
            for (int i = 0; i < this.columns.size(); ++i) {
                SqlColumn col = this.columns.get(i);
                if (col.getOffset() < offset || col.getOffset() >= highOffset) continue;
                String value = col.snagToString(oneKeyComponent.getBytes(), -oneKeyComponent.getRecordPosition());
                objStrs[numOfKeyCol++] = value;
            }
        }
        try {
            int i;
            int numOfParms = 0;
            if (mode == 0) {
                for (i = 0; i < numOfKeyCol; ++i) {
                    this.typeConversion(prepStmt, ++numOfParms, objStrs[i]);
                }
            } else {
                for (i = 0; i < numOfKeyCol; ++i) {
                    for (int j = 0; j < numOfKeyCol - i; ++j) {
                        this.typeConversion(prepStmt, ++numOfParms, objStrs[j]);
                    }
                }
            }
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.finer("replacing 1 or more place holders");
            }
            prepStmt.setFetchSize(FETCHSIZE);
            this.resultSet = prepStmt.executeQuery();
            this.resultSetRecordNumber = 0;
            this.alreadyDidNext = isFound = this.resultSet.next();
            if (isFound) {
                this.resultSetRecordNumber = 1;
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        if (!isFound) {
            this.iostatus(-23);
            this.lastKeyRead = null;
            this.lastRecordAccessed = null;
            this.warning("VSQLIndexedFile.start", "invalid key, random record missing");
            return true;
        }
        this.iostatus(0);
        this.priorCommand = "start";
        this.priorAccessType = AccessType.START;
        this.lastKeyRead = currentKey;
        this.lastRecordAccessed = null;
        return false;
    }

    @Override
    public synchronized boolean start(String format, Variable nullKeyMap, int mode) {
        return this.start(mode);
    }

    @Override
    public synchronized boolean start(String format, Variable nullKeyMap, Variable currentKey) {
        return this.start(currentKey);
    }

    @Override
    public synchronized boolean start(Variable currentKey) {
        try {
            return this.start(0, currentKey);
        }
        catch (Throwable t) {
            CobolException.runtimeError("Error in indexed file START.", t);
            return false;
        }
    }

    @Override
    public synchronized byte[] readNetwork(boolean seqOverride, int keyOffset, byte[] keyData, int mode, double timeout) {
        return this.readNetwork(seqOverride, keyOffset, keyData, mode, timeout, 1);
    }

    @Override
    public synchronized boolean read(String format, Variable nullKeyMap, Variable nullMap, Variable intoVar, Variable keyIs, int mode, Numeric timeout) {
        return this.read(intoVar, keyIs, mode, timeout);
    }

    @Override
    public boolean read(Variable intoVar, Variable keyIs, int mode, Numeric timeout) {
        if (!this.isOpenInput && !this.isOpenIO) {
            this.iostatus(-47);
            this.warning("VSQLIndexedFile.read", "invalid operation, file not open for input");
            return false;
        }
        Variable key = null;
        String keyName = keyIs.getName();
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer("mode=" + mode + ". current key: " + keyName + "=" + keyIs.toText());
        }
        boolean keyExists = false;
        for (int i = 0; i < this.numberOfKeys; ++i) {
            if (!keyName.equals(this.keyNameArray[i])) continue;
            keyExists = true;
            key = this.keyArray[i] = keyIs;
            break;
        }
        if (!keyExists) {
            throw new RuntimeException("VSQL: READ KEY is invalid. KEY name is " + keyName + ". KEY value is " + keyIs.toText());
        }
        boolean isFound = false;
        PreparedStatement prepStmt = this.procurePreparedStatement(keyIs, "READ", mode);
        try {
            prepStmt.setMaxRows(1);
            prepStmt.setFetchSize(1);
            Variable[] keyComponents = keyIs instanceof VariableList ? ((VariableList)keyIs).getList() : new Variable[]{keyIs};
            int numOfKeyCol = 0;
            for (Variable oneKeyComponent : keyComponents) {
                int offset = oneKeyComponent.getRecordPosition();
                int highOffset = offset + oneKeyComponent.getLength();
                for (int i = 0; i < this.columns.size(); ++i) {
                    SqlColumn col = this.columns.get(i);
                    if (col.getOffset() < offset || col.getOffset() >= highOffset) continue;
                    String value = col.snagToString(oneKeyComponent.getBytes(), -oneKeyComponent.getRecordPosition());
                    this.typeConversion(prepStmt, ++numOfKeyCol, value);
                }
            }
            this.resultSet = prepStmt.executeQuery();
            this.resultSetRecordNumber = 0;
            if (this.alreadyDidNext || this.resultSet.next()) {
                this.alreadyDidNext = false;
                ++this.resultSetRecordNumber;
                isFound = true;
                for (int i = 0; i < this.columns.size(); ++i) {
                    SqlColumn col = this.columns.get(i);
                    col.retrieve(this.resultSet, this.into);
                }
            } else {
                isFound = false;
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        if (!isFound) {
            this.iostatus(-23);
            this.lastKeyRead = null;
            this.lastRecordAccessed = null;
            this.warning("VSQLIndexedFile.read", "invalid key, random record missing");
            return true;
        }
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer("length of into=" + this.into.length + ". into=" + String2.makeDisplayable(new String(this.into)) + ".");
        }
        this.iostatus(0);
        intoVar.setArgument(this.into);
        this.priorCommand = "read";
        this.priorAccessType = AccessType.READ;
        this.lastKeyRead = key;
        this.lastRecordAccessed = intoVar;
        return false;
    }

    @Override
    public synchronized boolean read(String format, Variable nullKeyMap, Variable nullMap, Variable intoVar, Variable keyIs) {
        return this.read(intoVar, keyIs);
    }

    @Override
    public synchronized boolean read(Variable intoVar, Variable keyIs) {
        return this.read(intoVar, keyIs, 0, null);
    }

    @Override
    public synchronized boolean read(String format, Variable nullKeyMap, Variable nullMap, Variable intoVar, int mode, Numeric timeout) {
        if (this.accessMode == 1) {
            return this.readNext(intoVar, mode, timeout);
        }
        return this.read(intoVar, mode, timeout);
    }

    @Override
    public synchronized boolean read(Variable intoVar, int mode, Numeric timeout) {
        String func = ".read(V,i,N)";
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer("VSQLIndexedFile.read(V,i,N)");
        }
        Variable key = this.keyArray[0];
        return this.read(intoVar, key, mode, timeout);
    }

    @Override
    public synchronized boolean read(Variable intoVar) {
        return this.read(intoVar, 0, null);
    }

    @Override
    public synchronized boolean readFirst(String format, Variable nullKeyMap, Variable nullMap, Variable intoVar, int mode, Numeric timeout) {
        return this.readFirst(intoVar, mode, timeout);
    }

    @Override
    public synchronized boolean readFirst(String format, Variable nullKeyMap, Variable nullMap, Variable intoVar) {
        return this.readFirst(intoVar);
    }

    @Override
    public synchronized boolean readFirst(Variable intoVar) {
        return this.readFirst(intoVar, 0, null);
    }

    @Override
    public synchronized boolean readLast(String format, Variable nullKeyMap, Variable nullMap, Variable intoVar, int mode, Numeric timeout) {
        return this.readLast(intoVar, mode, timeout);
    }

    @Override
    public synchronized boolean readLast(String format, Variable nullKeyMap, Variable nullMap, Variable intoVar) {
        return this.readLast(intoVar);
    }

    @Override
    public synchronized boolean readLast(Variable intoVar) {
        return this.readLast(intoVar, 0, null);
    }

    @Override
    public synchronized boolean readNext(String format, Variable nullKeyMap, Variable nullMap, Variable intoVar, int mode, Numeric timeout) {
        return this.readNext(intoVar, mode, timeout);
    }

    @Override
    public synchronized boolean readNext(Variable intoVar, int mode, Numeric timeout) {
        int fileStatus;
        String func = ".readNext(V,i,N)";
        if (!this.isOpenInput && !this.isOpenIO) {
            this.iostatus(-47);
            this.logit("file status=" + this.fileStatus.toText() + "ERROR! READ NEXT requires file be OPENed as INPUT or IO.", ".readNext(V,i,N)");
            this.warning("VSQLIndexedFile.readNext", "invalid operation, file not open for input");
            return false;
        }
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer("intoVar is " + String2.makeDisplayable(intoVar.toText()) + ". mode=" + mode + ".");
        }
        if (mode == 0) {
            mode = 1;
        }
        Variable key = this.lastKeyRead == null ? this.keyArray[0] : this.lastKeyRead;
        if (this.priorAccessType == AccessType.READ) {
            this.closeResultSet();
            this.resultSetRecordNumber = 0;
        }
        if ((fileStatus = this.startNext(intoVar, key, mode)) < -9) {
            return true;
        }
        boolean isFound = false;
        boolean skipFirstRec = false;
        if (mode == 1 && (this.priorAccessType == AccessType.READ || this.priorAccessType == AccessType.READ_NEXT)) {
            skipFirstRec = true;
        }
        try {
            if (this.alreadyDidNext) {
                this.alreadyDidNext = false;
            } else {
                boolean bl = isFound = this.resultSet.next();
                if (!isFound) {
                    this.iostatus(-10);
                    this.lastKeyRead = null;
                    return true;
                }
                ++this.resultSetRecordNumber;
                if (skipFirstRec && this.resultSetRecordNumber == 1) {
                    boolean bl2 = isFound = this.resultSet.next();
                    if (isFound) {
                        ++this.resultSetRecordNumber;
                    }
                }
                if (!isFound) {
                    this.iostatus(-10);
                    this.lastKeyRead = null;
                    return true;
                }
            }
            for (int i = 0; i < this.columns.size(); ++i) {
                SqlColumn col = this.columns.get(i);
                col.retrieve(this.resultSet, this.into);
            }
        }
        catch (SQLException e) {
            e.printStackTrace(System.err);
        }
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer("length of into=" + this.into.length + ". into=" + String2.makeDisplayable(new String(this.into)) + ".");
        }
        this.iostatus(0);
        intoVar.setArgument(this.into);
        this.priorCommand = "readnext";
        this.priorAccessType = AccessType.READ_NEXT;
        this.lastKeyRead = key;
        this.lastRecordAccessed = intoVar;
        return false;
    }

    private void closeResultSet() {
        if (this.resultSet != null) {
            try {
                this.resultSet.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.resultSet = null;
        }
    }

    public int startNext(Variable intoVar, Variable key, int mode) {
        String func = ".startNext()";
        if (this.accessMode != 1 && this.accessMode != 4) {
            this.iostatus(-90);
            this.logit("file status=" + this.fileStatus.toText() + " ERROR! ACCESS MODE must be SEQUENTIAL or DYNAMIC.", ".startNext()");
            return -90;
        }
        String value = null;
        if (this.resultSet == null || this.priorAccessType != AccessType.READ_NEXT && this.priorAccessType != AccessType.START || !key.getName().equals(this.lastKeyRead.getName())) {
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.finer("Finding prep statement.");
            }
            PreparedStatement prepStmt = this.procurePreparedStatement(key, "READNEXT", mode);
            Variable[] keyComponents = key instanceof VariableList ? ((VariableList)key).getList() : new Variable[]{key};
            try {
                int numOfKeyCol = 0;
                for (Variable oneKeyComponent : keyComponents) {
                    int offset = oneKeyComponent.getRecordPosition();
                    int highOffset = offset + oneKeyComponent.getLength();
                    for (int i = 0; i < this.columns.size(); ++i) {
                        SqlColumn col = this.columns.get(i);
                        if (col.getOffset() < offset || col.getOffset() >= highOffset) continue;
                        value = col.snagToString(intoVar.getBytes(), 0);
                        this.typeConversion(prepStmt, ++numOfKeyCol, value);
                    }
                }
                prepStmt.setFetchSize(FETCHSIZE);
                this.resultSet = prepStmt.executeQuery();
                this.resultSetRecordNumber = 0;
            }
            catch (SQLException e) {
                e.printStackTrace(System.err);
            }
        }
        return 0;
    }

    @Override
    public synchronized boolean readNext(String format, Variable nullKeyMap, Variable nullMap, Variable intoVar) {
        return this.readNext(intoVar);
    }

    @Override
    public synchronized boolean readNext(Variable intoVar) {
        return this.readNext(intoVar, 0, null);
    }

    @Override
    public synchronized boolean readPrevious(String format, Variable nullKeyMap, Variable nullMap, Variable intoVar, int mode, Numeric timeout) {
        return this.readPrevious(intoVar, mode, timeout);
    }

    @Override
    public synchronized boolean readPrevious(String format, Variable nullKeyMap, Variable nullMap, Variable intoVar) {
        return this.readPrevious(intoVar);
    }

    @Override
    public synchronized boolean readPrevious(Variable intoVar) {
        return this.readPrevious(intoVar, 0, null);
    }

    @Override
    public boolean write(String format, Variable nullKeyMap, Variable nullMap, Variable fromVar, int mode, Numeric timeout) {
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer("mode=" + mode + ".");
        }
        return this.write(fromVar);
    }

    @Override
    public boolean write(Variable fromVar, int mode, Numeric timeout) {
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer("mode=" + mode + ".");
        }
        return false;
    }

    @Override
    public synchronized boolean write(String format, Variable nullKeyMap, Variable nullMap, Variable fromVar) {
        return this.write(fromVar);
    }

    @Override
    public synchronized boolean write(Variable fromVar) {
        String func = "VSQLIndexedFile.write(Variable fromVar): ";
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer("VSQLIndexedFile.write(Variable fromVar): Start. fromVar=" + fromVar.getName() + ". ");
        }
        if (!this.isOpenOutput && !this.isOpenIO) {
            this.iostatus(-48);
            this.warning("VSQLIndexedFile.write", "invalid operation, file not open for output");
            return false;
        }
        int numOfRowsInserted = 0;
        try {
            PreparedStatement prepStmt = this.fillStatementParameterValues("VSQLIndexedFile.write(Variable fromVar): ", "WRITE", 0, fromVar);
            numOfRowsInserted = prepStmt.executeUpdate();
            this.commitIfNecessary(numOfRowsInserted);
        }
        catch (SQLException e) {
            e.printStackTrace(System.err);
        }
        if (numOfRowsInserted == 0) {
            this.iostatus(-22);
            this.logit("file status=" + this.fileStatus.toText() + ". No record was written. ", "VSQLIndexedFile.write(Variable fromVar): ");
            this.warning("VSQLIndexedFile.write", "invalid key, primary index duplicate key");
            return true;
        }
        if (numOfRowsInserted > 1) {
            this.iostatus(-90);
            this.logit("file status=" + this.fileStatus.toText() + ". More than 1 record written. " + numOfRowsInserted + " records were written. ", "VSQLIndexedFile.write(Variable fromVar): ");
            return true;
        }
        this.iostatus(0);
        this.priorCommand = "write";
        this.lastRecordAccessed = fromVar;
        return false;
    }

    @Override
    public synchronized boolean writeNext(String format, Variable nullKeyMap, Variable nullMap, Variable fromVar) {
        return this.writeNext(fromVar);
    }

    @Override
    public boolean rewrite(String format, Variable nullKeyMap, Variable nullMap, Variable fromVar, int mode, Numeric timeout) {
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer("mode=" + mode + ".");
        }
        return this.rewrite(fromVar);
    }

    @Override
    public synchronized boolean rewrite(String format, Variable nullKeyMap, Variable nullMap, Variable fromVar) {
        return this.rewrite(fromVar);
    }

    @Override
    public boolean rewrite(Variable fromVar) {
        String func = ".rewrite(V)";
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer("VSQLIndexedFile.rewrite(V).");
        }
        if (!this.isOpenIO) {
            this.iostatus(-49);
            this.warning("VSQLIndexedFile.rewrite", "invalid operation, file not open for I-O");
            return false;
        }
        int numOfRowsUpdated = 0;
        try {
            PreparedStatement prepStmt = this.fillStatementParameterValues(".rewrite(V)", "REWRITE", 0, fromVar);
            int numOfParms = this.columns.size();
            Variable[] keyComponents = this.keyArray[0] instanceof VariableList ? ((VariableList)this.keyArray[0]).getList() : new Variable[]{this.keyArray[0]};
            for (Variable oneKeyComponent : keyComponents) {
                int offset = oneKeyComponent.getRecordPosition();
                int highOffset = offset + oneKeyComponent.getLength();
                for (int i = 0; i < this.columns.size(); ++i) {
                    SqlColumn col = this.columns.get(i);
                    if (col.getOffset() < offset || col.getOffset() >= highOffset) continue;
                    String value = col.snagToString(this.keyArray[0].getBytes(), 0);
                    prepStmt.setString(++numOfParms, value);
                }
            }
            numOfRowsUpdated = prepStmt.executeUpdate();
            this.commitIfNecessary(numOfRowsUpdated);
        }
        catch (SQLException e) {
            e.printStackTrace(System.err);
        }
        if (numOfRowsUpdated == 0) {
            this.iostatus(-23);
            this.logit("file status=" + this.fileStatus.toText() + ". No record rewritten because no record is found. ", ".rewrite(V)");
            this.warning("VSQLIndexedFile.rewrite", "invalid key, random record missing");
            return true;
        }
        if (numOfRowsUpdated > 1) {
            this.iostatus(-90);
            this.logit("file status=" + this.fileStatus.toText() + ". More than 1 record rewritten. " + numOfRowsUpdated + " records were rewritten. ", ".rewrite(V)");
            return true;
        }
        this.iostatus(0);
        this.priorCommand = "rewrite";
        this.lastRecordAccessed = fromVar;
        return false;
    }

    @Override
    public boolean delete(String format, Variable nullKeyMap, int mode, Numeric timeout) {
        return this.delete(mode, timeout);
    }

    @Override
    public synchronized boolean delete(String format, Variable nullKeyMap) {
        return this.delete();
    }

    @Override
    public synchronized boolean delete() {
        String func = ".delete()";
        if (!this.isOpenIO) {
            this.setIOStatus(-49);
            this.logit("file status=" + this.fileStatus.toText() + ". Record cannot be deleted. File must be OPENed for I-O.", ".delete()");
            this.warning("VSQLIndexedFile.delete", "invalid operation, file not open for I-O");
            return true;
        }
        if (this.lastRecordAccessed == null) {
            this.setIOStatus(-23);
            this.logit("file status=" + this.fileStatus.toText() + ". Record cannot be deleted. No record found to be deleted. ", ".delete()");
            this.warning("VSQLIndexedFile.delete", "invalid key, random record missing");
            return true;
        }
        if (this.accessMode == 1 && this.lastKeyRead == null && !"read".equals(this.priorCommand) && !"readnext".equals(this.priorCommand)) {
            this.setIOStatus(-43);
            this.logit("file status=" + this.fileStatus.toText() + ". Record cannot be deleted. Previous access to file (sql table) must be successful 'READ'.", ".delete()");
            this.warning("VSQLIndexedFile.delete", "invalid operation, delete not after read");
            return true;
        }
        PreparedStatement prepStmt = this.procurePreparedStatement(this.lastRecordAccessed, "DELETE", 0);
        int numOfRowsDeleted = 0;
        int numOfParms = this.columns.size();
        Variable[] keyComponents = this.keyArray[0] instanceof VariableList ? ((VariableList)this.keyArray[0]).getList() : new Variable[]{this.keyArray[0]};
        try {
            for (Variable oneKeyComponent : keyComponents) {
                int offset = oneKeyComponent.getRecordPosition();
                int highOffset = offset + oneKeyComponent.getLength();
                for (int i = 0; i < this.columns.size(); ++i) {
                    SqlColumn col = this.columns.get(i);
                    if (col.getOffset() < offset || col.getOffset() >= highOffset) continue;
                    String value = col.snagToString(this.keyArray[0].getBytes(), 0);
                    prepStmt.setString(++numOfParms, value);
                }
            }
            numOfRowsDeleted = prepStmt.executeUpdate();
            this.commitIfNecessary(numOfRowsDeleted);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        if (numOfRowsDeleted == 0) {
            this.iostatus(-23);
            this.logit("file status=" + this.fileStatus.toText() + ". No record is deleted because no record is found. ", ".delete()");
            this.warning("VSQLIndexedFile.delete", "invalid key, random record missing");
            return true;
        }
        if (numOfRowsDeleted > 1) {
            this.iostatus(-90);
            this.logit("file status=" + this.fileStatus.toText() + ". More than 1 record deleted. " + numOfRowsDeleted + " records were deleted. ", ".delete()");
            return true;
        }
        this.iostatus(0);
        this.priorCommand = "delete";
        return false;
    }

    @Override
    public synchronized boolean delete(String format, Variable nullKeyMap, byte[] keyData, int mode, double timeout, boolean generic) {
        return this.delete(keyData, mode, timeout, generic);
    }

    @Override
    public synchronized void init() {
        try {
            if (this.file != null) {
                this.file.init();
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Override
    public synchronized int priorError() {
        return this.getPriorError();
    }

    @Override
    public final int getPriorError() {
        if (this.priorErrorCode > 0) {
            return -this.priorErrorCode;
        }
        return this.priorErrorCode;
    }

    @Override
    public final void setPriorError(int priorError) {
        this.priorErrorCode = priorError;
    }

    @Override
    public final int setIOStatus(int status) {
        char[] smallChar = new char[]{'0', '0'};
        if ((status = status < 0 ? -status : 0) == 9) {
            status = 0;
        }
        this.setPriorError(status);
        if (this.fileStatus != null) {
            if (status == 0) {
                this.fileStatus.moveZeroes();
            } else if (status < 10) {
                smallChar[1] = (char)(status + 48);
                this.fileStatus.move(smallChar);
            } else {
                this.fileStatus.move(status);
            }
        }
        return status;
    }

    @Override
    public final int setIOStatus(String x) {
        int status = 0;
        try {
            status = Integer.decode(x);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.setIOStatus(-status);
    }

    @Override
    public int iostatus(int status) {
        return this.setIOStatus(status);
    }

    @Override
    public synchronized int iostatus(String x) {
        return this.setIOStatus(x);
    }

    @Override
    public synchronized boolean isOK() {
        int priorErrorCode = this.getPriorError();
        return priorErrorCode > -10 && priorErrorCode < 10;
    }

    @Override
    public synchronized boolean useException() {
        int priorErrorCode = this.getPriorError();
        if (priorErrorCode < 0) {
            priorErrorCode = -priorErrorCode;
        }
        return priorErrorCode >= 10;
    }

    @Override
    public synchronized int useException(int specific, int input, int output, int io, int extend) {
        if (this.useException()) {
            if (specific >= 0) {
                return specific;
            }
            if (this.isInput()) {
                return input;
            }
            if (this.isOutput()) {
                return output;
            }
            if (this.isIO()) {
                return io;
            }
            if (this.isExtend()) {
                return extend;
            }
        }
        return -1;
    }

    @Override
    public synchronized int useException(int specific) {
        if (this.useException()) {
            return specific;
        }
        return -1;
    }

    @Override
    public synchronized boolean useAtEnd() {
        int priorErrorCode = this.getPriorError();
        return priorErrorCode == -10 || priorErrorCode == 10 || priorErrorCode == 14 || priorErrorCode == -14;
    }

    @Override
    public synchronized int useAtEnd(int specific, int input, int output, int io, int extend) {
        if (this.useAtEnd()) {
            if (specific >= 0) {
                return specific;
            }
            if (this.isInput()) {
                return input;
            }
            if (this.isOutput()) {
                return output;
            }
            if (this.isIO()) {
                return io;
            }
            if (this.isExtend()) {
                return extend;
            }
        }
        return -1;
    }

    @Override
    public synchronized int useAtEnd(int specific) {
        if (this.useAtEnd() && specific >= 0) {
            return specific;
        }
        return -1;
    }

    @Override
    public synchronized Numeric getLinageCounter() {
        return new Numeric(1);
    }

    @Override
    public Object getObject() {
        return null;
    }

    @Override
    public void finalize() throws Throwable {
        this.init();
        super.finalize();
    }

    @Override
    public idxFile settingExternalFile(Context context, String name) {
        Object copy = context.getExternalFile(this, name);
        if (copy == null) {
            return this;
        }
        if (!(copy instanceof VSQLIndexedFile)) {
            return this;
        }
        if (copy == this) {
            return this;
        }
        this.externalFile = (VSQLIndexedFile)copy;
        this.file = this.externalFile.file;
        return this;
    }

    @Override
    public boolean supportsTransactions() {
        if (this.file != null) {
            return this.file.supportsTransactions();
        }
        return false;
    }

    @Override
    public boolean begin() {
        if (this.supportsTransactions()) {
            return this.file.begin();
        }
        return false;
    }

    @Override
    public boolean commit() {
        if (this.supportsTransactions()) {
            return this.file.commit();
        }
        return false;
    }

    @Override
    public boolean rollback() {
        if (this.supportsTransactions()) {
            return this.file.rollback();
        }
        return false;
    }

    @Override
    public boolean recover() {
        if (this.supportsTransactions()) {
            return this.file.recover();
        }
        return false;
    }

    @Override
    public idxFile setPassword(Variable identifier) {
        return this;
    }

    private PreparedStatement getPreparedStatement(String prepStmtKey) {
        PreparedStatement pstmt = this.keyToPreparedStatementMap.get(prepStmtKey);
        return pstmt;
    }

    private void makePreparedStatement(Variable var, String command, int mode, String prepStmtKey) {
        String cmd = command.toUpperCase();
        this.makeComparator(mode);
        PreparedStatement pstmt = null;
        String query = null;
        if ("READNEXT".equals(cmd) || "READ".equals(cmd) || "START".equals(cmd)) {
            query = "select * from " + this.sqlTableName + " where " + this.makeSqlWhere(var) + " order by " + this.makeSqlOrderBy(var);
        }
        if ("WRITE".equals(cmd)) {
            query = "insert into " + this.sqlTableName + " values (" + this.makeSqlInsertPlaceHolders(var) + ")";
        }
        if ("DELETE".equals(cmd)) {
            query = "delete from " + this.sqlTableName + " where " + this.makeSqlWhere(this.keyArray[0]);
        }
        if ("REWRITE".equals(cmd)) {
            query = "update " + this.sqlTableName + " set " + this.makeSqlSet(var) + " where " + this.makeSqlWhere(this.keyArray[0]);
        }
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.fine("VSQL: query=" + query);
        }
        try {
            pstmt = this.writeable ? this.conn.prepareStatement(query, 1003, 1008) : this.conn.prepareStatement(query, 1003, 1007);
        }
        catch (SQLException e) {
            e.printStackTrace(System.err);
        }
        this.keyToPreparedStatementMap.put(prepStmtKey, pstmt);
    }

    private PreparedStatement procurePreparedStatement(Variable var, String command, int mode) {
        PreparedStatement pstmt;
        String func = ".procurePreparedStatement()";
        String cmd = command.toUpperCase();
        this.makeComparator(mode);
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(cmd).append(' ').append(var.getName()).append(' ').append(this.operator);
        String prepStmtKey = sbuf.toString();
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer("VSQL: key to prepared statement Map is " + prepStmtKey + ". mode=" + mode + ".");
        }
        if ((pstmt = this.getPreparedStatement(prepStmtKey)) != null) {
            return pstmt;
        }
        this.makePreparedStatement(var, command, mode, prepStmtKey);
        pstmt = this.getPreparedStatement(prepStmtKey);
        if (pstmt == null) {
            this.logit("PreparedStatement object should have been found! This java program has logic error.", ".procurePreparedStatement()");
        }
        return pstmt;
    }

    private String makeSqlOrderBy(Variable key) {
        int offset = key.getRecordPosition();
        int highOffset = offset + key.getLength();
        StringBuffer sbuf = new StringBuffer();
        int numOfColumns = 0;
        for (int i = 0; i < this.columns.size(); ++i) {
            SqlColumn col = this.columns.get(i);
            if (col.getOffset() < offset || col.getOffset() >= highOffset) continue;
            if (++numOfColumns > 1) {
                sbuf.append(", ");
            }
            sbuf.append(col.getName());
        }
        String str = sbuf.toString();
        return str;
    }

    private String makeSqlSet(Variable key) {
        int offset = key.getRecordPosition();
        int highOffset = offset + key.getLength();
        StringBuffer sbuf = new StringBuffer();
        int numOfColumns = 0;
        for (int i = 0; i < this.columns.size(); ++i) {
            SqlColumn col = this.columns.get(i);
            if (col.getOffset() < offset || col.getOffset() >= highOffset) continue;
            if (++numOfColumns > 1) {
                sbuf.append(",");
            }
            sbuf.append(col.getName()).append("=?");
        }
        String str = sbuf.toString();
        return str;
    }

    private String makeSqlWhereEQ(Variable key) {
        Variable[] keyComponents = key instanceof VariableList ? ((VariableList)key).getList() : new Variable[]{key};
        StringBuffer sbuf = new StringBuffer();
        int numOfColumns = 0;
        for (Variable oneKeyComponent : keyComponents) {
            int offset = oneKeyComponent.getRecordPosition();
            int highOffset = offset + oneKeyComponent.getLength();
            for (int i = 0; i < this.columns.size(); ++i) {
                SqlColumn col = this.columns.get(i);
                if (col.getOffset() < offset || col.getOffset() >= highOffset) continue;
                if (++numOfColumns > 1) {
                    sbuf.append(" and ");
                }
                sbuf.append(col.getName()).append(" = ? ");
            }
        }
        String str = sbuf.toString();
        return str;
    }

    private String makeSqlWhere(Variable key) {
        SqlColumn col;
        if ("=".equals(this.comparator)) {
            return this.makeSqlWhereEQ(key);
        }
        Variable[] keyComponents = key instanceof VariableList ? ((VariableList)key).getList() : new Variable[]{key};
        StringBuffer sbuf = new StringBuffer();
        ArrayList<SqlColumn> cols = new ArrayList<SqlColumn>();
        for (Variable oneKeyComponent : keyComponents) {
            int offset = oneKeyComponent.getRecordPosition();
            int highOffset = offset + oneKeyComponent.getLength();
            for (int i = 0; i < this.columns.size(); ++i) {
                col = this.columns.get(i);
                if (col.getOffset() < offset || col.getOffset() >= highOffset) continue;
                cols.add(col);
            }
        }
        for (int i = 0; i < cols.size(); ++i) {
            if (i != 0) {
                sbuf.append(" or ");
            }
            for (int j = 0; j < cols.size() - i; ++j) {
                if (j == 0) {
                    sbuf.append('(');
                } else {
                    sbuf.append(" and ");
                }
                col = (SqlColumn)cols.get(j);
                if (j == cols.size() - i - 1) {
                    if (i == 0) {
                        sbuf.append(col.getName()).append(this.comparator).append(" ? ").append(')');
                        continue;
                    }
                    sbuf.append(col.getName()).append(" > ? ").append(')');
                    continue;
                }
                sbuf.append(col.getName()).append(" = ? ");
            }
        }
        String str = sbuf.toString();
        return str;
    }

    private String makeSqlInsertPlaceHolders(Variable intoVar) {
        StringBuffer sbuf = new StringBuffer();
        int numOfCol = 0;
        for (int i = 0; i < this.columns.size(); ++i) {
            if (++numOfCol > 1) {
                sbuf.append(',');
            }
            sbuf.append('?');
        }
        String str = sbuf.toString();
        return str;
    }

    private void makeComparator(int mode) {
        String func = ".obtainComparator(i)";
        switch (mode) {
            case 0: {
                this.comparator = "=";
                this.operator = "EQ";
                break;
            }
            case 1: {
                this.comparator = ">=";
                this.operator = "GE";
                break;
            }
            case 2: {
                this.comparator = ">";
                this.operator = "GT";
                break;
            }
            default: {
                this.logit("WARNING: VALID START COMPARATORS ARE =, >, >=, NOT <. ASSUMED = ", ".obtainComparator(i)");
                this.comparator = "=";
            }
        }
    }

    private void logit(String str, String methodName) {
        System.out.println("\n@OUT VSQLIndexedFile" + methodName + ": " + str);
        System.err.println("\n@ERR VSQLIndexedFile" + methodName + ": " + str + "\n");
    }

    private PreparedStatement fillStatementParameterValues(String func, String operation, int mode, Variable fromVar) throws SQLException {
        PreparedStatement prepStmt = this.procurePreparedStatement(fromVar, operation, mode);
        for (int i = 0; i < this.columns.size(); ++i) {
            SqlColumn col = this.columns.get(i);
            String value = col.snagToString(fromVar.getBytes(), 0);
            int j = i + 1;
            this.typeConversion(prepStmt, j, value);
        }
        return prepStmt;
    }

    private void commitIfNecessary(int records) throws SQLException {
        if (this.BuffSize > 0 && BUFFSIZE > 0) {
            this.BuffSize -= records;
            if (this.BuffSize <= 0) {
                this.conn.commit();
                this.BuffSize = BUFFSIZE;
            }
        }
    }

    private void typeConversion(PreparedStatement prepStmt, int j, String value) throws SQLException {
        ParameterMetaData parms = prepStmt.getParameterMetaData();
        DatabaseMetaData dbMeta = this.conn.getMetaData();
        if (!dbMeta.getDatabaseProductName().equals("Oracle")) {
            switch (parms.getParameterType(j)) {
                case -2: {
                    prepStmt.setBytes(j, value.getBytes());
                    break;
                }
                case 4: {
                    try {
                        prepStmt.setInt(j, Integer.parseInt(value));
                    }
                    catch (NumberFormatException e) {
                        prepStmt.setNull(j, 4);
                    }
                    break;
                }
                case 2: {
                    try {
                        prepStmt.setBigDecimal(j, new BigDecimal(value));
                    }
                    catch (NumberFormatException e) {
                        prepStmt.setNull(j, 2);
                    }
                    break;
                }
                case 6: 
                case 7: {
                    try {
                        prepStmt.setFloat(j, new Float(value).floatValue());
                    }
                    catch (NumberFormatException e) {
                        prepStmt.setNull(j, parms.getParameterType(j));
                    }
                    break;
                }
                case 8: {
                    try {
                        prepStmt.setDouble(j, new Double(value));
                    }
                    catch (NumberFormatException e) {
                        prepStmt.setNull(j, 8);
                    }
                    break;
                }
                default: {
                    if (dbMeta.getDatabaseProductName().equals("PostgreSQL")) {
                        prepStmt.setString(j, value.replace('\u0000', ' '));
                        break;
                    }
                    prepStmt.setString(j, value);
                    break;
                }
            }
        } else {
            prepStmt.setString(j, value);
        }
    }

    private static final class AccessType {
        private String name;
        private static final AccessType START = new AccessType("start");
        private static final AccessType READ = new AccessType("read");
        private static final AccessType READ_NEXT = new AccessType("readnext");

        private AccessType(String nm) {
            this.name = nm;
        }

        public String toString() {
            return this.name;
        }
    }
}

