/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.jfc;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;

class LBorder
extends AbstractBorder {
    public static final int RAISED = 0;
    public static final int LOWERED = 1;
    protected int etchType;
    protected Color highlightOuter;
    protected Color highlightInner;
    protected Color shadowInner;
    protected Color shadowOuter;
    protected Color lineColor;
    protected int type;
    protected int thickness = 1;
    protected boolean alternate = false;
    protected boolean roundedCorners = false;
    protected int verticalOffset = 0;

    public void setHighlight(Color value) {
        this.highlightOuter = value;
        if (this.highlightOuter != null) {
            this.highlightOuter = this.highlightOuter.brighter();
        }
        this.highlightInner = value;
    }

    public void setShadow(Color value) {
        this.shadowOuter = value;
        this.shadowInner = value;
        if (this.shadowInner != null) {
            this.shadowInner = this.shadowInner.brighter();
        }
    }

    public void setNormal() {
        this.type = 0;
    }

    public void setRaised() {
        this.type = 1;
    }

    public void setLowered() {
        this.type = 2;
    }

    public void setEngraved() {
        this.type = 3;
    }

    public void setRimmed() {
        this.type = 4;
    }

    public boolean isNormal() {
        return this.type == 0;
    }

    public boolean isRaised() {
        return this.type == 1;
    }

    public boolean isLowered() {
        return this.type == 2;
    }

    public boolean isEngraved() {
        return this.type == 3;
    }

    public boolean isRimmed() {
        return this.type == 4;
    }

    public void setDefault() {
        this.thickness = 1;
    }

    public void setHeavy() {
        this.thickness = 2;
    }

    public void setVeryHeavy() {
        this.thickness = 3;
    }

    public boolean isDefault() {
        return this.thickness == 1;
    }

    public boolean isHeavy() {
        return this.thickness == 2;
    }

    public boolean isVeryHeavy() {
        return this.thickness == 3;
    }

    public void setAlternate(boolean state) {
        this.alternate = state;
    }

    public boolean isAlternate() {
        return this.alternate;
    }

    public LBorder(int verticalOffset, int type, Color lineColor, Color highlight, Color shadow, int thickness, boolean alternate, boolean roundedCorners) {
        this.verticalOffset = verticalOffset;
        this.lineColor = lineColor;
        this.type = type;
        this.setHighlight(highlight);
        this.setShadow(shadow);
        this.thickness = thickness;
        this.alternate = alternate;
        this.roundedCorners = roundedCorners;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (height > this.verticalOffset) {
            y += this.verticalOffset;
            height -= this.verticalOffset;
        }
        if (this.type == 0) {
            Color oldColor = g.getColor();
            g.setColor(c.getForeground());
            if (!this.roundedCorners) {
                if (this.alternate) {
                    g.drawRect(x, y, width - 1, height - 1);
                    int i = this.thickness - 1;
                    g.drawRect(x + i, y + i, width - i - i - 1, height - i - i - 1);
                } else {
                    for (int i = 0; i < this.thickness; ++i) {
                        g.drawRect(x + i, y + i, width - i - i - 1, height - i - i - 1);
                    }
                }
            } else if (this.alternate) {
                g.drawRoundRect(x, y, width - 1, height - 1, 2, 2);
                int i = this.thickness - 1;
                g.drawRoundRect(x + i, y + i, width - i - i - 1, height - i - i - 1, 2, 2);
            } else {
                for (int i = 0; i < this.thickness; ++i) {
                    g.drawRoundRect(x + i, y + i, width - i - i - 1, height - i - i - 1, 2, 2);
                }
            }
            g.setColor(oldColor);
        } else if (this.type == 1) {
            this.paintRaisedBevel(c, g, x, y, width, height, this.thickness);
        } else if (this.type == 2) {
            this.paintLoweredBevel(c, g, x, y, width, height, this.thickness);
        } else if (this.type == 3 || this.type == 4) {
            int w = width;
            int h = height;
            g.translate(x, y);
            int half = this.thickness / 2;
            int i = 0;
            g.setColor(this.type == 4 ? this.getShadowColor(c) : this.getHighlightColor(c));
            for (i = half; i < this.thickness; ++i) {
                g.drawRect(i, i, w - this.thickness, h - this.thickness);
            }
            g.setColor(this.type == 4 ? this.getHighlightColor(c) : this.getShadowColor(c));
            for (i = 0; i < half; ++i) {
                g.drawRect(i, i, w - this.thickness, h - this.thickness);
            }
            g.translate(-x, -y);
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(this.thickness, this.thickness, this.thickness, this.thickness);
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        insets.right = insets.bottom = this.thickness;
        insets.top = insets.bottom;
        insets.left = insets.bottom;
        return insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    public Color getHighlightColor(Component c) {
        return this.highlightInner != null ? this.highlightInner : c.getBackground().brighter();
    }

    public Color getShadowColor(Component c) {
        return this.shadowOuter != null ? this.shadowOuter : c.getBackground().darker();
    }

    protected void paintRaisedBevel(Component c, Graphics g, int x, int y, int width, int height, int thickness) {
        Color oldColor = g.getColor();
        int h = height;
        int w = width;
        g.translate(x, y);
        g.setColor(this.getHighlightOuterColor(c));
        g.drawLine(0, 0, 0, h - 1);
        g.drawLine(1, 0, w - 1, 0);
        g.setColor(this.getShadowOuterColor(c));
        g.drawLine(1, h - 1, w - 1, h - 1);
        g.drawLine(w - 1, 1, w - 1, h - 2);
        for (int i = 1; i < thickness; ++i) {
            g.setColor(this.getHighlightInnerColor(c));
            g.drawLine(i, i, i, h - 1 - i);
            g.drawLine(i + 1, i, w - 1 - i, i);
            g.setColor(this.getShadowInnerColor(c));
            g.drawLine(i + 1, h - i - 1, w - i - 1, h - i - 1);
            g.drawLine(w - i - 1, i + 1, w - i - 1, h - i - 2);
        }
        g.translate(-x, -y);
        g.setColor(oldColor);
    }

    protected void paintLoweredBevel(Component c, Graphics g, int x, int y, int width, int height, int thickness) {
        Color oldColor = g.getColor();
        int h = height;
        int w = width;
        g.translate(x, y);
        g.setColor(this.getShadowInnerColor(c));
        g.drawLine(0, 0, 0, h - 1);
        g.drawLine(1, 0, w - 1, 0);
        g.setColor(this.getHighlightOuterColor(c));
        g.drawLine(1, h - 1, w - 1, h - 1);
        g.drawLine(w - 1, 1, w - 1, h - 2);
        for (int i = 1; i < thickness; ++i) {
            g.setColor(this.getShadowOuterColor(c));
            g.drawLine(i, i, i, h - i - 1);
            g.drawLine(i + 1, i, w - i - 1, i);
            g.setColor(this.getHighlightInnerColor(c));
            g.drawLine(i + 1, h - i - 1, w - i - 1, h - i - 1);
            g.drawLine(w - i - 1, i + 1, w - i - 1, h - i - 2);
        }
        g.translate(-x, -y);
        g.setColor(oldColor);
    }

    public Color getHighlightOuterColor(Component c) {
        return this.highlightOuter != null ? this.highlightOuter : c.getBackground().brighter().brighter();
    }

    public Color getHighlightInnerColor(Component c) {
        return this.highlightInner != null ? this.highlightInner : c.getBackground().brighter();
    }

    public Color getShadowInnerColor(Component c) {
        return this.shadowInner != null ? this.shadowInner : c.getBackground().darker();
    }

    public Color getShadowOuterColor(Component c) {
        return this.shadowOuter != null ? this.shadowOuter : c.getBackground().darker().darker();
    }
}

