/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.jfc;

import com.heirloomcomputing.ecs.exec.AcceptEvent;
import com.heirloomcomputing.ecs.exec.Handle;
import com.heirloomcomputing.ecs.exec.ProcedurePointer;
import com.heirloomcomputing.ecs.jfc.LComponent;
import com.heirloomcomputing.ecs.jfc.LListBox;
import com.heirloomcomputing.ecs.jfc.LListComboCellRenderer;
import com.heirloomcomputing.ecs.jfc.LListComboModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicComboBoxEditor;

public final class LComboBox
extends LComponent
implements ActionListener,
FocusListener,
ItemListener,
KeyListener {
    public static final int LEFT = 2;
    public static final int RIGHT = 4;
    public static final int CENTER = 0;
    public static final int UNALIGNED = 2;
    private int maxText;
    private int insertionIndex;
    private String searchText;
    private int queryIndex;
    private String itemToAdd = "";
    private boolean itemsAdded;
    JComboBox<Object> list;
    LListBox llist;
    JScrollPane scrollPane;
    Border defaultComboBorder;

    public LComboBox() {
        this.size = 12.0;
        this.lines = 5.0;
        this.style = 0;
        this.setLayout(new BorderLayout());
        this.llist = new LListBox(this);
        this.llist.setVisible(false);
        this.llist.setEntryFieldVisible(true);
        this.list = new JComboBox<Object>(){

            @Override
            protected void processComponentKeyEvent(KeyEvent event) {
                if (event.getKeyCode() == 9) {
                    event.consume();
                    return;
                }
                super.processComponentKeyEvent(event);
            }

            @Override
            public boolean isManagingFocus() {
                return true;
            }

            @Override
            public boolean isFocusTraversable() {
                return true;
            }
        };
        this.list.setEditor(new LBasicComboBoxEditor());
        this.list.setEditable(true);
        this.setModel(new LListComboModel());
        this.setRenderer(new LListComboCellRenderer(this));
        int value = (int)this.lines - 1;
        this.list.setMaximumRowCount(value);
        this.add(this.list, "North");
        this.add((Component)this.llist, "Center");
        this.defaultComboBorder = this.list.getBorder();
        this.adjustSize = 16;
    }

    @Override
    public void keyPressed(KeyEvent event) {
    }

    @Override
    public void keyReleased(KeyEvent event) {
        int keyCode = event.getKeyCode();
        if (keyCode == 38) {
            return;
        }
        if (keyCode == 40) {
            return;
        }
        if (keyCode == 37) {
            return;
        }
        if (keyCode == 39) {
            return;
        }
        this.processKey(this, event);
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.updateValue();
        if (this.exceptionValue != 0) {
            this.processAcceptKey(new AcceptEvent(this.getHandle(), 2, this.exceptionValue, event));
        } else if (this.terminationValue != 0) {
            this.processAcceptKey(new AcceptEvent(this.getHandle(), 1, this.terminationValue, event));
        } else if (this.isNotifyDblclick()) {
            this.processAcceptEvent(new AcceptEvent(this.getHandle(), 0, 5, event));
        }
    }

    @Override
    public void focusGained(FocusEvent event) {
        if (!this.isSelfAct() && this.processGotoEvent(new AcceptEvent(this.getHandle(), 0, 3, event))) {
            return;
        }
    }

    @Override
    public void focusLost(FocusEvent event) {
        if (event.isTemporary()) {
            return;
        }
        if (this.processAcceptEvent(new AcceptEvent(this.getHandle(), 0, 16391, event))) {
            this.requestFocus();
            return;
        }
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        int state = evt.getStateChange();
        if (state != 1) {
            return;
        }
        if (this.isNotifySelchange()) {
            final ItemEvent event = evt;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LComboBox.this.processAcceptEvent(new AcceptEvent(LComboBox.this.getHandle(), 0, 4099, event, LComboBox.this.list.getSelectedIndex() + 1));
                }
            });
        }
    }

    public void addConstantListeners() {
        try {
            this.list.addFocusListener(this);
            this.list.addActionListener(this);
            this.list.addItemListener(this);
            this.list.addKeyListener(this);
            Component c = this.list.getEditor().getEditorComponent();
            c.addKeyListener(this);
            c.addFocusListener(this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void removeConstantListeners() {
        try {
            this.list.removeFocusListener(this);
            this.list.removeItemListener(this);
            this.list.removeActionListener(this);
            this.list.removeKeyListener(this);
            Component c = this.list.getEditor().getEditorComponent();
            c.removeKeyListener(this);
            c.removeKeyListener(this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.isStaticList()) {
            this.list.setPopupVisible(true);
        }
        this.addConstantListeners();
    }

    @Override
    public void removeNotify() {
        this.removeConstantListeners();
        super.removeNotify();
    }

    public void setModel(LListComboModel model) {
        this.list.setModel(model);
        this.llist.setModel(model);
    }

    public void setRenderer(LListComboCellRenderer renderer) {
        this.list.setRenderer(renderer);
        this.llist.setRenderer(renderer);
    }

    @Override
    public void setEnabled(boolean state) {
        this.list.setEnabled(state);
        this.llist.setEnabled(state);
        super.setEnabled(state);
    }

    @Override
    public boolean isManagingFocus() {
        return true;
    }

    @Override
    public void requestChildFocus() {
        if (this.llist.isVisible()) {
            this.llist.requestChildFocus();
        } else if (this.list.isEditable()) {
            this.list.getEditor().getEditorComponent().requestFocus();
        } else {
            this.list.requestFocus();
        }
    }

    @Override
    public boolean hasFocusChild() {
        return this.hasFocus() || this.list.hasFocus() || this.llist.hasFocusChild();
    }

    @Override
    public int getControlType() {
        return 8;
    }

    @Override
    public void updateValue() {
        this.setValue(this.getValue());
        super.updateValue();
    }

    public JComboBox<Object> getJComboBox() {
        return this.list;
    }

    public LListBox getLList() {
        return this.llist;
    }

    @Override
    public void setLines(double lines) {
        super.setLines(lines);
        int value = (int)(lines - 1.0);
        this.list.setMaximumRowCount(value);
        this.llist.setLines(lines);
    }

    public LListComboModel getListModel() {
        return (LListComboModel)this.list.getModel();
    }

    @Override
    public void setHandle(Handle myHandle) {
        super.setHandle(myHandle);
        this.llist.setHandle(myHandle);
    }

    @Override
    public String getValue() {
        try {
            if (this.llist.isVisible()) {
                return this.llist.getValue();
            }
            String value = (String)this.list.getSelectedItem();
            if (value == null) {
                value = " ";
            }
            try {
                if (this.maxText > 0) {
                    value = value.substring(0, this.maxText);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return value;
        }
        catch (Throwable t) {
            return " ";
        }
    }

    @Override
    public void setValue(String value) {
        if (this.llist.isVisible()) {
            try {
                this.llist.setValueInternal(value);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return;
        }
        try {
            String string2 = value = value == null ? "" : value.replace('\u0000', ' ').trim();
            if (this.list.isEditable()) {
                this.list.setSelectedItem(value);
            } else {
                int index = this.getListModel().find(value);
                if (index >= 0) {
                    this.list.setSelectedIndex(index);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean isDropDown() {
        return this.isStyle(0);
    }

    public int getDropDown() {
        return this.isDropDown() ? 1 : 0;
    }

    public void setDropDown() {
        this.setStyleOn(0);
    }

    public void setDropDown(boolean state) {
        this.setStyle(0, state);
    }

    public boolean isStaticList() {
        return this.isStyle(2);
    }

    public int getStaticList() {
        return this.isStaticList() ? 1 : 0;
    }

    public void setStaticList() {
        this.setStyleOn(2);
    }

    public void setStaticList(boolean state) {
        this.setStyle(2, state);
    }

    public boolean isDropList() {
        return this.isStyle(4);
    }

    public int getDropList() {
        return this.isDropList() ? 1 : 0;
    }

    public void setDropList() {
        this.setStyleOn(4);
    }

    public void setDropList(boolean state) {
        this.setStyle(4, state);
    }

    public boolean isUnsorted() {
        return this.isStyle(1);
    }

    public int getUnsorted() {
        return this.isUnsorted() ? 1 : 0;
    }

    public void setUnsorted() {
        this.setStyleOn(1);
    }

    public void setUnsorted(boolean state) {
        this.setStyle(1, state);
    }

    public boolean isSorted() {
        return !this.isStyle(1);
    }

    public int getSorted() {
        return this.isSorted() ? 1 : 0;
    }

    public void setSorted() {
        this.setStyleOff(1);
    }

    public void setSorted(boolean state) {
        this.setStyle(1, !state);
    }

    public boolean isNoBox() {
        return this.isStyle(2);
    }

    public void setNoBox() {
        this.setStyleOn(16, 0x2000008);
    }

    public void setNoBox(boolean state) {
        this.setStyle(16, state, 0x2000008);
    }

    public boolean isBox() {
        return this.isStyle(8);
    }

    public void setBox() {
        this.setStyleOn(8, 0x2000010);
    }

    public void setBox(boolean state) {
        this.setStyle(8, state, 0x2000010);
    }

    public boolean isBoxed() {
        return this.isStyle(8);
    }

    public void setBoxed() {
        this.setStyleOn(8, 0x2000010);
    }

    public void setBoxed(boolean state) {
        this.setStyle(8, state, 0x2000010);
    }

    public boolean isNotifyDblclick() {
        return this.isStyle(256);
    }

    public int getNotifyDblclick() {
        return this.isNotifyDblclick() ? 1 : 0;
    }

    public void setNotifyDblclick() {
        this.setStyleOn(256);
    }

    public void setNotifyDblclick(boolean state) {
        this.setStyle(256, state);
    }

    public boolean isNotifySelchange() {
        return this.isStyle(512);
    }

    public int getNotifySelchange() {
        return this.isNotifySelchange() ? 1 : 0;
    }

    public void setNotifySelchange() {
        this.setStyleOn(512);
    }

    public void setNotifySelchange(boolean state) {
        this.setStyle(512, state);
    }

    @Override
    public boolean isUpper() {
        return this.isStyle(2048);
    }

    public int getUpper() {
        return this.isUpper() ? 1 : 0;
    }

    public void setUpper() {
        this.setStyleOn(2048);
    }

    public void setUpper(boolean state) {
        this.setStyle(2048, state);
    }

    @Override
    public boolean isLower() {
        return this.isStyle(4096);
    }

    public int getLower() {
        return this.isLower() ? 1 : 0;
    }

    public void setLower() {
        this.setStyleOn(4096);
    }

    public void setLower(boolean state) {
        this.setStyle(4096, state);
    }

    @Override
    public void setStyle(int mask) {
        int change = this.style ^ mask;
        if ((change & 1) == 1 && (mask & 1) == 1 && COMPATIBILITY >= 2 && this.itemsAdded()) {
            mask &= 0xFFFFFFFE;
            change ^= 1;
        }
        if ((change & 6) != 0) {
            if ((mask & 4) == 4) {
                this.llist.setVisible(false);
                this.list.setVisible(true);
                this.list.setEditable(false);
                this.adjustSize = 16;
                this.setColumns(this.size);
            } else if ((mask & 2) == 2) {
                boolean wasInFocus = this.list.hasFocus();
                this.list.setVisible(false);
                this.llist.setVisible(true);
                if (wasInFocus) {
                    this.llist.requestFocus();
                }
                this.adjustSize = 0;
                this.setColumns(this.size);
            } else if ((mask & 0) == 0) {
                this.llist.setVisible(false);
                this.list.setVisible(true);
                this.list.setEditable(true);
                this.adjustSize = 16;
                this.setColumns(this.size);
            }
            this.revalidateAndDisplay();
        }
        super.setStyle(mask);
        if ((mask & 2) == 2) {
            int llistStyle = mask;
            llistStyle &= 0x7FE01B01;
            if ((mask & 8) == 8) {
                llistStyle |= 4;
            }
            if ((mask & 0x10) == 16) {
                llistStyle |= 2;
            }
            this.llist.setStyle(llistStyle);
        }
    }

    @Override
    public void setProperty(int number, Object property) {
        switch (number) {
            case 4: {
                this.setMaxText(this.getInt(property));
                break;
            }
            case 3: {
                this.setMassUpdate(this.getInt(property));
                break;
            }
            case 5: {
                this.setInsertionIndex(this.getInt(property));
                break;
            }
            case 4097: {
                this.setItemToAdd(this.getString(property));
                break;
            }
            case 4098: {
                this.setResetList(this.getInt(property));
                break;
            }
            case 4099: {
                this.setItemToDelete(this.getInt(property));
                break;
            }
            default: {
                super.setProperty(number, property);
            }
        }
    }

    @Override
    public String getProperty(int number) {
        switch (number) {
            case 4: {
                return String.valueOf(this.getMaxText());
            }
            case 3: {
                return String.valueOf(this.getMassUpdate());
            }
            case 5: {
                return String.valueOf(this.getInsertionIndex());
            }
            case 4097: {
                return this.getItemToAdd();
            }
            case 4098: {
                return String.valueOf(this.getResetList());
            }
            case 4099: {
                return String.valueOf(this.getItemToDelete());
            }
        }
        return super.getProperty(number);
    }

    @Override
    public void setTerminationValue(int value) {
        this.llist.setTerminationValue(value);
        super.setTerminationValue(value);
    }

    @Override
    public void setExceptionValue(int value) {
        this.llist.setExceptionValue(value);
        super.setExceptionValue(value);
    }

    @Override
    public void setWindow(Component window) {
        this.llist.setWindow(window);
        super.setWindow(window);
    }

    @Override
    public void setLinesCells(double lines) {
        super.setLinesCells(lines);
        this.llist.setLinesCells(lines);
    }

    @Override
    public void setLinesUnits(double lines) {
        super.setLinesUnits(lines);
        this.llist.setLinesUnits(lines);
    }

    @Override
    public void setColumns(double size) {
        super.setColumns(size);
        this.llist.setColumns(size);
    }

    @Override
    public void setColumnsCells(double size) {
        super.setColumnsCells(size);
        this.llist.setColumnsCells(size);
    }

    @Override
    public void setColumnsUnits(double size) {
        super.setColumnsUnits(size);
        this.llist.setColumnsUnits(size);
    }

    public void setMaxText(int value) {
        this.maxText = value;
    }

    public int getMaxText() {
        return this.maxText;
    }

    public void setMassUpdate(int value) {
        this.setMassUpdate(value != 0);
    }

    public void setMassUpdate(boolean state) {
        this.getListModel().setMassUpdate(state);
    }

    public boolean isMassUpdate() {
        return this.getListModel().isMassUpdate();
    }

    public int getMassUpdate() {
        return this.isMassUpdate() ? 1 : 0;
    }

    public void setInsertionIndex(int value) {
        this.insertionIndex = value;
        this.llist.setInsertionIndex(value);
    }

    public int getInsertionIndex() {
        if (this.llist.isVisible()) {
            return this.llist.getInsertionIndex();
        }
        return this.insertionIndex;
    }

    public void setDataColumns(int value) {
        if (value < 1) {
            this.getListModel().resetDataColumns();
        } else {
            this.getListModel().addDataColumn(value - 1);
        }
    }

    public void setDisplayColumns(int value) {
        if (value < 1) {
            this.getListModel().resetDisplayColumns();
        } else {
            this.getListModel().addDisplayColumn(value - 1);
        }
    }

    public void setQueryIndex(int value) {
        this.queryIndex = value;
    }

    public void setAlignment(String value) {
        if (value != null && value.length() > 0) {
            char c = Character.toUpperCase(value.charAt(0));
            switch (c) {
                case 'L': {
                    this.getListModel().addAlignment(2);
                    return;
                }
                case 'R': {
                    this.getListModel().addAlignment(4);
                    return;
                }
                case 'C': {
                    this.getListModel().addAlignment(0);
                    return;
                }
                case 'U': {
                    this.getListModel().addAlignment(2);
                    return;
                }
            }
        }
        this.getListModel().resetAlignment();
    }

    public void setSeparation(int value) {
        if (value < 0) {
            this.getListModel().resetSeparation();
        } else {
            this.getListModel().addSeparation(value);
        }
    }

    public void setDividers(int value) {
        if (value < 0) {
            this.getListModel().resetDividers();
        } else {
            this.getListModel().addDivider(value);
        }
    }

    public void setSortOrder(int value) {
        if (value >= 0 && value <= 3) {
            this.getListModel().setSortOrder(value);
        }
    }

    public boolean itemsAdded() {
        return this.itemsAdded;
    }

    public void setItemToAdd(Object[] values) {
        for (int i = 1; i < values.length; ++i) {
            this.setItemToAdd(String.valueOf(values[i]));
        }
    }

    public void setItemToAdd(String value) {
        if (value == null) {
            return;
        }
        if ((value = value.trim()).length() <= 0) {
            return;
        }
        this.itemsAdded = true;
        this.itemToAdd = value;
        if (this.insertionIndex == 0) {
            if (this.isUnsorted()) {
                this.getListModel().addElement(value);
            } else {
                this.getListModel().addSortedElement(value);
            }
        } else {
            this.getListModel().insertElementAt(value, this.insertionIndex - 1);
        }
    }

    public String getItemToAdd() {
        return this.itemToAdd;
    }

    public void setResetList(int value) {
        if (value != 0) {
            this.getListModel().removeAllElements();
        }
    }

    public int getResetList() {
        return 0;
    }

    public void setItemToDelete(int value) {
        try {
            if (value > 0) {
                this.getListModel().removeElementAt(value - 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getItemToDelete() {
        return 0;
    }

    public void setSearchText(String value) {
        this.searchText = value;
    }

    public String getSearchText() {
        return this.searchText;
    }

    public void setSelectionIndex(int value) {
        if (this.llist.isVisible()) {
            this.llist.setSelectionIndex(value);
            return;
        }
        try {
            if (value < 0) {
                this.list.removeAllItems();
            } else {
                this.list.setSelectedIndex(value - 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getSelectionIndex() {
        if (this.llist.isVisible()) {
            return this.llist.getSelectionIndex();
        }
        try {
            return this.list.getSelectedIndex() + 1;
        }
        catch (Exception e) {
            return -1;
        }
    }

    public void setItemValue(String value) {
        try {
            this.getListModel().setElementAt(value, this.queryIndex - 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getItemValue() {
        try {
            return (String)this.getListModel().elementAt(this.queryIndex - 1);
        }
        catch (Exception exception) {
            return " ";
        }
    }

    public void setThumbPosition(int value) {
        if (value > 0) {
            this.list.setToolTipText(String.valueOf(value));
        } else {
            this.list.setToolTipText(null);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return this.scrollPane.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.scrollPane.getMinimumSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.scrollPane.getMaximumSize();
    }

    @Override
    public void setBackground(Color c) {
        this.scrollPane.setBackground(c);
        this.list.setBackground(c);
        this.llist.setBackground(c);
        super.setBackground(c);
    }

    @Override
    public void setForeground(Color c) {
        this.scrollPane.setForeground(c);
        this.list.setForeground(c);
        this.llist.setForeground(c);
        super.setForeground(c);
    }

    @Override
    public void setOpaque(boolean state) {
        this.scrollPane.setOpaque(state);
        this.llist.setOpaque(state);
        super.setOpaque(state);
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        if (this.scrollPane != null) {
            this.scrollPane.setFont(f);
        }
        if (this.list != null) {
            this.list.setFont(f);
        }
        if (this.llist != null) {
            this.llist.setFont(f);
        }
    }

    @Override
    public void setEventProcedure(ProcedurePointer eventProcedure) {
        this.llist.setEventProcedure(eventProcedure);
        super.setEventProcedure(eventProcedure);
    }

    @Override
    public void setBeforeProcedure(ProcedurePointer eventProcedure) {
        this.llist.setBeforeProcedure(eventProcedure);
        super.setBeforeProcedure(eventProcedure);
    }

    @Override
    public void setAfterProcedure(ProcedurePointer eventProcedure) {
        this.llist.setAfterProcedure(eventProcedure);
        super.setAfterProcedure(eventProcedure);
    }

    @Override
    public void setExceptionProcedure(ProcedurePointer eventProcedure) {
        this.llist.setExceptionProcedure(eventProcedure);
        super.setExceptionProcedure(eventProcedure);
    }

    class LBasicComboBoxEditor
    extends BasicComboBoxEditor {
        public LBasicComboBoxEditor() {
            this.editor = new JTextField(){

                @Override
                public String toString() {
                    return "LBasicComboBoxEditor";
                }

                @Override
                protected void processComponentKeyEvent(KeyEvent event) {
                    if (event.getKeyCode() == 9) {
                        event.consume();
                        return;
                    }
                    super.processComponentKeyEvent(event);
                }

                @Override
                public boolean isManagingFocus() {
                    return true;
                }

                @Override
                public void setBorder(Border b) {
                }
            };
        }
    }
}

