/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.jfc;

import com.heirloomcomputing.ecs.exec.AcceptEvent;
import com.heirloomcomputing.ecs.jfc.LComponent;
import com.heirloomcomputing.ecs.jfc.LListComboCellRenderer;
import com.heirloomcomputing.ecs.jfc.LListComboModel;
import com.heirloomcomputing.ecs.jfc.LPager;
import com.heirloomcomputing.ecs.jfc.PageListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.EventObject;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public final class LListBox
extends LComponent
implements FocusListener,
MouseListener,
ListSelectionListener,
KeyListener,
PageListener,
DocumentListener {
    public static final int LEFT = 2;
    public static final int RIGHT = 4;
    public static final int CENTER = 0;
    public static final int UNALIGNED = 2;
    JList<Object> list;
    JScrollPane scrollPane;
    Border defaultScrollBorder;
    LPager pager;
    JTextField entryField;
    LComponent parentComponent;
    private int insertionIndex;
    private String searchText = "";
    private boolean spinGeneratedItem;
    private boolean entryFieldHasFocus;
    private boolean itemsAdded;
    private int queryIndex = 0;

    public LListBox() {
        this(null);
    }

    public LListBox(LComponent parent) {
        this.parentComponent = parent;
        this.lines = 5.0;
        this.size = 12.0;
        this.entryField = new JTextField(){

            @Override
            protected void processComponentKeyEvent(KeyEvent event) {
                if (event.getKeyCode() == 9) {
                    event.consume();
                    return;
                }
                super.processComponentKeyEvent(event);
            }

            @Override
            public boolean isManagingFocus() {
                return true;
            }
        };
        this.entryField.setFont(null);
        this.entryField.setVisible(false);
        this.pager = new LPager();
        this.pager.setVisible(false);
        this.list = new JList<Object>(){

            @Override
            protected void processComponentKeyEvent(KeyEvent event) {
                if (event.getKeyCode() == 9) {
                    event.consume();
                    return;
                }
                super.processComponentKeyEvent(event);
            }

            @Override
            public boolean isManagingFocus() {
                return true;
            }
        };
        this.setModel(new LListComboModel());
        this.setRenderer(new LListComboCellRenderer(this));
        this.list.setSelectionMode(0);
        this.scrollPane = new JScrollPane(this.list);
        this.defaultScrollBorder = this.scrollPane.getBorder();
        this.setLayout(new BorderLayout());
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)this.entryField, "North");
        this.add((Component)this.pager, "East");
        this.adjustSize = 12;
    }

    @Override
    public void keyPressed(KeyEvent event) {
    }

    @Override
    public void keyReleased(KeyEvent event) {
        int keyCode;
        if ((this.style & 0x400) == 1024) {
            keyCode = event.getKeyCode();
            if (keyCode == 33) {
                this.pageIncrease();
                return;
            }
            if (keyCode == 34) {
                this.pageDecrease();
                return;
            }
            if (keyCode == 38) {
                if (this.list.getSelectedIndex() == 0) {
                    this.spinnerIncrease();
                    return;
                }
            } else if (keyCode == 40) {
                int listSize;
                int listIndex = this.list.getSelectedIndex();
                if (listIndex == (listSize = this.getListModel().getSize()) - 1) {
                    this.spinnerDecrease();
                    return;
                }
            } else if (keyCode >= 32 && keyCode < 127) {
                event.consume();
                this.showSearchBox(event);
                return;
            }
        }
        if (event.getModifiers() == 0) {
            keyCode = event.getKeyCode();
            if (keyCode == 38) {
                return;
            }
            if (keyCode == 40) {
                return;
            }
            if (keyCode == 37) {
                return;
            }
            if (keyCode == 39) {
                return;
            }
        }
        this.processKey(this, event);
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }

    public void addConstantListeners() {
        try {
            this.list.addFocusListener(this);
            this.list.addMouseListener(this);
            this.list.addListSelectionListener(this);
            this.list.addKeyListener(this);
            this.pager.addPageListener(this);
            this.entryField.getDocument().addDocumentListener(this);
            this.entryField.addFocusListener(this);
            this.entryField.addKeyListener(this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void removeConstantListeners() {
        try {
            this.list.removeFocusListener(this);
            this.list.removeMouseListener(this);
            this.list.removeListSelectionListener(this);
            this.list.removeKeyListener(this);
            this.pager.removePageListener(this);
            this.entryField.getDocument().removeDocumentListener(this);
            this.entryField.removeFocusListener(this);
            this.entryField.removeKeyListener(this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        if ((this.style & 0x400) == 1024 && event.isPopupTrigger()) {
            event.consume();
            this.showSearchBox(event);
            return;
        }
        if (event.getClickCount() == 2) {
            if (this.exceptionValue != 0) {
                this.processAcceptKey(new AcceptEvent(this.getHandle(), 2, this.exceptionValue, event));
            } else if (this.terminationValue != 0) {
                this.processAcceptKey(new AcceptEvent(this.getHandle(), 1, this.terminationValue, event));
            } else if (this.isNotifyDblclick()) {
                this.processAcceptEvent(new AcceptEvent(this.getHandle(), 0, 5, event));
            }
            event.consume();
            return;
        }
        super.mouseClicked(event);
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        super.mouseEntered(event);
    }

    @Override
    public void mouseExited(MouseEvent event) {
        super.mouseExited(event);
    }

    @Override
    public void mousePressed(MouseEvent event) {
        if ((this.style & 0x400) == 1024 && event.isPopupTrigger()) {
            event.consume();
            this.showSearchBox(event);
            return;
        }
        super.mousePressed(event);
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        if ((this.style & 0x400) == 1024 && event.isPopupTrigger()) {
            event.consume();
            this.showSearchBox(event);
            return;
        }
        super.mouseReleased(event);
    }

    private boolean showSearchBox(EventObject event) {
        String searchPrompt = LListBox.getParameter("SEARCH-PROMPT");
        if (searchPrompt == null) {
            searchPrompt = "Enter Search Text:";
        }
        this.searchText = JOptionPane.showInputDialog(this, (Object)searchPrompt);
        if (this.searchText != null) {
            this.processAcceptEvent(new AcceptEvent(this.getHandle(), 0, 4107, event, this.searchText.length()));
            return true;
        }
        return false;
    }

    @Override
    public void spinnerIncrease() {
        this.spinGeneratedItem = true;
        if (this.processAcceptEvent(new AcceptEvent(this.getHandle(), 0, 4102, null))) {
            return;
        }
    }

    @Override
    public void spinnerDecrease() {
        this.spinGeneratedItem = true;
        if (this.processAcceptEvent(new AcceptEvent(this.getHandle(), 0, 4101, null))) {
            return;
        }
    }

    @Override
    public void pageIncrease() {
        this.spinGeneratedItem = true;
        if (this.processAcceptEvent(new AcceptEvent(this.getHandle(), 0, 4104, null))) {
            return;
        }
    }

    @Override
    public void pageDecrease() {
        this.spinGeneratedItem = true;
        if (this.processAcceptEvent(new AcceptEvent(this.getHandle(), 0, 4103, null))) {
            return;
        }
    }

    @Override
    public void pageFirst() {
        this.spinGeneratedItem = true;
        if (this.processAcceptEvent(new AcceptEvent(this.getHandle(), 0, 4104, null))) {
            return;
        }
    }

    @Override
    public void pageLast() {
        this.spinGeneratedItem = true;
        if (this.processAcceptEvent(new AcceptEvent(this.getHandle(), 0, 4103, null))) {
            return;
        }
    }

    @Override
    public void focusGained(FocusEvent event) {
        this.entryFieldHasFocus = event.getSource() == this.entryField;
        if (event.isTemporary()) {
            return;
        }
        if (!this.isSelfAct() && this.processGotoEvent(new AcceptEvent(this.getHandle(), 0, 3, event))) {
            return;
        }
    }

    @Override
    public void focusLost(FocusEvent event) {
        if (event.isTemporary()) {
            return;
        }
        if (this.processAcceptEvent(new AcceptEvent(this.getHandle(), 0, 16391, event))) {
            this.requestFocus();
            return;
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        if (!this.entryField.hasFocus()) {
            this.entryFieldHasFocus = false;
            this.entryField.setText(this.getValue());
        }
        if (event.getValueIsAdjusting()) {
            return;
        }
        this.updateValue();
        if (this.isNotifySelchange() && this.processAcceptEvent(new AcceptEvent(this.getHandle(), 0, 4099, event, event.getFirstIndex() + 1))) {
            return;
        }
    }

    @Override
    public void changedUpdate(DocumentEvent event) {
    }

    @Override
    public void insertUpdate(DocumentEvent event) {
        this.updateListFromEntryField();
    }

    @Override
    public void removeUpdate(DocumentEvent event) {
        this.updateListFromEntryField();
    }

    @Override
    public void updateValue() {
        if (this.parentComponent != null) {
            this.parentComponent.updateValue();
        }
        super.updateValue();
    }

    @Override
    public LComponent getLParent() {
        if (this.parentComponent != null) {
            return this.parentComponent.getLParent();
        }
        return super.getLParent();
    }

    private void updateListFromEntryField() {
        if (this.entryField.hasFocus()) {
            this.entryFieldHasFocus = true;
            String text = this.entryField.getText();
            this.setValue(text);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        Font f = this.getFont();
        if (f != null) {
            this.list.setFixedCellHeight(this.getDefaultUnitHeight(f));
        }
        this.addConstantListeners();
    }

    @Override
    public void removeNotify() {
        this.removeConstantListeners();
        super.removeNotify();
    }

    @Override
    public boolean isManagingFocus() {
        return true;
    }

    public void setEntryFieldVisible(boolean state) {
        this.entryField.setVisible(state);
        if (state && this.list.hasFocus()) {
            this.entryFieldHasFocus = true;
            this.entryField.requestFocus();
        }
        this.revalidateAndDisplay();
    }

    @Override
    public boolean isFocusable() {
        if (this.isEntryFieldVisible()) {
            return this.entryField.isFocusable();
        }
        return super.isFocusable();
    }

    public boolean isEntryFieldVisible() {
        return this.entryField.isVisible();
    }

    public int getEntryFieldVisible() {
        return this.isEntryFieldVisible() ? 1 : 0;
    }

    @Override
    public void requestChildFocus() {
        if (this.entryFieldHasFocus) {
            this.entryField.requestFocus();
        } else {
            this.list.requestFocus();
        }
    }

    @Override
    public boolean hasFocusChild() {
        return this.hasFocus() || this.list.hasFocus() || this.entryField.hasFocus();
    }

    public void setVerticalScrollBarPolicy(int value) {
        this.scrollPane.setVerticalScrollBarPolicy(value);
    }

    public int getVerticalScrollBarPolicy() {
        return this.scrollPane.getVerticalScrollBarPolicy();
    }

    @Override
    public int getControlType() {
        if (this.parentComponent != null) {
            return this.parentComponent.getControlType();
        }
        return 7;
    }

    @Override
    public void setInquireIndex(int value) {
        if (this.parentComponent != null) {
            this.parentComponent.setInquireIndex(value);
        } else {
            this.setQueryIndex(value);
        }
    }

    @Override
    public void setInquireIndex(int value1, int value2) {
        this.setInquireIndex(value1);
    }

    public LListComboModel getListModel() {
        return (LListComboModel)this.list.getModel();
    }

    public boolean hasElements() {
        LListComboModel listModel = this.getListModel();
        if (listModel != null) {
            return listModel.getSize() > 0;
        }
        return false;
    }

    public String getEntryFieldValue() {
        return this.entryField.getText();
    }

    public void setEntryFieldValue(String value) {
        if (value == null) {
            return;
        }
        if ((value = value.replace('\u0000', ' ').trim()).length() == 0) {
            return;
        }
        this.entryField.setText(value);
    }

    @Override
    public String getValue() {
        try {
            String value = (String)this.list.getSelectedValue();
            return value != null ? value : " ";
        }
        catch (Throwable t) {
            return " ";
        }
    }

    @Override
    public void setValue(String value) {
        if (this.parentComponent != null) {
            this.parentComponent.setValue(value);
        }
        this.setValueInternal(value);
    }

    public void setValueInternal(String value) {
        try {
            if (value == null) {
                return;
            }
            if ((value = value.replace('\u0000', ' ').trim()).length() == 0) {
                return;
            }
            int index = this.getListModel().find(value);
            if (index >= 0) {
                this.list.ensureIndexIsVisible(index);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean isUnsorted() {
        return this.isStyle(1);
    }

    public int getUnsorted() {
        return this.isUnsorted() ? 1 : 0;
    }

    public void setUnsorted() {
        this.setStyleOn(1);
    }

    public void setUnsorted(boolean state) {
        this.setStyle(1, state);
    }

    public boolean isSorted() {
        return !this.isStyle(1);
    }

    public int getSorted() {
        return this.isSorted() ? 1 : 0;
    }

    public void setSorted() {
        if (!this.itemsAdded()) {
            this.setStyleOff(1);
        }
    }

    public void setSorted(boolean state) {
        if (!this.itemsAdded()) {
            this.setStyle(1, !state);
        }
    }

    public boolean isNoBox() {
        return this.isStyle(2);
    }

    public int getNoBox() {
        return this.isNoBox() ? 1 : 0;
    }

    public void setNoBox() {
        this.setStyleOn(2, 0x2000004);
    }

    public void setNoBox(boolean state) {
        this.setStyle(2, state, 0x2000004);
    }

    public boolean isBox() {
        return this.isStyle(4);
    }

    public void setBox() {
        this.setStyleOn(4, 0x2000002);
    }

    public void setBox(boolean state) {
        this.setStyle(4, state, 0x2000002);
    }

    public boolean isBoxed() {
        return this.isStyle(4);
    }

    public int getBoxed() {
        return this.isBoxed() ? 1 : 0;
    }

    public void setBoxed() {
        this.setStyleOn(4, 0x2000002);
    }

    public void setBoxed(boolean state) {
        this.setStyle(4, state, 0x2000002);
    }

    public boolean isNotifyDblclick() {
        return this.isStyle(256);
    }

    public int getNotifyDblclick() {
        return this.isNotifyDblclick() ? 1 : 0;
    }

    public void setNotifyDblclick() {
        this.setStyleOn(256);
    }

    public void setNotifyDblclick(boolean state) {
        this.setStyle(256, state);
    }

    public boolean isNotifySelchange() {
        return this.isStyle(512);
    }

    public int getNotifySelchange() {
        return this.isNotifySelchange() ? 1 : 0;
    }

    public void setNotifySelchange() {
        this.setStyleOn(512);
    }

    public void setNotifySelchange(boolean state) {
        this.setStyle(512, state);
    }

    public boolean isPaged() {
        return this.isStyle(1024);
    }

    public int getPaged() {
        return this.isPaged() ? 1 : 0;
    }

    public void setPaged() {
        this.setStyleOn(1024);
    }

    public void setPaged(boolean state) {
        this.setStyle(1024, state);
    }

    @Override
    public boolean isUpper() {
        return this.isStyle(2048);
    }

    public int getUpper() {
        return this.isUpper() ? 1 : 0;
    }

    public void setUpper() {
        this.setStyleOn(2048);
    }

    public void setUpper(boolean state) {
        this.setStyle(2048, state);
    }

    @Override
    public boolean isLower() {
        return this.isStyle(4096);
    }

    public int getLower() {
        return this.isLower() ? 1 : 0;
    }

    public void setLower() {
        this.setStyleOn(4096);
    }

    public void setLower(boolean state) {
        this.setStyle(4096, state);
    }

    public boolean isNoSearch() {
        return this.isStyle(8192);
    }

    public int getNoSearch() {
        return this.isNoSearch() ? 1 : 0;
    }

    public void setNoSearch() {
        this.setStyleOn(8192);
    }

    public void setNoSearch(boolean state) {
        this.setStyle(8192, state);
    }

    @Override
    public void setStyle(int mask) {
        int change = this.style ^ mask;
        try {
            if ((change & 0x400) == 1024) {
                boolean paged;
                boolean bl = paged = (mask & 0x400) == 1024;
                if (paged) {
                    change = this.style ^ (mask |= 1);
                }
                this.pager.setVisible(paged);
                this.setVerticalScrollBarPolicy(paged ? 21 : 20);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if ((change & 1) == 1 && (mask & 1) == 1 && COMPATIBILITY >= 2 && this.itemsAdded()) {
                mask &= 0xFFFFFFFE;
                change ^= 1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if ((change & 0x2000006) != 0) {
                if ((mask & 4) == 4) {
                    this.scrollPane.setBorder(new LineBorder(Color.black, 1));
                } else if ((mask & 2) == 2) {
                    this.scrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
                } else if ((mask & 0x2000000) == 0x2000000) {
                    this.scrollPane.setBorder(new BevelBorder(1));
                } else {
                    this.scrollPane.setBorder(this.defaultScrollBorder);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.revalidateAndDisplay();
        super.setStyle(mask);
    }

    @Override
    public void setProperty(int number, Object property) {
        switch (number) {
            case 3: {
                this.setMassUpdate(this.getInt(property));
                break;
            }
            case 4: {
                this.setInsertionIndex(this.getInt(property));
                break;
            }
            case 5: {
                this.setDataColumns(this.getInt(property));
                break;
            }
            case 6: {
                this.setDisplayColumns(this.getInt(property));
                break;
            }
            case 7: {
                this.setQueryIndex(this.getInt(property));
                break;
            }
            case 8: {
                this.setAlignment(this.getString(property));
                break;
            }
            case 9: {
                this.setSeparation(this.getInt(property));
                break;
            }
            case 10: {
                this.setDividers(this.getInt(property));
                break;
            }
            case 11: {
                this.setSortOrder(this.getInt(property));
                break;
            }
            case 4097: {
                this.setItemToAdd(this.getString(property));
                break;
            }
            case 4098: {
                this.setResetList(this.getInt(property));
                break;
            }
            case 4099: {
                this.setItemToDelete(this.getInt(property));
                break;
            }
            case 4100: {
                this.setSearchText(this.getString(property));
                break;
            }
            case 4103: {
                this.setSelectionIndex(this.getInt(property));
                break;
            }
            case 4104: {
                this.setItemValue(this.getString(property));
                break;
            }
            case 4105: {
                this.setThumbPosition(this.getInt(property));
                break;
            }
            default: {
                super.setProperty(number, property);
            }
        }
    }

    @Override
    public String getProperty(int number) {
        switch (number) {
            case 3: {
                return String.valueOf(this.getMassUpdate());
            }
            case 4: {
                return String.valueOf(this.getInsertionIndex());
            }
            case 5: {
                return String.valueOf(this.getDataColumns());
            }
            case 6: {
                return String.valueOf(this.getDisplayColumns());
            }
            case 7: {
                return String.valueOf(this.getQueryIndex());
            }
            case 8: {
                return this.getAlignment();
            }
            case 9: {
                return String.valueOf(this.getSeparation());
            }
            case 10: {
                return String.valueOf(this.getDividers());
            }
            case 11: {
                return String.valueOf(this.getSortOrder());
            }
            case 4097: {
                return String.valueOf(this.getItemToAdd());
            }
            case 4098: {
                return String.valueOf(this.getResetList());
            }
            case 4099: {
                return String.valueOf(this.getItemToDelete());
            }
            case 4100: {
                return this.getSearchText();
            }
            case 4103: {
                return String.valueOf(this.getSelectionIndex());
            }
            case 4104: {
                return this.getItemValue();
            }
            case 4105: {
                return String.valueOf(this.getThumbPosition());
            }
        }
        return super.getProperty(number);
    }

    public void setMassUpdate(int value) {
        this.setMassUpdate(value != 0);
    }

    public void setMassUpdate(boolean state) {
        this.getListModel().setMassUpdate(state);
    }

    public boolean isMassUpdate() {
        return this.getListModel().isMassUpdate();
    }

    public int getMassUpdate() {
        return this.isMassUpdate() ? 1 : 0;
    }

    public void setInsertionIndex(int value) {
        this.insertionIndex = value;
    }

    public int getInsertionIndex() {
        return this.insertionIndex;
    }

    public void setDataColumns(int value) {
        if (value < 1) {
            this.getListModel().resetDataColumns();
        } else {
            this.getListModel().addDataColumn(value - 1);
        }
    }

    public int getDataColumns() {
        return 0;
    }

    public void setDisplayColumns(int value) {
        if (value < 1) {
            this.getListModel().resetDisplayColumns();
        } else {
            this.getListModel().addDisplayColumn(value - 1);
        }
    }

    public int getDisplayColumns() {
        return 0;
    }

    public void setQueryIndex(int value) {
        this.queryIndex = value;
    }

    public int getQueryIndex() {
        return this.queryIndex;
    }

    public void setAlignment(String value) {
        if (value != null && value.length() > 0) {
            char c = Character.toUpperCase(value.charAt(0));
            switch (c) {
                case 'L': {
                    this.getListModel().addAlignment(2);
                    return;
                }
                case 'R': {
                    this.getListModel().addAlignment(4);
                    return;
                }
                case 'C': {
                    this.getListModel().addAlignment(0);
                    return;
                }
                case 'U': {
                    this.getListModel().addAlignment(2);
                    return;
                }
            }
        }
        this.getListModel().resetAlignment();
    }

    public String getAlignment() {
        return "U";
    }

    public void setSeparation(int value) {
        if (value < 0) {
            this.getListModel().resetSeparation();
        } else {
            this.getListModel().addSeparation(value);
        }
    }

    public int getSeparation() {
        return 0;
    }

    public void setDividers(int value) {
        if (value < 0) {
            this.getListModel().resetDividers();
        } else {
            this.getListModel().addDivider(value);
        }
    }

    public int getDividers() {
        return 0;
    }

    public void setSortOrder(int value) {
        if (value >= 0 && value <= 3) {
            this.getListModel().setSortOrder(value);
        }
    }

    public int getSortOrder() {
        return 0;
    }

    public boolean itemsAdded() {
        return this.itemsAdded;
    }

    public void setItemToAdd(Object[] values) {
        for (int i = 1; i < values.length; ++i) {
            this.setItemToAdd(String.valueOf(values[i]));
        }
    }

    public void setItemToAdd(String value) {
        int selectionType = 0;
        if (value != null && (value = value.trim()).length() > 0) {
            this.itemsAdded = true;
            try {
                if ((this.style & 0x400) == 1024 && (double)this.getListModel().getSize() >= this.lines) {
                    if (this.insertionIndex == 0) {
                        selectionType = 1;
                        this.getListModel().removeFirstElement();
                        if (this.spinGeneratedItem) {
                            this.list.setSelectedIndex(this.getListModel().getSize() - 1);
                        }
                    } else {
                        selectionType = 2;
                        this.getListModel().removeLastElement();
                        if (this.spinGeneratedItem) {
                            this.list.setSelectedIndex(0);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.insertionIndex == 0) {
                if (this.isUnsorted()) {
                    this.getListModel().addElement(value);
                } else {
                    this.getListModel().addSortedElement(value);
                }
            } else {
                this.getListModel().insertElementAt(value, this.insertionIndex - 1);
                this.insertionIndex = 0;
            }
        }
        try {
            if (this.spinGeneratedItem) {
                switch (selectionType) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        this.list.setSelectedIndex(1);
                    }
                }
                this.spinGeneratedItem = false;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String getItemToAdd() {
        return "";
    }

    public void setResetList(int value) {
        if (value != 0) {
            this.getListModel().removeAllElements();
        }
    }

    public int getResetList() {
        return 0;
    }

    public void setItemToDelete(int value) {
        try {
            if (value > 0) {
                this.getListModel().removeElementAt(value - 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getItemToDelete() {
        return 0;
    }

    public void setSearchText(String value) {
        this.searchText = value;
    }

    public String getSearchText() {
        return this.searchText != null ? this.searchText : "";
    }

    public void setSelectionIndex(int value) {
        try {
            if (value < 0) {
                this.list.clearSelection();
            } else {
                this.list.setSelectedIndex(value - 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getSelectionIndex() {
        try {
            return this.list.getSelectedIndex() - 1;
        }
        catch (Exception e) {
            return -1;
        }
    }

    public void setItemValue(String value) {
        try {
            this.getListModel().setElementAt(value, this.queryIndex - 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getItemValue() {
        try {
            return (String)this.getListModel().elementAt(this.queryIndex - 1);
        }
        catch (Exception exception) {
            return " ";
        }
    }

    public void setThumbPosition(int value) {
        if (value > 0) {
            this.list.setToolTipText(String.valueOf(value));
            this.list.ensureIndexIsVisible(value - 1);
        } else {
            this.list.setToolTipText(null);
        }
    }

    public int getThumbPosition() {
        int value = this.list.getFirstVisibleIndex();
        return value < 0 ? 0 : value + 1;
    }

    public void setModel(LListComboModel model) {
        this.list.setModel(model);
    }

    public void setRenderer(LListComboCellRenderer renderer) {
        this.list.setCellRenderer(renderer);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.scrollPane.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.scrollPane.getMinimumSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.scrollPane.getMaximumSize();
    }

    @Override
    public void setBackground(Color c) {
        this.scrollPane.setBackground(c);
        this.list.setBackground(c);
        this.entryField.setBackground(c);
        super.setBackground(c);
    }

    @Override
    public void setForeground(Color c) {
        this.scrollPane.setForeground(c);
        this.list.setForeground(c);
        this.entryField.setForeground(c);
        super.setForeground(c);
    }

    @Override
    public void setOpaque(boolean state) {
        this.scrollPane.setOpaque(state);
        super.setOpaque(state);
    }

    @Override
    public void setEnabled(boolean state) {
        this.scrollPane.setEnabled(state);
        this.list.setEnabled(state);
        this.entryField.setEnabled(state);
        super.setEnabled(state);
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        this.scrollPane.setFont(f);
        this.list.setFont(f);
        this.list.setFixedCellHeight(f.getSize());
        this.entryField.setFont(f);
    }

    @Override
    public boolean processAcceptEvent(AcceptEvent event) {
        if (this.parentComponent != null) {
            return this.parentComponent.processAcceptEvent(event);
        }
        return super.processAcceptEvent(event);
    }

    @Override
    protected boolean processAcceptKey(AcceptEvent event) {
        if (this.parentComponent != null) {
            return this.parentComponent.processAcceptKey(event);
        }
        return super.processAcceptKey(event);
    }

    @Override
    protected boolean processKey(LComponent component, KeyEvent key) {
        if (this.parentComponent != null) {
            return this.parentComponent.processKey(this.parentComponent, key);
        }
        return super.processKey(component, key);
    }
}

