/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.jfc;

import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;

public final class LListComboModel
extends DefaultComboBoxModel<Object> {
    private boolean massUpdate = false;
    private int lowerRange = -1;
    private int upperRange = -1;
    private Vector<Object> vector = new Vector();
    public Vector<Integer> dataColumns = null;
    public Vector<Integer> displayColumns = null;
    public Vector<Integer> alignments = null;
    public Vector<Integer> dividers = null;
    public Vector<Integer> separators = null;
    private Integer ZERO = new Integer(0);
    public static final int PL_SORT_DEFAULT = 0;
    public static final int PL_SORT_NONE = 1;
    public static final int PL_SORT_NATIVE = 2;
    public static final int PL_SORT_NATIVE_IGNORE_CASE = 3;

    @Override
    public int getSize() {
        return this.vector.size();
    }

    @Override
    public Object getElementAt(int index) {
        try {
            return this.vector.elementAt(index);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public void copyInto(Object[] array) {
        this.vector.copyInto(array);
    }

    public void trimToSize() {
        this.vector.trimToSize();
    }

    public void ensureCapacity(int minCapacity) {
        this.vector.ensureCapacity(minCapacity);
    }

    public void setSize(int size) {
        int oldSize = this.vector.size();
        this.vector.setSize(oldSize);
        if (oldSize > size) {
            this.purge();
            this.fireIntervalRemoved(this, size, oldSize - 1);
        } else {
            this.purge();
            this.fireIntervalAdded(this, oldSize, size - 1);
        }
    }

    public int capacity() {
        return this.vector.capacity();
    }

    public int size() {
        return this.vector.size();
    }

    public boolean isEmpty() {
        return this.vector.isEmpty();
    }

    public Enumeration<Object> elements() {
        return this.vector.elements();
    }

    public boolean contains(Object elem) {
        return this.vector.contains(elem);
    }

    public int indexOf(Object elem) {
        return this.vector.indexOf(elem);
    }

    public int indexOf(Object elem, int index) {
        return this.vector.indexOf(elem, index);
    }

    public int lastIndexOf(Object elem) {
        return this.vector.lastIndexOf(elem);
    }

    public int lastIndexOf(Object elem, int index) {
        return this.vector.lastIndexOf(elem, index);
    }

    public Object elementAt(int index) {
        try {
            return this.vector.elementAt(index);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public Object firstElement() {
        return this.vector.firstElement();
    }

    public Object lastElement() {
        return this.vector.lastElement();
    }

    public void setElementAt(Object elem, int index) {
        this.vector.setElementAt(elem, index);
        this.smartContent(index);
    }

    public int find(String value) {
        int size = this.size();
        int best = 0;
        int bestCount = 0;
        String uvalue = value;
        if (uvalue == null) {
            return 0;
        }
        value = value.trim();
        for (int i = 0; i < size; ++i) {
            String check = (String)this.vector.elementAt(i);
            if (!value.equalsIgnoreCase(check)) continue;
            return i;
        }
        uvalue = value.toUpperCase();
        int vlen = uvalue.length();
        if (vlen <= 0) {
            return 0;
        }
        int clen = 0;
        int limit = 0;
        for (int i = 0; i < size; ++i) {
            String check = (String)this.vector.elementAt(i);
            if (check == null) continue;
            if (uvalue.equals(check = check.toUpperCase())) {
                return i;
            }
            clen = check.length();
            if (clen > vlen) {
                clen = vlen;
            }
            if (clen < (limit = vlen)) {
                limit = clen;
            }
            for (int j = 0; j < limit && check.charAt(j) == uvalue.charAt(j); ++j) {
                if (j <= bestCount) continue;
                bestCount = j;
                best = i;
            }
        }
        return best;
    }

    private void smartContent(int index) {
        if (!this.massUpdate) {
            this.fireContentsChanged(this, index, index);
        } else {
            if (this.lowerRange == -1) {
                this.lowerRange = index;
            } else if (index < this.lowerRange) {
                this.lowerRange = index;
            }
            if (this.upperRange == -1) {
                this.upperRange = index;
            } else if (index > this.upperRange) {
                this.upperRange = index;
            }
        }
    }

    @Override
    public void removeElementAt(int index) {
        if (index < 0 || index >= this.getSize()) {
            return;
        }
        this.vector.removeElementAt(index);
        this.purge();
        this.fireIntervalRemoved(this, index, index);
    }

    public void removeFirstElement() {
        this.removeElementAt(0);
    }

    public void removeLastElement() {
        this.removeElementAt(this.getSize() - 1);
    }

    @Override
    public void insertElementAt(Object elem, int index) {
        this.vector.insertElementAt(elem, index);
        this.smartContent(index);
    }

    @Override
    public void removeElement(Object elem) {
        int index = this.indexOf(elem);
        this.vector.removeElement(elem);
        if (index >= 0) {
            this.purge();
            this.fireIntervalRemoved(this, index, index);
        }
    }

    public boolean removingElement(Object elem) {
        int index = this.indexOf(elem);
        boolean removed = this.vector.removeElement(elem);
        if (index >= 0) {
            this.purge();
            this.fireIntervalRemoved(this, index, index);
        }
        return removed;
    }

    @Override
    public void removeAllElements() {
        int index = this.vector.size() - 1;
        this.vector.removeAllElements();
        if (index >= 0) {
            this.purge();
            this.fireIntervalRemoved(this, 0, index);
        }
    }

    public void setMassUpdate(boolean state) {
        if (this.massUpdate && !state) {
            this.purge();
        }
        this.massUpdate = state;
    }

    public boolean isMassUpdate() {
        return this.massUpdate;
    }

    public void purge() {
        if (this.lowerRange >= 0) {
            this.fireContentsChanged(this, this.lowerRange, this.upperRange);
        }
        this.lowerRange = -1;
        this.upperRange = -1;
    }

    @Override
    public void addElement(Object elem) {
        int index = this.vector.size();
        this.vector.addElement(elem);
        this.smartContent(index);
    }

    public void addSortedElement(String value) {
        try {
            int size = this.getSize();
            for (int i = 0; i < size; ++i) {
                if (value.compareTo((String)this.getElementAt(i)) >= 0) continue;
                this.insertElementAt(value, i);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.addElement(value);
    }

    public void resetDataColumns() {
        this.dataColumns = null;
    }

    public void addDataColumn(int value) {
        if (this.dataColumns == null) {
            this.dataColumns = new Vector();
            this.dataColumns.addElement(this.ZERO);
        }
        if (value > 0) {
            this.dataColumns.addElement(new Integer(value));
        }
    }

    public void resetDisplayColumns() {
        this.displayColumns = null;
    }

    public void addDisplayColumn(int value) {
        if (this.displayColumns == null) {
            this.displayColumns = new Vector();
            this.displayColumns.addElement(this.ZERO);
        }
        if (value > 0) {
            this.displayColumns.addElement(new Integer(value));
        }
    }

    public void resetAlignment() {
        this.alignments = null;
    }

    public void addAlignment(int value) {
        if (this.alignments == null) {
            this.alignments = new Vector();
        }
        this.alignments.addElement(new Integer(value));
    }

    public void resetSeparation() {
        this.separators = null;
    }

    public void addSeparation(int value) {
        if (this.separators == null) {
            this.separators = new Vector();
        }
        this.separators.addElement(new Integer(value));
    }

    public void resetDividers() {
        this.dividers = null;
    }

    public void addDivider(int value) {
        if (this.dividers == null) {
            this.dividers = new Vector();
        }
        this.dividers.addElement(new Integer(value));
    }

    public void setSortOrder(int value) {
        if (value == 0) {
            value = 1;
        }
    }
}

