/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.jfc;

import com.heirloomcomputing.ecs.exec.ThreadQueue;
import com.heirloomcomputing.ecs.jfc.DoubleArrowButton;
import com.heirloomcomputing.ecs.jfc.LComponent;
import com.heirloomcomputing.ecs.jfc.PageListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.plaf.basic.BasicArrowButton;

final class LPager
extends LComponent
implements MouseListener,
PageListener,
KeyListener {
    BasicArrowButton up;
    BasicArrowButton down;
    DoubleArrowButton pageUp;
    DoubleArrowButton pageDown;
    private int value;
    private int minimumValue;
    private int maximumValue;
    private boolean limits;
    private final Vector<PageListener> spinnerListeners = new Vector();
    private SpinnerThread spinnerThread;
    private int pageSize = 10;

    @Override
    public void keyPressed(KeyEvent event) {
    }

    @Override
    public void keyReleased(KeyEvent event) {
        this.processKey(this, event);
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }

    @Override
    public boolean isFocusTraversable() {
        return false;
    }

    @Override
    public boolean isAcceptable() {
        return false;
    }

    public Component getIncreaseComponent() {
        return this.up;
    }

    public Component getDecreaseComponent() {
        return this.down;
    }

    public Component getPageIncreaseComponent() {
        return this.pageUp;
    }

    public Component getPageDecreaseComponent() {
        return this.pageDown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPageListener(PageListener listener) {
        Vector<PageListener> vector = this.spinnerListeners;
        synchronized (vector) {
            this.spinnerListeners.addElement(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePageListener(PageListener listener) {
        Vector<PageListener> vector = this.spinnerListeners;
        synchronized (vector) {
            this.spinnerListeners.removeElement(listener);
        }
    }

    public LPager() {
        this.setReverseOrder(false);
        this.setLayout(new GridLayout(4, 1));
        this.up = new BasicArrowButton(1);
        this.down = new BasicArrowButton(5);
        this.pageUp = new DoubleArrowButton(1);
        this.pageDown = new DoubleArrowButton(5);
        this.up.setPreferredSize(new Dimension(15, 16));
        this.down.setPreferredSize(new Dimension(15, 16));
        this.pageUp.setPreferredSize(new Dimension(15, 16));
        this.pageDown.setPreferredSize(new Dimension(15, 16));
        this.up.setMaximumSize(new Dimension(15, 16));
        this.down.setMaximumSize(new Dimension(15, 16));
        this.pageUp.setMaximumSize(new Dimension(15, 16));
        this.pageDown.setMaximumSize(new Dimension(15, 16));
        this.add(this.up);
        this.add(this.pageUp);
        this.add(this.pageDown);
        this.add(this.down);
        this.up.addMouseListener(this);
        this.down.addMouseListener(this);
        this.pageUp.addMouseListener(this);
        this.pageDown.addMouseListener(this);
        this.up.addKeyListener(this);
        this.down.addKeyListener(this);
        this.pageUp.addKeyListener(this);
        this.pageDown.addKeyListener(this);
    }

    public void setMinimumValue(int value) {
        this.minimumValue = value;
    }

    public void setMaximumValue(int value) {
        this.maximumValue = value;
    }

    public void setLimits(boolean state) {
        if (this.limits == state) {
            return;
        }
        this.limits = state;
        if (this.limits) {
            this.addPageListener(this);
        } else {
            this.removePageListener(this);
        }
    }

    public void setLimits(int min, int max) {
        this.minimumValue = min;
        this.maximumValue = max;
        this.setLimits(true);
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    @Override
    public void mousePressed(MouseEvent event) {
        if (this.spinnerThread == null) {
            this.spinnerThread = new SpinnerThread(this.spinnerListeners);
        }
        if (event.getSource() == this.up) {
            if (event.isShiftDown()) {
                this.spinnerThread.first();
            } else {
                this.spinnerThread.up();
            }
        } else if (event.getSource() == this.down) {
            if (event.isShiftDown()) {
                this.spinnerThread.last();
            } else {
                this.spinnerThread.down();
            }
        } else if (event.getSource() == this.pageUp) {
            this.spinnerThread.pageUp();
        } else if (event.getSource() == this.pageDown) {
            this.spinnerThread.pageDown();
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        if (this.spinnerThread == null) {
            this.spinnerThread = new SpinnerThread(this.spinnerListeners);
        }
        if (event.getSource() == this.up) {
            this.spinnerThread.nospin();
        } else if (event.getSource() == this.down) {
            this.spinnerThread.nospin();
        } else if (event.getSource() == this.pageUp) {
            this.spinnerThread.nospin();
        } else if (event.getSource() == this.pageDown) {
            this.spinnerThread.nospin();
        }
    }

    public void setPageSize(int value) {
        this.pageSize = value;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public void spinnerIncrease() {
        ++this.value;
        if (this.value > this.maximumValue) {
            this.value = this.maximumValue;
        }
    }

    @Override
    public void spinnerDecrease() {
        --this.value;
        if (this.value < this.minimumValue) {
            this.value = this.minimumValue;
        }
    }

    @Override
    public void pageIncrease() {
        this.value += this.pageSize;
        if (this.value > this.maximumValue) {
            this.value = this.maximumValue;
        }
    }

    @Override
    public void pageDecrease() {
        this.value -= this.pageSize;
        if (this.value < this.minimumValue) {
            this.value = this.minimumValue;
        }
    }

    @Override
    public void pageFirst() {
        this.value = this.minimumValue;
    }

    @Override
    public void pageLast() {
        this.value = this.maximumValue;
    }

    @Override
    public int getControlType() {
        return 1007;
    }

    class SpinnerThread
    implements Runnable {
        private Vector<PageListener> spinnerThreads = null;
        private boolean stopThread = true;
        private boolean increase = false;
        private boolean paged = false;
        private int primaryDelay = 500;
        private int secondaryDelay = 100;

        public void setPrimaryDelay(int value) {
            this.primaryDelay = value;
        }

        public void setSecondaryDelay(int value) {
            this.secondaryDelay = value;
        }

        public int getPrimaryDelay() {
            return this.primaryDelay;
        }

        public int getSecondaryDelay() {
            return this.secondaryDelay;
        }

        public SpinnerThread(Vector<PageListener> v) {
            this.spinnerThreads = v;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setVector(Vector<PageListener> v) {
            Vector<PageListener> vector = this.spinnerThreads;
            synchronized (vector) {
                this.spinnerThreads = v;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            PageListener listener;
            int size;
            int delay;
            block18: {
                delay = this.primaryDelay;
                size = 0;
                listener = null;
                try {
                    Thread.sleep(this.secondaryDelay / 4);
                }
                catch (Exception e) {
                    if (!this.stopThread) break block18;
                    return;
                }
            }
            while (!this.stopThread) {
                if (this.spinnerThreads != null) {
                    Vector<PageListener> e = this.spinnerThreads;
                    synchronized (e) {
                        size = this.spinnerThreads.size();
                    }
                    try {
                        for (int i = 0; i < size; ++i) {
                            Vector<PageListener> vector = this.spinnerThreads;
                            synchronized (vector) {
                                listener = this.spinnerThreads.elementAt(i);
                            }
                            if (listener == null) continue;
                            if (this.paged) {
                                if (this.increase) {
                                    listener.pageIncrease();
                                    continue;
                                }
                                listener.pageDecrease();
                                continue;
                            }
                            if (this.increase) {
                                listener.spinnerIncrease();
                                continue;
                            }
                            listener.spinnerDecrease();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                try {
                    Thread.sleep(delay);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                delay = this.secondaryDelay;
            }
        }

        public void pageUp() {
            this.increase = true;
            this.paged = true;
            if (this.stopThread) {
                this.stopThread = false;
                ThreadQueue t = new ThreadQueue(this);
                t.start();
            }
        }

        public void pageDown() {
            this.increase = false;
            this.paged = true;
            if (this.stopThread) {
                this.stopThread = false;
                ThreadQueue t = new ThreadQueue(this);
                t.start();
            }
        }

        public void up() {
            this.increase = true;
            this.paged = false;
            if (this.stopThread) {
                this.stopThread = false;
                ThreadQueue t = new ThreadQueue(this);
                t.start();
            }
        }

        public void down() {
            this.increase = false;
            this.paged = false;
            if (this.stopThread) {
                this.stopThread = false;
                ThreadQueue t = new ThreadQueue(this);
                t.start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void first() {
            PageListener listener = null;
            int size = 0;
            Vector<PageListener> vector = this.spinnerThreads;
            synchronized (vector) {
                size = this.spinnerThreads.size();
            }
            try {
                for (int i = 0; i < size; ++i) {
                    Vector<PageListener> vector2 = this.spinnerThreads;
                    synchronized (vector2) {
                        listener = this.spinnerThreads.elementAt(i);
                    }
                    listener.pageFirst();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void last() {
            PageListener listener = null;
            int size = 0;
            Vector<PageListener> vector = this.spinnerThreads;
            synchronized (vector) {
                size = this.spinnerThreads.size();
            }
            try {
                for (int i = 0; i < size; ++i) {
                    Vector<PageListener> vector2 = this.spinnerThreads;
                    synchronized (vector2) {
                        listener = this.spinnerThreads.elementAt(i);
                    }
                    listener.pageLast();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void nospin() {
            this.stopThread = true;
        }
    }
}

