/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.jfc;

import com.heirloomcomputing.ecs.exec.AcceptEvent;
import com.heirloomcomputing.ecs.exec.ColorProvider;
import com.heirloomcomputing.ecs.exec.Handle;
import com.heirloomcomputing.ecs.exec.IO;
import com.heirloomcomputing.ecs.exec.LogSetup;
import com.heirloomcomputing.ecs.exec.MediaImage;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.ScreenProperty;
import com.heirloomcomputing.ecs.exec.ThreadQueue;
import com.heirloomcomputing.ecs.exec.Tiler;
import com.heirloomcomputing.ecs.exec.Utilities;
import com.heirloomcomputing.ecs.jfc.LBitmap;
import com.heirloomcomputing.ecs.jfc.LComponent;
import com.heirloomcomputing.ecs.jfc.LLabel;
import com.heirloomcomputing.ecs.jfc.LMasterWindow;
import com.heirloomcomputing.ecs.jfc.LMenu;
import com.heirloomcomputing.ecs.jfc.LPushButton;
import com.heirloomcomputing.ecs.jfc.LStatusBar;
import com.heirloomcomputing.ecs.jfc.LToolBar;
import com.heirloomcomputing.term.ScreenHandler;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JWindow;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

public class LWindow
extends LComponent
implements KeyListener,
ComponentListener {
    private static final long serialVersionUID = 1L;
    public static final int TEXT_LAYER = 0;
    public static final int BACKGROUND_LAYER = 1;
    public static final int MASTER_LAYER = 50;
    Component textPane;
    JScrollPane scrollPane;
    LMasterWindow masterWindow;
    Component statusBar;
    LComponent toolbarPanel;
    JLayeredPane layeredPane;
    private String cleanTitle;
    private Object term;
    private String backgroundImageText;
    private LBitmap backgroundImage;
    private ActionListener actionListener;
    private Handle menuHandle;
    private Window containingWindow;
    private boolean overrideFocusTraversable;
    private boolean initial;
    private boolean systemMenu;
    private boolean floating;
    private boolean modeless;
    private boolean modal;
    private boolean bindToThread;
    private boolean linkToThread;
    private boolean titleBar;
    private boolean autoResize;
    private boolean resizable;
    private boolean autoMinimize;
    private boolean noScroll;
    private boolean noWrap;
    private int defaultAction = -1;
    private Handle parentWindowHandle;
    private int labelOffset = 20;
    private String iconImageString;
    private Image iconImage;
    private final Object textPaneLock = new Object();
    public Thread controllingThread;
    private boolean centered;
    private boolean tiled = true;
    private static final int STATE_NORMAL = 0;
    private static final int STATE_ICONIFIED = 1;
    private static final int STATE_MAXIMIZED_HORIZ = 2;
    private static final int STATE_MAXIMIZED_VERT = 4;
    private static final int STATE_MAXIMIZED_BOTH = 6;

    public LWindow(int cols, int rows, boolean isToolBar) {
        this.setLayout(new BorderLayout());
        this.setControlFont(Handle.DEFAULT_FONT);
        this.setCellFont(Handle.FIXED_FONT);
        int cellWidth = this.getCellWidth();
        int cellHeight = this.getCellHeight();
        this.masterWindow = new LMasterWindow();
        this.masterWindow.setWindow(this);
        this.masterWindow.setCellSize(cellWidth, cellHeight);
        this.setColumnLineCount(cols, rows);
        this.masterWindow.setOpaque(false);
        this.layeredPane = new JLayeredPane();
        this.layeredPane.add((Component)this.masterWindow, new Integer(50));
        this.masterWindow.setVisible(true);
        this.layeredPane.setPreferredSize(this.masterWindow.getPreferredSize());
        if (isToolBar) {
            super.add((Component)this.layeredPane, "Center");
        } else {
            this.scrollPane = new JScrollPane(this.layeredPane);
            this.scrollPane.setBorder(null);
            this.scrollPane.setHorizontalScrollBarPolicy(30);
            this.scrollPane.setVerticalScrollBarPolicy(20);
            super.add((Component)this.scrollPane, "Center");
        }
        if (!isToolBar) {
            this.toolbarPanel = new LComponent();
            this.toolbarPanel.setReverseOrder(false);
            this.toolbarPanel.setLayout(new FlowLayout(0, 1, 1));
            this.toolbarPanel.setLayout(new BoxLayout(this.toolbarPanel, 1));
            this.toolbarPanel.setVisible(false);
            super.add((Component)this.toolbarPanel, "North");
        }
        this.statusBar = null;
        this.line = -1.0;
        this.column = -1.0;
        this.setVisible(true);
        this.setEnabled(true);
        this.controllingThread = Thread.currentThread();
    }

    public LWindow() {
        this(Utilities.getColumns(), Utilities.getLines(), false);
    }

    @Override
    public void keyPressed(KeyEvent event) {
    }

    @Override
    public void keyReleased(KeyEvent event) {
        int keyCode = event.getKeyCode();
        if (keyCode == 9) {
            return;
        }
        this.processKey(this, event);
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }

    public void addConstantListeners() {
        this.addKeyListener(this);
    }

    public void removeConstantListeners() {
        this.removeKeyListener(this);
    }

    @Override
    public int getControlType() {
        return 1003;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.cleanTitle != null) {
            this.setCleanTitle(this.cleanTitle);
        }
        this.addConstantListeners();
    }

    @Override
    public void removeNotify() {
        this.removeConstantListeners();
        super.removeNotify();
        this.removeComponentListener();
    }

    public Component getMasterWindow() {
        return this.masterWindow;
    }

    @Override
    public void setFont(int value) {
        this.setFont(Handle.getFont(value));
    }

    @Override
    public void setFont(Handle h) {
        this.setFont(h.getFont());
    }

    @Override
    public void setFont(Font f) {
        super.setCellFont(f);
    }

    @Override
    public void setControlFont(String s) {
        this.setControlFont(Handle.decodeFont(s));
    }

    @Override
    public void setControlFont(int value) {
        super.setFont(value);
    }

    @Override
    public void setControlFont(Handle h) {
        super.setFont(h.getFont());
    }

    @Override
    public void setControlFont(Font f) {
        super.setFont(f);
    }

    @Override
    public void setLine(double value) {
        this.line = value;
        Window w = this.getMyContainingWindow();
        if (w != null) {
            Point p = w.getLocation();
            int size = this.getCellHeight();
            if (size <= 0) {
                size = 8;
            }
            w.setLocation(p.x, (int)(this.line * (double)size));
        }
    }

    @Override
    public void setColumn(double value) {
        this.column = value;
        Window w = this.getMyContainingWindow();
        if (w != null) {
            Point p = w.getLocation();
            int size = this.getCellWidth();
            if (size <= 0) {
                size = 8;
            }
            w.setLocation((int)(this.column * (double)size), p.y);
        }
    }

    @Override
    public void setLineCells(double value) {
        this.setLine(value);
    }

    @Override
    public void setColumnCells(double value) {
        this.setColumn(value);
    }

    @Override
    public void setVisible(boolean state) {
        Window w = this.getMyContainingWindow();
        if (w != null) {
            w.setVisible(state);
        }
        super.setVisible(state);
    }

    @Override
    public void setEnabled(boolean state) {
        Window w = this.getMyContainingWindow();
        if (w != null) {
            w.setEnabled(state);
        }
        super.setEnabled(state);
    }

    private boolean setupContainingWindow(Window parentWindow) {
        Window w = this.getMyContainingWindow();
        if (this.cleanTitle != null) {
            this.setCleanTitle(this.cleanTitle);
        }
        int x = 0;
        int y = 0;
        if (w != null) {
            if (this.line >= 0.0 && this.column < 0.0) {
                this.column = 0.0;
            }
            if (this.column >= 0.0 && this.line < 0.0) {
                this.line = 0.0;
            }
            if (this.line > 0.0 || this.column > 0.0) {
                int width = this.getCellWidth();
                int height = this.getCellHeight();
                if (width <= 0) {
                    width = 8;
                }
                if (height <= 0) {
                    height = 8;
                }
                x = (int)(this.column * (double)width);
                y = (int)(this.line * (double)height);
            }
        }
        try {
            if (this.centered) {
                Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
                Dimension pref = this.getPreferredSize();
                w.setLocation((d.width - pref.width) / 2, (d.height - pref.height) / 2);
            } else if (this.tiled) {
                w.setLocation(Tiler.getNextLocation(this.getPreferredSize().width, this.getPreferredSize().height, parentWindow, x, y));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void setLines(double value) {
        super.setLines(value);
        this.setLineCount((int)value);
        Window w = this.getMyContainingWindow();
        if (w != null) {
            Dimension d = w.getSize();
            Insets i = w.getInsets();
            int insetHeight = i.top + i.bottom;
            w.setSize(d.width, (int)(value * (double)this.getCellHeight()) + insetHeight);
        }
    }

    @Override
    public void setColumns(double value) {
        super.setColumns(value);
        this.setColumnCount((int)value);
        Window w = this.getMyContainingWindow();
        if (w != null) {
            Dimension d = w.getSize();
            Insets i = w.getInsets();
            int insetWidth = i.left + i.right;
            w.setSize((int)(value * (double)this.getCellWidth()) + insetWidth, d.height);
        }
    }

    @Override
    public double getLines() {
        double d = super.getLines();
        if (d <= 0.0) {
            return 1.0;
        }
        return d;
    }

    @Override
    public double getColumns() {
        double d = super.getColumns();
        if (d <= 0.0) {
            return 1.0;
        }
        return d;
    }

    @Override
    public void setCellWidth(int width) {
        super.setCellWidth(width);
        if (this.masterWindow != null) {
            this.masterWindow.setCellWidth(width);
        }
    }

    @Override
    public void setCellHeight(int height) {
        super.setCellHeight(height);
        if (this.masterWindow != null) {
            this.masterWindow.setCellHeight(height);
        }
    }

    @Override
    public void setCellSize(int width, int height) {
        super.setCellSize(width, height);
        if (this.masterWindow != null) {
            this.masterWindow.setCellSize(width, height);
        }
    }

    @Override
    public void setCellSize(Dimension d) {
        super.setCellSize(d);
        if (this.masterWindow != null) {
            this.masterWindow.setCellSize(d);
        }
    }

    @Override
    public void setCleanTitle(String title) {
        try {
            this.setTitleBar();
            this.cleanTitle = title;
            Window w = this.getMyContainingWindow();
            if (w instanceof Frame) {
                ((Frame)w).setTitle(title);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setControllingThread(Thread t) {
        this.controllingThread = t;
        try {
            ((ThreadQueue)t).controlsWindow(this.getHandle());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Thread getControllingThread() {
        return this.controllingThread;
    }

    @Override
    public void setPopupMenu(int value) {
        this.masterWindow.setPopupMenu(value);
        super.setPopupMenu(value);
    }

    private void updateBackgroundImage() {
        try {
            if (this.backgroundImage == null) {
                return;
            }
            Dimension d = this.getSize();
            int d_width = 0;
            int d_height = 0;
            if (d != null) {
                d_width = d.width;
                d_height = d.height;
            }
            if ((d = this.textPane != null ? this.textPane.getPreferredSize() : this.masterWindow.getPreferredSize()) != null) {
                if (d.width > d_width) {
                    d_width = d.width;
                }
                if (d.height > d_height) {
                    d_height = d.height;
                }
            }
            d = new Dimension(d_width, d_height);
            this.backgroundImage.setSize(d);
            this.backgroundImage.setPreferredSize(d);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBackgroundImage(String name) {
        try {
            Object object = this.getTreeLock();
            synchronized (object) {
                this.backgroundImageText = name;
                if (this.backgroundImage != null) {
                    this.backgroundImage.setVisible(false);
                    this.layeredPane.remove(this.backgroundImage);
                }
                if (name != null && (name = name.trim()).length() > 0) {
                    this.backgroundImage = new LBitmap(name);
                    this.layeredPane.add((Component)this.backgroundImage, new Integer(1));
                    this.backgroundImage.setVisible(true);
                    this.updateBackgroundImage();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBackgroundImageTiled(String name) {
        try {
            Object object = this.getTreeLock();
            synchronized (object) {
                this.backgroundImageText = name;
                if (this.backgroundImage != null) {
                    this.backgroundImage.setVisible(false);
                    this.layeredPane.remove(this.backgroundImage);
                }
                if (name != null && (name = name.trim()).length() > 0) {
                    this.backgroundImage = new LBitmap(name);
                    this.backgroundImage.setTiled(true);
                    this.layeredPane.add((Component)this.backgroundImage, new Integer(1));
                    this.backgroundImage.setVisible(true);
                    this.updateBackgroundImage();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBackgroundImageScaled(String name) {
        try {
            Object object = this.getTreeLock();
            synchronized (object) {
                this.backgroundImageText = name;
                if (this.backgroundImage != null) {
                    this.backgroundImage.setVisible(false);
                    this.layeredPane.remove(this.backgroundImage);
                }
                if (name != null && (name = name.trim()).length() > 0) {
                    this.backgroundImage = new LBitmap(name);
                    this.backgroundImage.setScaled(true);
                    this.layeredPane.add((Component)this.backgroundImage, new Integer(1));
                    this.backgroundImage.setVisible(true);
                    this.updateBackgroundImage();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String getBackgroundImage() {
        return this.backgroundImageText != null ? this.backgroundImageText : "";
    }

    public void setCentered() {
        this.centered = true;
    }

    public void setCentered(boolean center) {
        this.centered = center;
    }

    public boolean isCentered() {
        return this.centered;
    }

    public void setTiled(boolean state) {
        this.tiled = state;
    }

    public boolean isTiled() {
        return this.tiled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTextPane(Object term, Component c) {
        Container check2;
        this.term = term;
        this.masterWindow.setOpaque(false);
        Object object = this.textPaneLock;
        synchronized (object) {
            this.textPane = c;
            this.layeredPane.add(this.textPane, new Integer(0));
            this.layeredPane.setPreferredSize(this.textPane.getPreferredSize());
            this.updateBackgroundImage();
        }
        Font cellFont = this.getCellFont();
        if (cellFont != null) {
            ((ScreenHandler)term).setFont(cellFont);
        }
        int cellWidth = this.getCellWidth();
        int cellHeight = this.getCellHeight();
        if (cellWidth >= 0) {
            ((ScreenHandler)term).setCellWidth(cellWidth);
        }
        if (cellHeight >= 0) {
            ((ScreenHandler)term).setCellHeight(cellHeight);
        }
        int cols = this.getColumnCount();
        int lines = this.getLineCount();
        if (cols >= 0 && lines >= 0) {
            ((ScreenHandler)term).setScreenResolution(lines, cols);
        }
        Color back = this.getBackground();
        Color fore = this.getForeground();
        try {
            if (back == null) {
                check2 = this;
                while (back == null && check2.getParent() != null) {
                    if ((check2 = check2.getParent()) == null) continue;
                    back = check2.getBackground();
                }
            }
        }
        catch (Exception check2) {
            // empty catch block
        }
        try {
            if (fore == null) {
                check2 = this;
                while (fore == null && check2.getParent() != null) {
                    if ((check2 = check2.getParent()) == null) continue;
                    fore = check2.getForeground();
                }
            }
        }
        catch (Exception check3) {
            // empty catch block
        }
        if (back == null) {
            back = ScreenProperty.getColorObject(((ScreenHandler)term).getDefaultBG());
        }
        if (fore == null) {
            fore = ScreenProperty.getColorObject(((ScreenHandler)term).getDefaultFG());
        }
        this.masterWindow.setBackground(back);
        this.masterWindow.setForeground(fore);
        ((ScreenHandler)term).setDefaultColors(fore, back);
        ((ScreenHandler)term).setFG(fore);
        ((ScreenHandler)term).setBG(back);
        ActionListener l = this.getTextPaneListener();
        if (l != null) {
            ((ScreenHandler)term).addActionListener(l);
        }
    }

    public ActionListener getTextPaneListener() {
        if (this.actionListener == null) {
            this.actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    String command;
                    if (event != null && (command = event.getActionCommand()).equals("CLEAR_SCREEN")) {
                        Handle.destroyAll(LWindow.this.getHandle());
                    }
                }
            };
        }
        return this.actionListener;
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        if (this instanceof LToolBar) {
            return;
        }
        if (this.getMasterWindow() != null) {
            this.getMasterWindow().setSize(w, h);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension getPreferredSize() {
        int w = 0;
        int h = 0;
        Dimension d = null;
        if (this.layeredPane != null) {
            Object object = this.textPaneLock;
            synchronized (object) {
                if (this.textPane != null) {
                    this.layeredPane.setPreferredSize(this.textPane.getPreferredSize());
                }
                this.updateBackgroundImage();
            }
        }
        if (this.scrollPane != null) {
            d = this.scrollPane.getPreferredSize();
            w = d.width;
            h = d.height;
        } else if (this.layeredPane != null) {
            d = this.layeredPane.getPreferredSize();
            w = d.width;
            h = d.height;
        }
        if (this.statusBar != null) {
            d = this.statusBar.getPreferredSize();
            h += d.height;
        }
        if (this.toolbarPanel != null) {
            d = this.toolbarPanel.getPreferredSize();
            h += d.height;
        }
        if (w < 10) {
            w = 10;
        }
        return new Dimension(w, h);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public void setColumnCount(int x) {
        if (this.masterWindow != null) {
            this.masterWindow.setColumnCount(x);
        }
    }

    public void setLineCount(int y) {
        if (this.masterWindow != null) {
            this.masterWindow.setLineCount(y);
        }
    }

    public void setColumnLineCount(int x, int y) {
        if (this.masterWindow != null) {
            this.masterWindow.setColumnLineCount(x, y);
        }
    }

    public int getColumnCount() {
        return this.masterWindow != null ? this.masterWindow.getColumnCount() : 80;
    }

    public int getLineCount() {
        return this.masterWindow != null ? this.masterWindow.getLineCount() : 25;
    }

    private void updateComponent(Component c) {
        if (c instanceof LComponent) {
            ((LComponent)c).setWindow(this);
        }
    }

    @Override
    public void setWindow(LComponent window) {
    }

    public Component setMenuBar(Handle menuHandle, LMenu menuComponent) {
        this.menuHandle = menuHandle;
        return this.setMenuBar(menuComponent);
    }

    public Handle getMenuHandle() {
        return this.menuHandle;
    }

    public Component setMenuBar(LMenu c) {
        try {
            JRootPane rootPane = SwingUtilities.getRootPane(this);
            if (rootPane != null && c != null) {
                c.setJMenuBarOn(rootPane);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return c;
    }

    public Component getMenuBar() {
        try {
            Container parent = this.getParent();
            if (parent == null) {
                parent = this.getMyContainingWindow();
            }
            do {
                if (!(parent instanceof RootPaneContainer)) continue;
                return ((RootPaneContainer)((Object)parent)).getRootPane().getJMenuBar();
            } while ((parent = parent.getParent()) != null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public Component setToolBar(LToolBar c) {
        this.toolbarPanel.setVisible(true);
        c.setWindow(this);
        this.toolbarPanel.add(c);
        JSeparator sep = new JSeparator(0);
        this.toolbarPanel.add(sep);
        return c;
    }

    private Component inner_add(String name, Component c, int index, Object constraints) {
        if (c == null) {
            return this;
        }
        Component result = c;
        Container parent = c.getParent();
        if (parent != this && parent != this.masterWindow) {
            this.updateComponent(c);
            if (c instanceof LStatusBar) {
                this.setStatusBar((LStatusBar)c);
                result = c;
            } else if (c instanceof LToolBar) {
                result = this.setToolBar((LToolBar)c);
            } else if (c instanceof LMenu) {
                result = this.setMenuBar((LMenu)c);
            } else if (c instanceof Window) {
                result = this.addWindow(name, c, constraints, index);
            } else if (name != null) {
                result = this.masterWindow.add(name, c);
            } else if (constraints == null) {
                result = index < 0 ? this.masterWindow.add(c) : this.masterWindow.add(c, index);
            } else if (index < 0) {
                this.masterWindow.add(c, constraints);
                result = null;
            } else {
                this.masterWindow.add(c, constraints, index);
                result = null;
            }
        } else if (c instanceof LPushButton) {
            LPushButton button = (LPushButton)c;
            button.notifyRootPaneIfDefaultButton();
        }
        return result;
    }

    @Override
    public Component add(Component c) {
        return this.inner_add(null, c, -1, null);
    }

    @Override
    public Component add(Component c, int index) {
        return this.inner_add(null, c, index, null);
    }

    @Override
    public Component add(String name, Component c) {
        return this.inner_add(name, c, -1, null);
    }

    @Override
    public void add(Component c, Object constraints) {
        this.inner_add(null, c, -1, constraints);
    }

    @Override
    public void add(Component c, Object constraints, int index) {
        this.inner_add(null, c, index, constraints);
    }

    public Component addWindow(String name, Component c, Object constraints, int index) {
        if (c == null) {
            return c;
        }
        if (c.getParent() == this) {
            return c;
        }
        if (c.getParent() == this.masterWindow) {
            return c;
        }
        if (c instanceof Dialog) {
            Dialog dialog = (Dialog)c;
            dialog.setVisible(true);
            dialog.dispose();
            return c;
        }
        c.setVisible(true);
        return c;
    }

    public void setStatusBar(LStatusBar c) {
        this.updateComponent(c);
        this.statusBar = c;
        super.add(this.statusBar, "South");
        this.redisplayWindow();
    }

    private void redisplayWindow() {
        Window w = SwingUtilities.windowForComponent(this);
        if (w != null) {
            try {
                w.pack();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Window getMyContainingWindow() {
        return this.containingWindow;
    }

    public void setContainingWindow(Window w) {
        this.containingWindow = w;
        if (w != null) {
            this.containingWindow.setVisible(this.isVisible());
        }
    }

    @Override
    public void requestChildFocus() {
        this.masterWindow.snatchFocus();
    }

    @Override
    public void requestFocus() {
        Window w = this.getMyContainingWindow();
        if (w != null) {
            w.toFront();
        }
        super.requestFocus();
    }

    @Override
    public void destroy() {
        try {
            ActionListener l = this.getTextPaneListener();
            if (l != null) {
                ((ScreenHandler)this.term).removeActionListener(l);
            }
        }
        catch (Throwable l) {
            // empty catch block
        }
        Window w = this.getMyContainingWindow();
        if (w != null) {
            w.setVisible(false);
        }
        try {
            if (w != null) {
                w.dispatchEvent(new WindowEvent(this.getMyContainingWindow(), 201));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (w != null) {
                w.dispose();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (IO.getActiveIO().getIOHandle().getComponent() == this && this.parentWindowHandle != null) {
                IO.setActiveIO(this.parentWindowHandle);
                this.parentWindowHandle = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        IO myIO = this.getHandle().getIO();
        if (myIO != null) {
            IO.deallocateIO(myIO);
            this.getHandle().setIO(null);
        }
        super.destroy();
    }

    public Window createContainingWindow(String defaultTitle, boolean initial) {
        if (initial) {
            this.setInitial();
        }
        return this.createContainingWindow(defaultTitle);
    }

    @Override
    public Handle getWindowHandle() {
        return this.getHandle();
    }

    @Override
    public boolean isFocusable() {
        if (this.overrideFocusTraversable) {
            return true;
        }
        return super.isFocusable();
    }

    public void snatchFocus() {
        this.overrideFocusTraversable = true;
        this.requestFocus();
        this.overrideFocusTraversable = false;
    }

    private void initCreatedWindow(Window w2, boolean isResizable2, boolean isVisible2) {
        final Window w = w2;
        final boolean isResizable = isResizable2;
        Runnable r1 = new Runnable(){

            @Override
            public void run() {
                if (w instanceof Frame) {
                    Frame f = (Frame)w;
                    f.setResizable(isResizable);
                } else if (w instanceof Dialog) {
                    Dialog d = (Dialog)w;
                    d.setResizable(isResizable);
                }
                try {
                    w.pack();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                w.setVisible(true);
            }
        };
        try {
            SwingUtilities.invokeLater(r1);
        }
        catch (Throwable t) {
            r1.run();
        }
        try {
            Thread.sleep(200L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void setupComponentListener() {
        Window c = this.getMyContainingWindow();
        if (c != null) {
            c.addComponentListener(this);
        }
    }

    private void removeComponentListener() {
        Window c = this.getMyContainingWindow();
        if (c != null) {
            try {
                c.removeComponentListener(this);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public boolean isSecondaryWindow() {
        return false;
    }

    public Window createContainingWindow(String defaultTitle) {
        defaultTitle = null;
        String useTitle = this.getTitle();
        if (!(useTitle != null && useTitle.trim().length() != 0 || (useTitle = defaultTitle) != null && useTitle.trim().length() != 0)) {
            useTitle = Utilities.getDefaultTitle("Graphical Application");
        }
        boolean isItResizable = this.resizable;
        boolean isItVisible = this.isVisible();
        Window parentWindowComponent = null;
        if (this.isSystemFrame() || this.isFloating()) {
            try {
                if (this.parentWindowHandle != null) {
                    Window parentContainingWindow = ((LWindow)this.parentWindowHandle.getComponent()).getMyContainingWindow();
                    if (parentContainingWindow instanceof Dialog) {
                        Dialog parentDialog = (Dialog)parentContainingWindow;
                        JDialog dialog = new JDialog(parentDialog, useTitle, this.modal);
                        this.containingWindow = dialog;
                        parentWindowComponent = parentDialog;
                        dialog.getContentPane().setLayout(new BorderLayout());
                        dialog.getContentPane().add((Component)this, "Center");
                        dialog.setSize(this.getSize().width + 2, this.getSize().height + 2);
                        this.setupContainingWindow(parentWindowComponent);
                        this.initCreatedWindow(dialog, isItResizable, isItVisible);
                        Utilities.setMainWindow(dialog, this.initial, this.iconImage);
                        dialog.setDefaultCloseOperation(0);
                        this.setupComponentListener();
                        return dialog;
                    }
                    if (parentContainingWindow instanceof Frame) {
                        Frame parentFrame = (Frame)parentContainingWindow;
                        JDialog dialog = new JDialog(parentFrame, useTitle, this.modal);
                        this.containingWindow = dialog;
                        parentWindowComponent = parentFrame;
                        dialog.getContentPane().setLayout(new BorderLayout());
                        dialog.getContentPane().add((Component)this, "Center");
                        dialog.setSize(this.getSize().width + 2, this.getSize().height + 2);
                        this.setupContainingWindow(parentWindowComponent);
                        this.initCreatedWindow(dialog, isItResizable, isItVisible);
                        Utilities.setMainWindow(dialog, this.initial, this.iconImage);
                        dialog.setDefaultCloseOperation(0);
                        this.setupComponentListener();
                        return dialog;
                    }
                    if (this.containingWindow instanceof Window) {
                        Window parentWindow = parentContainingWindow;
                        Frame parentFrame = (Frame)parentWindow.getOwner();
                        JDialog dialog = new JDialog(parentFrame, useTitle, this.modal);
                        this.containingWindow = dialog;
                        parentWindowComponent = parentFrame;
                        dialog.getContentPane().setLayout(new BorderLayout());
                        dialog.getContentPane().add((Component)this, "Center");
                        dialog.setSize(this.getSize().width + 2, this.getSize().height + 2);
                        this.setupContainingWindow(parentWindowComponent);
                        this.initCreatedWindow(dialog, isItResizable, isItVisible);
                        Utilities.setMainWindow(dialog, this.initial, this.iconImage);
                        dialog.setDefaultCloseOperation(0);
                        this.setupComponentListener();
                        return dialog;
                    }
                }
            }
            catch (Throwable parentContainingWindow) {
                // empty catch block
            }
            JFrame frame = new JFrame(useTitle);
            this.containingWindow = frame;
            frame.getContentPane().setLayout(new BorderLayout());
            frame.getContentPane().add((Component)this, "Center");
            frame.setSize(this.getSize().width + 2, this.getSize().height + 2);
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.finest("line=" + this.getLine() + ". col=" + this.getColumn() + ".");
            }
            this.setupContainingWindow(parentWindowComponent);
            this.initCreatedWindow(frame, isItResizable, isItVisible);
            if (this.defaultAction >= 0) {
                this.setAction(this.defaultAction);
            }
            Utilities.setMainWindow(frame, this.initial, this.iconImage);
            frame.setDefaultCloseOperation(0);
            this.setupComponentListener();
            return frame;
        }
        JWindow window = null;
        try {
            if (this.parentWindowHandle != null) {
                Frame parentFrame;
                parentWindowComponent = parentFrame = (Frame)((LWindow)this.parentWindowHandle.getComponent()).getMyContainingWindow();
                window = new JWindow(parentFrame);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (window == null) {
            window = new JWindow();
        }
        this.containingWindow = window;
        window.getContentPane().setLayout(new BorderLayout());
        window.getContentPane().add((Component)this, "Center");
        this.setupContainingWindow(parentWindowComponent);
        window.setSize(this.getSize().width + 2, this.getSize().height + 2);
        this.initCreatedWindow(window, true, isItVisible);
        if (this.defaultAction >= 0) {
            this.setAction(this.defaultAction);
        }
        Utilities.setMainWindow(window, this.initial, this.iconImage);
        this.setupComponentListener();
        return window;
    }

    @Override
    public void setStandard() {
        this.setInitial();
        this.setTitleBar();
        this.setSystemMenu();
        this.setAutoMinimize();
        this.setInitialColors();
    }

    public void setInitialColors() {
        this.setUserColors();
        this.setForegroundColor(0);
        this.setBackgroundColor(7);
    }

    @Override
    public void setForeground(Color c) {
        if (this.term != null) {
            ((ScreenHandler)this.term).setFG(c);
        }
        super.setForeground(c);
        this.masterWindow.setForeground(c);
        this.revalidate();
        this.repaint();
        this.masterWindow.repaint();
    }

    @Override
    public void setBackground(Color c) {
        if (this.term != null) {
            ((ScreenHandler)this.term).setBG(c);
        }
        super.setBackground(c);
        this.masterWindow.setBackground(c);
        this.repaint();
        this.masterWindow.repaint();
    }

    public boolean isSystemFrame() {
        return this.systemMenu || this.titleBar || this.autoMinimize;
    }

    public void setInitial() {
        this.setTitleBar();
        this.setSystemMenu();
        this.setAutoMinimize();
        this.setModeless();
        if (!this.initial) {
            if (Utilities.hasMainWindow()) {
                throw new RuntimeException("Cannot recreate initial window.");
            }
            this.initial = true;
        }
    }

    public void setGraphical() {
        this.setCellSize(LLabel.getDefaultCellSize());
    }

    public void setSystemMenu() {
        this.systemMenu = true;
    }

    public void setIndependent() {
        try {
            LWindow currentWindow = (LWindow)IO.current().getIOHandle().getComponentNoCreate();
            this.inherit(currentWindow);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void inherit(LWindow currentWindow) {
        if (currentWindow == null) {
            return;
        }
        Color fore = currentWindow.getForeground();
        Color back = currentWindow.getBackground();
        Font cellFont = currentWindow.getCellFont();
        Font font2 = null;
        if (currentWindow.isFontSet()) {
            font2 = currentWindow.getFont();
        }
        if (fore != null) {
            this.setForeground(fore);
        }
        if (back != null) {
            this.setBackground(back);
        }
        if (font2 != null) {
            this.setFont(font2);
        }
        if (cellFont != null) {
            this.setCellFont(cellFont);
        }
    }

    public void setFloating() {
        this.floating = true;
        if (!this.modeless) {
            this.setModal();
        }
        try {
            if (this.parentWindowHandle == null) {
                this.setUpon(IO.getActiveIO().getIOHandle());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean isFloating() {
        return this.floating;
    }

    public int getFloating() {
        return this.isFloating() ? 1 : 0;
    }

    public void setSubwindow() {
        throw new RuntimeException("Subwindows not supported.");
    }

    public void setUpon(Handle parentWindowHandle) {
        this.parentWindowHandle = parentWindowHandle;
        try {
            LWindow parentComponent = (LWindow)parentWindowHandle.getComponent();
            this.setBackgroundHigh(parentComponent.isBackgroundHigh());
            this.setForegroundColor(parentComponent.getForegroundColor());
            this.setBackgroundColor(parentComponent.getBackgroundColor());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setUpon(int handleNumber) {
        this.setUpon(Handle.getHandle(handleNumber));
    }

    public void setModeless() {
        this.modal = false;
        this.modeless = true;
    }

    public boolean isModeless() {
        return this.modeless;
    }

    public void setModal() {
        this.modeless = false;
        this.modal = true;
    }

    public boolean isModal() {
        return this.modal;
    }

    public void setBindToThread() {
        this.bindToThread = true;
        this.setLinkToThread();
    }

    public boolean isBindToThread() {
        return this.bindToThread;
    }

    public int getBindToThread() {
        return this.isBindToThread() ? 1 : 0;
    }

    public void setLinkToThread() {
        this.linkToThread = true;
    }

    public boolean isLinkToThread() {
        return this.linkToThread;
    }

    public int getLinkToThread() {
        return this.isLinkToThread() ? 1 : 0;
    }

    public void setReverse() {
    }

    public void setErase() {
    }

    public void setTitleBar() {
        this.titleBar = true;
    }

    public void setAutoResize() {
        this.autoResize = true;
        this.setResizable();
    }

    public boolean isAutoResize() {
        return this.autoResize;
    }

    public int getAutoResize() {
        return this.isAutoResize() ? 1 : 0;
    }

    public void setMinSize(int value) {
    }

    public void setMaxSize(int value) {
    }

    public void setMinLines(int value) {
    }

    public void setMaxLines(int value) {
    }

    public void setAutoMinimize() {
        this.autoMinimize = true;
        this.setTitleBar();
        this.setSystemMenu();
    }

    public void setControlsUncropped() {
    }

    public void setNoScroll() {
        this.noScroll = true;
    }

    public boolean isNoScroll() {
        return this.noScroll;
    }

    public int getNoScroll() {
        return this.isNoScroll() ? 1 : 0;
    }

    public void setNoWrap() {
        this.noWrap = true;
    }

    public boolean isNoWrap() {
        return this.noWrap;
    }

    public int getNoWrap() {
        return this.isNoWrap() ? 1 : 0;
    }

    public void setBoxed() {
    }

    public void setBoxed(boolean state) {
    }

    public boolean isBoxed() {
        return false;
    }

    public int getBoxed() {
        return this.isBoxed() ? 1 : 0;
    }

    public void setShadow() {
    }

    public void setShadow(boolean state) {
    }

    public boolean isShadow() {
        return false;
    }

    public int getShadow() {
        return this.isShadow() ? 1 : 0;
    }

    @Override
    public int getControlValue() {
        return 0;
    }

    @Override
    public void setControlValue(int value) {
        if ((value & 1) == 1) {
            this.setBoxed();
        }
        if ((value & 2) == 2) {
            this.setShadow();
        }
        if ((value & 4) == 4) {
            this.setNoScroll();
        }
        if ((value & 8) == 8) {
            this.setNoWrap();
        }
        if ((value & 0x10) == 16) {
            this.setReverse();
        }
        if ((value & 0x20) == 32) {
            this.setTitleBar();
        }
        if ((value & 0x40) == 64) {
            this.setSystemMenu();
        }
        if ((value & 0x80) == 128) {
            this.setUserGray();
        }
        if ((value & 0x100) == 256) {
            this.setUserWhite();
        }
    }

    public void setAction(int value) {
        this.defaultAction = value;
        switch (value) {
            case 20: {
                this.doMinimize();
                break;
            }
            case 21: {
                this.doMaximize();
                break;
            }
            case 22: {
                this.doRestore();
                break;
            }
            case 1031: {
                this.doToFront();
                break;
            }
            case 1032: {
                this.doToBack();
            }
        }
    }

    public void doToFront() {
        LWindow.doToFront(this.getMyContainingWindow());
    }

    public static void doToFront(Window w) {
        if (w == null) {
            return;
        }
        w.toFront();
    }

    public void doToBack() {
        LWindow.doToBack(this.getMyContainingWindow());
    }

    public static void doToBack(Window w) {
        if (w == null) {
            return;
        }
        w.toBack();
    }

    public void doMinimize() {
        LWindow.doMinimize(this.getMyContainingWindow());
    }

    public static void doMinimize(Window w) {
        LWindow.setFrameState(w, 1);
    }

    private static void setFrameState(Window w, int state) {
        Method m;
        Class[] cparams2;
        if (w == null) {
            return;
        }
        try {
            cparams2 = new Class[]{Integer.TYPE};
            m = Frame.class.getMethod("setExtendedState", cparams2);
            if (m != null) {
                Object[] oparams = new Object[]{new Integer(state)};
                m.invoke((Object)w, oparams);
                return;
            }
        }
        catch (Throwable cparams2) {
            // empty catch block
        }
        switch (state) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                state = 0;
            }
        }
        try {
            cparams2 = new Class[]{Integer.TYPE};
            m = Frame.class.getMethod("setState", cparams2);
            if (m != null) {
                Object[] oparams = new Object[]{new Integer(state)};
                m.invoke((Object)w, oparams);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void doMaximize() {
        LWindow.doMaximize(this.getMyContainingWindow());
    }

    public static void doMaximize(Window w) {
        LWindow.setFrameState(w, 6);
    }

    public void doRestore() {
        this.doRestore(this.getMyContainingWindow());
    }

    public void doRestore(Window w) {
        LWindow.setFrameState(w, 0);
    }

    public void setUserGray() {
        Color c = LWindow.getUserGray();
        LWindow.colorIntegerArray[7] = c.getRGB();
        LWindow.colorArray[7] = c;
        ScreenProperty.setColor(7, c);
    }

    public void setUserWhite() {
        Color c = LWindow.getUserWhite();
        LWindow.colorIntegerArray[15] = c.getRGB();
        LWindow.colorArray[15] = c;
        ScreenProperty.setColor(15, c);
    }

    public void setUserColors() {
        this.setUserGray();
        this.setUserWhite();
    }

    public static Color getUserGray() {
        Color c = SystemColor.controlHighlight;
        try {
            String override = RuntimeEnvironment.getGlobalParameter("USER-GRAY");
            if (override == null) {
                override = RuntimeEnvironment.getGlobalParameter("USER-GREY");
            }
            if (override != null && (override = override.trim()).length() > 0) {
                c = ColorProvider.getColor(override.trim());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return c;
    }

    public static Color getUserWhite() {
        Color c = SystemColor.control;
        try {
            String override = RuntimeEnvironment.getGlobalParameter("USER-WHITE");
            if (override != null && (override = override.trim()).length() > 0) {
                c = ColorProvider.getColor(override.trim());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return c;
    }

    public void setResizable() {
        this.setResizable(true);
    }

    public void setResizable(boolean state) {
        this.resizable = state;
        try {
            ((Frame)this.getMyContainingWindow()).setResizable(state);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public void display() {
        Container c;
        for (c = this; c != null && !(c instanceof Window); c = c.getParent()) {
        }
        if (c == null) {
            this.createContainingWindow(null);
        } else {
            ((Component)c).setVisible(true);
        }
    }

    public void setLabelOffset(int value) {
        this.labelOffset = value;
    }

    public int getLabelOffset() {
        return this.labelOffset;
    }

    @Override
    public void componentHidden(ComponentEvent event) {
    }

    @Override
    public void componentMoved(ComponentEvent event) {
    }

    @Override
    public void componentResized(ComponentEvent event) {
        if (!this.isVisible()) {
            return;
        }
        if (!this.isResizable()) {
            return;
        }
        try {
            if (!this.isAutoResize()) {
                Dimension d = this.getMyContainingWindow().getSize();
                Insets i = this.getMyContainingWindow().getInsets();
                int width = d.width;
                int height = d.height;
                if (i != null) {
                    width = width - i.left - i.right;
                    height = height - i.top - i.bottom;
                }
                width *= 100;
                height *= 100;
                int cellWidth = this.getCellWidth();
                int cellHeight = this.getCellHeight();
                if (this.processAcceptEvent(new AcceptEvent(this.getHandle(), 0, 4114, event, height /= cellHeight, width /= cellWidth))) {
                    return;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void componentShown(ComponentEvent event) {
    }

    public void setIconImage(String imageName) {
        this.iconImageString = imageName;
        if (imageName != null) {
            imageName = imageName.trim();
            try {
                this.setIconImage(MediaImage.getImage(imageName));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void setIconImage(Image image) {
        try {
            this.iconImage = image;
            Frame containingFrame = (Frame)this.getMyContainingWindow();
            if (containingFrame != null) {
                containingFrame.setIconImage(image);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setIconImage(int value) {
        try {
            this.setIconImage(Handle.getHandle(value));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setIconImage(Handle value) {
        try {
            LBitmap bitmap = (LBitmap)value.getComponent();
            this.setIconImage(bitmap.getImageObject());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String getIconImage() {
        return this.iconImageString != null ? this.iconImageString : " ";
    }

    public void setGradient(int state) {
        this.masterWindow.setGradient(state);
    }

    public void setGradient(boolean state) {
        this.masterWindow.setGradient(state);
    }

    public boolean isGradient() {
        return this.masterWindow.isGradient();
    }

    public int getGradient() {
        return this.masterWindow.getGradient();
    }

    public void setGradientForeground(Color c) {
        this.masterWindow.setGradientForeground(c);
    }

    public void setGradientForegroundRGB(int rgb) {
        this.setGradientForeground(new Color(rgb));
    }

    public void setGradientForeground(int color2) {
        this.masterWindow.setGradientForeground(color2);
    }

    public int getGradientForegroundRGB() {
        Color c = this.masterWindow.getGradientForeground();
        if (c != null) {
            return c.getRGB();
        }
        return -1;
    }

    public void setGradientBackground(Color c) {
        this.masterWindow.setGradientBackground(c);
    }

    public void setGradientBackgroundRGB(int rgb) {
        this.setGradientBackground(new Color(rgb));
    }

    public void setGradientBackground(int color2) {
        this.masterWindow.setGradientBackground(color2);
    }

    public int getGradientBackgroundRGB() {
        Color c = this.masterWindow.getGradientBackground();
        if (c != null) {
            return c.getRGB();
        }
        return -1;
    }

    public int getBorderThickness() {
        return this.masterWindow.getBorderThickness();
    }

    public void setBorderThickness(int n) {
        this.masterWindow.setBorderThickness(n);
    }

    public boolean isGradientBorder() {
        return this.masterWindow.isGradientBorder();
    }

    public int getGradientBorder() {
        return this.masterWindow.getGradientBorder();
    }

    public void setGradientBorder(boolean state) {
        this.masterWindow.setGradientBorder(state);
    }

    public void setGradientBorder(int state) {
        this.masterWindow.setGradientBorder(state);
    }

    public Color getBorderColor() {
        return this.masterWindow.getBorderColor();
    }

    public void setBorderColor(Color c) {
        this.masterWindow.setBorderColor(c);
    }

    public void setBorderRGB(int rgb) {
        this.setBorderColor(new Color(rgb));
    }

    public void setBorderColor(int color2) {
        this.masterWindow.setBorderColor(color2);
    }

    public int getBorderRGB() {
        Color c = this.getBorderColor();
        if (c != null) {
            return c.getRGB();
        }
        return -1;
    }
}

