/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.jfc;

import com.heirloomcomputing.ecs.exec.LogSetup;
import com.heirloomcomputing.ecs.exec.ResourceManager;
import com.heirloomcomputing.ecs.jfc.TerminalAttribute;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Vector;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.StringContent;
import javax.swing.text.StyleConstants;

class SJAbstractDocument
extends AbstractDocument {
    public static final String tabSizeAttribute = "tabSize";
    public static final String lineLimitAttribute = "lineLimit";
    private AbstractDocument.AbstractElement defaultRoot;
    private Vector<Element> added = null;
    private Vector<Element> removed = null;
    private static final String[] YMDPattern = new String[]{"yyyy, MMMM d", "yyyy MMM d", "yy/M/d", "yyyy/M/d", "yy-M-d", "yyyy-M-d", "yy M d", "yyyy M d", "yyMMdd", "yyyyMMdd"};
    private static final String[] MDYPattern = new String[]{"MMMM d, yyyy", "MMM d, yyyy", "M/d/yy", "M/d/yyyy", "M-d-yy", "M-d-yyyy", "M d yy", "M d yyyy", "MMddyy", "MMddyyyy"};
    private static final String[] DMYPattern = new String[]{"d MMMM yyyy", "d MMM yyyy", "d/M/yy", "d/M/yyyy", "d-M-yy", "d-M-yyyy", "d M yy", "d M yyyy", "ddMMyy", "ddMMyyyy"};

    public static String getResource(String name) {
        return ResourceManager.get(name);
    }

    public static String getResource(String name, String value) {
        return ResourceManager.get(name, value);
    }

    public SJAbstractDocument() {
        this(new StringContent());
    }

    protected SJAbstractDocument(AbstractDocument.Content c) {
        super(c);
        this.putProperty(tabSizeAttribute, new Integer(8));
    }

    @Override
    public Element getDefaultRootElement() {
        if (this.defaultRoot == null) {
            this.defaultRoot = this.createDefaultRoot();
        }
        return this.defaultRoot;
    }

    protected AbstractDocument.AbstractElement createDefaultRoot() {
        AbstractDocument.BranchElement map = (AbstractDocument.BranchElement)this.createBranchElement(null, null);
        Element line = this.createLeafElement(map, null, 0, 1);
        Element[] lines = new Element[]{line};
        map.replace(0, 0, lines);
        return map;
    }

    @Override
    public Element getParagraphElement(int pos) {
        Element lineMap = this.getDefaultRootElement();
        return lineMap.getElement(lineMap.getElementIndex(pos));
    }

    @Override
    protected void insertUpdate(AbstractDocument.DefaultDocumentEvent chng, AttributeSet attr) {
        if (this.removed != null) {
            this.removed.removeAllElements();
        } else {
            this.removed = new Vector();
        }
        if (this.added != null) {
            this.added.removeAllElements();
        } else {
            this.added = new Vector();
        }
        AbstractDocument.BranchElement lineMap = (AbstractDocument.BranchElement)this.getDefaultRootElement();
        int offset = chng.getOffset();
        int length = chng.getLength();
        if (offset > 0) {
            --offset;
            ++length;
        }
        int index = lineMap.getElementIndex(offset);
        Element rmCandidate = lineMap.getElement(index);
        int rmOffs0 = rmCandidate.getStartOffset();
        int rmOffs1 = rmCandidate.getEndOffset();
        int lastOffset = rmOffs0;
        try {
            String str = this.getText(offset, length);
            boolean hasBreaks = false;
            for (int i = 0; i < length; ++i) {
                char c = str.charAt(i);
                if (c != '\n') continue;
                int breakOffset = offset + i + 1;
                this.added.addElement(this.createLeafElement(lineMap, null, lastOffset, breakOffset));
                lastOffset = breakOffset;
                hasBreaks = true;
            }
            if (hasBreaks) {
                this.removed.addElement(rmCandidate);
                if (offset + length == rmOffs1 && lastOffset != rmOffs1 && index + 1 < lineMap.getElementCount()) {
                    Element e = lineMap.getElement(index + 1);
                    this.removed.addElement(e);
                    rmOffs1 = e.getEndOffset();
                }
                if (lastOffset < rmOffs1) {
                    this.added.addElement(this.createLeafElement(lineMap, null, lastOffset, rmOffs1));
                }
                Object[] aelems = new Element[this.added.size()];
                this.added.copyInto(aelems);
                Object[] relems = new Element[this.removed.size()];
                this.removed.copyInto(relems);
                AbstractDocument.ElementEdit ee = new AbstractDocument.ElementEdit(lineMap, index, (Element[])relems, (Element[])aelems);
                chng.addEdit(ee);
                lineMap.replace(index, relems.length, (Element[])aelems);
            }
            if (SJAbstractDocument.isComposedTextAttributeDefined(attr)) {
                this.insertComposedTextUpdate(chng, attr);
            }
        }
        catch (BadLocationException e) {
            if (LogSetup.IS_LOGGING_INFO) {
                LogSetup.LOGGER.info("catch (BadLocationException e). ");
                e.printStackTrace();
            }
            throw new Error("Internal error: " + e.toString());
        }
    }

    @Override
    protected void removeUpdate(AbstractDocument.DefaultDocumentEvent chng) {
        if (this.removed == null) {
            this.removed = new Vector();
        } else {
            this.removed.removeAllElements();
        }
        AbstractDocument.BranchElement map = (AbstractDocument.BranchElement)this.getDefaultRootElement();
        int offset = chng.getOffset();
        int length = chng.getLength();
        int line0 = map.getElementIndex(offset);
        int line1 = map.getElementIndex(offset + length);
        if (line0 != line1) {
            for (int i = line0; i <= line1; ++i) {
                this.removed.addElement(map.getElement(i));
            }
            int p0 = map.getElement(line0).getStartOffset();
            int p1 = map.getElement(line1).getEndOffset();
            Element[] aelems = new Element[]{this.createLeafElement(map, null, p0, p1)};
            Object[] relems = new Element[this.removed.size()];
            this.removed.copyInto(relems);
            AbstractDocument.ElementEdit ee = new AbstractDocument.ElementEdit(map, line0, (Element[])relems, aelems);
            chng.addEdit(ee);
            map.replace(line0, relems.length, aelems);
        } else {
            Element leaf;
            Element line = map.getElement(line0);
            if (!line.isLeaf() && SJAbstractDocument.isComposedTextElement(leaf = line.getElement(line.getElementIndex(offset)))) {
                Element[] aelem = new Element[]{this.createLeafElement(map, null, line.getStartOffset(), line.getEndOffset())};
                Element[] relem = new Element[]{line};
                AbstractDocument.ElementEdit ee = new AbstractDocument.ElementEdit(map, line0, relem, aelem);
                chng.addEdit(ee);
                map.replace(line0, 1, aelem);
            }
        }
    }

    private void insertComposedTextUpdate(AbstractDocument.DefaultDocumentEvent chng, AttributeSet attr) {
        if (this.added == null) {
            this.added = new Vector();
        } else {
            this.added.removeAllElements();
        }
        AbstractDocument.BranchElement lineMap = (AbstractDocument.BranchElement)this.getDefaultRootElement();
        int offset = chng.getOffset();
        int length = chng.getLength();
        int index = lineMap.getElementIndex(offset);
        Element elem = lineMap.getElement(index);
        int elemStart = elem.getStartOffset();
        int elemEnd = elem.getEndOffset();
        Element[] abelem = new AbstractDocument.BranchElement[]{(AbstractDocument.BranchElement)this.createBranchElement(lineMap, null)};
        Element[] relem = new Element[]{elem};
        if (elemStart != offset) {
            this.added.addElement(this.createLeafElement(abelem[0], null, elemStart, offset));
        }
        this.added.addElement(this.createLeafElement(abelem[0], attr, offset, offset + length));
        if (elemEnd != offset + length) {
            this.added.addElement(this.createLeafElement(abelem[0], null, offset + length, elemEnd));
        }
        Object[] alelem = new Element[this.added.size()];
        this.added.copyInto(alelem);
        AbstractDocument.ElementEdit ee = new AbstractDocument.ElementEdit(lineMap, index, relem, abelem);
        chng.addEdit(ee);
        ((AbstractDocument.BranchElement)abelem[0]).replace(0, 0, (Element[])alelem);
        lineMap.replace(index, 1, abelem);
    }

    static boolean isComposedTextElement(Element elem) {
        AttributeSet as = elem.getAttributes();
        return SJAbstractDocument.isComposedTextAttributeDefined(as);
    }

    static boolean isComposedTextAttributeDefined(AttributeSet as) {
        return as != null && as.isDefined(StyleConstants.ComposedTextAttribute);
    }

    private static Date parseDate(Locale locale, String date, int type) {
        if (date == null) {
            return null;
        }
        if (locale == null) {
            locale = Locale.US;
        }
        SimpleDateFormat df = null;
        if (type == 0) {
            for (int i = 0; i < MDYPattern.length; ++i) {
                try {
                    if (df == null) {
                        df = new SimpleDateFormat(MDYPattern[i], locale);
                    } else {
                        df.applyPattern(MDYPattern[i]);
                    }
                    Date d = df.parse(date);
                    return d;
                }
                catch (Exception e) {
                    if (!LogSetup.IS_LOGGING_INFO) continue;
                    LogSetup.LOGGER.info("catch(Exception e) 1st. ");
                    e.printStackTrace();
                    continue;
                }
            }
            return null;
        }
        if (type == 1) {
            for (int i = 0; i < DMYPattern.length; ++i) {
                try {
                    if (df == null) {
                        df = new SimpleDateFormat(DMYPattern[i], locale);
                    } else {
                        df.applyPattern(DMYPattern[i]);
                    }
                    Date d = df.parse(date);
                    return d;
                }
                catch (Exception e) {
                    if (!LogSetup.IS_LOGGING_INFO) continue;
                    LogSetup.LOGGER.info("catch(Exception e) 2nd. ");
                    e.printStackTrace();
                    continue;
                }
            }
            return null;
        }
        if (type == 2) {
            for (int i = 0; i < YMDPattern.length; ++i) {
                try {
                    if (df == null) {
                        df = new SimpleDateFormat(YMDPattern[i], locale);
                    } else {
                        df.applyPattern(YMDPattern[i]);
                    }
                    Date d = df.parse(date);
                    return d;
                }
                catch (Exception e) {
                    if (!LogSetup.IS_LOGGING_INFO) continue;
                    LogSetup.LOGGER.info("catch(Exception e) 3rd. ");
                    e.printStackTrace();
                    continue;
                }
            }
            return null;
        }
        return null;
    }

    private static String parseDateString(Locale locale, String text, int len, int type) {
        Date d = SJAbstractDocument.parseDate(locale, text, type);
        if (d == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.setTime(d);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        int year = cal.get(1);
        char c1 = (char)(month / 10 + 48);
        char c2 = (char)(month % 10 + 48);
        String mo = "" + c1 + c2;
        char c3 = (char)(day / 10 + 48);
        char c4 = (char)(day % 10 + 48);
        String da = "" + c3 + c4;
        int y = year;
        if (y < 100) {
            y += 1900;
        }
        char c8 = (char)(y % 10 + 48);
        char c7 = (char)((y /= 10) % 10 + 48);
        char c6 = (char)((y /= 10) % 10 + 48);
        char c5 = (char)((y /= 10) % 10 + 48);
        String yr = len < 10 ? "" + c7 + c8 : "" + c5 + c6 + c7 + c8;
        if (len >= 8) {
            if (type == 0) {
                return mo + "/" + da + "/" + yr;
            }
            if (type == 1) {
                return da + "/" + mo + "/" + yr;
            }
            if (type == 2) {
                return yr + "/" + mo + "/" + da;
            }
        } else {
            if (type == 0) {
                return mo + da + yr;
            }
            if (type == 1) {
                return da + mo + yr;
            }
            if (type == 2) {
                return yr + mo + da;
            }
        }
        return "";
    }

    static String validateData(TerminalAttribute ta, String text, Locale locale, int minimumValue, int maximumValue) {
        String func = ".validateData(): ";
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer(".validateData(): text=" + text + ".");
        }
        if (text == null) {
            text = "";
        }
        if (ta.getFull()) {
            String mask = ta.getMask();
            if (text.length() != 0 && (mask != null && mask.length() > 0 && text.length() < mask.length() || ta.getDataBufferLength() > 0 && text.length() < ta.getDataBufferLength())) {
                ta.setError(true, SJAbstractDocument.getResource("component.entry-field.full-or-empty", "Must Be Full or Empty"));
                if (ta.getValidateExplicitly()) {
                    ta.requestFocus();
                }
                return text;
            }
        }
        if (ta.getRequired() && text.length() == 0) {
            ta.setError(202, SJAbstractDocument.getResource("component.entry-field.required", "Required Field"));
            if (ta.getValidateExplicitly()) {
                ta.requestFocus();
            }
            return text;
        }
        if (text.length() < ta.getMinimumLength()) {
            ta.setError(true, SJAbstractDocument.getResource("component.entry-field.minimum", "Minimum Length is ") + ta.getMinimumLength());
            if (ta.getValidateExplicitly()) {
                ta.requestFocus();
            }
            return text;
        }
        int decimalPlaces = ta.getDecimalPlaces();
        String temp = text;
        temp = temp.trim();
        if (ta.getImpliedDecimal()) {
            try {
                temp = SJAbstractDocument.formatDecimalNumber(locale, text, ta.getDataBufferLength(), ta.getDatatype(), decimalPlaces, ta);
            }
            catch (Exception e) {
                if (LogSetup.IS_LOGGING_INFO) {
                    LogSetup.LOGGER.info("catch(Exception e) 1st. ");
                    e.printStackTrace();
                }
                ta.setError(207, SJAbstractDocument.getResource("component.entry-field.number-only", "This field can only contain a number (" + decimalPlaces + " decimal places implied)"));
                if (ta.getValidateExplicitly()) {
                    ta.requestFocus();
                }
                return text;
            }
        }
        if (ta.getDatatype() == 65537) {
            try {
                text = SJAbstractDocument.formatDecimalNumber(locale, text, ta.getDataBufferLength(), ta.getDatatype(), decimalPlaces, ta);
            }
            catch (Exception e) {
                if (LogSetup.IS_LOGGING_INFO) {
                    LogSetup.LOGGER.info("catch(Exception e) 2nd. ");
                    e.printStackTrace();
                }
                ta.setError(204, SJAbstractDocument.getResource("component.entry-field.digits-only", "This field can only contain digits (0-9)"));
                if (ta.getValidateExplicitly()) {
                    ta.requestFocus();
                }
                return text;
            }
        }
        if (ta.getDatatype() != 65536) {
            if (ta.getDatatype() == 65540) {
                int len = ta.getDataBufferLength();
                String dateString = SJAbstractDocument.parseDateString(locale, text, len, 2);
                if (dateString == null) {
                    ta.setError(210, SJAbstractDocument.getResource("component.entry-field.ymd-only", "The field must be a valid date, in YMD order"));
                    if (ta.getValidateExplicitly()) {
                        ta.requestFocus();
                    }
                    return text;
                }
                return dateString;
            }
            if (ta.getDatatype() == 65538) {
                int len = ta.getDataBufferLength();
                String dateString = SJAbstractDocument.parseDateString(locale, text, len, 1);
                if (dateString == null) {
                    ta.setError(208, SJAbstractDocument.getResource("component.entry-field.dmy-only", "The field must be a valid date, in DMY order"));
                    if (ta.getValidateExplicitly()) {
                        ta.requestFocus();
                    }
                    return text;
                }
                return dateString;
            }
            if (ta.getDatatype() == 65539) {
                int len = ta.getDataBufferLength();
                String dateString = SJAbstractDocument.parseDateString(locale, text, len, 0);
                if (dateString == null) {
                    ta.setError(209, SJAbstractDocument.getResource("component.entry-field.mdy-only", "The field must be a valid date, in MDY order"));
                    if (ta.getValidateExplicitly()) {
                        ta.requestFocus();
                    }
                    return text;
                }
                return dateString;
            }
            if (decimalPlaces < 0) {
                try {
                    temp = SJAbstractDocument.formatDecimalNumber(locale, text, ta.getDataBufferLength(), ta.getDatatype(), decimalPlaces, ta);
                }
                catch (Exception e) {
                    if (LogSetup.IS_LOGGING_INFO) {
                        LogSetup.LOGGER.info("catch(Exception e) 3rd. ");
                        e.printStackTrace();
                    }
                    ta.setError(205, SJAbstractDocument.getResource("component.entry-field.number-only", "This field can only contain a number (" + decimalPlaces + " decimal places)"));
                    if (ta.getValidateExplicitly()) {
                        ta.requestFocus();
                    }
                    return text;
                }
            }
            if (decimalPlaces > 0) {
                try {
                    temp = SJAbstractDocument.formatDecimalNumber(locale, text, ta.getDataBufferLength(), ta.getDatatype(), decimalPlaces, ta);
                }
                catch (Exception e) {
                    if (LogSetup.IS_LOGGING_INFO) {
                        LogSetup.LOGGER.info("catch(Exception e) 4th. ");
                        e.printStackTrace();
                    }
                    ta.setError(205, SJAbstractDocument.getResource("component.entry-field.number-only", "This field can only contain a number (" + decimalPlaces + " decimal places)"));
                    if (ta.getValidateExplicitly()) {
                        ta.requestFocus();
                    }
                    return text;
                }
            }
        }
        if (minimumValue != maximumValue) {
            StringBuffer result = new StringBuffer();
            int length = text.length();
            char c = '\u0000';
            for (int i = 0; i < length; ++i) {
                c = text.charAt(i);
                switch (c) {
                    case '-': 
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        result.append(c);
                    }
                }
            }
            String resultString = result.toString();
            int theValue = Integer.parseInt(resultString);
            if (theValue < minimumValue || theValue > maximumValue) {
                ta.setError(205, SJAbstractDocument.getResource("component.entry-field.number-range", "Number must be in " + minimumValue + " through " + maximumValue));
                if (ta.getValidateExplicitly()) {
                    ta.requestFocus();
                }
                return resultString;
            }
        }
        return text;
    }

    private static String stripLeadingZeros(String text, char zip, char decimal, char comma) {
        char c;
        int index;
        for (index = 0; index < text.length() && ((c = text.charAt(index)) == zip || c == comma); ++index) {
        }
        if (index > 0) {
            text = text.substring(index);
        }
        if (text.trim().length() == 0) {
            text = "" + zip;
        }
        if (text.charAt(0) == decimal) {
            text = zip + text;
        }
        return text;
    }

    private static String roundOrTruncate(String text, boolean isNegative, char zip, char decimal, char comma) {
        int len;
        String func = ".roundOrTruncate(): ";
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer(".roundOrTruncate(): text=" + text + ".");
        }
        if ((len = text.length() - 1) < 0) {
            return "";
        }
        char c = text.charAt(len);
        char five = (char)(zip + 5);
        if (c == decimal) {
            if (len == 0) {
                return String.valueOf(decimal);
            }
            return SJAbstractDocument.roundOrTruncate(text.substring(0, len), isNegative, zip, decimal, comma) + decimal;
        }
        if (c == comma) {
            if (len == 0) {
                return String.valueOf(comma);
            }
            return SJAbstractDocument.roundOrTruncate(text.substring(0, len), isNegative, zip, decimal, comma) + comma;
        }
        if (c < five) {
            if (len == 0) {
                return "";
            }
            return text.substring(0, len);
        }
        if (c == five && isNegative) {
            if (len == 0) {
                return "";
            }
            return text.substring(0, len);
        }
        if (--len <= 0) {
            return "1";
        }
        char lc = text.charAt(len);
        boolean addDecimal = false;
        boolean addComma = false;
        if (lc == decimal) {
            if (--len <= 0) {
                return "1" + decimal;
            }
            lc = text.charAt(len);
            addDecimal = true;
        } else if (lc == comma) {
            if (--len <= 0) {
                return "1" + comma;
            }
            lc = text.charAt(len);
            addComma = true;
        }
        char lastChar = lc != '9' ? (lc = (char)(lc + '\u0001')) : zip;
        if (addDecimal) {
            return SJAbstractDocument.roundOrTruncate(text.substring(0, len) + lc, isNegative, zip, decimal, comma) + decimal + lastChar;
        }
        if (addComma) {
            return SJAbstractDocument.roundOrTruncate(text.substring(0, len) + lc, isNegative, zip, decimal, comma) + comma + lastChar;
        }
        return SJAbstractDocument.roundOrTruncate(text.substring(0, len) + lc, isNegative, zip, decimal, comma) + lastChar;
    }

    private static String round(String text, int curDecimalPlaces, int decimalPlaces, boolean isNegative, char zip, char decimal, char comma) throws ParseException {
        String func = ".round(): ";
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer(".round(): text=" + text + ".");
        }
        if (text == null || text.length() <= 1) {
            return "";
        }
        if (curDecimalPlaces == 0) {
            return text.substring(0, text.length() - 1);
        }
        int dif = curDecimalPlaces - decimalPlaces;
        if (dif <= 0) {
            return text;
        }
        int targetLength = text.length() - dif;
        while (text.length() > targetLength) {
            text = SJAbstractDocument.roundOrTruncate(text, isNegative, zip, decimal, comma);
        }
        while (text.length() < targetLength) {
            text = text + zip;
        }
        return text;
    }

    private static boolean checkCommas(String text, char comma, int groupingSize) {
        int start = text.indexOf(comma);
        if (start >= 0) {
            int end = -1;
            if (start + 1 != text.length()) {
                end = text.indexOf(comma, start + 1);
            }
            if (end < 0) {
                int dif = text.length() - (start + 1);
                if (dif < groupingSize) {
                    return false;
                }
            } else {
                int dif = end - (start + 1);
                if (dif < groupingSize) {
                    return false;
                }
                if (end + 1 != text.length()) {
                    return SJAbstractDocument.checkCommas(text.substring(end + 1), comma, groupingSize);
                }
            }
            return true;
        }
        return true;
    }

    private static String formatDecimalNumber(Locale locale, String text, int len, int datatype, int decimalPlaces, TerminalAttribute ta) throws ParseException {
        String func = ".formatDecimalNumber(): ";
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer(".formatDecimalNumber(): text=" + text + ". locale=" + locale + ". len=" + len + ". decimalPlaces=" + decimalPlaces + ".");
        }
        if (text == null || text.trim().length() == 0) {
            return text;
        }
        return SJAbstractDocument.inner_formatDecimalNumber(locale, text, len, datatype, decimalPlaces, ta);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String inner_formatDecimalNumber(Locale locale, String text, int len, int datatype, int decimalPlaces, TerminalAttribute ta) throws ParseException {
        int currentDecimalPlaces;
        String func = ".inner_formatDecimalNumber(): ";
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer(".inner_formatDecimalNumber(): text=" + text + ". locale=" + locale + ". len=" + len + ". decimalPlaces=" + decimalPlaces + ".");
        }
        ta.setAlignment(2);
        String originalText = text;
        DecimalFormat df = null;
        try {
            df = (DecimalFormat)NumberFormat.getInstance(locale);
        }
        catch (Exception e) {
            if (!LogSetup.IS_LOGGING_INFO) throw new ParseException("NL Error", 0);
            LogSetup.LOGGER.info("catch(Exception e). ");
            e.printStackTrace();
            throw new ParseException("NL Error", 0);
        }
        DecimalFormatSymbols symbols = df.getDecimalFormatSymbols();
        char comma = symbols.getGroupingSeparator();
        char decimal = symbols.getDecimalSeparator();
        char minus = symbols.getMinusSign();
        char zip = symbols.getZeroDigit();
        int groupingSize = df.getGroupingSize();
        text = text == null ? "" : text.trim();
        boolean isNegative = false;
        int index = text.indexOf(minus);
        if (index > 0) {
            throw new ParseException("Invalid number", 0);
        }
        if (index == 0) {
            isNegative = true;
            text = text.length() > 1 ? text.substring(1) : "";
        }
        if ((index = text.indexOf(43)) > 0) {
            throw new ParseException("Invalid number", 0);
        }
        if (index == 0) {
            text = text.length() > 1 ? text.substring(1) : "";
        }
        text = SJAbstractDocument.stripLeadingZeros(text, zip, decimal, comma);
        if (datatype > 65535) {
            if (isNegative) {
                throw new ParseException("Number must be positive", 0);
            }
            if (text.indexOf(comma) > 0) throw new ParseException("Number must only contain digits", 0);
            if (text.indexOf(decimal) > 0) throw new ParseException("Number must only contain digits", 0);
            if (text.indexOf(32) > 0) {
                throw new ParseException("Number must only contain digits", 0);
            }
        } else if (datatype < 0) {
            index = text.indexOf(decimal);
            if (index >= 0) {
                currentDecimalPlaces = text.length() - index - 1;
                if (currentDecimalPlaces > decimalPlaces && currentDecimalPlaces > decimalPlaces) {
                    ta.setError(206, "Maximum Decimal Places " + decimalPlaces);
                    if (!ta.getValidateExplicitly()) return originalText;
                    ta.requestFocus();
                    return originalText;
                }
                while (currentDecimalPlaces < decimalPlaces) {
                    text = text + zip;
                    ++currentDecimalPlaces;
                }
                if (index == 0) {
                    if ((text = text.substring(1)).indexOf(comma) >= 0) throw new ParseException("Invalid Number", 0);
                    if (text.indexOf(decimal) >= 0) throw new ParseException("Invalid Number", 0);
                    if (text.indexOf(32) > 0) {
                        throw new ParseException("Invalid Number", 0);
                    }
                    text = SJAbstractDocument.stripLeadingZeros(text, zip, decimal, comma);
                } else {
                    if (!SJAbstractDocument.checkCommas(text.substring(0, index), comma, groupingSize)) {
                        throw new ParseException("Invalid Number", 0);
                    }
                    if (index == text.length() - 1) {
                        text = text.substring(0, index);
                    } else {
                        String fraction = text.substring(index + 1);
                        if (fraction.indexOf(comma) >= 0) throw new ParseException("Invalid Number", 0);
                        if (fraction.indexOf(decimal) >= 0) throw new ParseException("Invalid Number", 0);
                        if (fraction.indexOf(32) > 0) {
                            throw new ParseException("Invalid Number", 0);
                        }
                        text = text.substring(0, index) + fraction;
                    }
                }
            }
        } else if (datatype > 0) {
            if (decimalPlaces < 0) {
                index = text.indexOf(decimal);
                if (index >= 0) {
                    int addition;
                    if (index > 0 && !SJAbstractDocument.checkCommas(text.substring(0, index), comma, groupingSize)) {
                        throw new ParseException("Invalid Number", 0);
                    }
                    currentDecimalPlaces = text.length() - index - 1;
                    if (currentDecimalPlaces > 0) {
                        String fraction = text.substring(index + 1);
                        if (fraction.indexOf(comma) >= 0) throw new ParseException("Invalid Number", 0);
                        if (fraction.indexOf(decimal) >= 0) throw new ParseException("Invalid Number", 0);
                        if (fraction.indexOf(32) > 0) {
                            throw new ParseException("Invalid Number", 0);
                        }
                        if (currentDecimalPlaces > 9) {
                            text = SJAbstractDocument.round(text, currentDecimalPlaces, 9, isNegative, zip, decimal, comma);
                        }
                    }
                    int n = addition = isNegative ? 1 : 0;
                    if (len > 0 && text.length() + addition > len) {
                        if (len < index) throw new ParseException("Number too large", 0);
                        text = SJAbstractDocument.round(text, text.length() + addition - index, len - index, isNegative, zip, decimal, comma);
                    }
                } else if (!SJAbstractDocument.checkCommas(text, comma, groupingSize)) {
                    throw new ParseException("Invalid Number", 0);
                }
            } else {
                int addition;
                index = text.indexOf(decimal);
                if (index >= 0) {
                    if (index > 0 && !SJAbstractDocument.checkCommas(text.substring(0, index), comma, groupingSize)) {
                        throw new ParseException("Invalid Number", 0);
                    }
                    currentDecimalPlaces = text.length() - index - 1;
                    if (currentDecimalPlaces > 0) {
                        String fraction = text.substring(index + 1);
                        if (fraction.indexOf(comma) >= 0) throw new ParseException("Invalid Number", 0);
                        if (fraction.indexOf(decimal) >= 0) throw new ParseException("Invalid Number", 0);
                        if (fraction.indexOf(32) > 0) {
                            throw new ParseException("Invalid Number", 0);
                        }
                    }
                    if (currentDecimalPlaces > decimalPlaces) {
                        ta.setError(206, "Maximum Decimal Places " + decimalPlaces);
                        if (!ta.getValidateExplicitly()) return originalText;
                        ta.requestFocus();
                        return originalText;
                    }
                } else {
                    if (!SJAbstractDocument.checkCommas(text, comma, groupingSize)) {
                        throw new ParseException("Invalid Number", 0);
                    }
                    index = text.length();
                    text = text + decimal;
                    for (int i = 0; i < decimalPlaces; ++i) {
                        text = text + zip;
                    }
                }
                int n = addition = isNegative ? 1 : 0;
                if (len > 0 && text.length() + addition > len) {
                    if (len < index) throw new ParseException("Number too large", 0);
                    text = SJAbstractDocument.round(text, text.length() + addition - index, len - index, isNegative, zip, decimal, comma);
                }
            }
        }
        if (isNegative) {
            text = minus + text;
        }
        if (len <= 0) return text;
        if (text.length() > len) {
            throw new ParseException("Number too large", 0);
        }
        if (text.length() >= len) return text;
        while (text.length() < len) {
            text = "                                        " + text;
        }
        if (text.length() <= len) return text;
        return text.substring(text.length() - len);
    }
}

