/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.jfc;

import com.heirloomcomputing.ecs.exec.LogSetup;
import com.heirloomcomputing.ecs.jfc.SJTextArea;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.WrappedPlainView;

class SJCustomView
extends WrappedPlainView {
    private boolean underlined = false;
    private char echochar = '\u0000';
    private char[] echoChar = new char[1];
    private boolean isField = true;
    private int tabBase = 0;
    boolean widthChanging = false;

    public SJCustomView(Element elem) {
        super(elem);
    }

    public SJCustomView(Element elem, boolean componentIsAField) {
        super(elem);
        this.isField = componentIsAField;
    }

    public void setUnderline(boolean state) {
        this.underlined = state;
    }

    public void setEchoChar(char c) {
        this.echochar = c;
    }

    private int drawEchoCharacter(Graphics g, int x, int y, char c) {
        this.echoChar[0] = c;
        g.drawChars(this.echoChar, 0, 1, x, y);
        return x + g.getFontMetrics().charWidth(c);
    }

    private int drawElementEcho(Element elem, int p0, int p1, Graphics g, int x, int y) throws BadLocationException {
        int firstx = x;
        int firsty = y;
        Container c = this.getContainer();
        if (c instanceof JTextComponent) {
            JTextComponent f = (JTextComponent)c;
            g.setColor(f.getForeground());
            int n = p1 - p0;
            for (int i = 0; i < n; ++i) {
                x = this.drawEchoCharacter(g, x, y, this.echochar);
            }
        }
        if (this.underlined && firstx != x) {
            g.drawLine(firstx, firsty, x, y);
        }
        return x;
    }

    private final int getTabbedTextWidth(FontMetrics metrics, int count, int x, TabExpander e, int startOffset) {
        int echoCharWidth = metrics.charWidth(this.echochar);
        if (count > 0) {
            return echoCharWidth > 0 ? echoCharWidth * count : 0;
        }
        return 0;
    }

    private Rectangle lineToRect2(FontMetrics metrics, Shape a, int line) {
        if (metrics == null) {
            return null;
        }
        Rectangle alloc = a.getBounds();
        return new Rectangle(alloc.x, alloc.y + line * metrics.getHeight(), alloc.width, metrics.getHeight());
    }

    private Shape modelToViewEcho(FontMetrics metrics, int pos, Shape a, Position.Bias b) throws BadLocationException {
        Element map = this.getElement();
        int lineIndex = map.getElementIndex(pos);
        Rectangle lineArea = this.lineToRect2(metrics, a, lineIndex);
        int tabBase = lineArea.x;
        Element line = map.getElement(lineIndex);
        int p0 = line.getStartOffset();
        int xOffs = this.getTabbedTextWidth(metrics, pos - p0, tabBase, this, p0);
        lineArea.x += xOffs;
        lineArea.width = 1;
        lineArea.height = metrics.getHeight();
        return lineArea;
    }

    private final int getTabbedTextOffset(FontMetrics metrics, int count, int x0, int x, TabExpander e, int startOffset, boolean round) {
        int currX;
        int nextX = currX = x0;
        int echoCharWidth = metrics.charWidth(this.echochar);
        for (int i = 0; i < count; ++i) {
            if (x >= currX && x < (nextX += echoCharWidth)) {
                if (!round || x - currX < nextX - x) {
                    return i;
                }
                return i + 1;
            }
            currX = nextX;
        }
        return count;
    }

    private int viewToModelEcho(FontMetrics metrics, float fx, float fy, Shape a, Position.Bias[] bias) {
        bias[0] = Position.Bias.Forward;
        Rectangle alloc = a.getBounds();
        Document doc = this.getDocument();
        int x = (int)fx;
        int y = (int)fy;
        if (y < alloc.y) {
            return this.getStartOffset();
        }
        if (y > alloc.y + alloc.height) {
            return this.getEndOffset() - 1;
        }
        Element map = doc.getDefaultRootElement();
        int lineIndex = Math.abs((y - alloc.y) / metrics.getHeight());
        if (lineIndex >= map.getElementCount()) {
            return this.getEndOffset() - 1;
        }
        Element line = map.getElement(lineIndex);
        if (x < alloc.x) {
            return line.getStartOffset();
        }
        if (x > alloc.x + alloc.width) {
            return line.getEndOffset() - 1;
        }
        int p0 = line.getStartOffset();
        int p1 = line.getEndOffset() - 1;
        int tabBase = alloc.x;
        return p0 + this.getTabbedTextOffset(metrics, p1 - p0, tabBase, x, this, p0, true);
    }

    @Override
    protected int calculateBreakPosition(int p0, int p1) {
        block3: {
            try {
                boolean wordWrap;
                boolean bl = wordWrap = ((SJTextArea)this.getContainer()).getLineWrap() && ((SJTextArea)this.getContainer()).getWrapStyleWord();
                if (wordWrap) {
                    return this.calculateBreakPosition(p0, p1);
                }
            }
            catch (Exception e) {
                if (!LogSetup.IS_LOGGING_INFO) break block3;
                LogSetup.LOGGER.info("catch(Exception e). ");
                e.printStackTrace();
            }
        }
        return super.calculateBreakPosition(p0, p1);
    }

    @Override
    protected void drawLine(int p0, int p1, Graphics g, int x, int y) {
        block5: {
            Element lineMap = this.getElement();
            Element line = lineMap.getElement(lineMap.getElementIndex(p0));
            p1 = Math.min(this.getDocument().getLength(), p1);
            try {
                if (line.isLeaf()) {
                    this.drawElement(line, p0, p1, g, x, y);
                } else {
                    int lastIdx = line.getElementIndex(p1);
                    for (int idx = line.getElementIndex(p0); idx <= lastIdx; ++idx) {
                        Element elem = line.getElement(idx);
                        int start = Math.max(elem.getStartOffset(), p0);
                        int end = Math.min(elem.getEndOffset(), p1);
                        x = this.drawElement(elem, start, end, g, x, y);
                    }
                }
            }
            catch (BadLocationException e) {
                if (!LogSetup.IS_LOGGING_INFO) break block5;
                LogSetup.LOGGER.info("catch (BadLocationException e). ");
                e.printStackTrace();
            }
        }
    }

    private int drawElement(Element elem, int p0, int p1, Graphics g, int x, int y) throws BadLocationException {
        if (this.echochar != '\u0000') {
            return this.drawElementEcho(elem, p0, p1, g, x, y);
        }
        int firstx = x;
        int firsty = y;
        x = this.drawElementInner(elem, p0, p1, g, x, y);
        if (this.underlined && firstx != x) {
            g.drawLine(firstx, firsty, x, y);
        }
        return x;
    }

    public Segment getOurLineBuffer() {
        return super.getLineBuffer();
    }

    private int drawElementInner(Element elem, int p0, int p1, Graphics g, int x, int y) throws BadLocationException {
        int sel1;
        int offsetx;
        JTextComponent host;
        block17: {
            host = (JTextComponent)this.getContainer();
            offsetx = 0;
            try {
                int horizontalAlignment = ((SJTextArea)host).getHorizontalAlignment();
                switch (horizontalAlignment) {
                    default: {
                        break;
                    }
                    case 0: 
                    case 4: {
                        FontMetrics fm = g.getFontMetrics();
                        if (fm != null) {
                            Segment lineBuffer = this.getLineBuffer();
                            this.getDocument().getText(p0, p1 - p0, lineBuffer);
                            String lineBufferString = lineBuffer.toString();
                            int stringSize = SwingUtilities.computeStringWidth(fm, lineBufferString);
                            Rectangle r = host.getBounds();
                            offsetx = r.width - stringSize;
                        }
                        if (horizontalAlignment == 0) {
                            offsetx /= 2;
                        }
                        break;
                    }
                }
            }
            catch (Exception e) {
                if (!LogSetup.IS_LOGGING_INFO) break block17;
                LogSetup.LOGGER.info("catch(Exception e). ");
                e.printStackTrace();
            }
        }
        x += offsetx;
        int sel0 = host.getSelectionStart();
        if (sel0 == (sel1 = host.getSelectionEnd())) {
            x = this.drawUnselectedText(g, x, y, p0, p1);
        } else if (p0 >= sel0 && p0 <= sel1 && p1 >= sel0 && p1 <= sel1) {
            x = this.drawSelectedText(g, x, y, p0, p1);
        } else if (sel0 >= p0 && sel0 <= p1) {
            if (sel1 >= p0 && sel1 <= p1) {
                x = this.drawUnselectedText(g, x, y, p0, sel0);
                x = this.drawSelectedText(g, x, y, sel0, sel1);
                x = this.drawUnselectedText(g, x, y, sel1, p1);
            } else {
                x = this.drawUnselectedText(g, x, y, p0, sel0);
                x = this.drawSelectedText(g, x, y, sel0, p1);
            }
        } else if (sel1 >= p0 && sel1 <= p1) {
            x = this.drawSelectedText(g, x, y, p0, sel1);
            x = this.drawUnselectedText(g, x, y, sel1, p1);
        } else {
            x = this.drawUnselectedText(g, x, y, p0, p1);
        }
        return x;
    }

    @Override
    public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
        View v;
        int testPos;
        if (this.echochar != '\u0000') {
            return this.modelToViewEcho(this.getFontMetrics(), pos, a, b);
        }
        if (!this.isAllocationValid()) {
            Rectangle alloc = a.getBounds();
            this.setSize(alloc.width, alloc.height);
        }
        boolean isBackward = b == Position.Bias.Backward;
        int n = testPos = isBackward ? Math.max(0, pos - 1) : pos;
        if (isBackward && testPos < this.getStartOffset()) {
            return null;
        }
        int vIndex = this.getViewIndexAtPosition(testPos);
        Shape retShape = null;
        if (vIndex != -1 && vIndex < this.getViewCount() && (v = this.getView(vIndex)) != null && testPos >= v.getStartOffset() && testPos < v.getEndOffset()) {
            retShape = v.modelToView(pos, this.getChildAllocation(vIndex, a), b);
            if (retShape == null && v.getEndOffset() == pos && ++vIndex < this.getViewCount()) {
                v = this.getView(vIndex);
                retShape = v.modelToView(pos, this.getChildAllocation(vIndex, a), b);
            }
            return retShape;
        }
        throw new BadLocationException("Position not represented by view", pos);
    }

    @Override
    public int viewToModel(float fx, float fy, Shape a, Position.Bias[] bias) {
        if (this.echochar != '\u0000') {
            return this.viewToModelEcho(this.getFontMetrics(), fx, fy, a, bias);
        }
        return super.viewToModel(fx, fy, a, bias);
    }

    protected void loadTextForNow(int p0, int p1) {
        block2: {
            try {
                this.getDocument().getText(p0, p1 - p0, this.getLineBuffer());
            }
            catch (Exception e) {
                if (!LogSetup.IS_LOGGING_INFO) break block2;
                LogSetup.LOGGER.info("catch(Exception e). ");
                e.printStackTrace();
            }
        }
    }

    private int getLineIndexFromPos(int pos) {
        return this.getElement().getElementIndex(pos);
    }

    private FontMetrics getFontMetrics() {
        Container c = this.getContainer();
        return c.getFontMetrics(c.getFont());
    }

    @Override
    public void paint(Graphics g, Shape a) {
        block4: {
            try {
                this.tabBase = ((Rectangle)a).x;
                if (!this.isField) {
                    super.paint(g, a);
                } else {
                    Rectangle r = (Rectangle)a;
                    g.clipRect(r.x, r.y, r.width, r.height);
                    super.paint(g, a);
                }
            }
            catch (Throwable throwable) {
                if (!LogSetup.IS_LOGGING_INFO) break block4;
                LogSetup.LOGGER.info("catch(Throwable throwable). ");
                throwable.printStackTrace();
            }
        }
    }

    private int getLineWidth(Element line) {
        try {
            int p0 = line.getStartOffset();
            int p1 = line.getEndOffset();
            line.getDocument().getText(p0, p1 - p0, this.getLineBuffer());
            return Utilities.getTabbedTextWidth(this.getLineBuffer(), this.getFontMetrics(), this.tabBase, (TabExpander)this, p0);
        }
        catch (BadLocationException e) {
            if (LogSetup.IS_LOGGING_INFO) {
                LogSetup.LOGGER.info("catch (BadLocationException e). ");
                e.printStackTrace();
            }
            return 0;
        }
    }

    public float getPreferredSpan(int axis, int lineIndex) {
        switch (axis) {
            case 0: {
                return this.getLineWidth(this.getElement().getElement(lineIndex));
            }
        }
        return super.getPreferredSpan(axis);
    }

    @Override
    public float getPreferredSpan(int axis) {
        switch (axis) {
            case 0: {
                Segment buff = this.getLineBuffer();
                Document doc = this.getDocument();
                try {
                    doc.getText(0, doc.getLength(), buff);
                    return Utilities.getTabbedTextWidth(buff, this.getFontMetrics(), 0, (TabExpander)this, 0);
                }
                catch (BadLocationException bl) {
                    if (LogSetup.IS_LOGGING_INFO) {
                        LogSetup.LOGGER.info("catch (BadLocationException bl). ");
                        bl.printStackTrace();
                    }
                    return 0.0f;
                }
            }
        }
        return super.getPreferredSpan(axis);
    }

    @Override
    public int getResizeWeight(int axis) {
        if (!this.isField) {
            return super.getResizeWeight(axis);
        }
        return axis == 0 ? 1 : 0;
    }

    @Override
    public void insertUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        this.updateOurChildren(e, a);
        Rectangle alloc = a != null && this.isAllocationValid() ? this.getInsideAllocation(a) : null;
        int pos = e.getOffset();
        View v = this.getViewAtPosition(pos, alloc);
        if (v != null) {
            v.insertUpdate(e, alloc, f);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        this.updateOurChildren(e, a);
        Rectangle alloc = a != null && this.isAllocationValid() ? this.getInsideAllocation(a) : null;
        int pos = e.getOffset();
        View v = this.getViewAtPosition(pos, alloc);
        if (v != null) {
            v.removeUpdate(e, alloc, f);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        this.updateOurChildren(e, a);
    }

    @Override
    public void setSize(float width, float height) {
        if ((int)width != this.getWidth()) {
            this.widthChanging = true;
        }
        super.setSize(width, height);
        this.widthChanging = false;
    }

    @Override
    protected void loadChildren(ViewFactory f) {
        Element e = this.getElement();
        int n = e.getElementCount();
        if (n > 0) {
            View[] added = new View[n];
            for (int i = 0; i < n; ++i) {
                added[i] = new OurWrappedLine(e.getElement(i));
            }
            this.replace(0, 0, added);
        }
    }

    void updateOurChildren(DocumentEvent e, Shape a) {
        Element elem = this.getElement();
        DocumentEvent.ElementChange ec = e.getChange(elem);
        if (ec != null) {
            Element[] removedElems = ec.getChildrenRemoved();
            Element[] addedElems = ec.getChildrenAdded();
            View[] added = new View[addedElems.length];
            for (int i = 0; i < addedElems.length; ++i) {
                added[i] = new OurWrappedLine(addedElems[i]);
            }
            this.replace(ec.getIndex(), removedElems.length, added);
            if (a != null) {
                this.preferenceChanged(null, true, true);
                this.getContainer().repaint();
            }
        }
        super.getPreferredSpan(0);
    }

    class OurWrappedLine
    extends View {
        int nlines;

        OurWrappedLine(Element elem) {
            super(elem);
        }

        protected Shape adjustAllocation(Shape a, int pos) {
            return this.adjustAllocation(a, pos, 0);
        }

        protected Shape adjustAllocation(Shape a, int pos, int lineNumber) {
            if (a == null) {
                return null;
            }
            Rectangle bounds = a.getBounds();
            int lineIndex = SJCustomView.this.getLineIndexFromPos(pos);
            int hspan = lineIndex >= 0 ? (int)SJCustomView.this.getPreferredSpan(0, lineIndex) : (int)SJCustomView.this.getPreferredSpan(0);
            int viewWidth = SJCustomView.this.getWidth();
            int finalLine = 0;
            if (viewWidth > 0) {
                finalLine = (hspan - 1) / viewWidth;
            }
            boolean isLastLine = lineNumber == finalLine;
            hspan %= bounds.width;
            Container c = this.getContainer();
            if (c instanceof SJTextArea) {
                SJTextArea field = (SJTextArea)c;
                int alignment = field.getHorizontalAlignment();
                if (alignment == 2) {
                    return bounds;
                }
                if (hspan <= bounds.width) {
                    int slop = bounds.width - 1 - hspan;
                    switch (alignment) {
                        case 0: {
                            if (!isLastLine) {
                                return bounds;
                            }
                            bounds.x += slop / 2;
                            bounds.width -= slop;
                            break;
                        }
                        case 4: {
                            if (!isLastLine) {
                                return bounds;
                            }
                            bounds.x += slop;
                            bounds.width -= slop;
                        }
                    }
                }
            }
            return bounds;
        }

        protected Shape adjustAllocation(Shape a) {
            return this.adjustAllocation(a, -1, 0);
        }

        final int calculateLineCount() {
            return this.calculateLineCount(null);
        }

        final int calculateLineCount(Rectangle alloc) {
            int nlines = 0;
            int p1 = this.getEndOffset();
            FontMetrics metrics = SJCustomView.this.getFontMetrics();
            int p0 = this.getStartOffset();
            while (p0 < p1) {
                ++nlines;
                int p = alloc == null ? SJCustomView.this.calculateBreakPosition(p0, p1) : this.UtilitiesCalculateBreakPosition(p0, p1, metrics);
                p0 = p == p0 ? p1 : p;
            }
            return nlines;
        }

        @Override
        public float getPreferredSpan(int axis) {
            switch (axis) {
                case 0: {
                    return SJCustomView.this.getWidth();
                }
                case 1: {
                    if (this.nlines == 0 || SJCustomView.this.widthChanging) {
                        this.nlines = this.calculateLineCount();
                    }
                    return this.nlines * SJCustomView.this.getFontMetrics().getHeight();
                }
            }
            throw new IllegalArgumentException("Invalid axis: " + axis);
        }

        @Override
        public void paint(Graphics g, Shape a) {
            block6: {
                try {
                    FontMetrics metrics = g.getFontMetrics();
                    Rectangle alloc = (Rectangle)a;
                    int y = alloc.y + metrics.getAscent();
                    int x = alloc.x;
                    JTextComponent host = (JTextComponent)this.getContainer();
                    Highlighter h = host.getHighlighter();
                    LayeredHighlighter dh = h instanceof LayeredHighlighter ? (LayeredHighlighter)h : null;
                    int p1 = this.getEndOffset();
                    Rectangle allocAdjusted = null;
                    int curLine = -1;
                    int curIndex = 0;
                    int lastIndex = 0;
                    int metricsHeight = metrics.getHeight();
                    int p0 = this.getStartOffset();
                    while (p0 < p1) {
                        curIndex = SJCustomView.this.getLineIndexFromPos(p0);
                        curLine = curIndex == lastIndex ? ++curLine : 0;
                        lastIndex = curIndex;
                        int p = this.UtilitiesCalculateBreakPosition(p0, p1, metrics);
                        if (dh != null) {
                            allocAdjusted = this.adjustAllocation(new Rectangle(alloc), p0, curLine).getBounds();
                            if (p == p1) {
                                dh.paintLayeredHighlights(g, p0, p - 1, allocAdjusted, host, this);
                            } else {
                                dh.paintLayeredHighlights(g, p0, p, allocAdjusted, host, this);
                            }
                        }
                        SJCustomView.this.drawLine(p0, p, g, x, y);
                        p0 = p == p0 ? p1 : p;
                        y += metricsHeight;
                    }
                }
                catch (Exception squashExceptions) {
                    if (!LogSetup.IS_LOGGING_INFO) break block6;
                    LogSetup.LOGGER.info("catch (Exception squashExceptions). ");
                    squashExceptions.printStackTrace();
                }
            }
        }

        @Override
        public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
            FontMetrics metrics = SJCustomView.this.getFontMetrics();
            Rectangle alloc = a.getBounds();
            Rectangle allocAdjusted = null;
            int awidth = a.getBounds().width;
            alloc.height = metrics.getHeight();
            alloc.width = awidth;
            int p1 = this.getEndOffset();
            int p0 = this.getStartOffset();
            int testP = b == Position.Bias.Forward ? pos : Math.max(p0, pos - 1);
            int curLine = -1;
            int lastIndex = 0;
            int curIndex = 0;
            int p = -1;
            while (p0 < p1) {
                curIndex = SJCustomView.this.getLineIndexFromPos(p0);
                curLine = curIndex == lastIndex ? ++curLine : 0;
                lastIndex = curIndex;
                p = this.UtilitiesCalculateBreakPosition(p0, p1, metrics);
                if (pos >= p0 && testP < p) {
                    allocAdjusted = this.adjustAllocation(new Rectangle(alloc), p0, curLine).getBounds();
                    SJCustomView.this.loadTextForNow(p0, pos);
                    allocAdjusted.x += Utilities.getTabbedTextWidth(SJCustomView.this.getOurLineBuffer(), metrics, allocAdjusted.x, (TabExpander)SJCustomView.this, p0);
                    allocAdjusted.y = alloc.y;
                    allocAdjusted.height = alloc.height;
                    allocAdjusted.width = 1;
                    return allocAdjusted;
                }
                if (p == p1 && pos == p1) {
                    allocAdjusted = this.adjustAllocation(new Rectangle(alloc), p0, curLine).getBounds();
                    if (pos > p0) {
                        SJCustomView.this.loadTextForNow(p0, pos);
                        allocAdjusted.x += Utilities.getTabbedTextWidth(SJCustomView.this.getOurLineBuffer(), metrics, allocAdjusted.x, (TabExpander)SJCustomView.this, p0);
                    }
                    allocAdjusted.y = alloc.y;
                    allocAdjusted.height = alloc.height;
                    allocAdjusted.width = 1;
                    return allocAdjusted;
                }
                p0 = p == p0 ? p1 : p;
                alloc.y += alloc.height;
            }
            throw new BadLocationException(null, pos);
        }

        protected int UtilitiesCalculateBreakPosition(int p0, int p1, int tabBase, FontMetrics metrics, int lineNumber) {
            boolean lineWrap;
            boolean wordWrap;
            SJTextArea textArea = (SJTextArea)this.getContainer();
            boolean bl = wordWrap = textArea.getLineWrap() && textArea.getWrapStyleWord();
            if (wordWrap) {
                return SJCustomView.this.calculateBreakPosition(p0, p1);
            }
            boolean bl2 = lineWrap = textArea.getLineWrap() && !textArea.getWrapStyleWord();
            if (!lineWrap) {
                return SJCustomView.this.calculateBreakPosition(p0, p1);
            }
            tabBase = 0;
            SJCustomView.this.loadTextForNow(p0, p1);
            int viewWidth = SJCustomView.this.getWidth();
            int tabStart = 0;
            int width = viewWidth - (tabBase - tabStart);
            int tto = Utilities.getTabbedTextOffset(SJCustomView.this.getOurLineBuffer(), metrics, tabStart, width, SJCustomView.this, p0);
            return p0 + tto;
        }

        protected int UtilitiesCalculateBreakPosition(int p0, int p1, FontMetrics metrics) {
            boolean lineWrap;
            boolean wordWrap;
            SJTextArea textArea = (SJTextArea)this.getContainer();
            boolean bl = wordWrap = textArea.getLineWrap() && textArea.getWrapStyleWord();
            if (wordWrap) {
                return SJCustomView.this.calculateBreakPosition(p0, p1);
            }
            boolean bl2 = lineWrap = textArea.getLineWrap() && !textArea.getWrapStyleWord();
            if (!lineWrap) {
                return SJCustomView.this.calculateBreakPosition(p0, p1);
            }
            SJCustomView.this.loadTextForNow(p0, p1);
            return p0 + Utilities.getTabbedTextOffset(SJCustomView.this.getOurLineBuffer(), metrics, 0, SJCustomView.this.getWidth(), SJCustomView.this, p0);
        }

        @Override
        public int viewToModel(float fx, float fy, Shape a, Position.Bias[] bias) {
            bias[0] = Position.Bias.Forward;
            Rectangle alloc = (Rectangle)a;
            int x = (int)fx;
            int y = (int)fy;
            if (y < alloc.y) {
                return this.getStartOffset();
            }
            if (y > alloc.y + alloc.height) {
                return this.getEndOffset() - 1;
            }
            FontMetrics metrics = SJCustomView.this.getFontMetrics();
            alloc.height = metrics.getHeight();
            int p1 = this.getEndOffset();
            Rectangle allocAdjusted = null;
            int curLine = -1;
            int curIndex = 0;
            int lastIndex = 0;
            int p0 = this.getStartOffset();
            while (p0 < p1) {
                curIndex = SJCustomView.this.getLineIndexFromPos(p0);
                curLine = curIndex == lastIndex ? ++curLine : 0;
                lastIndex = curIndex;
                allocAdjusted = this.adjustAllocation(new Rectangle(alloc), p0, curLine).getBounds();
                int p = this.UtilitiesCalculateBreakPosition(p0, p1, metrics);
                if (y >= alloc.y && y < alloc.y + alloc.height) {
                    if (x < allocAdjusted.x) {
                        return p0;
                    }
                    if (x > allocAdjusted.x + allocAdjusted.width) {
                        return p;
                    }
                    int n = Utilities.getTabbedTextOffset(SJCustomView.this.getOurLineBuffer(), metrics, allocAdjusted.x, x, SJCustomView.this, p0);
                    return Math.min(p0 + n, p1 - 1);
                }
                p0 = p == p0 ? p1 : p;
                alloc.y += alloc.height;
            }
            return this.getEndOffset() - 1;
        }

        @Override
        public void insertUpdate(DocumentEvent e, Shape a, ViewFactory f) {
            int n = this.calculateLineCount((Rectangle)a);
            if (this.nlines != n) {
                this.nlines = n;
                SJCustomView.this.preferenceChanged(this, false, true);
                this.getContainer().repaint();
            } else if (a != null) {
                Rectangle alloc = (Rectangle)a;
                this.getContainer().repaint(alloc.x, alloc.y, alloc.width, alloc.height);
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e, Shape a, ViewFactory f) {
            int n = this.calculateLineCount((Rectangle)a);
            if (this.nlines != n) {
                this.nlines = n;
                SJCustomView.this.preferenceChanged(this, false, true);
                this.getContainer().repaint();
            } else if (a != null) {
                Rectangle alloc = (Rectangle)a;
                this.getContainer().repaint(alloc.x, alloc.y, alloc.width, alloc.height);
            }
        }
    }
}

