/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.jfc;

import com.heirloomcomputing.ecs.exec.LogSetup;
import com.heirloomcomputing.ecs.exec.ResourceManager;
import com.heirloomcomputing.ecs.jfc.SJBevelBorder;
import com.heirloomcomputing.ecs.jfc.SJCustomDocument;
import com.heirloomcomputing.ecs.jfc.SJCustomView;
import com.heirloomcomputing.ecs.jfc.SJTextUI;
import com.heirloomcomputing.ecs.jfc.TerminalAttribute;
import java.awt.Color;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.io.Serializable;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JRootPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.plaf.TextUI;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.TextAction;

class SJTextArea
extends JTextArea
implements Serializable,
FocusListener,
TerminalAttribute {
    private static final long serialVersionUID = 1L;
    private static final String numericsOnly = "-1234567890.,+ ";
    static final int FORCE_UPPERCASE = 1;
    static final int FORCE_LOWERCASE = 2;
    static final int ERROR_STATUS = 4;
    static final int PASSWORD_FIELD = 8;
    static final int AUTO = 16;
    static final int REQUIRED = 32;
    static final int FULL = 64;
    static final int DIM = 128;
    static final int UNDERLINE = 256;
    static final int INVERSE = 512;
    static final int BLINKING = 1024;
    static final int IMPLIED_DECIMAL = 2048;
    static final int OPTIONAL = 4096;
    static final int DARKEN_WHEN_EDITING_FALSE = 8192;
    static final int PROCESSED = 16384;
    static final int TOOLTIPREGISTERED = 32768;
    static final int VALIDATE_EXPLICITLY = 65536;
    private int style = 8192;
    private int minimumLength = 0;
    private int decimalPlaces = -1;
    private int fieldOrder = 0;
    private int screenOrder = 0;
    private int datatype = 65536;
    private int errorCode = 0;
    private int dataBufferPosition = 0;
    private char passwordChar = (char)42;
    private boolean selectOnFocus = false;
    private int dataBufferLength = 0;
    private String includeChars = null;
    private String excludeChars = null;
    private String mask = null;
    private String defaultValue = "";
    private String errorMessage = null;
    private static final Color defaultErrorColor = Color.red;
    private static final Color defaultBlinkColor = Color.blue;
    private Color errorColor = defaultErrorColor;
    private Color blinkingColor = defaultBlinkColor;
    private Color errorColorBackup = null;
    private Color blinkingColorBackup = null;
    private Color backgroundProtected = null;
    private SJBevelBorder jBevelBorder = new SJBevelBorder();
    private Locale curLocale = Locale.US;
    private int alignment = 0;
    private Keymap originalKeymap;
    private static final String uiClassID = "SJTextUI";
    private int horizontalAlignment = 2;
    private boolean includeTabs = true;
    private boolean includeReturn = true;
    private int autoDecimal = -1;
    private String explicitToolTipText = null;
    private int minimumValue = 0;
    private int maximumValue = 0;

    public SJTextArea() {
        this.addFocusListener(this);
        this.setBorder(this.jBevelBorder);
        this.setWrapStyleWord(false);
        this.setLineWrap(true);
        this.originalKeymap = this.getKeymap();
    }

    public SJTextArea(int rows, int cols) {
        super(rows, cols);
        this.addFocusListener(this);
        this.setBorder(this.jBevelBorder);
        this.setWrapStyleWord(false);
        this.setLineWrap(true);
        this.originalKeymap = this.getKeymap();
    }

    public void setWordWrap(boolean state) {
        if (state) {
            this.setLineWrap(true);
        }
        this.setWrapStyleWord(state);
    }

    @Override
    protected void processComponentKeyEvent(KeyEvent event) {
        if (!this.isIncludeTabs()) {
            if (event.getKeyCode() == 9) {
                event.consume();
                return;
            }
            super.processComponentKeyEvent(event);
        }
    }

    @Override
    public boolean isManagingFocus() {
        return true;
    }

    @Override
    public void setLineWrap(boolean flag) {
        super.setLineWrap(flag);
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    private SJCustomView getView() {
        TextUI ui = this.getUI();
        if (ui instanceof SJTextUI) {
            return ((SJTextUI)ui).getView();
        }
        return null;
    }

    @Override
    public void updateUI() {
        this.setUI(new SJTextUI(false));
        this.invalidate();
    }

    @Override
    public Document getDocument() {
        Document result = super.getDocument();
        if (result == null) {
            result = new SJCustomDocument(this);
            super.setDocument(result);
        }
        return result;
    }

    @Override
    protected Document createDefaultModel() {
        return this.getDocument();
    }

    public void setHorizontalAlignment(int value) {
        if (this.horizontalAlignment == value) {
            return;
        }
        this.horizontalAlignment = value;
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setIncludeTabs(boolean state) {
        this.includeTabs = state;
    }

    public boolean isIncludeTabs() {
        return this.includeTabs;
    }

    public void delete() {
        block3: {
            try {
                int p1;
                int p0;
                if (this.isEditable() && this.isEnabled() && (p0 = Math.min(this.getCaret().getDot(), this.getCaret().getMark())) != (p1 = Math.max(this.getCaret().getDot(), this.getCaret().getMark()))) {
                    Document doc = this.getDocument();
                    doc.remove(p0, p1 - p0);
                }
            }
            catch (Exception anyException) {
                if (!LogSetup.IS_LOGGING_INFO) break block3;
                LogSetup.LOGGER.info("catch(Exception anyException). ");
                anyException.printStackTrace();
            }
        }
    }

    public void setIncludeReturn(boolean state) {
        if (this.includeReturn == state) {
            return;
        }
        this.includeReturn = state;
        if (this.includeReturn) {
            this.restoreEnterBinding(this);
        } else {
            this.removeEnterBinding(this);
        }
    }

    public boolean isIncludeReturn() {
        return this.includeReturn;
    }

    public void setAutoDecimal(int value) {
        this.autoDecimal = value;
        this.setDatatype(value);
    }

    public int getAutoDecimal() {
        return this.autoDecimal;
    }

    private final void removeEnterBinding(JTextComponent component) {
        KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
        String noEnter = "ENTER_Binding_Removed";
        Keymap map = JTextComponent.getKeymap("ENTER_Binding_Removed");
        if (map == null) {
            map = JTextComponent.addKeymap("ENTER_Binding_Removed", component.getKeymap());
            map.addActionForKeyStroke(enter, new TextAction("ENTER_Binding_Removed"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JButton button;
                    JTextComponent text = (JTextComponent)e.getSource();
                    JRootPane rp = SwingUtilities.getRootPane(text);
                    if (rp != null && (button = rp.getDefaultButton()) != null) {
                        button.doClick();
                    }
                }
            });
        }
        component.setKeymap(map);
    }

    private final void restoreEnterBinding(JTextComponent component) {
        component.setKeymap(this.originalKeymap);
    }

    boolean isStyle(int mask) {
        return (this.style & mask) != 0;
    }

    void setStyle(int mask, boolean state) {
        this.style = state ? (this.style |= mask) : (this.style &= ~mask);
    }

    void setStyle(int mask) {
        this.style |= mask;
    }

    void clearStyle(int mask) {
        this.style &= ~mask;
    }

    @Override
    public String toString() {
        int fOrder = this.getFieldOrder();
        int sOrder = this.getScreenOrder();
        String text = "(field order = " + fOrder + ", screen order = " + sOrder + ")";
        if (fOrder == 0 || sOrder == 0) {
            text = text + " [ " + super.toString() + " ]";
        }
        return text;
    }

    @Override
    public void setDataBufferLength(int n) {
        this.dataBufferLength = n;
    }

    @Override
    public int getDataBufferLength() {
        return this.dataBufferLength;
    }

    @Override
    public int getFieldOrder() {
        return this.fieldOrder;
    }

    @Override
    public void setFieldOrder(int n) {
        this.fieldOrder = n;
    }

    @Override
    public int getScreenOrder() {
        return this.screenOrder;
    }

    @Override
    public void setScreenOrder(int n) {
        this.screenOrder = n;
    }

    @Override
    public int getDataBufferPosition() {
        return this.dataBufferPosition;
    }

    @Override
    public void setDataBufferPosition(int n) {
        this.dataBufferPosition = n;
    }

    public boolean isDarkenWhenEditingFalse() {
        return this.isStyle(8192);
    }

    public void setDarkenWhenEditingFalse(boolean state) {
        this.setStyle(8192, state);
    }

    @Override
    public boolean isForceUppercase() {
        return this.isStyle(1);
    }

    @Override
    public void setForceUppercase(boolean state) {
        this.setStyle(1, state);
        if (state) {
            this.clearStyle(2);
        }
    }

    @Override
    public boolean isForceLowercase() {
        return this.isStyle(2);
    }

    @Override
    public void setForceLowercase(boolean state) {
        this.setStyle(2, state);
        if (state) {
            this.clearStyle(1);
        }
    }

    @Override
    public String getIncludeChars() {
        return this.includeChars;
    }

    @Override
    public void setIncludeChars(String s) {
        this.includeChars = s;
        this.excludeChars = null;
    }

    @Override
    public String getExcludeChars() {
        return this.excludeChars;
    }

    @Override
    public void setExcludeChars(String s) {
        this.excludeChars = s;
        this.includeChars = null;
    }

    @Override
    public boolean isNumericsOnly() {
        return this.includeChars != null ? this.includeChars.equals(numericsOnly) : false;
    }

    @Override
    public void setNumericsOnly(boolean state) {
        if (state) {
            this.setIncludeChars(numericsOnly);
        } else {
            this.setIncludeChars(null);
        }
    }

    @Override
    public int getDecimalPlaces() {
        return this.decimalPlaces;
    }

    @Override
    public void setDecimalPlaces(int n) {
        this.decimalPlaces = n;
    }

    @Override
    public boolean getImpliedDecimal() {
        return this.isStyle(2048);
    }

    @Override
    public void setImpliedDecimal(boolean state) {
        this.setStyle(2048, state);
    }

    @Override
    public int getMinimumLength() {
        return this.minimumLength;
    }

    @Override
    public void setMinimumLength(int n) {
        this.minimumLength = n;
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(String s) {
        this.defaultValue = s;
        String currentText = this.getText();
        if (currentText == null || currentText.length() == 0) {
            this.setText(this.defaultValue);
        }
    }

    @Override
    public void setOptional(boolean state) {
        this.setStyle(4096, state);
    }

    @Override
    public boolean isOptional() {
        return this.isStyle(4096);
    }

    @Override
    public void setProcessed(boolean state) {
        this.setStyle(16384, state);
    }

    @Override
    public boolean isProcessed() {
        return this.isStyle(16384);
    }

    @Override
    public void finishForm(String s) {
    }

    @Override
    public void fieldEdits(String s) {
    }

    @Override
    public void initForm(String s) {
        if (!this.isStyle(65536)) {
            this.setStyle(65536);
            this.removeEnterBinding(this);
        }
        this.reset();
        this.setError(false);
    }

    @Override
    public int getDatatype() {
        return this.datatype;
    }

    @Override
    public void setDatatype(int n) {
        this.datatype = n;
        switch (n) {
            case 65536: {
                this.setNumericsOnly(false);
                return;
            }
            case 65537: {
                this.setNumericsOnly(true);
                return;
            }
            case 65538: {
                this.setNumericsOnly(false);
                return;
            }
            case 65539: {
                this.setNumericsOnly(false);
                return;
            }
            case 65540: {
                this.setNumericsOnly(false);
                return;
            }
        }
        if (n < 0) {
            this.setImpliedDecimal(true);
            this.setDecimalPlaces(-n);
            this.setNumericsOnly(true);
        } else if (n > 0) {
            this.setImpliedDecimal(false);
            this.setDecimalPlaces(n);
            this.setNumericsOnly(true);
        } else {
            this.setDecimalPlaces(-1);
            this.setImpliedDecimal(false);
            this.setNumericsOnly(true);
        }
    }

    @Override
    public boolean isFocusable() {
        return this.isEditable() && this.isEnabled() && super.isFocusable();
    }

    public Color littledarker(Color c) {
        int b;
        int g;
        double INVFACTOR = 0.775;
        int r = (int)((double)c.getRed() * INVFACTOR);
        if (r > 255) {
            r = 255;
        }
        if ((g = (int)((double)c.getGreen() * INVFACTOR)) > 255) {
            g = 255;
        }
        if ((b = (int)((double)c.getBlue() * INVFACTOR)) > 255) {
            b = 255;
        }
        return new Color(r, g, b);
    }

    @Override
    public void setBackground(Color background) {
        super.setBackground(background);
        this.backgroundProtected = this.littledarker(background);
    }

    @Override
    public Color getBackground() {
        if (!this.isDarkenWhenEditingFalse() || this.isEditable()) {
            return super.getBackground();
        }
        if (this.backgroundProtected == null) {
            this.backgroundProtected = this.littledarker(super.getBackground());
        }
        return this.backgroundProtected;
    }

    @Override
    public void reset() {
        this.setText(this.getDefaultValue());
    }

    public String getResource(String name) {
        return ResourceManager.get(name);
    }

    public String getResource(String name, String value) {
        return ResourceManager.get(name, value);
    }

    protected String getDefaultToolTipText() {
        if (!this.isEditable()) {
            return null;
        }
        if (this.mask != null) {
            return this.mask;
        }
        switch (this.datatype) {
            case 65536: {
                return null;
            }
            case 65537: {
                return this.getResource("component.entry-field.digits", "Digits");
            }
            case 65538: {
                return this.getResource("component.entry-field.dmy", "DDMMYY");
            }
            case 65539: {
                return this.getResource("component.entry-field.mdy", "MMDDYY");
            }
            case 65540: {
                return this.getResource("component.entry-field.ymd", "YYMMDD");
            }
        }
        if (this.datatype < 0) {
            return this.getResource("component.entry-field.implied", "Implied Decimal") + " (" + -this.datatype + ")";
        }
        if (this.datatype > 0) {
            return this.getResource("component.entry-field.decimal", "Decimal") + " (" + this.datatype + ")";
        }
        return this.getResource("component.entry-field.number", "Number");
    }

    public boolean isMasked() {
        return this.mask != null;
    }

    @Override
    public String getMask() {
        return this.mask;
    }

    @Override
    public void setMask(String s) {
        this.mask = s;
        if (this.mask != null && this.mask.trim().length() == 0) {
            this.mask = null;
        }
        if (this.mask != null) {
            this.setToolTipText(s);
        } else {
            String t = this.getDefaultToolTipText();
            if (t != null) {
                this.setToolTipText(t);
            }
        }
    }

    @Override
    public String getDemaskedText() {
        String text = this.getText();
        if (this.mask == null || this.mask.length() == 0) {
            return text;
        }
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < this.mask.length(); ++i) {
            char m = this.mask.charAt(i);
            if (m != '?' && m != '#') continue;
            result.append(text.charAt(i));
        }
        return result.toString();
    }

    @Override
    public boolean getError() {
        return this.isStyle(4);
    }

    @Override
    public void setError(int code, String message) {
        if (code != 0) {
            this.setError(true, message);
        } else {
            this.setError(false, message);
        }
        this.errorCode = code;
    }

    @Override
    public void setErrorCode(int code) {
        if (code != 0) {
            this.setError(true);
        } else {
            this.setError(false);
        }
        this.errorCode = code;
    }

    @Override
    public int getErrorCode() {
        return this.errorCode;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public void setError(boolean state, String errorMessage) {
        this.setError(state);
        if (state) {
            this.errorMessage = errorMessage;
            this.setToolTipText(errorMessage);
        } else {
            this.errorMessage = null;
            String text = this.getToolTipText();
            if (text != null && text.trim().length() > 0) {
                this.setToolTipText(this.getDefaultToolTipText());
            }
        }
    }

    @Override
    public void setError(boolean state) {
        if (state == this.getError()) {
            return;
        }
        this.setStyle(4, state);
        if (state) {
            this.errorMessage = null;
            this.errorCode = 222;
            this.errorColorBackup = this.getBackground();
            this.setBackground(this.errorColor);
            Toolkit.getDefaultToolkit().beep();
        } else {
            String text;
            this.errorMessage = null;
            this.errorCode = 0;
            if (this.errorColorBackup != null) {
                this.setBackground(this.errorColorBackup);
            }
            if ((text = this.getToolTipText()) != null && text.trim().length() > 0) {
                this.setToolTipText(this.getDefaultToolTipText());
            }
        }
    }

    @Override
    public Color getErrorColor() {
        return this.errorColor;
    }

    @Override
    public void setErrorColor(Color c) {
        this.errorColor = c;
    }

    @Override
    public Color getBlinkingColor() {
        return this.blinkingColor;
    }

    @Override
    public void setBlinkingColor(Color c) {
        this.blinkingColor = c;
    }

    @Override
    public boolean getBlinking() {
        return this.isStyle(1024);
    }

    @Override
    public void setBlinking(boolean state) {
        if (state == this.getBlinking()) {
            return;
        }
        this.setStyle(1024, state);
        if (state) {
            this.blinkingColorBackup = this.getForeground();
            this.setForeground(this.blinkingColor);
        } else {
            this.setForeground(this.blinkingColorBackup);
        }
    }

    @Override
    public boolean getInverse() {
        return this.isStyle(512);
    }

    @Override
    public void setInverse(boolean state) {
        if (state == this.getInverse()) {
            return;
        }
        this.setStyle(512, state);
        Color tempColor = this.getBackground();
        this.setBackground(this.getForeground());
        this.setForeground(tempColor);
    }

    @Override
    public boolean getDim() {
        return this.isStyle(128);
    }

    @Override
    public void setDim(boolean state) {
        if (state == this.getDim()) {
            return;
        }
        this.setStyle(128, state);
        if (state) {
            Color back = this.getBackground();
            Color fore = this.getForeground();
            int r = fore.getRed() + back.getRed();
            int g = fore.getGreen() + back.getGreen();
            int b = fore.getBlue() + back.getBlue();
            g >>= 1;
            b >>= 1;
            if ((r >>= 1) > 255) {
                r = 255;
            }
            if (r < 0) {
                r = 0;
            }
            if (g > 255) {
                g = 255;
            }
            if (g < 0) {
                g = 0;
            }
            if (b > 255) {
                b = 255;
            }
            if (b < 0) {
                b = 0;
            }
            if (this.getInverse()) {
                this.setBackground(new Color(r, g, b));
            } else {
                this.setForeground(new Color(r, g, b));
            }
        } else {
            Color back = this.getBackground();
            Color fore = this.getForeground();
            int difr = fore.getRed() - back.getRed();
            int difg = fore.getGreen() - back.getGreen();
            int difb = fore.getBlue() - back.getBlue();
            int r = back.getRed() + difr * 2;
            int g = back.getGreen() + difg * 2;
            int b = back.getBlue() + difb * 2;
            if (r > 255) {
                r = 255;
            }
            if (r < 0) {
                r = 0;
            }
            if (g > 255) {
                g = 255;
            }
            if (g < 0) {
                g = 0;
            }
            if (b > 255) {
                b = 255;
            }
            if (b < 0) {
                b = 0;
            }
            if (this.getInverse()) {
                this.setBackground(new Color(r, g, b));
            } else {
                this.setForeground(new Color(r, g, b));
            }
        }
    }

    @Override
    public boolean getUnderline() {
        return this.isStyle(256);
    }

    @Override
    public void setUnderline(boolean state) {
        if (state == this.getUnderline()) {
            return;
        }
        this.setStyle(256, state);
        SJCustomView customView = this.getView();
        if (customView != null) {
            customView.setUnderline(state);
            this.invalidate();
            this.repaint();
        }
    }

    @Override
    public void setAuto(boolean state) {
        this.setStyle(16, state);
    }

    @Override
    public boolean getAuto() {
        return this.isStyle(16);
    }

    @Override
    public void setRequired(boolean state) {
        this.setStyle(32, state);
    }

    @Override
    public boolean getRequired() {
        return this.isStyle(32);
    }

    @Override
    public void setFull(boolean state) {
        this.setStyle(64, state);
    }

    @Override
    public boolean getFull() {
        return this.isStyle(64);
    }

    @Override
    public char getPasswordChar() {
        return this.passwordChar;
    }

    @Override
    public void setPasswordChar(char c) {
        this.passwordChar = c;
        SJCustomView customView = this.getView();
        if (customView != null) {
            customView.setEchoChar(this.passwordChar);
            this.invalidate();
            this.repaint();
        }
    }

    @Override
    public boolean getPasswordField() {
        return this.isStyle(8);
    }

    @Override
    public void setPasswordField(boolean state) {
        if (state == this.getPasswordField()) {
            return;
        }
        this.setStyle(8, state);
        SJCustomView customView = this.getView();
        if (customView != null) {
            if (state) {
                customView.setEchoChar(this.passwordChar);
            } else {
                customView.setEchoChar('\u0000');
            }
            this.invalidate();
            this.repaint();
        }
    }

    @Override
    public boolean getBorderRaised() {
        return this.jBevelBorder.getBorderRaised();
    }

    @Override
    public void setBorderRaised(boolean state) {
        this.jBevelBorder.setBorderRaised(state);
    }

    @Override
    public void setBorderHThickness(int n) {
        this.jBevelBorder.setBorderHThickness(n);
    }

    @Override
    public int getBorderHThickness() {
        return this.jBevelBorder.getBorderHThickness();
    }

    @Override
    public void setBorderVThickness(int n) {
        this.jBevelBorder.setBorderVThickness(n);
    }

    @Override
    public int getBorderVThickness() {
        return this.jBevelBorder.getBorderVThickness();
    }

    public void setBorderThickness(int n) {
        this.jBevelBorder.setBorderThickness(n);
    }

    public int getBorderThickness() {
        return this.jBevelBorder.getBorderThickness();
    }

    @Override
    public boolean getValidateExplicitly() {
        return this.isStyle(65536);
    }

    @Override
    public void cut() {
        if (this.getPasswordField()) {
            this.getToolkit().beep();
        } else {
            super.cut();
        }
    }

    @Override
    public void copy() {
        if (this.getPasswordField()) {
            this.getToolkit().beep();
        } else {
            super.copy();
        }
    }

    @Override
    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }

    @Override
    public int getAlignment() {
        return this.alignment;
    }

    public String getExplicitToolTipText() {
        return this.explicitToolTipText;
    }

    @Override
    public void setToolTipText(String s) {
        super.setToolTipText(s);
        this.explicitToolTipText = s;
    }

    public void setSelectOnFocus(boolean state) {
        this.selectOnFocus = state;
    }

    public boolean getSelectOnFocus() {
        return this.selectOnFocus;
    }

    @Override
    public void focusLost(FocusEvent event) {
        if (!this.isStyle(65536)) {
            this.validateData();
        }
    }

    @Override
    public void focusGained(FocusEvent event) {
        if (!this.isStyle(65536)) {
            this.setError(false);
        }
        if (this.selectOnFocus) {
            this.moveCaretPosition(0);
            this.selectAll();
            this.repaint();
        }
    }

    @Override
    public void setText(String text) {
        if (text == null) {
            text = "";
        } else {
            String curText = this.getText();
            if (text.equals(curText)) {
                return;
            }
            text = text.replace('\u0000', ' ');
        }
        super.setText(this.validateData(text));
    }

    @Override
    public void validateData() {
        super.setText(this.validateData(this.getText()));
    }

    @Override
    public void validateData(Locale locale) {
        this.curLocale = locale;
        super.setText(this.validateData(this.getText()));
    }

    public void setMinimumValue(int value) {
        this.minimumValue = value;
    }

    public int getMinimumValue() {
        return this.minimumValue;
    }

    public void setMaximumValue(int value) {
        this.maximumValue = value;
    }

    public int getMaximumValue() {
        return this.maximumValue;
    }

    private String validateData(String text) {
        return SJCustomDocument.validateData(this, text, this.curLocale, this.minimumValue, this.maximumValue);
    }
}

