/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.libcall;

import com.heirloomcomputing.ecs.api.IDatatype;
import com.heirloomcomputing.ecs.libcall.BytestreamInputFile;
import com.heirloomcomputing.ecs.libcall.BytestreamOutputFile;
import com.heirloomcomputing.ecs.libcall.BytestreamRandomAccessFile;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;

class BytestreamFileHandler {
    protected static final byte FILLER_BYTE = 32;
    public static final int ACCESS_MODE_R = 1;
    public static final int ACCESS_MODE_W = 2;
    public static final int ACCESS_MODE_RW = 3;
    public static final int DENY_RW = 0;
    public static final int DENY_W = 1;
    public static final int DENY_R = 2;
    public static final int DENY_N = 3;
    private static int handleCounter = 0;
    private static Hashtable<Integer, BytestreamFileHandler> handles = new Hashtable();
    protected int fileHandle;
    protected Object filename;
    protected int blockSize = 0;

    public static BytestreamFileHandler obtainBytestream(Object filename) {
        if (filename instanceof InputStream) {
            return new BytestreamInputFile(filename);
        }
        if (filename instanceof OutputStream) {
            return new BytestreamOutputFile(filename);
        }
        return new BytestreamRandomAccessFile(filename);
    }

    public static BytestreamFileHandler obtainBytestream(int handle) {
        return handles.get(new Integer(handle));
    }

    public static BytestreamFileHandler obtainBytestream(IDatatype handle) {
        return BytestreamFileHandler.obtainBytestream(handle.toInt());
    }

    protected BytestreamFileHandler(Object filename) {
        this.filename = filename;
        this.fileHandle = handleCounter++;
        handles.put(new Integer(this.fileHandle), this);
    }

    public int getFileHandle() {
        return this.fileHandle;
    }

    public int close(boolean closeStream) {
        handles.remove(new Integer(this.fileHandle));
        return 0;
    }

    public int createFile(int accessMode, int denyMode) {
        return 0;
    }

    public int openFile(int accessMode, int denyMode) {
        return 0;
    }

    public int readFile(long offset, int length, byte[] buffer) {
        return 0;
    }

    public int writeFile(long offset, int length, byte[] buffer) {
        return 0;
    }

    public long length() {
        return 0L;
    }

    public int flushFile() {
        return 0;
    }

    public void setBlockSize(int blockSize) {
        this.blockSize = blockSize;
    }

    protected String filenameString(Object filename) {
        if (filename == null) {
            return "";
        }
        String file2 = String.valueOf(filename);
        int index = file2.indexOf(0);
        if (index >= 0) {
            file2 = file2.substring(0, index);
        }
        file2 = file2.trim();
        file2 = file2.replace('/', File.separatorChar);
        file2 = file2.replace('\\', File.separatorChar);
        return file2;
    }

    public String toString() {
        return "[BytestreamFileHandler: filename='" + this.filename + "', handle=" + this.fileHandle + "]";
    }
}

