/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.libcall;

import com.heirloomcomputing.ecs.exec.ICallableProgramGiving;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.exec.parameterList;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class CEELOCT
implements ICallableProgramGiving {
    private static final String JCS_DATE_PARAMETER = "jcsjobdate";

    @Override
    public void call(parameterList param) {
        this.callGiving(param);
    }

    @Override
    public Object callGiving() {
        return "";
    }

    @Override
    public void call() {
    }

    @Override
    public Object callGiving(parameterList param) {
        int statusCode = 0;
        try {
            if (param.getLength() == 4) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
                GregorianCalendar lilianCalendar = new GregorianCalendar(1582, 9, 14);
                Calendar currenTime = this.getCurrentCalendar();
                LocalDateTime lilianDate = LocalDateTime.ofInstant(lilianCalendar.toInstant(), ZoneId.systemDefault());
                LocalDateTime currentDate = LocalDateTime.ofInstant(currenTime.toInstant(), ZoneId.systemDefault());
                long days = ChronoUnit.DAYS.between(lilianDate, currentDate) + 10L;
                double seconds = (double)ChronoUnit.MILLIS.between(lilianDate, currentDate) / 1000.0 + 864000.0;
                param.set(0, new Variable(days));
                param.set(1, new Variable(seconds));
                param.set(2, new Variable(sdf.format(currenTime.getTime())));
                for (Variable child : param.getVariable(3).getChildrenWithArrayElementsAsItems()) {
                    child.setConditionalStatusByName("CEE000", true);
                }
            } else {
                statusCode = 2;
            }
        }
        catch (Exception e) {
            statusCode = 1;
        }
        return new Variable(String.valueOf(statusCode));
    }

    private Calendar getCurrentCalendar() {
        Calendar today = Calendar.getInstance();
        if (RuntimeEnvironment.getGlobalParameter(JCS_DATE_PARAMETER) != null) {
            try {
                String receivedDate = RuntimeEnvironment.getGlobalParameter(JCS_DATE_PARAMETER);
                DateTimeFormatter pattern = DateTimeFormatter.ofPattern("dd/MM/yyyy");
                LocalDate localDate = LocalDate.parse(receivedDate, pattern);
                today.clear();
                today.set(localDate.getYear(), localDate.getMonthValue() - 1, localDate.getDayOfMonth());
            }
            catch (Exception e) {
                today = Calendar.getInstance();
            }
        }
        return today;
    }

    @Override
    public void cancel() {
    }

    @Override
    public String redirectCall() {
        return null;
    }
}

