/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.libcall;

import com.heirloomcomputing.ecs.api.ICallTarget2;
import com.heirloomcomputing.ecs.api.IProgramEnvironment;
import com.heirloomcomputing.ecs.exec.Binary;
import com.heirloomcomputing.ecs.exec.Context;
import com.heirloomcomputing.ecs.exec.DataPointer;
import com.heirloomcomputing.ecs.exec.Memory;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.UnbufferedMemory;
import com.heirloomcomputing.ecs.exec.Variable;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;

public class DFHXCIS
implements ICallTarget2 {
    public static final String BASICAUTHSTRING_PARAM = "_BASICAUTHSTRING";
    public static final String ENDPOINT_URL_PARAM = "_URL";
    private String applidEndpoint;
    private String applidBasicAuth;
    private String commArea;
    private Variable commAreaVar;

    @Override
    public Object call(IProgramEnvironment programenvironment, boolean[] byReference, Object[] params) {
        int rc = 0;
        try {
            HashMap<String, Object> parms = this.storeParamsAsHashmap(params);
            this.applidEndpoint = this.getApplIDEndPoint(parms);
            this.applidBasicAuth = this.getApplIDBasicAuthorization(parms);
            String progId = this.getProgId(parms);
            String encoding = Variable.getByteEncoding() != null ? Variable.getByteEncoding() : "ISO-8859-1";
            this.commArea = this.setCommArea(parms, encoding);
            byte[] responseBytes = this.invokeEndpoint(parms, progId, encoding, this.commArea);
            this.setCOBOLProgramReturnCodeMemoryStructures(parms, encoding, responseBytes);
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex.getMessage());
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex.getMessage());
        }
        if (programenvironment instanceof Context) {
            ((Context)programenvironment).setReturnCode(rc);
        }
        return rc;
    }

    private void setCOBOLProgramReturnCodeMemoryStructures(HashMap<String, Object> parms, String encoding, byte[] responseBytes) throws UnsupportedEncodingException {
        UnbufferedMemory _memory = new UnbufferedMemory(20, "dfhxcis.Wrk");
        Binary wscc_resp_OF_wscc_retcode = new Binary();
        Binary wscc_resp2_OF_wscc_retcode = new Binary();
        Variable wscc_abcode_OF_wscc_retcode = new Variable();
        Binary wscc_msglen_OF_wscc_retcode = new Binary();
        DataPointer wscc_msgptr_OF_wscc_retcode = new DataPointer();
        Variable wscc_retcode = new Variable();
        wscc_resp_OF_wscc_retcode.declare((Memory)_memory, 0, 4, "WSCC-RESP", 8, null, wscc_retcode, null, (Variable)wscc_resp2_OF_wscc_retcode, 0x4000000);
        wscc_resp2_OF_wscc_retcode.declare((Memory)_memory, 4, 4, "WSCC-RESP2", 8, null, wscc_retcode, null, wscc_abcode_OF_wscc_retcode, 0x4000000);
        wscc_abcode_OF_wscc_retcode.declare((Memory)_memory, 8, 4, "WSCC-ABCODE", null, null, wscc_retcode, null, (Variable)wscc_msglen_OF_wscc_retcode, 0);
        wscc_msglen_OF_wscc_retcode.declare((Memory)_memory, 12, 4, "WSCC-MSGLEN", 8, null, wscc_retcode, null, (Variable)wscc_msgptr_OF_wscc_retcode, 0x4000000);
        wscc_msgptr_OF_wscc_retcode.declare((Memory)_memory, 16, 4, "WSCC-MSGPTR", null, null, wscc_retcode, null, null, 0);
        wscc_retcode.declare((Memory)_memory, 0, 20, "WSCC-RETCODE", null, null, null, (Variable)wscc_resp_OF_wscc_retcode, null, 0);
        UnbufferedMemory msgmemory = new UnbufferedMemory(200, "dfhxcis.errmsg");
        Variable wscc_msg_area = new Variable();
        wscc_msg_area.declare((Memory)msgmemory, 0, 200, "WSCC-MSG-AREA", null, null, null, null, null, 0);
        int from = 20;
        byte[] msgBytes = null;
        Object obj = parms.get("RETCODE");
        Variable retCodeVar = null;
        if (obj instanceof String) {
            String retCode = (String)obj;
            retCode = new String(Arrays.copyOfRange(responseBytes, 0, 20), encoding);
        } else {
            retCodeVar = (Variable)obj;
            wscc_retcode.fromByteArray(Arrays.copyOfRange(responseBytes, 0, 20));
            if (wscc_msglen_OF_wscc_retcode.compare(0) > 0) {
                msgBytes = Arrays.copyOfRange(responseBytes, 20, 20 + wscc_msglen_OF_wscc_retcode.toInt());
                wscc_msg_area.fromByteArray(msgBytes);
                wscc_msgptr_OF_wscc_retcode.setPointerToAddress(wscc_msg_area);
                from = 20 + wscc_msglen_OF_wscc_retcode.toInt();
                retCodeVar.move(wscc_retcode);
            }
        }
        if (this.commAreaVar != null) {
            this.commAreaVar.fromByteArray(Arrays.copyOfRange(responseBytes, from, responseBytes.length - from));
        } else {
            this.commArea = new String(Arrays.copyOfRange(responseBytes, from, responseBytes.length - from), encoding);
        }
    }

    private String setCommArea(HashMap<String, Object> parms, String encoding) throws UnsupportedEncodingException {
        String commArea;
        Object obj = parms.get("COMMAREA");
        this.commAreaVar = null;
        if (obj instanceof String) {
            commArea = (String)obj;
        } else {
            this.commAreaVar = (Variable)obj;
            commArea = new String(this.commAreaVar.getBytes(), encoding);
        }
        return commArea;
    }

    private String getProgId(HashMap<String, Object> parms) {
        String progId;
        Object obj = parms.get("PROGRAM");
        if (obj instanceof String) {
            progId = (String)obj;
        } else {
            Variable v = (Variable)obj;
            progId = v.toText();
        }
        return progId;
    }

    private byte[] invokeEndpoint(HashMap<String, Object> parms, String progId, String encoding, String commArea) throws IOException {
        URL url2 = new URL(this.applidEndpoint);
        String baseAuthString = this.getApplIDBasicAuthorization(parms);
        HttpURLConnection conn = (HttpURLConnection)url2.openConnection();
        if (!baseAuthString.isEmpty()) {
            conn.setRequestProperty("Authorization", "Basic " + baseAuthString);
        }
        conn.setDoOutput(true);
        conn.setRequestProperty("Accept", "application/json");
        StringBuilder sb = new StringBuilder("progId=");
        sb.append(progId);
        sb.append("&exci=yes");
        if (parms.containsKey("SYNCONRETURN")) {
            sb.append("&syncOnReturn=yes");
        }
        sb.append("&commarea=");
        sb.append(URLEncoder.encode(commArea, encoding));
        sb.append(System.lineSeparator());
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(conn.getOutputStream()));
        out.write(sb.toString());
        out.flush();
        out.close();
        BufferedInputStream in = new BufferedInputStream(conn.getInputStream());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while (in.read(buf) != -1) {
            baos.write(buf);
        }
        byte[] responseBytes = baos.toByteArray();
        baos.close();
        in.close();
        return responseBytes;
    }

    private HashMap<String, Object> storeParamsAsHashmap(Object[] params) {
        HashMap<String, Object> parms;
        if (params == null || params.length < 1) {
            throw new RuntimeException("Invalid number of parameters");
        }
        if (params[0] instanceof HashMap) {
            parms = (HashMap<String, Object>)params[0];
        } else {
            if (params.length < 9) {
                throw new RuntimeException("Invalid number of parameters");
            }
            parms = new HashMap<String, Object>();
            parms.put("APPLID", params[0]);
            parms.put("COMMAREA", params[1]);
            parms.put("DATALENGTH", params[2]);
            parms.put("LENGTH", params[3]);
            parms.put("LINK", params[4]);
            parms.put("PROGRAM", params[5]);
            parms.put("RETCODE", params[6]);
            parms.put("SYNCONRETURN", params[7]);
            parms.put("TRANSID", params[8]);
        }
        return parms;
    }

    private String getApplIDEndPoint(HashMap<String, Object> parms) {
        String applidEndpoint;
        Object obj = parms.get("APPLID");
        if (obj instanceof String) {
            String s = (String)obj;
            applidEndpoint = DFHXCIS.findProperty(s.toUpperCase() + ENDPOINT_URL_PARAM);
        } else {
            Variable v = (Variable)obj;
            applidEndpoint = DFHXCIS.findProperty(v.toText().toUpperCase() + ENDPOINT_URL_PARAM);
        }
        return applidEndpoint;
    }

    private String getApplIDBasicAuthorization(HashMap<String, Object> parms) {
        String applidBasicAuth;
        Object obj = parms.get("APPLID");
        if (obj instanceof String) {
            String s = (String)obj;
            applidBasicAuth = DFHXCIS.findProperty(s.toUpperCase() + BASICAUTHSTRING_PARAM);
        } else {
            Variable v = (Variable)obj;
            applidBasicAuth = DFHXCIS.findProperty(v.toText().toUpperCase() + BASICAUTHSTRING_PARAM);
        }
        return applidBasicAuth;
    }

    private static String findProperty(String propKey) {
        String propValue = System.getProperty(propKey.toUpperCase() + ENDPOINT_URL_PARAM);
        if (propValue == null && (propValue = RuntimeEnvironment.getGlobalParameter(propKey)) == null) {
            try (InputStream input = DFHXCIS.class.getClassLoader().getResourceAsStream("deploy.properties");){
                Properties prop = new Properties();
                if (input == null) {
                    System.err.println("Unable to find deploy.properties on classpath");
                } else {
                    prop.load(input);
                    propValue = prop.getProperty(propKey);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return propValue;
    }
}

