/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.libcall;

import com.heirloomcomputing.ecs.exec.ICallableProgramGiving;
import com.heirloomcomputing.ecs.exec.Numeric;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.exec.VariableSubscript;
import com.heirloomcomputing.ecs.exec.parameterList;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DSNTIAR
implements ICallableProgramGiving {
    public static final Pattern SQL_CODE_PATTERN = Pattern.compile("SQLCODE:\\s*(-*\\d+)");

    @Override
    public Object callGiving() {
        return new Numeric(1);
    }

    public String extractSQLCODEFromException(SQLException sqlException) {
        try {
            Matcher m = SQL_CODE_PATTERN.matcher(sqlException.getMessage());
            if (m.find()) {
                return m.group(1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void call() {
    }

    @Override
    public Object callGiving(parameterList param) {
        this.call(param);
        return new Numeric();
    }

    @Override
    public void call(parameterList param) {
        if (param != null && param.getLength() >= 3) {
            Variable sqlcaVar = param.getVariable(0);
            Variable errmsgVar = param.getVariable(1);
            Variable maxlenVar = param.getVariable(2);
            int lineLen = maxlenVar.toInt();
            String errmsg = null;
            for (Variable e : sqlcaVar.getElementaryItems()) {
                if (e.getName().toLowerCase().contains("sqlerrmc")) {
                    errmsg = e.toDisplayString();
                    break;
                }
                if (!e.getName().toLowerCase().contains("sqlcode")) continue;
                errmsg = "SQLCODE: " + e.toDisplayString();
            }
            if (errmsgVar.getChildrenCount() == 2) {
                Variable lenVar = errmsgVar.getChild(1);
                Variable msgVar = errmsgVar.getChild(2);
                int totMaxLen = msgVar.toInt();
                if (totMaxLen > errmsgVar.getLength()) {
                    totMaxLen = errmsgVar.getLength();
                }
                if (msgVar.getMaxIndex() > 1) {
                    Variable[] lines = null;
                    Object[] objArray = msgVar.getElements();
                    if (objArray instanceof Variable[]) {
                        lines = (Variable[])objArray;
                    } else if (objArray instanceof VariableSubscript[]) {
                        lines = new Variable[objArray.length];
                        for (int i = 0; i < objArray.length; ++i) {
                            if (objArray[i] == null) continue;
                            lines[i] = ((VariableSubscript)objArray[i]).get(i);
                        }
                    }
                    if (lines.length >= 2) {
                        if (lineLen != lines[1].getLength()) {
                            lineLen = lines[1].getLength();
                        }
                        if (errmsg == null) {
                            String theMsg = "You do not have a properly structured SQLCA";
                            lines[1].move(theMsg);
                            lenVar.fromInt(theMsg.length());
                        } else {
                            int lineno = 1;
                            int actualLen = 0;
                            String linebuf = "";
                            for (String word : errmsg.split(" ")) {
                                if (lineno >= lines.length) break;
                                if (word.length() > lineLen) {
                                    int chop = lineLen + linebuf.length();
                                    linebuf = linebuf + word.substring(0, chop);
                                    lines[lineno++].move(linebuf);
                                    actualLen += lineLen;
                                    if (lineno >= lines.length) break;
                                    linebuf = word.substring(chop);
                                }
                                if (linebuf.length() + word.length() + 1 > lineLen) {
                                    lines[lineno++].move(linebuf);
                                    linebuf = word;
                                    actualLen += lineLen;
                                    continue;
                                }
                                linebuf = linebuf.length() == 0 ? linebuf + word : linebuf + " " + word;
                            }
                            if (lineno < lines.length && linebuf.length() > 0) {
                                lines[lineno++].move(linebuf);
                                linebuf = "";
                                actualLen += lineLen;
                            }
                            lenVar.fromInt(actualLen);
                        }
                    } else {
                        lenVar.fromInt(0);
                    }
                } else if (errmsg == null) {
                    String theMsg = "You do not have a properly structured SQLCA";
                    msgVar.move(theMsg);
                    lenVar.fromInt(theMsg.length());
                } else {
                    lenVar.fromInt(errmsg.length());
                    msgVar.move(errmsg);
                }
            } else {
                errmsgVar.move("0072" + errmsg);
            }
        }
    }

    @Override
    public void cancel() {
    }

    @Override
    public String redirectCall() {
        return null;
    }
}

