/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.libcall;

import com.heirloomcomputing.ecs.api.IGenericPrinter;
import com.heirloomcomputing.ecs.exec.ColorProvider;
import com.heirloomcomputing.ecs.exec.Handle;
import com.heirloomcomputing.ecs.exec.MediaImage;
import com.heirloomcomputing.ecs.exec.Numeric;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.exec.parameterList;
import com.heirloomcomputing.ecs.libcall.DefaultCall;
import com.heirloomcomputing.ecs.print.PrinterControl;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;

public class P {
    public static boolean defaultAlignment;
    public static boolean defaultMode;
    public static String defaultUnits;

    public static IGenericPrinter getPrinter() {
        return PrinterControl.getPrinter();
    }

    public static IGenericPrinter getPrinter(int n) {
        return PrinterControl.getPrinter(n);
    }

    public static Color getColor(String name) {
        return P.getColor(name, 100.0);
    }

    public static Color getColor(String name, double percentage) {
        if (name == null) {
            return null;
        }
        Color c = ColorProvider.getColor(name, percentage /= 100.0);
        if (c == null) {
            c = Color.black;
        }
        return c;
    }

    public static boolean alignment(String align) {
        if (align == null) {
            return defaultAlignment;
        }
        if ((align = align.trim()).length() > 0) {
            switch (align.charAt(0)) {
                case 'T': 
                case 't': {
                    return false;
                }
                case 'B': 
                case 'b': {
                    return true;
                }
            }
        }
        return defaultAlignment;
    }

    public static boolean mode(String mode) {
        if (mode == null) {
            return defaultMode;
        }
        if ((mode = mode.trim()).length() > 0) {
            switch (mode.charAt(0)) {
                case 'R': 
                case 'r': {
                    return true;
                }
                case 'A': 
                case 'a': {
                    return false;
                }
            }
        }
        return defaultMode;
    }

    public static int unitsX(double scalar, String units) {
        if (units == null) {
            units = defaultUnits;
        }
        return (int)(scalar * P.getPrinter().getScaleX(units));
    }

    public static double unitsByX(double scalar, String units) {
        try {
            if (units == null) {
                units = defaultUnits;
            }
            return scalar / P.getPrinter().getScaleX(units);
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public static int unitsY(double scalar, String units) {
        if (units == null) {
            units = defaultUnits;
        }
        return (int)(scalar * P.getPrinter().getScaleY(units));
    }

    public static double unitsByY(double scalar, String units) {
        try {
            if (units == null) {
                units = defaultUnits;
            }
            return scalar / P.getPrinter().getScaleY(units);
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public static double setXpos(double param) {
        P.getPrinter().setPositionX(param);
        return param;
    }

    public static double setYpos(double param) {
        P.getPrinter().setPositionY(param);
        return param;
    }

    public static double getXpos() {
        return P.getPrinter().getPositionX();
    }

    public static double getYpos() {
        return P.getPrinter().getPositionY();
    }

    public static class COMMAND
    extends DefaultCall {
        @Override
        public Object callGiving(parameterList param) {
            if (param != null) {
                return P.getPrinter().command(param.getString(0));
            }
            return " ";
        }
    }

    public static class CONNECTOR
    extends DefaultCall {
        @Override
        public Object callGiving(parameterList param) {
            if (param != null) {
                double xpos = P.getXpos();
                double ypos = P.getYpos();
                int paramSize = param.size();
                String units = null;
                if (paramSize >= 4 && !param.isOmitted(3)) {
                    units = param.getString(3);
                }
                String hunits = units;
                if (paramSize >= 10 && !param.isOmitted(9)) {
                    hunits = param.getString(9);
                }
                String vunits = hunits;
                if (paramSize >= 11 && !param.isOmitted(10)) {
                    vunits = param.getString(10);
                }
                if (paramSize >= 1 && !param.isOmitted(0)) {
                    xpos = P.unitsX(param.getDouble(0), units);
                }
                if (paramSize >= 2 && !param.isOmitted(1)) {
                    ypos = P.unitsY(param.getDouble(1), units);
                }
                String connections = "A";
                if (paramSize >= 3 && !param.isOmitted(2)) {
                    connections = param.getString(2);
                }
                if (connections == null) {
                    connections = "A";
                }
                int connection = 0;
                if ((connections = connections.toUpperCase()).indexOf(76) >= 0) {
                    connection |= 1;
                }
                if (connections.indexOf(82) >= 0) {
                    connection |= 2;
                }
                if (connections.indexOf(85) >= 0) {
                    connection |= 4;
                }
                if (connections.indexOf(68) >= 0) {
                    connection |= 8;
                }
                if (connections.indexOf(65) >= 0) {
                    connection |= 0xF;
                }
                if (connections.indexOf(72) >= 0) {
                    connection |= 3;
                }
                if (connections.indexOf(86) >= 0) {
                    connection |= 0xC;
                }
                if (connections.indexOf(124) >= 0) {
                    connection |= 0xC;
                }
                if (connections.indexOf(45) >= 0) {
                    connection |= 3;
                }
                if (connections.indexOf(43) >= 0) {
                    connection |= 0xF;
                }
                String type = null;
                if (paramSize >= 5 && !param.isOmitted(4)) {
                    type = param.getString(4);
                }
                if (type != null) {
                    if ((type = type.toUpperCase()).indexOf(83) >= 0) {
                        connection |= 0x20;
                    }
                    if (type.indexOf(49) >= 0) {
                        connection |= 0x20;
                    }
                    if (type.indexOf(68) >= 0) {
                        connection |= 0x40;
                    }
                    if (type.indexOf(50) >= 0) {
                        connection |= 0x40;
                    }
                    if (type.indexOf(84) >= 0) {
                        connection |= 0x60;
                    }
                    if (type.indexOf(82) >= 0) {
                        connection |= 0x80;
                    }
                    if (type.indexOf(72) >= 0) {
                        connection |= 0x10;
                    }
                }
                if ((connection & 0xE0) == 0) {
                    connection |= 0x20;
                }
                int hrep = 1;
                int vrep = 1;
                double hspace = P.unitsX(1.0, hunits);
                double vspace = P.unitsY(1.0, vunits);
                if (paramSize >= 6 && !param.isOmitted(5)) {
                    hrep = param.getInt(5);
                }
                if (paramSize >= 7 && !param.isOmitted(6)) {
                    vrep = param.getInt(6);
                }
                if (paramSize >= 8 && !param.isOmitted(7)) {
                    hspace = P.unitsX(param.getDouble(7), hunits);
                }
                if (paramSize >= 9 && !param.isOmitted(8)) {
                    vspace = P.unitsY(param.getDouble(8), vunits);
                }
                int effectiveConnect = 0;
                int effectiveX = (int)xpos;
                int effectiveY = (int)ypos;
                if (hrep < 1) {
                    hrep = 1;
                }
                if (vrep < 1) {
                    vrep = 1;
                }
                for (int h = 0; h < hrep; ++h) {
                    effectiveY = (int)ypos;
                    for (int v = 0; v < vrep; ++v) {
                        effectiveConnect = connection;
                        if (h < hrep - 1) {
                            effectiveConnect |= 2;
                        }
                        if (h > 0) {
                            effectiveConnect |= 1;
                        }
                        if (v < vrep - 1) {
                            effectiveConnect |= 8;
                        }
                        if (v > 0) {
                            effectiveConnect |= 4;
                        }
                        P.getPrinter().setConnector(effectiveX, effectiveY, effectiveConnect);
                        effectiveY += (int)vspace;
                    }
                    effectiveX += (int)hspace;
                }
                return new Numeric(0);
            }
            return new Numeric(-1);
        }
    }

    public static class CONNECTORTHICKNESS
    extends DefaultCall {
        @Override
        public Object callGiving(parameterList param) {
            int paramSize;
            if (param != null && (paramSize = param.size()) >= 1 && !param.isOmitted(0)) {
                String units = null;
                if (paramSize >= 2 && !param.isOmitted(1)) {
                    units = param.getString(1);
                }
                int connectorThickness = P.unitsX(param.getDouble(0), units);
                P.getPrinter().setConnectorThickness(connectorThickness);
                return new Numeric(connectorThickness);
            }
            return new Numeric(-1);
        }
    }

    public static class SETRAWMODE
    extends DefaultCall {
        @Override
        public Object callGiving(parameterList param) {
            boolean openRawMode = true;
            openRawMode = param != null && param.size() >= 1 && !param.isOmitted(0) ? param.getBoolean(0) : true;
            PrinterControl.setPrinterOpenRawMode(openRawMode);
            return new Numeric(openRawMode ? 1 : 0);
        }
    }

    public static class SETHANDLE
    extends DefaultCall {
        @Override
        public Object callGiving(parameterList param) {
            if (param != null && param.size() >= 1) {
                int printerHandle = -1;
                if (!param.isOmitted(0)) {
                    printerHandle = param.getInt(0);
                    PrinterControl.setPrinterHandle(printerHandle);
                    return new Numeric(printerHandle);
                }
            }
            return new Numeric(-1);
        }
    }

    public static class GETPRINTERINFO
    extends DefaultCall {
        @Override
        public Object callGiving(parameterList param) {
            if (param != null) {
                if (param.size() > 1) {
                    int paramSize = param.size();
                    for (int i = 0; i < paramSize; i += 2) {
                        String paramName = null;
                        if (!param.isOmitted(i)) {
                            paramName = param.getDisplayString(i);
                        }
                        boolean found = false;
                        String used = null;
                        if (paramName != null) {
                            paramName = paramName.trim().toUpperCase();
                            used = P.getPrinter().getPrinterInfo(paramName);
                            if (used != null) {
                                found = true;
                            }
                        }
                        if (found) {
                            if (used == null) {
                                param.setParameter(i + 1, "N/A");
                                continue;
                            }
                            param.setParameter(i + 1, used);
                            continue;
                        }
                        param.setParameter(i + 1, "UNKNOWN");
                    }
                }
                return new Numeric(0);
            }
            return new Numeric(-1);
        }
    }

    public static class GETHANDLE
    extends DefaultCall {
        @Override
        public Object callGiving(parameterList param) {
            int printerHandle = PrinterControl.getPrinterHandle();
            if (param != null && param.size() >= 1) {
                param.setParameter(0, printerHandle);
            }
            return new Numeric(printerHandle);
        }
    }

    public static class GETDEVICECAPABILITIES
    extends DefaultCall {
        @Override
        public Object callGiving(parameterList param) {
            if (param != null) {
                if (param.size() > 1) {
                    int paramSize = param.size();
                    for (int i = 0; i < paramSize; i += 2) {
                        boolean found = false;
                        String used = null;
                        String paramName = null;
                        if (!param.isOmitted(i)) {
                            paramName = param.getDisplayString(i);
                        }
                        if (paramName != null) {
                            paramName = paramName.trim().toUpperCase();
                            used = P.getPrinter().getDeviceCapability(paramName);
                            if (used != null) {
                                found = true;
                            }
                        }
                        if (found) {
                            if (used == null) {
                                param.setParameter(i + 1, "N/A");
                                continue;
                            }
                            param.setParameter(i + 1, used);
                            continue;
                        }
                        param.setParameter(i + 1, "UNKNOWN");
                    }
                }
                return new Numeric(0);
            }
            return new Numeric(-1);
        }
    }

    public static class DISABLEESCAPESEQUENCES
    extends DefaultCall {
        @Override
        public Object callGiving(parameterList param) {
            if (param != null && param.size() >= 1) {
                if (!param.isOmitted(0)) {
                    P.getPrinter().setEscapeSequences(!param.getBoolean(0));
                }
            } else {
                P.getPrinter().setEscapeSequences(false);
            }
            return new Numeric(0);
        }
    }

    public static class ENABLEESCAPESEQUENCES
    extends DefaultCall {
        @Override
        public Object callGiving(parameterList param) {
            if (param != null && param.size() >= 1) {
                if (!param.isOmitted(0)) {
                    P.getPrinter().setEscapeSequences(param.getBoolean(0));
                }
            } else {
                P.getPrinter().setEscapeSequences(true);
            }
            return new Numeric(0);
        }
    }

    public static class CHANGEDEVICEMODES
    extends DefaultCall {
        @Override
        public Object callGiving(parameterList param) {
            if (param != null) {
                if (param.size() > 1) {
                    int paramSize = param.size();
                    for (int i = 0; i < paramSize; i += 2) {
                        String paramName = null;
                        if (!param.isOmitted(i)) {
                            paramName = param.getDisplayString(i);
                        }
                        if (paramName == null) continue;
                        paramName = paramName.trim().toUpperCase();
                        P.getPrinter().setDeviceMode(paramName, param.getString(i + 1));
                    }
                }
                return new Numeric(0);
            }
            return new Numeric(-1);
        }
    }

    public static class SETBOTTOMMARGIN
    extends DefaultCall {
        @Override
        public Object callGiving(parameterList param) {
            if (param != null) {
                String units = null;
                if (param.size() >= 2 && !param.isOmitted(1)) {
                    units = param.getString(1);
                }
                if (!param.isOmitted(0)) {
                    P.getPrinter().setBottomMargin(P.unitsY(param.getDouble(0), units));
                }
                return new Numeric(0);
            }
            return new Numeric(-1);
        }
    }

    public static class SETTOPMARGIN
    extends DefaultCall {
        @Override
        public Object callGiving(parameterList param) {
            if (param != null) {
                String units = null;
                if (param.size() >= 2 && !param.isOmitted(1)) {
                    units = param.getString(1);
                }
                if (!param.isOmitted(0)) {
                    P.getPrinter().setTopMargin(P.unitsY(param.getDouble(0), units));
                }
                return new Numeric(0);
            }
            return new Numeric(-1);
        }
    }

    public static class SETLEFTMARGIN
    extends DefaultCall {
        @Override
        public Object callGiving(parameterList param) {
            if (param != null) {
                String units = null;
                if (param.size() >= 2 && !param.isOmitted(1)) {
                    units = param.getString(1);
                }
                if (!param.isOmitted(0)) {
                    P.getPrinter().setLeftMargin(P.unitsX(param.getDouble(0), units));
                }
                return new Numeric(0);
            }
            return new Numeric(-1);
        }
    }

    public static class SETDEFAULTUNITS
    extends DefaultCall {
        @Override
        public Object callGiving(parameterList param) {
            if (param != null) {
                String units = null;
                if (param.size() >= 1 && !param.isOmitted(0)) {
                    units = param.getString(0);
                }
                if (units != null && (units = units.trim()).length() > 0) {
                    defaultUnits = units.substring(0, 1);
                    return new Numeric(0);
                }
            }
            return new Numeric(-1);
        }
    }

    public static class SETDEFAULTMODE
    extends DefaultCall {
        @Override
        public Object callGiving(parameterList param) {
            if (param != null) {
                if (!param.isOmitted(0)) {
                    defaultMode = P.mode(param.getString(0));
                }
                return new Numeric(0);
            }
            return new Numeric(-1);
        }
    }

    public static class COMPONENTOUT
    extends DefaultCall {
        @Override
        public Object callGiving(parameterList param) {
            if (param != null) {
                boolean mode = defaultMode;
                String units = null;
                boolean box = false;
                boolean shade = false;
                double xpos = P.getXpos();
                double ypos = P.getYpos();
                double oldX = xpos;
                double oldY = ypos;
                Object graphicsObject = null;
                int paramSize = param.size();
                if (paramSize >= 5 && !param.isOmitted(4)) {
                    units = param.getString(4);
                }
                if (paramSize >= 1 && !param.isOmitted(0)) {
                    graphicsObject = param.getObject(0);
                }
                if (paramSize >= 2 && !param.isOmitted(1)) {
                    xpos = P.unitsX(param.getDouble(1), units);
                }
                if (paramSize >= 3 && !param.isOmitted(2)) {
                    ypos = P.unitsY(param.getDouble(2), units);
                }
                if (paramSize >= 4 && !param.isOmitted(3)) {
                    mode = P.mode(param.getString(3));
                }
                if (paramSize >= 6 && !param.isOmitted(5)) {
                    box = param.getBoolean(5);
                }
                if (paramSize >= 7 && !param.isOmitted(6)) {
                    shade = param.getBoolean(6);
                }
                double w = 0.0;
                double h = 0.0;
                String sizeUnits = null;
                if (paramSize >= 10 && !param.isOmitted(9)) {
                    sizeUnits = param.getString(9);
                }
                if (sizeUnits == null) {
                    sizeUnits = units;
                }
                if (paramSize >= 8 && !param.isOmitted(7)) {
                    w = P.unitsX(param.getDouble(7), sizeUnits);
                }
                if (paramSize >= 9 && !param.isOmitted(8)) {
                    h = P.unitsY(param.getDouble(8), sizeUnits);
                }
                if (mode) {
                    xpos += oldX;
                    ypos += oldY;
                }
                int x = (int)xpos;
                int y = (int)ypos;
                try {
                    if (graphicsObject instanceof Variable) {
                        graphicsObject = ((Variable)graphicsObject).getHandle();
                    }
                    if (graphicsObject instanceof Handle) {
                        graphicsObject = ((Handle)graphicsObject).getComponent();
                    }
                    int wint = (int)w;
                    int hint = (int)h;
                    if (graphicsObject instanceof Component) {
                        Component component = (Component)graphicsObject;
                        Dimension d = component.getPreferredSize();
                        if (d != null && d.width > 0 && d.height > 0) {
                            if (wint <= 0) {
                                wint = d.width;
                            }
                            if (hint <= 0) {
                                hint = d.height;
                            }
                        }
                        if (wint <= 0) {
                            wint = P.unitsX(1.0, sizeUnits);
                        }
                        if (hint <= 0) {
                            hint = P.unitsY(1.0, sizeUnits);
                        }
                        if (wint <= 1) {
                            wint = 300;
                        }
                        if (hint <= 1) {
                            hint = 300;
                        }
                        component.setSize(wint, hint);
                        boolean isVisible = component.isVisible();
                        component.setVisible(true);
                        if (shade || box) {
                            P.getPrinter().drawBox(xpos, ypos, (double)wint, (double)hint, shade, false, false);
                        }
                        P.getPrinter().draw(component, xpos, ypos, (double)wint, (double)hint);
                        if (!isVisible) {
                            component.setVisible(isVisible);
                        }
                    } else if (graphicsObject instanceof Image) {
                        Image image = (Image)graphicsObject;
                        P.getPrinter().draw(image, xpos, ypos, (double)wint, (double)hint);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                xpos = x;
                ypos = y;
            }
            return new Numeric(-1);
        }
    }

    public static class TEXTOUT
    extends DefaultCall {
        @Override
        public Object callGiving(parameterList param) {
            if (param != null) {
                String text = null;
                boolean mode = defaultMode;
                String units = null;
                boolean box = false;
                boolean shade = false;
                double xpos = P.getXpos();
                double ypos = P.getYpos();
                double oldX = xpos;
                double oldY = ypos;
                int paramSize = param.size();
                if (paramSize >= 5 && !param.isOmitted(4)) {
                    units = param.getString(4);
                }
                if (paramSize >= 1 && !param.isOmitted(0)) {
                    text = param.getString(0);
                }
                if (paramSize >= 2 && !param.isOmitted(1)) {
                    xpos = P.unitsX(param.getDouble(1), units);
                }
                if (paramSize >= 3 && !param.isOmitted(2)) {
                    ypos = P.unitsY(param.getDouble(2), units);
                }
                if (paramSize >= 4 && !param.isOmitted(3)) {
                    mode = P.mode(param.getString(3));
                }
                if (paramSize >= 6 && !param.isOmitted(5)) {
                    box = param.getBoolean(5);
                }
                if (paramSize >= 7 && !param.isOmitted(6)) {
                    shade = param.getBoolean(6);
                }
                if (mode) {
                    xpos += oldX;
                    ypos += oldY;
                }
                P.getPrinter().textOut(text, xpos, ypos, box, shade);
            }
            return new Numeric(-1);
        }
    }

    public static class SETTEXTPOSITION
    extends DefaultCall {
        @Override
        public Object callGiving(parameterList param) {
            if (param != null) {
                int paramSize = param.size();
                boolean alignment = defaultAlignment;
                if (paramSize >= 3 && !param.isOmitted(2)) {
                    alignment = P.alignment(param.getString(2));
                }
                boolean mode = defaultMode;
                if (paramSize >= 4 && !param.isOmitted(3)) {
                    mode = P.mode(param.getString(3));
                }
                String units = null;
                if (paramSize >= 5 && !param.isOmitted(4)) {
                    units = param.getString(4);
                }
                double x = P.getXpos();
                double y = P.getYpos();
                if (paramSize >= 1 && !param.isOmitted(0)) {
                    x = P.unitsX(param.getDouble(0), units);
                }
                if (paramSize >= 2 && !param.isOmitted(1)) {
                    y = P.unitsY(param.getDouble(1), units);
                }
                if (mode) {
                    x += P.getXpos();
                    y += P.getYpos();
                }
                P.getPrinter().setTextPositionX(x, alignment);
                P.getPrinter().setTextPositionY(y, alignment);
            }
            return new Numeric(-1);
        }
    }

    public static class SETPAINTMODE
    extends DefaultCall {
        @Override
        public Object callGiving(parameterList param) {
            if (param != null) {
                if (param.size() >= 1) {
                    String name = null;
                    if (!param.isOmitted(0)) {
                        name = param.getString(0);
                    }
                    if (param.size() >= 2 && !param.isOmitted(1)) {
                        P.getPrinter().setXORMode(P.getColor(name, param.getDouble(1)));
                    } else {
                        P.getPrinter().setXORMode(P.getColor(name));
                    }
                    return new Numeric(0);
                }
                P.getPrinter().setPaintMode();
            }
            return new Numeric(-1);
        }
    }

    public static class SETTEXTCOLOR
    extends DefaultCall {
        @Override
        public Object callGiving(parameterList param) {
            if (param != null && param.size() >= 1) {
                String name = null;
                if (!param.isOmitted(0)) {
                    name = param.getString(0);
                }
                Color textColor = null;
                textColor = param.size() >= 2 && !param.isOmitted(1) ? P.getColor(name, param.getDouble(1)) : P.getColor(name);
                P.getPrinter().setTextColor(textColor);
                return new Numeric(0);
            }
            return new Numeric(-1);
        }
    }

    public static class SETTABSTOPS
    extends DefaultCall {
        @Override
        public Object callGiving(parameterList param) {
            if (param != null) {
                String units = null;
                if (param.size() >= 2 && !param.isOmitted(1)) {
                    units = param.getString(1);
                }
                if (!param.isOmitted(0)) {
                    P.getPrinter().setTabStop(P.unitsX(param.getDouble(0), units));
                }
                return new Numeric(0);
            }
            return new Numeric(-1);
        }
    }

    public static class SETPITCH
    extends DefaultCall {
        @Override
        public Object callGiving(parameterList param) {
            if (param != null) {
                String type = null;
                if (param.size() >= 1 && !param.isOmitted(0)) {
                    type = param.getString(0);
                }
                if (type != null && (type = type.trim()).length() > 0) {
                    switch (type.charAt(0)) {
                        case 'N': 
                        case 'n': {
                            P.getPrinter().setPitch(0);
                            break;
                        }
                        case 'E': 
                        case 'X': 
                        case 'e': 
                        case 'x': {
                            P.getPrinter().setPitch(1);
                            break;
                        }
                        case 'C': 
                        case 'c': {
                            P.getPrinter().setPitch(2);
                            break;
                        }
                        default: {
                            return new Numeric(-1);
                        }
                    }
                    return new Numeric(0);
                }
            }
            return new Numeric(-1);
        }
    }

    public static class SETLINEEXTENDMODE
    extends DefaultCall {
        @Override
        public Object callGiving(parameterList param) {
            if (param != null) {
                String units = null;
                if (param.size() >= 2 && !param.isOmitted(1)) {
                    units = param.getString(1);
                }
                if (!param.isOmitted(0)) {
                    P.getPrinter().setLineExtend(P.unitsY(param.getDouble(0), units));
                }
                return new Numeric(0);
            }
            return new Numeric(-1);
        }
    }

    public static class SETFONT
    extends DefaultCall {
        @Override
        public Object callGiving(parameterList param) {
            Font font2 = P.getPrinter().getFont();
            boolean fontStrikeOut = P.getPrinter().isFontStrikeOut();
            boolean fontUnderline = P.getPrinter().isFontUnderline();
            String fontName = null;
            int fontHeight = -1;
            boolean fontItalic = false;
            boolean fontBold = false;
            boolean fontDoubleStrike = false;
            if (font2 != null) {
                fontName = font2.getName();
                fontItalic = font2.isItalic();
                fontBold = font2.isBold();
                fontHeight = font2.getSize();
            }
            if (param != null) {
                if (param.size() > 1) {
                    int paramSize = param.size();
                    for (int i = 0; i < paramSize; i += 2) {
                        String paramName = null;
                        if (!param.isOmitted(i)) {
                            paramName = param.getDisplayString(i);
                        }
                        if (paramName == null) continue;
                        if ((paramName = paramName.trim().toUpperCase().replace('-', '_').replace(' ', '_')).startsWith("HEIGHT")) {
                            if (param.size() < i + 2) continue;
                            fontHeight = param.getInt(i + 1);
                            continue;
                        }
                        if (paramName.startsWith("WIDTH") || paramName.startsWith("ESCAPEMENT") || paramName.startsWith("ORIENTATION") || paramName.startsWith("WEIGHT")) continue;
                        if (paramName.startsWith("ITALIC")) {
                            if (param.size() < i + 2) continue;
                            fontItalic = param.getBoolean(i + 1);
                            continue;
                        }
                        if (paramName.startsWith("BOLD")) {
                            if (param.size() < i + 2) continue;
                            fontBold = param.getBoolean(i + 1);
                            continue;
                        }
                        if (paramName.startsWith("DOUBLE_STRIKE")) {
                            if (param.size() < i + 2) continue;
                            fontDoubleStrike = param.getBoolean(i + 1);
                            continue;
                        }
                        if (paramName.startsWith("UNDERLINE")) {
                            if (param.size() < i + 2) continue;
                            fontUnderline = param.getBoolean(i + 1);
                            continue;
                        }
                        if (paramName.startsWith("STRIKE_OUT")) {
                            if (param.size() < i + 2) continue;
                            fontStrikeOut = param.getBoolean(i + 1);
                            continue;
                        }
                        if (paramName.startsWith("CHAR_SET") || paramName.startsWith("OUT_PRECISION") || paramName.startsWith("CLIP_PRECISION") || paramName.startsWith("QUALITY") || paramName.startsWith("PITCH")) continue;
                        if (paramName.startsWith("FAMILY")) {
                            if (fontName != null || param.size() < i + 2 || (fontName = param.getDisplayString(i + 1)) == null) continue;
                            fontName = fontName.trim();
                            continue;
                        }
                        if (paramName.startsWith("FACE_NAME")) {
                            if (param.size() < i + 2 || (fontName = param.getDisplayString(i + 1).trim()) == null) continue;
                            fontName = fontName.trim();
                            continue;
                        }
                        if (!paramName.startsWith("NAME") || param.size() < i + 2 || (fontName = param.getDisplayString(i + 1)) == null) continue;
                        fontName = fontName.trim();
                    }
                    int style = 0;
                    if (fontItalic) {
                        style |= 2;
                    }
                    if (fontBold) {
                        style |= 1;
                    }
                    if (fontHeight < 1) {
                        fontHeight = 12;
                    }
                    Font f = new Font(fontName, style, fontHeight);
                    P.getPrinter().setFont(f, fontUnderline, fontStrikeOut, fontDoubleStrike);
                }
                return new Numeric(0);
            }
            return new Numeric(-1);
        }
    }

    public static class SETDEFAULTALIGNMENT
    extends DefaultCall {
        @Override
        public Object callGiving(parameterList param) {
            if (param != null) {
                if (param.size() >= 1 && !param.isOmitted(0)) {
                    defaultAlignment = P.alignment(param.getString(0));
                }
                return new Numeric(0);
            }
            return new Numeric(-1);
        }
    }

    public static class GETTEXTPOSITION
    extends DefaultCall {
        @Override
        public Object callGiving(parameterList param) {
            if (param != null) {
                String align = null;
                String units = null;
                int paramSize = param.size();
                if (paramSize >= 3 && !param.isOmitted(2)) {
                    align = param.getString(2);
                }
                if (paramSize >= 4 && !param.isOmitted(3)) {
                    units = param.getString(3);
                }
                double x = P.unitsByX(P.getXpos(), units);
                double y = P.unitsByY(P.getYpos(), units);
                boolean bottom = P.alignment(align);
                x = P.getPrinter().getTextPositionX(bottom);
                y = P.getPrinter().getTextPositionY(bottom);
                if (paramSize >= 1) {
                    param.set(0, x);
                }
                if (paramSize >= 2) {
                    param.set(1, y);
                }
                return new Numeric(0);
            }
            return new Numeric(-1);
        }
    }

    public static class GETTEXTMETRICS
    extends DefaultCall {
        @Override
        public Object callGiving(parameterList param) {
            if (param != null) {
                Font font2 = P.getPrinter().getFont();
                FontMetrics fontMetrics = P.getPrinter().getFontMetrics();
                if (param.size() > 1) {
                    int paramSize = param.size();
                    for (int i = 0; i < paramSize; i += 2) {
                        String paramName = null;
                        if (!param.isOmitted(i)) {
                            paramName = param.getDisplayString(i);
                        }
                        boolean found = false;
                        String used = null;
                        if (paramName != null) {
                            int check;
                            if ((paramName = paramName.trim().toUpperCase().replace('-', '_').replace(' ', '_')).startsWith("HEIGHT")) {
                                found = true;
                                used = String.valueOf(fontMetrics.getHeight());
                            } else if (paramName.startsWith("ASCENT")) {
                                found = true;
                                used = String.valueOf(fontMetrics.getAscent());
                            } else if (paramName.startsWith("DESCENT")) {
                                found = true;
                                used = String.valueOf(fontMetrics.getDescent());
                            } else if (paramName.startsWith("MAXIMUM_ASCENT")) {
                                found = true;
                                used = String.valueOf(fontMetrics.getMaxAscent());
                            } else if (paramName.startsWith("MAXIMUM_DESCENT")) {
                                found = true;
                                used = String.valueOf(fontMetrics.getMaxDescent());
                            } else if (paramName.startsWith("LEADING")) {
                                found = true;
                                used = String.valueOf(fontMetrics.getLeading());
                            } else if (paramName.startsWith("INTERNAL_LEADING")) {
                                found = true;
                                used = String.valueOf(fontMetrics.getLeading());
                            } else if (paramName.startsWith("EXTERNAL_LEADING")) {
                                found = true;
                                used = String.valueOf(fontMetrics.getLeading());
                            } else if (paramName.startsWith("AVERAGE_CHARACTER_WIDTH")) {
                                found = true;
                                used = String.valueOf(fontMetrics.charWidth('0'));
                            } else if (paramName.startsWith("TYPICAL_CHARACTER_WIDTH")) {
                                found = true;
                                used = String.valueOf(fontMetrics.charWidth('0'));
                            } else if (paramName.startsWith("MAXIMUM_CHARACTER_WIDTH")) {
                                found = true;
                                used = String.valueOf(fontMetrics.getMaxAdvance());
                            } else if (paramName.startsWith("WEIGHT")) {
                                found = true;
                            } else if (paramName.startsWith("OVERHANG")) {
                                found = true;
                            } else if (paramName.startsWith("DIGITIZED_ASPECT_X")) {
                                found = true;
                            } else if (paramName.startsWith("DIGITIZED_ASPECT_Y")) {
                                found = true;
                            } else if (paramName.startsWith("FIRST_CHARACTER")) {
                                found = true;
                                for (check = 0; check < 65535; ++check) {
                                    if (fontMetrics.charWidth(check) <= 0) continue;
                                    used = String.valueOf(check);
                                    break;
                                }
                            } else if (paramName.startsWith("LAST_CHARACTER")) {
                                found = true;
                                for (check = 65535; check >= 0; --check) {
                                    if (fontMetrics.charWidth(check) <= 0) continue;
                                    used = String.valueOf(check);
                                    break;
                                }
                            } else if (paramName.startsWith("DEFAULT_CHARACTER")) {
                                found = true;
                            } else if (paramName.startsWith("BREAK_CHARACTER")) {
                                found = true;
                            } else if (paramName.startsWith("ITALIC")) {
                                found = true;
                                used = font2.isItalic() ? "Y" : "N";
                            } else if (paramName.startsWith("UNDERLINED")) {
                                found = true;
                                used = P.getPrinter().isFontUnderline() ? "Y" : "N";
                            } else if (paramName.startsWith("STRUCK_OUT") || paramName.startsWith("STRIKE_OUT")) {
                                found = true;
                                used = P.getPrinter().isFontStrikeOut() ? "Y" : "N";
                            } else if (paramName.startsWith("PITCH")) {
                                found = true;
                            } else if (paramName.startsWith("FAMILY")) {
                                found = true;
                            } else if (paramName.startsWith("CHARACTER SET")) {
                                found = true;
                                return "Unicode";
                            }
                        }
                        if (found) {
                            if (used == null) {
                                param.setParameter(i + 1, "N/A");
                                continue;
                            }
                            param.setParameter(i + 1, used);
                            continue;
                        }
                        param.setParameter(i + 1, "UNKNOWN");
                    }
                }
                return new Numeric(0);
            }
            return new Numeric(-1);
        }
    }

    public static class GETTEXTEXTENT
    extends DefaultCall {
        @Override
        public Object callGiving(parameterList param) {
            try {
                if (param != null) {
                    Dimension d;
                    int paramSize = param.size();
                    String text = null;
                    if (paramSize >= 1 && !param.isOmitted(0)) {
                        text = param.getDisplayString(0);
                    }
                    if ((d = P.getPrinter().getTextExtent(text)) != null) {
                        String units = null;
                        if (paramSize >= 4) {
                            units = param.getString(3);
                        }
                        double doubleWidth = P.unitsByX(d.width, units);
                        double doubleHeight = P.unitsByY(d.height, units);
                        if (paramSize >= 2 && !param.isOmitted(1)) {
                            param.set(1, doubleWidth);
                        }
                        if (paramSize >= 3 && !param.isOmitted(2)) {
                            param.set(2, doubleHeight);
                        }
                        return new Numeric(0);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return new Numeric(-1);
        }
    }

    public static class CLEARFONT
    extends DefaultCall {
        @Override
        public Object callGiving(parameterList param) {
            P.getPrinter().clearFont();
            return new Numeric(0);
        }
    }

    public static class OPEN
    extends DefaultCall {
        @Override
        public Object callGiving(parameterList param) {
            String driverName;
            String filename;
            block15: {
                filename = null;
                driverName = null;
                try {
                    if (param != null && param.size() >= 1 && !param.isOmitted(0)) {
                        filename = param.getString(0);
                    }
                    if (filename == null) {
                        filename = "";
                    }
                    driverName = filename;
                    String driverNameUpperCase = (driverName = driverName.trim()).toUpperCase();
                    int index = driverNameUpperCase.indexOf("DRIVER=");
                    if (index < 0) {
                        index = driverNameUpperCase.indexOf("DEVICE=");
                    }
                    if (index >= 0) {
                        filename = index > 0 ? driverName.substring(0, index) : "";
                        if ((index = (driverName = driverName.substring(index + 7)).indexOf(47)) >= 0) {
                            try {
                                filename = filename + driverName.substring(index + 1);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            driverName = driverName.substring(0, index);
                            break block15;
                        }
                        index = driverName.indexOf(58);
                        if (index >= 0) {
                            try {
                                filename = filename + driverName.substring(index + 1);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            driverName = driverName.substring(0, index);
                            break block15;
                        }
                        index = driverName.indexOf(59);
                        if (index < 0) break block15;
                        try {
                            filename = filename + driverName.substring(index + 1);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        driverName = driverName.substring(0, index);
                        break block15;
                    }
                    driverName = null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (PrinterControl.openPrinter(PrinterControl.isPrinterDialogEnabled(), PrinterControl.isPrinterOpenRawMode(), driverName, filename)) {
                return new Numeric(0);
            }
            return new Numeric(-1);
        }
    }

    public static class CLOSE
    extends DefaultCall {
        @Override
        public Object callGiving(parameterList param) {
            PrinterControl.closePrinter();
            return new Numeric(0);
        }
    }

    public static class EJECT
    extends DefaultCall {
        @Override
        public Object callGiving(parameterList param) {
            P.getPrinter().eject();
            return new Numeric(0);
        }
    }

    public static class SETPOSITION
    extends DefaultCall {
        @Override
        public Object callGiving(parameterList param) {
            if (param != null) {
                int paramSize = param.size();
                double xpos = P.getXpos();
                double ypos = P.getYpos();
                double oldXpos = xpos;
                double oldYpos = ypos;
                String units = null;
                if (paramSize >= 4 && !param.isOmitted(3)) {
                    units = param.getString(3);
                }
                if (paramSize >= 1 && !param.isOmitted(0)) {
                    xpos = P.unitsX(param.getDouble(0), units);
                }
                if (paramSize >= 2 && !param.isOmitted(1)) {
                    ypos = P.unitsY(param.getDouble(1), units);
                }
                boolean mode = defaultMode;
                if (paramSize >= 3 && !param.isOmitted(2)) {
                    mode = P.mode(param.getString(2));
                }
                if (mode) {
                    xpos += oldXpos;
                    ypos += oldYpos;
                }
                double fromx = xpos;
                double fromy = ypos;
                P.getPrinter().setPositionX(fromx);
                P.getPrinter().setPositionY(fromy);
                return new Numeric(0);
            }
            return new Numeric(-1);
        }
    }

    public static class SETPEN
    extends DefaultCall {
        @Override
        public Object callGiving(parameterList param) {
            if (param != null && param.size() >= 3) {
                int penStyle = 0;
                double penWidth = 1.0;
                if (!param.isOmitted(0)) {
                    penStyle = param.getInt(0);
                }
                if (!param.isOmitted(1)) {
                    penWidth = param.getDouble(1);
                }
                String name = null;
                if (!param.isOmitted(2)) {
                    name = param.getString(2);
                }
                Color penColor = null;
                penColor = param.size() >= 4 && !param.isOmitted(3) ? P.getColor(name, param.getDouble(3)) : P.getColor(name);
                P.getPrinter().setPen(penStyle, penWidth, penColor);
                return new Numeric(0);
            }
            return new Numeric(-1);
        }
    }

    public static class SETBOXSHADE
    extends DefaultCall {
        @Override
        public Object callGiving(parameterList param) {
            if (param != null && param.size() >= 1) {
                String name = null;
                if (!param.isOmitted(0)) {
                    name = param.getString(0);
                }
                Color shadeColor = null;
                shadeColor = param.size() >= 2 && !param.isOmitted(1) ? P.getColor(name, param.getDouble(1)) : P.getColor(name);
                P.getPrinter().setShadeColor(shadeColor);
                return new Numeric(0);
            }
            return new Numeric(-1);
        }
    }

    public static class MOVETO
    extends DefaultCall {
        @Override
        public Object callGiving(parameterList param) {
            if (param != null) {
                int paramSize = param.size();
                double xpos = P.getXpos();
                double ypos = P.getYpos();
                double oldXpos = xpos;
                double oldYpos = ypos;
                String units = null;
                if (paramSize >= 4 && !param.isOmitted(3)) {
                    units = param.getString(3);
                }
                if (paramSize >= 1 && !param.isOmitted(0)) {
                    xpos = P.unitsX(param.getDouble(0), units);
                }
                if (paramSize >= 2 && !param.isOmitted(1)) {
                    ypos = P.unitsY(param.getDouble(1), units);
                }
                boolean mode = defaultMode;
                if (paramSize >= 3 && !param.isOmitted(2)) {
                    mode = P.mode(param.getString(2));
                }
                if (mode) {
                    xpos += oldXpos;
                    ypos += oldYpos;
                }
                double fromx = xpos;
                double fromy = ypos;
                P.getPrinter().drawLineFrom(fromx, fromy);
                return new Numeric(0);
            }
            return new Numeric(-1);
        }
    }

    public static class LINETO
    extends DefaultCall {
        @Override
        public Object callGiving(parameterList param) {
            if (param != null) {
                int paramSize = param.size();
                double xpos = P.getXpos();
                double ypos = P.getYpos();
                double oldXpos = xpos;
                double oldYpos = ypos;
                String units = null;
                if (paramSize >= 4 && !param.isOmitted(3)) {
                    units = param.getString(3);
                }
                if (paramSize >= 1 && !param.isOmitted(0)) {
                    xpos = P.unitsX(param.getDouble(0), units);
                }
                if (paramSize >= 2 && !param.isOmitted(1)) {
                    ypos = P.unitsY(param.getDouble(1), units);
                }
                boolean mode = defaultMode;
                if (paramSize >= 3 && !param.isOmitted(2)) {
                    mode = P.mode(param.getString(2));
                }
                if (mode) {
                    xpos += oldXpos;
                    ypos += oldYpos;
                }
                double tox = xpos;
                double toy = ypos;
                P.getPrinter().drawLineTo(tox, toy);
                return new Numeric(0);
            }
            return new Numeric(-1);
        }
    }

    public static class GETPOSITION
    extends DefaultCall {
        @Override
        public Object callGiving(parameterList param) {
            if (param != null) {
                String units = null;
                if (param.size() >= 4 && !param.isOmitted(3)) {
                    units = param.getString(3);
                }
                double x = P.unitsByX(P.getPrinter().getPositionX(), units);
                double y = P.unitsByY(P.getPrinter().getPositionY(), units);
                if (param.size() >= 1) {
                    param.set(0, x);
                }
                if (param.size() >= 2) {
                    param.set(1, y);
                }
                return new Numeric(0);
            }
            return new Numeric(-1);
        }
    }

    public static class DRAWLINE
    extends DefaultCall {
        @Override
        public Object callGiving(parameterList param) {
            if (param != null) {
                int paramSize = param.size();
                double xpos = P.getXpos();
                double ypos = P.getYpos();
                double oldXpos = xpos;
                double oldYpos = ypos;
                String units = null;
                if (paramSize >= 4 && !param.isOmitted(3)) {
                    units = param.getString(3);
                }
                if (paramSize >= 1 && !param.isOmitted(0)) {
                    xpos = P.unitsX(param.getDouble(0), units);
                }
                if (paramSize >= 2 && !param.isOmitted(1)) {
                    ypos = P.unitsY(param.getDouble(1), units);
                }
                boolean mode = defaultMode;
                if (paramSize >= 3 && !param.isOmitted(2)) {
                    mode = P.mode(param.getString(2));
                }
                if (mode) {
                    xpos += oldXpos;
                    ypos += oldYpos;
                }
                double fromx = xpos;
                double fromy = ypos;
                units = null;
                if (paramSize >= 8 && !param.isOmitted(7)) {
                    units = param.getString(7);
                }
                if (paramSize >= 5 && !param.isOmitted(4)) {
                    xpos = P.unitsX(param.getDouble(4), units);
                }
                if (paramSize >= 6 && !param.isOmitted(5)) {
                    ypos = P.unitsY(param.getDouble(5), units);
                }
                mode = defaultMode;
                if (paramSize >= 7 && !param.isOmitted(6)) {
                    mode = P.mode(param.getString(6));
                }
                if (mode) {
                    xpos += oldXpos;
                    ypos += oldYpos;
                }
                double tox = xpos;
                double toy = ypos;
                P.getPrinter().drawLine(fromx, fromy, tox, toy);
                return new Numeric(0);
            }
            return new Numeric(-1);
        }
    }

    public static class DRAWOVAL
    extends DefaultCall {
        @Override
        public Object callGiving(parameterList param) {
            if (param != null) {
                int paramSize = param.size();
                double xpos = P.getXpos();
                double ypos = P.getYpos();
                double oldXpos = xpos;
                double oldYpos = ypos;
                String units = null;
                if (paramSize >= 4 && !param.isOmitted(3)) {
                    units = param.getString(3);
                }
                if (paramSize >= 1 && !param.isOmitted(0)) {
                    xpos = P.unitsX(param.getDouble(0), units);
                }
                if (paramSize >= 2 && !param.isOmitted(1)) {
                    ypos = P.unitsY(param.getDouble(1), units);
                }
                boolean mode = defaultMode;
                if (paramSize >= 3 && !param.isOmitted(2)) {
                    mode = P.mode(param.getString(2));
                }
                double sizeWidth = -1.0;
                double sizeHeight = -1.0;
                if (paramSize >= 5 && !param.isOmitted(4)) {
                    sizeWidth = param.getDouble(4);
                }
                if (paramSize >= 6 && !param.isOmitted(5)) {
                    sizeHeight = param.getDouble(5);
                }
                String sizeUnits = null;
                if (paramSize >= 7 && !param.isOmitted(6)) {
                    sizeUnits = param.getString(6);
                }
                sizeWidth = P.unitsX(sizeWidth, sizeUnits);
                sizeHeight = P.unitsY(sizeHeight, sizeUnits);
                boolean shade = false;
                if (paramSize >= 8 && !param.isOmitted(7)) {
                    shade = param.getBoolean(7);
                }
                if (mode) {
                    xpos += oldXpos;
                    ypos += oldYpos;
                }
                int type = 0;
                int sa = -1;
                int aa = -1;
                if (paramSize >= 10 && !param.isOmitted(8) && !param.isOmitted(9)) {
                    type = 2;
                    sa = param.getInt(8);
                    aa = param.getInt(9);
                }
                if (type != 2) {
                    P.getPrinter().drawOval(xpos, ypos, sizeWidth, sizeHeight, shade);
                } else {
                    P.getPrinter().drawArc(xpos, ypos, sizeWidth, sizeHeight, shade, sa, aa);
                }
                return new Numeric(0);
            }
            return new Numeric(-1);
        }
    }

    public static class DRAWBOX
    extends DefaultCall {
        @Override
        public Object callGiving(parameterList param) {
            if (param != null) {
                int paramSize = param.size();
                double xpos = P.getXpos();
                double ypos = P.getYpos();
                double oldXpos = xpos;
                double oldYpos = ypos;
                String units = null;
                if (paramSize >= 4 && !param.isOmitted(3)) {
                    units = param.getString(3);
                }
                if (paramSize >= 1 && !param.isOmitted(0)) {
                    xpos = P.unitsX(param.getDouble(0), units);
                }
                if (paramSize >= 2 && !param.isOmitted(1)) {
                    ypos = P.unitsY(param.getDouble(1), units);
                }
                boolean mode = defaultMode;
                if (paramSize >= 3 && !param.isOmitted(2)) {
                    mode = P.mode(param.getString(2));
                }
                double sizeWidth = -1.0;
                double sizeHeight = -1.0;
                if (paramSize >= 5 && !param.isOmitted(4)) {
                    sizeWidth = param.getDouble(4);
                }
                if (paramSize >= 6 && !param.isOmitted(5)) {
                    sizeHeight = param.getDouble(5);
                }
                String sizeUnits = null;
                if (paramSize >= 7 && !param.isOmitted(6)) {
                    sizeUnits = param.getString(6);
                }
                sizeWidth = P.unitsX(sizeWidth, sizeUnits);
                sizeHeight = P.unitsY(sizeHeight, sizeUnits);
                boolean shade = false;
                if (paramSize >= 8 && !param.isOmitted(7)) {
                    shade = param.getBoolean(7);
                }
                if (mode) {
                    xpos += oldXpos;
                    ypos += oldYpos;
                }
                int type = 0;
                boolean raised = false;
                int sa = -1;
                int aa = -1;
                boolean _3d = false;
                if (paramSize >= 9) {
                    if (paramSize >= 10) {
                        if (!param.isOmitted(8) && !param.isOmitted(9)) {
                            type = 2;
                            sa = param.getInt(8);
                            aa = param.getInt(9);
                        }
                    } else if (!param.isOmitted(8)) {
                        _3d = true;
                        type = 1;
                        raised = param.getBoolean(8);
                    }
                }
                switch (type) {
                    case 0: 
                    case 1: {
                        P.getPrinter().drawBox(xpos, ypos, sizeWidth, sizeHeight, shade, _3d, raised);
                        break;
                    }
                    case 2: {
                        P.getPrinter().drawBox(xpos, ypos, sizeWidth, sizeHeight, shade, sa, aa);
                    }
                }
                return new Numeric(0);
            }
            return new Numeric(-1);
        }
    }

    public static class DRAWBITMAP
    extends DefaultCall {
        @Override
        public Object callGiving(parameterList param) {
            if (param != null) {
                int paramSize = param.size();
                String filename = null;
                if (paramSize >= 1 && !param.isOmitted(0)) {
                    filename = param.getString(0);
                }
                if (filename != null) {
                    filename = filename.trim();
                }
                double xpos = P.getXpos();
                double ypos = P.getYpos();
                double oldXpos = xpos;
                double oldYpos = ypos;
                String units = null;
                if (paramSize >= 5 && !param.isOmitted(4)) {
                    units = param.getString(4);
                }
                if (paramSize >= 2 && !param.isOmitted(1)) {
                    xpos = P.unitsX(param.getDouble(1), units);
                }
                if (paramSize >= 3 && !param.isOmitted(2)) {
                    ypos = P.unitsY(param.getDouble(2), units);
                }
                double sizeWidth = -1.0;
                double sizeHeight = -1.0;
                if (paramSize >= 6 && !param.isOmitted(5)) {
                    sizeWidth = param.getDouble(5);
                }
                if (paramSize >= 7 && !param.isOmitted(6)) {
                    sizeHeight = param.getDouble(6);
                }
                String sizeUnits = null;
                if (paramSize >= 8 && !param.isOmitted(7)) {
                    sizeUnits = param.getString(7);
                }
                if (sizeWidth >= 0.0) {
                    sizeWidth = P.unitsX(sizeWidth, sizeUnits);
                }
                if (sizeHeight >= 0.0) {
                    sizeHeight = P.unitsY(sizeHeight, sizeUnits);
                }
                boolean mode = defaultMode;
                if (paramSize >= 4 && !param.isOmitted(3)) {
                    mode = P.mode(param.getString(3));
                }
                if (mode) {
                    xpos += oldXpos;
                    ypos += oldYpos;
                }
                Image image = MediaImage.getImage(filename, P.getPrinter().getComponent());
                P.getPrinter().draw(image, xpos, ypos, sizeWidth, sizeHeight);
                return new Numeric(0);
            }
            return new Numeric(-1);
        }
    }

    public static class SETDIALOG
    extends DefaultCall {
        @Override
        public Object callGiving(parameterList param) {
            if (param != null) {
                if (param.size() > 1) {
                    int paramSize = param.size();
                    for (int i = 0; i < paramSize; i += 2) {
                        String paramName = null;
                        if (!param.isOmitted(i)) {
                            paramName = param.getDisplayString(i);
                        }
                        if (paramName == null) continue;
                        paramName = paramName.trim().toUpperCase();
                        if (param.size() < i + 2) continue;
                        P.getPrinter().setDialog(paramName, param.getString(i + 1));
                    }
                }
                return new Numeric(0);
            }
            return new Numeric(-1);
        }
    }

    public static class GETDIALOG
    extends DefaultCall {
        @Override
        public Object callGiving(parameterList param) {
            if (param != null) {
                if (param.size() > 1) {
                    int paramSize = param.size();
                    for (int i = 0; i < paramSize; i += 2) {
                        String paramName = null;
                        if (!param.isOmitted(i)) {
                            paramName = param.getDisplayString(i);
                        }
                        boolean found = false;
                        String used = null;
                        if (paramName != null) {
                            paramName = paramName.trim().toUpperCase();
                            used = P.getPrinter().getDialog(paramName);
                            if (used != null) {
                                found = true;
                            }
                        }
                        if (found) {
                            if (used == null) {
                                param.setParameter(i + 1, "N/A");
                                continue;
                            }
                            param.setParameter(i + 1, used);
                            continue;
                        }
                        param.setParameter(i + 1, "UNKNOWN");
                    }
                }
                return new Numeric(0);
            }
            return new Numeric(-1);
        }
    }

    public static class SETDRIVER
    extends DefaultCall {
        @Override
        public Object callGiving(parameterList param) {
            if (param != null) {
                String driverName = param.getDisplayString(0);
                if (driverName != null) {
                    driverName = driverName.trim();
                }
                PrinterControl.setDefaultDriverName(driverName);
            } else {
                PrinterControl.setDefaultDriverName(null);
            }
            return new Numeric(0);
        }
    }

    public static class DISABLEDIALOG
    extends DefaultCall {
        @Override
        public Object callGiving(parameterList param) {
            if (param != null) {
                PrinterControl.setPrinterDialogEnabled(!param.getBoolean(0));
            } else {
                PrinterControl.setPrinterDialogEnabled(false);
            }
            return new Numeric(0);
        }
    }

    public static class ENABLEDIALOG
    extends DefaultCall {
        @Override
        public Object callGiving(parameterList param) {
            if (param != null) {
                PrinterControl.setPrinterDialogEnabled(param.getBoolean(0));
            } else {
                PrinterControl.setPrinterDialogEnabled(true);
            }
            return new Numeric(0);
        }
    }

    public static class DISPLAYDIALOG
    extends DefaultCall {
        @Override
        public Object callGiving(parameterList param) {
            if (param != null) {
                try {
                    return new Numeric(P.getPrinter().displayDialog() ? 0 : 1);
                }
                catch (Throwable t) {
                    return new Numeric(2);
                }
            }
            return new Numeric(-1);
        }
    }

    public static class CLEARDIALOG
    extends DefaultCall {
        @Override
        public Object callGiving(parameterList param) {
            if (param != null) {
                P.getPrinter().clearDialog();
                return new Numeric(0);
            }
            return new Numeric(-1);
        }
    }
}

