/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.libcall;

import com.heirloomcomputing.ecs.exec.ICallableProgramGiving;
import com.heirloomcomputing.ecs.exec.Numeric;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.exec.parameterList;
import com.heirloomcomputing.ecs.xio.RedisUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import java.util.Properties;

public class TBCALL
implements ICallableProgramGiving {
    static final String HOST;
    static final String PORT;
    static final boolean LOG_ENABLED;
    static final RedisUtil REDIS_UTIL;
    List<String> resultsFromFetchKey = null;
    String resTableName = "";
    int fetchKeyIndex = -1;
    Variable firstKey = null;

    @Override
    public Object callGiving() {
        return new Numeric(1);
    }

    @Override
    public void call() {
    }

    @Override
    public Object callGiving(parameterList param) {
        this.call(param);
        return new Numeric();
    }

    @Override
    public void call(parameterList param) {
        Variable commandArea = null;
        Variable parm2 = null;
        Variable ioArea = null;
        Variable keyInfo = null;
        Object tableList = null;
        Variable defineArea = null;
        Variable statusArea = null;
        Variable baseName = null;
        Variable altDefArea = null;
        if (param != null) {
            List<String> resultList;
            String key;
            if (param.getLength() == 1) {
                commandArea = param.getVariable(0);
            } else if (param.getLength() == 2) {
                commandArea = param.getVariable(0);
                parm2 = param.getVariable(1);
            } else if (param.getLength() == 3) {
                commandArea = param.getVariable(0);
                ioArea = param.getVariable(1);
                keyInfo = param.getVariable(2);
            }
            Variable commandCode = null;
            Variable tableName = null;
            Variable tableFound = null;
            Variable errorCode = null;
            Variable count = null;
            if (commandArea != null) {
                commandCode = commandArea.getChild();
                tableName = commandCode.getSibling();
                tableFound = tableName.getSibling();
                errorCode = commandArea.getChild(4);
                count = commandArea.getChild(5);
            }
            String commandCodeStr = null;
            commandCodeStr = commandCode != null ? commandCode.toText() : "";
            if (parm2 != null) {
                switch (commandCodeStr) {
                    case "CS": 
                    case "LS": {
                        statusArea = parm2;
                        break;
                    }
                    case "SK": 
                    case "FK": 
                    case "FC": 
                    case "FG": 
                    case "GF": 
                    case "GL": 
                    case "GN": 
                    case "GP": {
                        ioArea = parm2;
                        break;
                    }
                    case "GD": {
                        defineArea = parm2;
                        if (defineArea == null) break;
                        defineArea.getChild(1).fromText("S");
                        defineArea.getChild(24).fromText("R");
                        defineArea.getChild(25).fromText("N");
                        tableFound.fromText("Y");
                        break;
                    }
                    case "CA": {
                        baseName = parm2;
                        altDefArea = keyInfo;
                        break;
                    }
                    case "IA": 
                    case "OR": {
                        baseName = parm2;
                    }
                }
            }
            if ("FG".equalsIgnoreCase(commandCodeStr)) {
                if (this.firstKey != null && keyInfo != null) {
                    if (!this.firstKey.toText().equals(keyInfo.toText())) {
                        this.firstKey.fromText(keyInfo.toText());
                    } else {
                        System.out.println("Fetch NEXT Generic");
                        commandCodeStr = "GN";
                    }
                } else {
                    this.firstKey = this.firstKey == null && keyInfo != null ? keyInfo : null;
                }
            } else {
                this.firstKey = null;
            }
            String string2 = key = keyInfo != null ? keyInfo.toText().replaceAll("\\s+$", "") : null;
            if (key != null) {
                key = key.replaceAll("^(\\s+)(\\*)$", "$2");
            }
            if (!commandCodeStr.contains("LS") && !commandCodeStr.contains("CS") && tableName.toText().trim().length() == 0) {
                TBCALL.log("** TableName is blank");
            }
            List<String> list = resultList = this.resultsFromFetchKey != null ? this.resultsFromFetchKey : null;
            if (tableName.toText().trim().length() != 0 && resultList != null && this.resTableName.compareTo(tableName.toText()) != 0) {
                resultList.clear();
                this.resTableName = tableName.toText();
            }
            switch (commandCodeStr) {
                case "OR": {
                    System.out.println("Open For Read");
                    break;
                }
                case "CL": {
                    System.out.println("Close Table");
                    break;
                }
                case "RL": {
                    System.out.println("Release Table");
                    break;
                }
                case "ST": {
                    System.out.println("Store Table");
                    break;
                }
                case "MT": {
                    System.out.println("Empty Table");
                    break;
                }
                case "XT": {
                    System.out.println("Eliminate Table");
                    break;
                }
                case "DT": {
                    System.out.println("Define Table");
                    break;
                }
                case "OW": {
                    System.out.println("Open For Write");
                    break;
                }
                case "VS": {
                    System.out.println("Virtual System");
                    break;
                }
                case "LS": {
                    break;
                }
                case "FK": {
                    this.fetchByKey(ioArea, key, tableName, tableFound, errorCode, count);
                    break;
                }
                case "FG": {
                    this.fetchByGeneric(ioArea, tableName, tableFound, errorCode, count, key, resultList);
                    break;
                }
                case "GF": {
                    this.getFirst(ioArea, tableFound, errorCode);
                    break;
                }
                case "GL": {
                    this.getLast(ioArea, tableFound, errorCode);
                    break;
                }
                case "GN": {
                    this.getNext(ioArea, tableFound, errorCode, count);
                    break;
                }
                case "GP": {
                    this.getPrevious(ioArea, tableFound, errorCode, count);
                }
            }
        }
    }

    private void fetchByKey(Variable ioArea, String keyInfo, Variable tableName, Variable tableFound, Variable errorCode, Variable count) {
        String fetchedRecordByKey = REDIS_UTIL.fetchByKey(tableName.toText().trim(), keyInfo);
        if (Objects.nonNull(fetchedRecordByKey)) {
            TBCALL.log("FK: Record found by key(" + fetchedRecordByKey + ")");
            tableFound.fromText("Y");
            errorCode.fromInt(0);
            count.fromInt(1);
            ioArea.fromText(fetchedRecordByKey);
        } else {
            TBCALL.log("FK: No record found!");
            tableFound.fromText("N");
            count.fromInt(0);
            errorCode.fromInt(100);
        }
    }

    private void fetchByGeneric(Variable ioArea, Variable tableName, Variable tableFound, Variable errorCode, Variable count, String key, List<String> resList) {
        if (resList != null && !resList.isEmpty()) {
            this.resultsFromFetchKey = resList;
        } else {
            this.resultsFromFetchKey = REDIS_UTIL.getFetchByGeneric(tableName.toText().trim(), key);
            this.fetchKeyIndex = 0;
        }
        if (Objects.nonNull(this.resultsFromFetchKey) && !this.resultsFromFetchKey.isEmpty()) {
            TBCALL.log("FG: Records found. size(" + this.resultsFromFetchKey.size() + ")");
            TBCALL.log("FG: Records index: " + String.valueOf(this.fetchKeyIndex));
            if (this.fetchKeyIndex >= this.resultsFromFetchKey.size()) {
                this.fetchKeyIndex = this.resultsFromFetchKey.size() - 1;
                TBCALL.log("FG: Ran out of records");
                tableFound.fromText("N");
                count.fromInt(this.resultsFromFetchKey.size());
                return;
            }
            tableFound.fromText("Y");
            errorCode.fromInt(0);
            List<String> keyList = this.resultsFromFetchKey;
            String nextRecord = REDIS_UTIL.fetchByKey(keyList.get(this.fetchKeyIndex));
            count.fromInt(this.fetchKeyIndex + 1);
            TBCALL.log("FG: Fetch By Generic record (" + nextRecord + ")");
            ++this.fetchKeyIndex;
            ioArea.fromText(nextRecord);
        } else {
            TBCALL.log("FG: No record found!");
            tableFound.fromText("N");
            count.fromInt(0);
            errorCode.fromInt(100);
        }
    }

    private void getPrevious(Variable ioArea, Variable tableFound, Variable errorCode, Variable count) {
        ioArea.fromText(null);
        if (this.resultsFromFetchKey != null && this.resultsFromFetchKey != null && !this.resultsFromFetchKey.isEmpty()) {
            this.fetchKeyIndex = this.fetchKeyIndex - 1 < 0 ? 0 : this.fetchKeyIndex - 1;
            String prevKey = this.resultsFromFetchKey.get(this.fetchKeyIndex);
            String prevRecord = REDIS_UTIL.fetchByKey(prevKey);
            TBCALL.log("GP: Get Previous prevKey(" + prevKey + ") prevRecord(" + prevRecord + ")");
            count.fromInt(this.fetchKeyIndex - 1);
            tableFound.fromText("Y");
            errorCode.fromInt(0);
            ioArea.fromText(prevRecord);
        } else {
            TBCALL.log("GP: No record found!");
        }
    }

    private void getNext(Variable ioArea, Variable tableFound, Variable errorCode, Variable count) {
        List<String> resultList;
        ioArea.fromText(null);
        List<String> list = resultList = this.resultsFromFetchKey != null ? this.resultsFromFetchKey : null;
        if (this.resultsFromFetchKey != null && this.resultsFromFetchKey != null && !this.resultsFromFetchKey.isEmpty()) {
            ++this.fetchKeyIndex;
            if (this.fetchKeyIndex >= this.resultsFromFetchKey.size()) {
                this.fetchKeyIndex = this.resultsFromFetchKey.size() - 1;
                TBCALL.log("GN: Ran out of records");
                tableFound.fromText("N");
                count.fromInt(this.resultsFromFetchKey.size());
                return;
            }
            String nextKey = this.resultsFromFetchKey.get(this.fetchKeyIndex);
            String nextRecord = REDIS_UTIL.fetchByKey(nextKey);
            TBCALL.log("GN: Get Next nextKey(" + nextKey + ") nextRecord(" + nextRecord + ")");
            count.fromInt(this.fetchKeyIndex + 1);
            tableFound.fromText("Y");
            errorCode.fromInt(0);
            ioArea.fromText(nextRecord);
        } else {
            TBCALL.log("GN: No record found!");
            tableFound.fromText("N");
            count.fromInt(0);
        }
    }

    private void getFirst(Variable ioArea, Variable tableFound, Variable errorCode) {
        ioArea.fromText(null);
        tableFound.fromText("N");
        if (this.resultsFromFetchKey != null && this.resultsFromFetchKey != null && !this.resultsFromFetchKey.isEmpty()) {
            RedisUtil redisUtil = new RedisUtil(HOST, Integer.parseInt(PORT), LOG_ENABLED);
            String firstKey = this.resultsFromFetchKey.get(0);
            String firstRecord = REDIS_UTIL.fetchByKey(firstKey);
            TBCALL.log("GF: Get First firstKey(" + firstKey + ") firstRecord(" + firstRecord + ")");
            tableFound.fromText("Y");
            errorCode.fromInt(0);
            ioArea.fromText(firstRecord);
        } else {
            TBCALL.log("GF: No record found!");
        }
    }

    private void getLast(Variable ioArea, Variable tableFound, Variable errorCode) {
        List<String> resultList;
        ioArea.fromText(null);
        List<String> list = resultList = this.resultsFromFetchKey != null ? this.resultsFromFetchKey : null;
        if (this.resultsFromFetchKey != null && this.resultsFromFetchKey != null && !this.resultsFromFetchKey.isEmpty()) {
            RedisUtil redisUtil = new RedisUtil(HOST, Integer.parseInt(PORT), LOG_ENABLED);
            String lastKey = this.resultsFromFetchKey.get(resultList.size() - 1);
            String lastRecord = redisUtil.fetchByKey(lastKey);
            TBCALL.log("GL: Get Last lastKey(" + lastKey + ") lastRecord(" + lastRecord + ")");
            tableFound.fromText("Y");
            errorCode.fromInt(0);
            ioArea.fromText(lastRecord);
        } else {
            TBCALL.log("GL: No record found!");
        }
    }

    @Override
    public void cancel() {
    }

    @Override
    public String redirectCall() {
        return null;
    }

    private static void log(String message) {
        if (LOG_ENABLED) {
            System.out.println(message);
        }
    }

    private static String findProperty(String propKey) {
        String propValue = System.getProperty(propKey);
        if (propValue == null && (propValue = RuntimeEnvironment.getGlobalParameter(propKey)) == null) {
            try (InputStream input = TBCALL.class.getClassLoader().getResourceAsStream("deploy.properties");){
                Properties prop = new Properties();
                if (input == null) {
                    System.err.println("Unable to find deploy.properties on classpath");
                } else {
                    prop.load(input);
                    propValue = prop.getProperty(propKey);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return propValue;
    }

    static {
        String host = TBCALL.findProperty("tblbase.host");
        HOST = host != null ? host : "redis://localhost";
        String port = TBCALL.findProperty("tblbase.port");
        PORT = port != null ? port : "6379";
        String logredis = TBCALL.findProperty("logredis");
        LOG_ENABLED = logredis != null ? Boolean.valueOf(logredis) : false;
        REDIS_UTIL = new RedisUtil(HOST, Integer.parseInt(PORT), LOG_ENABLED);
    }
}

