/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.mqi;

import com.heirloomcomputing.ecs.mqi.api.MQIConnectOptions;
import com.heirloomcomputing.ecs.mqi.api.MQIConnection;
import com.heirloomcomputing.ecs.mqi.api.MQIConnectionManager;
import com.heirloomcomputing.ecs.mqi.api.MQIResponse;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;

public abstract class MQIConnectionManagerAbstract
implements MQIConnectionManager {
    public static final String MQI_PROPERTIES_FILE = "heirloomcomputing_mqi";
    private static final Properties configProperties = new Properties();
    private static final MQIConnectionManager instanceConnectionManager = MQIConnectionManagerAbstract.initConnectionManager();
    private final Map<Integer, MQIConnection> existingConnectionsCache = new Hashtable<Integer, MQIConnection>();
    private int connectionHandle = -1;
    private boolean logging = false;
    protected final MQIResponse response = new MQIResponse(0, 0);

    private static final boolean init() {
        try {
            ResourceBundle resourcebundle = ResourceBundle.getBundle(MQI_PROPERTIES_FILE);
            if (resourcebundle != null) {
                Enumeration<String> enumeration = resourcebundle.getKeys();
                while (enumeration.hasMoreElements()) {
                    String propKey = enumeration.nextElement().toString();
                    String propVal = resourcebundle.getString(propKey);
                    configProperties.put(propKey, propVal);
                }
                if (MQIConnectionManagerAbstract.getPropValueBoolean("com.heirloomcomputing.ecs.mqi.api.MQIConnectionManager.trace")) {
                    MQIConnectionManagerAbstract.logError("Found configuration properties file 'heirloomcomputing_mqi':");
                    MQIConnectionManagerAbstract.logError("" + configProperties);
                }
            } else {
                MQIConnectionManagerAbstract.logError("Could not find configuration properties file 'heirloomcomputing_mqi.The propeties are not loaded");
            }
        }
        catch (MissingResourceException missingresourceexception) {
            MQIConnectionManagerAbstract.logError("Could not find configuration properties file 'heirloomcomputing_mqi.The propeties are not loaded");
            return false;
        }
        return true;
    }

    private final boolean isLogging() {
        return this.logging;
    }

    private static void logException(Throwable throwable) {
        System.err.println("ConnectionManager: ");
        throwable.printStackTrace(System.err);
    }

    private static void logError(String s1) {
        System.err.println("ConnectionManager: " + s1);
    }

    private static MQIConnectionManager initConnectionManager() {
        block6: {
            boolean doLog;
            MQIConnectionManagerAbstract.init();
            String conManagerClassName = MQIConnectionManagerAbstract.getPropValue("com.heirloomcomputing.ecs.mqi.api.MQIConnectionManager");
            if (conManagerClassName == null) {
                conManagerClassName = "com.heirloomcomputing.ecs.mqi.jms.JMSConnectionManager";
            }
            if (doLog = MQIConnectionManagerAbstract.getPropValueBoolean("com.heirloomcomputing.ecs.mqi.api.MQIConnectionManager.trace")) {
                MQIConnectionManagerAbstract.logError("Attempting to initialize connection manager implementation '" + conManagerClassName + "'");
            }
            try {
                Class<?> conManagerClass = Class.forName(conManagerClassName);
                if (conManagerClass != null) {
                    MQIConnectionManager conManagerInstance = (MQIConnectionManager)conManagerClass.newInstance();
                    if (MQIConnectionManagerAbstract.class.isInstance(conManagerInstance)) {
                        ((MQIConnectionManagerAbstract)conManagerInstance).logging = doLog;
                    }
                    return conManagerInstance;
                }
            }
            catch (Throwable throwable) {
                if (!doLog) break block6;
                MQIConnectionManagerAbstract.logError("An exception occurred, e=");
                MQIConnectionManagerAbstract.logException(throwable);
            }
        }
        return null;
    }

    public static String getQueueManager() {
        return MQIConnectionManagerAbstract.getPropValue("queueManager");
    }

    protected static String getPropValue(String s1) {
        return (String)configProperties.get(s1);
    }

    protected static boolean getPropValueBoolean(String s1) {
        String s2 = MQIConnectionManagerAbstract.getPropValue(s1);
        if (s2 == null || s2.length() == 0) {
            return false;
        }
        s2 = s2.trim();
        int i = s2.length();
        switch (i) {
            case 1: {
                char c1 = Character.toUpperCase(s2.charAt(0));
                return c1 == 'Y' || c1 == 'T';
            }
            case 2: {
                return !"no".equalsIgnoreCase(s2);
            }
            case 3: {
                return "yes".equalsIgnoreCase(s2);
            }
            case 4: {
                return "true".equalsIgnoreCase(s2);
            }
            case 5: {
                return !"false".equalsIgnoreCase(s2);
            }
        }
        return false;
    }

    protected static Properties getConfigProperties() {
        return configProperties;
    }

    private void c(int i) {
        this.response.assign(2, i);
    }

    private void addConnectionToCache(int i, MQIConnection obj) {
        this.existingConnectionsCache.put(new Integer(i), obj);
    }

    private MQIConnection retrieveExistingConnectionFromCache(int i) {
        return this.existingConnectionsCache.get(new Integer(i));
    }

    private int nextHandle() {
        if (this.connectionHandle > 0x7FFFFFFE) {
            this.connectionHandle = -1;
        }
        return ++this.connectionHandle;
    }

    private MQIConnection createConnection(String queueManagerName, MQIConnectOptions u, Object obj) {
        int conHandle = this.nextHandle();
        MQIConnection connection = this.mqConnect(queueManagerName, u, obj, conHandle);
        if (connection == null) {
            if (this.isLogging()) {
                MQIConnectionManagerAbstract.logError("Unable to create MQIConnection object");
            }
            return null;
        }
        this.addConnectionToCache(conHandle, connection);
        if (this.isLogging()) {
            MQIConnectionManagerAbstract.logError("Returning MQIConnection object: " + connection);
        }
        return connection;
    }

    protected void removeConnectionFromCache(int i) {
        this.existingConnectionsCache.remove(new Integer(i));
    }

    @Override
    public MQIConnection mqConnect(Object obj) {
        this.response.assign(0, 0);
        if (this.isLogging()) {
            MQIConnectionManagerAbstract.logError("Called mqConnect(" + obj + ")");
        }
        if (obj == null) {
            if (this.isLogging()) {
                MQIConnectionManagerAbstract.logError("Connection parameter passed is null, returning MQRC_ADAPTER_CONN_LOAD_ERROR");
            }
            this.c(2129);
            return null;
        }
        try {
            return this.createConnection(null, null, obj);
        }
        catch (Throwable throwable) {
            if (this.isLogging()) {
                MQIConnectionManagerAbstract.logError("An exception occurred, e=");
                MQIConnectionManagerAbstract.logException(throwable);
            }
            this.response.assign(2, 2273);
            return null;
        }
    }

    @Override
    public MQIConnection mqConnect(String queueManagerName, MQIConnectOptions u) {
        this.response.assign(0, 0);
        if (this.isLogging()) {
            MQIConnectionManagerAbstract.logError("Called mqConnect(" + queueManagerName + ", connectionOptions)");
        }
        if (queueManagerName != null && (queueManagerName = queueManagerName.replace('\u0000', ' ').trim()).trim().length() == 0) {
            queueManagerName = null;
        }
        try {
            return this.createConnection(queueManagerName, u, null);
        }
        catch (Throwable throwable) {
            if (this.isLogging()) {
                MQIConnectionManagerAbstract.logError("An exception occurred, e=");
                MQIConnectionManagerAbstract.logException(throwable);
            }
            this.response.assign(2, 2273);
            return null;
        }
    }

    @Override
    public MQIConnection getExistingConnection(int i) {
        return this.retrieveExistingConnectionFromCache(i);
    }

    @Override
    public MQIResponse getResponse() {
        return (MQIResponse)this.response.clone();
    }

    public static MQIConnectionManager getInstance() {
        return instanceConnectionManager;
    }

    protected abstract MQIConnection mqConnect(String var1, MQIConnectOptions var2, Object var3, int var4);
}

