/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.mqi.jms.module;

import com.heirloomcomputing.ecs.mqi.api.MQIChannelDefinition;
import com.heirloomcomputing.ecs.mqi.api.MQIConnectOptions;
import com.heirloomcomputing.ecs.mqi.api.MQIGetMessageOptions;
import com.heirloomcomputing.ecs.mqi.api.MQIMessageDescriptor;
import com.heirloomcomputing.ecs.mqi.api.MQIObjectDescriptor;
import com.heirloomcomputing.ecs.mqi.api.MQIPutMessageOptions;
import com.heirloomcomputing.ecs.mqi.api.MQIResponse;
import com.heirloomcomputing.ecs.mqi.jms.module.AbstractJMSModule;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.TimeZone;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.jms.ResourceAllocationException;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.Topic;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.TransactionInProgressException;
import javax.jms.TransactionRolledBackException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.InsufficientResourcesException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.NamingSecurityException;
import javax.naming.ServiceUnavailableException;

public class StandardJMSModule
extends AbstractJMSModule {
    private Context namingContext = null;
    private ConnectionFactory conFactory = null;
    private String c = null;
    private ArrayList<String> d = null;
    private boolean connectionError = false;

    public boolean initNamingContext() throws NamingException {
        if (this.isLoggingEnabled()) {
            this.log("Attempting to initialize JNDI initial context object with properties from properties file");
        }
        try {
            this.namingContext = new InitialContext(AbstractJMSModule.getConfigProperties());
            if (this.isLoggingEnabled()) {
                this.log("JNDI Context connected to " + this.namingContext.getEnvironment().get("java.naming.provider.url"));
            }
            return true;
        }
        catch (Throwable throwable) {
            if (this.isLoggingEnabled()) {
                this.log("A problem occurred initializing context, t=" + throwable);
            }
            return false;
        }
    }

    public ConnectionFactory lookupConnectionFactoryFromContext(String connectionFactoryName) throws NamingException {
        if (this.isLoggingEnabled()) {
            this.log("Looking up connection factory using '" + connectionFactoryName + "'");
        }
        Object factoryObject = this.lookupFromRootAndSubcontext(connectionFactoryName);
        if (this.isLoggingEnabled()) {
            this.log("Result of lookup='" + factoryObject + "'");
            if (factoryObject != null) {
                this.log("factoryObject=" + factoryObject.getClass().getName());
            } else {
                this.log("factoryObject is null");
            }
        }
        if (!(factoryObject instanceof ConnectionFactory)) {
            return null;
        }
        return (ConnectionFactory)factoryObject;
    }

    private Object lookupFromRootAndSubcontext(String objectName) throws NamingException {
        try {
            Object obj = this.namingContext.lookup(objectName);
            return obj;
        }
        catch (NameNotFoundException e) {
            if (this.isLoggingEnabled()) {
                this.log("Not found in root context.");
            }
            if (this.isLoggingEnabled()) {
                this.log("Looking up using 'java:comp/env/" + objectName + "'");
            }
            Context namingSubContext = (Context)this.namingContext.lookup("java:comp/env");
            Object obj = namingSubContext.lookup(objectName);
            return obj;
        }
    }

    public Destination lookupDestinationFromContext(String dest) throws NamingException {
        if (this.isLoggingEnabled()) {
            this.log("Looking up destination using '" + dest + "'");
        }
        Object obj = this.lookupFromRootAndSubcontext(dest);
        if (this.isLoggingEnabled()) {
            this.log("Result of lookup='" + obj + "'");
        }
        if (!(obj instanceof Destination)) {
            return null;
        }
        return (Destination)obj;
    }

    private Connection createConnection(ConnectionFactory connectionfactory, String userid, String pass) throws JMSException {
        if (!this.connectionError) {
            try {
                return connectionfactory.createConnection(userid, pass);
            }
            catch (LinkageError linkageerror) {
                this.connectionError = true;
            }
        }
        if (connectionfactory instanceof QueueConnectionFactory) {
            return ((QueueConnectionFactory)connectionfactory).createQueueConnection(userid, pass);
        }
        if (connectionfactory instanceof TopicConnectionFactory) {
            return ((TopicConnectionFactory)connectionfactory).createTopicConnection(userid, pass);
        }
        return null;
    }

    private Connection createConnection(ConnectionFactory connectionfactory) throws JMSException {
        if (!this.connectionError) {
            try {
                return connectionfactory.createConnection();
            }
            catch (LinkageError linkageerror) {
                this.connectionError = true;
            }
        }
        if (connectionfactory instanceof QueueConnectionFactory) {
            return ((QueueConnectionFactory)connectionfactory).createQueueConnection();
        }
        if (connectionfactory instanceof TopicConnectionFactory) {
            return ((TopicConnectionFactory)connectionfactory).createTopicConnection();
        }
        return null;
    }

    private Destination lookupDestination(Session session, String queueManagerName, String queueName, String dunamicQueueName) throws NamingException, JMSException {
        if (queueName != null && (queueName = queueName.replace('\u0000', ' ').trim()).length() == 0) {
            queueName = null;
        }
        if (queueManagerName != null && (queueManagerName = queueManagerName.replace('\u0000', ' ').trim()).length() == 0) {
            queueManagerName = null;
        }
        if (queueManagerName == null) {
            queueManagerName = this.a(this.conFactory);
        }
        if (this.isLoggingEnabled()) {
            this.log("Attempting to get destination object, queueManagerName='" + queueManagerName + "', queueName='" + queueName + "'");
        }
        String destinationLookupName = null;
        if (queueManagerName != null && queueName != null) {
            destinationLookupName = AbstractJMSModule.getPropValue("com.heirloomcomputing.ecs.mqi.jms.Destination." + queueManagerName + "." + queueName);
        }
        if (destinationLookupName == null) {
            if (queueName != null) {
                destinationLookupName = AbstractJMSModule.getPropValue("com.heirloomcomputing.ecs.mqi.jms.Destination." + queueName);
            }
            if (destinationLookupName == null) {
                destinationLookupName = AbstractJMSModule.getPropValue("com.heirloomcomputing.ecs.mqi.jms.Destination");
            }
        }
        Destination destination = null;
        NamingException namingexception = null;
        try {
            if (destinationLookupName != null) {
                destination = this.lookupDestinationFromContext(destinationLookupName.toString());
            }
        }
        catch (NamingException namingexception1) {
            namingexception = namingexception1;
        }
        if (destination == null) {
            Destination destination1 = null;
            destination1 = destinationLookupName != null ? this.lookupDestinationVendorSpecific(session, queueManagerName, destinationLookupName) : this.lookupDestinationVendorSpecific(session, queueManagerName, queueName);
            if (destination1 != null) {
                return destination1;
            }
            if (namingexception != null) {
                throw namingexception;
            }
        }
        return destination;
    }

    protected ConnectionFactory fInitConnectionFactory(String s1) throws NamingException {
        if (this.conFactory != null && (this.c == null ? s1 == null : this.c.equals(s1))) {
            return this.conFactory;
        }
        if (this.namingContext == null && !this.initNamingContext()) {
            return null;
        }
        String s2 = null;
        if (s1 != null) {
            s2 = AbstractJMSModule.getPropValue("com.heirloomcomputing.ecs.mqi.jms.ConnectionFactory." + s1);
        }
        if (s2 == null) {
            s2 = AbstractJMSModule.getPropValue("com.heirloomcomputing.ecs.mqi.jms.ConnectionFactory");
            if (s2 == null) {
                if (this.isLoggingEnabled()) {
                    this.log("Problem encountered:  Connection factory property (com.heirloomcomputing.ecs.mqi.jms.ConnectionFactory=<value>) is not set in properties file");
                }
                return null;
            }
            this.c = null;
        } else {
            this.c = s1;
        }
        if (this.isLoggingEnabled()) {
            this.log("Looking up connection factory from context:  " + s2.toString());
        }
        this.conFactory = this.lookupConnectionFactoryFromContext(s2.toString());
        if (this.conFactory == null && this.isLoggingEnabled()) {
            this.log("Problem encountered:  Connection factory could not be obtained");
        }
        return this.conFactory;
    }

    protected String a(Destination destination, String s1) throws JMSException {
        if (destination instanceof Queue) {
            return ((Queue)destination).getQueueName();
        }
        if (destination instanceof Topic) {
            return ((Topic)destination).getTopicName();
        }
        return s1;
    }

    protected String b(Destination destination, String s1) throws JMSException {
        return s1;
    }

    protected Destination lookupDestinationVendorSpecific(Session session, String queueManagerName, String destinationName) {
        Object d;
        block2: {
            d = null;
            try {
                d = session instanceof TopicSession ? session.createTopic(destinationName) : session.createQueue(destinationName);
            }
            catch (JMSException e) {
                if (!this.isLoggingEnabled()) break block2;
                this.log("Exception occurred lookingup vendor specific '" + destinationName + "' queue");
                this.logException(e);
            }
        }
        return d;
    }

    protected String a(ConnectionFactory connectionfactory) {
        return null;
    }

    @Override
    public Connection obtainConnection(String queueManagerName, MQIConnectOptions conOptions) throws NamingException, JMSException {
        ConnectionFactory connectionfactory = this.fInitConnectionFactory(queueManagerName);
        if (connectionfactory == null) {
            throw new JMSException("Unable to initialize connection factory for " + queueManagerName);
        }
        String conUserid = null;
        String conPassword = null;
        if (conOptions != null) {
            int i;
            MQIChannelDefinition v1 = conOptions.getChannelDefinition();
            if (v1 != null && (i = v1.getChannelType()) == 6) {
                conUserid = v1.getMcaUserIdentifier();
                if (conUserid != null) {
                    conUserid = conUserid.replace('\u0000', ' ').trim();
                }
                conPassword = v1.getPassword();
                int j = 0;
                if (conPassword != null) {
                    conPassword = conPassword.replace('\u0000', ' ').trim();
                    j = conPassword.length();
                }
                if (this.isLoggingEnabled()) {
                    this.log("Channel data type is client connection, userId='" + conUserid + "', password exists? " + (j <= 0 ? "No" : "Yes"));
                }
            }
        } else {
            conUserid = AbstractJMSModule.getPropValue("com.heirloomcomputing.ecs.mqi.jms.UserID." + queueManagerName);
            if (conUserid == null) {
                conUserid = AbstractJMSModule.getPropValue("com.heirloomcomputing.ecs.mqi.jms.UserID");
            }
            if ((conPassword = AbstractJMSModule.getPropValue("com.heirloomcomputing.ecs.mqi.jms.Password." + queueManagerName)) == null) {
                conPassword = AbstractJMSModule.getPropValue("com.heirloomcomputing.ecs.mqi.jms.Password");
            }
        }
        Connection connection = null;
        if (conUserid != null && conUserid.length() > 0) {
            if (this.isLoggingEnabled()) {
                this.log("Creating connection using connection factory (using userId/password method): " + connectionfactory.getClass() + " UserId: " + conUserid + " Password: " + conPassword);
            }
            connection = this.createConnection(connectionfactory, conUserid, conPassword);
        } else {
            if (this.isLoggingEnabled()) {
                this.log("Creating connection using connection factory: " + connectionfactory.getClass());
            }
            connection = this.createConnection(connectionfactory);
        }
        if (this.isLoggingEnabled()) {
            if (connection != null) {
                this.log("Connection=" + connection.getClass());
            } else {
                this.log("Connection returned from connection factory is null");
            }
        }
        return connection;
    }

    @Override
    public Destination obtainDestination(Session session, MQIObjectDescriptor destinationDescriptor) throws NamingException, JMSException {
        String dunamicQueueName;
        String queueName = destinationDescriptor.getObjectName();
        String queueManagerName = destinationDescriptor.getQueueManagerName();
        Destination destination = this.lookupDestination(session, queueManagerName, queueName, dunamicQueueName = destinationDescriptor.getDynamicQueueName());
        if (destination != null) {
            destinationDescriptor.setResolvedQueueName(this.a(destination, queueName));
            destinationDescriptor.setResolvedQueueManagerName(this.b(destination, queueManagerName));
            if (destination instanceof TemporaryQueue) {
                destinationDescriptor.setObjectName(destinationDescriptor.getResolvedQueueName());
                destinationDescriptor.setQueueManagerName(destinationDescriptor.getResolvedQueueManagerName());
            }
            if (this.isLoggingEnabled()) {
                this.log("Set object descriptor's resolved queue name to '" + destinationDescriptor.getResolvedQueueName() + "'");
                this.log("Set object descriptor's resolved queue manager name to '" + destinationDescriptor.getResolvedQueueManagerName() + "'");
            }
        }
        return destination;
    }

    @Override
    public void specifyMqgetCharset(Destination destination, MQIMessageDescriptor w1, MQIGetMessageOptions x1) throws JMSException {
    }

    @Override
    public void specifyMqputCharset(Destination destination, MQIMessageDescriptor w1, MQIPutMessageOptions ad1) throws JMSException {
    }

    @Override
    public void populateMessageDescriptor(MQIGetMessageOptions x1, Message message, MQIMessageDescriptor w1) throws JMSException {
        int i = message.getJMSDeliveryMode();
        if (i == 2) {
            if (this.isLoggingEnabled()) {
                this.log("Setting message descriptor's persistence property to persistent");
            }
            w1.setPersistence(1);
        } else if (i == 1) {
            if (this.isLoggingEnabled()) {
                this.log("Setting message descriptor's persistence property to non-persistent");
            }
            w1.setPersistence(0);
        } else {
            w1.setPersistence(2);
        }
        long l = message.getJMSExpiration();
        if (l > 0L && l <= Integer.MAX_VALUE) {
            int j = (int)l / 10;
            if (this.isLoggingEnabled()) {
                this.log("Setting message descriptor's expiry property to " + j + " centiseconds");
            }
            w1.setExpiry(j);
        } else {
            if (this.isLoggingEnabled()) {
                this.log("Setting message descriptor's expiry property to unlimited");
            }
            w1.setExpiry(-1);
        }
        int k = message.getJMSPriority();
        if (this.isLoggingEnabled()) {
            this.log("Setting message descriptor's priority property to " + k);
        }
        w1.setPriority(k);
        String msgId = message.getJMSMessageID();
        if (msgId != null) {
            if (msgId.startsWith("ID:")) {
                String s2 = this.a(msgId.substring(3));
                if (s2 != null) {
                    if (this.isLoggingEnabled()) {
                        this.log("Setting message descriptor's message id property to '" + s2 + "', (jms hex='" + msgId + "')");
                    }
                    w1.setMessageId(s2);
                } else {
                    w1.setMessageId("\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000");
                }
            } else {
                w1.setMessageId("\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000");
            }
        } else {
            w1.setMessageId("\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000");
        }
        long l1 = message.getJMSTimestamp();
        Date date = new Date(l1);
        TimeZone timezone = TimeZone.getTimeZone("GMT");
        SimpleDateFormat simpledateformat = new SimpleDateFormat("yyyyMMdd");
        simpledateformat.setTimeZone(timezone);
        String s3 = simpledateformat.format(date);
        if (this.isLoggingEnabled()) {
            this.log("Setting message descriptor's 'put date' property to '" + s3 + "' (jms timestamp=" + l1 + ")");
        }
        w1.setPutDate(s3);
        simpledateformat = new SimpleDateFormat("HHmmssSSS");
        simpledateformat.setTimeZone(timezone);
        String s4 = simpledateformat.format(date);
        s4 = s4.substring(0, 8);
        if (this.isLoggingEnabled()) {
            this.log("Setting message descriptor's 'put time' property to '" + s4 + "' (jms timestamp=" + l1 + ")");
        }
        w1.etPutTime(s4);
        String corrId = message.getJMSCorrelationID();
        if (corrId != null) {
            if (corrId.startsWith("ID:")) {
                String s6 = this.a(corrId.substring(3));
                if (s6 != null) {
                    if (this.isLoggingEnabled()) {
                        this.log("Setting message descriptor's correlation id property to '" + s6 + "', (jms hex='" + corrId + "')");
                    }
                    w1.setCorrelationId(s6);
                } else {
                    w1.setCorrelationId("\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000");
                }
            } else {
                String s7 = this.c(corrId);
                if (s7 != null) {
                    StringBuffer stringbuffer = new StringBuffer();
                    int i1 = s7.length();
                    if (i1 <= 24) {
                        stringbuffer.append(s7);
                    } else {
                        stringbuffer.append(s7.substring(0, 24));
                    }
                    stringbuffer.setLength(24);
                    if (this.isLoggingEnabled()) {
                        this.log("Setting message descriptor's correlation id property to '" + stringbuffer + "', (jms hex='" + corrId + "')");
                    }
                    w1.setCorrelationId(stringbuffer.toString());
                } else {
                    w1.setCorrelationId("\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000");
                }
            }
        } else {
            w1.setCorrelationId("\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000");
        }
        Destination replyTo = message.getJMSReplyTo();
        if (replyTo instanceof Queue) {
            String s8 = this.a(replyTo, ((Queue)replyTo).getQueueName());
            String s11 = this.b(replyTo, null);
            if (this.isLoggingEnabled()) {
                this.log("Setting message descriptor's replyToQueue to '" + s8 + "' and replyToQueueManager to '" + s11 + "'");
            }
            w1.setReplyToQueueName(s8);
            w1.setReplyToQueueManagerName(s11);
        } else if (replyTo instanceof Topic) {
            String s9 = this.a(replyTo, ((Topic)replyTo).getTopicName());
            String s12 = this.b(replyTo, null);
            if (this.isLoggingEnabled()) {
                this.log("Setting message descriptor's replyToQueue to '" + s9 + "' and replyToQueueManager to '" + s12 + "'");
            }
            w1.setReplyToQueueName(s9);
            w1.setReplyToQueueManagerName(s12);
        }
        String userId = message.getStringProperty("JMSXUserID");
        if (this.isLoggingEnabled()) {
            this.log("Setting message descriptor's user id property to '" + userId + "'");
        }
        w1.setUserId(userId);
        String appId = message.getStringProperty("JMSXAppID");
        if (this.isLoggingEnabled()) {
            this.log("Setting message descriptor's putApplName property to '" + appId + "'");
        }
        w1.setPutApplicationName(appId);
        int c1 = 2096;
        if ((x1.getOptions() & c1) == 0) {
            String s14 = message.getStringProperty("JMSXDeliveryCount");
            if (s14 != null) {
                try {
                    if (this.isLoggingEnabled()) {
                        this.log("Setting message descriptor's backout count to '" + s14 + "'");
                    }
                    w1.setBackoutCount(Integer.parseInt(s14));
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                w1.setBackoutCount(0);
            }
        } else {
            w1.setBackoutCount(0);
        }
        int messageFlags = 0;
        if (!(message.getJMSDestination() instanceof Topic)) {
            String groupId = message.getStringProperty("JMSXGroupID");
            if (groupId != null) {
                if (groupId.startsWith("ID:")) {
                    String s16 = this.a(groupId.substring(3));
                    if (s16 != null) {
                        if (this.isLoggingEnabled()) {
                            this.log("Setting message descriptor's group id property to '" + s16 + "', (jms hex='" + groupId + "')");
                        }
                        w1.setGroupId(s16);
                    } else {
                        w1.setGroupId("\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000");
                    }
                } else {
                    String s17 = this.c(groupId);
                    if (s17 != null) {
                        StringBuffer stringbuffer1 = new StringBuffer();
                        int k1 = s17.length();
                        if (k1 <= 24) {
                            stringbuffer1.append(s17);
                        } else {
                            stringbuffer1.append(s17.substring(0, 24));
                        }
                        stringbuffer1.setLength(24);
                        if (this.isLoggingEnabled()) {
                            this.log("Setting message descriptor's group id property to '" + stringbuffer1 + "', (jms hex='" + groupId + "')");
                        }
                        w1.setGroupId(stringbuffer1.toString());
                        if (this.isLoggingEnabled()) {
                            this.log("Updating message flags to include MQMF_MSG_IN_GROUP");
                        }
                        messageFlags |= 8;
                    } else {
                        w1.setGroupId("\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000");
                    }
                }
            } else {
                w1.setGroupId("\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000");
            }
            String groupSeq = message.getStringProperty("JMSXGroupSeq");
            if (groupSeq != null && Integer.parseInt(groupSeq) > 0) {
                try {
                    if (this.isLoggingEnabled()) {
                        this.log("Setting message descriptor's message sequence number property to '" + groupSeq + "'");
                    }
                    w1.setMessageSequenceNumber(Integer.parseInt(groupSeq));
                    if (this.isLoggingEnabled()) {
                        this.log("Updating message flags to include MQMF_MSG_IN_GROUP");
                    }
                    messageFlags |= 8;
                }
                catch (NumberFormatException numberformatexception1) {
                    if (this.isLoggingEnabled()) {
                        this.log("A number format exception happened while setting message descriptor's message sequence number property, e=");
                        this.logException(numberformatexception1);
                    }
                }
            } else {
                w1.setMessageSequenceNumber(1);
            }
        }
        w1.setMessageFlags(messageFlags);
    }

    @Override
    public void populateMessageOptionsBeforePut(Session session, MQIPutMessageOptions ad1, MQIMessageDescriptor w1, Message message) throws JMSException {
        boolean flag1;
        block16: {
            int i = ad1.getOptions();
            if (this.isLoggingEnabled()) {
                this.log("ad1.getOptions() = '" + i + "'");
            }
            String s1 = w1.getMessageId();
            if (this.isLoggingEnabled()) {
                this.log("w1.getMessageId() = '" + s1 + "'");
            }
            if (s1 != null && !"0".equals(s1) && !"\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000".equals(s1) && (i & 0x40) != 64) {
                if (this.isLoggingEnabled()) {
                    this.log("Setting message's message id property to '" + s1 + "'");
                }
                message.setJMSMessageID("ID:" + this.b(s1));
            }
            String s2 = w1.getCorrelationId();
            if (this.isLoggingEnabled()) {
                this.log("w1.getCorrelationId() = '" + s2 + "'");
            }
            if (s2 != null && !"0".equals(s2) && !"\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000".equals(s2)) {
                if (this.isLoggingEnabled()) {
                    this.log("Setting message's correlation id property to '" + s2 + "'");
                }
                message.setJMSCorrelationID("ID:" + this.b(s2));
            }
            String queueName = w1.getReplyToQueueName();
            String queueManagerName = w1.getReplyToQueueManagerName();
            try {
                if (queueName != null && queueName.trim().length() > 0) {
                    Destination destination;
                    if (this.isLoggingEnabled()) {
                        this.log("Reply to queue name='" + queueName + "', queueManagerName=" + queueManagerName);
                    }
                    if ((destination = this.lookupDestination(session, queueManagerName, queueName, null)) != null) {
                        if (this.isLoggingEnabled()) {
                            this.log("Setting message's reply to queue property to '" + destination + "'");
                        }
                        message.setJMSReplyTo(destination);
                    }
                }
            }
            catch (NamingException namingexception) {
                if (!this.isLoggingEnabled()) break block16;
                this.log("Could not get message's reply to queue, e=");
                this.logException(namingexception);
            }
        }
        int j = w1.getMessageFlags();
        boolean flag = (j & 0x10) == 16;
        boolean bl = flag1 = flag || (j & 8) == 8;
        if (flag1) {
            String s5 = w1.getGroupId();
            if (this.isLoggingEnabled()) {
                this.log("Setting message's group id property to '" + s5 + "'");
            }
            message.setStringProperty("JMSXGroupID", "ID:" + this.b(s5));
            int k = w1.getMessageSequenceNumber();
            if (this.isLoggingEnabled()) {
                this.log("Setting message's sequence number property to '" + k + "'");
            }
            message.setStringProperty("JMSXGroupSeq", "" + k);
        }
    }

    @Override
    public void populateMessageOptionsAfterPut(MQIPutMessageOptions ad1, Message message, MQIMessageDescriptor w1) throws JMSException {
        long l = message.getJMSTimestamp();
        Date date = new Date(l);
        TimeZone timezone = TimeZone.getTimeZone("GMT");
        SimpleDateFormat simpledateformat = new SimpleDateFormat("yyyyMMdd");
        simpledateformat.setTimeZone(timezone);
        String s1 = simpledateformat.format(date);
        if (this.isLoggingEnabled()) {
            this.log("Setting message descriptor's 'put date' property to '" + s1 + "' (jms timestamp=" + l + ")");
        }
        w1.setPutDate(s1);
        simpledateformat = new SimpleDateFormat("HHmmssSSS");
        simpledateformat.setTimeZone(timezone);
        String s2 = simpledateformat.format(date);
        s2 = s2.substring(0, 8);
        if (this.isLoggingEnabled()) {
            this.log("Setting message descriptor's 'put time' property to '" + s2 + "' (jms timestamp=" + l + ")");
        }
        w1.etPutTime(s2);
        String s3 = message.getJMSMessageID();
        if (s3 != null) {
            if (s3.startsWith("ID:")) {
                String s4 = this.a(s3.substring(3));
                if (s4 != null) {
                    if (this.isLoggingEnabled()) {
                        this.log("Setting message descriptor's message id property to '" + s4 + "', (jms hex='" + s3 + "')");
                    }
                    w1.setMessageId(s4);
                } else {
                    w1.setMessageId("\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000");
                }
            } else {
                w1.setMessageId("\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000");
            }
        } else {
            w1.setMessageId("\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000");
        }
        String s5 = message.getJMSCorrelationID();
        if (s5 != null) {
            if (s5.startsWith("ID:")) {
                String s6 = this.a(s5.substring(3));
                if (s6 != null) {
                    if (this.isLoggingEnabled()) {
                        this.log("Setting message descriptor's correlation id property to '" + s6 + "', (jms hex='" + s5 + "')");
                    }
                    w1.setCorrelationId(s6);
                } else {
                    w1.setCorrelationId("\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000");
                }
            } else {
                String s7 = this.c(s5);
                if (s7 != null) {
                    StringBuffer stringbuffer = new StringBuffer();
                    int j = s7.length();
                    if (j <= 24) {
                        stringbuffer.append(s7);
                    } else {
                        stringbuffer.append(s7.substring(0, 24));
                    }
                    stringbuffer.setLength(24);
                    if (this.isLoggingEnabled()) {
                        this.log("Setting message descriptor's correlation id property to '" + stringbuffer + "', (jms hex='" + s5 + "')");
                    }
                    w1.setCorrelationId(stringbuffer.toString());
                } else {
                    w1.setCorrelationId("\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000");
                }
            }
        } else {
            w1.setCorrelationId("\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000");
        }
        String s8 = message.getStringProperty("JMSXUserID");
        if (this.isLoggingEnabled()) {
            this.log("Setting message descriptor's user id property to '" + s8 + "'");
        }
        w1.setUserId(s8);
        String s9 = message.getStringProperty("JMSXAppID");
        if (this.isLoggingEnabled()) {
            this.log("Setting message descriptor's putApplName property to '" + s9 + "'");
        }
        w1.setPutApplicationName(s9);
    }

    @Override
    public void convertNamingExceptionToResponseCodes(MQIResponse s1, NamingException namingexception) {
        if (namingexception instanceof InsufficientResourcesException) {
            s1.assign(2, 2102);
        } else if (namingexception instanceof NamingSecurityException) {
            s1.assign(2, 2063);
        } else if (namingexception instanceof ServiceUnavailableException) {
            s1.assign(2, 2285);
        } else {
            s1.assign(2, 2286);
        }
    }

    @Override
    public void convertJMSExceptionToResponseCodes(MQIResponse s1, JMSException jmsexception) {
        if (jmsexception instanceof InvalidDestinationException) {
            s1.assign(2, 2085);
        } else if (jmsexception instanceof JMSSecurityException) {
            s1.assign(2, 2063);
        } else if (jmsexception instanceof ResourceAllocationException) {
            s1.assign(2, 2102);
        } else if (jmsexception instanceof TransactionInProgressException) {
            s1.assign(2, 2128);
        } else if (jmsexception instanceof TransactionRolledBackException) {
            s1.assign(1, 2003);
        } else {
            s1.assign(2, 2195);
        }
    }

    @Override
    public void closeNamingContext() {
        if (this.namingContext != null) {
            block7: {
                if (this.d != null) {
                    Iterator<String> iterator = this.d.iterator();
                    while (iterator.hasNext()) {
                        try {
                            this.namingContext.unbind(iterator.next());
                        }
                        catch (Exception exception) {}
                    }
                    this.d = null;
                }
                try {
                    this.namingContext.close();
                }
                catch (NamingException namingexception) {
                    if (!this.isLoggingEnabled()) break block7;
                    this.log("A naming exception occurred while closing context, e=");
                    this.logException(namingexception);
                }
            }
            this.namingContext = null;
            this.conFactory = null;
        }
    }
}

