/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.run;

import com.heirloomcomputing.ecs.api.ICallRemoteTarget;
import com.heirloomcomputing.ecs.exec.Dialog;
import com.heirloomcomputing.ecs.exec.parameterList;
import java.awt.Toolkit;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.rmi.Naming;
import java.rmi.server.UnicastRemoteObject;

public class rmi
extends UnicastRemoteObject
implements ICallRemoteTarget {
    public static final String DEFAULT_REGISTRY_SERVER = "sun.rmi.registry.RegistryImpl";
    public static String registryServer = "sun.rmi.registry.RegistryImpl";
    public static int WAIT_SERVER_MILLISECONDS = 2000;
    private static Class<?> booleanArrayClass;
    private static boolean serverAttempted;
    private String bindName;
    private Object program;
    private Class<?> programClass;
    private Method invocationMethod;
    private boolean parameterListCall;
    private boolean callableCall;

    private static void usage() {
        System.out.println("com.heirloomcomputing.ecs.run.rmi Copyright (C) 2010-2023 Heirloom Computing.  All Rights Reserved.");
        System.out.println("");
        System.out.println("Usage:");
        System.out.println("");
        System.out.println("<java> com.heirloomcomputing.ecs.run.rmi [bind=]program_id[:method[:signature]] ...");
        System.out.println("");
        System.out.println("program_id: The program_id or class_name is the program to run.");
        System.out.println("bind      : The externally bound name");
        System.out.println("method    : Alternative method name to invoke");
        System.out.println("signature : Signature of method using the following codes:");
        System.out.println("            B=byte, C=char, D=double, F=float, I=int, J=long,");
        System.out.println("            S=short, Z=boolean, Lclassname;");
        System.out.println("");
        System.out.println("Note: The rmiregistry service must be running before running this.");
        System.out.println("");
    }

    public static void main(String[] args) {
        int counter;
        if (args == null || args.length == 0 || args.length == 1 && "-?".equals(args[0])) {
            rmi.usage();
            return;
        }
        Toolkit.getDefaultToolkit();
        do {
            counter = 0;
            System.out.println("Attempting to bind server listeners:");
            for (int i = 0; i < args.length; ++i) {
                try {
                    if (args[i] == null || args[i].startsWith("-")) continue;
                    args[i] = args[i].trim();
                    String name = args[i];
                    String methodName = null;
                    int colonIndex = name.indexOf(58);
                    if (colonIndex >= 0) {
                        methodName = name.substring(colonIndex + 1);
                        name = name.substring(0, colonIndex);
                    }
                    int equalsIndex = name.indexOf(61);
                    String bindName = name;
                    if (equalsIndex >= 0) {
                        bindName = name.substring(0, equalsIndex);
                        name = name.substring(equalsIndex + 1);
                    }
                    System.out.println("Creating reference to '" + args[i] + "'...");
                    rmi interceptor = new rmi(bindName, name, methodName);
                    System.out.println("Binding '" + name + "'...");
                    Naming.rebind(name, interceptor);
                    System.out.println("Bound.");
                    ++counter;
                    continue;
                }
                catch (Throwable t) {
                    System.out.println("ERROR: " + t);
                }
            }
            System.out.println("");
            if (counter == 1) {
                System.out.println(counter + " Service Started.");
            } else {
                System.out.println(counter + " Services Started.");
            }
            System.out.println("");
            if (counter != 0 || rmi.attemptServerConnection()) continue;
            String rmiregistry = System.getProperty("java.home");
            if (rmiregistry != null) {
                if (!rmiregistry.endsWith(File.separator)) {
                    rmiregistry = rmiregistry + File.separator;
                }
                rmiregistry = rmiregistry + "bin" + File.separator + "rmiregistry";
            }
            if (rmiregistry == null) {
                rmiregistry = "<jdk>" + File.separator + "bin" + File.separator + "rmiregistry";
            }
            System.out.println("Check that the rmiregistry is started using " + rmiregistry);
            System.out.println("then try again.  The rmiregistry must have percobo.jar in its CLASSPATH.");
            System.out.println("");
            String s = Dialog.singleLineOfTextInput("Press Enter to continue, 'run class' for registry server, or Q to Quit: ");
            if (s == null) continue;
            if ((s = s.trim()).startsWith("q") || s.startsWith("Q")) {
                System.exit(0);
            }
            if (!s.startsWith("run ")) continue;
            registryServer = s = s.substring(4).trim();
            serverAttempted = false;
            rmi.attemptServerConnection();
            String string2 = DEFAULT_REGISTRY_SERVER;
        } while (counter == 0);
    }

    private static boolean attemptServerConnection() {
        block5: {
            if (!serverAttempted) {
                serverAttempted = true;
                try {
                    Class<?> c = Class.forName(registryServer);
                    final Method m = c.getMethod("main", String[].class);
                    if (m == null) break block5;
                    new Thread(){

                        @Override
                        public void run() {
                            try {
                                System.out.println("Invoking main rmiregistry...");
                                m.invoke(null, new Object[]{new String[0]});
                                System.out.println("Invoked.");
                            }
                            catch (Throwable invocationException) {
                                invocationException.printStackTrace(System.out);
                            }
                        }
                    }.start();
                    try {
                        System.out.println("Waiting " + (double)WAIT_SERVER_MILLISECONDS / 1000.0 + " seconds for rmi registry server to start.");
                        Thread.sleep(WAIT_SERVER_MILLISECONDS);
                        System.out.println("Wait complete.");
                        System.out.println("");
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    return true;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    public rmi(String bindName, String programName, String methodName) throws Throwable {
        programName = programName.replace('/', '.');
        programName = programName.replace(File.separatorChar, '.');
        if (programName.endsWith(".class")) {
            programName = programName.substring(0, programName.length() - 6);
        }
        this.bindName = bindName;
        this.programClass = Class.forName(programName);
        this.program = this.programClass.newInstance();
        if (methodName == null) {
            try {
                this.invocationMethod = this.programClass.getMethod("callGiving", parameterList.class);
                if (this.invocationMethod != null) {
                    this.parameterListCall = true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.invocationMethod == null) {
                try {
                    this.invocationMethod = this.programClass.getMethod("call", booleanArrayClass, Object[].class);
                    if (this.invocationMethod != null) {
                        this.callableCall = true;
                    }
                }
                catch (Throwable throwable) {}
            }
        } else {
            int colonIndex = methodName.indexOf(58);
            if (colonIndex >= 0) {
                String signature = methodName.substring(colonIndex + 1);
                methodName = methodName.substring(0, colonIndex);
                signature = signature.trim();
                methodName = methodName.trim();
                if (signature.startsWith("(")) {
                    int index = signature.indexOf(41);
                    signature = index >= 0 ? signature.substring(1, index) : signature.substring(1);
                }
                int count = 0;
                int signatureLength = signature.length();
                block19: for (int i = 0; i < signatureLength; ++i) {
                    switch (signature.charAt(i)) {
                        case 'B': 
                        case 'C': 
                        case 'D': 
                        case 'F': 
                        case 'I': 
                        case 'J': 
                        case 'S': 
                        case 'Z': {
                            ++count;
                            continue block19;
                        }
                        case 'L': {
                            i = signature.indexOf(59, i + 1);
                            if (i >= 0) continue block19;
                            i = signatureLength;
                        }
                    }
                }
                Class[] params = new Class[count];
                count = 0;
                block20: for (int i = 0; i < signatureLength; ++i) {
                    switch (signature.charAt(i)) {
                        case 'B': {
                            params[count++] = Byte.TYPE;
                            continue block20;
                        }
                        case 'C': {
                            params[count++] = Character.TYPE;
                            continue block20;
                        }
                        case 'D': {
                            params[count++] = Double.TYPE;
                            continue block20;
                        }
                        case 'F': {
                            params[count++] = Float.TYPE;
                            continue block20;
                        }
                        case 'I': {
                            params[count++] = Integer.TYPE;
                            continue block20;
                        }
                        case 'J': {
                            params[count++] = Long.TYPE;
                            continue block20;
                        }
                        case 'S': {
                            params[count++] = Short.TYPE;
                            continue block20;
                        }
                        case 'Z': {
                            params[count++] = Boolean.TYPE;
                            continue block20;
                        }
                        case 'L': {
                            int semicolon = signature.indexOf(59, i + 1);
                            if (semicolon >= 0) {
                                String className = signature.substring(i, semicolon);
                                params[count++] = Class.forName(className);
                                i = semicolon;
                                continue block20;
                            }
                            i = signatureLength;
                        }
                    }
                }
                this.invocationMethod = this.programClass.getMethod(methodName, params);
            } else {
                Method[] methods = this.programClass.getMethods();
                int methodsLength = methods.length;
                for (int i = 0; i < methodsLength; ++i) {
                    if (!methods[i].getName().equals(methodName)) continue;
                    this.invocationMethod = methods[i];
                }
            }
        }
    }

    @Override
    public synchronized Serializable call(Serializable[] params) throws Exception {
        if (this.invocationMethod != null) {
            System.out.println("Invoking bound service '" + this.bindName + "'");
            Object result = null;
            result = this.parameterListCall ? this.invocationMethod.invoke(this.program, new parameterList(params)) : (this.callableCall ? this.invocationMethod.invoke(this.program, null, params) : this.invocationMethod.invoke(this.program, (Object[])params));
            try {
                return (Serializable)result;
            }
            catch (Throwable throwable) {
            }
        } else {
            System.out.println("ERROR: Cannot invoke service '" + this.bindName + "': no such method");
        }
        return null;
    }

    static {
        try {
            booleanArrayClass = Class.forName("[Z");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        serverAttempted = true;
    }
}

