/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.run;

import com.heirloomcomputing.ecs.exec.Beep;
import com.heirloomcomputing.ecs.exec.Context;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.SocketContext;
import com.heirloomcomputing.ecs.exec.Version;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.net.Socket;

public class server
extends Thread {
    private Object program = null;
    private Socket client = null;
    private int id = 0;
    private static long timer = 0L;
    private static boolean beep = false;
    private static boolean verbose = false;
    private static boolean quiet = false;
    private static int maxid = 0;
    private static int port = 9090;
    private static ServerSocket ssocket = null;
    private static Class<?> programClass = null;
    private static Method program_call;

    public server(Object program, Socket client) {
        this.program = program;
        this.client = client;
        this.id = ++maxid;
    }

    @Override
    public void run() {
        block5: {
            this.begin();
            try {
                SocketContext context = new SocketContext(this, ssocket, this.client);
                program_call.invoke(this.program, context);
            }
            catch (Exception e) {
                if (!verbose) break block5;
                e.printStackTrace(System.out);
            }
        }
        this.end();
        try {
            if (this.client != null) {
                this.client.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void message(String message) {
        if (!quiet) {
            System.out.println(message);
        }
    }

    public static void verbose(String message) {
        if (verbose) {
            System.out.println(message);
        }
    }

    private static String massage(String program) {
        String programCompare = program.toUpperCase();
        if (programCompare.endsWith(".CLASS")) {
            program = program.substring(0, program.length() - 6);
        }
        program = program.replace('/', '.');
        program = program.replace('\\', '.');
        return program;
    }

    private static void setPort(int value) {
        if (value >= 0) {
            port = value;
        }
    }

    protected static boolean option(String option) {
        try {
            if (option.equalsIgnoreCase("sysout=syserr")) {
                System.setOut(System.err);
            } else if (option.equalsIgnoreCase("syserr=sysout")) {
                System.setErr(System.out);
            } else if (option.equalsIgnoreCase("nosysout")) {
                System.setOut(null);
            } else if (option.equalsIgnoreCase("nosyserr")) {
                System.setErr(null);
            } else if (option.equals("version")) {
                Version.outputVersion();
            } else if (option.equals("time")) {
                timer = System.currentTimeMillis();
            } else if (option.equals("beep")) {
                beep = true;
            } else if (option.equals("debug")) {
                RuntimeEnvironment.setGlobalParameter("DEBUGMODE", "true");
            } else if (option.equals("error") || option.equals("fileopenerrors")) {
                RuntimeEnvironment.setGlobalParameter("FILEOPENERRORS", "true");
            } else if (option.equals("noerror") || option.equals("nofileopenerrors")) {
                RuntimeEnvironment.setGlobalParameter("FILEOPENERRORS", "false");
            } else if (option.equals("curses")) {
                RuntimeEnvironment.setGlobalParameter("USECURSES", "true");
            } else if (option.equals("verbose")) {
                verbose = true;
                quiet = false;
            } else if (option.equals("quiet")) {
                verbose = false;
                quiet = true;
            } else {
                if (option.equals("port")) {
                    return true;
                }
                server.message("Unknown option: '" + option + "'");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    protected void begin() {
        server.verbose("Begin serving program: " + this.id);
        if (beep) {
            Beep.beep();
        }
    }

    protected void end() {
        server.verbose("End serving program: " + this.id);
        if (timer > 0L) {
            long timerEnd = System.currentTimeMillis();
            timer = timerEnd - timer;
            System.out.println("Elapsed Time: " + timer + "ms");
        }
        if (beep) {
            Beep.beep();
        }
    }

    private static void serve(int port) {
        boolean opened = false;
        try {
            if (ssocket == null) {
                ssocket = new ServerSocket(port);
            }
            opened = true;
            while (true) {
                server.message("Waiting on socket connection to " + port + ":");
                try {
                    Object program = programClass.newInstance();
                    Socket client = ssocket.accept();
                    server.message("Socket accepted from " + client + ".");
                    new server(program, client).start();
                }
                catch (Exception program) {}
            }
        }
        catch (Throwable t) {
            if (opened) {
                server.message("Server socket cancelled on " + port + ".");
            } else {
                server.message("Servet socket could not be established on " + port + ".");
            }
            return;
        }
    }

    public static void main(String[] args) {
        if (args == null) {
            args = new String[]{};
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null || args[i].trim().length() == 0) continue;
            if (args[i].startsWith("/") || args[i].startsWith("-")) {
                if (!server.option(args[i].substring(1))) continue;
                server.setPort(Integer.parseInt(args[++i].trim()));
                continue;
            }
            if (args[i].startsWith("--")) {
                if (!server.option(args[i].substring(2))) continue;
                server.setPort(Integer.parseInt(args[++i].trim()));
                continue;
            }
            if (args[i].length() <= 0) continue;
            try {
                server.setPort(Integer.parseInt(args[i].trim()));
                continue;
            }
            catch (Exception exception) {
                String program = server.massage(args[i]);
                int length = args.length - i - 1;
                String[] programArgs = new String[length];
                for (int j = 0; j < length; ++j) {
                    programArgs[j] = args[i + j + 1];
                }
                try {
                    programClass = Class.forName(program);
                }
                catch (Throwable t) {
                    server.message("ERROR: Could not find program '" + program + "'.");
                    return;
                }
                server.verbose("Program name is: '" + program + "'");
                Class[] paramClasses = new Class[]{String[].class};
                try {
                    program_call = programClass.getMethod("call", Context.class);
                }
                catch (Exception e) {
                    server.message("ERROR: Could not obtain program entry point.");
                    return;
                }
                try {
                    server.serve(port);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return;
            }
        }
    }
}

