/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.sql;

import com.heirloomcomputing.ecs.sql.AbstractResultSet;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;

public class InMemoryResultSet
extends AbstractResultSet {
    boolean open;
    int row;
    int rows;
    int columns;
    ArrayList<Object[]> data;

    public InMemoryResultSet(ResultSet rs) throws SQLException {
        if (rs.isClosed()) {
            throw new SQLException("ResultSet is not Open", "UNKN", -20000);
        }
        ResultSetMetaData rmd = rs.getMetaData();
        this.columns = rmd.getColumnCount();
        this.open = true;
        this.rows = 0;
        this.data = new ArrayList();
        while (rs.next()) {
            Object[] tuple = new Object[this.columns];
            for (int i = 0; i < this.columns; ++i) {
                tuple[i] = rs.getObject(i + 1);
            }
            this.data.add(tuple);
            ++this.rows;
        }
        this.row = -1;
    }

    @Override
    public boolean next() throws SQLException {
        if (this.row > this.rows) {
            throw new SQLException("No Next Row", "UNKN", -20000);
        }
        ++this.row;
        if (this.row >= this.rows) {
            this.open = false;
            this.data = null;
        }
        return this.open;
    }

    @Override
    public void close() throws SQLException {
        this.data = null;
        this.open = false;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return !this.open;
    }

    @Override
    public int getRow() throws SQLException {
        return this.row + 1;
    }

    @Override
    public Object getObject(int columnIdx) throws SQLException {
        if (!this.open) {
            throw new SQLException("ResultSet is not Open", "UNKN", -20000);
        }
        if (this.row < 0) {
            this.close();
            throw new SQLException("Must start with a next()", "UNKN", -20000);
        }
        if (columnIdx > this.columns) {
            throw new SQLException("Not that many columns", "UNKN", -20000);
        }
        return this.data.get(this.row)[columnIdx - 1];
    }

    @Override
    public String getString(int columnIdx) throws SQLException {
        if (!this.open) {
            throw new SQLException("ResultSet is not Open", "UNKN", -20000);
        }
        if (this.row < 0) {
            this.close();
            throw new SQLException("Must start with a next()", "UNKN", -20000);
        }
        if (columnIdx > this.columns) {
            throw new SQLException("Not that many columns", "UNKN", -20000);
        }
        return this.data.get(this.row)[columnIdx - 1].toString();
    }

    @Override
    public byte[] getBytes(int columnIdx) throws SQLException {
        if (!this.open) {
            throw new SQLException("ResultSet is not Open", "UNKN", -20000);
        }
        if (this.row < 0) {
            this.close();
            throw new SQLException("Must start with a next()", "UNKN", -20000);
        }
        if (columnIdx > this.columns) {
            throw new SQLException("Not that many columns", "UNKN", -20000);
        }
        Object obj = this.data.get(this.row)[columnIdx - 1];
        if (obj instanceof byte[]) {
            return (byte[])obj;
        }
        return obj.toString().getBytes();
    }
}

