/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.util;

import com.heirloomcomputing.ecs.isamsql.DCB;
import com.heirloomcomputing.ecs.isamsql.DCBFactory;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Scanner;
import java.util.Vector;

public class AutoLoadDCBInfo {
    static String ASCII_CHARSET = "ISO-8859-1";
    static BufferedWriter bfw;
    static String dsnPath;
    static String dsnName;
    static String protocol;
    static String orientation;
    static String recFormat;
    static ArrayList<Integer> keyOffs;
    static ArrayList<Integer> keyLens;
    static ArrayList<Boolean> keyDups;
    static ArrayList<Integer> keyGroups;
    static int minLen;
    static int dcbLrecl;
    static Integer[] dcbKeyOff;
    static Integer[] dcbKeylen;
    static int passCntr;
    static int failCntr;
    static boolean recursive;
    static boolean dcbIsFixed;
    static boolean dcbIsIndexed;
    static boolean dcbIsNumbered;
    static boolean dcbIsIbm1047;
    static RandomAccessFile editorFile;
    static int MFFILE_HEADER_LEN;
    static byte[] fileHeader;
    static int keyBlockCurIndex;
    static int keyBlockOffset;
    static int keyBlockContinuationRecordNumber;
    static int idxHeaderSize;
    static int filePointerSize;
    static int idxFormat;
    static Vector<byte[]> keyInfoRecords;
    static int MAX_SEGS;
    static String mfHeaderFile;
    static String acuIdxFileName;
    static String acuDatFileName;

    public static void main(String[] args) {
        String logName;
        System.out.println("\n\n[2********Auto DCB Loader*********]");
        Scanner in = new Scanner(System.in);
        System.out.println("Enter directory location for files to be converted:");
        String inputDir = in.nextLine();
        System.out.println("Scan subdirectories?:[y/n]");
        String choice = in.nextLine();
        recursive = choice.toLowerCase().equals("y");
        in.close();
        try {
            long time = System.currentTimeMillis();
            logName = "LoadLog_" + time + ".txt";
            bfw = new BufferedWriter(new FileWriter(logName));
            AutoLoadDCBInfo.scanFolder(inputDir);
            bfw.close();
        }
        catch (IOException e) {
            System.out.println("[********Auto DCB Loader**IO**Err*****]");
            e.printStackTrace();
            return;
        }
        System.out.println("\nSuccesfully loaded DCB info for " + passCntr + " files.");
        if (failCntr > 0) {
            System.out.println("Load failed for " + passCntr + " files.");
        }
        System.out.println("\nLog information written to " + logName);
    }

    private static void scanFolder(String inputDir) throws IOException {
        File inputfolder = new File(inputDir);
        File[] listOfFiles = inputfolder.listFiles();
        for (int i = 0; i < listOfFiles.length; ++i) {
            if (listOfFiles[i].isFile()) {
                dsnPath = listOfFiles[i].getAbsolutePath();
                String fnameLower = dsnPath.toLowerCase();
                if (fnameLower.endsWith(".vix") || fnameLower.endsWith(".idx") || fnameLower.endsWith(".dcb")) continue;
                System.out.print(".");
                bfw.newLine();
                bfw.write("Loading: " + dsnPath);
                AutoLoadDCBInfo.readFileAndLoadDCB();
                continue;
            }
            if (!listOfFiles[i].isDirectory() || !recursive) continue;
            AutoLoadDCBInfo.scanFolder(listOfFiles[i].getAbsolutePath());
        }
    }

    private static void readFileAndLoadDCB() throws IOException {
        dsnName = dsnPath.substring(dsnPath.lastIndexOf(File.separatorChar) + 1).toUpperCase();
        if (AutoLoadDCBInfo.readFileHeader()) {
            DCB newDCB = DCBFactory.getInstance(dsnName, dsnPath, true);
            try {
                newDCB.addProtocol(protocol);
                newDCB.setOrientation(orientation);
                newDCB.setRecordFormat(recFormat);
            }
            catch (DCB.InvalidDCBException e) {
                ++failCntr;
                bfw.newLine();
                bfw.write("FAIL:=>[InvalidDCBException:] " + e.getMessage());
                return;
            }
            newDCB.setCharset(ASCII_CHARSET);
            newDCB.setKeyOffset(dcbKeyOff);
            newDCB.setKeyLength(dcbKeylen);
            newDCB.setAltKeyOffsets(keyOffs.toArray(new Integer[0]));
            newDCB.setAltKeyLengths(keyLens.toArray(new Integer[0]));
            newDCB.setAltKeyDuplicates(keyDups.toArray(new Boolean[0]));
            newDCB.setAltKeyGroups(keyGroups.toArray(new Integer[0]));
            newDCB.setRecordMinimum(minLen);
            newDCB.setRecordMaximum(dcbLrecl);
            newDCB.saveDCB();
            newDCB.unlockDCB();
            bfw.newLine();
            bfw.write("PASS");
            ++passCntr;
        } else {
            bfw.newLine();
            bfw.write("FAIL:File header load failed");
            ++failCntr;
        }
    }

    private static boolean readFileHeader() throws IOException {
        dcbIsIndexed = false;
        dcbIsNumbered = false;
        dcbIsFixed = false;
        dcbIsIbm1047 = false;
        boolean result = AutoLoadDCBInfo.loadFileHeader();
        if (editorFile != null) {
            try {
                editorFile.close();
            }
            catch (IOException e) {
                bfw.newLine();
                bfw.write("WARN:Load success however failure to close datafile");
            }
            editorFile = null;
        }
        return result;
    }

    private static boolean loadFileHeader() throws IOException {
        if (AutoLoadDCBInfo.checkForMFSystem()) {
            return true;
        }
        return AutoLoadDCBInfo.checkForACUSystem();
    }

    private static boolean checkForMFSystem() throws IOException {
        if (!AutoLoadDCBInfo.selectMFFileHeader()) {
            return false;
        }
        if (!AutoLoadDCBInfo.seekFilePos(0L)) {
            return false;
        }
        fileHeader = new byte[MFFILE_HEADER_LEN];
        if (!AutoLoadDCBInfo.readFileBytes(fileHeader, 0, MFFILE_HEADER_LEN)) {
            return false;
        }
        if (fileHeader[0] >> 4 == 3) {
            if (fileHeader[39] == 2) {
                dcbIsIndexed = true;
                orientation = "INDEXED";
            }
            if (dcbIsIndexed) {
                idxFormat = fileHeader[43];
                if (idxFormat != 0 && idxFormat != 3 && idxFormat != 4 && idxFormat != 8) {
                    bfw.newLine();
                    bfw.write("UnSupported version of MicroFocus Index Files: " + idxFormat);
                    return false;
                }
                if (idxFormat != 8 && !mfHeaderFile.regionMatches(true, mfHeaderFile.lastIndexOf(46), ".idx", 0, 4)) {
                    return false;
                }
                if (fileHeader[48] != 0 && fileHeader[48] != 1) {
                    bfw.newLine();
                    bfw.write("UnSupported Record Format of MicroFocus Index file");
                    return false;
                }
                recFormat = fileHeader[48] == 0 ? "F" : "V";
                int nodeSize = (int)(AutoLoadDCBInfo.getIntFromBytes(fileHeader, 172) + 2L);
                dcbLrecl = (int)AutoLoadDCBInfo.getIntFromBytes(fileHeader, 54);
                minLen = (int)AutoLoadDCBInfo.getIntFromBytes(fileHeader, 58);
                if (idxFormat == 8) {
                    idxHeaderSize = dcbLrecl > 4095 ? 4 : 2;
                    filePointerSize = 6;
                } else {
                    idxHeaderSize = 0;
                    filePointerSize = 4;
                }
                int numberOfKeys = AutoLoadDCBInfo.getShortFromBytes(fileHeader, 140);
                long startOfKeyInfoRecords = AutoLoadDCBInfo.getLongFromBytes(fileHeader, 144);
                if (!AutoLoadDCBInfo.seekFilePos(startOfKeyInfoRecords)) {
                    return false;
                }
                keyInfoRecords = new Vector();
                int count = 0;
                while (true) {
                    byte[] bytes = null;
                    if (count >= keyInfoRecords.size()) {
                        bytes = new byte[nodeSize];
                        keyInfoRecords.addElement(bytes);
                    } else {
                        bytes = keyInfoRecords.elementAt(count);
                    }
                    if (!AutoLoadDCBInfo.readFileBytes(bytes, 0, nodeSize)) {
                        return false;
                    }
                    long next = AutoLoadDCBInfo.getFilePointerFromBytes(bytes, idxHeaderSize + 2);
                    if (next <= 0L) break;
                    if (!AutoLoadDCBInfo.seekFilePos(next)) {
                        return false;
                    }
                    ++count;
                }
                keyBlockCurIndex = -1;
                keyBlockOffset = -1;
                keyBlockContinuationRecordNumber = -1;
                keyOffs.clear();
                keyLens.clear();
                keyDups.clear();
                keyGroups.clear();
                dcbKeyOff = null;
                dcbKeylen = null;
                int grpCntr = 0;
                for (int i = 0; i < numberOfKeys; ++i) {
                    int offset;
                    byte[] bytes = AutoLoadDCBInfo.getKeyBlock(i);
                    if (bytes == null) {
                        return false;
                    }
                    int blockLen = keyBlockOffset + AutoLoadDCBInfo.getShortFromBytes(bytes, keyBlockOffset);
                    boolean dupsAllowed = (bytes[offset - 1] & 0x40) != 0;
                    if (bytes[keyBlockOffset + (idxFormat == 8 ? 22 : 6)] != 0) {
                        bfw.newLine();
                        bfw.write("Key Compression detected for MF Indexed file! Currently UnSupported");
                        return false;
                    }
                    if (offset + (idxFormat == 8 ? 8 : 5) < blockLen) {
                        int j = 0;
                        for (offset = keyBlockOffset + (idxFormat == 8 ? 24 : 7); offset < blockLen; offset += idxFormat == 8 ? 8 : 5) {
                            if (idxFormat != 8 && j == 0) {
                                dupsAllowed = (bytes[offset] & 0xFFFFFF80) != 0;
                            }
                            keyLens.add(AutoLoadDCBInfo.getShortFromBytes(bytes, offset) & Short.MAX_VALUE);
                            keyOffs.add(AutoLoadDCBInfo.getShortFromBytes(bytes, offset + (idxFormat == 8 ? 4 : 2)));
                            keyDups.add(dupsAllowed);
                            keyGroups.add(grpCntr);
                            ++j;
                        }
                        if (i == 0) {
                            dcbKeyOff = keyOffs.toArray(new Integer[0]);
                            dcbKeylen = keyLens.toArray(new Integer[0]);
                            keyOffs.clear();
                            keyLens.clear();
                            keyDups.clear();
                            keyGroups.clear();
                            continue;
                        }
                        ++grpCntr;
                        continue;
                    }
                    if (idxFormat != 8) {
                        dupsAllowed = (bytes[offset] & 0xFFFFFF80) != 0;
                    }
                    int len = AutoLoadDCBInfo.getShortFromBytes(bytes, offset);
                    if (idxFormat != 8) {
                        len &= Short.MAX_VALUE;
                    }
                    keyLens.add(len);
                    keyOffs.add(AutoLoadDCBInfo.getShortFromBytes(bytes, offset + (idxFormat == 8 ? 4 : 2)));
                    keyDups.add(dupsAllowed);
                    keyGroups.add(-1);
                    if (i == 0) {
                        dcbKeyOff = keyOffs.toArray(new Integer[0]);
                        dcbKeylen = keyLens.toArray(new Integer[0]);
                        keyOffs.clear();
                        keyLens.clear();
                        keyDups.clear();
                        keyGroups.clear();
                    }
                    offset += idxFormat == 8 ? 8 : 5;
                }
                protocol = idxFormat == 8 ? "MF8" : (idxFormat == 3 ? "MF3" : "MF");
                return true;
            }
        }
        return false;
    }

    private static boolean selectMFFileHeader() {
        String filename = dsnPath;
        if (filename.indexOf(46) != -1) {
            String ext = filename.substring(filename.lastIndexOf(46) + 1);
            if (!ext.equalsIgnoreCase("idx") && filename.lastIndexOf(File.separator) != -1) {
                File folder = new File(filename.substring(0, filename.lastIndexOf(File.separator)));
                String idxName = filename.substring(filename.lastIndexOf(File.separator) + 1, filename.lastIndexOf(46)) + ".IDX";
                if (folder.exists() && folder.isDirectory()) {
                    File[] files;
                    for (File file2 : files = folder.listFiles()) {
                        if (!file2.getName().equalsIgnoreCase(idxName)) continue;
                        filename = file2.getAbsolutePath();
                        break;
                    }
                }
            }
        } else {
            File folder = new File(filename.substring(0, filename.lastIndexOf(File.separator)));
            String idxName = filename.substring(filename.lastIndexOf(File.separator) + 1) + ".IDX";
            if (folder.exists() && folder.isDirectory()) {
                File[] files;
                for (File file3 : files = folder.listFiles()) {
                    if (!file3.getName().equalsIgnoreCase(idxName)) continue;
                    filename = file3.getAbsolutePath();
                    break;
                }
            }
        }
        try {
            if (editorFile != null) {
                editorFile.close();
                editorFile = null;
            }
            mfHeaderFile = filename;
            editorFile = new RandomAccessFile(new File(filename), "r");
            return true;
        }
        catch (FileNotFoundException e2) {
            e2.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean selectACUFileHeader() {
        String filename = dsnPath;
        if (filename.indexOf(46) != -1 && filename.lastIndexOf(File.separator) != -1) {
            acuDatFileName = filename;
            File folder = new File(filename.substring(0, filename.lastIndexOf(File.separator)));
            String idxName = filename.substring(filename.lastIndexOf(File.separator) + 1, filename.lastIndexOf(46)) + ".VIX";
            if (folder.exists() && folder.isDirectory()) {
                File[] files;
                for (File file2 : files = folder.listFiles()) {
                    if (!file2.getName().equalsIgnoreCase(idxName)) continue;
                    filename = file2.getAbsolutePath();
                    acuIdxFileName = file2.getAbsolutePath();
                    break;
                }
            }
            if (acuIdxFileName == null || acuDatFileName == null) {
                return false;
            }
        } else {
            acuDatFileName = filename;
            File folder = new File(filename.substring(0, filename.lastIndexOf(File.separator)));
            String idxName = filename + ".VIX";
            if (folder.exists() && folder.isDirectory()) {
                File[] files;
                for (File file3 : files = folder.listFiles()) {
                    if (!file3.getAbsolutePath().equalsIgnoreCase(idxName)) continue;
                    filename = file3.getAbsolutePath();
                    acuIdxFileName = file3.getAbsolutePath();
                    break;
                }
            }
            if (acuIdxFileName == null || acuDatFileName == null) {
                return false;
            }
        }
        return true;
    }

    private static boolean checkForACUSystem() throws IOException {
        if (!AutoLoadDCBInfo.selectACUFileHeader()) {
            return false;
        }
        try {
            editorFile = new RandomAccessFile(new File(acuIdxFileName), "r");
        }
        catch (FileNotFoundException e2) {
            return false;
        }
        if (!AutoLoadDCBInfo.seekFilePos(0L)) {
            return false;
        }
        fileHeader = new byte[6];
        if (!AutoLoadDCBInfo.readFileBytes(fileHeader, 0, 6)) {
            return false;
        }
        if (fileHeader[0] != 16 || fileHeader[1] != 18 || fileHeader[2] != 20 || fileHeader[3] != 24) {
            return false;
        }
        if (AutoLoadDCBInfo.getShortFromBytes(fileHeader, 4) != 4) {
            bfw.newLine();
            bfw.write("UnSupported version of ACU Vision Index IDX File: " + AutoLoadDCBInfo.getShortFromBytes(fileHeader, 4));
            return false;
        }
        try {
            editorFile.close();
            editorFile = null;
        }
        catch (IOException e) {
            bfw.newLine();
            bfw.write("Check for ACU File:" + e.getMessage());
            return false;
        }
        try {
            editorFile = new RandomAccessFile(new File(acuDatFileName), "r");
        }
        catch (FileNotFoundException e2) {
            return false;
        }
        if (!AutoLoadDCBInfo.seekFilePos(0L)) {
            return false;
        }
        fileHeader = new byte[256];
        if (!AutoLoadDCBInfo.readFileBytes(fileHeader, 0, fileHeader.length)) {
            return false;
        }
        if (fileHeader[0] != 16 || fileHeader[1] != 18 || fileHeader[2] != 20 || fileHeader[3] != 25) {
            return false;
        }
        if (AutoLoadDCBInfo.getShortFromBytes(fileHeader, 4) != 4) {
            bfw.newLine();
            bfw.write("UnSupported version of ACU Vision Index DAT File: " + AutoLoadDCBInfo.getShortFromBytes(fileHeader, 4));
            return false;
        }
        if ((fileHeader[121] & 0xFF) != 0) {
            bfw.newLine();
            bfw.write("Compression not supported for ACU Vision Index File: ");
            return false;
        }
        dcbLrecl = AutoLoadDCBInfo.getShortFromBytes(fileHeader, 116);
        minLen = AutoLoadDCBInfo.getShortFromBytes(fileHeader, 118);
        int nodeSize = fileHeader[104] == 250 ? 512 : 1024;
        int numKeys = fileHeader[120] & 0xFF;
        dcbIsIndexed = true;
        orientation = "INDEXED";
        protocol = "ACU";
        recFormat = "F";
        int dfhSize = 160 + (14 + 3 * (MAX_SEGS - 1)) * numKeys;
        dfhSize = nodeSize * (int)Math.ceil((double)dfhSize / (double)nodeSize);
        fileHeader = new byte[dfhSize];
        if (!AutoLoadDCBInfo.seekFilePos(0L)) {
            return false;
        }
        if (!AutoLoadDCBInfo.readFileBytes(fileHeader, 0, dfhSize)) {
            return false;
        }
        keyOffs.clear();
        keyLens.clear();
        keyDups.clear();
        keyGroups.clear();
        dcbKeyOff = null;
        dcbKeylen = null;
        int grpCntr = -1;
        int offset = 160;
        for (int i = 0; i < numKeys; ++i) {
            if (i == 5) {
                offset = 512;
            }
            int numSegments = fileHeader[offset + 7] & 0xFF;
            boolean dups = (fileHeader[offset + 8] & 0xFF) != 0;
            keyLens.add(AutoLoadDCBInfo.getShortFromBytes(fileHeader, offset + 10));
            keyOffs.add(AutoLoadDCBInfo.getShortFromBytes(fileHeader, offset + 12));
            keyDups.add(dups);
            if (i != 0 && numSegments > 1) {
                keyGroups.add(++grpCntr);
            } else {
                keyGroups.add(-1);
            }
            offset += 14;
            for (int j = 1; j < numSegments; ++j) {
                keyLens.add(fileHeader[offset] & 0xFF);
                keyOffs.add(AutoLoadDCBInfo.getShortFromBytes(fileHeader, offset + 1));
                keyDups.add(dups);
                keyGroups.add(grpCntr);
                offset += 3;
            }
            offset += 3 * (MAX_SEGS - numSegments);
            if (i != 0) continue;
            dcbKeyOff = keyOffs.toArray(new Integer[0]);
            dcbKeylen = keyLens.toArray(new Integer[0]);
            keyOffs.clear();
            keyLens.clear();
            keyDups.clear();
            keyGroups.clear();
        }
        return true;
    }

    private static boolean seekFilePos(long pos) {
        try {
            if (pos < editorFile.length()) {
                editorFile.seek(pos);
                return true;
            }
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    private static boolean readFileBytes(byte[] byteArray, int off, int len) {
        try {
            editorFile.read(byteArray, off, len);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private static long getLongFromBytes(byte[] bytes, int offset) {
        return (long)(bytes[offset] & 0xFF) << 56 | (long)(bytes[offset + 1] & 0xFF) << 48 | (long)(bytes[offset + 2] & 0xFF) << 40 | (long)(bytes[offset + 3] & 0xFF) << 32 | (long)(bytes[offset + 4] & 0xFF) << 24 | (long)(bytes[offset + 5] & 0xFF) << 16 | (long)(bytes[offset + 6] & 0xFF) << 8 | (long)(bytes[offset + 7] & 0xFF);
    }

    private static long getIntFromBytes(byte[] bytes, int offset) {
        return (long)(bytes[offset] & 0xFF) << 24 | (long)(bytes[offset + 1] & 0xFF) << 16 | (long)(bytes[offset + 2] & 0xFF) << 8 | (long)(bytes[offset + 3] & 0xFF);
    }

    private static int getShortFromBytes(byte[] bytes, int offset) {
        return (bytes[offset] & 0xFF) << 8 | bytes[offset + 1] & 0xFF;
    }

    private static long getFilePointerFromBytes(byte[] bytes, int offset) {
        if (filePointerSize == 4) {
            return (long)(bytes[offset] & 0xFF) << 24 | (long)(bytes[offset + 1] & 0xFF) << 16 | (long)(bytes[offset + 2] & 0xFF) << 8 | (long)(bytes[offset + 3] & 0xFF);
        }
        if (filePointerSize == 6) {
            return (long)(bytes[offset] & 0xFF) << 40 | (long)(bytes[offset + 1] & 0xFF) << 32 | (long)(bytes[offset + 2] & 0xFF) << 24 | (long)(bytes[offset + 3] & 0xFF) << 16 | (long)(bytes[offset + 4] & 0xFF) << 8 | (long)(bytes[offset + 5] & 0xFF);
        }
        return -1L;
    }

    private static byte[] getKeyBlock(int keyIndex) {
        try {
            if (keyBlockCurIndex > keyIndex || keyBlockCurIndex < 0) {
                keyBlockCurIndex = 0;
                keyBlockOffset = idxHeaderSize + 2 + filePointerSize;
                keyBlockContinuationRecordNumber = 0;
            }
            return AutoLoadDCBInfo.getKeyBlock(keyBlockContinuationRecordNumber, keyBlockCurIndex, keyBlockOffset, keyIndex);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static byte[] getKeyBlock(int continuationRecordNumber, int curIndex, int offset, int keyIndex) {
        byte[] bytes = null;
        bytes = keyInfoRecords.elementAt(continuationRecordNumber);
        int end = AutoLoadDCBInfo.getShortFromBytes(bytes, idxHeaderSize) & Short.MAX_VALUE;
        while (curIndex < keyIndex && offset < end) {
            offset += AutoLoadDCBInfo.getShortFromBytes(bytes, offset);
            ++curIndex;
        }
        if (curIndex < keyIndex) {
            return AutoLoadDCBInfo.getKeyBlock(continuationRecordNumber + 1, curIndex, idxFormat == 8 ? 17 : 6, keyIndex);
        }
        keyBlockCurIndex = curIndex;
        keyBlockOffset = offset;
        keyBlockContinuationRecordNumber = continuationRecordNumber;
        return bytes;
    }

    static {
        keyOffs = new ArrayList();
        keyLens = new ArrayList();
        keyDups = new ArrayList();
        keyGroups = new ArrayList();
        minLen = 0;
        dcbLrecl = 0;
        dcbKeyOff = null;
        dcbKeylen = null;
        passCntr = 0;
        failCntr = 0;
        recursive = false;
        dcbIsFixed = false;
        dcbIsIndexed = false;
        dcbIsNumbered = false;
        dcbIsIbm1047 = false;
        editorFile = null;
        MFFILE_HEADER_LEN = 256;
        keyBlockCurIndex = -1;
        keyBlockOffset = -1;
        keyBlockContinuationRecordNumber = -1;
        filePointerSize = 4;
        idxFormat = 0;
        keyInfoRecords = null;
        MAX_SEGS = 16;
        acuIdxFileName = null;
        acuDatFileName = null;
    }
}

