/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.TreeMap;

public class DCBDBUtils {
    private static final String dcbCreateTableHeader = "CREATE TABLE \"DCBDB";
    private static String dcbTableNameExt = "";
    private static final String dcbCreateCols = "( DSNAME VARCHAR(150 ) NOT NULL PRIMARY KEY, LRECL VARCHAR(6 ), DSORG VARCHAR(5 ), ORIENTATION VARCHAR(50 ), PROTOTYPE VARCHAR(6 ), RECFM VARCHAR(5 ), RECMIN VARCHAR(6 ), RECAVG VARCHAR(6 ), CHARSET VARCHAR(50 ), BLKSIZE VARCHAR(7 ), GDG_LIMIT VARCHAR(7 ), KEYLEN VARCHAR(7 ), KEYOFF VARCHAR(7 ), ALTKEYOFFS VARCHAR(7 ), ALTKEYLENS VARCHAR(7 ), ALTKEYDUPS VARCHAR(7 ), ALTKEYGROUPS VARCHAR(20 ), LABEL VARCHAR(20 ), EXPDT VARCHAR(26 ), REUSE VARCHAR(20 ), RELATE VARCHAR(150 ), ASSOCIATES VARCHAR(150 ), PATH VARCHAR(150 ), UPDATE_USER VARCHAR(50 ), UPDATE_TS DATETIME )";

    public static void main(String[] argv) {
        if (argv.length < 4) {
            DCBDBUtils.printUsage();
            return;
        }
        String url2 = argv[0];
        String user = argv[1];
        String pass = argv[2];
        ArrayList<String> datadirsList = new ArrayList<String>();
        for (int i = 3; i < argv.length; ++i) {
            datadirsList.add(argv[i]);
        }
        String[] datadirs = datadirsList.toArray(new String[0]);
        int rowsImported = DCBDBUtils.importAllDCBFiles(url2, user, pass, datadirs);
        System.out.println("Rows imported into DCBDB table: " + rowsImported);
    }

    public static void printUsage() {
        System.out.println("usage DCBDBUtils url user password datalib[,datalib]*");
        System.out.println("  url          : String DB connection URL");
        System.out.println("  user         : String DB user ID");
        System.out.println("  pass         : String DB user password");
        System.out.println("  datalib1     : String full path to datalib1 containing .dcb files");
        System.out.println("  [,datalib(n)]: String full path to datalib(n) containing .dcb files");
        System.out.println();
        System.out.println("examples:");
        System.out.println("java DCBDBUtils jdbc:db2://localhost:50000/SAMPLE:currentSchema=TEST; myuserID myPassword C:/path1");
        System.out.println();
        System.out.println("java DCBDBUtils jdbc:db2://localhost:50000/SAMPLE:currentSchema=TEST; myuserID myPassword C:/path1 C:/path2 C:/path3 C:/path4");
    }

    public static int importDCBFile(String dcbfile, String url2, String user, String pass) {
        Connection connection = null;
        try {
            connection = DriverManager.getConnection(url2, user, pass);
        }
        catch (SQLException e) {
            System.err.println("Connection Failed! Check output console");
            e.printStackTrace();
            return -1;
        }
        if (connection == null) {
            System.err.println("Failed to make connection!");
            return -1;
        }
        return DCBDBUtils.importDCBFile(dcbfile, connection);
    }

    public static int importDCBFile(String dcbfile, Connection connection) {
        int rowsImported = 0;
        int idx = -1;
        ArrayList<String> importList = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        Properties props = new Properties();
        try {
            props.load(new FileInputStream(dcbfile));
            TreeMap<Object, Object> sortedMap = new TreeMap<Object, Object>(props);
            String keyStack = null;
            for (String propKey : sortedMap.keySet()) {
                idx = propKey.indexOf(45);
                if (idx == -1) {
                    System.err.println("Bad property key detected: " + propKey + " skipping to next key");
                    continue;
                }
                String keyPrefix = propKey.substring(0, idx);
                if (keyStack == null) {
                    keyStack = keyPrefix;
                    sb.append("dsname=");
                    sb.append(keyStack);
                    sb.append('\u001c');
                    sb.append(propKey.substring(idx + 1));
                    sb.append("=");
                    sb.append((String)sortedMap.get(propKey));
                    sb.append('\u001c');
                    continue;
                }
                if (keyStack.equals(keyPrefix)) {
                    sb.append(propKey.substring(idx + 1));
                    sb.append("=");
                    sb.append((String)sortedMap.get(propKey));
                    sb.append('\u001c');
                    continue;
                }
                importList.add(sb.toString());
                sb = new StringBuilder();
                keyStack = keyPrefix;
                sb.append("dsname=");
                sb.append(keyStack);
                sb.append('\u001c');
                sb.append(propKey.substring(idx + 1));
                sb.append("=");
                sb.append((String)sortedMap.get(propKey));
                sb.append('\u001c');
            }
            if (sb.length() > 0) {
                importList.add(sb.toString());
            }
            if (connection == null) {
                System.err.println("Failed to make connection!");
                return -1;
            }
            PreparedStatement ps = null;
            try {
                String sql = "INSERT INTO \"DCBDB" + DCBDBUtils.getDcbTableNameExt() + "\" (DSNAME, LRECL, DSORG, ORIENTATION, PROTOTYPE, RECFM, RECMIN, RECAVG, CHARSET, BLKSIZE, GDG_LIMIT, KEYLEN, KEYOFF, ALTKEYOFFS, ALTKEYLENS, ALTKEYDUPS, ALTKEYGROUPS, LABEL, EXPDT, REUSE, RELATE, ASSOCIATES, PATH, UPDATE_USER, UPDATE_TS) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                ps = connection.prepareStatement(sql);
                for (String valStr : importList) {
                    String[] parts = valStr.split("\u001c");
                    HashMap<String, String> colvalMap = new HashMap<String, String>();
                    for (String s : parts) {
                        String[] sparts = s.split("=");
                        colvalMap.put(sparts[0], sparts[1]);
                    }
                    ps.setString(1, (String)colvalMap.get("dsname"));
                    ps.setString(2, (String)colvalMap.get("lrecl"));
                    ps.setString(3, (String)colvalMap.get("dsorg"));
                    ps.setString(4, (String)colvalMap.get("orient"));
                    ps.setString(5, (String)colvalMap.get("proto"));
                    ps.setString(6, (String)colvalMap.get("recfm"));
                    ps.setString(7, (String)colvalMap.get("recmin"));
                    ps.setString(8, (String)colvalMap.get("recavg"));
                    ps.setString(9, (String)colvalMap.get("charset"));
                    ps.setString(10, (String)colvalMap.get("blksize"));
                    ps.setString(11, (String)colvalMap.get("limit"));
                    ps.setString(12, (String)colvalMap.get("keylen"));
                    ps.setString(13, (String)colvalMap.get("keyoff"));
                    ps.setString(14, (String)colvalMap.get("altkeyoffs"));
                    ps.setString(15, (String)colvalMap.get("altkeylens"));
                    ps.setString(16, (String)colvalMap.get("altkeydups"));
                    ps.setString(17, (String)colvalMap.get("altkeygroups"));
                    ps.setString(18, (String)colvalMap.get("label"));
                    ps.setString(19, (String)colvalMap.get("expdt"));
                    ps.setString(20, (String)colvalMap.get("reuse"));
                    ps.setString(21, (String)colvalMap.get("relate"));
                    ps.setString(22, (String)colvalMap.get("associates"));
                    ps.setString(23, (String)colvalMap.get("path"));
                    ps.setString(24, "DcbUtils");
                    ps.setTimestamp(25, Timestamp.valueOf(LocalDateTime.now()));
                    rowsImported += ps.executeUpdate();
                }
                ps.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
                return rowsImported;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return rowsImported;
    }

    public static int importGDGDCBFile(String dcbfile, String url2, String user, String pass) {
        Connection connection = null;
        try {
            connection = DriverManager.getConnection(url2, user, pass);
        }
        catch (SQLException e) {
            System.err.println("Connection Failed! Check output console");
            e.printStackTrace();
            return -1;
        }
        if (connection == null) {
            System.err.println("Failed to make connection!");
            return -1;
        }
        return DCBDBUtils.importGDGDCBFile(dcbfile, connection);
    }

    public static int importGDGDCBFile(String dcbfile, Connection connection) {
        int rowsImported = 0;
        int idx = -1;
        File gdgDCB = new File(dcbfile);
        String gdgBase = gdgDCB.getParentFile().getName();
        ArrayList<String> importList = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        Properties props = new Properties();
        try {
            props.load(new FileInputStream(dcbfile));
            TreeMap<Object, Object> sortedMap = new TreeMap<Object, Object>(props);
            if (!"GDG".equalsIgnoreCase((String)sortedMap.get(gdgBase + "-dsorg"))) {
                for (Object propKey : sortedMap.keySet()) {
                    if (!((String)propKey).endsWith("-dsorg") || !"GDG".equalsIgnoreCase((String)sortedMap.get(propKey))) continue;
                    gdgBase = ((String)propKey).replaceAll("-dsorg", "");
                    break;
                }
            }
            String keyStack = null;
            for (String propKey : sortedMap.keySet()) {
                idx = propKey.indexOf(45);
                if (idx == -1) {
                    System.err.println("Bad property key detected: " + propKey + " skipping to next key");
                    continue;
                }
                String keyPrefix = propKey.substring(0, idx);
                if (keyStack == null) {
                    keyStack = keyPrefix;
                    sb.append("dsname=");
                    if (keyStack.equals(gdgBase)) {
                        sb.append(keyStack);
                    } else {
                        sb.append(gdgBase + "." + keyStack);
                    }
                    sb.append('\u001c');
                    sb.append(propKey.substring(idx + 1));
                    sb.append("=");
                    sb.append((String)sortedMap.get(propKey));
                    sb.append('\u001c');
                    continue;
                }
                if (keyStack.equals(keyPrefix)) {
                    sb.append(propKey.substring(idx + 1));
                    sb.append("=");
                    sb.append((String)sortedMap.get(propKey));
                    sb.append('\u001c');
                    continue;
                }
                importList.add(sb.toString());
                sb = new StringBuilder();
                keyStack = keyPrefix;
                sb.append("dsname=");
                if (keyStack.equals(gdgBase)) {
                    sb.append(keyStack);
                } else {
                    sb.append(gdgBase + "." + keyStack);
                }
                sb.append('\u001c');
                sb.append(propKey.substring(idx + 1));
                sb.append("=");
                sb.append((String)sortedMap.get(propKey));
                sb.append('\u001c');
            }
            if (sb.length() > 0) {
                importList.add(sb.toString());
            }
            if (connection == null) {
                System.err.println("Failed to make connection!");
                return -1;
            }
            PreparedStatement ps = null;
            try {
                String sql = "INSERT INTO \"DCBDB" + DCBDBUtils.getDcbTableNameExt() + "\" (DSNAME, LRECL, DSORG, ORIENTATION, PROTOTYPE, RECFM, RECMIN, RECAVG, CHARSET, BLKSIZE, GDG_LIMIT, KEYLEN, KEYOFF, ALTKEYOFFS, ALTKEYLENS, ALTKEYDUPS, ALTKEYGROUPS, LABEL, EXPDT, REUSE, RELATE, ASSOCIATES, PATH, UPDATE_USER, UPDATE_TS) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                ps = connection.prepareStatement(sql);
                for (String valStr : importList) {
                    String[] parts = valStr.split("\u001c");
                    HashMap<String, String> colvalMap = new HashMap<String, String>();
                    for (String s : parts) {
                        String[] sparts = s.split("=");
                        colvalMap.put(sparts[0], sparts[1]);
                    }
                    ps.setString(1, (String)colvalMap.get("dsname"));
                    ps.setString(2, (String)colvalMap.get("lrecl"));
                    ps.setString(3, (String)colvalMap.get("dsorg"));
                    ps.setString(4, (String)colvalMap.get("orient"));
                    ps.setString(5, (String)colvalMap.get("proto"));
                    ps.setString(6, (String)colvalMap.get("recfm"));
                    ps.setString(7, (String)colvalMap.get("recmin"));
                    ps.setString(8, (String)colvalMap.get("recavg"));
                    ps.setString(9, (String)colvalMap.get("charset"));
                    ps.setString(10, (String)colvalMap.get("blksize"));
                    ps.setString(11, (String)colvalMap.get("limit"));
                    ps.setString(12, (String)colvalMap.get("keylen"));
                    ps.setString(13, (String)colvalMap.get("keyoff"));
                    ps.setString(14, (String)colvalMap.get("altkeyoffs"));
                    ps.setString(15, (String)colvalMap.get("altkeylens"));
                    ps.setString(16, (String)colvalMap.get("altkeydups"));
                    ps.setString(17, (String)colvalMap.get("altkeygroups"));
                    ps.setString(18, (String)colvalMap.get("label"));
                    ps.setString(19, (String)colvalMap.get("expdt"));
                    ps.setString(20, (String)colvalMap.get("reuse"));
                    ps.setString(21, (String)colvalMap.get("relate"));
                    ps.setString(22, (String)colvalMap.get("associates"));
                    ps.setString(23, (String)colvalMap.get("path"));
                    ps.setString(24, "DcbUtils");
                    ps.setTimestamp(25, Timestamp.valueOf(LocalDateTime.now()));
                    rowsImported += ps.executeUpdate();
                }
                ps.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
                return rowsImported;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return rowsImported;
    }

    public static int importAnyDCBFile(String dcbfile, String url2, String user, String pass) {
        Connection connection = null;
        try {
            connection = DriverManager.getConnection(url2, user, pass);
        }
        catch (SQLException e) {
            System.err.println("Connection Failed! Check output console");
            e.printStackTrace();
            return -1;
        }
        if (connection == null) {
            System.err.println("Failed to make connection!");
            return -1;
        }
        return DCBDBUtils.importAnyDCBFile(dcbfile, connection);
    }

    public static int importAnyDCBFile(String dcbfile, Connection connection) {
        int rowsImported = 0;
        int idx = -1;
        File gdgDCB = new File(dcbfile);
        File gdgDCBPath = gdgDCB.getParentFile();
        String gdgBase = gdgDCBPath != null ? gdgDCBPath.getName() : null;
        String gdgPath = gdgDCBPath != null ? gdgDCBPath.getAbsolutePath() : null;
        System.out.println();
        System.out.println("dcb Path=" + gdgPath);
        boolean isGDG = false;
        ArrayList<String> importList = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        Properties props = new Properties();
        try {
            props.load(new FileInputStream(dcbfile));
            TreeMap<Object, Object> sortedMap = new TreeMap<Object, Object>(props);
            for (Object propKey : sortedMap.keySet()) {
                String[] fileNames;
                Object object;
                int n;
                int n2;
                if (!((String)propKey).endsWith("-dsorg")) continue;
                String propKeyPrefix = ((String)propKey).replaceAll("-dsorg", "");
                if (!"PS".equalsIgnoreCase((String)sortedMap.get(propKey)) || !propKeyPrefix.equalsIgnoreCase(gdgBase) || (n2 = 0) >= (n = ((String[])(object = (fileNames = gdgDCBPath.list(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return !name.matches("\\.dcb");
                    }
                })))).length)) continue;
                String f = object[n2];
                if (f.matches("G[0-9]{4}V00")) {
                    sortedMap.put(propKey, "GDG");
                    continue;
                }
                sortedMap.put(propKey, "PO");
            }
            if ("GDG".equalsIgnoreCase((String)sortedMap.get(gdgBase + "-dsorg")) || "PO".equalsIgnoreCase((String)sortedMap.get(gdgBase + "-dsorg"))) {
                isGDG = true;
            } else {
                for (Object propKey : sortedMap.keySet()) {
                    if (!((String)propKey).endsWith("-dsorg") || !"GDG".equalsIgnoreCase((String)sortedMap.get(propKey)) && !"PO".equalsIgnoreCase((String)sortedMap.get(propKey))) continue;
                    gdgBase = ((String)propKey).replaceAll("-dsorg", "");
                    isGDG = true;
                    break;
                }
                if (!isGDG) {
                    gdgBase = null;
                }
            }
            String keyStack = null;
            for (String propKey : sortedMap.keySet()) {
                idx = propKey.indexOf(45);
                if (idx == -1) {
                    System.err.println("Bad property key detected: " + propKey + " skipping to next key");
                    continue;
                }
                String keyPrefix = propKey.substring(0, idx);
                if (keyStack == null) {
                    keyStack = keyPrefix;
                    sb.append("dsname=");
                    if (gdgBase == null) {
                        sb.append(keyStack);
                    } else if (keyStack.equals(gdgBase)) {
                        sb.append(keyStack);
                    } else {
                        sb.append(gdgBase + "." + keyStack);
                    }
                    sb.append('\u001c');
                    sb.append(propKey.substring(idx + 1));
                    sb.append("=");
                    sb.append((String)sortedMap.get(propKey));
                    sb.append('\u001c');
                    continue;
                }
                if (keyStack.equals(keyPrefix)) {
                    sb.append(propKey.substring(idx + 1));
                    sb.append("=");
                    sb.append((String)sortedMap.get(propKey));
                    sb.append('\u001c');
                    continue;
                }
                importList.add(sb.toString());
                sb = new StringBuilder();
                keyStack = keyPrefix;
                sb.append("dsname=");
                if (gdgBase == null) {
                    sb.append(keyStack);
                } else if (keyStack.equals(gdgBase)) {
                    sb.append(keyStack);
                } else {
                    sb.append(gdgBase + "." + keyStack);
                }
                sb.append('\u001c');
                sb.append(propKey.substring(idx + 1));
                sb.append("=");
                sb.append((String)sortedMap.get(propKey));
                sb.append('\u001c');
            }
            if (sb.length() > 0) {
                importList.add(sb.toString());
            }
            if (connection == null) {
                System.err.println("Failed to make connection!");
                return -1;
            }
            HashMap<String, String> lastColvalMap = null;
            String sql = null;
            Statement ps = null;
            sql = "INSERT INTO \"DCBDB" + DCBDBUtils.getDcbTableNameExt() + "\" (DSNAME, LRECL, DSORG, ORIENTATION, PROTOTYPE, RECFM, RECMIN, RECAVG, CHARSET, BLKSIZE, GDG_LIMIT, KEYLEN, KEYOFF, ALTKEYOFFS, ALTKEYLENS, ALTKEYDUPS, ALTKEYGROUPS, LABEL, EXPDT, REUSE, RELATE, ASSOCIATES, PATH, UPDATE_USER, UPDATE_TS) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            for (String valStr : importList) {
                String[] parts = valStr.split("\u001c");
                HashMap<String, String> colvalMap = new HashMap<String, String>();
                for (String s : parts) {
                    String[] sparts = s.split("=");
                    colvalMap.put(sparts[0], sparts[1]);
                }
                lastColvalMap = colvalMap;
                try {
                    if (ps != null) {
                        if (ps.isClosed()) {
                            connection.prepareStatement(sql);
                        }
                    } else {
                        ps = connection.prepareStatement(sql);
                    }
                    ps.setString(1, (String)colvalMap.get("dsname"));
                    ps.setString(2, (String)colvalMap.get("lrecl"));
                    ps.setString(3, (String)colvalMap.get("dsorg"));
                    ps.setString(4, (String)colvalMap.get("orient"));
                    ps.setString(5, (String)colvalMap.get("proto"));
                    ps.setString(6, (String)colvalMap.get("recfm"));
                    ps.setString(7, (String)colvalMap.get("recmin"));
                    ps.setString(8, (String)colvalMap.get("recavg"));
                    ps.setString(9, (String)colvalMap.get("charset"));
                    ps.setString(10, (String)colvalMap.get("blksize"));
                    ps.setString(11, (String)colvalMap.get("limit"));
                    ps.setString(12, (String)colvalMap.get("keylen"));
                    ps.setString(13, (String)colvalMap.get("keyoff"));
                    ps.setString(14, (String)colvalMap.get("altkeyoffs"));
                    ps.setString(15, (String)colvalMap.get("altkeylens"));
                    ps.setString(16, (String)colvalMap.get("altkeydups"));
                    ps.setString(17, (String)colvalMap.get("altkeygroups"));
                    ps.setString(18, (String)colvalMap.get("label"));
                    ps.setString(19, (String)colvalMap.get("expdt"));
                    ps.setString(20, (String)colvalMap.get("reuse"));
                    ps.setString(21, (String)colvalMap.get("relate"));
                    ps.setString(22, (String)colvalMap.get("associates"));
                    ps.setString(23, (String)colvalMap.get("path"));
                    ps.setString(24, "DcbUtils");
                    ps.setTimestamp(25, Timestamp.valueOf(LocalDateTime.now()));
                    System.out.println();
                    System.out.println(String.format(sql.replaceAll("\\?", "%s"), lastColvalMap.get("dsname"), lastColvalMap.get("lrecl"), lastColvalMap.get("dsorg"), lastColvalMap.get("orient"), lastColvalMap.get("proto"), lastColvalMap.get("recfm"), lastColvalMap.get("recmin"), lastColvalMap.get("recavg"), lastColvalMap.get("charset"), lastColvalMap.get("blksize"), lastColvalMap.get("limit"), lastColvalMap.get("keylen"), lastColvalMap.get("keyoff"), lastColvalMap.get("altkeyoffs"), lastColvalMap.get("altkeylens"), lastColvalMap.get("altkeydups"), lastColvalMap.get("altkeygroups"), lastColvalMap.get("label"), lastColvalMap.get("expdt"), lastColvalMap.get("reuse"), lastColvalMap.get("relate"), lastColvalMap.get("associates"), lastColvalMap.get("path"), "DcbUtils", LocalDateTime.now()));
                    rowsImported += ps.executeUpdate();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            try {
                ps.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return rowsImported;
    }

    public static int importAllDCBFiles(String url2, String user, String pass, String[] datadirs) {
        DCBDBUtils.createDCBDB(url2, user, pass);
        return DCBDBUtils.importAllDCBFiles(datadirs, url2, user, pass);
    }

    public static int importAllDCBFiles(String[] datadirs, String url2, String user, String pass) {
        int rowsImported = 0;
        for (String datadir : datadirs) {
            File root = new File(datadir);
            rowsImported += DCBDBUtils.processFilesRecursive(root, url2, user, pass);
        }
        return rowsImported;
    }

    private static int processFilesRecursive(File pFile, String url2, String user, String pass) {
        int rowsImported = 0;
        for (File file2 : pFile.listFiles()) {
            if (file2.isDirectory()) {
                rowsImported += DCBDBUtils.processFilesRecursive(file2, url2, user, pass);
                continue;
            }
            if (!".dcb".equalsIgnoreCase(file2.getName())) continue;
            rowsImported += DCBDBUtils.importAnyDCBFile(file2.getAbsolutePath(), url2, user, pass);
        }
        return rowsImported;
    }

    public static void createDCBDB(String url2, String user, String pass) {
        System.setProperty("dcb.db.url", url2);
        System.setProperty("dcb.db.user", user);
        System.setProperty("dcb.db.pass", pass);
        DCBDBUtils.createDCBDB();
    }

    public static void createDCBDB(String url2, String user, String pass, String driver) {
        System.setProperty("dcb.db.url", url2);
        System.setProperty("dcb.db.user", user);
        System.setProperty("dcb.db.pass", pass);
        System.setProperty("dcb.db.driver", driver);
        DCBDBUtils.createDCBDB();
    }

    public static void createDCBDB(String url2, String user, String pass, String driver, String table) {
        System.setProperty("dcb.db.url", url2);
        System.setProperty("dcb.db.user", user);
        System.setProperty("dcb.db.pass", pass);
        System.setProperty("dcb.db.driver", driver);
        System.setProperty("dcb.db.table", table);
        DCBDBUtils.createDCBDB();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createDCBDB() {
        String url2 = System.getProperty("dcb.db.url");
        String user = System.getProperty("dcb.db.user");
        String pass = System.getProperty("dcb.db.pass");
        String driver = System.getProperty("dcb.db.driver");
        String tableExt = System.getProperty("dcb.db.table");
        Connection connection = null;
        Statement stmt = null;
        try {
            if (driver != null) {
                Class.forName(driver);
            }
            if ((connection = DriverManager.getConnection(url2, user, pass)) != null) {
                if (tableExt != null) {
                    DCBDBUtils.setDcbTableNameExt(tableExt);
                }
                DatabaseMetaData dbmd = connection.getMetaData();
                ResultSet mdrs = dbmd.getTables(null, connection.getSchema(), "DCBDB" + dcbTableNameExt, new String[]{"TABLE"});
                if (!mdrs.next()) {
                    String sql = dcbCreateTableHeader + dcbTableNameExt + "\"" + dcbCreateCols;
                    if (System.getProperty("dcb.db.url").toLowerCase().contains("postgresql")) {
                        sql = dcbCreateTableHeader + dcbTableNameExt + "\"" + "( DSNAME VARCHAR(150 ) NOT NULL PRIMARY KEY, LRECL VARCHAR(6 ), DSORG VARCHAR(5 ), ORIENTATION VARCHAR(50 ), PROTOTYPE VARCHAR(6 ), RECFM VARCHAR(5 ), RECMIN VARCHAR(6 ), RECAVG VARCHAR(6 ), CHARSET VARCHAR(50 ), BLKSIZE VARCHAR(7 ), GDG_LIMIT VARCHAR(7 ), KEYLEN VARCHAR(7 ), KEYOFF VARCHAR(7 ), ALTKEYOFFS VARCHAR(7 ), ALTKEYLENS VARCHAR(7 ), ALTKEYDUPS VARCHAR(7 ), ALTKEYGROUPS VARCHAR(20 ), LABEL VARCHAR(20 ), EXPDT VARCHAR(26 ), REUSE VARCHAR(20 ), RELATE VARCHAR(150 ), ASSOCIATES VARCHAR(150 ), PATH VARCHAR(150 ), UPDATE_USER VARCHAR(50 ), UPDATE_TS TIMESTAMP )";
                    }
                    stmt = connection.createStatement();
                    stmt.executeUpdate(sql);
                }
            } else {
                System.err.println("Connection Failed! Check output console");
            }
        }
        catch (SQLException e) {
            System.err.println("DCBFactory->setupDCBDB()" + e.getMessage());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {}
        }
    }

    public static String getDcbTableNameExt() {
        return dcbTableNameExt;
    }

    public static void setDcbTableNameExt(String dcbTableNameExt) {
        DCBDBUtils.dcbTableNameExt = dcbTableNameExt;
    }
}

