/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;

public class IntervalMap<K, V>
extends AbstractMap<K, V>
implements NavigableMap<K, V>,
Cloneable,
Serializable {
    private final Comparator<? super K> comparator;
    private final Comparator<? super K> maxComparator;
    private final Comparator<? super K> overlapComparator;
    private final Comparator<? super K> extentComparator;
    private transient Entry<K, V> root = null;
    private transient int size = 0;
    private transient int modCount = 0;
    private transient EntrySet entrySet = null;
    private transient KeySet<K> navigableKeySet = null;
    private transient NavigableMap<K, V> descendingMap = null;
    private static final Object UNBOUNDED = new Object();
    private static final boolean RED = false;
    private static final boolean BLACK = true;
    private static final long serialVersionUID = 919286545866124006L;

    public IntervalMap() {
        this.comparator = null;
        this.extentComparator = null;
        this.overlapComparator = null;
        this.maxComparator = null;
    }

    public IntervalMap(Comparator<? super K> comparator) {
        this.comparator = comparator;
        this.extentComparator = null;
        this.overlapComparator = null;
        this.maxComparator = null;
    }

    public IntervalMap(Comparator<? super K> comparator, Comparator<? super K> maxComparator) {
        this.comparator = comparator;
        this.maxComparator = maxComparator;
        this.extentComparator = null;
        this.overlapComparator = null;
    }

    public IntervalMap(Comparator<? super K> comparator, Comparator<? super K> maxComparator, Comparator<? super K> overlapComparator) {
        this.comparator = comparator;
        this.maxComparator = maxComparator;
        this.overlapComparator = overlapComparator;
        this.extentComparator = null;
    }

    public IntervalMap(Comparator<? super K> comparator, Comparator<? super K> maxComparator, Comparator<? super K> overlapComparator, Comparator<? super K> extentComparator) {
        this.comparator = comparator;
        this.maxComparator = maxComparator;
        this.overlapComparator = overlapComparator;
        this.extentComparator = extentComparator;
    }

    public IntervalMap(Map<? extends K, ? extends V> m) {
        this.comparator = null;
        this.extentComparator = null;
        this.overlapComparator = null;
        this.maxComparator = null;
        this.putAll(m);
    }

    public IntervalMap(SortedMap<K, ? extends V> m) {
        this.comparator = m.comparator();
        this.extentComparator = null;
        this.overlapComparator = null;
        this.maxComparator = null;
        try {
            this.buildFromSorted(m.size(), m.entrySet().iterator(), null, null);
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public IntervalMap(IntervalMap<K, ? extends V> m) {
        this.comparator = m.comparator();
        this.maxComparator = m.maxComparator();
        this.overlapComparator = m.overlapComparator();
        this.extentComparator = m.extentComparator();
        try {
            this.buildFromSorted(m.size(), m.entrySet().iterator(), null, null);
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getEntry(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        Entry<K, V> e = this.getFirstEntry();
        while (e != null) {
            if (IntervalMap.valEquals(value, e.value)) {
                return true;
            }
            e = IntervalMap.successor(e);
        }
        return false;
    }

    @Override
    public V get(Object key) {
        Entry<K, V> p = this.getEntry(key);
        return p == null ? null : (V)p.value;
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.comparator;
    }

    public Comparator<? super K> maxComparator() {
        return this.maxComparator;
    }

    public Comparator<? super K> overlapComparator() {
        return this.overlapComparator;
    }

    public Comparator<? super K> extentComparator() {
        return this.extentComparator;
    }

    @Override
    public K firstKey() {
        return IntervalMap.key(this.getFirstEntry());
    }

    @Override
    public K lastKey() {
        return IntervalMap.key(this.getLastEntry());
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        Comparator c;
        int mapSize = map.size();
        if (this.size == 0 && mapSize != 0 && map instanceof SortedMap && ((c = ((SortedMap)map).comparator()) == this.comparator || c != null && c.equals(this.comparator))) {
            ++this.modCount;
            try {
                this.buildFromSorted(mapSize, map.entrySet().iterator(), null, null);
            }
            catch (IOException iOException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return;
        }
        super.putAll(map);
    }

    final Entry<K, V> getEntry(Object key) {
        if (this.comparator != null) {
            return this.getEntryUsingComparator(key);
        }
        if (key == null) {
            throw new NullPointerException();
        }
        Comparable k = (Comparable)key;
        Entry<K, V> p = this.root;
        while (p != null) {
            int cmp = k.compareTo(p.key);
            if (cmp < 0) {
                p = p.left;
                continue;
            }
            if (cmp > 0) {
                p = p.right;
                continue;
            }
            return p;
        }
        return null;
    }

    final Entry<K, V> getEntryUsingComparator(Object key) {
        Object k = key;
        Comparator<K> cpr = this.comparator;
        if (cpr != null) {
            Entry<K, V> p = this.root;
            while (p != null) {
                int cmp = cpr.compare(k, p.key);
                if (cmp < 0) {
                    p = p.left;
                    continue;
                }
                if (cmp > 0) {
                    p = p.right;
                    continue;
                }
                return p;
            }
        }
        return null;
    }

    final Entry<K, V> getCeilingEntry(K key) {
        Entry<K, V> p = this.root;
        while (p != null) {
            int cmp;
            if (p.left != null && (cmp = this.extentCompare(key, p.left.max)) <= 0) {
                p = p.left;
                continue;
            }
            cmp = this.overlapCompare(key, p.key);
            if (cmp == 0) {
                return p;
            }
            if (p.right != null && (cmp = this.extentCompare(key, p.right.max)) <= 0) {
                p = p.right;
                continue;
            }
            return p;
        }
        return null;
    }

    final Entry<K, V> getFloorEntry(K key) {
        Entry<K, V> p = this.root;
        while (p != null) {
            int cmp = this.overlapCompare(key, p.key);
            if (cmp > 0) {
                if (p.right != null) {
                    p = p.right;
                    continue;
                }
                return p;
            }
            if (cmp < 0) {
                if (p.left != null) {
                    p = p.left;
                    continue;
                }
                Entry parent = p.parent;
                Entry<K, V> ch = p;
                while (parent != null && ch == parent.left) {
                    ch = parent;
                    parent = parent.parent;
                }
                return parent;
            }
            if (p.right != null && this.maxCompare(key, p.right.max) <= 0) {
                p = p.right;
                continue;
            }
            return p;
        }
        return null;
    }

    final Entry<K, V> getHigherEntry(K key) {
        Entry<K, V> p = this.root;
        while (p != null) {
            int cmp = this.overlapCompare(key, p.key);
            if (cmp < 0) {
                if (p.left != null) {
                    p = p.left;
                    continue;
                }
                return p;
            }
            if (p.right != null) {
                p = p.right;
                continue;
            }
            Entry parent = p.parent;
            Entry<K, V> ch = p;
            while (parent != null && ch == parent.right) {
                ch = parent;
                parent = parent.parent;
            }
            return parent;
        }
        return null;
    }

    final Entry<K, V> getLowerEntry(K key) {
        Entry<K, V> p = this.root;
        while (p != null) {
            int cmp = this.overlapCompare(key, p.key);
            if (cmp > 0) {
                if (p.right != null) {
                    p = p.right;
                    continue;
                }
                return p;
            }
            if (p.left != null) {
                p = p.left;
                continue;
            }
            Entry parent = p.parent;
            Entry<K, V> ch = p;
            while (parent != null && ch == parent.left) {
                ch = parent;
                parent = parent.parent;
            }
            return parent;
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        int cmp;
        Entry<K, V> parent;
        Entry<K, V> t = this.root;
        if (t == null) {
            this.compare(key, key);
            this.root = new Entry<K, V>(key, key, value, null);
            this.size = 1;
            ++this.modCount;
            return null;
        }
        Comparator<K> cpr = this.comparator;
        if (cpr != null) {
            do {
                parent = t;
                cmp = cpr.compare(key, t.key);
                if (cmp < 0) {
                    t = t.left;
                    continue;
                }
                if (cmp > 0) {
                    t = t.right;
                    continue;
                }
                return t.setValue(value);
            } while (t != null);
        } else {
            if (key == null) {
                throw new NullPointerException();
            }
            Comparable k = (Comparable)key;
            do {
                parent = t;
                cmp = k.compareTo(t.key);
                if (cmp < 0) {
                    t = t.left;
                    continue;
                }
                if (cmp > 0) {
                    t = t.right;
                    continue;
                }
                return t.setValue(value);
            } while (t != null);
        }
        Entry<K, V> e = new Entry<K, V>(key, key, value, parent);
        if (cmp < 0) {
            parent.left = e;
        } else {
            parent.right = e;
        }
        t = parent;
        Comparator<K> mCpr = this.maxComparator;
        if (mCpr != null) {
            while ((cmp = mCpr.compare(key, t.max)) > 0) {
                t.max = key;
                t = t.parent;
                if (t != null) continue;
                break;
            }
        } else {
            Comparable k = (Comparable)key;
            while ((cmp = k.compareTo(t.max)) > 0) {
                t.max = key;
                t = t.parent;
                if (t != null) continue;
            }
        }
        this.fixAfterInsertion(e);
        ++this.size;
        ++this.modCount;
        return null;
    }

    @Override
    public V remove(Object key) {
        Entry<K, V> p = this.getEntry(key);
        if (p == null) {
            return null;
        }
        Object oldValue = p.value;
        this.deleteEntry(p);
        return oldValue;
    }

    @Override
    public void clear() {
        ++this.modCount;
        this.size = 0;
        this.root = null;
    }

    @Override
    public Object clone() {
        IntervalMap clone = null;
        try {
            clone = (IntervalMap)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        clone.root = null;
        clone.size = 0;
        clone.modCount = 0;
        clone.entrySet = null;
        clone.navigableKeySet = null;
        clone.descendingMap = null;
        try {
            clone.buildFromSorted(this.size, this.entrySet().iterator(), null, null);
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return clone;
    }

    @Override
    public Map.Entry<K, V> firstEntry() {
        return IntervalMap.exportEntry(this.getFirstEntry());
    }

    @Override
    public Map.Entry<K, V> lastEntry() {
        return IntervalMap.exportEntry(this.getLastEntry());
    }

    @Override
    public Map.Entry<K, V> pollFirstEntry() {
        Entry<K, V> p = this.getFirstEntry();
        Map.Entry<K, V> result = IntervalMap.exportEntry(p);
        if (p != null) {
            this.deleteEntry(p);
        }
        return result;
    }

    @Override
    public Map.Entry<K, V> pollLastEntry() {
        Entry<K, V> p = this.getLastEntry();
        Map.Entry<K, V> result = IntervalMap.exportEntry(p);
        if (p != null) {
            this.deleteEntry(p);
        }
        return result;
    }

    @Override
    public Map.Entry<K, V> lowerEntry(K key) {
        return IntervalMap.exportEntry(this.getLowerEntry(key));
    }

    @Override
    public K lowerKey(K key) {
        return IntervalMap.keyOrNull(this.getLowerEntry(key));
    }

    @Override
    public Map.Entry<K, V> floorEntry(K key) {
        return IntervalMap.exportEntry(this.getFloorEntry(key));
    }

    @Override
    public K floorKey(K key) {
        return IntervalMap.keyOrNull(this.getFloorEntry(key));
    }

    @Override
    public Map.Entry<K, V> ceilingEntry(K key) {
        return IntervalMap.exportEntry(this.getCeilingEntry(key));
    }

    @Override
    public K ceilingKey(K key) {
        return IntervalMap.keyOrNull(this.getCeilingEntry(key));
    }

    @Override
    public Map.Entry<K, V> higherEntry(K key) {
        return IntervalMap.exportEntry(this.getHigherEntry(key));
    }

    @Override
    public K higherKey(K key) {
        return IntervalMap.keyOrNull(this.getHigherEntry(key));
    }

    @Override
    public Set<K> keySet() {
        return this.navigableKeySet();
    }

    @Override
    public NavigableSet<K> navigableKeySet() {
        KeySet<K> nks = this.navigableKeySet;
        return nks != null ? nks : (this.navigableKeySet = new KeySet(this));
    }

    @Override
    public NavigableSet<K> descendingKeySet() {
        return this.descendingMap().navigableKeySet();
    }

    @Override
    public Collection<V> values() {
        return super.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    @Override
    public NavigableMap<K, V> descendingMap() {
        NavigableMap<K, V> km = this.descendingMap;
        return km != null ? km : (this.descendingMap = new DescendingOverlapMap(this, true, null, true, true, null, true));
    }

    public NavigableMap<K, V> overlapMap(K theKey) {
        return new AscendingOverlapMap(this, false, theKey, true, false, theKey, true);
    }

    @Override
    public NavigableMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        return new AscendingOverlapMap(this, false, fromKey, fromInclusive, false, toKey, toInclusive);
    }

    @Override
    public NavigableMap<K, V> headMap(K toKey, boolean inclusive) {
        return new AscendingOverlapMap(this, true, null, true, false, toKey, inclusive);
    }

    @Override
    public NavigableMap<K, V> tailMap(K fromKey, boolean inclusive) {
        return new AscendingOverlapMap(this, false, fromKey, inclusive, true, null, true);
    }

    @Override
    public SortedMap<K, V> subMap(K fromKey, K toKey) {
        return this.subMap(fromKey, true, toKey, false);
    }

    @Override
    public SortedMap<K, V> headMap(K toKey) {
        return this.headMap(toKey, false);
    }

    @Override
    public SortedMap<K, V> tailMap(K fromKey) {
        return this.tailMap(fromKey, true);
    }

    Iterator<K> keyIterator() {
        return new KeyIterator(this.getFirstEntry());
    }

    Iterator<K> descendingKeyIterator() {
        return new DescendingKeyIterator(this.getLastEntry());
    }

    final int compare(Object k1, Object k2) {
        return this.comparator == null ? ((Comparable)k1).compareTo(k2) : this.comparator.compare(k1, k2);
    }

    final int maxCompare(Object k1, Object k2) {
        return this.maxComparator == null ? ((Comparable)k1).compareTo(k2) : this.maxComparator.compare(k1, k2);
    }

    final int overlapCompare(Object k1, Object k2) {
        return this.overlapComparator == null ? ((Comparable)k1).compareTo(k2) : this.overlapComparator.compare(k1, k2);
    }

    final int extentCompare(Object k1, Object k2) {
        return this.extentComparator == null ? ((Comparable)k1).compareTo(k2) : this.extentComparator.compare(k1, k2);
    }

    static final boolean valEquals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    static <K, V> Map.Entry<K, V> exportEntry(Entry<K, V> e) {
        return e == null ? null : new AbstractMap.SimpleImmutableEntry<K, V>(e);
    }

    static <K, V> K keyOrNull(Entry<K, V> e) {
        return e == null ? null : (K)e.key;
    }

    static <K> K key(Entry<K, ?> e) {
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e.key;
    }

    final Entry<K, V> getFirstEntry() {
        Entry<K, V> p = this.root;
        if (p != null) {
            while (p.left != null) {
                p = p.left;
            }
        }
        return p;
    }

    final Entry<K, V> getLastEntry() {
        Entry<K, V> p = this.root;
        if (p != null) {
            while (p.right != null) {
                p = p.right;
            }
        }
        return p;
    }

    static <K, V> Entry<K, V> successor(Entry<K, V> t) {
        if (t == null) {
            return null;
        }
        if (t.right != null) {
            Entry p = t.right;
            while (p.left != null) {
                p = p.left;
            }
            return p;
        }
        Entry p = t.parent;
        Entry<K, V> ch = t;
        while (p != null && ch == p.right) {
            ch = p;
            p = p.parent;
        }
        return p;
    }

    static <K, V> Entry<K, V> predecessor(Entry<K, V> t) {
        if (t == null) {
            return null;
        }
        if (t.left != null) {
            Entry p = t.left;
            while (p.right != null) {
                p = p.right;
            }
            return p;
        }
        Entry p = t.parent;
        Entry<K, V> ch = t;
        while (p != null && ch == p.left) {
            ch = p;
            p = p.parent;
        }
        return p;
    }

    private static <K, V> boolean colorOf(Entry<K, V> p) {
        return p == null ? true : p.color;
    }

    private static <K, V> Entry<K, V> parentOf(Entry<K, V> p) {
        return p == null ? null : p.parent;
    }

    private static <K, V> void setColor(Entry<K, V> p, boolean c) {
        if (p != null) {
            p.color = c;
        }
    }

    private static <K, V> Entry<K, V> leftOf(Entry<K, V> p) {
        return p == null ? null : p.left;
    }

    private static <K, V> Entry<K, V> rightOf(Entry<K, V> p) {
        return p == null ? null : p.right;
    }

    private void rotateLeft(Entry<K, V> p) {
        if (p != null) {
            Entry r = p.right;
            p.right = r.left;
            if (r.left != null) {
                r.left.parent = p;
            }
            r.parent = p.parent;
            if (p.parent == null) {
                this.root = r;
            } else if (p.parent.left == p) {
                p.parent.left = r;
            } else {
                p.parent.right = r;
            }
            r.left = p;
            p.parent = r;
            Comparator<K> mCpr = this.maxComparator;
            if (mCpr != null) {
                p.max = p.key;
                if (p.right != null && mCpr.compare(p.right.max, p.max) > 0) {
                    p.max = p.right.max;
                }
                if (p.left != null && mCpr.compare(p.left.max, p.max) > 0) {
                    p.max = p.left.max;
                }
                r.max = r.key;
                if (r.left != null && mCpr.compare(r.left.max, r.max) > 0) {
                    r.max = r.left.max;
                }
                if (r.right != null && mCpr.compare(r.right.max, r.max) > 0) {
                    r.max = r.right.max;
                }
            }
        }
    }

    private void rotateRight(Entry<K, V> p) {
        if (p != null) {
            Entry l = p.left;
            p.left = l.right;
            if (l.right != null) {
                l.right.parent = p;
            }
            l.parent = p.parent;
            if (p.parent == null) {
                this.root = l;
            } else if (p.parent.right == p) {
                p.parent.right = l;
            } else {
                p.parent.left = l;
            }
            l.right = p;
            p.parent = l;
            Comparator<K> mCpr = this.maxComparator;
            if (mCpr != null) {
                p.max = p.key;
                if (p.right != null && mCpr.compare(p.right.max, p.max) > 0) {
                    p.max = p.right.max;
                }
                if (p.left != null && mCpr.compare(p.left.max, p.max) > 0) {
                    p.max = p.left.max;
                }
                l.max = l.key;
                if (l.left != null && mCpr.compare(l.left.max, l.max) > 0) {
                    l.max = l.left.max;
                }
                if (l.right != null && mCpr.compare(l.right.max, l.max) > 0) {
                    l.max = l.right.max;
                }
            }
        }
    }

    private void fixAfterInsertion(Entry<K, V> x) {
        x.color = false;
        while (x != null && x != this.root && !x.parent.color) {
            Entry<K, V> y;
            if (IntervalMap.parentOf(x) == IntervalMap.leftOf(IntervalMap.parentOf(IntervalMap.parentOf(x)))) {
                y = IntervalMap.rightOf(IntervalMap.parentOf(IntervalMap.parentOf(x)));
                if (!IntervalMap.colorOf(y)) {
                    IntervalMap.setColor(IntervalMap.parentOf(x), true);
                    IntervalMap.setColor(y, true);
                    IntervalMap.setColor(IntervalMap.parentOf(IntervalMap.parentOf(x)), false);
                    x = IntervalMap.parentOf(IntervalMap.parentOf(x));
                    continue;
                }
                if (x == IntervalMap.rightOf(IntervalMap.parentOf(x))) {
                    x = IntervalMap.parentOf(x);
                    this.rotateLeft(x);
                }
                IntervalMap.setColor(IntervalMap.parentOf(x), true);
                IntervalMap.setColor(IntervalMap.parentOf(IntervalMap.parentOf(x)), false);
                this.rotateRight(IntervalMap.parentOf(IntervalMap.parentOf(x)));
                continue;
            }
            y = IntervalMap.leftOf(IntervalMap.parentOf(IntervalMap.parentOf(x)));
            if (!IntervalMap.colorOf(y)) {
                IntervalMap.setColor(IntervalMap.parentOf(x), true);
                IntervalMap.setColor(y, true);
                IntervalMap.setColor(IntervalMap.parentOf(IntervalMap.parentOf(x)), false);
                x = IntervalMap.parentOf(IntervalMap.parentOf(x));
                continue;
            }
            if (x == IntervalMap.leftOf(IntervalMap.parentOf(x))) {
                x = IntervalMap.parentOf(x);
                this.rotateRight(x);
            }
            IntervalMap.setColor(IntervalMap.parentOf(x), true);
            IntervalMap.setColor(IntervalMap.parentOf(IntervalMap.parentOf(x)), false);
            this.rotateLeft(IntervalMap.parentOf(IntervalMap.parentOf(x)));
        }
        this.root.color = true;
    }

    private void deleteEntry(Entry<K, V> p) {
        Entry replacement;
        ++this.modCount;
        --this.size;
        if (p.left != null && p.right != null) {
            Entry<K, V> s = IntervalMap.successor(p);
            p.key = s.key;
            p.value = s.value;
            p = s;
        }
        Entry entry = replacement = p.left != null ? p.left : p.right;
        if (replacement != null) {
            replacement.parent = p.parent;
            if (p.parent == null) {
                this.root = replacement;
            } else if (p == p.parent.left) {
                p.parent.left = replacement;
                if (this.maxComparator != null) {
                    p.parent.max = p.parent.key;
                    if (this.maxComparator.compare(p.parent.left.max, p.parent.max) > 0) {
                        p.parent.max = p.parent.left.max;
                    }
                    if (this.maxComparator.compare(p.parent.right.max, p.parent.max) > 0) {
                        p.parent.max = p.parent.right.max;
                    }
                }
            } else {
                p.parent.right = replacement;
                if (this.maxComparator != null) {
                    p.parent.max = p.parent.key;
                    if (this.maxComparator.compare(p.parent.right.max, p.parent.max) > 0) {
                        p.parent.max = p.parent.right.max;
                    }
                    if (this.maxComparator.compare(p.parent.left.max, p.parent.max) > 0) {
                        p.parent.max = p.parent.left.max;
                    }
                }
            }
            p.parent = null;
            p.right = null;
            p.left = null;
            if (p.color) {
                this.fixAfterDeletion(replacement);
            }
        } else if (p.parent == null) {
            this.root = null;
        } else {
            if (p.color) {
                this.fixAfterDeletion(p);
            }
            if (p.parent != null) {
                if (p == p.parent.left) {
                    p.parent.left = null;
                } else if (p == p.parent.right) {
                    p.parent.right = null;
                }
                p.parent = null;
            }
        }
    }

    private void fixAfterDeletion(Entry<K, V> x) {
        while (x != this.root && IntervalMap.colorOf(x)) {
            Entry<K, V> sib;
            if (x == IntervalMap.leftOf(IntervalMap.parentOf(x))) {
                sib = IntervalMap.rightOf(IntervalMap.parentOf(x));
                if (!IntervalMap.colorOf(sib)) {
                    IntervalMap.setColor(sib, true);
                    IntervalMap.setColor(IntervalMap.parentOf(x), false);
                    this.rotateLeft(IntervalMap.parentOf(x));
                    sib = IntervalMap.rightOf(IntervalMap.parentOf(x));
                }
                if (IntervalMap.colorOf(IntervalMap.leftOf(sib)) && IntervalMap.colorOf(IntervalMap.rightOf(sib))) {
                    IntervalMap.setColor(sib, false);
                    x = IntervalMap.parentOf(x);
                    continue;
                }
                if (IntervalMap.colorOf(IntervalMap.rightOf(sib))) {
                    IntervalMap.setColor(IntervalMap.leftOf(sib), true);
                    IntervalMap.setColor(sib, false);
                    this.rotateRight(sib);
                    sib = IntervalMap.rightOf(IntervalMap.parentOf(x));
                }
                IntervalMap.setColor(sib, IntervalMap.colorOf(IntervalMap.parentOf(x)));
                IntervalMap.setColor(IntervalMap.parentOf(x), true);
                IntervalMap.setColor(IntervalMap.rightOf(sib), true);
                this.rotateLeft(IntervalMap.parentOf(x));
                x = this.root;
                continue;
            }
            sib = IntervalMap.leftOf(IntervalMap.parentOf(x));
            if (!IntervalMap.colorOf(sib)) {
                IntervalMap.setColor(sib, true);
                IntervalMap.setColor(IntervalMap.parentOf(x), false);
                this.rotateRight(IntervalMap.parentOf(x));
                sib = IntervalMap.leftOf(IntervalMap.parentOf(x));
            }
            if (IntervalMap.colorOf(IntervalMap.rightOf(sib)) && IntervalMap.colorOf(IntervalMap.leftOf(sib))) {
                IntervalMap.setColor(sib, false);
                x = IntervalMap.parentOf(x);
                continue;
            }
            if (IntervalMap.colorOf(IntervalMap.leftOf(sib))) {
                IntervalMap.setColor(IntervalMap.rightOf(sib), true);
                IntervalMap.setColor(sib, false);
                this.rotateLeft(sib);
                sib = IntervalMap.leftOf(IntervalMap.parentOf(x));
            }
            IntervalMap.setColor(sib, IntervalMap.colorOf(IntervalMap.parentOf(x)));
            IntervalMap.setColor(IntervalMap.parentOf(x), true);
            IntervalMap.setColor(IntervalMap.leftOf(sib), true);
            this.rotateRight(IntervalMap.parentOf(x));
            x = this.root;
        }
        IntervalMap.setColor(x, true);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.size);
        for (Map.Entry<K, V> e : this.entrySet()) {
            s.writeObject(e.getKey());
            s.writeObject(e.getValue());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int size = s.readInt();
        this.buildFromSorted(size, null, s, null);
    }

    void readTreeSet(int size, ObjectInputStream s, V defaultVal) throws IOException, ClassNotFoundException {
        this.buildFromSorted(size, null, s, defaultVal);
    }

    void addAllForTreeSet(SortedSet<? extends K> set, V defaultVal) {
        try {
            this.buildFromSorted(set.size(), set.iterator(), null, defaultVal);
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private void buildFromSorted(int size, Iterator<?> it, ObjectInputStream str, V defaultVal) throws IOException, ClassNotFoundException {
        this.size = size;
        this.root = this.buildFromSorted(0, 0, size - 1, IntervalMap.computeRedLevel(size), it, str, defaultVal);
    }

    private final Entry<K, V> buildFromSorted(int level, int lo, int hi, int redLevel, Iterator<?> it, ObjectInputStream str, V defaultVal) throws IOException, ClassNotFoundException {
        V value;
        Object key;
        if (hi < lo) {
            return null;
        }
        int mid = lo + hi >>> 1;
        Entry<K, V> left = null;
        if (lo < mid) {
            left = this.buildFromSorted(level + 1, lo, mid - 1, redLevel, it, str, defaultVal);
        }
        if (it != null) {
            if (defaultVal == null) {
                Map.Entry entry = (Map.Entry)it.next();
                key = entry.getKey();
                value = entry.getValue();
            } else {
                key = it.next();
                value = defaultVal;
            }
        } else {
            key = str.readObject();
            value = defaultVal != null ? defaultVal : str.readObject();
        }
        Entry<Object, V> middle = new Entry<Object, V>(key, key, value, null);
        if (level == redLevel) {
            middle.color = false;
        }
        if (left != null) {
            middle.left = left;
            left.parent = middle;
        }
        if (mid < hi) {
            Entry<K, V> right = this.buildFromSorted(level + 1, mid + 1, hi, redLevel, it, str, defaultVal);
            middle.right = right;
            right.parent = middle;
        }
        return middle;
    }

    private static int computeRedLevel(int sz) {
        int level = 0;
        int m = sz - 1;
        while (m >= 0) {
            ++level;
            m = m / 2 - 1;
        }
        return level;
    }

    private void sanity(int indent) {
        if (this.root != null) {
            this.root.sanity(this.comparator, this.maxComparator, indent);
        }
    }

    public static void main(String[] args) {
        if (args.length <= 2 || args.length % 2 == 1) {
            System.out.println("+++ IntervalMap test -- find overlaps of an interval search-start/end in a list of data points start/end");
            System.out.println("+++ Usage:  vjava IntervalMap search-start search-end [data-start data-end]...");
            System.out.println("+++ Example: java IntervalMap 4 5     0 2   2 3   4 6   2 4   3 6   8 10");
            System.out.println("+++    should indicate (4,5) overlaps with (4,6), (2,4) and (3,6)");
            return;
        }
        try {
            int start = Integer.parseInt(args[0]);
            int end = Integer.parseInt(args[1]);
            if (end < start) {
                System.err.println("+++ IntervalMap unit test requires search start/end point pairs where end (" + end + ") >= start (" + start + ")");
                return;
            }
            interval search = new interval(start, end);
            System.out.println("+++ IntervalMap unit test");
            IntervalMap<interval, interval> im = new IntervalMap<interval, interval>(new intStartComp(), new intEndComp(), new overlapsComp(), new extentComp());
            for (int i = 2; i < args.length; i += 2) {
                start = Integer.parseInt(args[i]);
                end = Integer.parseInt(args[i + 1]);
                if (end < start) {
                    System.err.println("+++ IntervalMap unit test requires data start/end point pairs where end (" + end + ") >= start (" + start + ")");
                    return;
                }
                interval test = new interval(start, end);
                interval tmp = (interval)im.get(test);
                if (tmp != null) {
                    if (end > tmp.end) {
                        im.remove(tmp);
                        im.put(test, test);
                        System.out.println("+++ replacing: " + tmp.toString() + ", with duplicate input:" + test.toString());
                        continue;
                    }
                    System.out.println("+++ ignoring duplicate input: " + test.toString() + ", keeping original:" + tmp.toString());
                    continue;
                }
                im.put(test, test);
                System.out.println("+++ input data point:" + test.toString());
            }
            System.out.println("+++ resulting IntervalMap:" + im.toString());
            System.out.println("+++ " + search.toString() + " overlaps:");
            for (interval it : im.overlapMap(search).keySet()) {
                System.out.println("+++    " + it.toString());
            }
        }
        catch (NumberFormatException e) {
            System.err.println("+++ IntervalMap usage test requires integer start/end points");
        }
    }

    private static class extentComp
    implements Comparator<interval> {
        private extentComp() {
        }

        @Override
        public int compare(interval arg1, interval arg2) {
            if (arg1.start > arg2.end) {
                return 1;
            }
            if (arg1.start < arg2.end) {
                return -1;
            }
            return 0;
        }
    }

    private static class overlapsComp
    implements Comparator<interval> {
        private overlapsComp() {
        }

        @Override
        public int compare(interval arg1, interval arg2) {
            if (arg1.start >= arg2.start && arg1.start <= arg2.end || arg2.start >= arg1.start && arg2.start <= arg1.end) {
                return 0;
            }
            if (arg1.start < arg2.start) {
                return -1;
            }
            return 1;
        }
    }

    private static class intEndComp
    implements Comparator<interval> {
        private intEndComp() {
        }

        @Override
        public int compare(interval arg1, interval arg2) {
            if (arg1.end > arg2.end) {
                return 1;
            }
            if (arg1.end < arg2.end) {
                return -1;
            }
            if (arg1.start < arg2.start) {
                return 1;
            }
            if (arg1.start > arg2.start) {
                return -1;
            }
            return 0;
        }
    }

    private static class intStartComp
    implements Comparator<interval> {
        private intStartComp() {
        }

        @Override
        public int compare(interval arg1, interval arg2) {
            if (arg1.start > arg2.start) {
                return 1;
            }
            if (arg1.start < arg2.start) {
                return -1;
            }
            return 0;
        }
    }

    private static class interval {
        private int start;
        private int end;

        public interval(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public String toString() {
            return "interval<start=" + this.start + ", end=" + this.end + ">";
        }
    }

    static final class Entry<K, V>
    implements Map.Entry<K, V> {
        K key;
        K max;
        V value;
        Entry<K, V> left = null;
        Entry<K, V> right = null;
        Entry<K, V> parent;
        boolean color = true;

        Entry(K key, K max, V value, Entry<K, V> parent) {
            this.key = key;
            this.max = max;
            this.value = value;
            this.parent = parent;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return IntervalMap.valEquals(this.key, e.getKey()) && IntervalMap.valEquals(this.value, e.getValue());
        }

        @Override
        public int hashCode() {
            int keyHash = this.key == null ? 0 : this.key.hashCode();
            int valueHash = this.value == null ? 0 : this.value.hashCode();
            return keyHash ^ valueHash;
        }

        public String toString() {
            return this.key + "(" + this.max + ")=" + this.value;
        }

        public void sanity(Comparator<? super K> sc, Comparator<? super K> ec, int indent) {
            String msg;
            if (this.left != null) {
                this.left.sanity(sc, ec, indent == 0 ? 0 : indent + 2);
            }
            String fmt = "+++ %" + indent + "s%s\n";
            String efmt = "!!! %" + (indent == 0 ? 1 : indent) + "s%s";
            if (indent != 0) {
                System.out.printf(fmt, " ", this.toString());
            }
            if (this.left != null) {
                if (sc != null && sc.compare(this.left.key, this.key) >= 0) {
                    msg = String.format(efmt, " ", "node " + this.key.toString() + " not greater than left node " + this.left.key.toString());
                    if (indent == 0) {
                        throw new InternalError(msg);
                    }
                    System.out.println(msg);
                }
                if (ec != null && ec.compare(this.left.max, this.max) > 0) {
                    msg = String.format(efmt, " ", "node " + this.key.toString() + " max " + this.max.toString() + " not greater or equal to left node max " + this.left.max.toString());
                    if (indent == 0) {
                        throw new InternalError(msg);
                    }
                    System.out.println(msg);
                }
            }
            if (this.right != null) {
                if (sc != null && sc.compare(this.right.key, this.key) <= 0) {
                    msg = String.format(efmt, " ", "node " + this.key.toString() + " not less than right node " + this.right.key.toString());
                    if (indent == 0) {
                        throw new InternalError(msg);
                    }
                    System.out.println(msg);
                }
                if (ec != null && ec.compare(this.right.max, this.max) > 0) {
                    msg = String.format(efmt, " ", "node " + this.key.toString() + " max " + this.max.toString() + " not greater or equal to right node max " + this.right.max.toString());
                    if (indent == 0) {
                        throw new InternalError(msg);
                    }
                    System.out.println(msg);
                }
            }
            if (this.right != null) {
                this.right.sanity(sc, ec, indent == 0 ? 0 : indent + 2);
            }
        }
    }

    static final class DescendingOverlapMap<K, V>
    extends NavigableOverlapMap<K, V> {
        private static final long serialVersionUID = 912986545866120460L;
        private final Comparator<? super K> reverseComparator;

        DescendingOverlapMap(IntervalMap<K, V> m, boolean fromStart, K lo, boolean loInclusive, boolean toEnd, K hi, boolean hiInclusive) {
            super(m, fromStart, lo, loInclusive, toEnd, hi, hiInclusive);
            this.reverseComparator = Collections.reverseOrder(this.m.comparator);
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.reverseComparator;
        }

        @Override
        public NavigableMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
            if (!this.inRange(fromKey, fromInclusive)) {
                throw new IllegalArgumentException("fromKey out of range");
            }
            if (!this.inRange(toKey, toInclusive)) {
                throw new IllegalArgumentException("toKey out of range");
            }
            return new DescendingOverlapMap<K, V>(this.m, false, toKey, toInclusive, false, fromKey, fromInclusive);
        }

        @Override
        public NavigableMap<K, V> headMap(K toKey, boolean inclusive) {
            if (!this.inRange(toKey, inclusive)) {
                throw new IllegalArgumentException("toKey out of range");
            }
            return new DescendingOverlapMap<Object, V>(this.m, false, toKey, inclusive, this.toEnd, this.hi, this.hiInclusive);
        }

        @Override
        public NavigableMap<K, V> tailMap(K fromKey, boolean inclusive) {
            if (!this.inRange(fromKey, inclusive)) {
                throw new IllegalArgumentException("fromKey out of range");
            }
            return new DescendingOverlapMap<Object, V>(this.m, this.fromStart, this.lo, this.loInclusive, false, fromKey, inclusive);
        }

        @Override
        public NavigableMap<K, V> descendingMap() {
            AscendingOverlapMap mv = this.descendingMapView;
            return mv != null ? mv : (this.descendingMapView = new AscendingOverlapMap(this.m, this.fromStart, this.lo, this.loInclusive, this.toEnd, this.hi, this.hiInclusive));
        }

        @Override
        Iterator<K> keyIterator() {
            return new NavigableOverlapMap.DescendingOverlapMapKeyIterator(this.absHighest(), this.lo, this.absLowFence());
        }

        @Override
        Iterator<K> descendingKeyIterator() {
            return new NavigableOverlapMap.OverlapMapKeyIterator(this.absLowest(), this.lo, this.absHighFence());
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            NavigableOverlapMap.EntrySetView es = this.entrySetView;
            return es != null ? es : new DescendingEntrySetView();
        }

        @Override
        Entry<K, V> subLowest() {
            return this.absHighest();
        }

        @Override
        Entry<K, V> subHighest() {
            return this.absLowest();
        }

        @Override
        Entry<K, V> subCeiling(K key) {
            return this.absFloor(key);
        }

        @Override
        Entry<K, V> subHigher(K key) {
            return this.absLower(key);
        }

        @Override
        Entry<K, V> subFloor(K key) {
            return this.absCeiling(key);
        }

        @Override
        Entry<K, V> subLower(K key) {
            return this.absHigher(key);
        }

        final class DescendingEntrySetView
        extends NavigableOverlapMap.EntrySetView {
            DescendingEntrySetView() {
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new NavigableOverlapMap.DescendingOverlapMapEntryIterator(DescendingOverlapMap.this.absHighest(), DescendingOverlapMap.this.lo, DescendingOverlapMap.this.absLowFence());
            }
        }
    }

    static final class AscendingOverlapMap<K, V>
    extends NavigableOverlapMap<K, V> {
        private static final long serialVersionUID = 912986545866124060L;

        AscendingOverlapMap(IntervalMap<K, V> m, boolean fromStart, K lo, boolean loInclusive, boolean toEnd, K hi, boolean hiInclusive) {
            super(m, fromStart, lo, loInclusive, toEnd, hi, hiInclusive);
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.m.comparator();
        }

        @Override
        public NavigableMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
            if (!this.inRange(fromKey, fromInclusive)) {
                throw new IllegalArgumentException("fromKey out of range");
            }
            if (!this.inRange(toKey, toInclusive)) {
                throw new IllegalArgumentException("toKey out of range");
            }
            return new AscendingOverlapMap<K, V>(this.m, false, fromKey, fromInclusive, false, toKey, toInclusive);
        }

        @Override
        public NavigableMap<K, V> headMap(K toKey, boolean inclusive) {
            if (!this.inRange(toKey, inclusive)) {
                throw new IllegalArgumentException("toKey out of range");
            }
            return new AscendingOverlapMap<Object, V>(this.m, this.fromStart, this.lo, this.loInclusive, false, toKey, inclusive);
        }

        @Override
        public NavigableMap<K, V> tailMap(K fromKey, boolean inclusive) {
            if (!this.inRange(fromKey, inclusive)) {
                throw new IllegalArgumentException("fromKey out of range");
            }
            return new AscendingOverlapMap<Object, V>(this.m, false, fromKey, inclusive, this.toEnd, this.hi, this.hiInclusive);
        }

        @Override
        public NavigableMap<K, V> descendingMap() {
            DescendingOverlapMap mv = this.descendingMapView;
            return mv != null ? mv : (this.descendingMapView = new DescendingOverlapMap(this.m, this.fromStart, this.lo, this.loInclusive, this.toEnd, this.hi, this.hiInclusive));
        }

        @Override
        Iterator<K> keyIterator() {
            return new NavigableOverlapMap.OverlapMapKeyIterator(this.absLowest(), this.hi, this.absHighFence());
        }

        @Override
        Iterator<K> descendingKeyIterator() {
            return new NavigableOverlapMap.DescendingOverlapMapKeyIterator(this.absHighest(), this.hi, this.absLowFence());
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            NavigableOverlapMap.EntrySetView es = this.entrySetView;
            return es != null ? es : new AscendingEntrySetView();
        }

        @Override
        Entry<K, V> subLowest() {
            return this.absLowest();
        }

        @Override
        Entry<K, V> subHighest() {
            return this.absHighest();
        }

        @Override
        Entry<K, V> subCeiling(K key) {
            return this.absCeiling(key);
        }

        @Override
        Entry<K, V> subHigher(K key) {
            return this.absHigher(key);
        }

        @Override
        Entry<K, V> subFloor(K key) {
            return this.absFloor(key);
        }

        @Override
        Entry<K, V> subLower(K key) {
            return this.absLower(key);
        }

        final class AscendingEntrySetView
        extends NavigableOverlapMap.EntrySetView {
            AscendingEntrySetView() {
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new NavigableOverlapMap.OverlapMapEntryIterator(AscendingOverlapMap.this.absLowest(), AscendingOverlapMap.this.hi, AscendingOverlapMap.this.absHighFence());
            }
        }
    }

    static abstract class NavigableOverlapMap<K, V>
    extends AbstractMap<K, V>
    implements NavigableMap<K, V>,
    Serializable {
        final IntervalMap<K, V> m;
        final K lo;
        final K hi;
        final boolean fromStart;
        final boolean toEnd;
        final boolean loInclusive;
        final boolean hiInclusive;
        transient NavigableMap<K, V> descendingMapView = null;
        transient EntrySetView entrySetView = null;
        transient KeySet<K> navigableKeySetView = null;

        NavigableOverlapMap(IntervalMap<K, V> m, boolean fromStart, K lo, boolean loInclusive, boolean toEnd, K hi, boolean hiInclusive) {
            if (!fromStart && !toEnd) {
                if (m.compare(lo, hi) > 0) {
                    throw new IllegalArgumentException("fromKey > toKey");
                }
            } else {
                if (!fromStart) {
                    m.compare(lo, lo);
                }
                if (!toEnd) {
                    m.compare(hi, hi);
                }
            }
            this.m = m;
            this.fromStart = fromStart;
            this.lo = lo;
            this.loInclusive = loInclusive;
            this.toEnd = toEnd;
            this.hi = hi;
            this.hiInclusive = hiInclusive;
        }

        final boolean tooLow(Object key) {
            int c;
            return !this.fromStart && ((c = this.m.overlapCompare(key, this.hi)) < 0 || c == 0 && !this.loInclusive);
        }

        final boolean tooHigh(Object key) {
            int c;
            return !this.toEnd && ((c = this.m.overlapCompare(key, this.hi)) > 0 || c == 0 && !this.hiInclusive);
        }

        final boolean inRange(Object key) {
            return !this.tooLow(key) && !this.tooHigh(key);
        }

        final boolean inClosedRange(Object key) {
            return !(!this.fromStart && this.m.compare(key, this.lo) < 0 || !this.toEnd && this.m.compare(this.hi, key) < 0);
        }

        final boolean inRange(Object key, boolean inclusive) {
            return inclusive ? this.inRange(key) : this.inClosedRange(key);
        }

        final Entry<K, V> absLowest() {
            Entry<K, V> e = this.fromStart ? this.m.getFirstEntry() : (this.loInclusive ? this.m.getCeilingEntry(this.lo) : this.m.getHigherEntry(this.lo));
            return e == null || this.tooHigh(e.key) ? null : e;
        }

        final Entry<K, V> absHighest() {
            Entry<K, V> e = this.toEnd ? this.m.getLastEntry() : (this.hiInclusive ? this.m.getFloorEntry(this.hi) : this.m.getLowerEntry(this.hi));
            return e == null || this.tooLow(e.key) ? null : e;
        }

        final Entry<K, V> absCeiling(K key) {
            if (this.tooLow(key)) {
                return this.absLowest();
            }
            Entry<K, V> e = this.m.getCeilingEntry(key);
            return e == null || this.tooHigh(e.key) ? null : e;
        }

        final Entry<K, V> absHigher(K key) {
            if (this.tooLow(key)) {
                return this.absLowest();
            }
            Entry<K, V> e = this.m.getHigherEntry(key);
            return e == null || this.tooHigh(e.key) ? null : e;
        }

        final Entry<K, V> absFloor(K key) {
            if (this.tooHigh(key)) {
                return this.absHighest();
            }
            Entry<K, V> e = this.m.getFloorEntry(key);
            return e == null || this.tooLow(e.key) ? null : e;
        }

        final Entry<K, V> absLower(K key) {
            if (this.tooHigh(key)) {
                return this.absHighest();
            }
            Entry<K, V> e = this.m.getLowerEntry(key);
            return e == null || this.tooLow(e.key) ? null : e;
        }

        final Entry<K, V> absHighFence() {
            return this.toEnd ? null : (this.hiInclusive ? this.m.getHigherEntry(this.hi) : this.m.getCeilingEntry(this.hi));
        }

        final Entry<K, V> absLowFence() {
            return this.fromStart ? null : (this.loInclusive ? this.m.getLowerEntry(this.lo) : this.m.getFloorEntry(this.lo));
        }

        abstract Entry<K, V> subLowest();

        abstract Entry<K, V> subHighest();

        abstract Entry<K, V> subCeiling(K var1);

        abstract Entry<K, V> subHigher(K var1);

        abstract Entry<K, V> subFloor(K var1);

        abstract Entry<K, V> subLower(K var1);

        abstract Iterator<K> keyIterator();

        abstract Iterator<K> descendingKeyIterator();

        @Override
        public boolean isEmpty() {
            return this.fromStart && this.toEnd ? this.m.isEmpty() : this.entrySet().isEmpty();
        }

        @Override
        public int size() {
            return this.fromStart && this.toEnd ? this.m.size() : this.entrySet().size();
        }

        @Override
        public final boolean containsKey(Object key) {
            return this.inRange(key) && this.m.containsKey(key);
        }

        @Override
        public final V put(K key, V value) {
            if (!this.inRange(key)) {
                throw new IllegalArgumentException("key out of range");
            }
            return this.m.put(key, value);
        }

        @Override
        public final V get(Object key) {
            return !this.inRange(key) ? null : (V)this.m.get(key);
        }

        @Override
        public final V remove(Object key) {
            return !this.inRange(key) ? null : (V)this.m.remove(key);
        }

        @Override
        public final Map.Entry<K, V> ceilingEntry(K key) {
            return IntervalMap.exportEntry(this.subCeiling(key));
        }

        @Override
        public final K ceilingKey(K key) {
            return IntervalMap.keyOrNull(this.subCeiling(key));
        }

        @Override
        public final Map.Entry<K, V> higherEntry(K key) {
            return IntervalMap.exportEntry(this.subHigher(key));
        }

        @Override
        public final K higherKey(K key) {
            return IntervalMap.keyOrNull(this.subHigher(key));
        }

        @Override
        public final Map.Entry<K, V> floorEntry(K key) {
            return IntervalMap.exportEntry(this.subFloor(key));
        }

        @Override
        public final K floorKey(K key) {
            return IntervalMap.keyOrNull(this.subFloor(key));
        }

        @Override
        public final Map.Entry<K, V> lowerEntry(K key) {
            return IntervalMap.exportEntry(this.subLower(key));
        }

        @Override
        public final K lowerKey(K key) {
            return IntervalMap.keyOrNull(this.subLower(key));
        }

        @Override
        public final K firstKey() {
            return IntervalMap.key(this.subLowest());
        }

        @Override
        public final K lastKey() {
            return IntervalMap.key(this.subHighest());
        }

        @Override
        public final Map.Entry<K, V> firstEntry() {
            return IntervalMap.exportEntry(this.subLowest());
        }

        @Override
        public final Map.Entry<K, V> lastEntry() {
            return IntervalMap.exportEntry(this.subHighest());
        }

        @Override
        public final Map.Entry<K, V> pollFirstEntry() {
            Entry<K, V> e = this.subLowest();
            Map.Entry<K, V> result = IntervalMap.exportEntry(e);
            if (e != null) {
                ((IntervalMap)this.m).deleteEntry(e);
            }
            return result;
        }

        @Override
        public final Map.Entry<K, V> pollLastEntry() {
            Entry<K, V> e = this.subHighest();
            Map.Entry<K, V> result = IntervalMap.exportEntry(e);
            if (e != null) {
                ((IntervalMap)this.m).deleteEntry(e);
            }
            return result;
        }

        @Override
        public final NavigableSet<K> navigableKeySet() {
            KeySet<K> nksv = this.navigableKeySetView;
            return nksv != null ? nksv : (this.navigableKeySetView = new KeySet(this));
        }

        @Override
        public final Set<K> keySet() {
            return this.navigableKeySet();
        }

        @Override
        public NavigableSet<K> descendingKeySet() {
            return this.descendingMap().navigableKeySet();
        }

        @Override
        public final SortedMap<K, V> subMap(K fromKey, K toKey) {
            return this.subMap(fromKey, true, toKey, false);
        }

        @Override
        public final SortedMap<K, V> headMap(K toKey) {
            return this.headMap(toKey, false);
        }

        @Override
        public final SortedMap<K, V> tailMap(K fromKey) {
            return this.tailMap(fromKey, true);
        }

        final class DescendingOverlapMapKeyIterator
        extends OverlapMapIterator<K> {
            DescendingOverlapMapKeyIterator(Entry<K, V> last, K overlaps, Entry<K, V> fence) {
                super(last, overlaps, fence);
            }

            @Override
            public K next() {
                return this.prevEntry().key;
            }

            @Override
            public void remove() {
                this.removeDescending();
            }
        }

        final class DescendingOverlapMapEntryIterator
        extends OverlapMapIterator<Map.Entry<K, V>> {
            DescendingOverlapMapEntryIterator(Entry<K, V> last, K overlaps, Entry<K, V> fence) {
                super(last, overlaps, fence);
            }

            @Override
            public Map.Entry<K, V> next() {
                return this.prevEntry();
            }

            @Override
            public void remove() {
                this.removeDescending();
            }
        }

        final class OverlapMapKeyIterator
        extends OverlapMapIterator<K> {
            OverlapMapKeyIterator(Entry<K, V> first, K overlaps, Entry<K, V> fence) {
                super(first, overlaps, fence);
            }

            @Override
            public K next() {
                return this.nextEntry().key;
            }

            @Override
            public void remove() {
                this.removeAscending();
            }
        }

        final class OverlapMapEntryIterator
        extends OverlapMapIterator<Map.Entry<K, V>> {
            OverlapMapEntryIterator(Entry<K, V> first, K overlaps, Entry<K, V> fence) {
                super(first, overlaps, fence);
            }

            @Override
            public Map.Entry<K, V> next() {
                return this.nextEntry();
            }

            @Override
            public void remove() {
                this.removeAscending();
            }
        }

        abstract class OverlapMapIterator<T>
        implements Iterator<T> {
            Entry<K, V> lastReturned;
            Entry<K, V> next;
            final Object fenceKey;
            final K overlapKey;
            int expectedModCount;

            OverlapMapIterator(Entry<K, V> first, K overlaps, Entry<K, V> fence) {
                this.expectedModCount = NavigableOverlapMap.this.m.modCount;
                this.lastReturned = null;
                this.overlapKey = overlaps;
                this.next = first;
                this.fenceKey = fence == null ? UNBOUNDED : fence.key;
            }

            @Override
            public final boolean hasNext() {
                return this.next != null && this.next.key != this.fenceKey;
            }

            final Entry<K, V> nextEntry() {
                Entry e = this.next;
                if (e == null || e.key == this.fenceKey) {
                    throw new NoSuchElementException();
                }
                if (NavigableOverlapMap.this.m.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                do {
                    this.next = IntervalMap.successor(this.next);
                } while (this.next != null && this.next.key != this.fenceKey && NavigableOverlapMap.this.m.overlapCompare(this.next.key, this.overlapKey) != 0);
                this.lastReturned = e;
                return e;
            }

            final Entry<K, V> prevEntry() {
                Entry e = this.next;
                if (e == null || e.key == this.fenceKey) {
                    throw new NoSuchElementException();
                }
                if (NavigableOverlapMap.this.m.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                do {
                    this.next = IntervalMap.predecessor(this.next);
                } while (this.next != null && this.next.key != this.fenceKey && NavigableOverlapMap.this.m.overlapCompare(this.next.key, this.overlapKey) != 0);
                this.lastReturned = e;
                return e;
            }

            final void removeAscending() {
                if (this.lastReturned == null) {
                    throw new IllegalStateException();
                }
                if (NavigableOverlapMap.this.m.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                if (this.lastReturned.left != null && this.lastReturned.right != null) {
                    this.next = this.lastReturned;
                }
                NavigableOverlapMap.this.m.deleteEntry(this.lastReturned);
                this.lastReturned = null;
                this.expectedModCount = NavigableOverlapMap.this.m.modCount;
            }

            final void removeDescending() {
                if (this.lastReturned == null) {
                    throw new IllegalStateException();
                }
                if (NavigableOverlapMap.this.m.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                NavigableOverlapMap.this.m.deleteEntry(this.lastReturned);
                this.lastReturned = null;
                this.expectedModCount = NavigableOverlapMap.this.m.modCount;
            }
        }

        abstract class EntrySetView
        extends AbstractSet<Map.Entry<K, V>> {
            private transient int size = -1;
            private transient int sizeModCount;

            EntrySetView() {
            }

            @Override
            public int size() {
                if (NavigableOverlapMap.this.fromStart && NavigableOverlapMap.this.toEnd) {
                    return NavigableOverlapMap.this.m.size();
                }
                if (this.size == -1 || this.sizeModCount != NavigableOverlapMap.this.m.modCount) {
                    this.sizeModCount = NavigableOverlapMap.this.m.modCount;
                    this.size = 0;
                    Iterator i = this.iterator();
                    while (i.hasNext()) {
                        ++this.size;
                        i.next();
                    }
                }
                return this.size;
            }

            @Override
            public boolean isEmpty() {
                Entry n = NavigableOverlapMap.this.absLowest();
                return n == null || NavigableOverlapMap.this.tooHigh(n.key);
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)o;
                Object key = entry.getKey();
                if (!NavigableOverlapMap.this.inRange(key)) {
                    return false;
                }
                Entry node = NavigableOverlapMap.this.m.getEntry(key);
                return node != null && IntervalMap.valEquals(node.getValue(), entry.getValue());
            }

            @Override
            public boolean remove(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)o;
                Object key = entry.getKey();
                if (!NavigableOverlapMap.this.inRange(key)) {
                    return false;
                }
                Entry node = NavigableOverlapMap.this.m.getEntry(key);
                if (node != null && IntervalMap.valEquals(node.getValue(), entry.getValue())) {
                    NavigableOverlapMap.this.m.deleteEntry(node);
                    return true;
                }
                return false;
            }
        }
    }

    final class DescendingKeyIterator
    extends PrivateEntryIterator<K> {
        DescendingKeyIterator(Entry<K, V> first) {
            super(first);
        }

        @Override
        public K next() {
            return this.prevEntry().key;
        }
    }

    final class KeyIterator
    extends PrivateEntryIterator<K> {
        KeyIterator(Entry<K, V> first) {
            super(first);
        }

        @Override
        public K next() {
            return this.nextEntry().key;
        }
    }

    final class ValueIterator
    extends PrivateEntryIterator<V> {
        ValueIterator(Entry<K, V> first) {
            super(first);
        }

        @Override
        public V next() {
            return this.nextEntry().value;
        }
    }

    final class EntryIterator
    extends PrivateEntryIterator<Map.Entry<K, V>> {
        EntryIterator(Entry<K, V> first) {
            super(first);
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    abstract class PrivateEntryIterator<T>
    implements Iterator<T> {
        Entry<K, V> next;
        Entry<K, V> lastReturned;
        int expectedModCount;

        PrivateEntryIterator(Entry<K, V> first) {
            this.expectedModCount = IntervalMap.this.modCount;
            this.lastReturned = null;
            this.next = first;
        }

        @Override
        public final boolean hasNext() {
            return this.next != null;
        }

        final Entry<K, V> nextEntry() {
            Entry e = this.next;
            if (e == null) {
                throw new NoSuchElementException();
            }
            if (IntervalMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.next = IntervalMap.successor(e);
            this.lastReturned = e;
            return e;
        }

        final Entry<K, V> prevEntry() {
            Entry e = this.next;
            if (e == null) {
                throw new NoSuchElementException();
            }
            if (IntervalMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.next = IntervalMap.predecessor(e);
            this.lastReturned = e;
            return e;
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (IntervalMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.lastReturned.left != null && this.lastReturned.right != null) {
                this.next = this.lastReturned;
            }
            IntervalMap.this.deleteEntry(this.lastReturned);
            this.expectedModCount = IntervalMap.this.modCount;
            this.lastReturned = null;
        }
    }

    static final class KeySet<E>
    extends AbstractSet<E>
    implements NavigableSet<E> {
        private final NavigableMap<E, Object> m;

        KeySet(NavigableMap<E, Object> map) {
            this.m = map;
        }

        @Override
        public Iterator<E> iterator() {
            if (this.m instanceof IntervalMap) {
                return ((IntervalMap)this.m).keyIterator();
            }
            return ((NavigableOverlapMap)this.m).keyIterator();
        }

        @Override
        public Iterator<E> descendingIterator() {
            if (this.m instanceof IntervalMap) {
                return ((IntervalMap)this.m).descendingKeyIterator();
            }
            return ((NavigableOverlapMap)this.m).descendingKeyIterator();
        }

        @Override
        public int size() {
            return this.m.size();
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.m.containsKey(o);
        }

        @Override
        public void clear() {
            this.m.clear();
        }

        @Override
        public E lower(E e) {
            return this.m.lowerKey(e);
        }

        @Override
        public E floor(E e) {
            return this.m.floorKey(e);
        }

        @Override
        public E ceiling(E e) {
            return this.m.ceilingKey(e);
        }

        @Override
        public E higher(E e) {
            return this.m.higherKey(e);
        }

        @Override
        public E first() {
            return (E)this.m.firstKey();
        }

        @Override
        public E last() {
            return (E)this.m.lastKey();
        }

        @Override
        public Comparator<? super E> comparator() {
            return this.m.comparator();
        }

        @Override
        public E pollFirst() {
            Map.Entry<E, Object> e = this.m.pollFirstEntry();
            return e == null ? null : (E)e.getKey();
        }

        @Override
        public E pollLast() {
            Map.Entry<E, Object> e = this.m.pollLastEntry();
            return e == null ? null : (E)e.getKey();
        }

        @Override
        public boolean remove(Object o) {
            int oldSize = this.size();
            this.m.remove(o);
            return this.size() != oldSize;
        }

        @Override
        public NavigableSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
            return new KeySet<E>(this.m.subMap(fromElement, fromInclusive, toElement, toInclusive));
        }

        @Override
        public NavigableSet<E> headSet(E toElement, boolean inclusive) {
            return new KeySet<E>(this.m.headMap(toElement, inclusive));
        }

        @Override
        public NavigableSet<E> tailSet(E fromElement, boolean inclusive) {
            return new KeySet<E>(this.m.tailMap(fromElement, inclusive));
        }

        @Override
        public SortedSet<E> subSet(E fromElement, E toElement) {
            return this.subSet(fromElement, true, toElement, false);
        }

        @Override
        public SortedSet<E> headSet(E toElement) {
            return this.headSet(toElement, false);
        }

        @Override
        public SortedSet<E> tailSet(E fromElement) {
            return this.tailSet(fromElement, true);
        }

        @Override
        public NavigableSet<E> descendingSet() {
            return new KeySet<E>(this.m.descendingMap());
        }
    }

    class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator(IntervalMap.this.getFirstEntry());
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Object value = entry.getValue();
            Entry p = IntervalMap.this.getEntry(entry.getKey());
            return p != null && IntervalMap.valEquals(p.getValue(), value);
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Object value = entry.getValue();
            Entry p = IntervalMap.this.getEntry(entry.getKey());
            if (p != null && IntervalMap.valEquals(p.getValue(), value)) {
                IntervalMap.this.deleteEntry(p);
                return true;
            }
            return false;
        }

        @Override
        public int size() {
            return IntervalMap.this.size();
        }

        @Override
        public void clear() {
            IntervalMap.this.clear();
        }
    }

    class Values
    extends AbstractCollection<V> {
        Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator(IntervalMap.this.getFirstEntry());
        }

        @Override
        public int size() {
            return IntervalMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return IntervalMap.this.containsValue(o);
        }

        @Override
        public boolean remove(Object o) {
            Entry e = IntervalMap.this.getFirstEntry();
            while (e != null) {
                if (IntervalMap.valEquals(e.getValue(), o)) {
                    IntervalMap.this.deleteEntry(e);
                    return true;
                }
                e = IntervalMap.successor(e);
            }
            return false;
        }

        @Override
        public void clear() {
            IntervalMap.this.clear();
        }
    }
}

