/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.util;

import java.util.HashMap;
import java.util.Map;

public class MultiMap {
    private Map<Integer, Object> map;

    public MultiMap(boolean createAll, int ... dims) {
        this.map = createAll ? MultiMap.instantiateMapRecursive(0, dims) : MultiMap.instantiateMapRecursive(0, dims[0]);
    }

    private static Map<Integer, Object> instantiateMapRecursive(int idx, int ... dims) {
        int initialCapacity = dims[idx++];
        HashMap<Integer, Object> result = new HashMap<Integer, Object>(initialCapacity);
        for (int i = 1; i <= initialCapacity && idx < dims.length; ++i) {
            Map<Integer, Object> subMap = MultiMap.instantiateMapRecursive(idx, dims);
            result.put(i, subMap);
        }
        return result;
    }

    public Object get(int ... dims) {
        return this.findInMapRecursive(this.getMap(), 0, dims);
    }

    private Object findInMapRecursive(Map<Integer, Object> m, int idx, int ... dims) {
        Object result;
        if (m == null) {
            result = null;
        } else {
            int i = dims[idx];
            if (dims.length == ++idx) {
                result = m.get(i);
            } else {
                Map submap = (Map)m.get(i);
                result = this.findInMapRecursive(submap, idx, dims);
            }
        }
        return result;
    }

    public void put(Object o, int ... dims) {
        this.putInMapRecursive(this.getMap(), o, 0, dims);
    }

    private void putInMapRecursive(Map<Integer, Object> m, Object o, int idx, int ... dims) {
        int i = dims[idx];
        if (dims.length == ++idx) {
            m.put(i, o);
        } else {
            HashMap<Integer, Object> submap = (HashMap<Integer, Object>)m.get(i);
            if (submap == null) {
                submap = new HashMap<Integer, Object>();
                m.put(i, submap);
            }
            this.putInMapRecursive(submap, o, idx, dims);
        }
    }

    public Map<Integer, Object> getMap() {
        return this.map;
    }

    public void setMap(Map<Integer, Object> map) {
        this.map = map;
    }

    public void clear() {
        this.map.clear();
    }
}

