/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class XfdUtils {
    private static String currLayout;
    private static String fieldName;
    private static HashMap<String, String> whereList;
    private static HashMap<String, String> field2ColumnMap;
    private static String[] pg_helpers;
    private static String[] mysqlMariaDB_helpers;
    private static String[] MSSQL_helpers;

    public static void main(String[] args) {
        if (args.length < 1) {
            throw new IllegalArgumentException("Arguments required ==> Input:xfd_xml_file, [Output:outputDDL_file]");
        }
        String inputXfd = args[0];
        String outputDDL = null;
        if (args.length > 1) {
            outputDDL = args[1];
        }
        XfdUtils.generateDDL(inputXfd, outputDDL);
    }

    public static List<String> generateColumnList(String inputXfd) {
        ArrayList<String> columnList = new ArrayList<String>();
        try {
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
            XMLStreamReader xmlStreamReader = inputFactory.createXMLStreamReader(new BufferedReader(new FileReader(inputXfd)));
            while (xmlStreamReader.hasNext()) {
                int event = xmlStreamReader.next();
                if (event != 1) continue;
                String colName = null;
                String len = null;
                String piclen = null;
                String offset = null;
                String place = null;
                String type = null;
                int offsetInt = 0;
                if (!xmlStreamReader.getLocalName().equals("column")) continue;
                for (int i = 0; i < xmlStreamReader.getAttributeCount(); ++i) {
                    String name = xmlStreamReader.getAttributeLocalName(i);
                    if (name.equals("name")) {
                        colName = xmlStreamReader.getAttributeValue(i);
                        continue;
                    }
                    if (name.equals("sqltype")) {
                        type = xmlStreamReader.getAttributeValue(i);
                        continue;
                    }
                    if (name.equals("length")) {
                        len = xmlStreamReader.getAttributeValue(i);
                        continue;
                    }
                    if (name.equals("piclen")) {
                        piclen = xmlStreamReader.getAttributeValue(i);
                        continue;
                    }
                    if (name.equals("place")) {
                        place = xmlStreamReader.getAttributeValue(i);
                        continue;
                    }
                    if (!name.equals("offset")) continue;
                    offset = xmlStreamReader.getAttributeValue(i);
                    try {
                        offsetInt = Integer.parseInt(offset);
                    }
                    catch (NumberFormatException nfe) {
                        nfe.printStackTrace();
                        System.exit(99);
                    }
                    ++offsetInt;
                }
                if (type.equals("B")) continue;
                columnList.add(colName);
            }
        }
        catch (FactoryConfigurationError e) {
            System.out.println("FactoryConfigurationError" + e.getMessage());
        }
        catch (XMLStreamException e) {
            System.out.println("XMLStreamException" + e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("IOException" + e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return columnList;
    }

    public static void generateDDL(String inputXfd) {
        XfdUtils.generateDDL(inputXfd, null);
    }

    public static void generateDDL(String inputXfd, String outputDDL) {
        XfdUtils.generateDDL(inputXfd, outputDDL, Database.POSTGRES, false);
    }

    public static void generateDDL(String inputXfd, String outputDDL, Database dbType, boolean useVarchar) {
        XfdUtils.generateDDL(inputXfd, outputDDL, dbType, useVarchar, null, null);
    }

    public static void generateDDL(String inputXfd, String outputDDL, Database dbType, boolean useVarchar, List<String> pKey, List<String> aKey) {
        XfdUtils.generateDDL(inputXfd, outputDDL, dbType, useVarchar, pKey, aKey, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateDDL(String inputXfd, String outputDDL, Database dbType, boolean useVarchar, List<String> pKey, List<String> aKey, String tblname) {
        PrintStream origSysout = System.out;
        try {
            PrintStream outPrintStream = null;
            if (outputDDL != null) {
                outPrintStream = new PrintStream(new File(outputDDL));
                System.setOut(outPrintStream);
            }
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
            XMLStreamReader xmlStreamReader = inputFactory.createXMLStreamReader(new BufferedReader(new FileReader(inputXfd)));
            String comma = " ";
            boolean commaIsOn = false;
            String tableName = null;
            while (xmlStreamReader.hasNext()) {
                String name;
                int i;
                int event = xmlStreamReader.next();
                if (event != 1) continue;
                String colName = null;
                String sqlType = null;
                String sqlSize = null;
                String piclen = null;
                String usage = null;
                String place = null;
                String type = null;
                if (xmlStreamReader.getLocalName().equals("dataset")) {
                    for (i = 0; i < xmlStreamReader.getAttributeCount(); ++i) {
                        name = xmlStreamReader.getAttributeLocalName(i);
                        if (!name.equals("name")) continue;
                        tableName = xmlStreamReader.getAttributeValue(i);
                    }
                    if (tblname != null) {
                        tableName = tblname;
                    }
                    System.out.println("CREATE TABLE " + tableName);
                    System.out.println("(");
                    continue;
                }
                if (!xmlStreamReader.getLocalName().equals("column")) continue;
                for (i = 0; i < xmlStreamReader.getAttributeCount(); ++i) {
                    name = xmlStreamReader.getAttributeLocalName(i);
                    if (name.equals("name")) {
                        colName = xmlStreamReader.getAttributeValue(i);
                        continue;
                    }
                    if (name.equals("sqltype")) {
                        type = xmlStreamReader.getAttributeValue(i);
                        continue;
                    }
                    if (name.equals("piclen")) {
                        piclen = xmlStreamReader.getAttributeValue(i);
                        continue;
                    }
                    if (name.equals("place")) {
                        place = xmlStreamReader.getAttributeValue(i);
                        continue;
                    }
                    if (!name.equals("usage")) continue;
                    usage = xmlStreamReader.getAttributeValue(i);
                }
                if (type.equals("A")) {
                    if (useVarchar) {
                        switch (dbType) {
                            case POSTGRES: {
                                sqlType = "CHAR VARYING";
                                break;
                            }
                            case MYSQL: {
                                sqlType = "VARCHAR";
                                break;
                            }
                            case DB2: {
                                sqlType = "VARCHAR";
                                break;
                            }
                            case ORACLE: {
                                sqlType = "VARCHAR";
                                break;
                            }
                            default: {
                                sqlType = "VARCHAR";
                                break;
                            }
                        }
                    } else {
                        sqlType = "CHAR";
                    }
                    sqlSize = piclen;
                    System.out.println(comma + String.format("%1$-35s%2$-15s", colName, sqlType + "(" + sqlSize + ")"));
                } else if (type.equals("NZ") || type.equals("NP")) {
                    sqlType = "NUMERIC";
                    sqlSize = piclen + (place != null ? "," + place : "");
                    System.out.println(comma + String.format("%1$-35s%2$-15s", colName, sqlType + "(" + sqlSize + ")"));
                } else {
                    sqlType = "INTEGER";
                    sqlSize = piclen;
                    System.out.println(comma + String.format("%1$-35s%2$-15s", colName, sqlType));
                }
                if (commaIsOn) continue;
                comma = ",";
                commaIsOn = true;
            }
            System.out.println(");");
            if (pKey != null && !pKey.isEmpty()) {
                System.out.println();
                System.out.println("ALTER TABLE " + tableName);
                System.out.println("  ADD CONSTRAINT " + tableName + "_pk");
                StringBuffer keyListBuffer = new StringBuffer();
                boolean isFirstItem = true;
                for (String s : pKey) {
                    if (isFirstItem) {
                        isFirstItem = false;
                    } else {
                        keyListBuffer.append(",");
                    }
                    keyListBuffer.append(s);
                }
                System.out.println("    PRIMARY KEY (" + keyListBuffer.toString() + ");");
            }
        }
        catch (FactoryConfigurationError e) {
            System.err.println("FactoryConfigurationError" + e.getMessage());
        }
        catch (XMLStreamException e) {
            System.err.println("XMLStreamException" + e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            System.err.println("IOException" + e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (outputDDL != null) {
                System.setOut(origSysout);
            }
        }
    }

    public static void generateView(String inputXfd) {
        XfdUtils.generateView(inputXfd, null);
    }

    public static void generateView(String inputXfd, String outputDDL) {
        XfdUtils.generateView(inputXfd, outputDDL, Database.POSTGRES, false);
    }

    public static void generateView(String inputXfd, String outputDDL, Database dbType, boolean useVarchar) {
        XfdUtils.generateView(inputXfd, outputDDL, dbType, useVarchar, false, null, null, null, null);
    }

    public static void generateView(String inputXfd, String outputDDL, Database dbType, boolean useVarchar, boolean isMaterialized) {
        XfdUtils.generateView(inputXfd, outputDDL, dbType, useVarchar, isMaterialized, null, null, null, null);
    }

    public static void generateView(String inputXfd, String outputDDL, Database dbType, boolean useVarchar, boolean isMaterialized, String tblName, String _currLayout, String _fieldName, HashMap<String, String> _whereList) {
        currLayout = _currLayout;
        fieldName = _fieldName;
        whereList = _whereList;
        switch (dbType) {
            case POSTGRES: {
                XfdUtils.generatePostgresView(inputXfd, outputDDL, useVarchar, isMaterialized, tblName);
                break;
            }
            case MYSQL: {
                XfdUtils.generateMySQLView(inputXfd, outputDDL, useVarchar, tblName);
                break;
            }
            case DB2: {
                XfdUtils.generateDB2View(inputXfd, outputDDL, useVarchar, isMaterialized, tblName);
                break;
            }
            case ORACLE: {
                XfdUtils.generateOracleView(inputXfd, outputDDL, useVarchar, isMaterialized, tblName);
                break;
            }
            case MSSQL_SERVER: {
                XfdUtils.generateSQLServerView(inputXfd, outputDDL, useVarchar, tblName);
                break;
            }
            default: {
                XfdUtils.generatePostgresView(inputXfd, outputDDL, useVarchar);
            }
        }
    }

    public static void generateField2ColumnMapping(String inputXfd, boolean useVarchar, String tblName, Database dbType) {
        field2ColumnMap.clear();
        switch (dbType) {
            case POSTGRES: {
                XfdUtils.generatePostgresField2ColumnMapping(inputXfd, useVarchar, tblName);
                break;
            }
            case MYSQL: {
                XfdUtils.generateMySQLViewField2ColumnMapping(inputXfd, useVarchar, tblName);
                break;
            }
            case DB2: {
                XfdUtils.generateDB2Field2ColumnMapping(inputXfd, useVarchar, tblName);
                break;
            }
            case ORACLE: {
                XfdUtils.generateOracleField2ColumnMapping(inputXfd, useVarchar, tblName);
                break;
            }
            case MSSQL_SERVER: {
                XfdUtils.generateSQLServerField2ColumnMapping(inputXfd, useVarchar, tblName);
                break;
            }
            default: {
                XfdUtils.generatePostgresField2ColumnMapping(inputXfd, useVarchar, tblName);
            }
        }
    }

    public static void generateSQLServerView(String inputXfd, String outputDDL, boolean useVarchar) {
        XfdUtils.generateSQLServerView(inputXfd, outputDDL, useVarchar, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateSQLServerView(String inputXfd, String outputDDL, boolean useVarchar, String tableName) {
        PrintStream origSysout = System.out;
        try {
            PrintStream outPrintStream = null;
            if (outputDDL != null) {
                outPrintStream = new PrintStream(new File(outputDDL));
                System.setOut(outPrintStream);
            }
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
            XMLStreamReader xmlStreamReader = inputFactory.createXMLStreamReader(new BufferedReader(new FileReader(inputXfd)));
            String comma = "";
            String layoutName = "";
            boolean firstPass = true;
            boolean commaIsOn = false;
            while (xmlStreamReader.hasNext()) {
                String colExtract;
                String name;
                int i;
                int event = xmlStreamReader.next();
                if (event != 1) continue;
                String colName = null;
                String sqlType = null;
                String sqlSize = null;
                String len = null;
                String piclen = null;
                String offset = null;
                String place = null;
                String type = null;
                int offsetInt = 0;
                if (firstPass && xmlStreamReader.getLocalName().equals("group")) {
                    for (i = 0; i < xmlStreamReader.getAttributeCount(); ++i) {
                        name = xmlStreamReader.getAttributeLocalName(i);
                        if (!name.equals("name")) continue;
                        layoutName = xmlStreamReader.getAttributeValue(i);
                        firstPass = false;
                        break;
                    }
                    System.out.println("CREATE VIEW " + tableName + "_" + layoutName.replaceAll("\\.", "_") + "_view AS");
                    System.out.println("SELECT");
                    continue;
                }
                if (!xmlStreamReader.getLocalName().equals("column")) continue;
                for (i = 0; i < xmlStreamReader.getAttributeCount(); ++i) {
                    name = xmlStreamReader.getAttributeLocalName(i);
                    if (name.equals("name")) {
                        colName = xmlStreamReader.getAttributeValue(i);
                        continue;
                    }
                    if (name.equals("sqltype")) {
                        type = xmlStreamReader.getAttributeValue(i);
                        continue;
                    }
                    if (name.equals("length")) {
                        len = xmlStreamReader.getAttributeValue(i);
                        continue;
                    }
                    if (name.equals("piclen")) {
                        piclen = xmlStreamReader.getAttributeValue(i);
                        continue;
                    }
                    if (name.equals("place")) {
                        place = xmlStreamReader.getAttributeValue(i);
                        continue;
                    }
                    if (!name.equals("offset")) continue;
                    offset = xmlStreamReader.getAttributeValue(i);
                    try {
                        offsetInt = Integer.parseInt(offset);
                    }
                    catch (NumberFormatException nfe) {
                        nfe.printStackTrace();
                        System.exit(99);
                    }
                    ++offsetInt;
                }
                if (type.equals("A")) {
                    sqlSize = piclen;
                    sqlType = useVarchar ? "varchar(" + sqlSize + ")" : "char(" + sqlSize + ")";
                    colExtract = "cast(substring([dbo].[" + tableName + "].[data]," + offsetInt + "," + len + ") as " + sqlType + ") ";
                    System.out.println("     " + comma + colExtract + colName);
                } else {
                    sqlType = "decimal";
                    if (type.equals("NZ")) {
                        sqlSize = "(" + piclen + (place != null ? "," + place : "") + ")";
                        colExtract = "convert(" + sqlType + sqlSize + ",[dbo].[zoned_numeric_bytes](substring([dbo].[" + tableName + "].[data]," + offsetInt + "," + len + "))) ";
                        System.out.println("     " + comma + colExtract + colName);
                    } else if (type.equals("NP")) {
                        if (place != null) {
                            int numOfZeros = 1;
                            try {
                                numOfZeros = Integer.parseInt(place);
                            }
                            catch (NumberFormatException nfe) {
                                numOfZeros = 1;
                            }
                            String format = "%0" + numOfZeros + "d";
                            String strValOfDec = "." + String.format(format, 1);
                            sqlSize = "(" + piclen + "," + place + ")";
                            colExtract = "convert(" + sqlType + ",[dbo].[unpack_numeric_bytes](substring([dbo].[" + tableName + "].[data]," + offsetInt + "," + len + "))) *" + strValOfDec + " ";
                            System.out.println("     " + comma + colExtract + colName);
                        } else {
                            sqlSize = "(" + piclen + ")";
                            colExtract = "convert(" + sqlType + ",[dbo].[unpack_numeric_bytes](substring([dbo].[" + tableName + "].[data]," + offsetInt + "," + len + "))) ";
                            System.out.println("     " + comma + colExtract + colName);
                        }
                    } else {
                        sqlType = "integer";
                        sqlSize = piclen + ",0";
                        String intType = null;
                        intType = Integer.valueOf(piclen) / 2 > 4 ? "bigint" : (Integer.valueOf(piclen) / 2 > 2 ? "int" : "smallint");
                        colExtract = "cast(substring([dbo].[" + tableName + "].[data]," + offsetInt + "," + len + ") as " + intType + ") ";
                        System.out.println("     " + comma + colExtract + colName);
                    }
                }
                if (commaIsOn) continue;
                comma = ",";
                commaIsOn = true;
            }
            System.out.println("  FROM " + tableName);
            XfdUtils.generateViewWhere();
            System.out.println(";");
        }
        catch (FactoryConfigurationError e) {
            System.err.println("FactoryConfigurationError" + e.getMessage());
        }
        catch (XMLStreamException e) {
            System.err.println("XMLStreamException" + e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            System.err.println("IOException" + e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (outputDDL != null) {
                System.setOut(origSysout);
            }
        }
    }

    public static void generateSQLServerField2ColumnMapping(String inputXfd, boolean useVarchar, String tableName) {
        try {
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
            XMLStreamReader xmlStreamReader = inputFactory.createXMLStreamReader(new BufferedReader(new FileReader(inputXfd)));
            while (xmlStreamReader.hasNext()) {
                String colExtract;
                int event = xmlStreamReader.next();
                if (event != 1) continue;
                String colName = null;
                String sqlType = null;
                String sqlSize = null;
                String len = null;
                String piclen = null;
                String offset = null;
                String place = null;
                String type = null;
                int offsetInt = 0;
                if (!xmlStreamReader.getLocalName().equals("column")) continue;
                for (int i = 0; i < xmlStreamReader.getAttributeCount(); ++i) {
                    String name = xmlStreamReader.getAttributeLocalName(i);
                    if (name.equals("name")) {
                        colName = xmlStreamReader.getAttributeValue(i).toUpperCase();
                        continue;
                    }
                    if (name.equals("sqltype")) {
                        type = xmlStreamReader.getAttributeValue(i);
                        continue;
                    }
                    if (name.equals("length")) {
                        len = xmlStreamReader.getAttributeValue(i);
                        continue;
                    }
                    if (name.equals("piclen")) {
                        piclen = xmlStreamReader.getAttributeValue(i);
                        continue;
                    }
                    if (name.equals("place")) {
                        place = xmlStreamReader.getAttributeValue(i);
                        continue;
                    }
                    if (!name.equals("offset")) continue;
                    offset = xmlStreamReader.getAttributeValue(i);
                    try {
                        offsetInt = Integer.parseInt(offset);
                    }
                    catch (NumberFormatException nfe) {
                        nfe.printStackTrace();
                        System.exit(99);
                    }
                    ++offsetInt;
                }
                if (type.equals("A")) {
                    sqlSize = piclen;
                    sqlType = useVarchar ? "varchar(" + sqlSize + ")" : "char(" + sqlSize + ")";
                    colExtract = "cast(substring([dbo].[" + tableName + "].[data]," + offsetInt + "," + len + ") as " + sqlType + ") ";
                    field2ColumnMap.put(colName, colExtract);
                    continue;
                }
                sqlType = "decimal";
                if (type.equals("NZ")) {
                    sqlSize = "(" + piclen + (place != null ? "," + place : "") + ")";
                    colExtract = "convert(" + sqlType + sqlSize + ",[dbo].[zoned_numeric_bytes](substring([dbo].[" + tableName + "].[data]," + offsetInt + "," + len + "))) ";
                    field2ColumnMap.put(colName, colExtract);
                    continue;
                }
                if (type.equals("NP")) {
                    if (place != null) {
                        int numOfZeros = 1;
                        try {
                            numOfZeros = Integer.parseInt(place);
                        }
                        catch (NumberFormatException nfe) {
                            numOfZeros = 1;
                        }
                        String format = "%0" + numOfZeros + "d";
                        String strValOfDec = "." + String.format(format, 1);
                        colExtract = "convert(" + sqlType + ",[dbo].[unpack_numeric_bytes](substring([dbo].[" + tableName + "].[data]," + offsetInt + "," + len + "))) *" + strValOfDec + " ";
                        field2ColumnMap.put(colName, colExtract);
                        continue;
                    }
                    colExtract = "convert(" + sqlType + ",[dbo].[unpack_numeric_bytes](substring([dbo].[" + tableName + "].[data]," + offsetInt + "," + len + "))) ";
                    field2ColumnMap.put(colName, colExtract);
                    continue;
                }
                String intType = null;
                intType = Integer.valueOf(piclen) / 2 > 4 ? "bigint" : (Integer.valueOf(piclen) / 2 > 2 ? "int" : "smallint");
                colExtract = "cast(substring([dbo].[" + tableName + "].[data]," + offsetInt + "," + len + ") as " + intType + ") ";
                field2ColumnMap.put(colName, colExtract);
            }
        }
        catch (FactoryConfigurationError e) {
            System.err.println("FactoryConfigurationError" + e.getMessage());
        }
        catch (XMLStreamException e) {
            System.err.println("XMLStreamException" + e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            System.err.println("IOException" + e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void generateViewWhere() {
        String arg;
        String colName;
        Object key;
        if (whereList == null) {
            return;
        }
        ArrayList<String> conds = new ArrayList<String>();
        if (fieldName != null && whereList.containsKey(key = currLayout + "." + fieldName) && (colName = field2ColumnMap.get((arg = whereList.get(key).substring(0, whereList.get(key).indexOf(32))).toUpperCase())) != null) {
            conds.add(whereList.get(key).replaceAll(arg, colName));
        }
        for (Map.Entry<String, String> es : whereList.entrySet()) {
            if (!es.getKey().startsWith(currLayout + "_")) continue;
            colName = field2ColumnMap.get(es.getKey().substring(currLayout.length() + 1).toUpperCase());
            conds.add(es.getValue().replaceAll(es.getKey().substring(currLayout.length() + 1), colName));
        }
        if (conds.size() > 0) {
            System.out.println("WHERE ");
            boolean first = true;
            for (String cond : conds) {
                if (first) {
                    System.out.println(cond);
                    first = false;
                    continue;
                }
                System.out.println("AND " + cond);
            }
        }
    }

    public static void generateOracleView(String inputXfd, String outputDDL, boolean useVarchar) {
        XfdUtils.generateOracleView(inputXfd, outputDDL, useVarchar, false);
    }

    public static void generateOracleView(String inputXfd, String outputDDL, boolean useVarchar, boolean isMaterialized) {
        XfdUtils.generateOracleView(inputXfd, outputDDL, useVarchar, isMaterialized, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateOracleView(String inputXfd, String outputDDL, boolean useVarchar, boolean isMaterialized, String tableName) {
        PrintStream origSysout = System.out;
        try {
            PrintStream outPrintStream = null;
            if (outputDDL != null) {
                outPrintStream = new PrintStream(new File(outputDDL));
                System.setOut(outPrintStream);
            }
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
            XMLStreamReader xmlStreamReader = inputFactory.createXMLStreamReader(new BufferedReader(new FileReader(inputXfd)));
            String comma = "";
            boolean commaIsOn = false;
            String layoutName = "";
            boolean firstPass = true;
            while (xmlStreamReader.hasNext()) {
                String colExtract;
                String name;
                int i;
                int event = xmlStreamReader.next();
                if (event != 1) continue;
                String colName = null;
                String sqlType = null;
                String sqlSize = null;
                String len = null;
                String piclen = null;
                String offset = null;
                String place = null;
                String type = null;
                int offsetInt = 0;
                if (firstPass && xmlStreamReader.getLocalName().equals("group")) {
                    for (i = 0; i < xmlStreamReader.getAttributeCount(); ++i) {
                        name = xmlStreamReader.getAttributeLocalName(i);
                        if (!name.equals("name")) continue;
                        layoutName = xmlStreamReader.getAttributeValue(i);
                        firstPass = false;
                        break;
                    }
                    if (isMaterialized) {
                        System.out.println("CREATE MATERIALIZED VIEW " + tableName + "_" + layoutName.replaceAll("\\.", "_") + "_view");
                        System.out.println("BUILD IMMEDIATE");
                        System.out.println("REFRESH FORCE");
                        System.out.println("ON COMMIT");
                        System.out.println("AS");
                        System.out.println("SELECT");
                        continue;
                    }
                    System.out.println("CREATE VIEW " + tableName + "_" + layoutName.replaceAll("\\.", "_") + "_view AS");
                    System.out.println("SELECT");
                    continue;
                }
                if (!xmlStreamReader.getLocalName().equals("column")) continue;
                for (i = 0; i < xmlStreamReader.getAttributeCount(); ++i) {
                    name = xmlStreamReader.getAttributeLocalName(i);
                    if (name.equals("name")) {
                        colName = xmlStreamReader.getAttributeValue(i);
                        continue;
                    }
                    if (name.equals("sqltype")) {
                        type = xmlStreamReader.getAttributeValue(i);
                        continue;
                    }
                    if (name.equals("length")) {
                        len = xmlStreamReader.getAttributeValue(i);
                        continue;
                    }
                    if (name.equals("piclen")) {
                        piclen = xmlStreamReader.getAttributeValue(i);
                        continue;
                    }
                    if (name.equals("place")) {
                        place = xmlStreamReader.getAttributeValue(i);
                        continue;
                    }
                    if (!name.equals("offset")) continue;
                    offset = xmlStreamReader.getAttributeValue(i);
                    try {
                        offsetInt = Integer.parseInt(offset);
                    }
                    catch (NumberFormatException nfe) {
                        nfe.printStackTrace();
                        System.exit(99);
                    }
                    ++offsetInt;
                }
                if (type.equals("A")) {
                    sqlSize = piclen;
                    sqlType = useVarchar ? "varchar(" + sqlSize + ")" : "char(" + sqlSize + ")";
                    colExtract = "cast(substring(" + tableName + ".data," + offsetInt + "," + len + ") as " + sqlType + ")";
                    System.out.println("     " + comma + colExtract + " AS " + colName);
                } else {
                    sqlType = "decimal";
                    if (type.equals("NZ")) {
                        sqlSize = "(" + piclen + (place != null ? "," + place : "") + ")";
                        colExtract = "cast(zoned_numeric_bytes(" + tableName + ".data," + offsetInt + "," + len + ") as " + sqlType + sqlSize + ")";
                        System.out.println("     " + comma + colExtract + " AS " + colName);
                    } else if (type.equals("NP")) {
                        if (place != null) {
                            int numOfZeros = 1;
                            try {
                                numOfZeros = Integer.parseInt(place);
                            }
                            catch (NumberFormatException nfe) {
                                numOfZeros = 1;
                            }
                            String format = "%0" + numOfZeros + "d";
                            String strValOfDec = "." + String.format(format, 1);
                            sqlSize = "(" + piclen + "," + place + ")";
                            colExtract = "cast((unpack_numeric_bytes(" + tableName + ".data," + offsetInt + "," + len + ") *" + strValOfDec + ") as " + sqlType + sqlSize + ")";
                            System.out.println("     " + comma + colExtract + " AS " + colName);
                        } else {
                            sqlSize = "(" + piclen + ")";
                            colExtract = "cast(unpack_numeric_bytes(" + tableName + ".data," + offsetInt + "," + len + ") as " + sqlType + sqlSize + ")";
                            System.out.println("     " + comma + colExtract + " AS " + colName);
                        }
                    } else {
                        sqlType = "integer";
                        sqlSize = piclen + ",0";
                        colExtract = "blob_to_int(substring(" + tableName + ".data," + offsetInt + "," + len + ")," + len + ")";
                        System.out.println("     " + comma + colExtract + " AS " + colName);
                    }
                }
                if (commaIsOn) continue;
                comma = ",";
                commaIsOn = true;
            }
            System.out.println("  FROM " + tableName);
            XfdUtils.generateViewWhere();
            System.out.println(";");
        }
        catch (FactoryConfigurationError e) {
            System.err.println("FactoryConfigurationError" + e.getMessage());
        }
        catch (XMLStreamException e) {
            System.err.println("XMLStreamException" + e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            System.err.println("IOException" + e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (outputDDL != null) {
                System.setOut(origSysout);
            }
        }
    }

    public static void generateOracleField2ColumnMapping(String inputXfd, boolean useVarchar, String tableName) {
        try {
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
            XMLStreamReader xmlStreamReader = inputFactory.createXMLStreamReader(new BufferedReader(new FileReader(inputXfd)));
            while (xmlStreamReader.hasNext()) {
                String colExtract;
                int event = xmlStreamReader.next();
                if (event != 1) continue;
                String colName = null;
                String sqlType = null;
                String sqlSize = null;
                String len = null;
                String piclen = null;
                String offset = null;
                String place = null;
                String type = null;
                int offsetInt = 0;
                if (!xmlStreamReader.getLocalName().equals("column")) continue;
                for (int i = 0; i < xmlStreamReader.getAttributeCount(); ++i) {
                    String name = xmlStreamReader.getAttributeLocalName(i);
                    if (name.equals("name")) {
                        colName = xmlStreamReader.getAttributeValue(i).toUpperCase();
                        continue;
                    }
                    if (name.equals("sqltype")) {
                        type = xmlStreamReader.getAttributeValue(i);
                        continue;
                    }
                    if (name.equals("length")) {
                        len = xmlStreamReader.getAttributeValue(i);
                        continue;
                    }
                    if (name.equals("piclen")) {
                        piclen = xmlStreamReader.getAttributeValue(i);
                        continue;
                    }
                    if (name.equals("place")) {
                        place = xmlStreamReader.getAttributeValue(i);
                        continue;
                    }
                    if (!name.equals("offset")) continue;
                    offset = xmlStreamReader.getAttributeValue(i);
                    try {
                        offsetInt = Integer.parseInt(offset);
                    }
                    catch (NumberFormatException nfe) {
                        nfe.printStackTrace();
                        System.exit(99);
                    }
                    ++offsetInt;
                }
                if (type.equals("A")) {
                    sqlSize = piclen;
                    sqlType = useVarchar ? "varchar(" + sqlSize + ")" : "char(" + sqlSize + ")";
                    colExtract = "cast(substring(" + tableName + ".data," + offsetInt + "," + len + ") as " + sqlType + ")";
                    field2ColumnMap.put(colName, colExtract);
                    continue;
                }
                sqlType = "decimal";
                if (type.equals("NZ")) {
                    sqlSize = "(" + piclen + (place != null ? "," + place : "") + ")";
                    colExtract = "cast(zoned_numeric_bytes(" + tableName + ".data," + offsetInt + "," + len + ") as " + sqlType + sqlSize + ")";
                    field2ColumnMap.put(colName, colExtract);
                    continue;
                }
                if (type.equals("NP")) {
                    if (place != null) {
                        int numOfZeros = 1;
                        try {
                            numOfZeros = Integer.parseInt(place);
                        }
                        catch (NumberFormatException nfe) {
                            numOfZeros = 1;
                        }
                        String format = "%0" + numOfZeros + "d";
                        String strValOfDec = "." + String.format(format, 1);
                        sqlSize = "(" + piclen + "," + place + ")";
                        colExtract = "cast((unpack_numeric_bytes(" + tableName + ".data," + offsetInt + "," + len + ") *" + strValOfDec + ") as " + sqlType + sqlSize + ")";
                        field2ColumnMap.put(colName, colExtract);
                        continue;
                    }
                    sqlSize = "(" + piclen + ")";
                    colExtract = "cast(unpack_numeric_bytes(" + tableName + ".data," + offsetInt + "," + len + ") as " + sqlType + sqlSize + ")";
                    field2ColumnMap.put(colName, colExtract);
                    continue;
                }
                colExtract = "blob_to_int(substring(" + tableName + ".data," + offsetInt + "," + len + ")," + len + ")";
                field2ColumnMap.put(colName, colExtract);
            }
        }
        catch (FactoryConfigurationError e) {
            System.err.println("FactoryConfigurationError" + e.getMessage());
        }
        catch (XMLStreamException e) {
            System.err.println("XMLStreamException" + e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            System.err.println("IOException" + e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void generateDB2View(String inputXfd, String outputDDL, boolean useVarchar) {
        XfdUtils.generateDB2View(inputXfd, outputDDL, useVarchar, false);
    }

    public static void generateDB2View(String inputXfd, String outputDDL, boolean useVarchar, boolean isMaterialized) {
        XfdUtils.generateDB2View(inputXfd, outputDDL, useVarchar, isMaterialized, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateDB2View(String inputXfd, String outputDDL, boolean useVarchar, boolean isMaterialized, String tableName) {
        PrintStream origSysout = System.out;
        try {
            PrintStream outPrintStream = null;
            if (outputDDL != null) {
                outPrintStream = new PrintStream(new File(outputDDL));
                System.setOut(outPrintStream);
            }
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
            XMLStreamReader xmlStreamReader = inputFactory.createXMLStreamReader(new BufferedReader(new FileReader(inputXfd)));
            String comma = "";
            boolean commaIsOn = false;
            String layoutName = "";
            boolean firstPass = true;
            while (xmlStreamReader.hasNext()) {
                String colExtract;
                String name;
                int i;
                int event = xmlStreamReader.next();
                if (event != 1) continue;
                String colName = null;
                String sqlType = null;
                String sqlSize = null;
                String len = null;
                String piclen = null;
                String offset = null;
                String place = null;
                String type = null;
                int offsetInt = 0;
                if (firstPass && xmlStreamReader.getLocalName().equals("group")) {
                    for (i = 0; i < xmlStreamReader.getAttributeCount(); ++i) {
                        name = xmlStreamReader.getAttributeLocalName(i);
                        if (!name.equals("name")) continue;
                        layoutName = xmlStreamReader.getAttributeValue(i);
                        firstPass = false;
                        break;
                    }
                    if (isMaterialized) {
                        System.out.println("CREATE TABLE " + tableName + "_" + layoutName.replaceAll("\\.", "_") + "_view AS");
                        System.out.println("(SELECT");
                        continue;
                    }
                    System.out.println("CREATE VIEW " + tableName + "_" + layoutName.replaceAll("\\.", "_") + "_view AS");
                    System.out.println("SELECT");
                    continue;
                }
                if (!xmlStreamReader.getLocalName().equals("column")) continue;
                for (i = 0; i < xmlStreamReader.getAttributeCount(); ++i) {
                    name = xmlStreamReader.getAttributeLocalName(i);
                    if (name.equals("name")) {
                        colName = xmlStreamReader.getAttributeValue(i);
                        continue;
                    }
                    if (name.equals("sqltype")) {
                        type = xmlStreamReader.getAttributeValue(i);
                        continue;
                    }
                    if (name.equals("length")) {
                        len = xmlStreamReader.getAttributeValue(i);
                        continue;
                    }
                    if (name.equals("piclen")) {
                        piclen = xmlStreamReader.getAttributeValue(i);
                        continue;
                    }
                    if (name.equals("place")) {
                        place = xmlStreamReader.getAttributeValue(i);
                        continue;
                    }
                    if (!name.equals("offset")) continue;
                    offset = xmlStreamReader.getAttributeValue(i);
                    try {
                        offsetInt = Integer.parseInt(offset);
                    }
                    catch (NumberFormatException nfe) {
                        nfe.printStackTrace();
                        System.exit(99);
                    }
                    ++offsetInt;
                }
                if (type.equals("A")) {
                    sqlSize = piclen;
                    sqlType = useVarchar ? "varchar(" + sqlSize + ")" : "char(" + sqlSize + ")";
                    colExtract = "cast(substring(" + tableName + ".data," + offsetInt + "," + len + ") as " + sqlType + ")";
                    System.out.println("     " + comma + colExtract + " AS " + colName);
                } else {
                    sqlType = "decimal";
                    if (type.equals("NZ")) {
                        sqlSize = "(" + piclen + (place != null ? "," + place : "") + ")";
                        colExtract = "cast(zoned_numeric_bytes(" + tableName + ".data," + offsetInt + "," + len + ") as " + sqlType + sqlSize + ")";
                        System.out.println("     " + comma + colExtract + " AS " + colName);
                    } else if (type.equals("NP")) {
                        if (place != null) {
                            int numOfZeros = 1;
                            try {
                                numOfZeros = Integer.parseInt(place);
                            }
                            catch (NumberFormatException nfe) {
                                numOfZeros = 1;
                            }
                            String format = "%0" + numOfZeros + "d";
                            String strValOfDec = "." + String.format(format, 1);
                            sqlSize = "(" + piclen + "," + place + ")";
                            colExtract = "cast((unpack_numeric_bytes(" + tableName + ".data," + offsetInt + "," + len + ") *" + strValOfDec + ") as " + sqlType + sqlSize + ")";
                            System.out.println("     " + comma + colExtract + " AS " + colName);
                        } else {
                            sqlSize = "(" + piclen + ")";
                            colExtract = "cast(unpack_numeric_bytes(" + tableName + ".data," + offsetInt + "," + len + ") as " + sqlType + sqlSize + ")";
                            System.out.println("     " + comma + colExtract + " AS " + colName);
                        }
                    } else {
                        sqlType = "integer";
                        sqlSize = piclen + ",0";
                        colExtract = "blob_to_int(substring(" + tableName + ".data," + offsetInt + "," + len + ")," + len + ")";
                        System.out.println("     " + comma + colExtract + " AS " + colName);
                    }
                }
                if (commaIsOn) continue;
                comma = ",";
                commaIsOn = true;
            }
            if (isMaterialized) {
                System.out.println("  FROM " + tableName + " )");
                XfdUtils.generateViewWhere();
                System.out.println("DATA INITIALLY DEFERRED");
                System.out.println("REFRESH DEFERRED");
                System.out.println("MAINTAINED BY SYSTEM");
                System.out.println("ENABLE QUERY OPTIMIZATION");
                System.out.println(";");
                System.out.println(" ");
                System.out.println("REFRESH TABLE " + tableName + "_view");
            } else {
                System.out.println("  FROM " + tableName);
                XfdUtils.generateViewWhere();
            }
            System.out.println(";");
        }
        catch (FactoryConfigurationError e) {
            System.err.println("FactoryConfigurationError" + e.getMessage());
        }
        catch (XMLStreamException e) {
            System.err.println("XMLStreamException" + e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            System.err.println("IOException" + e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (outputDDL != null) {
                System.setOut(origSysout);
            }
        }
    }

    static void generateDB2Field2ColumnMapping(String inputXfd, boolean useVarchar, String tableName) {
        try {
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
            XMLStreamReader xmlStreamReader = inputFactory.createXMLStreamReader(new BufferedReader(new FileReader(inputXfd)));
            while (xmlStreamReader.hasNext()) {
                String colExtract;
                int event = xmlStreamReader.next();
                if (event != 1) continue;
                String colName = null;
                String sqlType = null;
                String sqlSize = null;
                String len = null;
                String piclen = null;
                String offset = null;
                String place = null;
                String type = null;
                int offsetInt = 0;
                if (!xmlStreamReader.getLocalName().equals("column")) continue;
                for (int i = 0; i < xmlStreamReader.getAttributeCount(); ++i) {
                    String name = xmlStreamReader.getAttributeLocalName(i);
                    if (name.equals("name")) {
                        colName = xmlStreamReader.getAttributeValue(i).toUpperCase();
                        continue;
                    }
                    if (name.equals("sqltype")) {
                        type = xmlStreamReader.getAttributeValue(i);
                        continue;
                    }
                    if (name.equals("length")) {
                        len = xmlStreamReader.getAttributeValue(i);
                        continue;
                    }
                    if (name.equals("piclen")) {
                        piclen = xmlStreamReader.getAttributeValue(i);
                        continue;
                    }
                    if (name.equals("place")) {
                        place = xmlStreamReader.getAttributeValue(i);
                        continue;
                    }
                    if (!name.equals("offset")) continue;
                    offset = xmlStreamReader.getAttributeValue(i);
                    try {
                        offsetInt = Integer.parseInt(offset);
                    }
                    catch (NumberFormatException nfe) {
                        nfe.printStackTrace();
                        System.exit(99);
                    }
                    ++offsetInt;
                }
                if (type.equals("A")) {
                    sqlSize = piclen;
                    sqlType = useVarchar ? "varchar(" + sqlSize + ")" : "char(" + sqlSize + ")";
                    colExtract = "cast(substring(" + tableName + ".data," + offsetInt + "," + len + ") as " + sqlType + ")";
                    field2ColumnMap.put(colName, colExtract);
                    continue;
                }
                sqlType = "decimal";
                if (type.equals("NZ")) {
                    sqlSize = "(" + piclen + (place != null ? "," + place : "") + ")";
                    colExtract = "cast(zoned_numeric_bytes(" + tableName + ".data," + offsetInt + "," + len + ") as " + sqlType + sqlSize + ")";
                    field2ColumnMap.put(colName, colExtract);
                    continue;
                }
                if (type.equals("NP")) {
                    if (place != null) {
                        int numOfZeros = 1;
                        try {
                            numOfZeros = Integer.parseInt(place);
                        }
                        catch (NumberFormatException nfe) {
                            numOfZeros = 1;
                        }
                        String format = "%0" + numOfZeros + "d";
                        String strValOfDec = "." + String.format(format, 1);
                        sqlSize = "(" + piclen + "," + place + ")";
                        colExtract = "cast((unpack_numeric_bytes(" + tableName + ".data," + offsetInt + "," + len + ") *" + strValOfDec + ") as " + sqlType + sqlSize + ")";
                        field2ColumnMap.put(colName, colExtract);
                        continue;
                    }
                    sqlSize = "(" + piclen + ")";
                    colExtract = "cast(unpack_numeric_bytes(" + tableName + ".data," + offsetInt + "," + len + ") as " + sqlType + sqlSize + ")";
                    field2ColumnMap.put(colName, colExtract);
                    continue;
                }
                sqlType = "integer";
                sqlSize = piclen + ",0";
                colExtract = "blob_to_int(substring(" + tableName + ".data," + offsetInt + "," + len + ")," + len + ")";
                field2ColumnMap.put(colName, colExtract);
            }
        }
        catch (FactoryConfigurationError e) {
            System.err.println("FactoryConfigurationError" + e.getMessage());
        }
        catch (XMLStreamException e) {
            System.err.println("XMLStreamException" + e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            System.err.println("IOException" + e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void generatePostgresView(String inputXfd, String outputDDL, boolean useVarchar) {
        XfdUtils.generatePostgresView(inputXfd, outputDDL, useVarchar, false);
    }

    public static void generatePostgresView(String inputXfd, String outputDDL, boolean useVarchar, boolean isMaterialized) {
        XfdUtils.generatePostgresView(inputXfd, outputDDL, useVarchar, isMaterialized, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generatePostgresView(String inputXfd, String outputDDL, boolean useVarchar, boolean isMaterialized, String tableName) {
        PrintStream origSysout = System.out;
        try {
            PrintStream outPrintStream = null;
            if (outputDDL != null) {
                outPrintStream = new PrintStream(new File(outputDDL));
                System.setOut(outPrintStream);
            }
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
            XMLStreamReader xmlStreamReader = inputFactory.createXMLStreamReader(new BufferedReader(new FileReader(inputXfd)));
            String comma = "";
            boolean commaIsOn = false;
            String layoutName = "";
            boolean firstPass = true;
            while (xmlStreamReader.hasNext()) {
                String colExtract;
                String name;
                int i;
                int event = xmlStreamReader.next();
                if (event != 1) continue;
                String colName = null;
                String sqlType = null;
                String sqlSize = null;
                String len = null;
                String piclen = null;
                String offset = null;
                String place = null;
                String type = null;
                int offsetInt = 0;
                if (firstPass && xmlStreamReader.getLocalName().equals("group")) {
                    for (i = 0; i < xmlStreamReader.getAttributeCount(); ++i) {
                        name = xmlStreamReader.getAttributeLocalName(i);
                        if (!name.equals("name")) continue;
                        layoutName = xmlStreamReader.getAttributeValue(i);
                        firstPass = false;
                        break;
                    }
                    if (isMaterialized) {
                        System.out.println("CREATE MATERIALIZED VIEW " + tableName + "_" + layoutName.replaceAll("\\.", "_") + "_view AS");
                    } else {
                        System.out.println("CREATE VIEW " + tableName + "_" + layoutName.replaceAll("\\.", "_") + "_view AS");
                    }
                    System.out.println("SELECT");
                    continue;
                }
                if (!xmlStreamReader.getLocalName().equals("column")) continue;
                for (i = 0; i < xmlStreamReader.getAttributeCount(); ++i) {
                    name = xmlStreamReader.getAttributeLocalName(i);
                    if (name.equals("name")) {
                        colName = xmlStreamReader.getAttributeValue(i);
                        continue;
                    }
                    if (name.equals("sqltype")) {
                        type = xmlStreamReader.getAttributeValue(i);
                        continue;
                    }
                    if (name.equals("length")) {
                        len = xmlStreamReader.getAttributeValue(i);
                        continue;
                    }
                    if (name.equals("piclen")) {
                        piclen = xmlStreamReader.getAttributeValue(i);
                        continue;
                    }
                    if (name.equals("place")) {
                        place = xmlStreamReader.getAttributeValue(i);
                        continue;
                    }
                    if (!name.equals("offset")) continue;
                    offset = xmlStreamReader.getAttributeValue(i);
                    try {
                        offsetInt = Integer.parseInt(offset);
                    }
                    catch (NumberFormatException nfe) {
                        nfe.printStackTrace();
                        System.exit(99);
                    }
                    ++offsetInt;
                }
                if (type.equals("A")) {
                    sqlSize = piclen;
                    sqlType = useVarchar ? "character varying" : "char(" + sqlSize + ")";
                    colExtract = "encode(substring(" + tableName + ".data," + offsetInt + "," + len + "),'escape')::" + sqlType;
                    System.out.println("     " + comma + colExtract + " AS " + colName);
                } else {
                    String strValOfDec;
                    String format;
                    sqlType = "numeric";
                    if (type.equals("NZ")) {
                        sqlSize = "(" + piclen + (place != null ? "," + place : "") + ")";
                        if (place != null) {
                            int numOfZeros = 1;
                            try {
                                numOfZeros = Integer.parseInt(place);
                            }
                            catch (NumberFormatException nfe) {
                                numOfZeros = 1;
                            }
                            format = "%0" + numOfZeros + "d";
                            strValOfDec = "." + String.format(format, 1);
                            sqlSize = "(" + piclen + "," + place + ")";
                            colExtract = "zoned_numeric_bytes(" + tableName + ".data," + offsetInt + "," + len + ")::" + sqlType + " * " + strValOfDec;
                            System.out.println("     " + comma + colExtract + " AS " + colName);
                        } else {
                            sqlSize = "(" + piclen + ")";
                            colExtract = "zoned_numeric_bytes(" + tableName + ".data," + offsetInt + "," + len + ")::" + sqlType + sqlSize;
                            System.out.println("     " + comma + colExtract + " AS " + colName);
                        }
                    } else if (type.equals("NP")) {
                        sqlSize = "(" + piclen + (place != null ? "," + place : "") + ")";
                        if (place != null) {
                            int numOfZeros = 1;
                            try {
                                numOfZeros = Integer.parseInt(place);
                            }
                            catch (NumberFormatException nfe) {
                                numOfZeros = 1;
                            }
                            format = "%0" + numOfZeros + "d";
                            strValOfDec = "." + String.format(format, 1);
                            sqlSize = "(" + piclen + "," + place + ")";
                            colExtract = "unpack_numeric_bytes(" + tableName + ".data," + offsetInt + "," + len + ")::" + sqlType + " * " + strValOfDec;
                            System.out.println("     " + comma + colExtract + " AS " + colName);
                        } else {
                            sqlSize = "(" + piclen + ")";
                            colExtract = "unpack_numeric_bytes(" + tableName + ".data," + offsetInt + "," + len + ")::" + sqlType;
                            System.out.println("     " + comma + colExtract + " AS " + colName);
                        }
                    } else {
                        sqlSize = piclen + ",0";
                        colExtract = "bytea_to_int(substring(" + tableName + ".data," + offsetInt + "," + len + ")," + len + ")";
                        System.out.println("     " + comma + colExtract + " AS " + colName);
                    }
                }
                if (commaIsOn) continue;
                comma = ",";
                commaIsOn = true;
            }
            System.out.println("  FROM " + tableName);
            XfdUtils.generateViewWhere();
            if (isMaterialized) {
                System.out.println("WITH DATA");
            }
            System.out.println(";");
            outPrintStream.close();
        }
        catch (FactoryConfigurationError e) {
            System.err.println("FactoryConfigurationError" + e.getMessage());
        }
        catch (XMLStreamException e) {
            System.err.println("XMLStreamException" + e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            System.err.println("IOException" + e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (outputDDL != null) {
                System.setOut(origSysout);
            }
        }
    }

    public static void generatePostgresField2ColumnMapping(String inputXfd, boolean useVarchar, String tableName) {
        try {
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
            XMLStreamReader xmlStreamReader = inputFactory.createXMLStreamReader(new BufferedReader(new FileReader(inputXfd)));
            while (xmlStreamReader.hasNext()) {
                String strValOfDec;
                String format;
                String colExtract;
                int event = xmlStreamReader.next();
                if (event != 1) continue;
                String colName = null;
                String sqlType = null;
                String sqlSize = null;
                String len = null;
                String piclen = null;
                String offset = null;
                String place = null;
                String type = null;
                int offsetInt = 0;
                if (!xmlStreamReader.getLocalName().equals("column")) continue;
                for (int i = 0; i < xmlStreamReader.getAttributeCount(); ++i) {
                    String name = xmlStreamReader.getAttributeLocalName(i);
                    if (name.equals("name")) {
                        colName = xmlStreamReader.getAttributeValue(i).toUpperCase();
                        continue;
                    }
                    if (name.equals("sqltype")) {
                        type = xmlStreamReader.getAttributeValue(i);
                        continue;
                    }
                    if (name.equals("length")) {
                        len = xmlStreamReader.getAttributeValue(i);
                        continue;
                    }
                    if (name.equals("piclen")) {
                        piclen = xmlStreamReader.getAttributeValue(i);
                        continue;
                    }
                    if (name.equals("place")) {
                        place = xmlStreamReader.getAttributeValue(i);
                        continue;
                    }
                    if (!name.equals("offset")) continue;
                    offset = xmlStreamReader.getAttributeValue(i);
                    try {
                        offsetInt = Integer.parseInt(offset);
                    }
                    catch (NumberFormatException nfe) {
                        nfe.printStackTrace();
                        System.exit(99);
                    }
                    ++offsetInt;
                }
                if (type.equals("A")) {
                    sqlSize = piclen;
                    sqlType = useVarchar ? "character varying" : "char(" + sqlSize + ")";
                    colExtract = "substring(" + tableName + ".data," + offsetInt + "," + len + ") ";
                    field2ColumnMap.put(colName, colExtract);
                    continue;
                }
                sqlType = "numeric";
                if (type.equals("NZ")) {
                    if (place != null) {
                        int numOfZeros = 1;
                        try {
                            numOfZeros = Integer.parseInt(place);
                        }
                        catch (NumberFormatException nfe) {
                            numOfZeros = 1;
                        }
                        format = "%0" + numOfZeros + "d";
                        strValOfDec = "." + String.format(format, 1);
                        colExtract = "zoned_numeric_bytes(" + tableName + ".data," + offsetInt + "," + len + ")::" + sqlType + " * " + strValOfDec;
                        field2ColumnMap.put(colName, colExtract);
                        continue;
                    }
                    sqlSize = "(" + piclen + ")";
                    colExtract = "zoned_numeric_bytes(" + tableName + ".data," + offsetInt + "," + len + ")::" + sqlType + sqlSize;
                    field2ColumnMap.put(colName, colExtract);
                    continue;
                }
                if (type.equals("NP")) {
                    if (place != null) {
                        int numOfZeros = 1;
                        try {
                            numOfZeros = Integer.parseInt(place);
                        }
                        catch (NumberFormatException nfe) {
                            numOfZeros = 1;
                        }
                        format = "%0" + numOfZeros + "d";
                        strValOfDec = "." + String.format(format, 1);
                        colExtract = "unpack_numeric_bytes(" + tableName + ".data," + offsetInt + "," + len + ")::" + sqlType + " * " + strValOfDec;
                        field2ColumnMap.put(colName, colExtract);
                        continue;
                    }
                    colExtract = "unpack_numeric_bytes(" + tableName + ".data," + offsetInt + "," + len + ")::" + sqlType;
                    field2ColumnMap.put(colName, colExtract);
                    continue;
                }
                colExtract = "bytea_to_int(substring(" + tableName + ".data," + offsetInt + "," + len + ")," + len + ")";
                field2ColumnMap.put(colName, colExtract);
            }
        }
        catch (FactoryConfigurationError e) {
            System.err.println("FactoryConfigurationError" + e.getMessage());
        }
        catch (XMLStreamException e) {
            System.err.println("XMLStreamException" + e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            System.err.println("IOException" + e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void generateMySQLView(String inputXfd, String outputDDL, boolean useVarchar) {
        XfdUtils.generateMySQLView(inputXfd, outputDDL, useVarchar, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateMySQLView(String inputXfd, String outputDDL, boolean useVarchar, String tableName) {
        PrintStream origSysout = System.out;
        try {
            PrintStream outPrintStream = null;
            if (outputDDL != null) {
                outPrintStream = new PrintStream(new File(outputDDL));
                System.setOut(outPrintStream);
            }
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
            XMLStreamReader xmlStreamReader = inputFactory.createXMLStreamReader(new BufferedReader(new FileReader(inputXfd)));
            String comma = "";
            boolean commaIsOn = false;
            String layoutName = "";
            boolean firstPass = true;
            while (xmlStreamReader.hasNext()) {
                String colExtract;
                String name;
                int i;
                int event = xmlStreamReader.next();
                if (event != 1) continue;
                String colName = null;
                String sqlType = null;
                String sqlSize = null;
                String len = null;
                String piclen = null;
                String offset = null;
                String place = null;
                String type = null;
                int offsetInt = 0;
                if (firstPass && xmlStreamReader.getLocalName().equals("group")) {
                    for (i = 0; i < xmlStreamReader.getAttributeCount(); ++i) {
                        name = xmlStreamReader.getAttributeLocalName(i);
                        if (!name.equals("name")) continue;
                        layoutName = xmlStreamReader.getAttributeValue(i);
                        firstPass = false;
                        break;
                    }
                    System.out.println("CREATE VIEW " + tableName + "_" + layoutName.replaceAll("\\.", "_") + "_view AS");
                    System.out.println("SELECT");
                    continue;
                }
                if (!xmlStreamReader.getLocalName().equals("column")) continue;
                for (i = 0; i < xmlStreamReader.getAttributeCount(); ++i) {
                    name = xmlStreamReader.getAttributeLocalName(i);
                    if (name.equals("name")) {
                        colName = xmlStreamReader.getAttributeValue(i);
                        continue;
                    }
                    if (name.equals("sqltype")) {
                        type = xmlStreamReader.getAttributeValue(i);
                        continue;
                    }
                    if (name.equals("length")) {
                        len = xmlStreamReader.getAttributeValue(i);
                        continue;
                    }
                    if (name.equals("piclen")) {
                        piclen = xmlStreamReader.getAttributeValue(i);
                        continue;
                    }
                    if (name.equals("place")) {
                        place = xmlStreamReader.getAttributeValue(i);
                        continue;
                    }
                    if (!name.equals("offset")) continue;
                    offset = xmlStreamReader.getAttributeValue(i);
                    try {
                        offsetInt = Integer.parseInt(offset);
                    }
                    catch (NumberFormatException nfe) {
                        nfe.printStackTrace();
                        System.exit(99);
                    }
                    ++offsetInt;
                }
                if (type.equals("A")) {
                    sqlSize = piclen;
                    sqlType = useVarchar ? "varchar(" + sqlSize + ")" : "char(" + sqlSize + ")";
                    colExtract = "cast(substring(" + tableName + ".data," + offsetInt + "," + len + ") as " + sqlType + ")";
                    System.out.println("     " + comma + colExtract + " AS " + colName);
                } else {
                    sqlType = "decimal";
                    if (type.equals("NZ")) {
                        sqlSize = "(" + piclen + (place != null ? "," + place : "") + ")";
                        colExtract = "cast(zoned_numeric_bytes(" + tableName + ".data," + offsetInt + "," + len + ") as " + sqlType + sqlSize + ")";
                        System.out.println("     " + comma + colExtract + " AS " + colName);
                    } else if (type.equals("NP")) {
                        if (place != null) {
                            int numOfZeros = 1;
                            try {
                                numOfZeros = Integer.parseInt(place);
                            }
                            catch (NumberFormatException nfe) {
                                numOfZeros = 1;
                            }
                            String format = "%0" + numOfZeros + "d";
                            String strValOfDec = "." + String.format(format, 1);
                            sqlSize = "(" + piclen + "," + place + ")";
                            colExtract = "cast((unpack_numeric_bytes(" + tableName + ".data," + offsetInt + "," + len + ") *" + strValOfDec + ") as " + sqlType + sqlSize + ")";
                            System.out.println("     " + comma + colExtract + " AS " + colName);
                        } else {
                            sqlSize = "(" + piclen + ")";
                            colExtract = "cast(unpack_numeric_bytes(" + tableName + ".data," + offsetInt + "," + len + ") as " + sqlType + sqlSize + ")";
                            System.out.println("     " + comma + colExtract + " AS " + colName);
                        }
                    } else {
                        sqlType = "integer";
                        sqlSize = piclen + ",0";
                        colExtract = "blob_to_int(substring(" + tableName + ".data," + offsetInt + "," + len + ")," + len + ")";
                        System.out.println("     " + comma + colExtract + " AS " + colName);
                    }
                }
                if (commaIsOn) continue;
                comma = ",";
                commaIsOn = true;
            }
            System.out.println("  FROM " + tableName);
            XfdUtils.generateViewWhere();
            System.out.println(";");
        }
        catch (FactoryConfigurationError e) {
            System.err.println("FactoryConfigurationError" + e.getMessage());
        }
        catch (XMLStreamException e) {
            System.err.println("XMLStreamException" + e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            System.err.println("IOException" + e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (outputDDL != null) {
                System.setOut(origSysout);
            }
        }
    }

    public static void generateMySQLViewField2ColumnMapping(String inputXfd, boolean useVarchar, String tableName) {
        try {
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
            XMLStreamReader xmlStreamReader = inputFactory.createXMLStreamReader(new BufferedReader(new FileReader(inputXfd)));
            while (xmlStreamReader.hasNext()) {
                String colExtract;
                int event = xmlStreamReader.next();
                if (event != 1) continue;
                String colName = null;
                String sqlType = null;
                String sqlSize = null;
                String len = null;
                String piclen = null;
                String offset = null;
                String place = null;
                String type = null;
                int offsetInt = 0;
                if (!xmlStreamReader.getLocalName().equals("column")) continue;
                for (int i = 0; i < xmlStreamReader.getAttributeCount(); ++i) {
                    String name = xmlStreamReader.getAttributeLocalName(i);
                    if (name.equals("name")) {
                        colName = xmlStreamReader.getAttributeValue(i).toUpperCase();
                        continue;
                    }
                    if (name.equals("sqltype")) {
                        type = xmlStreamReader.getAttributeValue(i);
                        continue;
                    }
                    if (name.equals("length")) {
                        len = xmlStreamReader.getAttributeValue(i);
                        continue;
                    }
                    if (name.equals("piclen")) {
                        piclen = xmlStreamReader.getAttributeValue(i);
                        continue;
                    }
                    if (name.equals("place")) {
                        place = xmlStreamReader.getAttributeValue(i);
                        continue;
                    }
                    if (!name.equals("offset")) continue;
                    offset = xmlStreamReader.getAttributeValue(i);
                    try {
                        offsetInt = Integer.parseInt(offset);
                    }
                    catch (NumberFormatException nfe) {
                        nfe.printStackTrace();
                        System.exit(99);
                    }
                    ++offsetInt;
                }
                if (type.equals("A")) {
                    sqlSize = piclen;
                    sqlType = useVarchar ? "varchar(" + sqlSize + ")" : "char(" + sqlSize + ")";
                    colExtract = "cast(substring(" + tableName + ".data," + offsetInt + "," + len + ") as " + sqlType + ")";
                    field2ColumnMap.put(colName, colExtract);
                    continue;
                }
                sqlType = "decimal";
                if (type.equals("NZ")) {
                    sqlSize = "(" + piclen + (place != null ? "," + place : "") + ")";
                    colExtract = "cast(zoned_numeric_bytes(" + tableName + ".data," + offsetInt + "," + len + ") as " + sqlType + sqlSize + ")";
                    field2ColumnMap.put(colName, colExtract);
                    continue;
                }
                if (type.equals("NP")) {
                    if (place != null) {
                        int numOfZeros = 1;
                        try {
                            numOfZeros = Integer.parseInt(place);
                        }
                        catch (NumberFormatException nfe) {
                            numOfZeros = 1;
                        }
                        String format = "%0" + numOfZeros + "d";
                        String strValOfDec = "." + String.format(format, 1);
                        sqlSize = "(" + piclen + "," + place + ")";
                        colExtract = "cast((unpack_numeric_bytes(" + tableName + ".data," + offsetInt + "," + len + ") *" + strValOfDec + ") as " + sqlType + sqlSize + ")";
                        field2ColumnMap.put(colName, colExtract);
                        continue;
                    }
                    sqlSize = "(" + piclen + ")";
                    colExtract = "cast(unpack_numeric_bytes(" + tableName + ".data," + offsetInt + "," + len + ") as " + sqlType + sqlSize + ")";
                    field2ColumnMap.put(colName, colExtract);
                    continue;
                }
                colExtract = "blob_to_int(substring(" + tableName + ".data," + offsetInt + "," + len + ")," + len + ")";
                field2ColumnMap.put(colName, colExtract);
            }
        }
        catch (FactoryConfigurationError e) {
            System.err.println("FactoryConfigurationError" + e.getMessage());
        }
        catch (XMLStreamException e) {
            System.err.println("XMLStreamException" + e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            System.err.println("IOException" + e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String returnDatabaseHelperFunctions(Database dbType) {
        switch (dbType) {
            case POSTGRES: {
                return XfdUtils.returnPostgresFunctions();
            }
            case MYSQL: 
            case DB2: 
            case ORACLE: {
                return XfdUtils.returnMySQLMariaFunctions();
            }
            case MSSQL_SERVER: {
                return XfdUtils.returnMsSQLFunctions();
            }
        }
        return XfdUtils.returnPostgresFunctions();
    }

    public static String returnPostgresFunctions() {
        StringBuilder sb = new StringBuilder(5000);
        for (String line : pg_helpers) {
            if (line.trim().startsWith("--") || line.trim().isEmpty()) continue;
            sb.append(" " + line.trim() + "\n");
        }
        return sb.toString();
    }

    public static String returnMySQLMariaFunctions() {
        StringBuilder sb = new StringBuilder(5000);
        for (String line : mysqlMariaDB_helpers) {
            if (line.trim().startsWith("--") || line.trim().isEmpty()) continue;
            sb.append(" " + line.trim() + "\n");
        }
        return sb.toString();
    }

    public static String returnMsSQLFunctions() {
        StringBuilder sb = new StringBuilder(5000);
        for (String line : MSSQL_helpers) {
            if (line.trim().startsWith("--") || line.trim().isEmpty()) continue;
            sb.append(" " + line.trim() + "\n");
        }
        return sb.toString();
    }

    private static void printPostgresFunctions() {
        for (String line : pg_helpers) {
            System.out.println(line);
        }
    }

    private static void printMySQLFunctions() {
        for (String line : mysqlMariaDB_helpers) {
            System.out.println(line);
        }
    }

    private static void printSQLServerFunctions() {
        for (String line : MSSQL_helpers) {
            System.out.println(line);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printDatabaseHelperFunctions(String outputDDL, Database dbType, String createSqlText) {
        PrintStream origSysout = System.out;
        try {
            PrintStream outPrintStream = null;
            if (outputDDL != null) {
                outPrintStream = new PrintStream(new File(outputDDL));
                System.setOut(outPrintStream);
            }
            switch (dbType) {
                case POSTGRES: {
                    XfdUtils.printPostgresFunctions();
                    break;
                }
                case MYSQL: 
                case DB2: 
                case ORACLE: {
                    XfdUtils.printMySQLFunctions();
                    break;
                }
                case MSSQL_SERVER: {
                    XfdUtils.printSQLServerFunctions();
                    break;
                }
                default: {
                    XfdUtils.printPostgresFunctions();
                }
            }
            System.out.println(createSqlText);
            outPrintStream.close();
        }
        catch (FactoryConfigurationError e) {
            System.err.println("FactoryConfigurationError" + e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            System.err.println("IOException" + e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (outputDDL != null) {
                System.setOut(origSysout);
            }
        }
    }

    static {
        field2ColumnMap = new HashMap();
        pg_helpers = new String[]{"-- Set bytea output in case default is set to hex                                             ", "DO $$                                                                                         ", "BEGIN                                                                                         ", "   execute 'alter database '||current_database()||' set bytea_output = ''escape''';           ", "END;                                                                                          ", "$$                                                                                            ", "   ;                                                                                          ", "                                                                                              ", "-- Function: public.bytea_to_int(bytea, integer)                                              ", "                                                                                              ", "-- DROP FUNCTION public.bytea_to_int(bytea, integer);                                         ", "                                                                                              ", "CREATE OR REPLACE FUNCTION public.bytea_to_int(                                               ", "    i_bytes bytea,                                                                            ", "    i_bytes_len integer)                                                                      ", "  RETURNS integer AS                                                                          ", "$BODY$               DECLARE                                                                  ", "      v_hex_bytes TEXT;                                                                       ", "      v_ret_val INTEGER;                                                                      ", "      b1 INTEGER;                                                                             ", "      b2 INTEGER;                                                                             ", "      b3 INTEGER;                                                                             ", "      b4 INTEGER;                                                                             ", "                                                                                              ", "   BEGIN                                                                                      ", "       IF i_bytes_len = 1 THEN                                                                ", "             b1 = get_byte(i_bytes, 0);                                                       ", "             v_ret_val = b1;                                                                  ", "       ELSE                                                                                   ", "          IF i_bytes_len = 2 THEN                                                             ", "                b1 = get_byte(i_bytes, 0);                                                    ", "                b2 = get_byte(i_bytes, 1);                                                    ", "                v_ret_val = (b1 << 8) + b2;                                                   ", "          ELSE                                                                                ", "             IF i_bytes_len = 3 THEN                                                          ", "                  b1 = get_byte(i_bytes, 0);                                                  ", "                  b2 = get_byte(i_bytes, 1);                                                  ", "                  b3 = get_byte(i_bytes, 2);                                                  ", "                  v_ret_val = (b1 << 16) + (b2 << 8) + b3;                                    ", "             ELSE                                                                             ", "                IF i_bytes_len = 4 THEN                                                       ", "                     b1 = get_byte(i_bytes, 0);                                               ", "                     b2 = get_byte(i_bytes, 1);                                               ", "                     b3 = get_byte(i_bytes, 2);                                               ", "                     b4 = get_byte(i_bytes, 3);                                               ", "                     v_ret_val = (b1 << 24) + (b2 << 16) + (b3 << 8) + b4;                    ", "                ELSE                                                                          ", "                    RAISE EXCEPTION 'Unimplemented integer size --> %', i_bytes_len           ", "                         USING HINT = 'Please check with programmer';                         ", "                END IF;                                                                       ", "             END IF;                                                                          ", "          END IF;                                                                             ", "       END IF;                                                                                ", "                                                                                              ", "       return v_ret_val;                                                                      ", "                                                                                              ", "   END;$BODY$                                                                                 ", "  LANGUAGE plpgsql VOLATILE                                                                   ", "  COST 100;                                                                                   ", "                                                                                              ", "                                                                                              ", "-- Function: public.pack_numeric_bytes(text, integer)                                         ", "                                                                                              ", "-- DROP FUNCTION public.pack_numeric_bytes(text, integer);                                    ", "                                                                                              ", "CREATE OR REPLACE FUNCTION public.pack_numeric_bytes(                                         ", "    i_numeric_string text,                                                                    ", "    i_pd_size integer)                                                                        ", "  RETURNS text AS                                                                             ", "$BODY$    DECLARE                                                                             ", "                                                                                              ", "      v_numeric_string TEXT;                                                                  ", "      v_hex_string TEXT := '';                                                                ", "      v_ret_pd_string TEXT := '';                                                             ", "      v_num_str_len INTEGER := 0;                                                             ", "      v_sign_ind INTEGER := 0;                                                                ", "      v_remainder INTEGER := 0;                                                               ", "      v_hex_size INTEGER := i_pd_size * 2;                                                    ", "   BEGIN                                                                                      ", "       select position('-' in i_numeric_string) into v_sign_ind;                              ", "       select replace(replace(replace(i_numeric_string,'.',''),'+',''),'-','')                ", "         into v_numeric_string;                                                               ", "       select encode(v_numeric_string::BYTEA,'hex') into v_hex_string;                        ", "       select length(v_hex_string) into v_num_str_len;                                        ", "                                                                                              ", "        FOR i IN 1 .. v_num_str_len LOOP                                                      ", "           v_remainder := i % 2;                                                              ", "           IF v_remainder = 0 THEN                                                            ", "              v_ret_pd_string := v_ret_pd_string || substring(v_hex_string,i,1);              ", "           END IF;                                                                            ", "        END LOOP;                                                                             ", "                                                                                              ", "        IF v_sign_ind = 0 THEN                                                                ", "           v_ret_pd_string := v_ret_pd_string || 'c'::TEXT;                                   ", "        ELSE                                                                                  ", "           v_ret_pd_string := v_ret_pd_string || 'd'::TEXT;                                   ", "        END IF;                                                                               ", "        IF length(v_ret_pd_string) < v_hex_size THEN                                          ", "           v_ret_pd_string := lpad(v_ret_pd_string, v_hex_size, '0');                         ", "        ELSE                                                                                  ", "           v_remainder := length(v_ret_pd_string) - v_hex_size;                               ", "           v_ret_pd_string := substring(v_ret_pd_string from v_remainder);                    ", "        END IF;                                                                               ", "                                                                                              ", "        RETURN v_ret_pd_string;                                                               ", "    END;$BODY$                                                                                ", "  LANGUAGE plpgsql VOLATILE                                                                   ", "  COST 100;                                                                                   ", "                                                                                              ", "                                                                                              ", "-- Function: public.unpack_numeric_bytes(bytea, integer, integer)                             ", "                                                                                              ", "-- DROP FUNCTION public.unpack_numeric_bytes(bytea, integer, integer);                        ", "                                                                                              ", "CREATE OR REPLACE FUNCTION public.unpack_numeric_bytes(                                       ", "    i_bytes bytea,                                                                            ", "    i_bytes_start integer,                                                                    ", "    i_bytes_len integer)                                                                      ", "  RETURNS text AS                                                                             ", "$BODY$            DECLARE                                                                     ", "        v_length INTEGER;                                                                     ", "        v_hex_sign TEXT;                                                                      ", "        v_hex_string TEXT;                                                                    ", "        v_sign TEXT;                                                                          ", "        v_num_edited TEXT;                                                                    ", "                                                                                              ", "    BEGIN                                                                                     ", "        select encode(                                                                        ", "               substring(i_bytes ::bytea from i_bytes_start for i_bytes_len),'hex')           ", "         into v_hex_string;                                                                   ", "        select length(v_hex_string) into v_length;                                            ", "        select substring(v_hex_string from v_length for 1) into v_hex_sign;                   ", "        IF v_hex_sign = 'd' THEN                                                              ", "           v_sign := '-';                                                                     ", "        ELSE                                                                                  ", "           v_sign := '+';                                                                     ", "        END If;                                                                               ", "        select v_sign || substring(v_hex_string from 1 for (v_length - 1)::INTEGER)           ", "          into v_num_edited;                                                                  ", "                                                                                              ", "        RETURN v_num_edited;                                                                  ", "    END;$BODY$                                                                                ", "  LANGUAGE plpgsql VOLATILE                                                                   ", "  COST 100;                                                                                   ", "                                                                                              ", "                                                                                              ", "-- Function: public.zoned_numeric_bytes(bytea, integer, integer)                              ", "                                                                                              ", "-- DROP FUNCTION public.zoned_numeric_bytes(bytea, integer, integer);                         ", "                                                                                              ", "CREATE OR REPLACE FUNCTION public.zoned_numeric_bytes(                                        ", "    i_bytes bytea,                                                                            ", "    i_bytes_start integer,                                                                    ", "    i_bytes_len integer)                                                                      ", "  RETURNS text AS                                                                             ", "$BODY$            DECLARE                                                                     ", "        v_edit_str TEXT;                                                                      ", "        v_length INTEGER;                                                                     ", "        v_x_sign TEXT;                                                                        ", "        v_last_digit TEXT;                                                                    ", "        v_sign TEXT;                                                                          ", "        v_num_edited TEXT;                                                                    ", "                                                                                              ", "    BEGIN                                                                                     ", "      --RAISE INFO 'i_bytes --> %', i_bytes;                                                  ", "        select replace(replace(                                                               ", "            encode(substring(i_bytes from i_bytes_start for i_bytes_len),'escape'::text),' ','0'),'\\00','0')  ", "          into v_edit_str;                                                                    ", "        select length(v_edit_str) into v_length;                                              ", "        select substring(v_edit_str from v_length for 1) into v_x_sign;                       ", "      --RAISE INFO 'v_x_sign --> %', v_x_sign;                                                ", "       IF v_x_sign = 'p' or v_x_sign = '}' THEN                                               ", "          v_sign := '-';                                                                      ", "          v_last_digit := '0';                                                                ", "       ELSE IF v_x_sign = 'q' or v_x_sign = 'J' THEN                                          ", "          v_sign := '-';                                                                      ", "          v_last_digit := '1';                                                                ", "       ELSE IF v_x_sign = 'r' or v_x_sign = 'K' THEN                                          ", "          v_sign := '-';                                                                      ", "          v_last_digit := '2';                                                                ", "       ELSE IF v_x_sign = 's' or v_x_sign = 'L' THEN                                          ", "          v_sign := '-';                                                                      ", "          v_last_digit := '3';                                                                ", "       ELSE IF v_x_sign = 't' or v_x_sign = 'M' THEN                                          ", "          v_sign := '-';                                                                      ", "          v_last_digit := '4';                                                                ", "       ELSE IF v_x_sign = 'u' or v_x_sign = 'N' THEN                                          ", "          v_sign := '-';                                                                      ", "          v_last_digit := '5';                                                                ", "       ELSE IF v_x_sign = 'v' or v_x_sign = 'O' THEN                                          ", "          v_sign := '-';                                                                      ", "          v_last_digit := '6';                                                                ", "       ELSE IF v_x_sign = 'w' or v_x_sign = 'P' THEN                                          ", "          v_sign := '-';                                                                      ", "          v_last_digit := '7';                                                                ", "       ELSE IF v_x_sign = 'x' or v_x_sign = 'Q' THEN                                          ", "          v_sign := '-';                                                                      ", "          v_last_digit := '8';                                                                ", "       ELSE IF v_x_sign = 'y' or v_x_sign = 'R' THEN                                          ", "          v_sign := '-';                                                                      ", "          v_last_digit := '9';                                                                ", "        ELSE                                                                                  ", "           v_sign := '+';                                                                     ", "           v_last_digit := v_x_sign;                                                          ", "        END If;                                                                               ", "        END If;                                                                               ", "        END If;                                                                               ", "        END If;                                                                               ", "        END If;                                                                               ", "        END If;                                                                               ", "        END If;                                                                               ", "        END If;                                                                               ", "        END If;                                                                               ", "        END If;                                                                               ", "      --RAISE INFO 'v_sign --> %', v_sign;                                                    ", "      --RAISE INFO 'v_last_digit --> %', v_last_digit;                                        ", "        IF v_last_digit = '+' or v_last_digit = '-' THEN                                      ", "           select v_edit_str into v_num_edited;                                               ", "           select v_last_digit|| substring(v_edit_str from 1 for (v_length - 1))              ", "             into v_num_edited;                                                               ", "        ELSE                                                                                  ", "           select v_sign || substring(v_edit_str from 1 for (v_length - 1)) || v_last_digit   ", "             into v_num_edited;                                                               ", "        END If;                                                                               ", "                                                                                              ", "      --RAISE INFO 'v_num_edited --> %', v_num_edited;                                        ", "                                                                                              ", "        RETURN v_num_edited;                                                                  ", "    END; $BODY$                                                                               ", "  LANGUAGE plpgsql VOLATILE                                                                   ", "  COST 100;                                                                                   ", "                                                                                              ", "                                                                                              "};
        mysqlMariaDB_helpers = new String[]{"                                                                                              ", "--DROP FUNCTION blob_to_int;                                                                  ", "CREATE FUNCTION blob_to_int(                                                                  ", "    i_blob blob,                                                                              ", "    i_blob_len integer) RETURNS integer                                                       ", "BEGIN                                                                                         ", "      DECLARE v_ret_unsigned INTEGER UNSIGNED;                                                ", "      DECLARE v_hold_unsigned INTEGER UNSIGNED;                                               ", "      DECLARE v_ret_int INTEGER;                                                              ", "      DECLARE i INTEGER;                                                                      ", "                                                                                              ", "      select cast(conv(hex(i_blob),16,10) AS UNSIGNED) into v_ret_unsigned;                   ", "      IF v_ret_unsigned > 2147483647 THEN                                                     ", "           set v_hold_unsigned = cast((4294967296 - v_ret_unsigned) AS UNSIGNED);             ", "           set v_ret_int = cast(v_hold_unsigned AS SIGNED) * -1;                              ", "      ELSE                                                                                    ", "           set v_ret_int = cast(v_ret_unsigned AS SIGNED);                                    ", "      END IF;                                                                                 ", "                                                                                              ", "      RETURN v_ret_int;                                                                       ", "END                                                                                           ", ";                                                                                             ", "                                                                                              ", "--DROP FUNCTION pack_numeric_bytes;                                                           ", "CREATE FUNCTION pack_numeric_bytes(                                                           ", "    i_numeric_string text,                                                                    ", "    i_pd_size integer) RETURNS text                                                           ", "BEGIN                                                                                         ", "      DECLARE v_numeric_string TEXT;                                                          ", "      DECLARE v_hex_string TEXT;                                                              ", "      DECLARE v_ret_pd_string TEXT;                                                           ", "      DECLARE v_num_str_len INTEGER;                                                          ", "      DECLARE v_sign_ind INTEGER;                                                             ", "      DECLARE v_remainder INTEGER;                                                            ", "      DECLARE v_hex_size INTEGER;                                                             ", "      DECLARE i INTEGER;                                                                      ", "                                                                                              ", "                                                                                              ", "      SET v_hex_string = '';                                                                  ", "      SET v_ret_pd_string = '';                                                               ", "      SET v_num_str_len = 0;                                                                  ", "      SET v_sign_ind  = 0;                                                                    ", "      SET v_remainder = 0;                                                                    ", "      SET v_hex_size = i_pd_size * 2;                                                         ", "                                                                                              ", "       select position('-' in i_numeric_string) into v_sign_ind;                              ", "       select replace(replace(replace(i_numeric_string,'.',''),'+',''),'-','')                ", "         into v_numeric_string;                                                               ", "       select hex(v_numeric_string) into v_hex_string;                                        ", "       select length(v_hex_string) into v_num_str_len;                                        ", "                                                                                              ", "      SET i=0;                                                                                ", "      myloop:LOOP                                                                             ", "           SET i = i + 1;                                                                     ", "           IF i > v_num_str_len THEN                                                          ", "              LEAVE myloop;                                                                   ", "          END IF;                                                                             ", "           SET v_remainder = i % 2;                                                           ", "           IF v_remainder = 0 THEN                                                            ", "              select concat(v_ret_pd_string, substring(v_hex_string,i,1))                     ", "                into v_ret_pd_string;                                                         ", "           END IF;                                                                            ", "        END LOOP myloop;                                                                      ", "                                                                                              ", "        IF v_sign_ind = 0 THEN                                                                ", "           select concat(v_ret_pd_string, 'C') into v_ret_pd_string;                          ", "        ELSE                                                                                  ", "           select concat(v_ret_pd_string, 'D') into v_ret_pd_string;                          ", "        END IF;                                                                               ", "                                                                                              ", "        IF length(v_ret_pd_string) < v_hex_size THEN                                          ", "           select lpad(v_ret_pd_string, v_hex_size, '0') into v_ret_pd_string;                ", "        ELSE                                                                                  ", "           SET v_remainder = length(v_ret_pd_string) - v_hex_size;                            ", "           IF v_remainder = 0 THEN                                                            ", "              SET v_remainder = 1;                                                            ", "          END IF;                                                                             ", "           select substring(v_ret_pd_string, v_remainder) into v_ret_pd_string;               ", "        END IF;                                                                               ", "                                                                                              ", "        RETURN (v_ret_pd_string);                                                             ", "END                                                                                           ", ";                                                                                             ", "                                                                                              ", "--DROP FUNCTION unpack_numeric_bytes;                                                         ", "CREATE FUNCTION unpack_numeric_bytes(                                                         ", "    i_bytes blob,                                                                             ", "    i_bytes_start integer,                                                                    ", "    i_bytes_len integer) RETURNS text                                                         ", "BEGIN                                                                                         ", " DECLARE v_length INTEGER;                                                                    ", " DECLARE v_hex_sign TEXT;                                                                     ", " DECLARE v_hex_string TEXT;                                                                   ", " DECLARE v_sign TEXT;                                                                         ", " DECLARE v_num_edited TEXT;                                                                   ", "                                                                                              ", "        select hex(substring(i_bytes,i_bytes_start, i_bytes_len)) into v_hex_string;          ", "        select length(v_hex_string) into v_length;                                            ", "        select substring(v_hex_string,v_length,1) into v_hex_sign;                            ", "        case v_hex_sign                                                                       ", "        when 'D' THEN                                                                         ", "           SET v_sign = '-';                                                                  ", "        ELSE                                                                                  ", "           SET v_sign = '+';                                                                  ", "        END case;                                                                             ", "        set v_length = v_length - 1;                                                          ", "        select concat(v_sign, substring(v_hex_string,1,v_length)) into v_num_edited;          ", "                                                                                              ", "        RETURN (v_num_edited);                                                                ", "END                                                                                           ", ";                                                                                             ", "                                                                                              ", "--DROP FUNCTION zoned_numeric_bytes;                                                          ", "                                                                                              ", "CREATE FUNCTION zoned_numeric_bytes(                                                          ", "    i_bytes blob,                                                                             ", "    i_bytes_start integer,                                                                    ", "    i_bytes_len integer)                                                                      ", "  RETURNS text                                                                                ", "                                                                                              ", "BEGIN                                                                                         ", "  DECLARE v_edit_str TEXT;                                                                    ", "  DECLARE v_length INTEGER;                                                                   ", "  DECLARE v_x_sign TEXT;                                                                      ", "  DECLARE v_last_digit TEXT;                                                                  ", "  DECLARE v_sign TEXT;                                                                        ", "  DECLARE v_num_edited TEXT;                                                                  ", "                                                                                              ", "        select replace(substring(i_bytes,i_bytes_start,i_bytes_len),' ','0')                  ", "          into v_edit_str;                                                                    ", "        call log_msg(concat('v_edit_str is: ', v_edit_str));                                  ", "        select length(v_edit_str) into v_length;                                              ", "        select substring(v_edit_str,v_length,1) into v_x_sign;                                ", "        call log_msg(concat('v_x_sign is: ', v_x_sign));                                      ", "                                                                                              ", "        IF v_x_sign = 'p' THEN                                                                ", "           set v_sign = '-';                                                                  ", "           set v_last_digit = '0';                                                            ", "        ELSE IF v_x_sign = 'q' THEN                                                           ", "           set v_sign = '-';                                                                  ", "           set v_last_digit = '1';                                                            ", "        ELSE IF v_x_sign = 'r' THEN                                                           ", "           set v_sign = '-';                                                                  ", "           set v_last_digit = '2';                                                            ", "        ELSE IF v_x_sign = 's' THEN                                                           ", "           set v_sign = '-';                                                                  ", "           set v_last_digit = '3';                                                            ", "        ELSE IF v_x_sign = 't' THEN                                                           ", "           set v_sign = '-';                                                                  ", "           set v_last_digit = '4';                                                            ", "        ELSE IF v_x_sign = 'u' THEN                                                           ", "           set v_sign = '-';                                                                  ", "           set v_last_digit = '5';                                                            ", "        ELSE IF v_x_sign = 'v' THEN                                                           ", "           set v_sign = '-';                                                                  ", "           set v_last_digit = '6';                                                            ", "        ELSE IF v_x_sign = 'w' THEN                                                           ", "           set v_sign = '-';                                                                  ", "           set v_last_digit = '7';                                                            ", "        ELSE IF v_x_sign = 'x' THEN                                                           ", "           set v_sign = '-';                                                                  ", "           set v_last_digit = '8';                                                            ", "        ELSE IF v_x_sign = 'y' THEN                                                           ", "           set v_sign = '-';                                                                  ", "           set v_last_digit = '9';                                                            ", "        ELSE                                                                                  ", "           set v_sign = '+';                                                                  ", "           set v_last_digit = v_x_sign;                                                       ", "        END If;                                                                               ", "        END If;                                                                               ", "        END If;                                                                               ", "        END If;                                                                               ", "        END If;                                                                               ", "        END If;                                                                               ", "        END If;                                                                               ", "        END If;                                                                               ", "        END If;                                                                               ", "        END If;                                                                               ", "        select concat(v_sign, substring(v_edit_str,1,(v_length - 1)), v_last_digit)           ", "          into v_num_edited;                                                                  ", "                                                                                              ", "                                                                                              ", "        RETURN v_num_edited;                                                                  ", "END                                                                                           ", ";                                                                                             ", "                                                                                              "};
        MSSQL_helpers = new String[]{"                                                                                              ", "IF OBJECT_ID(N'dbo.unpack_numeric_bytes') IS NOT NULL                                         ", "    BEGIN                                                                                     ", "        DROP FUNCTION [dbo].[unpack_numeric_bytes];                                           ", "    END                                                                                       ", "GO                                                                                            ", "                                                                                              ", "CREATE FUNCTION [dbo].[unpack_numeric_bytes] (@InputBinaryStr VARBINARY(256))                 ", "RETURNS VARCHAR(256)                                                                          ", "AS                                                                                            ", "    BEGIN                                                                                     ", "                                                                                              ", "        DECLARE @BinaryStr VARCHAR(256)                                                       ", "        DECLARE @StrLen INTEGER                                                               ", "                                                                                              ", "        SELECT @BinaryStr = convert(varchar,@InputBinaryStr,2)                                ", "                                                                                              ", "        SELECT @StrLen = len(@BinaryStr)                                                      ", "                                                                                              ", "        DECLARE @BinarySign CHAR                                                              ", "        SELECT @BinarySign = substring(@BinaryStr,@StrLen,1)                                  ", "                                                                                              ", "        DECLARE @Sign CHAR                                                                    ", "        IF @BinarySign = 'D'                                                                  ", "           SELECT @Sign = '-'                                                                 ", "        ELSE                                                                                  ", "           SELECT @Sign = '+'                                                                 ", "                                                                                              ", "        DECLARE @NumLen INTEGER                                                               ", "        SELECT @NumLen = @StrLen - 1                                                          ", "                                                                                              ", "        DECLARE @NumStr VARCHAR(256)                                                          ", "        SELECT @NumStr = @Sign + substring(@BinaryStr,1,@NumLen)                              ", "                                                                                              ", "        RETURN (SELECT @NumStr)                                                               ", "    END                                                                                       ", "GO                                                                                            ", "                                                                                              ", "IF OBJECT_ID(N'dbo.zoned_numeric_bytes') IS NOT NULL                                          ", "    BEGIN                                                                                     ", "        DROP FUNCTION [dbo].[zoned_numeric_bytes];                                            ", "    END                                                                                       ", "GO                                                                                            ", "                                                                                              ", "CREATE FUNCTION [dbo].[zoned_numeric_bytes] (@InputBinaryStr VARBINARY(256))                  ", "RETURNS VARCHAR(256)                                                                          ", "AS                                                                                            ", "    BEGIN                                                                                     ", "                                                                                              ", "        DECLARE @CharStr VARCHAR(256)                                                         ", "        DECLARE @StrLen INTEGER                                                               ", "                                                                                              ", "        SELECT @CharStr = convert(varchar,@InputBinaryStr)                                    ", "                                                                                              ", "        SELECT @StrLen = len(@CharStr)                                                        ", "                                                                                              ", "        DECLARE @OverPunchSign CHAR                                                           ", "        SELECT @OverPunchSign = substring(@CharStr,@StrLen,1)                                 ", "                                                                                              ", "        DECLARE @Sign CHAR                                                                    ", "       DECLARE @LastDigit CHAR                                                                ", "        IF @OverPunchSign = 'p'                                                               ", "           (SELECT @Sign = '-'                                                                ", "                 ,@LastDigit = '0')                                                           ", "        ELSE IF @OverPunchSign = 'q'                                                          ", "           (SELECT @Sign = '-'                                                                ", "                 ,@LastDigit = '1')                                                           ", "        ELSE IF @OverPunchSign = 'r'                                                          ", "           (SELECT @Sign = '-'                                                                ", "                 ,@LastDigit = '2')                                                           ", "        ELSE IF @OverPunchSign = 's'                                                          ", "           (SELECT @Sign = '-'                                                                ", "                 ,@LastDigit = '3')                                                           ", "        ELSE IF @OverPunchSign = 't'                                                          ", "           (SELECT @Sign = '-'                                                                ", "                 ,@LastDigit = '4')                                                           ", "        ELSE IF @OverPunchSign = 'u'                                                          ", "           (SELECT @Sign = '-'                                                                ", "                 ,@LastDigit = '5')                                                           ", "        ELSE IF @OverPunchSign = 'v'                                                          ", "           (SELECT @Sign = '-'                                                                ", "                 ,@LastDigit = '6')                                                           ", "        ELSE IF @OverPunchSign = 'w'                                                          ", "           (SELECT @Sign = '-'                                                                ", "                 ,@LastDigit = '7')                                                           ", "        ELSE IF @OverPunchSign = 'x'                                                          ", "           (SELECT @Sign = '-'                                                                ", "                 ,@LastDigit = '8')                                                           ", "        ELSE IF @OverPunchSign = 'y'                                                          ", "           (SELECT @Sign = '-'                                                                ", "                 ,@LastDigit = '9')                                                           ", "       ELSE                                                                                   ", "          (SELECT @Sign = '+'                                                                 ", "                 ,@LastDigit = @OverPunchSign)                                                ", "                                                                                              ", "                                                                                              ", "        DECLARE @NumLen INTEGER                                                               ", "        SELECT @NumLen = @StrLen - 1                                                          ", "                                                                                              ", "        DECLARE @NumStr VARCHAR(256)                                                          ", "        SELECT @NumStr = @Sign + substring(@CharStr,1,@NumLen) + @LastDigit                   ", "                                                                                              ", "        RETURN (SELECT @NumStr)                                                               ", "    END                                                                                       ", "GO                                                                                            ", "                                                                                              "};
    }

    public static enum Database {
        POSTGRES,
        MYSQL,
        DB2,
        ORACLE,
        MSSQL_SERVER;

    }
}

