/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.util;

import com.heirloomcomputing.ecs.util.XfdUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class vdbgen {
    static String profDirLoc;
    static String profFileLoc;
    static String CURR_PROF_VERSION;
    static ArrayList<String> includedLayouts;
    static ArrayList<String> excludedLayouts;
    static HashMap<String, String> renamedLayouts;
    static HashMap<String, String> redefUseMap;
    static HashMap<String, String> redefIterFileMap;
    static HashMap<String, String> layoutRedefIterMap;
    static String useVarchar;
    static boolean varChar;
    static String genMatView;
    static boolean matView;
    static String dbms;
    static String xfdFileName;
    static String sqlFileName;
    static BufferedWriter bw;
    static BufferedWriter bwRedef;
    static StringBuilder sqlgen;
    static String currLayout;
    static String defLayout;
    static boolean iterateRedef;
    static String datasetGroupID;
    static String redefinesID;
    static ArrayList<String> redefProcess;
    static ArrayList<String> redefinesList;

    private static void help() {
        System.out.println("");
        System.out.println("");
        System.out.println("java -cp [/path/to/ecoboljar] com.heirloomcomputing.ecs.util.vdbgen  [help] [key=value] xxx.properties");
        System.out.println("");
        System.out.println("     help        - Display help Information");
        System.out.println("");
        System.out.println("     key:value   - Override key=value specified in xxx.properties file");
        System.out.println("                   Note: Value for Key=Value pairs that contains spaces should be enclosed within quotes");
        System.out.println("                   The following are the Key=Value pairs that may be specified either in the command line");
        System.out.println("                   or the properties file.");
        System.out.println("");
        System.out.println("     XFD-FILE=filename-path ");
        System.out.println("     Either the absolute location path of the input xfd xml file or its location relative to the properties file");
        System.out.println("");
        System.out.println("     SQL-FILE=filename-path ");
        System.out.println("     Either the absolute location path of the output SQL generate file or its location relative to the properties file");
        System.out.println("");
        System.out.println("     DBMS=POSTGRES|MYSQL|DB2|ORACLE|MSSQL_SERVER  ");
        System.out.println("     Name of the database for which to generate the SQL");
        System.out.println("");
        System.out.println("     USE-VARCHAR=TRUE|FALSE  ");
        System.out.println("     Use VARCHAR declaration whereever CHAR PIC(X) is in use");
        System.out.println("");
        System.out.println("     MATERIALIZED-VIEW=TRUE|FALSE  ");
        System.out.println("     Create SQL for materialized View");
        System.out.println("");
        System.out.println("     INCLUDE-LAYOUTS=Layout1,Layout2,Layout3,.....  ");
        System.out.println("     Used to include layouts within a multi-layout XFD for which to generate create SQL");
        System.out.println("");
        System.out.println("     EXCLUDE-LAYOUTS=Layout1,Layout2,Layout3,.....  ");
        System.out.println("     Used to exclude layouts within a multi-layout XFD");
        System.out.println("");
        System.out.println("     RENAME-LAYOUTS=Layout1:MyLayout,Layout2:UrLayout,Layout3:HisLayout,.....  ");
        System.out.println("     Used to override the layout field name during SQL generation");
        System.out.println("");
        System.out.println("     REDEFINES_USE= <Layout>.<RedefinedField1>:<RedefiningField1>,.......");
        System.out.println("     where <layout> is the name of the top 01 level record field");
        System.out.println("           <RedefinedField1> is the name of the base field that is being redefined");
        System.out.println("           <RedefiningField1> is the name of the redefining field to be used when creating the view");
        System.out.println("     The <layout> qualifier is required when multiple layouts (01 levels) are present");
        System.out.println("     If the <layout> qualifier is not present, the field is processed for every layout encountered");
        System.out.println("     For e.g.");
        System.out.println("     REDEFINES_USE=Layout1.RedefinedA:RedefinesA2,Layout2.RedefinedB:RedefinesB1");
        System.out.println("     ");
        System.out.println("     The default behavior when REDEFINES_USE is not specified is to use the base field being redefined to create the view");
        System.out.println("     Specifying * as the redefining field will create a view consisting of the base redefined field and also views for each of ");
        System.out.println("     redefining fields of that base redefined field");
        System.out.println("     For e.g.");
        System.out.println("     REDEFINES_USE=field1:*");
        System.out.println("     Note the * can be specified for only one redefining field. If multiple redefines are present, the others will all default to ");
        System.out.println("     base redefined field unless specified otherwise");
        System.out.println("     01 L1.");
        System.out.println("        05 A.");
        System.out.println("        05 B.");
        System.out.println("        05 B1 redefines B.");
        System.out.println("        05 B2 redefines B.");
        System.out.println("        05 B3 redefines B.");
        System.out.println("        05 C.");
        System.out.println("        05 D.");
        System.out.println("        05 D1 redefines D.");
        System.out.println("        05 D2 redefines D.");
        System.out.println("        05 D3 redefines D.");
        System.out.println("        05 E.");
        System.out.println("        05 F.");
        System.out.println("        05 F1 redefines F.");
        System.out.println("        05 F2 redefines F.");
        System.out.println("        05 F3 redefines F.");
        System.out.println("        05 G.");
        System.out.println("     ");
        System.out.println("     For the above layout consider the following scenarios");
        System.out.println("     1) REDEFINES_USE not specified or default behavior");
        System.out.println("        View created = V(A,B,C,D,E,F,G");
        System.out.println("     2)REDEFINES_USE=B:B2,F:F3");
        System.out.println("        View created = V(A,B2,C,D,E,F3,G");
        System.out.println("     3)REDEFINES_USE=D:*,F:F2");
        System.out.println("        View/s created = V(A,B2,C,D, E,F2,G");
        System.out.println("                         V(A,B2,C,D1,E,F2,G");
        System.out.println("                         V(A,B2,C,D2,E,F2,G");
        System.out.println("                         V(A,B2,C,D3,E,F2,G");
        System.out.println("     4)REDEFINES_USE=*   Same as (3) but applies the * to the first redefines within the layout");
        System.out.println("        View/s created = V(A,B, C,D,E,F,G");
        System.out.println("                         V(A,B1,C,D,E,F,G");
        System.out.println("                         V(A,B2,C,D,E,F,G");
        System.out.println("                         V(A,B3,C,D,E,F,G");
    }

    public static void main(String[] args) {
        if (args == null || args.length == 0) {
            args = new String[]{"help"};
        }
        String arg = null;
        for (int i = 0; i < args.length; ++i) {
            arg = args[i];
            if (arg.equalsIgnoreCase("help") || arg.equalsIgnoreCase("?")) {
                vdbgen.help();
                System.exit(0);
                continue;
            }
            if (arg.endsWith(".properties")) {
                profFileLoc = arg;
                continue;
            }
            String[] keyval = arg.split("=", 2);
            if (keyval.length != 2) {
                System.out.println("Parameter Error:" + arg);
                System.exit(0);
            }
            vdbgen.setKeyValues(keyval[0], keyval[1].trim());
        }
        if (!profFileLoc.isEmpty()) {
            try {
                Properties profProp = new Properties();
                FileInputStream inStream = null;
                File profFile = new File(profFileLoc);
                inStream = new FileInputStream(profFile);
                if (inStream != null) {
                    String abspath = profFile.getAbsolutePath();
                    profDirLoc = abspath.substring(0, abspath.lastIndexOf(File.separatorChar));
                    profProp.load(inStream);
                    String version = profProp.getProperty("PROF-VERSION");
                    if (version == null || !version.equals(CURR_PROF_VERSION)) {
                        System.out.println("Invalid version profile file:" + version);
                        ((InputStream)inStream).close();
                        System.exit(0);
                        return;
                    }
                    for (Map.Entry<Object, Object> keyval : profProp.entrySet()) {
                        vdbgen.setKeyValues((String)keyval.getKey(), (String)keyval.getValue());
                    }
                    ((InputStream)inStream).close();
                }
            }
            catch (Exception err) {
                if (err.getMessage() == null) {
                    System.out.println("Error in VDB generation:" + err.toString());
                } else {
                    System.out.println("Error in VDB generation:" + err.getMessage());
                }
                err.printStackTrace();
                System.exit(0);
            }
        }
        if (xfdFileName == null || xfdFileName.trim().isEmpty()) {
            System.out.println("Input XFD not specified");
            System.exit(1);
        }
        if (sqlFileName == null || sqlFileName.trim().isEmpty()) {
            sqlFileName = xfdFileName + ".sql";
            System.out.println("SQL generated to output file:\n" + sqlFileName);
        }
        if (dbms.trim().isEmpty()) {
            System.out.println("DBMS not specified");
            System.exit(1);
        }
        vdbgen.processXfdXml();
        XfdUtils.printDatabaseHelperFunctions(sqlFileName, XfdUtils.Database.valueOf(dbms), sqlgen.toString());
        System.out.println("SQL Generation completed:");
    }

    static void processXfdXml() {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        try {
            File file2 = new File(xfdFileName);
            DocumentBuilder dBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document xfdxml = dBuilder.parse(file2);
            if (xfdxml.hasChildNodes()) {
                NodeList nodeList = xfdxml.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node tempNode = nodeList.item(i);
                    if (tempNode.getNodeType() != 1 || !tempNode.getNodeName().equalsIgnoreCase("dataset") || !tempNode.hasChildNodes()) continue;
                    NodeList recLayouts = tempNode.getChildNodes();
                    for (int j = 0; j < recLayouts.getLength(); ++j) {
                        Node fieldNode = recLayouts.item(j);
                        if (fieldNode.getNodeType() != 1 || !fieldNode.getNodeName().equalsIgnoreCase("group") && !fieldNode.getNodeName().equalsIgnoreCase("column")) continue;
                        NamedNodeMap nodeMap = fieldNode.getAttributes();
                        currLayout = nodeMap.getNamedItem("name").getNodeValue().toUpperCase();
                        if (defLayout.isEmpty()) {
                            defLayout = currLayout;
                            String defIter = layoutRedefIterMap.get("");
                            if (defIter != null) {
                                layoutRedefIterMap.replace(defLayout, defIter);
                            }
                        }
                        if (fieldNode.getNodeName().equalsIgnoreCase("column")) continue;
                        vdbgen.parseRedefines(fieldNode.getChildNodes());
                    }
                }
                Iterator<Map.Entry<String, String>> iter = layoutRedefIterMap.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry<String, String> set = iter.next();
                    if (redefinesList.contains(set.getKey() + "." + set.getValue())) continue;
                    iter.remove();
                }
            }
            if ((xfdxml = dBuilder.parse(file2)).hasChildNodes()) {
                vdbgen.processRecordLayouts(xfdxml.getChildNodes());
            }
        }
        catch (FactoryConfigurationError e) {
            System.err.println("FactoryConfigurationError" + e.getMessage());
            System.exit(1);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.err.println("IOException" + e.getMessage());
            System.exit(1);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static void parseRedefines(NodeList fieldNodeList) {
        for (int count = 0; count < fieldNodeList.getLength(); ++count) {
            Node fieldNode = fieldNodeList.item(count);
            if (fieldNode.getNodeType() != 1) continue;
            NamedNodeMap nodeAttrMap = fieldNode.getAttributes();
            Node redefAttr = nodeAttrMap.getNamedItem("redefines");
            if (redefAttr != null) {
                String redefines = nodeAttrMap.getNamedItem("redefines").getNodeValue().toUpperCase();
                if (!redefinesList.contains(currLayout + "." + redefines)) {
                    redefinesList.add(currLayout + "." + redefines);
                }
                if (iterateRedef && layoutRedefIterMap.get(currLayout) == null) {
                    layoutRedefIterMap.put(currLayout, redefines);
                }
            }
            if (!fieldNode.hasChildNodes()) continue;
            vdbgen.parseRedefines(fieldNode.getChildNodes());
        }
    }

    private static void processRecordLayouts(NodeList nodeList) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node tempNode = nodeList.item(i);
            if (tempNode.getNodeType() != 1 || !tempNode.getNodeName().equalsIgnoreCase("dataset") || !tempNode.hasChildNodes()) continue;
            NodeList recLayouts = tempNode.getChildNodes();
            for (int j = 0; j < recLayouts.getLength(); ++j) {
                Node fieldNode = recLayouts.item(j);
                if (fieldNode.getNodeType() != 1 || !fieldNode.getNodeName().equalsIgnoreCase("group") && !fieldNode.getNodeName().equalsIgnoreCase("column")) continue;
                NamedNodeMap nodeMap = fieldNode.getAttributes();
                currLayout = nodeMap.getNamedItem("name").getNodeValue().toUpperCase();
                if (includedLayouts.size() != 0 && (includedLayouts.size() <= 0 || !includedLayouts.contains(currLayout)) || excludedLayouts.size() != 0 && (excludedLayouts.size() <= 0 || excludedLayouts.contains(currLayout))) continue;
                redefProcess.clear();
                redefIterFileMap.clear();
                String currLayoutName = currLayout;
                if (renamedLayouts.containsKey(currLayout)) {
                    currLayoutName = renamedLayouts.get(currLayout);
                }
                String tempInputXFD = System.getProperty("java.io.tmpdir") + File.separator + "tempInputXfd" + UUID.randomUUID() + ".xml";
                String tempOutputView = System.getProperty("java.io.tmpdir") + File.separator + "tempInputXfd" + UUID.randomUUID() + ".sql";
                File tempInputFile = new File(tempInputXFD);
                try {
                    FileOutputStream fos = new FileOutputStream(tempInputFile);
                    bw = new BufferedWriter(new OutputStreamWriter(fos));
                    bw.write("<?xml version=\"1.0\" standalone=\"yes\"?>\n");
                    if (layoutRedefIterMap.get(currLayout) != null) {
                        bw.write(datasetGroupID + "\n");
                    } else {
                        bw.write("<dataset name=\"" + currLayoutName + "\" charset=\"\">\n");
                        bw.write("<group name=\"" + currLayoutName + "\" >\n");
                    }
                    if (fieldNode.getNodeName().equalsIgnoreCase("column")) {
                        bw.write("<column name=\"" + currLayoutName + "\" offset=\"" + nodeMap.getNamedItem("offset").getNodeValue() + "\" length=\"" + nodeMap.getNamedItem("length").getNodeValue() + "\" piclen=\"" + nodeMap.getNamedItem("piclen").getNodeValue() + "\" sqltype=\"" + nodeMap.getNamedItem("sqltype").getNodeValue());
                        if (nodeMap.getNamedItem("place") != null) {
                            bw.write("\" place=\"" + nodeMap.getNamedItem("place").getNodeValue() + "\"/>\n");
                        } else {
                            bw.write("\"/>\n");
                        }
                    } else {
                        vdbgen.processFields(fieldNode.getChildNodes());
                    }
                    bw.write("</group>\n");
                    bw.write("</dataset>\n");
                    bw.close();
                    fos.close();
                    if (layoutRedefIterMap.get(currLayout) != null) {
                        for (Map.Entry<String, String> entryset : redefIterFileMap.entrySet()) {
                            String tmpViewXFDinput = System.getProperty("java.io.tmpdir") + File.separator + "IterXfdFile" + UUID.randomUUID() + ".xml";
                            File tmpViewXfdFile = new File(tmpViewXFDinput);
                            FileOutputStream outputStream2 = new FileOutputStream(tmpViewXfdFile);
                            BufferedWriter bufferedWriter2 = new BufferedWriter(new OutputStreamWriter(outputStream2));
                            String iterFileName = entryset.getValue();
                            File iterFile = new File(iterFileName);
                            FileInputStream inputStream1 = new FileInputStream(iterFile);
                            BufferedReader redefFileReader = new BufferedReader(new InputStreamReader(inputStream1));
                            FileInputStream mainInputStream = new FileInputStream(tempInputFile);
                            BufferedReader brMainFile = new BufferedReader(new InputStreamReader(mainInputStream));
                            String mainFileLine = brMainFile.readLine();
                            while (mainFileLine != null) {
                                if (mainFileLine.equals(datasetGroupID)) {
                                    bufferedWriter2.write("<dataset name=\"" + currLayoutName + "_" + entryset.getKey() + "\" charset=\"\">\n");
                                    bufferedWriter2.write("<group name=\"" + currLayoutName + "_" + entryset.getKey() + "\" >\n");
                                } else if (mainFileLine.equals(redefinesID)) {
                                    String redefLine = redefFileReader.readLine();
                                    while (redefLine != null) {
                                        bufferedWriter2.write(redefLine);
                                        redefLine = redefFileReader.readLine();
                                    }
                                } else {
                                    bufferedWriter2.write(mainFileLine);
                                }
                                mainFileLine = brMainFile.readLine();
                            }
                            bufferedWriter2.close();
                            redefFileReader.close();
                            mainInputStream.close();
                            brMainFile.close();
                            sqlgen.append(new String(Files.readAllBytes(Paths.get(tempOutputView, new String[0]))));
                            iterFile.delete();
                            tmpViewXfdFile.delete();
                            File tempOutputFile = new File(tempOutputView);
                            tempOutputFile.delete();
                        }
                        tempInputFile.delete();
                    } else {
                        sqlgen.append(new String(Files.readAllBytes(Paths.get(tempOutputView, new String[0]))));
                        tempInputFile.delete();
                        File tempOutputFile = new File(tempOutputView);
                        tempOutputFile.delete();
                    }
                }
                catch (IOException ioerr) {
                    System.out.println("Generate View SQL:-" + ioerr.getMessage());
                    System.exit(1);
                }
                for (String str : redefProcess) {
                    System.out.println("Unable to process redefines field :-" + str);
                }
                if (redefProcess.size() <= 0) continue;
                System.out.println("Syntax  REDEFINES_USE= <Layout>.<RedefinedField1>:<RedefiningField1>,.......");
            }
        }
    }

    private static boolean processIterRedefines(String redefField, String redefines, Node fieldNode) throws IOException {
        String redefFld = layoutRedefIterMap.get(currLayout);
        if (redefFld != null && redefFld.equalsIgnoreCase(redefines)) {
            if (bwRedef == null) {
                String redefFileName = System.getProperty("java.io.tmpdir") + File.separator + "redefField" + UUID.randomUUID() + ".xml";
                File redefFile = new File(redefFileName);
                FileOutputStream redefFos = new FileOutputStream(redefFile);
                bwRedef = new BufferedWriter(new OutputStreamWriter(redefFos));
                if (fieldNode.hasChildNodes()) {
                    vdbgen.processFields(fieldNode.getChildNodes());
                } else {
                    NamedNodeMap nodeAttrMap = fieldNode.getAttributes();
                    bwRedef.write("<column name=\"" + redefField + "\" offset=\"" + nodeAttrMap.getNamedItem("offset").getNodeValue() + "\" length=\"" + nodeAttrMap.getNamedItem("length").getNodeValue() + "\" piclen=\"" + nodeAttrMap.getNamedItem("piclen").getNodeValue() + "\" sqltype=\"" + nodeAttrMap.getNamedItem("sqltype").getNodeValue());
                    if (nodeAttrMap.getNamedItem("place") != null) {
                        bwRedef.write("\" place=\"" + nodeAttrMap.getNamedItem("place").getNodeValue() + "\"/>\n");
                    } else {
                        bwRedef.write("\"/>\n");
                    }
                }
                bwRedef.close();
                redefFos.close();
                bwRedef = null;
                redefIterFileMap.put(redefField, redefFileName);
                bw.write(redefinesID + "\n");
                return true;
            }
            System.out.println("Duplicate nested redefines:[" + currLayout + "." + redefField + "] Iterative processings will not be performed.");
            System.out.println("Use the $XFD Name directive to rename duplicate fields.");
        }
        return false;
    }

    private static void processFields(NodeList fieldNodeList) throws IOException {
        for (int count = 0; count < fieldNodeList.getLength(); ++count) {
            Node fieldNode = fieldNodeList.item(count);
            if (fieldNode.getNodeType() != 1) continue;
            NamedNodeMap nodeAttrMap = fieldNode.getAttributes();
            Node redefAttr = nodeAttrMap.getNamedItem("redefines");
            String fieldName = nodeAttrMap.getNamedItem("name").getNodeValue().toUpperCase();
            if (redefAttr != null) {
                String redefMap;
                String redefines = nodeAttrMap.getNamedItem("redefines").getNodeValue().toUpperCase();
                if (vdbgen.processIterRedefines(fieldName, redefines, fieldNode) || (redefMap = vdbgen.locatefield(redefines)) == null || !redefMap.equalsIgnoreCase(fieldName)) continue;
                redefProcess.remove(currLayout + "." + redefines);
            } else if (redefinesList.contains(currLayout + "." + fieldName)) {
                if (vdbgen.processIterRedefines(fieldName, fieldName, fieldNode)) continue;
                redefProcess.add(currLayout + "." + fieldName);
                String redefMap = vdbgen.locatefield(fieldName);
                if (redefMap != null && !redefMap.equalsIgnoreCase(fieldName)) continue;
                redefProcess.remove(currLayout + "." + fieldName);
            }
            if (fieldNode.hasChildNodes()) {
                vdbgen.processFields(fieldNode.getChildNodes());
                continue;
            }
            BufferedWriter currBw = bwRedef != null ? bwRedef : bw;
            currBw.write("<column name=\"" + fieldName + "\" offset=\"" + nodeAttrMap.getNamedItem("offset").getNodeValue() + "\" length=\"" + nodeAttrMap.getNamedItem("length").getNodeValue() + "\" piclen=\"" + nodeAttrMap.getNamedItem("piclen").getNodeValue() + "\" sqltype=\"" + nodeAttrMap.getNamedItem("sqltype").getNodeValue());
            if (nodeAttrMap.getNamedItem("place") != null) {
                currBw.write("\" place=\"" + nodeAttrMap.getNamedItem("place").getNodeValue() + "\"/>\n");
                continue;
            }
            currBw.write("\"/>\n");
        }
    }

    private static String locatefield(String fieldName) {
        if (redefUseMap.containsKey(fieldName)) {
            return redefUseMap.get(fieldName);
        }
        if (redefUseMap.containsKey(currLayout + "." + fieldName)) {
            return redefUseMap.get(currLayout + "." + fieldName);
        }
        return null;
    }

    static void setKeyValues(String key, String val) {
        if ((key = key.toUpperCase()).equals("PROF-VERSION")) {
            return;
        }
        if (key.equals("XFD-FILE")) {
            if (xfdFileName.isEmpty()) {
                File ifile = new File(val);
                if (ifile.isAbsolute()) {
                    xfdFileName = val;
                } else {
                    File resFile = new File(profDirLoc, val);
                    try {
                        xfdFileName = resFile.getCanonicalPath();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        System.exit(1);
                    }
                }
            }
        } else if (key.equals("SQL-FILE")) {
            if (sqlFileName.isEmpty()) {
                File ifile = new File(val);
                if (ifile.isAbsolute()) {
                    sqlFileName = val;
                } else {
                    File resFile = new File(profDirLoc, val);
                    try {
                        sqlFileName = resFile.getCanonicalPath();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        System.exit(1);
                    }
                }
            }
        } else if (key.equals("REDEFINES_USE")) {
            if (redefUseMap.isEmpty() && !iterateRedef) {
                String[] vals;
                if (val.equals("*")) {
                    iterateRedef = true;
                    return;
                }
                for (String redefValue : vals = val.toUpperCase().split(",")) {
                    String[] redef = redefValue.split(":");
                    if (redef.length != 2) continue;
                    if (redef[1].equals("*")) {
                        int idx = redef[0].indexOf(46);
                        if (idx == -1) {
                            if (layoutRedefIterMap.containsKey("")) {
                                System.out.println("Warning. Multiple '*' found in REDEFINES_USE. " + redef[0] + ":* will be ignored.");
                                continue;
                            }
                            layoutRedefIterMap.put("", redef[0]);
                            continue;
                        }
                        String skey = redef[0].substring(0, idx);
                        if (layoutRedefIterMap.containsKey(skey)) {
                            System.out.println("Warning. Multiple '*' found in REDEFINES_USE. " + redef[0] + ":* will be ignored.");
                            continue;
                        }
                        layoutRedefIterMap.put(skey, redef[0].substring(idx + 1));
                        continue;
                    }
                    redefUseMap.put(redef[0], redef[1]);
                }
            }
        } else if (key.equals("INCLUDE-LAYOUTS")) {
            if (includedLayouts.isEmpty()) {
                String[] vals;
                for (String layout : vals = val.toUpperCase().split(",")) {
                    includedLayouts.add(layout);
                }
            }
        } else if (key.equals("EXCLUDE-LAYOUTS")) {
            if (excludedLayouts.isEmpty()) {
                String[] vals;
                for (String layout : vals = val.toUpperCase().split(",")) {
                    excludedLayouts.add(layout);
                }
            }
        } else if (key.equals("RENAME-LAYOUTS")) {
            if (renamedLayouts.isEmpty()) {
                String[] vals;
                for (String renames : vals = val.toUpperCase().split(",")) {
                    String[] names = renames.split(":");
                    renamedLayouts.put(names[0], names[1]);
                }
            }
        } else if (key.equals("USE-VARCHAR")) {
            if (useVarchar.isEmpty()) {
                if (val.equalsIgnoreCase("TRUE")) {
                    useVarchar = "TRUE";
                    varChar = true;
                } else {
                    useVarchar = "FALSE";
                    varChar = false;
                }
            }
        } else if (key.equals("DBMS")) {
            if (dbms.isEmpty()) {
                if (val.equalsIgnoreCase("POSTGRES")) {
                    dbms = "POSTGRES";
                } else if (val.equalsIgnoreCase("MYSQL")) {
                    dbms = "MYSQL";
                } else if (val.equalsIgnoreCase("DB2")) {
                    dbms = "DB2";
                } else if (val.equalsIgnoreCase("ORACLE")) {
                    dbms = "ORACLE";
                } else if (val.equalsIgnoreCase("MSSQL_SERVER")) {
                    dbms = "MSSQL_SERVER";
                } else {
                    System.out.println("DBMS not supported:" + val);
                    System.exit(1);
                }
            }
        } else if (key.equals("MATERIALIZED-VIEW")) {
            if (genMatView.isEmpty()) {
                if (val.equalsIgnoreCase("TRUE")) {
                    genMatView = "TRUE";
                    matView = true;
                } else {
                    genMatView = "FALSE";
                    matView = false;
                }
            }
        } else {
            System.out.println("Unknown param :" + key + "=" + val);
        }
    }

    static {
        profFileLoc = "";
        CURR_PROF_VERSION = "1";
        includedLayouts = new ArrayList();
        excludedLayouts = new ArrayList();
        renamedLayouts = new HashMap();
        redefUseMap = new HashMap();
        redefIterFileMap = new HashMap();
        layoutRedefIterMap = new HashMap();
        useVarchar = "";
        varChar = false;
        genMatView = "";
        matView = false;
        dbms = "";
        xfdFileName = "";
        sqlFileName = "";
        bwRedef = null;
        sqlgen = new StringBuilder();
        defLayout = "";
        iterateRedef = false;
        datasetGroupID = "@@@@@";
        redefinesID = "~~~~~";
        redefProcess = new ArrayList();
        redefinesList = new ArrayList();
    }
}

