/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.vse;

import com.heirloomcomputing.ecs.exec.Numeric;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.exec.seqFile;
import com.heirloomcomputing.ecs.exec.smartFile;
import com.heirloomcomputing.ecs.isamsql.DCB;
import com.heirloomcomputing.ecs.isamsql.DCBDB;
import com.heirloomcomputing.ecs.isamsql.DCBFactory;
import java.io.File;
import java.util.Arrays;
import java.util.List;

public class VSEGDGSequentialFile
extends seqFile {
    public static final String ASSGN_GDG_PROTOCOL = "vsegdg:VSEGDG";
    public static final String CURRENT_GDG_GEN = "vse_gdg_card_current_gdg";
    public static final String NEXT_GDG_GEN = "vse_gdg_card_next_gdg";
    public static final String GDG_GLOBAL_PARAM = "vse_gdg_card";
    smartFile fileNext = new smartFile();
    GDGGenerationType genType;
    Mode currentMode;

    @Override
    public boolean open(int mode) {
        String absolutePath = null;
        if ((mode & 1) != 0 && (mode & 2) != 0) {
            absolutePath = this.hasAssignedVSESpecificDD(CURRENT_GDG_GEN);
            this.genType = GDGGenerationType.CURRENT;
            this.currentMode = Mode.READ;
        } else if ((mode & 1) != 0) {
            absolutePath = this.hasAssignedVSESpecificDD(CURRENT_GDG_GEN);
            this.genType = GDGGenerationType.CURRENT;
            this.currentMode = Mode.READ;
        } else if ((mode & 2) != 0) {
            absolutePath = this.hasAssignedVSESpecificDD(NEXT_GDG_GEN);
            this.changeModifiedTime(absolutePath);
            this.genType = GDGGenerationType.NEXT;
            this.currentMode = Mode.WRITE;
        } else if ((mode & 4) != 0) {
            absolutePath = this.hasAssignedVSESpecificDD(NEXT_GDG_GEN);
            this.changeModifiedTime(absolutePath);
            this.genType = GDGGenerationType.NEXT;
            this.currentMode = Mode.WRITE;
        }
        RuntimeEnvironment.setGlobalParameter(this.ddName, absolutePath);
        this.resetResolvedAliasParameters();
        this.setFilename(this.ddName);
        return super.open(mode);
    }

    private void resetResolvedAliasParameters() {
        String[] splits = this.ddName.split("[_-]");
        String resolvedAlias = null;
        if (splits.length > 1) {
            resolvedAlias = splits[splits.length - 1];
        }
        if (resolvedAlias != null) {
            RuntimeEnvironment.setGlobalParameter(CURRENT_GDG_GEN + resolvedAlias, null);
            RuntimeEnvironment.setGlobalParameter(NEXT_GDG_GEN + resolvedAlias, null);
        }
    }

    private void changeModifiedTime(String path) {
        File fileName = new File(path);
        DCB dcb = DCBFactory.getInstance(fileName.getName(), fileName.getAbsolutePath());
        if (dcb instanceof DCBDB) {
            dcb.loadDCB(true);
            dcb.setLabel(1);
            dcb.saveDCB();
        }
    }

    private String hasAssignedVSESpecificDD(String gdgGenerationParam) {
        String vseDDCards = RuntimeEnvironment.getGlobalParameter(GDG_GLOBAL_PARAM);
        List<String> ddCardsNames = Arrays.asList(vseDDCards.split(","));
        for (String gdgName : ddCardsNames) {
            if (!this.ddName.toLowerCase().startsWith(gdgName.toLowerCase()) && !this.ddName.toLowerCase().endsWith(gdgName.toLowerCase())) continue;
            return RuntimeEnvironment.getGlobalParameter(gdgGenerationParam + gdgName);
        }
        return null;
    }

    @Override
    public int read(byte[] data) {
        if (GDGGenerationType.BOTH == this.genType) {
            this.currentMode = Mode.READ;
        }
        return super.read(data);
    }

    @Override
    public boolean read(Variable data, int determineSize) {
        if (GDGGenerationType.BOTH == this.genType) {
            this.currentMode = Mode.READ;
        }
        return super.read(data, determineSize);
    }

    @Override
    public boolean read(Variable data) {
        if (GDGGenerationType.BOTH == this.genType) {
            this.currentMode = Mode.READ;
        }
        return super.read(data);
    }

    @Override
    public boolean read(Variable data, int mode, Numeric timeout) {
        if (GDGGenerationType.BOTH == this.genType) {
            this.currentMode = Mode.READ;
        }
        return super.read(data, mode, timeout);
    }

    @Override
    public boolean write(Variable data, boolean printSequential) {
        if (GDGGenerationType.BOTH == this.genType) {
            this.currentMode = Mode.WRITE;
        }
        return super.write(data, printSequential);
    }

    @Override
    public boolean write(Variable data, int mode, Numeric timeout, boolean printSequential) {
        if (GDGGenerationType.BOTH == this.genType) {
            this.currentMode = Mode.WRITE;
        }
        return super.write(data, mode, timeout, printSequential);
    }

    @Override
    public boolean rewrite(Variable data, boolean printSequential) {
        if (GDGGenerationType.BOTH == this.genType) {
            this.currentMode = Mode.REWRITE;
        }
        return super.rewrite(data, printSequential);
    }

    @Override
    public boolean rewrite(Variable data, int mode, Numeric timeout, boolean printSequential) {
        if (GDGGenerationType.BOTH == this.genType) {
            this.currentMode = Mode.REWRITE;
        }
        return super.rewrite(data, mode, timeout, printSequential);
    }

    @Override
    protected smartFile getFile() {
        if (this.genType == GDGGenerationType.BOTH) {
            if (Mode.READ == this.currentMode || Mode.REWRITE == this.currentMode) {
                return super.getFile();
            }
            if (Mode.WRITE == this.currentMode) {
                return this.fileNext;
            }
        }
        return super.getFile();
    }

    private static enum Mode {
        READ,
        REWRITE,
        WRITE;

    }

    private static enum GDGGenerationType {
        CURRENT,
        NEXT,
        BOTH;

    }
}

