/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.xio;

import com.heirloomcomputing.ecs.exec.Numeric;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.exec.idxFile;
import com.heirloomcomputing.ecs.util.HexUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Properties;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;

public class ROXIndexedFile
extends idxFile {
    private int priorErrorCode = 0;
    public Variable filenameVariable = null;
    public boolean optional = false;
    public Variable fileStatus = null;
    public int blockFrom = 0;
    public int blockTo = 0;
    public boolean isRecords = false;
    public int recordFrom = 0;
    public int recordTo = 0;
    public Variable dependingOn = null;
    public int numberOfKeys = 0;
    public Variable[] keyArray = new Variable[256];
    private int readMode;
    private int keyOffset;
    private int keyLength;
    private int recLength;
    private boolean fixedFormat;
    private RocksDB rocksDBStore;
    private String indexStoreFileName;
    private short nextRdw;
    private int fileHandle;
    private int sessionId;
    private RandomAccessFile raf;
    private byte[] recBuf;
    private byte[] readNextBuf;
    private int readNextBufPos;
    private int readCnt = 0;
    public ACCESSMODE accessMode = ACCESSMODE.UNKNOWN;

    public ROXIndexedFile() {
        this.setFileHandle(0);
        this.setReadMode(0);
        RocksDB.loadLibrary();
    }

    @Override
    public synchronized idxFile declare(boolean optional, Variable filenameVariable, int reserve, Variable fileStatus, int accessMode, Variable recordKey, int blockFrom, int blockTo, boolean isRecords, int recordFrom, int recordTo, Variable dependingOn, int newModes) {
        return this.declare(optional, filenameVariable, reserve, fileStatus, accessMode, recordKey, blockFrom, blockTo, isRecords, recordFrom, recordTo, dependingOn);
    }

    @Override
    public synchronized idxFile declare(boolean optional, Variable filenameVariable, int reserve, Variable fileStatus, int accessMode, Variable recordKey, int blockFrom, int blockTo, boolean isRecords, int recordFrom, int recordTo, Variable dependingOn) {
        this.filenameVariable = filenameVariable;
        String assignTo = filenameVariable.toString();
        return this.declare(optional, assignTo, reserve, fileStatus, accessMode, recordKey, blockFrom, blockTo, isRecords, recordFrom, recordTo, dependingOn);
    }

    @Override
    public synchronized idxFile declare(boolean optional, String assignTo, int reserve, Variable fileStatus, int accessMode, Variable recordKey, int blockFrom, int blockTo, boolean isRecords, int recordFrom, int recordTo, Variable dependingOn, int newModes) {
        return this.declare(optional, assignTo, reserve, fileStatus, accessMode, recordKey, blockFrom, blockTo, isRecords, recordFrom, recordTo, dependingOn);
    }

    @Override
    public synchronized idxFile declare(boolean optional, String assignTo, int reserve, Variable fileStatus, int accessMode, Variable recordKey, int blockFrom, int blockTo, boolean isRecords, int recordFrom, int recordTo, Variable dependingOn) {
        String func = ".declare()";
        this.optional = optional;
        if (assignTo != null && this.assignTo == null) {
            this.assignTo = this.aliasFilename(assignTo, true);
        }
        this.fileStatus = fileStatus;
        this.accessMode = accessMode == 1 ? ACCESSMODE.SEQUENTIAL : (accessMode == 2 ? ACCESSMODE.RANDOM : (accessMode == 4 ? ACCESSMODE.DYNAMIC : ACCESSMODE.UNKNOWN));
        this.blockFrom = blockFrom;
        this.blockTo = blockTo;
        this.isRecords = isRecords;
        this.recordFrom = recordFrom;
        this.recordTo = recordTo;
        this.dependingOn = dependingOn;
        this.setKeyOffset(0);
        this.setKeyLength(recordKey.getLength());
        this.recBuf = new byte[recordTo + 4];
        return this;
    }

    @Override
    public synchronized idxFile endDeclare() {
        return this;
    }

    @Override
    public synchronized boolean open(int mode) throws RuntimeException {
        String func = ".open()";
        String dsn = this.assignTo.replaceFirst("^ROX:", "").replaceFirst("^ROX:", "").replaceFirst("^ROX:", "");
        if (!dsn.contains("/") && !dsn.contains("\\")) {
            String workDir = System.getProperty("user.dir", "");
            dsn = workDir + File.separatorChar + dsn;
        }
        int keyOffset = this.getKeyOffset();
        int keyLength = this.getKeyLength();
        try {
            this.createIndexObjects(dsn, keyOffset, keyLength);
        }
        catch (FileNotFoundException e1) {
            this.setIOStatus(-35);
            e1.printStackTrace();
            return false;
        }
        try {
            this.raf = new RandomAccessFile(dsn, "r");
        }
        catch (IOException e) {
            this.setIOStatus(-35);
            e.printStackTrace();
            return false;
        }
        this.setIOStatus(0);
        return true;
    }

    @Override
    public synchronized boolean read(String format, Variable nullKeyMap, Variable nullMap, Variable intoVar, Variable keyIs, int mode, Numeric timeout) {
        return this.read(intoVar, keyIs, mode, timeout);
    }

    @Override
    public boolean read(Variable intoVar, Variable keyIs, int mode, Numeric timeout) {
        String func = ".read()";
        this.setReadMode(mode >> 8);
        switch (mode &= 0xFF) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case -1: {
                break;
            }
            case -2: {
                break;
            }
        }
        byte[] fileposBytes = null;
        try {
            fileposBytes = this.rocksDBStore.get(keyIs.getBytes());
        }
        catch (RocksDBException e1) {
            e1.printStackTrace();
        }
        if (fileposBytes == null) {
            this.setIOStatus(-23);
            return true;
        }
        long filepos = this.isFixedFormat() ? ROXIndexedFile.bytesToLong(fileposBytes, 2) : ROXIndexedFile.bytesToLong(fileposBytes, 2) + 4L;
        short rdw = this.isFixedFormat() ? this.getShort(fileposBytes, 0) : (short)(this.getShort(fileposBytes, 0) + 4);
        this.readNextBufPos = -1;
        try {
            this.raf.seek(filepos);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.setIOStatus(-90);
            return true;
        }
        int readCnt = 0;
        try {
            readCnt = this.raf.read(this.recBuf, 0, rdw);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.setIOStatus(-98);
            return true;
        }
        if (readCnt <= 0) {
            this.setIOStatus(-23);
            return true;
        }
        if (this.isFixedFormat()) {
            this.setNextRdw(rdw);
            intoVar.fromByteArray(this.recBuf, 0, rdw);
        } else {
            this.setNextRdw((short)(this.getShort(this.recBuf, rdw - 4) - 4));
            intoVar.fromByteArray(this.recBuf, 0, rdw - 4);
        }
        return false;
    }

    @Override
    public synchronized boolean read(String format, Variable nullKeyMap, Variable nullMap, Variable intoVar, Variable keyIs) {
        return this.read(intoVar, keyIs);
    }

    @Override
    public synchronized boolean read(Variable intoVar, Variable keyIs) {
        return this.read(intoVar, keyIs, 0, null);
    }

    @Override
    public synchronized boolean read(String format, Variable nullKeyMap, Variable nullMap, Variable intoVar, int mode, Numeric timeout) {
        return this.read(intoVar, mode, timeout);
    }

    @Override
    public synchronized boolean read(Variable intoVar, int mode, Numeric timeout) {
        Variable key = this.keyArray[0];
        return this.read(intoVar, key, mode, timeout);
    }

    @Override
    public synchronized boolean read(Variable intoVar) {
        return this.read(intoVar, 0, null);
    }

    @Override
    public synchronized boolean readNext(String format, Variable nullKeyMap, Variable nullMap, Variable intoVar, int mode, Numeric timeout) {
        return this.readNext(intoVar, mode, timeout);
    }

    @Override
    public synchronized boolean readNext(Variable intoVar, int mode, Numeric timeout) {
        String func = ".readNext()";
        int readCnt = 0;
        try {
            if (this.raf.getFilePointer() < this.raf.length()) {
                if (this.isFixedFormat()) {
                    short rdw = this.getNextRdw();
                    readCnt = this.raf.read(this.recBuf, 0, rdw);
                    intoVar.fromByteArray(this.recBuf, 0, rdw);
                } else {
                    short rdw = (short)(this.getNextRdw() + 4);
                    readCnt = this.raf.read(this.recBuf, 0, rdw);
                    this.setNextRdw((short)(this.getShort(this.recBuf, rdw - 4) - 4));
                    intoVar.fromByteArray(this.recBuf, 0, rdw - 4);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            this.setIOStatus(-98);
            return true;
        }
        if (readCnt <= 0) {
            this.setIOStatus(-10);
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean readNext(String format, Variable nullKeyMap, Variable nullMap, Variable intoVar) {
        return this.readNext(intoVar);
    }

    @Override
    public synchronized boolean readNext(Variable intoVar) {
        return this.readNext(intoVar, 0, null);
    }

    @Override
    public synchronized boolean start(String format, Variable nullKeyMap, int mode, int keyOffset, byte[] replacementData) {
        return this.start(mode, keyOffset, replacementData);
    }

    @Override
    public synchronized boolean start(String format, Variable nullKeyMap, int mode, int keyOffset) {
        return this.start(mode, keyOffset);
    }

    @Override
    public synchronized boolean start(String format, Variable nullKeyMap, int mode, Variable currentKey) {
        return this.start(mode, currentKey);
    }

    @Override
    public synchronized boolean start(int mode, Variable currentKey) {
        long filepos;
        this.setReadMode(mode >> 8);
        byte[] fileposBytes = null;
        switch (mode &= 0xFF) {
            case 0: {
                try {
                    fileposBytes = this.rocksDBStore.get(currentKey.getBytes());
                }
                catch (RocksDBException e1) {
                    e1.printStackTrace();
                }
                break;
            }
            case 1: 
            case 2: {
                RocksIterator itr = this.rocksDBStore.newIterator();
                itr.seek(currentKey.getBytes());
                if (!itr.isValid()) break;
                fileposBytes = itr.value();
                break;
            }
            case -2: 
            case -1: {
                RocksIterator itr = this.rocksDBStore.newIterator();
                itr.seekForPrev(currentKey.getBytes());
                if (!itr.isValid()) break;
                fileposBytes = itr.value();
                break;
            }
        }
        if (fileposBytes == null) {
            this.setIOStatus(-23);
            return true;
        }
        long l = filepos = this.isFixedFormat() ? ROXIndexedFile.bytesToLong(fileposBytes, 2) : ROXIndexedFile.bytesToLong(fileposBytes, 2) + 4L;
        if (this.isFixedFormat()) {
            this.setNextRdw(this.getShort(fileposBytes, 0));
        } else {
            this.setNextRdw((short)(this.getShort(fileposBytes, 0) - 4));
        }
        this.readNextBufPos = -1;
        try {
            this.raf.seek(filepos);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.setIOStatus(-90);
            return true;
        }
        this.setIOStatus(0);
        return false;
    }

    @Override
    public synchronized boolean close() {
        return this.close(0);
    }

    @Override
    public synchronized boolean close(int mode) {
        this.rocksDBStore.close();
        try {
            this.raf.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.setIOStatus(-98);
            return false;
        }
        this.setIOStatus(0);
        return true;
    }

    @Override
    public synchronized int priorError() {
        return this.getPriorError();
    }

    @Override
    public final int getPriorError() {
        if (this.priorErrorCode > 0) {
            return -this.priorErrorCode;
        }
        return this.priorErrorCode;
    }

    @Override
    public final void setPriorError(int priorError) {
        this.priorErrorCode = priorError;
    }

    @Override
    public final int setIOStatus(int status) {
        char[] smallChar = new char[]{'0', '0'};
        if ((status = status < 0 ? -status : 0) == 9) {
            status = 0;
        }
        this.setPriorError(status);
        if (this.fileStatus != null) {
            if (status == 0) {
                this.fileStatus.moveZeroes();
            } else if (status < 10) {
                smallChar[1] = (char)(status + 48);
                this.fileStatus.move(smallChar);
            } else {
                this.fileStatus.move(status);
            }
        }
        return status;
    }

    @Override
    public final int setIOStatus(String x) {
        int status = 0;
        try {
            status = Integer.decode(x);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.setIOStatus(-status);
    }

    @Override
    public synchronized boolean isOK() {
        int priorErrorCode = this.getPriorError();
        return priorErrorCode > -10 && priorErrorCode < 10;
    }

    public int getFileHandle() {
        return this.fileHandle;
    }

    public void setFileHandle(int fileHandle) {
        this.fileHandle = fileHandle;
    }

    public int getReadMode() {
        return this.readMode;
    }

    public void setReadMode(int readMode) {
        this.readMode = readMode;
    }

    private void createIndexObjects(String inputFile, int keyOffset, int keyLength) throws FileNotFoundException {
        File f = new File(inputFile);
        if (!f.exists() || f.isDirectory()) {
            throw new FileNotFoundException(inputFile + "not found or is a directory");
        }
        String baseFileName = f.getName();
        String basePathName = f.getParent();
        String indexFileName = basePathName + File.separatorChar + baseFileName + "_rocksDBStore";
        boolean fixedIndexFileExists = new File(indexFileName + "Fixed").exists();
        if (fixedIndexFileExists) {
            indexFileName = indexFileName + "Fixed";
            this.setFixedFormat(true);
        }
        this.setIndexStore(indexFileName);
        if (new File(indexFileName).exists()) {
            try {
                Options options = new Options();
                options.setCreateIfMissing(false);
                this.rocksDBStore = RocksDB.openReadOnly((Options)options, (String)this.getIndexStoreFileName());
            }
            catch (RocksDBException e) {
                e.printStackTrace();
            }
            return;
        }
        try {
            Options options = new Options();
            options.setCreateIfMissing(true);
            this.rocksDBStore = RocksDB.open((Options)options, (String)this.getIndexStoreFileName());
        }
        catch (RocksDBException e) {
            e.printStackTrace();
            return;
        }
        long fpos = 0L;
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(inputFile));){
            int bytesRead = 0;
            boolean hasBytesToRead = true;
            while (hasBytesToRead) {
                byte[] recBytes;
                byte[] rdwBytes = new byte[4];
                bytesRead = ((InputStream)inputStream).read(rdwBytes);
                if (bytesRead <= 0) {
                    break;
                }
                short rdw = this.getShort(rdwBytes, 0);
                if (rdw - 4 <= 0) {
                    System.err.println("rdw minus 4 <= 0. rdw: " + rdw);
                }
                if ((bytesRead = ((InputStream)inputStream).read(recBytes = new byte[rdw - 4])) <= 0) {
                    break;
                }
                byte[] keyBytes = Arrays.copyOfRange(recBytes, keyOffset, keyLength);
                byte[] fposBytes = new byte[10];
                fposBytes[0] = rdwBytes[0];
                fposBytes[1] = rdwBytes[1];
                ROXIndexedFile.longToBytes(fpos, fposBytes, 2);
                this.rocksDBStore.put(keyBytes, fposBytes);
                fpos += (long)rdw;
            }
        }
        catch (IOException | RocksDBException ex) {
            ex.printStackTrace();
            this.setIOStatus(-98);
        }
    }

    private void createIndexObjects(String inputFile, int keyOffset, int keyLength, int recLength) throws FileNotFoundException {
        RocksDB rocksDBStore;
        RocksDB.loadLibrary();
        File f = new File(inputFile);
        if (!f.exists() || f.isDirectory()) {
            throw new FileNotFoundException(inputFile + "not found or is a directory");
        }
        String baseFileName = f.getName();
        String basePathName = f.getParent();
        String indexFileName = basePathName + File.separatorChar + baseFileName + "_rocksDBStoreFixed";
        Options options = new Options();
        options.setCreateIfMissing(true);
        if (new File(indexFileName).exists()) {
            try {
                RocksDB rocksDBStore2 = RocksDB.open((Options)options, (String)indexFileName);
            }
            catch (RocksDBException e) {
                e.printStackTrace();
            }
            return;
        }
        try {
            rocksDBStore = RocksDB.open((Options)options, (String)indexFileName);
        }
        catch (RocksDBException e) {
            e.printStackTrace();
            return;
        }
        long fpos = 0L;
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(inputFile));){
            int bytesRead = 0;
            short rdw = (short)recLength;
            byte[] recBytes = new byte[rdw];
            byte[] rdwBytes = new byte[2];
            this.shortToByteArray(rdw, rdwBytes, 0);
            boolean hasBytesToRead = true;
            while (hasBytesToRead) {
                bytesRead = inputStream.read(recBytes);
                if (bytesRead <= 0) {
                    break;
                }
                byte[] keyBytes = Arrays.copyOfRange(recBytes, keyOffset, keyLength);
                byte[] fposBytes = new byte[10];
                fposBytes[0] = rdwBytes[0];
                fposBytes[1] = rdwBytes[1];
                ROXIndexedFile.longToBytes(fpos, fposBytes, 2);
                rocksDBStore.put(keyBytes, fposBytes);
                fpos += (long)rdw;
            }
        }
        catch (IOException | RocksDBException ex) {
            ex.printStackTrace();
        }
    }

    private short getShort(byte[] arr, int off) {
        return (short)(arr[off] << 8 & 0xFF00 | arr[off + 1] & 0xFF);
    }

    private int getInt(byte[] arr, int off) {
        return arr[off] << 8 & 0xFF00 | arr[off + 1] & 0xFF;
    }

    private byte[] shortToBytes(short s) {
        return new byte[]{(byte)((s & 0xFF00) >> 8), (byte)(s & 0xFF)};
    }

    private void longToByteArray(long value, byte[] array, int startFrom) {
        for (int i = 7; i >= 0; --i) {
            array[startFrom + 7 - i] = (byte)(value >> i * 8);
        }
    }

    public byte[] longToByteArray(long value) {
        byte[] array = new byte[8];
        this.longToByteArray(value, array, 0);
        return array;
    }

    public static void longToBytes(long l, byte[] array, int offset) {
        for (int i = 7; i >= 0; --i) {
            array[offset + i] = (byte)(l & 0xFFL);
            l >>= 8;
        }
    }

    public static long bytesToLong(byte[] bytes, int offset) {
        long result = 0L;
        for (int i = offset; i < 8 + offset; ++i) {
            result <<= 8;
            result |= (long)(bytes[i] & 0xFF);
        }
        return result;
    }

    private void shortToByteArray(short value, byte[] array, int startFrom) {
        for (int i = 1; i >= 0; --i) {
            array[startFrom + 1 - i] = (byte)(value >> i * 8);
        }
    }

    public byte[] shortToByteArray(short value) {
        byte[] array = new byte[2];
        this.shortToByteArray(value, array, 0);
        return array;
    }

    @Override
    public String toString() {
        try {
            String linesep = System.getProperty("line.separator");
            if (linesep == null) {
                linesep = "\n";
            }
            StringBuffer result = new StringBuffer();
            result.append("ROXIndexedFile instance").append(linesep);
            result.append("PROTOCOL IS ROX (KSDS)").append(linesep);
            result.append("ORGANIZATION IS INDEXED").append(linesep);
            if (this.filenameVariable != null) {
                result.append("FILE " + this.filenameVariable.getName() + "=\"" + this.filenameVariable.toString()).append(linesep);
            }
            if (this.assignTo != null) {
                result.append("ASSIGN TO " + this.assignTo).append(linesep);
            } else {
                result.append("[unknown file]").append(linesep);
            }
            if (this.fileStatus != null) {
                result.append("FILE STATUS IS " + this.fileStatus.toString()).append(linesep);
            }
            if (this.recBuf != null) {
                String recData = null;
                try {
                    recData = new String(this.recBuf, Variable.getByteEncoding());
                }
                catch (UnsupportedEncodingException e) {
                    recData = HexUtils.printHexBinary(this.recBuf);
                }
                result.append("RECORD DATA =" + recData).append(linesep);
            }
            return result.toString();
        }
        catch (RuntimeException t) {
            return "INDEXED FILE";
        }
    }

    private String getUrlProperty() {
        String url2 = null;
        try (InputStream input = ROXIndexedFile.class.getClassLoader().getResourceAsStream("deploy.properties");){
            Properties prop = new Properties();
            if (input == null) {
                System.err.println("Unable to find deploy.properties on classpath");
            } else {
                prop.load(input);
                url2 = prop.getProperty("cburl");
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return url2;
    }

    private int getSessionId() {
        return this.sessionId;
    }

    private void setSessionId(int sessionId) {
        this.sessionId = sessionId;
    }

    public String getIndexStoreFileName() {
        return this.indexStoreFileName;
    }

    public void setIndexStore(String indexStoreFileName) {
        this.indexStoreFileName = indexStoreFileName;
    }

    public short getNextRdw() {
        return this.nextRdw;
    }

    public void setNextRdw(short nextRdw) {
        this.nextRdw = nextRdw;
    }

    public RocksDB getrocksDBStore() {
        return this.rocksDBStore;
    }

    public void setrocksDBStore(RocksDB rocksDBStore) {
        this.rocksDBStore = rocksDBStore;
    }

    public int getKeyOffset() {
        return this.keyOffset;
    }

    public void setKeyOffset(int keyOffset) {
        this.keyOffset = keyOffset;
    }

    public int getKeyLength() {
        return this.keyLength;
    }

    public void setKeyLength(int keyLength) {
        this.keyLength = keyLength;
    }

    public boolean isFixedFormat() {
        return this.fixedFormat;
    }

    public void setFixedFormat(boolean fixedFormat) {
        this.fixedFormat = fixedFormat;
    }

    public int getRecLength() {
        return this.recLength;
    }

    public void setRecLength(int recLength) {
        this.recLength = recLength;
    }

    public static enum ACCESSMODE {
        UNKNOWN,
        SEQUENTIAL,
        RANDOM,
        DYNAMIC;

    }
}

