/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.zos;

import com.heirloomcomputing.ecs.exec.CobolException;
import com.heirloomcomputing.ecs.exec.Context;
import com.heirloomcomputing.ecs.exec.IndexedFile;
import com.heirloomcomputing.ecs.exec.LockFile;
import com.heirloomcomputing.ecs.exec.LogSetup;
import com.heirloomcomputing.ecs.exec.Numeric;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.Utilities;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.exec.idxFile;
import com.heirloomcomputing.ecs.zos.YFile;
import com.heirloomcomputing.ecs.zos.YFileException;

public class zOSIndexedFile
extends idxFile {
    private static final String PGM = "com.heirloomcomputing.ecs.zos.zOSIndexedFile";
    private static final boolean on = true;
    private boolean isOpen = false;
    private int openIOMode;
    private boolean isOpenIO;
    private boolean isOpenInput;
    private boolean isOpenOutput;
    private boolean isOpenOExtend;
    private boolean isOpenIExtend;
    private boolean readable;
    private boolean writeable;
    private boolean extend;
    private int priorErrorCode = 0;
    private Command priorCommand;
    private zOSIndexedFile externalFile;
    private String protocol = null;
    private boolean remote = false;
    private int port;
    private String site;
    private IndexedFile file = null;
    private Variable filenameVariable = null;
    private boolean optional;
    private int reserve;
    private Variable fileStatus;
    private int accessMode;
    private int blockFrom;
    private int blockTo;
    private boolean isRecords;
    private int recordFrom;
    private int recordTo;
    private byte[] into;
    private Variable dependingOn;
    private int newModes = 0;
    private int numberOfKeys = 0;
    private String[] keyNameArray = new String[256];
    private Variable[] keyArray = new Variable[256];
    private boolean[] isKeyDuplicates = new boolean[256];
    private String filteredFilename;
    private int fileMarkerKeyOffset = 0;
    Class<?> zFileClass = null;
    YFile zFile = null;

    @Override
    public String getFilename() {
        String filename = "";
        filename = this.filenameVariable != null ? this.filenameVariable.toString() : this.assignTo;
        if (filename != null) {
            filename = filename.trim();
        }
        return filename;
    }

    private String getFilteredFilename() {
        String filename = "";
        filename = this.filenameVariable != null ? this.filenameVariable.toString() : this.assignTo;
        return this.filterFilename(filename);
    }

    private String getAConnectFilename(String filename) {
        if (filename == null || filename.trim().length() == 0) {
            return null;
        }
        if (filename.trim().charAt(0) == '@') {
            return filename;
        }
        String name = RuntimeEnvironment.getGlobalParameter(filename);
        if (name == null || name.trim().length() == 0) {
            return null;
        }
        if (name.trim().charAt(0) == '@') {
            return name;
        }
        return null;
    }

    private String filterFilename(String filename) {
        String temp;
        if (filename != null) {
            filename = filename.trim();
        }
        if ((temp = this.getAConnectFilename(filename)) != null) {
            filename = temp;
            this.protocol = "ACON";
        } else {
            String envname;
            if (filename.startsWith("env:") && (filename = RuntimeEnvironment.getGlobalParameter(envname = filename.substring(4))) == null) {
                filename = envname;
            }
            filename = this.filterRemote(filename);
            filename = this.filterProtocol(filename);
        }
        return filename;
    }

    private String filterProtocol(String filename) {
        if (filename == null) {
            return null;
        }
        this.protocol = null;
        int index = filename.indexOf(58);
        if (index >= 2) {
            this.protocol = filename.substring(0, index);
            filename = index < filename.length() - 1 ? filename.substring(index + 1) : "";
        }
        return filename;
    }

    private String filterRemote(String filename) {
        if (filename == null) {
            return null;
        }
        if ((filename = filename.trim()).toLowerCase().startsWith("remote:")) {
            int index = 7;
            if (index >= filename.length()) {
                return "";
            }
            filename = filename.substring(index);
            filename = this.setRemote(filename);
        }
        return filename;
    }

    private String setRemote(String filename) {
        if (filename == null) {
            return null;
        }
        this.remote = true;
        this.filenameVariable = null;
        this.site = null;
        int index = filename.indexOf(58);
        if (index >= 0) {
            this.site = filename.substring(0, index);
            filename = index < filename.length() - 1 ? filename.substring(index + 1) : "";
        }
        if (this.site == null) {
            try {
                this.site = Utilities.getCodeBase().toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.site == null) {
            this.site = RuntimeEnvironment.getGlobalParameter("REMOTEHOST");
        }
        if (this.site == null) {
            this.site = "127.0.0.1";
        }
        index = filename.indexOf(58);
        this.port = 6584;
        if (index >= 0) {
            if (index < filename.length() - 1) {
                try {
                    this.port = Integer.decode(filename.substring(index + 1));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            filename = filename.substring(0, index);
        }
        if (Context.getGlobalFileCharacter() != '/') {
            int i = 0;
            do {
                if ((i = filename.indexOf(47, i)) < 0) continue;
                filename = filename.substring(0, i - 1) + '/' + filename.substring(i);
                i += 2;
            } while (i >= 0);
            i = 0;
            do {
                if ((i = filename.indexOf(Context.getGlobalFileCharacter(), i)) < 0) continue;
                filename = filename.substring(0, i - 1) + Context.getGlobalFileCharacter() + filename.substring(i + 1);
                ++i;
            } while (i >= 0);
        }
        return filename;
    }

    @Override
    public String toString() {
        try {
            int i;
            String linesep = System.getProperty("line.separator");
            if (linesep == null) {
                linesep = "\n";
            }
            StringBuffer result = new StringBuffer();
            result.append("ORGANIZATION IS INDEXED").append(linesep);
            if (this.accessMode == 2) {
                result.append("ACCESS MODE IS RANDOM").append(linesep);
            } else if (this.accessMode == 4) {
                result.append("ACCESS MODE IS DYNAMIC").append(linesep);
            } else if (this.accessMode == 1) {
                result.append("ACCESS MODE IS SEQUENTIAL").append(linesep);
            }
            result.append((this.optional ? "" : "NOT-") + "OPTIONAL").append(linesep);
            if (this.filenameVariable != null) {
                result.append("ASSIGN TO ").append(this.filenameVariable.getName()).append("=\"").append(this.filenameVariable.toString()).append("\"").append(linesep);
            } else if (this.file != null) {
                result.append("ASSIGN TO \"").append(this.getFilename()).append("\"").append(linesep);
            }
            result.append("SYSTEM FILENAME W/O PROTOCOL IS " + this.filteredFilename).append(linesep);
            result.append("FILE IS " + (this.isOpen ? "OPENED" : "CLOSED")).append(linesep);
            if (this.fileStatus != null) {
                result.append("FILE STATUS IS ").append(this.fileStatus.getName()).append("=").append(this.fileStatus.toDisplayString()).append(linesep);
            }
            if (this.recordFrom == this.recordTo) {
                result.append("RECORDING MODE IS FIXED").append(linesep);
            } else {
                result.append("RECORDING MODE IS VARIABLE").append(linesep);
            }
            if (this.recordFrom != -1 || this.recordTo != -1) {
                if (this.recordFrom >= this.recordTo) {
                    result.append("RECORD CONTAINS ").append(this.recordFrom).append(" CHARACTERS").append(linesep);
                } else {
                    result.append("RECORD CONTAINS ").append(this.recordFrom).append(" TO ").append(this.recordTo).append(" CHARACTERS").append(linesep);
                }
            }
            if (this.dependingOn != null) {
                result.append("DEPENDING ON ").append(this.dependingOn.getName()).append('=').append(this.dependingOn.toInt()).append(linesep);
            }
            if (this.blockFrom != 0 || this.blockTo != 0) {
                String type = null;
                type = this.isRecords ? " RECORDS" : " CHARACTERS";
                if (this.blockFrom >= this.blockTo) {
                    result.append("BLOCK CONTAINS ").append(this.blockFrom).append(type).append(linesep);
                } else {
                    result.append("BLOCK CONTAINS ").append(this.blockFrom).append(" TO ").append(this.blockTo).append(type).append(linesep);
                }
            }
            result.append("PROTOCOL IS: " + this.protocol).append(linesep);
            if (this.remote) {
                result.append("IS REMOTE (HOST='" + this.site + "', PORT='" + this.port + "')").append(linesep);
            }
            result.append("OPEN INPUT/OUTPUT MODE IS: " + this.openIOMode).append(linesep);
            result.append((this.isOpenInput ? "" : "NOT ") + "OPEN INPUT").append(linesep);
            result.append((this.isOpenOutput ? "" : "NOT ") + "OPEN OUTPUT").append(linesep);
            result.append((this.isOpenIO ? "" : "NOT ") + "OPEN IO").append(linesep);
            result.append((this.readable ? "" : "NOT ") + "READABLE").append(linesep);
            result.append((this.writeable ? "" : "NOT ") + "WRITEABLE").append(linesep);
            result.append((this.extend ? "" : "NOT ") + "EXTEND").append(linesep);
            result.append("numberOfKeys is " + this.numberOfKeys).append(linesep);
            result.append("NAMES OF KEYS: ").append(linesep);
            for (i = 0; i < this.numberOfKeys; ++i) {
                result.append("    " + this.keyNameArray[i] + (i == 0 ? ". PRIMARY KEY" : ". ALTERNATE KEY")).append(linesep);
            }
            result.append("VALUE OF KEYS: ").append(linesep);
            for (i = 0; i < this.numberOfKeys; ++i) {
                result.append("    " + this.keyArray[i].toText() + (i == 0 ? ". PRIMARY KEY" : ". ALTERNATE KEY")).append(linesep);
            }
            return result.toString();
        }
        catch (RuntimeException t) {
            return "INDEXED FILE";
        }
    }

    @Override
    public int getFileMarkerKeyOffset() {
        return this.fileMarkerKeyOffset;
    }

    @Override
    public idxFile declare(boolean optional, Variable filenameVariable, int reserve, Variable fileStatus, int accessMode, Variable recordKey, int blockFrom, int blockTo, boolean isRecords, int recordFrom, int recordTo, Variable dependingOn, int newModes) {
        this.newModes = newModes;
        return this.declare(optional, filenameVariable, reserve, fileStatus, accessMode, recordKey, blockFrom, blockTo, isRecords, recordFrom, recordTo, dependingOn);
    }

    @Override
    public idxFile declare(boolean optional, Variable filenameVariable, int reserve, Variable fileStatus, int accessMode, Variable recordKey, int blockFrom, int blockTo, boolean isRecords, int recordFrom, int recordTo, Variable dependingOn) {
        this.filenameVariable = filenameVariable;
        String assignTo = filenameVariable.toString();
        return this.declare(optional, assignTo, reserve, fileStatus, accessMode, recordKey, blockFrom, blockTo, isRecords, recordFrom, recordTo, dependingOn);
    }

    @Override
    public idxFile declare(boolean optional, String assignTo, int reserve, Variable fileStatus, int accessMode, Variable recordKey, int blockFrom, int blockTo, boolean isRecords, int recordFrom, int recordTo, Variable dependingOn, int newModes) {
        this.newModes = newModes;
        return this.declare(optional, assignTo, reserve, fileStatus, accessMode, recordKey, blockFrom, blockTo, isRecords, recordFrom, recordTo, dependingOn);
    }

    @Override
    public idxFile declare(boolean optional, String assignTo, int reserve, Variable fileStatus, int accessMode, Variable recordKey, int blockFrom, int blockTo, boolean isRecords, int recordFrom, int recordTo, Variable dependingOn) {
        this.optional = optional;
        if (assignTo != null && this.assignTo == null) {
            this.assignTo = assignTo;
        }
        this.reserve = reserve;
        this.fileStatus = fileStatus;
        this.accessMode = accessMode;
        this.keyArray[0] = recordKey;
        this.isKeyDuplicates[0] = false;
        this.blockFrom = blockFrom;
        this.blockTo = blockTo;
        this.isRecords = isRecords;
        this.recordFrom = recordFrom;
        this.recordTo = recordTo;
        this.dependingOn = dependingOn;
        this.numberOfKeys = recordKey != null ? 1 : 0;
        if (this.keyArray[0] != null) {
            this.keyNameArray[0] = this.keyArray[0].getName();
        }
        if (recordFrom != -1 || recordTo != -1) {
            this.into = recordFrom >= recordTo ? new byte[recordFrom] : new byte[recordTo];
        }
        this.priorCommand = Command.DECLARE;
        return this;
    }

    @Override
    public idxFile alternateKey(Variable alternateKey, int duplicates) {
        this.keyArray[this.numberOfKeys] = alternateKey;
        this.keyNameArray[this.numberOfKeys] = this.keyArray[this.numberOfKeys].getName();
        this.isKeyDuplicates[this.numberOfKeys] = duplicates == 512;
        ++this.numberOfKeys;
        return this;
    }

    @Override
    public idxFile endDeclare() {
        this.filteredFilename = this.getFilteredFilename();
        return this;
    }

    @Override
    public boolean open(int mode) {
        this.openIOMode = mode;
        this.readable = (mode & 1) == 1;
        this.writeable = (mode & 2) == 2;
        this.extend = (mode & 4) == 4;
        this.isOpenIO = this.readable && this.writeable;
        this.isOpenInput = this.readable && !this.writeable;
        this.isOpenOutput = !this.readable && this.writeable;
        this.isOpenOExtend = !this.readable && this.extend;
        this.isOpenIExtend = this.readable && this.extend;
        String zFileName = "";
        String zFileOptions = "";
        zFileName = this.filteredFilename.contains(".") ? "//'" + this.filteredFilename.toUpperCase() + "'" : "//DD:" + this.filteredFilename.toUpperCase();
        if (this.isOpenIExtend) {
            zFileOptions = "ab+";
        } else if (this.isOpenOExtend) {
            zFileOptions = "ab";
        } else if (this.isOpenIO) {
            zFileOptions = "rb+";
        } else if (this.isOpenInput) {
            zFileOptions = "rb";
        } else if (this.isOpenOutput) {
            zFileOptions = "ab+";
        }
        if (this.isRecords) {
            zFileOptions = zFileOptions + ",type=record";
        }
        if (this.accessMode == 1) {
            zFileOptions = zFileOptions + ",noseek";
        }
        try {
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.finer("new ZFile(\"" + zFileName + "\",\"" + zFileOptions + "\")");
            }
            this.zFile = new YFile(zFileName, zFileOptions);
            this.setIOStatus(0);
            this.isOpen = true;
        }
        catch (NoClassDefFoundError e) {
            this.setIOStatus(-30);
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.warning("ZFile NoClassDefFoundError:  include ibmjzos.jar in CLASSPATH, its associated native library in LIBPATH, and only run on z/OS");
            }
            this.isOpenIExtend = false;
            this.isOpenOExtend = false;
            this.isOpenIO = false;
            this.isOpenOutput = false;
            this.isOpenInput = false;
            this.isOpen = false;
        }
        catch (UnsatisfiedLinkError e) {
            this.setIOStatus(-30);
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.warning("ZFile UnsatisfiedLinkError:  include ibmjzos.jar in CLASSPATH, its associated native library in LIBPATH, and only run on z/OS");
            }
            this.isOpenIExtend = false;
            this.isOpenOExtend = false;
            this.isOpenIO = false;
            this.isOpenOutput = false;
            this.isOpenInput = false;
            this.isOpen = false;
        }
        catch (YFileException e) {
            this.setIOStatus(-30);
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.warning("YFile exception: " + e.toString());
            }
            this.isOpenIExtend = false;
            this.isOpenOExtend = false;
            this.isOpenIO = false;
            this.isOpenOutput = false;
            this.isOpenInput = false;
            this.isOpen = false;
        }
        this.priorCommand = Command.OPEN;
        return this.isOpen;
    }

    @Override
    public boolean openTimeoutSeconds(int mode, Numeric timeout) {
        mode = LockFile.transformOpenMode(mode);
        int timeout_mask = 0x2100000;
        mode &= ~timeout_mask;
        double seconds = timeout.toDouble();
        boolean success = false;
        long currentTime = System.currentTimeMillis();
        long finalTime = currentTime + (long)(seconds * 1000.0);
        do {
            this.setIOStatus(0);
            success = this.open(mode);
            if (success || System.currentTimeMillis() >= finalTime) continue;
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (!success && System.currentTimeMillis() < finalTime);
        return success;
    }

    @Override
    public boolean openTimeoutRetries(int mode, Numeric timeout) {
        mode = LockFile.transformOpenMode(mode);
        int timeout_mask = 0x2100000;
        mode &= ~timeout_mask;
        int attempts = timeout.toInt();
        if (attempts < 0) {
            attempts = 0;
        }
        ++attempts;
        boolean success = false;
        do {
            this.setIOStatus(0);
            success = this.open(mode);
            if (success || --attempts <= 0) continue;
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (!success && attempts > 0);
        return success;
    }

    @Override
    public boolean openTimeoutRetries(int mode) {
        mode = LockFile.transformOpenMode(mode);
        mode &= 0xFDEFFFFF;
        boolean success = false;
        do {
            this.setIOStatus(0);
            success = this.open(mode);
            if (success) continue;
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (!success);
        return success;
    }

    @Override
    public boolean close() {
        return this.close(0);
    }

    @Override
    public boolean close(int mode) {
        if (!this.isOpen) {
            this.setIOStatus(-42);
            return true;
        }
        try {
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.finer("ZFile.close()");
            }
            this.zFile.close();
        }
        catch (YFileException e) {
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.warning("" + e);
            }
            this.setIOStatus(-90);
            return true;
        }
        this.setIOStatus(0);
        this.priorCommand = Command.CLOSE;
        return false;
    }

    private int EC2ZFconsts(int mode) {
        if (mode == 0) {
            return 3;
        }
        if (mode == 1) {
            return 5;
        }
        if (mode == 256) {
            return 4;
        }
        if ((mode & 0x100) == 256) {
            return 2;
        }
        return 1;
    }

    @Override
    public boolean start(int mode, Variable currentKey) {
        String func = ".start(i,V)";
        if (!this.isOpenInput && !this.isOpenIO) {
            this.setIOStatus(-47);
            return false;
        }
        if (this.accessMode != 1 && this.accessMode != 4) {
            this.setIOStatus(-90);
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.warning("" + this.fileStatus.toText() + ": ERROR! ACCESS MODE must be SEQUENTIAL or DYNAMIC.");
            }
            return false;
        }
        String keyName = currentKey.getName();
        boolean keyExists = false;
        for (int i = 0; i < this.numberOfKeys; ++i) {
            if (!keyName.equals(this.keyNameArray[i])) continue;
            keyExists = true;
            this.keyArray[i] = currentKey;
            this.fileMarkerKeyOffset = i;
            break;
        }
        if (!keyExists) {
            throw new RuntimeException("com.heirloomcomputing.ecs.zos.zOSIndexedFile.start(i,V): START KEY is invalid. KEY name is " + keyName + ". KEY value is " + currentKey.toText());
        }
        byte[] key = currentKey.toByteArray();
        return this.start(mode, this.fileMarkerKeyOffset, key);
    }

    @Override
    public synchronized boolean start(int mode, int keyOff, byte[] key) {
        boolean rclocate = true;
        int options = this.EC2ZFconsts(mode);
        try {
            rclocate = this.zFile.locate(key, 0, key.length, options);
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.finer("ZFile.locate(\"" + zOSIndexedFile.encode(key) + "\",0," + key.length + "," + options + ")=" + rclocate);
            }
            if (!rclocate) {
                this.setIOStatus(-23);
                return this.isInvalidKey(-23);
            }
        }
        catch (YFileException e) {
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.finer("ZFile.locate(\"" + zOSIndexedFile.encode(key) + "\",0," + key.length + "," + options + ")");
            }
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.warning("" + e);
            }
            this.setIOStatus(-23);
            return true;
        }
        this.setIOStatus(0);
        this.priorCommand = Command.START;
        return false;
    }

    @Override
    public boolean start(String format, Variable nullKeyMap, int mode) {
        return this.start(mode);
    }

    @Override
    public boolean start(Variable currentKey) {
        try {
            return this.start(0, currentKey);
        }
        catch (Throwable t) {
            CobolException.runtimeError("Error in indexed file START.", t);
            return false;
        }
    }

    @Override
    public synchronized byte[] readNetwork(boolean seqOverride, int keyOffset, byte[] keyData, int mode, double timeout) {
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer("zOSIndexedFile.readNetwork(" + seqOverride + keyOffset + ",,\"" + zOSIndexedFile.encode(keyData) + "\"," + mode + "," + timeout + ")");
        }
        byte[] rec = seqOverride || this.priorCommand == Command.START || this.priorCommand == Command.READ_NEXT ? this.readNext(mode, timeout) : this.read(keyData, keyOffset, mode, timeout);
        int len = rec.length;
        byte[] newData = new byte[len + 1];
        if (len > 0) {
            System.arraycopy(rec, 0, newData, 1, len);
        }
        newData[0] = (byte)(len == 0 ? 1 : 0);
        return newData;
    }

    @Override
    public synchronized byte[] readNetwork(boolean seqOverride, int keyOffset, byte[] keyData, int mode, double timeout, int direction) {
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer("zOSIndexedFile.readNetwork(" + seqOverride + keyOffset + ",,\"" + zOSIndexedFile.encode(keyData) + "\"," + mode + "," + timeout + "," + direction + ")");
        }
        byte[] rec = seqOverride || this.priorCommand == Command.START || this.priorCommand == Command.READ_NEXT && direction > 0 || this.priorCommand == Command.READ_PREVIOUS && direction < 0 ? (direction < 0 ? this.readPrevious(mode, timeout) : this.readNext(mode, timeout)) : this.read(keyData, keyOffset, mode, timeout);
        int len = rec.length;
        byte[] newData = new byte[len + 1];
        if (len > 0) {
            System.arraycopy(rec, 0, newData, 1, len);
        }
        newData[0] = (byte)(len == 0 ? 1 : 0);
        return newData;
    }

    @Override
    public boolean read(Variable intoVar, Variable keyIs, int mode, Numeric timeout) {
        double tod;
        String func = ".read(V,V,i,N)";
        Variable key = null;
        String keyName = keyIs.getName();
        boolean keyExists = false;
        for (int i = 0; i < this.numberOfKeys; ++i) {
            if (!keyName.equals(this.keyNameArray[i])) continue;
            keyExists = true;
            key = this.keyArray[i] = keyIs;
            this.fileMarkerKeyOffset = i;
            break;
        }
        if (!keyExists) {
            throw new RuntimeException("com.heirloomcomputing.ecs.zos.zOSIndexedFile.read(V,V,i,N): READ KEY is invalid. KEY name is " + keyName + ". KEY value is " + keyIs.toText());
        }
        byte[] keyArr = key.toByteArray();
        byte[] rec = this.read(keyArr, this.fileMarkerKeyOffset, mode, tod = timeout != null ? timeout.toDouble() : 0.0);
        if (rec.length == 0) {
            return true;
        }
        intoVar.setArgument(rec);
        return false;
    }

    private byte[] read(byte[] keyArr, int keyOff, int mode, double timeout) {
        boolean rclocate = true;
        int lenread = 0;
        if (!this.isOpenInput && !this.isOpenIO) {
            this.setIOStatus(-47);
            return new byte[0];
        }
        int options = this.EC2ZFconsts(mode);
        try {
            rclocate = this.zFile.locate(keyArr, 0, keyArr.length, options);
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.finer("ZFile.locate(\"" + zOSIndexedFile.encode(keyArr) + "\", 0," + keyArr.length + "," + options + ")=" + rclocate);
            }
            if (!rclocate) {
                this.setIOStatus(-23);
                return new byte[0];
            }
        }
        catch (YFileException e) {
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.finer("ZFile.locate(\"" + zOSIndexedFile.encode(keyArr) + "\", 0," + keyArr.length + "," + options + ")=ZFileException");
            }
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.warning("" + e);
            }
            this.setIOStatus(-23);
            return new byte[0];
        }
        try {
            lenread = this.zFile.read(this.into);
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.finer("ZFile.read(into)=" + lenread + ",\"" + zOSIndexedFile.encode(this.into) + "\" <length=" + this.into.length + ">");
            }
        }
        catch (YFileException e) {
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.finer("ZFile.read()=ZFileException");
            }
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.warning("" + e);
            }
            this.setIOStatus(-23);
            return new byte[0];
        }
        if (lenread <= 0) {
            this.setIOStatus(-23);
            return new byte[0];
        }
        this.setIOStatus(0);
        this.priorCommand = Command.READ;
        return this.into;
    }

    @Override
    public boolean read(Variable intoVar, Variable keyIs) {
        return this.read(intoVar, keyIs, 0, null);
    }

    @Override
    public boolean read(String format, Variable nullKeyMap, Variable nullMap, Variable intoVar, int mode, Numeric timeout) {
        if (this.accessMode == 1) {
            return this.readNext(intoVar, mode, timeout);
        }
        return this.read(intoVar, mode, timeout);
    }

    @Override
    public boolean read(Variable intoVar, int mode, Numeric timeout) {
        Variable key = this.keyArray[0];
        return this.read(intoVar, key, mode, timeout);
    }

    @Override
    public boolean read(Variable intoVar) {
        return this.read(intoVar, 0, null);
    }

    @Override
    public boolean readNext(String format, Variable nullKeyMap, Variable nullMap, Variable intoVar, int mode, Numeric timeout) {
        return this.readNext(intoVar, mode, timeout);
    }

    @Override
    public boolean readNext(Variable intoVar, int mode, Numeric timeout) {
        double tod = timeout != null ? timeout.toDouble() : 0.0;
        byte[] rec = this.readNext(mode, tod);
        if (rec.length == 0) {
            return false;
        }
        intoVar.setArgument(this.into);
        return true;
    }

    private byte[] readNext(int mode, double timeout) {
        int lenread = 0;
        if (!this.isOpenInput && !this.isOpenIO) {
            this.setIOStatus(-47);
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.warning("File Status=-47: READ NEXT requires file be OPENed as INPUT or IO.");
            }
            return new byte[0];
        }
        try {
            lenread = this.zFile.read(this.into);
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.finer("ZFile.read(into)=" + lenread + ",\"" + zOSIndexedFile.encode(this.into) + "\" <length=" + this.into.length + ">");
            }
        }
        catch (YFileException e) {
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.warning("" + e);
            }
            this.setIOStatus(-10);
            return new byte[0];
        }
        if (lenread <= 0) {
            this.setIOStatus(-10);
            return new byte[0];
        }
        this.setIOStatus(0);
        this.priorCommand = Command.READ_NEXT;
        return this.into;
    }

    @Override
    public boolean readNext(Variable intoVar) {
        return this.readNext(intoVar, 0, null);
    }

    @Override
    public boolean readPrevious(Variable intoVar, int mode, Numeric timeout) {
        double tod = timeout != null ? timeout.toDouble() : 0.0;
        byte[] rec = this.readPrevious(mode, tod);
        if (rec.length == 0) {
            return false;
        }
        intoVar.setArgument(this.into);
        return true;
    }

    private byte[] readPrevious(int mode, double timeout) {
        int lenread = 0;
        if (!this.isOpenInput && !this.isOpenIO) {
            this.setIOStatus(-47);
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.warning("File Status=-47: READ NEXT requires file be OPENed as INPUT or IO.");
            }
            return new byte[0];
        }
        try {
            lenread = this.zFile.read(this.into);
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.finer("ZFile.read(into <length=" + this.into.length + ">)=" + lenread);
            }
        }
        catch (YFileException e) {
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.warning("" + e);
            }
            this.setIOStatus(-10);
            return new byte[0];
        }
        if (lenread <= 0) {
            this.setIOStatus(-10);
            return new byte[0];
        }
        this.setIOStatus(0);
        this.priorCommand = Command.READ_PREVIOUS;
        return this.into;
    }

    @Override
    public boolean write(String format, Variable nullKeyMap, Variable nullMap, Variable fromVar, int mode, Numeric timeout) {
        byte[] rec = fromVar.toByteArray();
        return this.write(rec, 0, rec.length);
    }

    @Override
    public synchronized boolean writeNetwork(boolean seqOverride, int dependingOnLength, byte[] data, int mode, double timeout) {
        if (dependingOnLength <= 0) {
            dependingOnLength = data.length;
        }
        return this.write(data, 0, dependingOnLength);
    }

    @Override
    public boolean write(Variable fromVar) {
        byte[] rec = fromVar.toByteArray();
        return this.write(rec, 0, rec.length);
    }

    private boolean write(byte[] record, int off, int len) {
        if (!this.isOpenOutput && !this.isOpenIO) {
            this.setIOStatus(-48);
            return false;
        }
        try {
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.finer("ZFile.write(\"" + zOSIndexedFile.encode(record) + "\"," + off + "," + len + ")");
            }
            this.zFile.write(record, off, len);
        }
        catch (YFileException e) {
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.warning("" + e);
            }
            this.setIOStatus(-90);
            return true;
        }
        this.setIOStatus(0);
        this.priorCommand = Command.WRITE;
        return false;
    }

    @Override
    public boolean rewrite(String format, Variable nullKeyMap, Variable nullMap, Variable fromVar, int mode, Numeric timeout) {
        return this.rewrite(fromVar, mode, timeout);
    }

    @Override
    public synchronized boolean rewriteNetwork(int dependingOnLength, byte[] data, int mode, double timeout) {
        if (dependingOnLength <= 0) {
            dependingOnLength = data.length;
        }
        return this.rewrite(dependingOnLength, data);
    }

    @Override
    public boolean rewrite(Variable fromVar) {
        byte[] record = fromVar.toByteArray();
        return this.rewrite(record.length, record);
    }

    private boolean rewrite(int len, byte[] record) {
        if (!this.isOpenIO) {
            this.setIOStatus(-49);
            return false;
        }
        try {
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.finer("ZFile.update(\"" + zOSIndexedFile.encode(record) + "\",0," + len + ")");
            }
            this.zFile.update(record, 0, len);
        }
        catch (YFileException e) {
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.warning("" + e);
            }
            this.setIOStatus(-23);
            return true;
        }
        this.setIOStatus(0);
        this.priorCommand = Command.REWRITE;
        return false;
    }

    @Override
    public boolean delete() {
        if (!this.isOpenIO) {
            this.setIOStatus(-49);
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.warning("" + this.fileStatus.toText() + ". Record cannot be deleted. File must be OPENed for I-O.");
            }
            return true;
        }
        if (this.accessMode == 1 && this.priorCommand != Command.READ && this.priorCommand != Command.READ_NEXT) {
            this.setIOStatus(-43);
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.warning("" + this.fileStatus.toText() + ". Record cannot be deleted. Previous access to file must be successful 'READ'.");
            }
            return true;
        }
        if (this.getPriorError() != 0) {
            this.setIOStatus(-23);
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.warning("" + this.fileStatus.toText() + ". Record cannot be deleted. No record found to be deleted. ");
            }
            return true;
        }
        try {
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.finer("ZFile.delrec()");
            }
            this.zFile.delrec();
        }
        catch (YFileException e) {
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.warning("" + e);
            }
            this.setIOStatus(-23);
            return true;
        }
        this.setIOStatus(0);
        this.priorCommand = Command.DELETE;
        return false;
    }

    @Override
    public void init() {
        try {
            if (this.file != null) {
                this.file.init();
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Override
    public int priorError() {
        return this.getPriorError();
    }

    @Override
    public final int getPriorError() {
        if (this.priorErrorCode > 0) {
            return -this.priorErrorCode;
        }
        return this.priorErrorCode;
    }

    @Override
    public final void setPriorError(int priorError) {
        this.priorErrorCode = priorError;
    }

    @Override
    public final int setIOStatus(int status) {
        char[] smallChar = new char[]{'0', '0'};
        if ((status = status < 0 ? -status : 0) == 9) {
            status = 0;
        }
        this.setPriorError(status);
        if (this.fileStatus != null) {
            if (status == 0) {
                this.fileStatus.moveZeroes();
            } else if (status < 10) {
                smallChar[1] = (char)(status + 48);
                this.fileStatus.move(smallChar);
            } else {
                this.fileStatus.move(status);
            }
        }
        return status;
    }

    @Override
    public final int setIOStatus(String x) {
        int status = 0;
        try {
            status = Integer.decode(x);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.setIOStatus(-status);
    }

    @Override
    public int iostatus(int status) {
        return this.setIOStatus(status);
    }

    @Override
    public int iostatus(String x) {
        return this.setIOStatus(x);
    }

    @Override
    public boolean isOK() {
        int priorErrorCode = this.getPriorError();
        return priorErrorCode > -10 && priorErrorCode < 10;
    }

    @Override
    public boolean useException() {
        int priorErrorCode = this.getPriorError();
        if (priorErrorCode < 0) {
            priorErrorCode = -priorErrorCode;
        }
        return priorErrorCode >= 10;
    }

    @Override
    public int useException(int specific, int input, int output, int io, int extend) {
        if (this.useException()) {
            if (specific >= 0) {
                return specific;
            }
            if (this.isInput()) {
                return input;
            }
            if (this.isOutput()) {
                return output;
            }
            if (this.isIO()) {
                return io;
            }
            if (this.isExtend()) {
                return extend;
            }
        }
        return -1;
    }

    @Override
    public int useException(int specific) {
        if (this.useException()) {
            return specific;
        }
        return -1;
    }

    @Override
    public boolean useAtEnd() {
        int priorErrorCode = this.getPriorError();
        return priorErrorCode == -10 || priorErrorCode == 10 || priorErrorCode == 14 || priorErrorCode == -14;
    }

    @Override
    public int useAtEnd(int specific, int input, int output, int io, int extend) {
        if (this.useAtEnd()) {
            if (specific >= 0) {
                return specific;
            }
            if (this.isInput()) {
                return input;
            }
            if (this.isOutput()) {
                return output;
            }
            if (this.isIO()) {
                return io;
            }
            if (this.isExtend()) {
                return extend;
            }
        }
        return -1;
    }

    @Override
    public int useAtEnd(int specific) {
        if (this.useAtEnd() && specific >= 0) {
            return specific;
        }
        return -1;
    }

    @Override
    public Numeric getLinageCounter() {
        return new Numeric(1);
    }

    @Override
    public Object getObject() {
        return null;
    }

    @Override
    public void finalize() throws Throwable {
        this.init();
        super.finalize();
    }

    @Override
    public idxFile settingExternalFile(Context context, String name) {
        Object copy = context.getExternalFile(this, name);
        if (copy == null) {
            return this;
        }
        if (!(copy instanceof zOSIndexedFile)) {
            return this;
        }
        if (copy == this) {
            return this;
        }
        this.externalFile = (zOSIndexedFile)copy;
        this.file = this.externalFile.file;
        return this;
    }

    @Override
    public boolean supportsTransactions() {
        if (this.file != null) {
            return this.file.supportsTransactions();
        }
        return false;
    }

    @Override
    public boolean begin() {
        if (this.supportsTransactions()) {
            return this.file.begin();
        }
        return false;
    }

    @Override
    public boolean commit() {
        if (this.supportsTransactions()) {
            return this.file.commit();
        }
        return false;
    }

    @Override
    public boolean rollback() {
        if (this.supportsTransactions()) {
            return this.file.rollback();
        }
        return false;
    }

    @Override
    public boolean recover() {
        if (this.supportsTransactions()) {
            return this.file.recover();
        }
        return false;
    }

    @Override
    public idxFile setPassword(Variable identifier) {
        return this;
    }

    public static String encode(byte[] b) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < b.length; ++i) {
            if (b[i] < 32 || b[i] > 126) {
                sb.append(".");
                continue;
            }
            sb.append((char)b[i]);
        }
        return sb.toString();
    }

    private static enum Command {
        DECLARE,
        OPEN,
        CLOSE,
        START,
        START_NEXT,
        READ,
        READ_NEXT,
        READ_PREVIOUS,
        WRITE,
        REWRITE,
        DELETE;

    }
}

