/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.efc;

import com.heirloomcomputing.ecs.exec.LogSetup;
import com.heirloomcomputing.efc.CobolElement;
import com.heirloomcomputing.efc.FileConverterConstants;
import com.heirloomcomputing.efc.Utils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class FileConverter
implements Runnable {
    private boolean convertFiller;
    private boolean isVerboseOutput;
    private boolean allowDupAltKeys;
    private String inDataType;
    private String outDataType;
    private String inRecKey;
    private String primaryKey;
    private String alternateKey;
    private String organization;
    private String access;
    private String inputOrganization;
    private String driverPgm;
    private String copyBook;
    private String convertEncoding;
    private String infile;
    private String outfile;
    private String rfs;
    private String xfd;
    private List<String> copyBookList;
    private List<String> copyBookPrint;
    private Integer fillerNum;
    private Map<String, String> overrideList;

    public FileConverter(String inputOrganization, String organization, String access, String drvrpgm, String copybook, String convert, String infile, String outfile, String rfs, String xfd, String inRecKey, String primaryKey, String alternateKey, String inDataType, String outDataType, boolean allowDuplicates, boolean verbose, boolean cvtFiller) {
        this.setInputOrganization(inputOrganization);
        this.setOrganization(organization);
        this.setAccess(access);
        this.setDriverPgm(drvrpgm);
        this.setCopyBook(copybook);
        this.setConvertEncoding(convert);
        this.setInfile(infile);
        this.setOutfile(outfile);
        this.setRfs(rfs);
        this.setXfd(xfd);
        this.setVerboseOutput(verbose);
        this.setCopyBookList(new ArrayList<String>());
        this.setCopyBookPrint(new ArrayList<String>());
        this.setInRecKey(inRecKey);
        this.setAllowDupAltKeys(allowDuplicates);
        this.setPrimaryKey(primaryKey);
        this.setAlternateKey(alternateKey);
        this.setInDataType(inDataType);
        this.setOutDataType(outDataType);
        this.setFillerNum(0);
        this.setConvertFiller(cvtFiller);
    }

    public FileConverter(String inputOrganization, String organization, String access, String outpgm, String copybook, String convert, String infile, String outfile) {
        this(inputOrganization, organization, access, outpgm, copybook, convert, infile, outfile, null, null, null, null, null, null, null, false, false, true);
    }

    public FileConverter() {
        this(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, false, false, true);
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            FileConverter.printUsage();
            System.exit(0);
        }
        HashMap<String, String> parms = Utils.parseArgs(args);
        String outPgmName = null;
        String copyBookName = null;
        String convertEncoding = null;
        String inputFileName = null;
        String outputFileName = null;
        String rfsFileName = null;
        String xfdFileName = null;
        boolean verboseOutput = false;
        String inOrganization = null;
        String outOrganization = null;
        String outAccess = null;
        String inputKey = null;
        String primaryKey = null;
        String alternateKey = null;
        String inDataType = null;
        String outDataType = null;
        boolean allowDuplicates = false;
        boolean cvtFiller = true;
        if (parms.containsKey("verbose") && parms.get("verbose").equals("true")) {
            verboseOutput = true;
        }
        if (parms.containsKey("inkey")) {
            inputKey = parms.get("inkey");
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.fine("inkey: " + inputKey);
            }
        }
        if (parms.containsKey("outkey")) {
            primaryKey = parms.get("outkey");
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.fine("outkey: " + primaryKey);
            }
        }
        if (parms.containsKey("altkey")) {
            alternateKey = parms.get("altkey");
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.fine("altkey: " + alternateKey);
            }
            if (parms.containsKey("altdups") && parms.get("altdups").equals("true")) {
                allowDuplicates = true;
                if (LogSetup.IS_LOGGING) {
                    LogSetup.LOGGER.fine("altdups: true");
                }
            }
        }
        if (parms.containsKey("cvtfiller")) {
            cvtFiller = !parms.get("cvtfiller").equals("false");
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.fine("cvtfiller: " + cvtFiller);
            }
        }
        if (parms.containsKey("inorg")) {
            inOrganization = parms.get("inorg");
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.fine("inorg: " + inOrganization);
            }
        } else {
            inOrganization = "sequential";
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.fine("inorg: " + inOrganization);
            }
        }
        if (parms.containsKey("outorg")) {
            outOrganization = parms.get("outorg");
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.fine("outorg: " + outOrganization);
            }
        } else {
            outOrganization = "sequential";
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.fine("outorg: " + outOrganization);
            }
        }
        if (parms.containsKey("outaccess")) {
            outAccess = parms.get("outaccess");
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.fine("outaccess: " + outAccess);
            }
        } else {
            outAccess = "sequential";
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.fine("outaccess: " + outAccess);
            }
        }
        if (parms.containsKey("infile")) {
            inputFileName = parms.get("infile");
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.fine("infile: " + inputFileName);
            }
        }
        if (parms.containsKey("outfile")) {
            outputFileName = parms.get("outfile");
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.fine("outfile: " + outputFileName);
            }
        }
        if (parms.containsKey("rfs")) {
            rfsFileName = parms.get("rfs");
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.fine("rfs: " + rfsFileName);
            }
        }
        if (parms.containsKey("xfd")) {
            xfdFileName = parms.get("xfd");
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.fine("xfd: " + xfdFileName);
            }
        }
        if (parms.containsKey("outpgm")) {
            outPgmName = parms.get("outpgm");
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.fine("outpgm: " + outPgmName);
            }
        }
        if (parms.containsKey("copybook")) {
            copyBookName = parms.get("copybook");
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.fine("copybook: " + copyBookName);
            }
        }
        if (parms.containsKey("convert")) {
            convertEncoding = parms.get("convert");
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.fine("convert: " + convertEncoding);
            }
        }
        if (outPgmName == null) {
            outPgmName = "cvtrpgm.cbl";
        }
        outPgmName.toLowerCase();
        if (!outPgmName.endsWith(".cbl")) {
            if (outPgmName.endsWith(".cob")) {
                outPgmName.replaceAll(".cob", ".cbl");
            } else {
                outPgmName = outPgmName + ".cbl";
            }
        }
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.fine("outPgmName: " + outPgmName);
        }
        if (copyBookName == null) {
            System.err.println("Must provide a copybook describing the COBOL record");
            System.err.println("i.e. copybook=/full/path/and/copybook/filename");
            System.exit(12);
        }
        if (parms.containsKey("indt")) {
            inDataType = parms.get("indt");
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.fine("indt: " + inDataType);
            }
        } else {
            inDataType = "7";
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.fine("indt: " + inDataType);
            }
        }
        if (parms.containsKey("outdt")) {
            outDataType = parms.get("outdt");
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.fine("outdt: " + outDataType);
            }
        } else {
            outDataType = "7";
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.fine("outdt: " + outDataType);
            }
        }
        FileConverter aConverter = new FileConverter(inOrganization, outOrganization, outAccess, outPgmName, copyBookName, convertEncoding, inputFileName, outputFileName, rfsFileName, xfdFileName, inputKey, primaryKey, alternateKey, inDataType, outDataType, allowDuplicates, verboseOutput, cvtFiller);
        aConverter.run();
    }

    @Override
    public void run() {
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.fine("start of run() method");
        }
        this.generateProgram();
        try {
            this.compileCobolToJava();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.executeJavaProgram();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.cleanUpFiles();
    }

    public void cleanUpFiles() {
        File directory = new File(System.getProperty("user.dir"));
        for (File f : directory.listFiles()) {
            if (!f.getName().endsWith(".java") && !f.getName().endsWith(".class")) continue;
            f.delete();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void generateProgram() {
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.fine("start of generateProgram() method");
        }
        Map<String, CobolElement> cobolElementHash = this.processCopybook(this.getCopyBookList());
        PrintStream original = System.out;
        PrintStream outPrintStream = null;
        if (this.getDriverPgm() != null) {
            try {
                outPrintStream = new PrintStream(new File(this.getDriverPgm()));
            }
            catch (FileNotFoundException fnfe) {
                fnfe.printStackTrace();
                System.exit(12);
            }
            System.setOut(outPrintStream);
        }
        for (String string2 : FileConverterConstants.DECLARE_DIRECTIVES) {
            System.out.println(string2);
        }
        if (this.getConvertEncoding() != null) {
            if (this.getConvertEncoding().equals("e2a")) {
                System.out.println("      $set constant encoding(2)");
                System.out.println("      $set directive\"-dt 8\"");
            } else if (this.getConvertEncoding().equals("a2e")) {
                System.out.println("      $set constant encoding(1)");
                System.out.println("      $set directive\"-dt 7\"");
            } else {
                System.out.println("      $set constant encoding(0)");
            }
        } else {
            System.out.println("      $set constant encoding(0)");
        }
        for (String string3 : FileConverterConstants.DECLARE_SECTION) {
            System.out.println(string3);
        }
        System.out.println("       program-id.    " + this.getDriverPgm().replaceAll(".cbl", "") + ".");
        for (String string4 : FileConverterConstants.DECLARE_SECTION1) {
            System.out.println(string4);
        }
        for (String string5 : FileConverterConstants.DECLARE_SECTION_INPUT) {
            System.out.println(string5);
        }
        System.out.println("                organization         is " + this.getInputFileOrg());
        for (String string6 : FileConverterConstants.DATA_DIVISION_FD_HDR_INPUT) {
            System.out.println(string6);
        }
        for (String string7 : FileConverterConstants.DECLARE_SECTION_OUTPUT) {
            System.out.println(string7);
        }
        System.out.println("                organization         is " + this.getOrganization());
        System.out.println("                access               is " + this.getAccess());
        if (this.getPrimaryKey() != null) {
            System.out.println("                record key           is " + this.getPrimaryKey());
            if (this.getAlternateKey() != null) {
                Object altKeyLine = "          alternate record key is " + this.getAlternateKey();
                if (this.isAllowDupAltKeys()) {
                    altKeyLine = (String)altKeyLine + " with duplicates";
                }
                System.out.println("      " + (String)altKeyLine);
            }
        }
        for (String string8 : FileConverterConstants.DATA_DIVISION_FD_HDR_OUTPUT) {
            System.out.println(string8);
        }
        System.out.println("       fd recinp");
        System.out.println("          recording mode is f");
        System.out.println("       .");
        System.out.println("");
        System.out.println("       01 recinp-rec.");
        for (String line : this.getCopyBookList()) {
            System.out.println("          " + line);
        }
        System.out.println("");
        System.out.println("       fd recout");
        System.out.println("          recording mode is f");
        System.out.println("       .");
        System.out.println("");
        System.out.println("       01 recout-rec.");
        for (String line : this.getCopyBookList()) {
            System.out.println("          " + line);
        }
        System.out.println("");
        for (String string9 : FileConverterConstants.WS_SECTION) {
            System.out.println(string9);
        }
        System.out.println("");
        for (String string10 : FileConverterConstants.CP_TABLES) {
            System.out.println(string10);
        }
        System.out.println("");
        for (String string11 : FileConverterConstants.PROC_SECTION) {
            System.out.println(string11);
        }
        for (String string12 : FileConverterConstants.PROC_CONVERT_CODESET_SECTION) {
            System.out.println(string12);
        }
        String rfsInput = null;
        ArrayList<String> recList = new ArrayList<String>();
        HashMap<String, String> recMap = new HashMap<String, String>();
        rfsInput = this.getRfs();
        if (rfsInput != null) {
            this.processRfsFile(rfsInput, recList, recMap);
        } else {
            rfsInput = this.getXfd();
            if (rfsInput != null) {
                this.processRfsFile(this.processXfdInput(rfsInput), recList, recMap);
            } else {
                recList.add("1");
                recMap.put("1", "uno");
            }
        }
        Object var7_33 = null;
        String defGrp = null;
        for (String rec : recList) {
            void var7_34;
            if (recList.size() == 1) {
                System.out.println("           go to 4000-REC" + rec + ".");
                continue;
            }
            String condition = (String)recMap.get(rec);
            if (condition == null) continue;
            String[] toks = condition.split("\\|");
            if (toks.length > 1 && toks[0].equalsIgnoreCase("default") && toks[1] != null) {
                String string13 = "default";
                defGrp = toks[1];
            }
            if (var7_34 != null && defGrp != null) {
                System.out.println("           if 1 = 1");
            } else {
                String[] c_toks = toks[0].split("(<=|>=|<|>|=)");
                String c_stmt = c_toks[0] + " of recinp-rec " + toks[0].substring(c_toks[0].length());
                System.out.println("           if " + c_stmt);
            }
            System.out.println("              go to 4000-REC" + rec + ".");
        }
        for (String rec : recList) {
            int occurs;
            CobolElement cobElement;
            boolean isSignedNumeric;
            String toTable;
            String fromTable;
            String refMod;
            String excludeName = null;
            ArrayList<String> excludeList = null;
            ArrayList<String> grpList = null;
            String condition = (String)recMap.get(rec);
            String grpName = null;
            if (condition != null && !condition.equals("uno")) {
                String[] toks = condition.split("\\|");
                grpName = toks[1];
                excludeName = this.getExcludeElementName(grpName, cobolElementHash);
                excludeList = new ArrayList<String>();
                this.getAllChildren(excludeName, excludeList, cobolElementHash);
                grpList = new ArrayList<String>();
                this.getAllChildren(grpName, grpList, cobolElementHash);
                this.getOverrideList().clear();
                for (String gl : grpList) {
                    this.setOverrideList(gl);
                }
            }
            System.out.println("       4000-REC" + rec + ".");
            ArrayList<String> convertFieldList = new ArrayList<String>();
            for (Map.Entry<String, CobolElement> entry : cobolElementHash.entrySet()) {
                CobolElement cobElement2;
                String cobName = entry.getKey();
                if (condition != null && excludeList != null && excludeList.contains(cobName) || !this.isConvertible(cobElement2 = entry.getValue(), cobolElementHash) || !cobElement2.getChildren().isEmpty()) continue;
                if (cobElement2.getName().equalsIgnoreCase("FILLER")) {
                    CobolElement parentElement = cobolElementHash.get(cobElement2.getParent());
                    if (parentElement.getChildren().size() != 1) continue;
                    convertFieldList.add(parentElement.getName());
                    continue;
                }
                convertFieldList.add(cobElement2.getName());
            }
            System.out.println("      $if encoding = 2");
            for (String cvtField : convertFieldList) {
                refMod = "(1:)";
                fromTable = "E-INFO";
                toTable = "A-INFO";
                isSignedNumeric = false;
                cobElement = cobolElementHash.get(cvtField);
                if (cobElement.isSigned()) {
                    isSignedNumeric = true;
                }
                if ((occurs = this.getOccursCnt(cobolElementHash.get(cvtField), cobolElementHash)) > 0) {
                    System.out.println("           perform varying sub from 1 by 1");
                    System.out.println("               until sub > " + occurs);
                    if (isSignedNumeric) {
                        System.out.println("             compute len = length of " + cvtField + " of ");
                        System.out.println("                recinp-rec(sub) end-compute");
                        refMod = "(1:len - 1)";
                        System.out.println("             inspect " + cvtField + " of ");
                        System.out.println("                recinp-rec(sub)" + refMod);
                        System.out.println("                converting " + fromTable + " to " + toTable);
                        fromTable = "EO-INFO";
                        toTable = "AO-INFO";
                        refMod = "(len:1)";
                    }
                    System.out.println("             inspect " + cvtField + " of ");
                    System.out.println("                recinp-rec(sub)" + refMod);
                    System.out.println("                converting " + fromTable + " to " + toTable);
                    System.out.println("           end-perform.");
                    continue;
                }
                if (isSignedNumeric) {
                    System.out.println("             compute len = length of " + cvtField + " of ");
                    System.out.println("                recinp-rec end-compute");
                    refMod = "(1:len - 1)";
                    System.out.println("             inspect " + cvtField + " of ");
                    System.out.println("                recinp-rec" + refMod);
                    System.out.println("                converting " + fromTable + " to " + toTable);
                    fromTable = "EO-INFO";
                    toTable = "AO-INFO";
                    refMod = "(len:1)";
                }
                System.out.println("           inspect " + cvtField + " of ");
                System.out.println("                recinp-rec" + refMod);
                System.out.println("              converting " + fromTable + " to " + toTable + ".");
            }
            System.out.println("      $else if encoding = 1");
            for (String cvtField : convertFieldList) {
                refMod = "(1:)";
                fromTable = "A-INFO";
                toTable = "E-INFO";
                isSignedNumeric = false;
                cobElement = cobolElementHash.get(cvtField);
                if (cobElement.isSigned()) {
                    isSignedNumeric = true;
                }
                if ((occurs = this.getOccursCnt(cobolElementHash.get(cvtField), cobolElementHash)) > 0) {
                    System.out.println("           perform varying sub from 1 by 1");
                    System.out.println("               until sub > " + occurs);
                    if (isSignedNumeric) {
                        System.out.println("             compute len = length of " + cvtField + " of ");
                        System.out.println("                recinp-rec(sub) end-compute");
                        refMod = "(1:len - 1)";
                        System.out.println("             inspect " + cvtField + " of ");
                        System.out.println("                recinp-rec(sub)" + refMod);
                        System.out.println("                converting " + fromTable + " to " + toTable);
                        fromTable = "AO-INFO";
                        toTable = "EO-INFO";
                        refMod = "(len:1)";
                    }
                    System.out.println("             inspect " + cvtField + " of ");
                    System.out.println("                recinp-rec(sub)" + refMod);
                    System.out.println("                converting " + fromTable + " to " + toTable);
                    System.out.println("           end-perform.");
                    continue;
                }
                if (isSignedNumeric) {
                    System.out.println("             compute len = length of " + cvtField + " of ");
                    System.out.println("                recinp-rec end-compute");
                    refMod = "(1:len - 1)";
                    System.out.println("             inspect " + cvtField + " of ");
                    System.out.println("                recinp-rec" + refMod);
                    System.out.println("                converting " + fromTable + " to " + toTable);
                    fromTable = "AO-INFO";
                    toTable = "EO-INFO";
                    refMod = "(len:1)";
                }
                System.out.println("           inspect " + cvtField + " of ");
                System.out.println("                recinp-rec" + refMod);
                System.out.println("              converting " + fromTable + " to " + toTable + ".");
            }
            System.out.println("      $endif");
            System.out.println("           go to 4000-convert-codeset-exit.");
        }
        for (String line : FileConverterConstants.PROC_CONVERT_CODESET_EXIT_SECTION) {
            System.out.println(line);
        }
        System.out.flush();
        System.setOut(original);
    }

    private String getExcludeElementName(String grpName, Map<String, CobolElement> cobolElementHash) {
        String redefSourceName = null;
        String foundName = null;
        String searchName = grpName;
        while ((redefSourceName = cobolElementHash.get(searchName).getNameOfRedef()) != null) {
            searchName = foundName = redefSourceName;
        }
        return foundName;
    }

    private void getAllChildren(String grpName, List<String> grpList, Map<String, CobolElement> cobolElementHash) {
        if (grpName == null) {
            return;
        }
        CobolElement grpCobElement = cobolElementHash.get(grpName);
        if (grpCobElement == null) {
            return;
        }
        if (grpCobElement.getChildren().isEmpty()) {
            grpList.add(grpCobElement.getName());
        } else {
            List<String> childList = grpCobElement.getChildren();
            for (String childName : childList) {
                CobolElement childCobElement = cobolElementHash.get(childName);
                this.getAllChildren(childCobElement.getName(), grpList, cobolElementHash);
            }
        }
    }

    private void processRfsFile(InputStream rfsInputStream, List<String> recList, Map<String, String> recMap) {
        try {
            int recNum = 0;
            BufferedReader br = new BufferedReader(new InputStreamReader(rfsInputStream));
            String line = null;
            String defLine = null;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("default") || line.startsWith("DEFAULT")) {
                    defLine = line;
                    continue;
                }
                recList.add(String.valueOf(++recNum));
                recMap.put(String.valueOf(recNum), line);
            }
            br.close();
            if (defLine != null) {
                recList.add(String.valueOf(++recNum));
                recMap.put(String.valueOf(recNum), defLine);
            }
        }
        catch (IOException fnf) {
            fnf.printStackTrace();
        }
    }

    private void processRfsFile(String rfsFile, List<String> recList, Map<String, String> recMap) {
        try {
            FileInputStream is = new FileInputStream(rfsFile);
            this.processRfsFile(is, recList, recMap);
        }
        catch (IOException fnf) {
            fnf.printStackTrace();
        }
    }

    private InputStream processXfdInput(String inputXfd) {
        StringBuilder osb = new StringBuilder();
        try {
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
            XMLStreamReader xmlStreamReader = inputFactory.createXMLStreamReader(new BufferedReader(new FileReader(inputXfd)));
            ArrayList<String> noXargList = new ArrayList<String>();
            ArrayList<String> redefList = new ArrayList<String>();
            while (xmlStreamReader.hasNext()) {
                int event = xmlStreamReader.next();
                if (event != 1) continue;
                String tableName = null;
                if (xmlStreamReader.getLocalName().equals("dataset")) {
                    for (int i = 0; i < xmlStreamReader.getAttributeCount(); ++i) {
                        String name = xmlStreamReader.getAttributeLocalName(i);
                        if (!name.equals("name")) continue;
                        tableName = xmlStreamReader.getAttributeValue(i);
                    }
                    continue;
                }
                if (!xmlStreamReader.getLocalName().equals("group")) continue;
                String groupName = null;
                String xfdVar = null;
                String xfdOp = null;
                String xfdArg = null;
                String redef = null;
                String prtOp = "";
                for (int i = 0; i < xmlStreamReader.getAttributeCount(); ++i) {
                    String name = xmlStreamReader.getAttributeLocalName(i);
                    if (name.equals("name")) {
                        groupName = xmlStreamReader.getAttributeValue(i);
                        continue;
                    }
                    if (name.equals("redefines")) {
                        redef = xmlStreamReader.getAttributeValue(i);
                        redefList.add(redef);
                        continue;
                    }
                    if (name.equals("xfdvar")) {
                        xfdVar = xmlStreamReader.getAttributeValue(i);
                        continue;
                    }
                    if (name.equals("xfdop")) {
                        xfdOp = xmlStreamReader.getAttributeValue(i);
                        if (xfdOp.equals("EQ")) {
                            prtOp = " = ";
                            continue;
                        }
                        if (xfdOp.equals("GT")) {
                            prtOp = " > ";
                            continue;
                        }
                        if (xfdOp.equals("GE")) {
                            prtOp = " >= ";
                            continue;
                        }
                        if (xfdOp.equals("LT")) {
                            prtOp = " < ";
                            continue;
                        }
                        if (!xfdOp.equals("LE")) continue;
                        prtOp = " <= ";
                        continue;
                    }
                    if (!name.equals("xfdarg1")) continue;
                    xfdArg = xmlStreamReader.getAttributeValue(i);
                }
                if (xfdVar == null) {
                    noXargList.add(groupName);
                    continue;
                }
                osb.append(xfdVar.replaceAll("_", "-")).append(prtOp).append(xfdArg).append("|").append(groupName.replaceAll("_", "-")).append(System.lineSeparator());
            }
            for (String n : noXargList) {
                for (String r : redefList) {
                    if (!n.equals(r)) continue;
                    osb.append("default|").append(n.replaceAll("_", "-")).append(System.lineSeparator());
                }
            }
        }
        catch (FactoryConfigurationError e) {
            System.out.println("FactoryConfigurationError" + e.getMessage());
        }
        catch (XMLStreamException e) {
            System.out.println("XMLStreamException" + e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("IOException" + e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new ByteArrayInputStream(osb.toString().getBytes());
    }

    private int getOccursCnt(CobolElement cobolElement, Map<String, CobolElement> cobolElementHash) {
        int cnt = 0;
        if (cobolElement != null) {
            if (cobolElement.getOccurs() > 0) {
                return cobolElement.getOccurs();
            }
            cnt = this.getOccursCnt(cobolElementHash.get(cobolElement.getParent()), cobolElementHash);
            if (cnt > 0) {
                return cnt;
            }
        }
        return 0;
    }

    private boolean isConvertible(CobolElement cobElement, Map<String, CobolElement> cobElementHash) {
        if (cobElement == null) {
            return false;
        }
        if (cobElement.isBinary()) {
            return false;
        }
        return !this.isARedefinedElement(cobElement, cobElementHash) || this.isOnOverrideList(cobElement.getName());
    }

    private Map<String, String> getOverrideList() {
        if (this.overrideList == null) {
            this.overrideList = new HashMap<String, String>();
        }
        return this.overrideList;
    }

    private void setOverrideList(String name) {
        if (this.overrideList == null) {
            this.overrideList = new HashMap<String, String>();
        }
        this.overrideList.put(name, name);
    }

    private boolean isOnOverrideList(String name) {
        return this.getOverrideList().containsKey(name);
    }

    private boolean isSourceOfRedef(CobolElement cobElement, Map<String, CobolElement> cobElementHash) {
        if (cobElement != null) {
            String name = cobElement.getName();
            for (Map.Entry<String, CobolElement> entry : cobElementHash.entrySet()) {
                String cobName = entry.getKey();
                CobolElement cobolElement = entry.getValue();
                if (!name.equals(cobolElement.getNameOfRedef())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isARedefinedElement(CobolElement cobElement, Map<String, CobolElement> cobElementHash) {
        if (cobElement != null) {
            if (cobElement.isARedefine()) {
                return true;
            }
            if (this.isARedefinedElement(cobElementHash.get(cobElement.getParent()), cobElementHash)) {
                return true;
            }
        }
        return false;
    }

    private Map<String, CobolElement> processCopybook(List<String> copyBookList) {
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.fine("start of processCopybook(List<String> copyBookList) method");
        }
        HashMap<String, CobolElement> cobElementHash = new HashMap<String, CobolElement>();
        try {
            ArrayList<String> tmpPrintList = new ArrayList<String>();
            BufferedReader br = new BufferedReader(new FileReader(this.getCopyBook()));
            String line = null;
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                if (line.length() < 7 || line.charAt(6) == '*') continue;
                sb.append("      ").append(String.format("%0$-80s", line).substring(6, 72).replaceAll("\\s+$", "").replaceAll("\\.$", " \u001c")).append(" ");
                tmpPrintList.add(line);
            }
            br.close();
            String[] toks = sb.toString().trim().replaceAll(" +", " ").split("\u001c");
            for (int i = 0; i < toks.length; ++i) {
                String copyLine = null;
                copyLine = this.isConvertFiller() ? this.generateFillerName(toks[i]) : toks[i].trim() + ".";
                if (copyLine.startsWith("88")) continue;
                copyBookList.add(copyLine);
            }
            int startIndex = 0;
            String firstElement = null;
            for (String string2 : copyBookList) {
                String[] cob_toks = string2.trim().split("\\s+");
                if (Integer.valueOf(cob_toks[0]) > 1) {
                    firstElement = cob_toks[1];
                    break;
                }
                ++startIndex;
            }
            boolean startAdding = false;
            for (String printLine : tmpPrintList) {
                if (!startAdding) {
                    if (!printLine.contains(firstElement)) continue;
                    startAdding = true;
                    this.getCopyBookPrint().add(printLine);
                    continue;
                }
                this.getCopyBookPrint().add(printLine);
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            int ord = 0;
            String parentName = null;
            for (String element : copyBookList) {
                ++ord;
                String[] el_toks = element.split("\\s+");
                String name = null;
                int curLvl = 0;
                boolean isBinary = false;
                boolean isNumeric = false;
                boolean isSigned = false;
                boolean isRedefines = false;
                String nameOfRedefined = null;
                ArrayList<String> children = new ArrayList<String>();
                int occurs = 0;
                int chgLevel = 0;
                block8: for (int j = 0; j < el_toks.length; ++j) {
                    if (j == 0) {
                        curLvl = Integer.parseInt(el_toks[j]);
                        for (int k = ord; k < copyBookList.size(); ++k) {
                            String[] c_toks = copyBookList.get(k).split("\\s+");
                            int lvl = Integer.parseInt(c_toks[0]);
                            if (chgLevel == 0) {
                                chgLevel = lvl;
                            }
                            if (lvl < chgLevel) continue block8;
                            if (lvl != chgLevel) continue;
                            if (lvl <= curLvl) continue block8;
                            children.add(c_toks[1]);
                        }
                        continue;
                    }
                    if (j == 1) {
                        name = el_toks[j].replaceAll("\\.", "").trim();
                        arrayList.add(name);
                        continue;
                    }
                    if (el_toks[j].equalsIgnoreCase("PIC")) {
                        if (el_toks[j + 1].startsWith("X") || el_toks[j + 1].startsWith("x")) continue;
                        if (el_toks[j + 1].startsWith("S9") || el_toks[j + 1].startsWith("s9")) {
                            isNumeric = true;
                            isSigned = true;
                            continue;
                        }
                        if (!el_toks[j + 1].startsWith("9")) continue;
                        isNumeric = true;
                        continue;
                    }
                    if (el_toks[j].toUpperCase().startsWith("COMP") || el_toks[j].toUpperCase().startsWith("COMP.") || el_toks[j].toUpperCase().startsWith("COMP-") || el_toks[j].toUpperCase().startsWith("COMPUTATIONAL") || el_toks[j].toUpperCase().startsWith("COMPUTATIONAL.") || el_toks[j].toUpperCase().startsWith("COMPUTATIONAL-") || el_toks[j].toUpperCase().startsWith("BINARY")) {
                        isBinary = true;
                        continue;
                    }
                    if (el_toks[j].toUpperCase().equals("REDEFINES")) {
                        isRedefines = true;
                        nameOfRedefined = el_toks[j + 1].replaceAll("\\.", "");
                        continue;
                    }
                    if (!el_toks[j].toUpperCase().equals("OCCURS")) continue;
                    occurs = Integer.parseInt(el_toks[j + 1].replaceAll("\\.", ""));
                }
                for (int l = ord - 2; l > -1; --l) {
                    String[] c_toks = copyBookList.get(l).split("\\s+");
                    if (Integer.parseInt(c_toks[0]) >= curLvl) continue;
                    parentName = new String(c_toks[1].replaceAll("\\.", ""));
                    break;
                }
                cobElementHash.put(name, new CobolElement(name, curLvl, isBinary, isRedefines, isSigned, occurs, ord, nameOfRedefined, parentName, children));
            }
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
            System.err.println("Could find copyBook: " + this.getCopyBook());
            System.exit(12);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.err.println("Could not read copyBook: " + this.getCopyBook());
            System.exit(12);
        }
        int i = 0;
        String prevLvl = null;
        for (String line : copyBookList) {
            if (i > 0 && line.substring(0, 2).compareTo(prevLvl) > 0) break;
            prevLvl = line.substring(0, 2);
            ++i;
        }
        if (--i >= 0) {
            copyBookList.remove(i);
        }
        return cobElementHash;
    }

    private String generateFillerName(String line) {
        String[] line_toks = line.trim().split("\\s+");
        StringBuffer sb = new StringBuffer(line.length() + 5);
        if (line_toks[1].equalsIgnoreCase("filler")) {
            for (int i = 0; i < line_toks.length; ++i) {
                if (line_toks[i].equalsIgnoreCase("filler")) {
                    sb.append(" ").append(line_toks[i]).append("-").append(this.getNextFillerNum());
                    continue;
                }
                if (i != 0) {
                    sb.append(" ");
                }
                sb.append(line_toks[i]);
            }
            sb.append(".");
        } else {
            sb.append(line.trim() + ".");
        }
        return sb.toString();
    }

    private void compileCobolToJava() throws IOException {
        String execFileName;
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.fine("start of compileCobolToJava() method");
            LogSetup.LOGGER.fine("Working Directory = " + System.getProperty("user.dir"));
        }
        String string2 = execFileName = System.getProperty("os.name").toLowerCase().contains("windows") ? "ecobol.exe" : "ecobol";
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.fine(execFileName + " must be defined on system $PATH environment.");
        }
        String classPathSeparator = System.getProperty("os.name").toLowerCase().contains("windows") ? ";" : ":";
        String[] command = new String[]{execFileName, this.getDriverPgm(), "-out:class", "-classpath", System.getProperty("user.dir") + "/econv.jar" + classPathSeparator + System.getProperty("user.dir") + "/econv_ui.jar"};
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.fine("classpath: " + command[4]);
        }
        this.launchProcess(command);
    }

    private void executeJavaProgram() throws IOException {
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.fine("start of executeJavaProgram() method");
        }
        this.setVerboseOutput(true);
        String classPathSeparator = System.getProperty("os.name").toLowerCase().contains("windows") ? ";" : ":";
        String[] command = new String[]{"java", "-classpath", System.getProperty("user.dir") + "/econv.jar" + classPathSeparator + System.getProperty("user.dir") + "/econv_ui.jar" + classPathSeparator + System.getProperty("user.dir"), this.getDriverPgm().replaceAll(".cbl", ""), "infile=" + this.getInfile(), "outfile=" + this.getOutfile()};
        this.launchProcess(command);
    }

    private void launchProcess(String[] command) throws IOException {
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.fine("start of launchProcess(String[] command) method");
        }
        ProcessBuilder procBuilder = new ProcessBuilder(command);
        procBuilder.redirectErrorStream(true);
        Process process = procBuilder.start();
        InputStream is = process.getInputStream();
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isr);
        if (this.isVerboseOutput()) {
            String line;
            while ((line = br.readLine()) != null) {
                System.out.println(line);
            }
        }
        try {
            int exitValue = process.waitFor();
            if (this.isVerboseOutput()) {
                System.out.println("\n\nExit Value is " + exitValue);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private Integer getNextFillerNum() {
        return this.setFillerNum(this.getFillerNum() + 1);
    }

    public String getInputFileOrg() {
        return this.getInputOrganization();
    }

    public void setInputFileOrg(String inputFileOrganization) {
        this.setInputOrganization(inputFileOrganization);
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public String getAccess() {
        return this.access;
    }

    public void setAccess(String access) {
        this.access = access;
    }

    public String getDriverPgm() {
        return this.driverPgm;
    }

    public void setOutputPgm(String outputPgm) {
        this.setDriverPgm(outputPgm);
    }

    public String getCopyBook() {
        return this.copyBook;
    }

    public void setCopyBook(String copyBook) {
        this.copyBook = copyBook;
    }

    public String getConvertEncoding() {
        return this.convertEncoding;
    }

    public void setConvertEncoding(String convert) {
        this.convertEncoding = convert;
    }

    public String getInfile() {
        return this.infile;
    }

    public void setInfile(String infile) {
        this.infile = infile;
    }

    public String getOutfile() {
        return this.outfile;
    }

    public void setOutfile(String outfile) {
        this.outfile = outfile;
    }

    public boolean isVerboseOutput() {
        return this.isVerboseOutput;
    }

    public void setVerboseOutput(boolean isVerbose) {
        this.isVerboseOutput = isVerbose;
    }

    public boolean isAllowDupAltKeys() {
        return this.allowDupAltKeys;
    }

    public void setAllowDupAltKeys(boolean allowDupAltKeys) {
        this.allowDupAltKeys = allowDupAltKeys;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public String getAlternateKey() {
        return this.alternateKey;
    }

    public void setAlternateKey(String alternateKey) {
        this.alternateKey = alternateKey;
    }

    private String getInputOrganization() {
        return this.inputOrganization;
    }

    private void setInputOrganization(String inputOrganization) {
        this.inputOrganization = inputOrganization;
    }

    private void setDriverPgm(String driverPgm) {
        this.driverPgm = driverPgm;
    }

    private List<String> getCopyBookList() {
        return this.copyBookList;
    }

    private void setCopyBookList(List<String> copyBookList) {
        this.copyBookList = copyBookList;
    }

    public String getInRecKey() {
        return this.inRecKey;
    }

    public void setInRecKey(String inRecKey) {
        this.inRecKey = inRecKey;
    }

    public String getInDataType() {
        return this.inDataType;
    }

    public void setInDataType(String inDataType) {
        this.inDataType = inDataType;
    }

    public String getOutDataType() {
        return this.outDataType;
    }

    public void setOutDataType(String outDataType) {
        this.outDataType = outDataType;
    }

    private Integer getFillerNum() {
        return this.fillerNum;
    }

    private Integer setFillerNum(Integer fillerNum) {
        this.fillerNum = fillerNum;
        return fillerNum;
    }

    private boolean isConvertFiller() {
        return this.convertFiller;
    }

    private void setConvertFiller(boolean convertFiller) {
        this.convertFiller = convertFiller;
    }

    public String getRfs() {
        return this.rfs;
    }

    public void setRfs(String rfs) {
        this.rfs = rfs;
    }

    public String getXfd() {
        return this.xfd;
    }

    public void setXfd(String xfd) {
        this.xfd = xfd;
    }

    public List<String> getCopyBookPrint() {
        return this.copyBookPrint;
    }

    public void setCopyBookPrint(List<String> copyBookPrint) {
        this.copyBookPrint = copyBookPrint;
    }

    private static void printUsage() {
        System.err.println("Usage: java com.heirloomcomputing.efc.FileConverter [args...] ");
        System.err.println("           (to execute as class) ");
        System.err.println("   or  java -jar econv.jar [args...] ");
        System.err.println("           (to execute as jar file) ");
        System.err.println("");
        System.err.println("where args are key/value pairs that include:");
        System.err.println("infile\t  infile=/path/to/inputfile.dat            ***REQUIRED***");
        System.err.println("");
        System.err.println("outfile\t  outfile=/path/to/outputfile.dat          ***REQUIRED***");
        System.err.println("");
        System.err.println("copybook  copybook=/path/to/cobcopy.cpy            ***REQUIRED***");
        System.err.println("           (cobol copybook that describes record layout)");
        System.err.println("");
        System.err.println("rfs       rfs=/path/to/conditions.rfs    ***REQUIRED FOR MULTI RECORD LAYOUTS unless XFD specified***");
        System.err.println("(record file structure identifies conditions and corresponding group items to use)");
        System.err.println("");
        System.err.println("xfd       xfd=/path/to/cobcopy.xml    ***REQUIRED FOR MULTI RECORD LAYOUTS unless RFS specified***");
        System.err.println("(xfd with xfdarg ,xfdop and xfdvar identifies conditions and corresponding group items to use)");
        System.err.println("");
        System.err.println("convert\t  convert=e2a[|a2e] e2a-ebcdic to ascii, a2e-ascii to ebcdic");
        System.err.println("");
        System.err.println("outpgm\t  outpgm=cvtpgm1.cbl");
        System.err.println("           (use outpgm if you want to assign a specific name for the conversion program) ");
        System.err.println("");
        System.err.println("outkey\t  outkey=file-fld-key");
        System.err.println("           (file-fld-key would be the field in cobcopy.cpy that represents the primary key field) ");
        System.err.println("");
        System.err.println("altkey\t  altkey=file-fld-altkey");
        System.err.println("           (file-fld-altkey would be the field in cobcopy.cpy that represents the alternate key field) ");
        System.err.println("");
        System.err.println("altdups\t  altdups=true[|false]");
        System.err.println("");
        System.err.println("inorg\t  inorg=sequential");
        System.err.println("           (sequential | indexed | line sequential) ");
        System.err.println("");
        System.err.println("outorg\t  outorg=sequential");
        System.err.println("           (sequential | indexed | line sequential) ");
        System.err.println("");
        System.err.println("outdt\t  outdt=7");
        System.err.println("           (0=EC,2=Acu,4=MPE,5=MF,6=RM,7=IBMA,8=IBME) ");
        System.err.println("");
        System.err.println("verbose\t  verbose=true[|false]");
        System.err.println("           (generate verbose output) ");
        System.err.println("");
        System.err.println("logging");
        System.err.println("-DLOG=true");
    }
}

