/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.term;

import com.heirloomcomputing.ecc.CursesInterface;
import com.heirloomcomputing.term.KeyValue;
import com.heirloomcomputing.term.ScreenHandler;
import com.heirloomcomputing.term.Utilities;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionListener;

public class CursesHandler
implements ScreenHandler {
    public static boolean debugMode = false;
    private static CursesInterface Term;
    private static int cursorx;
    private static int cursory;
    private static keyboard Keyboard;
    private char secureChar = (char)32;
    private boolean secureCharSet = false;
    private boolean dataModified = false;
    public static final int DEFAULT_LINES = 25;
    public static final int DEFAULT_COLUMNS = 80;
    boolean clip = false;
    boolean scroll = false;
    private int realAttr = 0;
    private KeyValue terminator;
    private KeyValue exitKey;
    private boolean insertMode;
    private int cx = 0;
    private int cy = 0;
    private StringBuffer text = null;
    private int startpos = 0;
    private int startx = 0;
    private int starty = 0;
    private int startsc = 0;
    private int curpos = 0;
    private int endpos = -1;
    private int sx = 0;
    private int sy = 0;

    private static void debug(String string2) {
        System.out.println("CursesHandler: " + string2);
    }

    public CursesHandler() throws Throwable {
        this("Console", Color.green, Color.black, 25, 80);
    }

    public CursesHandler(String string2, Color color2, Color color3, int n, int n2) throws Throwable {
        if (Term == null) {
            try {
                Term = (CursesInterface)Class.forName("com.heirloomcomputing.ecc.NativeCurses").newInstance();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (Term == null) {
                try {
                    Class<?> clazz = Class.forName("com.heirloomcomputing.term.jcurses.jcurses");
                    Term = (CursesInterface)clazz.newInstance();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (Term == null) {
                throw new RuntimeException("Could not load any curses implementation");
            }
            try {
                if (!Term.initializescreen()) {
                    throw new RuntimeException("Could not initialize term");
                }
            }
            catch (Throwable throwable) {
                throw new RuntimeException("Could not open term");
            }
            Term.raw();
            Term.nonl();
            Term.keypad(true);
            Term.noecho();
            Keyboard = new keyboard(128);
        }
    }

    @Override
    public boolean isDataModified() {
        return this.dataModified;
    }

    @Override
    public void end() {
        if (Term != null) {
            Term.endwin();
        }
    }

    @Override
    public boolean move(int n, int n2) {
        if (Term == null) {
            return false;
        }
        try {
            cursorx = n2;
            cursory = n;
            Term.move((short)cursory, (short)cursorx);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    @Override
    public boolean refresh() {
        if (Term == null) {
            return false;
        }
        try {
            if (Term.refresh() == -1) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    @Override
    public void forceRefresh() {
    }

    private void scroll() {
        Term.scroll();
    }

    public static final boolean isPrintable(char c) {
        return c >= ' ' && c != '\u007f' && c != '\uffff';
    }

    @Override
    public boolean print(String string2) {
        if (debugMode) {
            CursesHandler.debug("Called print(" + string2 + ")");
        }
        if (string2 == null) {
            return false;
        }
        int n = string2.length();
        block0: for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            if (!CursesHandler.isPrintable(c)) {
                int n2;
                if (c == '\u0007') {
                    this.beep();
                    continue;
                }
                if (c == '\t') {
                    for (n2 = 0; n2 < 8; ++n2) {
                        if (cursorx >= Term.getColumns()) {
                            if (this.clip) {
                                cursorx = Term.getColumns() - 1;
                                return true;
                            }
                            cursorx = 0;
                            ++cursory;
                            continue block0;
                        }
                        if (cursory >= Term.getLines()) {
                            if (!this.scroll) {
                                cursory = Term.getLines() - 1;
                                return true;
                            }
                            cursory = Term.getLines() - 1;
                            this.scroll();
                        }
                        this.move(cursory, cursorx);
                        Term.addch(32);
                        ++cursorx;
                    }
                    continue;
                }
                if (c == '\n') {
                    if (++cursory < Term.getLines()) continue;
                    if (!this.scroll) {
                        cursory = Term.getLines() - 1;
                        return true;
                    }
                    cursory = Term.getLines() - 1;
                    this.scroll();
                    continue;
                }
                if (c == '\f') {
                    for (n2 = 0; n2 < Term.getLines(); ++n2) {
                        if (++cursory < Term.getLines()) continue;
                        if (!this.scroll) {
                            cursory = Term.getLines() - 1;
                            return true;
                        }
                        cursory = Term.getLines() - 1;
                        this.scroll();
                    }
                    cursorx = 0;
                    continue;
                }
                if (c == '\r') {
                    cursorx = 0;
                    continue;
                }
            }
            if (cursorx >= Term.getColumns()) {
                if (this.clip) {
                    cursorx = Term.getColumns() - 1;
                    return true;
                }
                cursorx = 0;
                ++cursory;
            }
            if (cursory >= Term.getLines()) {
                if (!this.scroll) {
                    cursory = Term.getLines() - 1;
                    return true;
                }
                cursory = Term.getLines() - 1;
                this.scroll();
            }
            this.move(cursory, cursorx);
            if (CursesHandler.isPrintable(c)) {
                Term.addch(c);
            } else {
                Term.addch(32);
            }
            ++cursorx;
        }
        return true;
    }

    @Override
    public boolean println(String string2) {
        this.print(string2);
        if (cursory + 1 >= Term.getLines()) {
            this.scroll();
            this.move(Term.getLines() - 1, 0);
            return true;
        }
        this.move(cursory + 1, 0);
        return true;
    }

    @Override
    public void clrtoeol() {
        if (Term == null) {
            return;
        }
        Term.clrtoeol();
    }

    @Override
    public void clrtobot() {
        if (Term == null) {
            return;
        }
        Term.clrtobot();
    }

    @Override
    public void beep() {
        if (Term == null) {
            return;
        }
        Term.beep();
    }

    @Override
    public void setScrollable(boolean bl) {
        if (Term == null) {
            return;
        }
        this.scroll = bl;
        Term.scrollok(bl);
    }

    private void blinkMode(boolean bl) {
        if (bl) {
            Term.attron(524288);
        } else {
            Term.attroff(524288);
        }
    }

    private void underlineMode(boolean bl) {
        if (bl) {
            Term.attron(131072);
        } else {
            Term.attroff(131072);
        }
    }

    private void reverseMode(boolean bl) {
        if (bl) {
            Term.attron(262144);
        } else {
            Term.attroff(262144);
        }
    }

    private void highlightMode(boolean bl) {
        if (bl) {
            Term.attron(0x200000);
        } else {
            Term.attroff(0x200000);
        }
    }

    private void lowlightMode(boolean bl) {
        if (bl) {
            Term.attron(0x100000);
        } else {
            Term.attroff(0x100000);
        }
    }

    @Override
    public int getLines() {
        if (Term == null) {
            return -1;
        }
        return Term.getLines();
    }

    @Override
    public int getColumns() {
        if (Term == null) {
            return -1;
        }
        return Term.getColumns();
    }

    @Override
    public void setAttributes(int n, int n2, int n3) {
        if (Term == null) {
            return;
        }
        this.realAttr = n;
        if ((n & 0x2000) != 0) {
            this.underlineMode(true);
        } else {
            this.underlineMode(false);
        }
        if ((n & 0x1000) != 0) {
            this.reverseMode(true);
        } else {
            this.reverseMode(false);
        }
        if ((n & 0x400) != 0) {
            this.highlightMode(true);
        } else {
            this.highlightMode(false);
        }
        if ((n & 0x800) != 0) {
            this.lowlightMode(true);
        } else {
            this.lowlightMode(false);
        }
        if ((n & 0x80) != 0) {
            this.blinkMode(true);
        } else {
            this.blinkMode(false);
        }
        if (n2 != -1 && n3 != -1) {
            Term.setColorPair(this.mapCursesColor(n2), this.mapCursesColor(n3));
        }
    }

    private int mapCursesColor(int n) {
        int n2 = n;
        switch (n) {
            case 1: {
                n2 = 4;
                break;
            }
            case 4: {
                n2 = 1;
            }
        }
        return n2;
    }

    @Override
    public void clearAttributes() {
        if (Term == null) {
            return;
        }
        this.realAttr = 0;
        this.underlineMode(false);
        this.reverseMode(false);
        this.highlightMode(false);
        this.lowlightMode(false);
        this.blinkMode(false);
    }

    @Override
    public int getAttributes() {
        if (Term == null) {
            return 0;
        }
        return this.realAttr;
    }

    @Override
    public int getFG() {
        return -1;
    }

    @Override
    public int getBG() {
        return -1;
    }

    @Override
    public boolean setDefaultColors(int n, int n2) {
        return Term == null ? true : Term.setColorPair(n, n2);
    }

    @Override
    public boolean setDefaultColors(Color color2, Color color3) {
        return true;
    }

    @Override
    public boolean setScreenResolution(int n, int n2) {
        return false;
    }

    @Override
    public boolean setFontSize(int n) {
        return false;
    }

    @Override
    public void showCursor() {
    }

    @Override
    public void hideCursor() {
    }

    @Override
    public int getCursorX() {
        return cursorx;
    }

    @Override
    public int getCursorY() {
        return cursory;
    }

    private boolean putChar(char c) {
        if (debugMode) {
            CursesHandler.debug("Called putChar(" + c + ")");
        }
        if (cursorx >= Term.getColumns() || cursory >= Term.getLines()) {
            return false;
        }
        if (!CursesHandler.isPrintable(c)) {
            c = (char)32;
        }
        Term.addch(c);
        return true;
    }

    private void setCursorType(int n) {
    }

    private static final String makePrintable(String string2) {
        int n = string2.length();
        StringBuffer stringBuffer = new StringBuffer(string2);
        for (int i = 0; i < n; ++i) {
            if (CursesHandler.isPrintable(stringBuffer.charAt(i))) continue;
            stringBuffer.setCharAt(i, ' ');
        }
        return stringBuffer.toString();
    }

    @Override
    public KeyValue getChar() {
        Keyboard.clearBuffer();
        return Keyboard.getChar();
    }

    @Override
    public void setSecureChar(char c) {
        this.secureChar = c;
        this.secureCharSet = true;
    }

    @Override
    public char getSecureChar() {
        if (this.secureCharSet) {
            return this.secureChar;
        }
        String string2 = Utilities.getParameter("SECURE-CHAR");
        if (string2 == null || string2.length() != 1) {
            return '*';
        }
        return string2.charAt(0);
    }

    @Override
    public String getString(String string2, boolean bl, boolean bl2, KeyValue[] keyValueArray, int n, boolean bl3, char n2, String string3, boolean bl4, String string4) {
        if (Term == null) {
            return null;
        }
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        this.dataModified = false;
        this.showCursor();
        this.terminator = null;
        this.exitKey = null;
        Keyboard.clearBuffer();
        string2 = CursesHandler.makePrintable(string2);
        int n3 = this.getCursorY();
        int n4 = this.getCursorX();
        if (debugMode) {
            CursesHandler.debug("cx=" + n4 + ", cy=" + n3);
        }
        this.move(n3, n4);
        this.refresh();
        int n5 = n4 - n;
        int n6 = n5 + (string2.length() - 1);
        if (n6 >= Term.getColumns()) {
            n6 = Term.getColumns() - 1;
            string2 = string2.substring(0, n6 - n5 + 1);
        }
        StringBuffer stringBuffer = new StringBuffer(string2);
        KeyValue keyValue = null;
        int n7 = 0;
        int n8 = -1;
        char c = this.getSecureChar();
        while (true) {
            int n9;
            int n10;
            int n11;
            int n12;
            block64: {
                block62: {
                    block63: {
                        if (bl2) {
                            for (n8 = stringBuffer.length() - 1; n8 >= 0 && stringBuffer.charAt(n8) == ' '; --n8) {
                            }
                        }
                        keyValue = Keyboard.getChar();
                        if (debugMode) {
                            CursesHandler.debug("key: " + keyValue);
                        }
                        if ((n7 = keyValue.getKeyModifier()) == 0) break block62;
                        if (n7 != 1) break block63;
                        if (keyValue.getKeyCode() == 9) {
                            this.exitKey = keyValue;
                            this.hideCursor();
                            if (bl3) {
                                this.println("");
                            }
                            return stringBuffer.toString();
                        }
                        break block64;
                    }
                    if (n7 != 2) break block64;
                    if (keyValue.getKeyCode() == 36) {
                        this.exitKey = keyValue;
                        this.hideCursor();
                        if (bl3) {
                            this.println("");
                        }
                        return stringBuffer.toString();
                    }
                    if (keyValue.getKeyCode() == 35) {
                        this.exitKey = keyValue;
                        this.hideCursor();
                        if (bl3) {
                            this.println("");
                        }
                        return stringBuffer.toString();
                    }
                    break block64;
                }
                if (keyValue.getKeyCode() == 155) {
                    boolean bl5 = this.insertMode = !this.insertMode;
                    if (this.insertMode) {
                        this.setCursorType(1);
                        continue;
                    }
                    this.setCursorType(0);
                    continue;
                }
                if (keyValue.getKeyCode() == 9) {
                    this.exitKey = keyValue;
                    this.hideCursor();
                    if (bl3) {
                        this.println("");
                    }
                    return stringBuffer.toString();
                }
                if (keyValue.getKeyCode() == 38) {
                    this.exitKey = keyValue;
                    this.hideCursor();
                    if (bl3) {
                        this.println("");
                    }
                    return stringBuffer.toString();
                }
                if (keyValue.getKeyCode() == 40) {
                    this.exitKey = keyValue;
                    this.hideCursor();
                    if (bl3) {
                        this.println("");
                    }
                    return stringBuffer.toString();
                }
                if (keyValue.getKeyCode() == 36) {
                    n4 = n5;
                    this.move(n3, n4);
                    this.refresh();
                    continue;
                }
                if (keyValue.getKeyCode() == 35) {
                    for (n12 = stringBuffer.length() - 1; n12 > 0 && stringBuffer.charAt(n12) == ' '; --n12) {
                    }
                    if (n12 != 0) {
                        n4 = n5 + n12 + 1;
                        if (n4 > n6) {
                            n4 = n6;
                        }
                    } else {
                        n4 = n5;
                    }
                    this.move(n3, n4);
                    this.refresh();
                    continue;
                }
                if (keyValue.getKeyCode() == 39) {
                    if (n4 < n6) {
                        this.move(n3, ++n4);
                        this.refresh();
                        continue;
                    }
                    if (!bl) continue;
                    this.hideCursor();
                    if (bl3) {
                        this.println("");
                    }
                    return stringBuffer.toString();
                }
                if (keyValue.getKeyCode() == 37) {
                    if (n4 <= n5) continue;
                    this.move(n3, --n4);
                    this.refresh();
                    continue;
                }
                if (keyValue.getKeyCode() == 8) {
                    if (n4 <= n5) continue;
                    n12 = --n4 - n5;
                    n11 = n6 - n5;
                    this.move(n3, n4);
                    for (n10 = n12; n10 < n11; ++n10) {
                        this.move(n3, n10 + n5);
                        n9 = 32;
                        n9 = !bl2 ? (int)stringBuffer.charAt(n10 + 1) : (n10 + 1 <= n8 ? (int)c : 32);
                        if (n9 == 32) {
                            n9 = n2;
                        }
                        this.putChar((char)n9);
                        stringBuffer.setCharAt(n10, stringBuffer.charAt(n10 + '\u0001'));
                    }
                    this.move(n3, n11 + n5);
                    this.putChar((char)n2);
                    this.move(n3, n4);
                    if (n11 >= 0) {
                        stringBuffer.setCharAt(n11, ' ');
                    }
                    this.dataModified = true;
                    this.refresh();
                    continue;
                }
                if (keyValue.getKeyCode() == 127) {
                    if (debugMode) {
                        CursesHandler.debug("hit del");
                    }
                    n12 = n4 - n5;
                    n11 = n6 - n5;
                    for (n10 = n12; n10 < n11; ++n10) {
                        this.move(n3, n10 + n5);
                        n9 = 32;
                        n9 = !bl2 ? (int)stringBuffer.charAt(n10 + 1) : (n10 + 1 <= n8 ? (int)c : 32);
                        if (n9 == 32) {
                            n9 = n2;
                        }
                        this.putChar((char)n9);
                        stringBuffer.setCharAt(n10, stringBuffer.charAt(n10 + '\u0001'));
                    }
                    this.move(n3, n11 + n5);
                    this.putChar((char)n2);
                    this.move(n3, n4);
                    if (n11 >= 0) {
                        stringBuffer.setCharAt(n11, ' ');
                    }
                    this.dataModified = true;
                    this.refresh();
                    continue;
                }
            }
            if (debugMode) {
                CursesHandler.debug("char hit..");
            }
            if (keyValueArray != null) {
                if (debugMode) {
                    CursesHandler.debug("term length: " + keyValueArray.length);
                }
                for (n12 = 0; n12 < keyValueArray.length; ++n12) {
                    if (debugMode && keyValueArray[n12] == null) {
                        CursesHandler.debug("PROBLEM!");
                    }
                    if (!keyValue.equals(keyValueArray[n12])) continue;
                    this.terminator = keyValue;
                    this.hideCursor();
                    if (bl3) {
                        this.println("");
                    }
                    return stringBuffer.toString();
                }
            }
            if (debugMode) {
                CursesHandler.debug("getting keychar..");
            }
            n12 = keyValue.getKeyChar();
            if (debugMode) {
                CursesHandler.debug("keychar=" + (char)n12);
            }
            if (n12 == 65535 || n12 == 65535 || !CursesHandler.isPrintable((char)n12)) continue;
            if (bl4) {
                n12 = Character.toUpperCase((char)n12);
            }
            if (string3 != null && string3.indexOf(n12) < 0) {
                this.beep();
                continue;
            }
            if (debugMode) {
                CursesHandler.debug("Calling putChar(c)");
            }
            if (this.insertMode) {
                n11 = n4 - n5;
                n10 = n6 - n5;
                if (n10 >= 0 && stringBuffer.charAt(n10) != ' ') continue;
                for (n9 = n10; n9 > n11; --n9) {
                    this.move(n3, n9 + n5);
                    if (!bl2) {
                        this.putChar(stringBuffer.charAt(n9 - 1));
                    } else if (n9 - 1 <= n8) {
                        this.putChar(c);
                    } else {
                        this.putChar(' ');
                    }
                    stringBuffer.setCharAt(n9, stringBuffer.charAt(n9 - 1));
                }
                this.move(n3, n4);
            }
            if (bl2) {
                this.putChar(c);
            } else {
                this.putChar((char)n12);
            }
            n11 = n4 - n5;
            stringBuffer.setCharAt(n11, (char)n12);
            this.dataModified = true;
            this.refresh();
            if (n4 < n6) {
                this.move(n3, ++n4);
                continue;
            }
            if (bl) break;
        }
        this.hideCursor();
        if (bl3) {
            this.println("");
        }
        return stringBuffer.toString();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void waitForTerminatorKey(KeyValue[] var1_1) {
        if (CursesHandler.Term == null) {
            return;
        }
        this.terminator = null;
        this.exitKey = null;
        CursesHandler.Keyboard.clearBuffer();
        var2_2 = null;
        block0: while (true) {
            var2_2 = CursesHandler.Keyboard.getChar();
            if (var1_1 == null) continue;
            var3_3 = 0;
            while (true) {
                if (var3_3 < var1_1.length) ** break;
                continue block0;
                if (var2_2.equals(var1_1[var3_3])) {
                    this.terminator = var2_2;
                    return;
                }
                ++var3_3;
            }
            break;
        }
    }

    private void cursorback() {
        --this.cx;
        if (this.cx < 0) {
            this.cx = Term.getColumns() - 1;
            --this.cy;
        }
        this.move(this.cy, this.cx);
    }

    private void cursorforward() {
        ++this.cx;
        if (this.cx >= Term.getColumns()) {
            this.cx = 0;
            ++this.cy;
            if (this.cy >= Term.getLines()) {
                this.cy = Term.getLines() - 1;
                this.scroll();
                --this.starty;
                this.startsc -= Term.getColumns();
                if (this.starty < 0) {
                    this.startpos += Term.getColumns() - this.startx;
                    this.startsc = 0;
                    this.startx = 0;
                    this.starty = 0;
                }
            }
        }
        this.move(this.cy, this.cx);
    }

    private void cursorsave() {
        this.sx = this.cx;
        this.sy = this.cy;
    }

    private void cursorrestore() {
        this.cx = this.sx;
        this.cy = this.sy;
        this.move(this.cy, this.cx);
    }

    private void cursorupdate() {
    }

    private void updateChar(int n, char c) {
        this.putChar(c);
        if (n == this.text.length()) {
            this.text.append(c);
            ++this.endpos;
        } else {
            this.text.setCharAt(n, c);
        }
    }

    private void cursormove(int n) {
        this.cy = (int)((float)(n - this.startpos + this.startsc) / (float)Term.getColumns());
        this.cx = n - this.startpos + this.startsc - this.cy * Term.getColumns();
        if (this.cy >= Term.getLines()) {
            this.cy = Term.getLines() - 1;
            this.scroll();
            --this.starty;
            this.startsc -= Term.getColumns();
            if (this.starty < 0) {
                this.startpos += Term.getColumns() - this.startx;
                this.startsc = 0;
                this.startx = 0;
                this.starty = 0;
            }
        }
        this.move(this.cy, this.cx);
    }

    @Override
    public String getString() {
        this.dataModified = false;
        this.showCursor();
        this.terminator = null;
        this.exitKey = null;
        Keyboard.clearBuffer();
        this.cy = this.getCursorY();
        this.cx = this.getCursorX();
        if (debugMode) {
            CursesHandler.debug("cx=" + this.cx + ", cy=" + this.cy);
        }
        this.move(this.cy, this.cx);
        this.startpos = 0;
        this.startx = this.cx;
        this.starty = this.cy;
        this.startsc = this.startx + this.starty * Term.getColumns();
        this.curpos = 0;
        this.endpos = -1;
        this.text = new StringBuffer();
        KeyValue keyValue = null;
        int n = 0;
        block8: while (true) {
            int n2;
            char c;
            keyValue = Keyboard.getChar();
            if (debugMode) {
                CursesHandler.debug("key: " + keyValue);
            }
            if ((c = keyValue.getKeyChar()) == '\r') {
                keyValue.setKeyCode(10);
            } else if (c == '\b') {
                keyValue.setKeyCode(8);
            } else if (c == '\t') {
                keyValue.setKeyCode(9);
            } else if (c == '\u007f') {
                keyValue.setKeyCode(127);
            } else if (c == '\u001b') {
                keyValue.setKeyCode(27);
            }
            n = keyValue.getKeyCode();
            switch (n) {
                case 155: {
                    boolean bl = this.insertMode = !this.insertMode;
                    if (this.insertMode) {
                        this.setCursorType(1);
                        continue block8;
                    }
                    this.setCursorType(0);
                    continue block8;
                }
                case 39: {
                    if (this.curpos > this.endpos) continue block8;
                    ++this.curpos;
                    this.cursorforward();
                    this.cursorupdate();
                    continue block8;
                }
                case 37: {
                    if (this.curpos <= this.startpos) continue block8;
                    --this.curpos;
                    this.cursorback();
                    this.cursorupdate();
                    continue block8;
                }
                case 8: {
                    if (this.curpos <= this.startpos) continue block8;
                    this.cursorback();
                    this.cursorsave();
                    for (n2 = --this.curpos; n2 < this.endpos; ++n2) {
                        this.updateChar(n2, this.text.charAt(n2 + 1));
                        this.cursorforward();
                    }
                    this.updateChar(this.endpos, ' ');
                    --this.endpos;
                    this.text.setLength(this.endpos + 1);
                    this.cursorrestore();
                    this.dataModified = true;
                    this.cursorupdate();
                    continue block8;
                }
                case 127: {
                    if (debugMode) {
                        CursesHandler.debug("hit del");
                    }
                    if (this.curpos > this.endpos) continue block8;
                    this.cursorsave();
                    for (n2 = this.curpos; n2 < this.endpos; ++n2) {
                        this.updateChar(n2, this.text.charAt(n2 + 1));
                        this.cursorforward();
                    }
                    this.updateChar(this.endpos, ' ');
                    --this.endpos;
                    this.text.setLength(this.endpos + 1);
                    this.cursorrestore();
                    this.dataModified = true;
                    this.cursorupdate();
                    continue block8;
                }
                case 33: 
                case 34: 
                case 35: 
                case 36: {
                    continue block8;
                }
            }
            if (debugMode) {
                CursesHandler.debug("char hit..");
            }
            if (n == 10) {
                this.terminator = keyValue;
                this.hideCursor();
                this.println("");
                return this.text.toString();
            }
            if (c == '\uffff' || c == '\uffff' || !CursesHandler.isPrintable(c)) continue;
            if (debugMode) {
                CursesHandler.debug("Calling putChar(c)");
            }
            if (this.insertMode) {
                this.updateChar(this.endpos + 1, ' ');
                this.cursormove(this.endpos);
                for (n2 = this.endpos; n2 > this.curpos; --n2) {
                    this.updateChar(n2, this.text.charAt(n2 - 1));
                    this.cursorback();
                }
            }
            this.updateChar(this.curpos, c);
            ++this.curpos;
            if (debugMode) {
                CursesHandler.debug("curpos=" + this.curpos + "  endpos=" + this.endpos);
            }
            this.cursorforward();
            this.dataModified = true;
            this.cursorupdate();
        }
    }

    @Override
    public KeyValue getTerminator() {
        return this.terminator;
    }

    @Override
    public KeyValue getExitKey() {
        return this.exitKey;
    }

    @Override
    public Container getPanelForWindow() {
        return null;
    }

    @Override
    public void addActionListener(ActionListener actionListener2) {
    }

    @Override
    public void removeActionListener(ActionListener actionListener2) {
    }

    @Override
    public int getCellWidth() {
        return -1;
    }

    @Override
    public void setCellWidth(int n) {
    }

    @Override
    public int getCellHeight() {
        return -1;
    }

    @Override
    public void setCellHeight(int n) {
    }

    @Override
    public Font getFont() {
        return null;
    }

    @Override
    public void setFont(Font font2) {
    }

    @Override
    public void clearScreen() {
        for (int i = 0; i < this.getLines(); ++i) {
            this.move(i, 0);
            this.clrtoeol();
        }
        this.move(0, 0);
        this.forceRefresh();
    }

    @Override
    public void setFG(Color color2) {
    }

    @Override
    public void setBG(Color color2) {
    }

    @Override
    public void setFG(int n) {
    }

    @Override
    public void setBG(int n) {
    }

    @Override
    public int getDefaultFG() {
        return -1;
    }

    @Override
    public int getDefaultBG() {
        return -1;
    }

    @Override
    public void setGetStringTimeout(long l) {
    }

    @Override
    public void forceGetStringTimeout() {
    }

    @Override
    public boolean isGetStringTimeout() {
        return false;
    }

    class keyboard {
        public keyboard(int n) {
        }

        public void clearBuffer() {
        }

        public KeyValue getChar() {
            KeyValue keyValue = null;
            block185: while (true) {
                keyValue = new KeyValue();
                char c = (char)Term.getch();
                if (debugMode) {
                    CursesHandler.debug("key typed: " + c + "  value=" + c);
                }
                if (c <= '\u00ff') {
                    switch (c) {
                        case '\r': {
                            keyValue.setKeyChar(c);
                            keyValue.setKeyCode(10);
                            break;
                        }
                        case '\b': {
                            keyValue.setKeyCode(8);
                            break;
                        }
                        case '\t': {
                            keyValue.setKeyCode(9);
                            break;
                        }
                        case '\u007f': {
                            keyValue.setKeyCode(127);
                            break;
                        }
                        case '\u001b': {
                            keyValue.setKeyCode(27);
                            break;
                        }
                        default: {
                            if (!CursesHandler.isPrintable(c)) continue block185;
                            keyValue.setKeyChar(c);
                            break;
                        }
                    }
                    break;
                }
                switch (c) {
                    case '\u0157': {
                        keyValue.setKeyCode(10);
                        keyValue.setKeyChar('\r');
                        break block185;
                    }
                    case '\u0103': {
                        keyValue.setKeyCode(38);
                        break block185;
                    }
                    case '\u0102': {
                        keyValue.setKeyCode(40);
                        break block185;
                    }
                    case '\u0104': {
                        keyValue.setKeyCode(37);
                        break block185;
                    }
                    case '\u0105': {
                        keyValue.setKeyCode(39);
                        break block185;
                    }
                    case '\u0106': {
                        keyValue.setKeyCode(36);
                        break block185;
                    }
                    case '\u0168': {
                        keyValue.setKeyCode(35);
                        break block185;
                    }
                    case '\u0107': {
                        keyValue.setKeyCode(8);
                        break block185;
                    }
                    case '\u014a': {
                        keyValue.setKeyCode(127);
                        break block185;
                    }
                    case '\u014b': {
                        keyValue.setKeyCode(155);
                        break block185;
                    }
                    case '\u014c': {
                        keyValue.setKeyCode(155);
                        break block185;
                    }
                    case '\u0161': {
                        keyValue.setKeyCode(9);
                        keyValue.setKeyModifier(1);
                        break block185;
                    }
                    case '\u0182': {
                        keyValue.setKeyCode(35);
                        keyValue.setKeyModifier(1);
                        break block185;
                    }
                    case '\u0187': {
                        keyValue.setKeyCode(36);
                        keyValue.setKeyModifier(1);
                        break block185;
                    }
                    case '\u0189': {
                        keyValue.setKeyCode(37);
                        keyValue.setKeyModifier(1);
                        break block185;
                    }
                    case '\u0192': {
                        keyValue.setKeyCode(39);
                        keyValue.setKeyModifier(1);
                        break block185;
                    }
                    case '\u0109': {
                        keyValue.setKeyCode(112);
                        break block185;
                    }
                    case '\u010a': {
                        keyValue.setKeyCode(113);
                        break block185;
                    }
                    case '\u010b': {
                        keyValue.setKeyCode(114);
                        break block185;
                    }
                    case '\u010c': {
                        keyValue.setKeyCode(115);
                        break block185;
                    }
                    case '\u010d': {
                        keyValue.setKeyCode(116);
                        break block185;
                    }
                    case '\u010e': {
                        keyValue.setKeyCode(117);
                        break block185;
                    }
                    case '\u010f': {
                        keyValue.setKeyCode(118);
                        break block185;
                    }
                    case '\u0110': {
                        keyValue.setKeyCode(119);
                        break block185;
                    }
                    case '\u0111': {
                        keyValue.setKeyCode(120);
                        break block185;
                    }
                    case '\u0112': {
                        keyValue.setKeyCode(121);
                        break block185;
                    }
                    case '\u0113': {
                        keyValue.setKeyCode(122);
                        break block185;
                    }
                    case '\u0114': {
                        keyValue.setKeyCode(123);
                        break block185;
                    }
                    case '\u0115': {
                        keyValue.setKeyCode(112);
                        keyValue.setKeyModifier(1);
                        break block185;
                    }
                    case '\u0116': {
                        keyValue.setKeyCode(113);
                        keyValue.setKeyModifier(1);
                        break block185;
                    }
                    case '\u0117': {
                        keyValue.setKeyCode(114);
                        keyValue.setKeyModifier(1);
                        break block185;
                    }
                    case '\u0118': {
                        keyValue.setKeyCode(115);
                        keyValue.setKeyModifier(1);
                        break block185;
                    }
                    case '\u0119': {
                        keyValue.setKeyCode(116);
                        keyValue.setKeyModifier(1);
                        break block185;
                    }
                    case '\u011a': {
                        keyValue.setKeyCode(117);
                        keyValue.setKeyModifier(1);
                        break block185;
                    }
                    case '\u011b': {
                        keyValue.setKeyCode(118);
                        keyValue.setKeyModifier(1);
                        break block185;
                    }
                    case '\u011c': {
                        keyValue.setKeyCode(119);
                        keyValue.setKeyModifier(1);
                        break block185;
                    }
                    case '\u011d': {
                        keyValue.setKeyCode(120);
                        keyValue.setKeyModifier(1);
                        break block185;
                    }
                    case '\u011e': {
                        keyValue.setKeyCode(121);
                        keyValue.setKeyModifier(1);
                        break block185;
                    }
                    case '\u011f': {
                        keyValue.setKeyCode(122);
                        keyValue.setKeyModifier(1);
                        break block185;
                    }
                    case '\u0120': {
                        keyValue.setKeyCode(123);
                        keyValue.setKeyModifier(1);
                        break block185;
                    }
                    case '\u0121': {
                        keyValue.setKeyCode(112);
                        keyValue.setKeyModifier(2);
                        break block185;
                    }
                    case '\u0122': {
                        keyValue.setKeyCode(113);
                        keyValue.setKeyModifier(2);
                        break block185;
                    }
                    case '\u0123': {
                        keyValue.setKeyCode(114);
                        keyValue.setKeyModifier(2);
                        break block185;
                    }
                    case '\u0124': {
                        keyValue.setKeyCode(115);
                        keyValue.setKeyModifier(2);
                        break block185;
                    }
                    case '\u0125': {
                        keyValue.setKeyCode(116);
                        keyValue.setKeyModifier(2);
                        break block185;
                    }
                    case '\u0126': {
                        keyValue.setKeyCode(117);
                        keyValue.setKeyModifier(2);
                        break block185;
                    }
                    case '\u0127': {
                        keyValue.setKeyCode(118);
                        keyValue.setKeyModifier(2);
                        break block185;
                    }
                    case '\u0128': {
                        keyValue.setKeyCode(119);
                        keyValue.setKeyModifier(2);
                        break block185;
                    }
                    case '\u0129': {
                        keyValue.setKeyCode(120);
                        keyValue.setKeyModifier(2);
                        break block185;
                    }
                    case '\u012a': {
                        keyValue.setKeyCode(121);
                        keyValue.setKeyModifier(2);
                        break block185;
                    }
                    case '\u012b': {
                        keyValue.setKeyCode(122);
                        keyValue.setKeyModifier(2);
                        break block185;
                    }
                    case '\u012c': {
                        keyValue.setKeyCode(123);
                        keyValue.setKeyModifier(2);
                        break block185;
                    }
                    case '\u012d': {
                        keyValue.setKeyCode(112);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u012e': {
                        keyValue.setKeyCode(113);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u012f': {
                        keyValue.setKeyCode(114);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u0130': {
                        keyValue.setKeyCode(115);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u0131': {
                        keyValue.setKeyCode(116);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u0132': {
                        keyValue.setKeyCode(117);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u0133': {
                        keyValue.setKeyCode(118);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u0134': {
                        keyValue.setKeyCode(119);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u0135': {
                        keyValue.setKeyCode(120);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u0136': {
                        keyValue.setKeyCode(121);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u0137': {
                        keyValue.setKeyCode(122);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u0138': {
                        keyValue.setKeyCode(123);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u015a': {
                        keyValue.setKeyCode(154);
                        break block185;
                    }
                    case '\u018f': {
                        keyValue.setKeyCode(154);
                        keyValue.setKeyModifier(1);
                        break block185;
                    }
                    case '\u0163': {
                        keyValue.setKeyCode(3);
                        break block185;
                    }
                    case '\u016b': {
                        keyValue.setKeyCode(156);
                        break block185;
                    }
                    case '\u0186': {
                        keyValue.setKeyCode(156);
                        keyValue.setKeyModifier(1);
                        break block185;
                    }
                    case '\u014d': {
                        keyValue.setKeyCode(12);
                        break block185;
                    }
                    case '\u0198': {
                        keyValue.setKeyCode(90);
                        keyValue.setKeyModifier(2);
                        break block185;
                    }
                    case '\u0196': {
                        keyValue.setKeyCode(90);
                        keyValue.setKeyModifier(3);
                        break block185;
                    }
                    case '\u016a': {
                        keyValue.setKeyCode(70);
                        keyValue.setKeyModifier(2);
                        break block185;
                    }
                    case '\u0185': {
                        keyValue.setKeyCode(70);
                        keyValue.setKeyModifier(3);
                        break block185;
                    }
                    case '\u0173': {
                        keyValue.setKeyCode(89);
                        keyValue.setKeyModifier(2);
                        break block185;
                    }
                    case '\u0190': {
                        keyValue.setKeyCode(89);
                        keyValue.setKeyModifier(3);
                        break block185;
                    }
                    case '\u0179': {
                        keyValue.setKeyCode(83);
                        keyValue.setKeyModifier(2);
                        break block185;
                    }
                    case '\u0194': {
                        keyValue.setKeyCode(83);
                        keyValue.setKeyModifier(3);
                        break block185;
                    }
                    case '\u017f': {
                        keyValue.setKeyCode(127);
                        break block185;
                    }
                    case '\u01a1': {
                        keyValue.setKeyCode(65);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u01a2': {
                        keyValue.setKeyCode(66);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u01a3': {
                        keyValue.setKeyCode(67);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u01a4': {
                        keyValue.setKeyCode(68);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u01a5': {
                        keyValue.setKeyCode(69);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u01a6': {
                        keyValue.setKeyCode(70);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u01a7': {
                        keyValue.setKeyCode(71);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u01a8': {
                        keyValue.setKeyCode(72);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u01a9': {
                        keyValue.setKeyCode(73);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u01aa': {
                        keyValue.setKeyCode(74);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u01ab': {
                        keyValue.setKeyCode(75);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u01ac': {
                        keyValue.setKeyCode(76);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u01ad': {
                        keyValue.setKeyCode(77);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u01ae': {
                        keyValue.setKeyCode(78);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u01af': {
                        keyValue.setKeyCode(79);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u01b0': {
                        keyValue.setKeyCode(80);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u01b1': {
                        keyValue.setKeyCode(81);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u01b2': {
                        keyValue.setKeyCode(82);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u01b3': {
                        keyValue.setKeyCode(83);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u01b4': {
                        keyValue.setKeyCode(84);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u01b5': {
                        keyValue.setKeyCode(85);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u01b6': {
                        keyValue.setKeyCode(86);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u01b7': {
                        keyValue.setKeyCode(87);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u01b8': {
                        keyValue.setKeyCode(88);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u01b9': {
                        keyValue.setKeyCode(89);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u01ba': {
                        keyValue.setKeyCode(90);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u0225': {
                        keyValue.setKeyCode(48);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u0226': {
                        keyValue.setKeyCode(49);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u0227': {
                        keyValue.setKeyCode(50);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u0228': {
                        keyValue.setKeyCode(51);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u0229': {
                        keyValue.setKeyCode(52);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u022a': {
                        keyValue.setKeyCode(53);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u022b': {
                        keyValue.setKeyCode(54);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u022c': {
                        keyValue.setKeyCode(55);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u022d': {
                        keyValue.setKeyCode(56);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u022e': {
                        keyValue.setKeyCode(57);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u01bb': {
                        keyValue.setKeyCode(37);
                        keyValue.setKeyModifier(2);
                        break block185;
                    }
                    case '\u01bc': {
                        keyValue.setKeyCode(39);
                        keyValue.setKeyModifier(2);
                        break block185;
                    }
                    case '\u01bd': {
                        keyValue.setKeyCode(33);
                        keyValue.setKeyModifier(2);
                        break block185;
                    }
                    case '\u01be': {
                        keyValue.setKeyCode(34);
                        keyValue.setKeyModifier(2);
                        break block185;
                    }
                    case '\u01bf': {
                        keyValue.setKeyCode(36);
                        keyValue.setKeyModifier(2);
                        break block185;
                    }
                    case '\u01c0': {
                        keyValue.setKeyCode(35);
                        keyValue.setKeyModifier(2);
                        break block185;
                    }
                    case '\u01fa': {
                        keyValue.setKeyCode(96);
                        keyValue.setKeyModifier(2);
                        break block185;
                    }
                    case '\u01fb': {
                        keyValue.setKeyCode(96);
                        keyValue.setKeyModifier(2);
                        break block185;
                    }
                    case '\u01fc': {
                        keyValue.setKeyCode(97);
                        keyValue.setKeyModifier(2);
                        break block185;
                    }
                    case '\u01fd': {
                        keyValue.setKeyCode(98);
                        keyValue.setKeyModifier(2);
                        break block185;
                    }
                    case '\u01fe': {
                        keyValue.setKeyCode(99);
                        keyValue.setKeyModifier(2);
                        break block185;
                    }
                    case '\u01ff': {
                        keyValue.setKeyCode(100);
                        keyValue.setKeyModifier(2);
                        break block185;
                    }
                    case '\u0200': {
                        keyValue.setKeyCode(101);
                        keyValue.setKeyModifier(2);
                        break block185;
                    }
                    case '\u0201': {
                        keyValue.setKeyCode(102);
                        keyValue.setKeyModifier(2);
                        break block185;
                    }
                    case '\u0202': {
                        keyValue.setKeyCode(103);
                        keyValue.setKeyModifier(2);
                        break block185;
                    }
                    case '\u0203': {
                        keyValue.setKeyCode(104);
                        keyValue.setKeyModifier(2);
                        break block185;
                    }
                    case '\u0204': {
                        keyValue.setKeyCode(105);
                        keyValue.setKeyModifier(2);
                        break block185;
                    }
                    case '\u0205': {
                        keyValue.setKeyCode(96);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u0206': {
                        keyValue.setKeyCode(97);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u0207': {
                        keyValue.setKeyCode(98);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u0208': {
                        keyValue.setKeyCode(99);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u0209': {
                        keyValue.setKeyCode(100);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u020a': {
                        keyValue.setKeyCode(101);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u020b': {
                        keyValue.setKeyCode(102);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u020c': {
                        keyValue.setKeyCode(103);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u020d': {
                        keyValue.setKeyCode(104);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u020e': {
                        keyValue.setKeyCode(105);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u0223': {
                        keyValue.setKeyCode(38);
                        keyValue.setKeyModifier(1);
                        break block185;
                    }
                    case '\u0224': {
                        keyValue.setKeyCode(40);
                        keyValue.setKeyModifier(1);
                        break block185;
                    }
                    case '\u017b': {
                        keyValue.setKeyCode(3);
                        keyValue.setKeyModifier(1);
                        break block185;
                    }
                    case '\u0170': {
                        keyValue.setKeyCode(79);
                        keyValue.setKeyModifier(2);
                        break block185;
                    }
                    case '\u0166': {
                        keyValue.setKeyCode(67);
                        keyValue.setKeyModifier(2);
                        break block185;
                    }
                    case '\u017d': {
                        keyValue.setKeyCode(67);
                        keyValue.setKeyModifier(3);
                        break block185;
                    }
                    case '\u016f': {
                        keyValue.setKeyCode(9);
                        break block185;
                    }
                    case '\u018c': {
                        keyValue.setKeyCode(35);
                        keyValue.setKeyModifier(1);
                        break block185;
                    }
                    case '\u0172': {
                        keyValue.setKeyCode(9);
                        keyValue.setKeyModifier(1);
                        break block185;
                    }
                    case '\u018e': {
                        keyValue.setKeyCode(36);
                        keyValue.setKeyModifier(1);
                        break block185;
                    }
                    case '\u01dd': {
                        keyValue.setKeyCode(155);
                        keyValue.setKeyModifier(2);
                        break block185;
                    }
                    case '\u01de': {
                        keyValue.setKeyCode(127);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u01df': {
                        keyValue.setKeyCode(155);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u01e0': {
                        keyValue.setKeyCode(38);
                        keyValue.setKeyModifier(2);
                        break block185;
                    }
                    case '\u01e1': {
                        keyValue.setKeyCode(40);
                        keyValue.setKeyModifier(2);
                        break block185;
                    }
                    case '\u01e2': {
                        keyValue.setKeyCode(9);
                        keyValue.setKeyModifier(2);
                        break block185;
                    }
                    case '\u01e3': {
                        keyValue.setKeyCode(9);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u01e4': {
                        keyValue.setKeyCode(45);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u01e5': {
                        keyValue.setKeyCode(61);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u01e6': {
                        keyValue.setKeyCode(36);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u01e7': {
                        keyValue.setKeyCode(33);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u01e8': {
                        keyValue.setKeyCode(34);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u01e9': {
                        keyValue.setKeyCode(35);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u01ea': {
                        keyValue.setKeyCode(38);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u01eb': {
                        keyValue.setKeyCode(40);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u01ec': {
                        keyValue.setKeyCode(39);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u01ed': {
                        keyValue.setKeyCode(37);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u01ee': {
                        keyValue.setKeyCode(10);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u01ef': {
                        keyValue.setKeyCode(27);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u01f1': {
                        keyValue.setKeyCode(91);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u01f2': {
                        keyValue.setKeyCode(93);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u01f3': {
                        keyValue.setKeyCode(59);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u01f5': {
                        keyValue.setKeyCode(44);
                        keyValue.setKeyModifier(8);
                        break block185;
                    }
                    case '\u0211': {
                        keyValue.setKeyCode(10);
                        keyValue.setKeyModifier(2);
                        break block185;
                    }
                    default: {
                        continue block185;
                    }
                }
                break;
            }
            return keyValue;
        }
    }
}

